;MEMDISKA/ASM - Version 6.2.0 - 11/01/83
	SUBTTL	<'MEMDISKA - Installation'>
	PAGE
; 02/18/83 - Changes per Doug
; 02/28/83 - Fixed Verify Error to include Bank # &
;	   - location of faulty RAM.
; 05/06/83 - Added HIGH$ before installation storage
;	   - area in MemDISK driver header, & corrected
;	   - method of restoring HIGH$ on disable. DK
; 10/18/83 - Reclaim high memory if premature abort.
; 10/25/83 - Clear out driver when disabling if
;	   - it was the last driver installed. DK
;
;***
;	INSTMEM - Install MemDISK
;***
;
INSTMEM	PUSH	AF		;Save # cyls
	PUSH	BC		;Save Bank #
;
;*=*=* Is there a MemDISK driver trapped ? *=*=*
;
	LD	DE,MD$		;"$MD"
	@@GTMOD			;MemDISK in ?
	JR	NZ,NOT__IN	;no
;
;*=*=* There is a driver trapped - use that area *=*=*
;
	LD	(OLDRVR+1),HL	;save old driver addr
	EX	DE,HL		;pt DE => Destination
	LD	HL,RE_USE	;set re-use flag
	INC	(HL)		;
	LD	HL,LENGTH-1	;Set HL = last used
	ADD	HL,DE		; address of driver.
	LD	(OLDHIGH),HL	;xfer into driver
	JR	DO_INST		;install driver
;
;*=*=* Driver is not in memory - is there room ? *=*=*
;
NOT__IN	CALL	GTDRV		;p/u next avail drv addr
	LD	(OLDRVR+1),DE	;save it
	LD	HL,LENGTH-1	;HL = length of driver
	LD	BC,HIDRVR	;BC = 1 + highest avail
	ADD	HL,DE		;HL => Last used by Mem
	LD	(OLDHIGH),HL
	INC	HL
	OR	A		;
	PUSH	HL		;Will MemDisk fit ?
	SBC	HL,BC		;
	POP	HL		;
	JR	C,OKDUDE	;yes - let's do it
;
;*=*=* Insufficient Driver space *=*=*
;
	LD	HL,NOMEM	;alter exit message
	LD	($NOT+1),HL	;
	JR	OLDRVR		;reclaim hi mem
;				;if bank 0
;
;*=*=* Save next avail mem addr & set Memdisk bit *=*=*
;
OKDUDE	LD	(IX),H		;Stuff msb
	LD	(IX-1),L	;stuff lsb
;
;*=*=* Install MemDISK driver & set up DCT *=*=*
;
DO_INST	CALL	INSTDRV		;Relocate, install driver
	POP	BC		;C = Bank # requests
	POP	AF		;A = # cylinders
	CALL	SETDCT		;set up DCT
;
;*=*=* Prompt for Format *=*=*
;
	CALL	FORMTIT		;Format this ?
	JR	Z,DOFORM1	;yes - do it
;
;*=*=* Format = No, Is there a MemDISK here ? *=*=*
;
MEMIN1	LD	A,$-$		;0 = not active
	OR	A		;
	JR	NZ,SHOWINU	;MemDisk previously in
;
;*=*=* Abort installation - stuff X'C9' in DCT *=*=*
;
OLDRVR	LD	HL,$-$		;p/u original driver addr
	LD	A,(RE_USE)	;Have we re-used driver
	OR	A		; area that was trapped ?
	JR	NZ,DONTRES	;yes - don't reset KIDCB.
KIDCB$	LD	($-$),HL	;stuff into KIDCB$
DONTRES	LD	HL,(SAVEDCT)	;p/u DCT address
	LD	(HL),0C9H	;disable it
	RES	4,(IY+DFLAG$)	;reset MemDISK bit
	LD	A,(SETBANK+1)	;pu bank request
	OR	A
	JR	NZ,$NOT		;don't reset high
	LD 	HL,(MDDATA+2)	;pu old high$
	LD	B,A
	@@HIGH$			;reset high$
$NOT	JP	NOTACT		;not in
;
;=== Format mem, init GAT & HIT, & BOOT-DIR entries *=*=*
;
DOFORM1	CALL	FORMAT		;format
	CALL	WRBOOT		;Write BOOT/SYS
	CALL	WRGAT		;initialize GAT
	CALL	WRHIT		;initialize HIT
	CALL	WRENT		;put DIR & BOOT entries
SHOWINU	CALL	SETBANK		;Show Banks in use
	SET	4,(IY+DFLAG$)	;set MemDisk flag
	LD	HL,INSTALD	;MemDisk Installed
	@@LOGOT			;
	RET			;done - GO TO EXIT
;
;
;***
;	WRBOOT - Write BOOT/SYS information
;***
;
WRBOOT	XOR	A		;Fill byte
	LD	HL,IOBUFF	;HL => I/O buffer
;
;*=*=* Fill BOOT/SYS with Zeroes *=*=*
;
FILBUF	LD	(HL),A		;stuff in byte
	INC	L		;one sector to
	JR	NZ,FILBUF	;fill
;
;*=*=* Write # of Sectors in BOOT *=*=*
;
	LD	D,A		;Cylinder 0
	LD	E,A		;Sector 0
BTSECS	LD	B,6		;p/u Sec cnt - 5,6, or 18
BTLP	CALL	WRSEC		;Write sector
	INC	E		;bump
	DJNZ	BTLP		;
;
;*=*=* Write Directory Cylinder byte in Sector Zero *=*=*
;
	LD	L,2		;Byte 2
	LD	(HL),1		;Directory cyl = 1
;
;*=*=* Write Sector 0 of Cylinder 0 *=*=*
;
	LD	DE,0		;Cylinder 0, Sector 0
	CALL	WRSEC		;Write Sector
;
;*=*=* Make a duplicate of sector 0 in sector 1 *=*=*
;
	INC	E		;sector 1
	CALL	WRSEC		;write sector
;
;*=*=* Write C/R in Auto Buffer in Sector 2 *=*=*
;
	LD	E,2		;Sector 2
	LD	L,20H		;byte X'20'
	LD	(HL),CR		;no auto
	CALL	WRSEC		;write sector
	RET			;RETurn for now
;
;
;***
;	WRGAT - Write Granule Allocation Table
;***
;
WRGAT	LD	HL,IOBUFF	;HL => I/O buffer
GAT0	LD	(HL),0F9H	;DD - X'F9', SD - X'FD'
	INC	HL		;bump
;
;*=*=* Lock out next X'CA' bytes in GAT *=*=*
;
	LD	B,0CAH		;Lock out the bytes
LOCKOUT	LD	(HL),0FFH	;GAT + X'00' through
	INC	HL		;GAT + X'CA'
	DJNZ	LOCKOUT		;
;
;*=*=* GAT + X'CB' *=*=*
;
	LD	(HL),62H	;GAT + X'CB'= Version 6.2
;
;*=*=* GAT + X'CC' *=*=*
;
CYLS	LD	A,$-$		;p/u cylinder count
	PUSH	AF		;Save Cylinder count
	SUB	35		;tracks in excess of 35
	INC	HL		;HL => next GAT byte
	LD	(HL),A		;GAT + X'CC'= tracks - 35
;
;*=*=* GAT + X'CD' *=*=*
;
	INC	HL		;GAT + X'CD' =
GATCD	LD	(HL),42H	;DDEN, 1 side, 3 gran/cyl
;
;*=*=* GAT + X'CE' & X'CF' *=*=*
;
	INC	HL		;GAT + X'CE' & X'CF' =
	LD	(HL),0E0H	;16-bit Hash code of
	INC	HL		;"PASSWORD"
	LD	(HL),42H	;Hash = X'E042'
;
;*=*=* GAT + X'D0' - X'D7' *=*=*
;
	INC	HL		;HL => next GAT byte
	LD	DE,MEMDISK	;"MEMDISK " is Pack ID
	LD	C,8		;Eight bytes
	EX	DE,HL		;swap 'em for LDIR
	LDIR			;stuff in ID
	EX	DE,HL		;HL => GAT + X'D8'
;
;*=*=* GAT + X'D8' - X'DF' *=*=*
;
	@@DATE			;stuff date in GAT
;
;*=*=* Stuff GAT with either X'F8' or X'FC' *=*=*
;
GPC	LD	A,0F8H		;3 gran/cyl
	LD	HL,IOBUFF+2	;HL => GAT + X'02'
	POP	BC		;B = # cylinders
	DEC	B		;Subtract 2 to account
	DEC	B		;for BOOT and DIR
;
;*=*=* Stuff open cylinder bytes into GAT *=*=*
;
FREETRK	LD	(HL),A		;free track
	INC	HL		;next GAT byte
	DJNZ	FREETRK		;do it B times
;
;*=*=* Put 2 free Cyl bytes in lockout - BOOT & DIR *=*=*
;
	LD	L,60H		;HL => Lockout
	LD	(HL),A		;
	INC	L		;
	LD	(HL),A		;
;
;*=*=* GAT + X'62' - GAT + X'BF' *=*=*
;
	LD	L,2		;HL => GAT + X'02'
	LD	D,H		;xfer to DE
	LD	E,L		;
	LD	C,60H		;of X'60' for the
	ADD	HL,BC		;duplicate of top
	DEC	C		;only duplicate X'5E'
	DEC	C		;bytes
	EX	DE,HL		;prepare for LDIR
	LDIR			;HL => GAT, DE => Lockout
;
	LD	DE,IOBUFF+255-11;6.2 Media Data Block
	LD	HL,LSIID	;point to header
	LD	BC,04		;set length
	LDIR			; move it
	LD	HL,(SAVEDCT)	; The data to move
	INC	HL
	INC	HL
	INC	HL
	LD	C,7		; bytes to move
	LDIR			; move it in
	JR	WRGAT1		;skip around string
LSIID	DB	03,'LSI'
;
WRGAT1	LD	DE,100H		;D = Cyl 1, E = Sector 0
;
;
;***
;	WRSEC - Write A sector to MemDISK drive
;***
;
WRSEC	LD	HL,IOBUFF	;I/O buffer
DRIVE	LD	C,$-$		;p/u drive #
	@@WRSEC			;Write Sector
	RET			;and RETurn
;
;
;***
;	RDSEC - Read A sector of MemDISK drive
;***
;
RDSEC	LD	HL,IOBUFF	;HL => I/O Buffer
	LD	A,(DRIVE+1)	;p/u drive #
	LD	C,A		;xfer to C
	@@RDSEC			;read sector
	RET			;and RETurn
;
;
;***
;	WRHIT - Write HIT sector in directory
;***
;
WRHIT	XOR	A		;Set A = 0
ZEROHIT	LD	(HL),A		;zero HIT position
	INC	L		;bump HIT pointer
	JR	NZ,ZEROHIT	;256 positions
	LD	(HL),0A2H	;Hash for BOOT/SYS
	INC	L		;HL => HIT + X'01'
	LD	(HL),0C4H	;Hash for DIR/SYS
	INC	E		;D = Cyl 1, Sector 1
	JR	WRSEC		;Write Sector & RETurn
;
;
;***
;	WRENT - Write DIR/SYS & BOOT/SYS entries
;***
;
WRENT	LD	DE,BOOT		;BOOT/SYS byte field
	EX	DE,HL		;swap for LDIR
	LD	BC,32		;32 bytes in entry
	LDIR			;block move
	LD	DE,102H		;D = Cyl 1, E = Sector 2
	CALL	WRSEC		;write Sector
;
	LD	BC,32		;
	EX	DE,HL		;xfer buffer ptr to DE
	LD	HL,DIR		;HL => DIR/SYS bytes
	LDIR			;xfer to MemDISK
	LD	DE,103H		;D = Cyl 1, E = Sector 3
	JR	WRSEC		;Write sector & RETurn
;
;*=*=* BOOT/SYS directory entry data *=*=*
;
BOOT	DB	01011110B	;No access,inv,sys,FPDE
	DW	0		;Date = 00/00/00
	DW	0		;EOF offset = 0, LRL=256
	DB	'BOOT    '	;Name field
	DB	'SYS'		;extension
	DW	037F6H		;Owner password hash
	DW	09CF5H		;User password hash
BOOTERN	DW	6		;ERN = 6 or 5
	DB	0		;First extent = Cyl 0
BOOTGRN	DB	0		;St gran = 0, 1 cont gran
	DW	0FFFFH		;no more extents
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
;
;*=*=* DIR/SYS directory entry data *=*=*
;
DIR	DB	01011101B	;read only,inv,sys,FPDE
	DW	0		;Date= 00/00/00
	DW	0		;EOF offset=0, LRL=256
	DB	'DIR     '	;Name field
	DB	'SYS'		;Extension
	DW	037F6H		;Owner password hash
	DW	04296H		;User password hash
DIRERN	DW	18		;ERN+1 = 10 or 18
	DB	1		;starts on cylinder 1
SDENI	DB	00000010B	;st. gran=0, 3 cont grans
	DW	0FFFFH		;No Second Extent
	DW	0FFFFH		;No Third Extent
	DW	0FFFFH		;No Fourth Extent
	DB	0FFH		;No further records
	DB	0FFH		;No DEC for DIR/SYS
;
;
;***
;	DOMEM - Issue Prompts & take inputs for type
;***
;
DOMEM	LD	HL,HELLO$	;Display message
	@@DSPLY			;and all the formalities
;*=*=*
;	Check if entry from SYSTEM (DRIVER= command
;*=*=*
	@@FLAGS
	BIT	3,(IY+'C'-'A')	;System request?
	JP	Z,VIASET
;
;*=*=* Input MemDISK type - A,B,C,D or E to disable *=*=*
;
GETYPE	LD	HL,BANKS	;Display prompt
	@@DSPLY			;
	LD	B,1		;# of chars to input
	CALL	INPUT		;input byte
	JR	Z,GETYPE	;<ENTER> ? - re-input
;
;*=*=* Convert input A-E to 0-4 *=*=*
;
	LD	A,(HL)		;p/u first character
	RES	5,A		;convert to U/C
	SUB	'A'		;<A> - Bank 0 ?
	LD	(SETBANK+1),A	;save type of MemDISK
	LD	C,A		;xfer to C for @BANK
;
;*=*=* If input is illegal then re-input *=*=*
;
	JR	C,GETYPE	;less - re-input
	CP	4		;<E> - Disable MemDISK
	JP	Z,DISMEM	;yes - take it out
	JR	NC,GETYPE	;>4 - Re-input
;
;*=*=* Check if MemDISK is already active *=*=*
;
	BIT	4,(IY+DFLAG$)	;MemDISK already active ?
	JP	NZ,MEMIN	;yes - abort
;
;*=*=* If Type A,B,C - Check Bk, D - Check bks 1&2 *=*=*
;
	PUSH	BC		;Save Bank #
	CP	3		;Type "D" ?
	JR	NZ,A_B_C	;no - "A", "B", or "C"
;
;*=*=* Type "D" - See if both banks 1 & 2 are avail *=*=*
;
TYPED	LD	C,1		;Bank #1 active ?
	CALL	CKBANK		;
	INC	C		;Bank #2 active ?
A_B_C	CALL	CKBANK		;
	POP	BC		;C = Bank # (0,1,2,3)
;
;*=*=* Stuff Default Bank # and offset into driver *=*=*
;
	LD	A,C		;p/u bank #
	DEC	A		;If bank 0 requested,
	JP	M,WAS0		;  then keep as -1
	INC	A		;  for driver bank test
	LD	(BANKIM),A	;save bank # in driver
	CP	2		;instruction if
	JR	NZ,NOT2		;just bank #2 active
	LD	HL,OFFSET+1	;Stuff X'80' in ADD
	LD	(HL),80H	;
NOT2	LD	A,1		;always init to bank 1
				;if type B, C or D
WAS0	LD	(DEFBANK+1),A	;and stuff in driver
;
;*=*=* Input Density (Single or Double) *=*=*
;
INPDENS	LD	HL,DENSITY	;"Density"
	@@DSPLY			;
	LD	B,1		;input an "S" or "D"
	CALL	INPUT		;
	JR	Z,DEFAULT	;<ENTER> - use default
;
;*=*=* <D>ouble Density input ? *=*=*
;
	LD	A,(HL)		;p/u first char
	RES	5,A		;convert to U/C
	CP	'D'		;<D>ouble Density ?
	JR	Z,DEFAULT	;yes - use 6 sectors/gran
;
;*=*=* <S>ingle Density input ? *=*=*
;
	CP	'S'		;<S>ingle Density ?
	JR	NZ,INPDENS	;no - input density again
;
;*=*=* Single Density - Change driver math *=*=*
;
	LD	A,82H		;ADD A,D instruction
	LD	(SDENB),A	;
	LD	A,87H		;ADD A,A instruction
	LD	(SDENC),A	;
	LD	A,9		;
	LD	(SDENF+3),A	;DCT + 7
	LD	(SPC+1),A	;Save in CALCSIZ routine
	INC	A		;SDEN BOOT ERN = 10
	LD	(DIRERN),A	;SDEN DIR/SYS ERN = 10
	LD	A,24H		;
	LD	(SDENG+3),A	;DCT + 8
	LD	A,'2'		;Change size to 2.50K
	LD	(FRTRK1),A	;space per cylinder
	LD	A,0FDH		;1 Gran Free
	LD	(GAT0+1),A	;stuff in WRGAT routine
	DEC	A		;2 Grans/Cyl - X'FC'
	LD	(GPC+1),A	;
	XOR	A		;NOP instruction
	LD	(SDENA),A	;
	LD	(SDEND+3),A	;DCT + 3
	INC	A		;Set A = 1
	LD	(GATCD+1),A	;stuff in WRGAT routine
	LD	(SDENI),A	;2 contiguous granules
	LD	A,5		;Set Boot ERN = 5
	LD	(BOOTERN),A	;
	LD	A,10H		;Alien Disk Controller
	LD	(SDENE+3),A	;
	LD	HL,BTSECS+1	;HL => # BOOT sectors
	DEC	(HL)		;use 5 instead of 6
	LD	HL,SDBPC	;change GETCYL routine
	LD	(BPC+1),HL	;
;
;*=*=* Calculate # of possible cylinders *=*=*
;
DEFAULT	LD	A,(SETBANK+1)	;p/u type of memdisk
	LD	C,A		;save in C
	OR	A		;Bank 0 ?
	JR	Z,PIKUPHI	;yes - use HIGH$
;
;*=*=* Bank #1, #2, or #1 & #2 *=*=*
;
	LD	HL,7FFFH	;HL = # bytes in 1 bank
	CP	3		;Bank 1 & 2 ?
	JR	NZ,CALCYL	;no - use X'7FFF'
	LD	H,L		;Set HL = X'FFFF'
	JR	CALCYL		;
;
;*=*=* Bank Zero request - calculate free mem avail *=*=*
;
PIKUPHI	XOR	A		;Set A = 0
	SBC	HL,HL		;HL = 0
	LD	B,A		;B = 0
	@@HIGH$			;p/u HIGH$
	LD	(MDDATA+2),HL	;Save HIGH$
	LD	(OLD_HI),HL	;save HIGH$ in driver
	INC	HL		;Set HL = last page
	DEC	H		;
	LD	L,A		;
	LD	(SAVPAGE+1),HL	;save page boundary
	LD	DE,LOWEST	;DE = lowest
	XOR	A		;
	SBC	HL,DE		;HL = amount free
	JP	C,NOMEM		;Carry - not enough mem
;
;*=*=* Calculate # of cylinders available *=*=*
;
CALCYL	CALL	GETCYL		;get # of poss cyls
	JP	NZ,NOMEM	;NZ - Not enough mem
;
;*=*=* Convert A to ASCII & stuff into string *=*=*
;
	INC	A		;bump one
	LD	(MAXCYL+1),A	;save max # of cyls
	DEC	A		;
	LD	(CYLS+1),A	;stuff in WRGAT routine
	PUSH	AF		;Save Max # of cyls
	CALL	DECASC		;convert to ASCII in HL
	POP	AF		;A = # cyls
	EX	DE,HL		;DE = #
	LD	HL,FRTRK2	;HL => Destination
	LD	(HL),D		;msb
	INC	HL		;
	LD	(HL),E		;lsb
;
;*=*=* A = # of Cyls poss, put in string if bank 0 *=*=*
;
	INC	C		;Bank Zero request ?
	DEC	C		;
	RET	NZ		;no - done prompting
;
;*=*=* Display Cylinders string & input # of cyls *=*=*
;
REDO	LD	HL,FRTRACK	;how many cylinders
	@@DSPLY			;
	LD	B,2		;Input # of cyls
	CALL	INPUT		;
	JR	Z,REDO		;reinput it
;
;*=*=* Check if input legal *=*=*
;
	CALL	DECHEX		;convert # to Hex
	JR	NZ,REDO		;Illegal - Re-input
	CP	MINCYL		;Less than minimum?
	JR	C,REDO
MAXCYL	CP	$-$		;p/u max # of cyls
	JR	NC,REDO		;too many - reinput
	LD	(CYLS+1),A	;New # of cylinders
;
;*=*=* CALCSIZ - Calculate Size of Cyl request *=*=*
;
CALCSIZ	CALL	SAVEREG		;Save Registers
	LD	C,A		;Xfer # cyls to C
SPC	LD	B,17		;p/u Sectors/Cyl
;
;*=*=* Multiply Sectors per Cylinder x # Cylinders *=*=*
;
MLOOP	ADD	A,C		;multiply B x C
	DJNZ	MLOOP		;
;
;*=*=* Set HL = New HIGH$ *=*=*
;
SAVPAGE	LD	HL,$-$		;p/u page boundary
	NEG			;Set H = H - A
	ADD	A,H		;
	LD	H,A		;HL = New HIGH$, B = 0
	LD	(OFFSET+1),A	;stuff into driver
;
;*=*=* Stuff a Memory Header on front of MemDISK *=*=*
;
	DEC	HL
	EX	DE,HL
	LD	HL,MDDATA+16
	LD	BC,17
	LDDR
	EX	DE,HL
	LD	(MEMHIGH),HL
	@@HIGH$			;install new HIGH$
	RET			;Restore Regs & RETurn
;
;*=*=* DISMEM - Disable MemDISK if in memory *=*=*
;
DISMEM	BIT	4,(IY+DFLAG$)	;MemDISK active ?
	JP	Z,NOTPRS	;no - display error mess
;
;*=*=* Pick up Driver address of drive *=*=*
;
	LD	HL,(SAVEDCT)	;p/u DCT address
	PUSH	HL		;Save DCT ptr
	INC	HL		;P/u driver address
	LD	E,(HL)		;lsb
	INC	HL		;
	LD	D,(HL)		;msb
	PUSH	DE		;Save Driver Address
;
;*=*=* Calculate end of driver & Posn to ID *=*=*
;
	EX	DE,HL		;Pt HL to driver
	PUSH	HL		;Save driver start
	LD	BC,LENGTH	;Add length of driver
	ADD	HL,BC		;to start of driver.
	LD	(DREND+1),HL	;save next available
	POP	HL		;HL => driver add start
	INC	HL		;pos'n to length byte
	INC	HL		;
	INC	HL		;
	INC	HL		;
;
;*=*=* P/u length byte & pt to driver name *=*=*
;
	LD	B,(HL)		;p/u length byte
	INC	HL		;HL => Driver Name
	LD	DE,MD$		;DE => MEMDISK
;
;*=*=* Is this REALLY a certified MemDISK ?? *=*=*
;
MEMLP	LD	A,(DE)		;p/u MemDISK byte
	CP	(HL)		;match ?
	INC	HL		;bump driver ptr
	INC	DE		;bump string ptr
	JP	NZ,NOTMEM	;no - Aint to MemDISK
	DJNZ	MEMLP		;yes - need 7 to match
;
;*=*=* Pick up Old HIGH$ address & stuff for later *=*=*
;
	LD	E,(HL)		;p/u old HIGH$
	INC	HL		;
	LD	D,(HL)		;
	LD	(SAVEOLD+1),DE	;stuff into LD HL inst
;
;*=*=* P/u BANK information *=*=*
;
	RES	4,(IY+DFLAG$)	;Reset MemDISK bit
	INC	HL		;HL => Bank image
	LD	A,(HL)		;p/u bank image
	LD	C,A		;xfer to C
	CP	3		;both banks 1 & 2 ?
	JR	C,FRBANK	;no - free up bank
	DEC	C		;Set C = 2
	CALL	FREBANK		;free bank #2
	DEC	C		;Set C = 1
FRBANK	CALL	FREBANK		;free Bank in C
;
;*=*=* Is this a Bank Zero MemDISK ? *=*=*
;
	LD	IY,TYPEDIS	;IY => Disable Type
	INC	C		;Is C = 0 ?
	DEC	C		;
	JR	NZ,GTDRV2	;no - check out driver
;
;*=*=* Bank 0 - p/u last HIGH$ from Driver storage *=*=*
;
	DEC	(IY)		;change type
	INC	HL		;pos to HI$ val after
	INC	HL		;  MemDISK installation.
	INC	HL
	LD	E,(HL)		;p/u address
	INC	HL		;
	LD	D,(HL)		;
;
;*=*=* Pick up Current HIGH$ & compare with other *=*=*
;
	LD	H,B		;Set HL = 0
	LD	L,B		;
	@@HIGH$			;(B=0), p/u HIGH$
	OR	A		;Same ?
	SBC	HL,DE		;
	JR	NZ,GTDRV2	;NZ - Can't do it
;
;*=*=* Reset HIGH$ = original HIGH$ *=*=*
;
SAVEOLD	LD	HL,$-$		;p/u old HIGH$
	@@HIGH$			;re-allocate space
	INC	(IY)		;Change Type
;
;*=*=* Can the Driver area be re-allocated ? *=*=*
;
GTDRV2	CALL	GTDRV		;Get driver area
DREND	LD	HL,$-$		;p/u driver address
	OR	A		;
	SBC	HL,DE		;Same ?
	POP	HL		;HL => Driver Address
	JR	NZ,NORECLM	;no - can't Reclaim
;
;*=*=* Stuff original Address into KIDCB$-2 *=*=*
;
	LD	(IX),H		;msb
	LD	(IX-1),L	;lsb
	INC	(IY)		;Change type
	INC	(IY)		;
;
;*=*=* Clear out Driver *=*=*
;
	LD	BC,LENGTH-1	;BC = # of bytes clr
	LD	(HL),0		;null byte
	LD	D,H		;Set DE = HL+1
	LD	E,L		;
	INC	DE		;
	LDIR			;clear area
;
;*=*=* Disable DCT slot *=*=*
;
NORECLM	POP	HL		;HL => DCT + 0
	LD	(HL),0C9H	;disable it
;
;*=*=* Calculate Start of Disable string *=*=*
;
	PUSH	IY		;Xfer to HL
	POP	HL		;
	LD	C,(HL)		;p/u type
	SLA	C		;multiply by 2
	LD	B,0		;BC = offset in table
	INC	HL		;HL => Address Table
	ADD	HL,BC		;HL => Add of mess string
	LD	E,(HL)		;p/u Address
	INC	HL		;
	LD	D,(HL)		;
	EX	DE,HL		;HL => Disable message
	@@LOGOT			;log message
	JP	EXIT		;go to exit routine
;
;***
;	FORMAT - Format Memory
;***
;
FORMAT	LD	HL,VERIFY	;"Verifying RAM ..."
	@@DSPLY			;display it
	LD	D,00		;track counter
;
;*=*=* Display Current Cylinder Formatting *=*=*
;
WIPELP	LD	A,D		;get track counter
	CALL	DECASC2		;display Dec ASCII equiv.
;
;*=*=* Run 4 different bit tests on each cylinder *=*=*
;
	LD	A,11111111B	;all bits on
	CALL	VERCYL		;verify track w/ bits on
	LD	A,01010101B	;next pattern
	CALL 	VERCYL
	LD	A,10101010B	;last pattern
	CALL	VERCYL
	LD	A,00000000B	;all bits off
	CALL	VERCYL		;verify track w/ bits off
;
;*=*=* Finished Formatting yet ? *=*=*
;
	INC	D		;bump cylinder #
	LD	A,D		;
	CP	(IX+6)		;Finished ?
	JR	NZ,WIPELP	;no - stop when max cyl
;
;*=*=* Finished Formatting - Display message *=*=*
;
	LD	HL,FORMCOM	;"Formatting Complete"
	@@DSPLY			;print it
	RET			;done formatting
;
;*=*=* VERCYL - Verify a cylinder of RAM *=*=*
;
VERCYL	LD	HL,IOBUFF	;HL => I/O buffer
	LD	E,0		;init to sector 0
;
;*=*=* Fill buffer with specified byte *=*=*
;
STUFLP	LD	(HL),A		;stuff into buffer
	INC	L		;bump
	JR	NZ,STUFLP	;256 bytes to fill
;
;*=*=* Write the sector & read it back *=*=*
;
CYLP	PUSH	AF		;Save fill byte
	CALL	WRSEC		;Write Sector
	CALL	RDSEC		;Read into other buff
	POP	AF		;A = Fill byte
;
;*=*=* Check if sector read back has correct byte *=*=*
;
CKLP	CP	(HL)		;match ?
	JP	NZ,ERROR	;no - BAD NEWS CLYDE !!!
	INC	L		;done with sector ?
	JR	NZ,CKLP		;256 bytes to check
;
;*=*=* Advance to next sector *=*=*
;
	LD	A,E		;p/u sector #
	CP	(IX+7)		;finished ?
	LD	A,(HL)		;p/u cylinder byte
	INC	DE		;bump E
	JR	NZ,CYLP		;DCT+8 sectors to check
	RET			;done - RETurn
;
;
;***
;	FORMTIT - Check if MemDISK has data on it
;***
;
FORMTIT	LD	DE,100H		;D = Cyl 1, Sec 0 (GAT)
	CALL	RDSEC		;Read BOOT sector
;
;*=*=* Check GAT ID *=*=*
;
	LD	L,0D0H		;MemDISK pack ID
	LD	DE,MEMDISK	;What it should be
	LD	B,8		;# of character
;
CKMLP	LD	A,(DE)		;p/u should be char
	CP	(HL)		;match ?
	INC	HL		;bump
	INC	DE		;
	JR	NZ,NOMTCH	;no - must format
	DJNZ	CKMLP		;yes - need 32 to match
;
;*=*=* Already a MemDISK - Sure about formatting ? *=*=*
;
	LD	HL,DOFORM	;Destination ...
	LD	A,1		;Set MemDISK in flag
	LD	(MEMIN1+1),A	;
	JR	DISMES		;display it
;
;*=*=* Not a MemDISK - Do normal Prompt *=*=*
;
NOMTCH	LD	HL,STILLFM	;Do you wish to format ?
DISMES	@@DSPLY			;display message
;
;*=*=* Input Response *=*=*
;
	LD	B,1		;input 1 character
	PUSH	HL		;Save message start
	CALL	INPUT		;
	LD	A,(HL)		;p/u character
	POP	HL		;recover message start
	DEC	B		;anything entered ?
	RET	NZ		;no - RETurn NZ
;
;*=*=* Set Z flag if "Y" & Reset Z if "N" entered *=*=*
;
	RES	5,A		;cvt to U/C
	CP	'N'		;<N>o ?
	JR	Z,RESZF		;RETurn NZ
	CP	'Y'		;<Y>es ?
	RET	Z		;RETurn Z set
	JR	DISMES		;no - reprompt
RESZF	OR	A		;Reset Z flag
	RET			;and RETurn
;
;*=*=* Variables used *=*=*
;
;
SAVEDE	DW	0
SAVEDCT	DW	0
DRADD	DW	0
;
;*=*=* Informative Error Display & Abort Routine *=*=*
;
NODRV	LD	HL,NODRV$
	DB	0DDH
BADDRV	LD	HL,BADDRV$
	DB	0DDH
VIASET	LD	HL,VIASET$	;Not via SYSTEM
	DB	0DDH
MEMIN	LD	HL,MEMIN$	;Already installed
	DB	0DDH		;
NOTMEM	LD	HL,NOTMEM$	;Not a MemDISK
	DB	0DDH		;
NOMEM	LD	HL,NOMEM$	;Insufficient Memory
	DB	0DDH		;
NOTPRS	LD	HL,NOTPRS$	;Not Present
	DB	0DDH		;
BNKUSE	LD	HL,BNKUSE$	;Bank in use
	DB	0DDH		;
NOTACT	LD	HL,NOTACT$	;Cant Install
;
;*=*=* Log Error Message & Abort *=*=*
;
	@@LOGOT			;Log error message
	JP	ABORT		;go to exit routine
;
;
;#### STRINGS ####
;
HELLO$	DB	'MEMDISK'
*GET	CLIENT:3
;
BANKS	DB	LF,'<A>  Bank 0 (Primary Memory)',LF
	DB	'<B>  Bank 1',LF
	DB	'<C>  Bank 2',LF
	DB	'<D>  Banks 1 and 2',LF
	DB	'<E>  Disable MemDISK',LF,LF
	DB	'Which type of allocation - '
	DB	'<A>, <B>, <C>, <D>, or <E> ? ',ETX
;
FRTRACK	DB	'Note: Each Cylinder equals '
FRTRK1	DB	'4.50K of space.',LF
	DB 'Number of free Cylinders: ',MINCYL+'0'&0FFH,'-'
FRTRK2	DB	'00 ? ',ETX
;
DENSITY	DB	'Single or Double Density <S,D> ? ',ETX
;
DOFORM	DB	'Destination MemDISK contains Data',LF
;
STILLFM	DB	'Do you wish to Format it <Y/N> ? ',ETX
;
MEMDISK	DB	'MEMDISK '
MD$	DB	'$MD',ETX
MDDATA	DB	18H,17,0,0,8,'MemDISKD',0,0,0,0
;
NODRV$	DB	'Logical drive number required',CR
BADDRV$	DB	'Can''t specify SYSTEM drive slot',CR
INSTALD	DB	'MemDISK Successfully Installed',CR
;
NOTMEM$	DB	'Target Drive not a MemDISK',CR
;
NOMEM$	DB	'Insufficient Memory ',CR
;
NOTPRS$	DB	'MemDISK not present',CR
;
NOTACT$	DB	'MemDISK not present, installation '
	DB	'aborted',CR
;
DISABE1	DB	'MemDISK disabled, memory now avail'
	DB	'able',CR
;
DISABE2	DB	'MemDISK disabled, Unable to reclaim '
	DB	'high memory',CR
;
DISABE3	DB	'MemDISK disabled, Unable to reclaim '
	DB	'driver area',CR
;
DISABE4	DB	'MemDISK disabled, Unable to reclaim '
	DB	'high memory and driver area',CR
;
BNKUSE$	DB	'Unable to install MemDISK, '
	DB	'requested bank in use.',CR
;
MEMIN$	DB	'MemDISK already Active',CR
;
VERIFY	DB	'Verifying RAM cylinder 00',ETX
;
FORMCOM	DB 	LF,'Verifying Complete, RAM good',LF
	DB 'Directory has been placed on Cylinder 1',CR
;
VIASET$	DB	'Must install via SYSTEM (DRIVER=',CR
;
BADRAM	DB	LF,'Verify Error in Bank '
VBANK	DB	'n at location X',AP
VLOC	DB	'nnnn',AP,LF,CR
;
TYPEDIS	DB	1		;Type of disable
DISTAB	DW	DISABE4,DISABE3,DISABE2,DISABE1
RE_USE	DB	0	;Re-use trapped driver area.
;
;#### Buffers used ####
;
	ORG	$<-8+1<+8
;
IOBUFF	DS	256
BUFFER	DS	256
DUPDCT	DS	10
;
;
