;LOWCORE2/ASM - LDOS-6.2 - 11/09/83
*LIST	OFF
@MOD2	EQU	-1
@MOD4	EQU	0
;
;	revised 09/26/83 for Mod II	- kjw
;
	TITLE	'<TRSDOS 6.2 - Low memory>'
;*=*=*
;	LDOS 6.x Low Core RAM storage assignments
;	Copyright (C) 1982 by Logical Systems, Inc.
;*=*=*
@GERMAN	EQU	0
@FRENCH	EQU	0
	IF	@GERMAN.AND.@FRENCH
	ERR	'*** CAN'T DO BOTH!! ***'
	ENDIF
	IF	@GERMAN.OR.@FRENCH
@INTL	EQU	-1
@USA	EQU	00
@HZ50	EQU	-1
	ELSE
@INTL	EQU	00
@USA	EQU	-1
@HZ50	EQU	00
	ENDIF
START$	EQU	0
FDDINT$	EQU	0EH
PDRV$	EQU	1BH
TIMSL$	EQU	2BH
TIMER$	EQU	2CH
TIME$	EQU	TIMER$+1
DATE$	EQU	33H
INTVC$	EQU	3EH
RSVECA	EQU	INTVC$+4
RSVECB	EQU	INTVC$+6
FLGTAB$	EQU	6AH
CFLAG$	EQU	FLGTAB$+'C'-'A'
DFLAG$	EQU	FLGTAB$+'D'-'A'
IFLAG$	EQU	FLGTAB$+'I'-'A'
KFLAG$	EQU	FLGTAB$+'K'-'A'
LFLAG$	EQU	FLGTAB$+'L'-'A'
MODOUT$	EQU	FLGTAB$+'M'-'A'
OPREG$	EQU	FLGTAB$+'O'-'A'
RFLAG$	EQU	FLGTAB$+'R'-'A'
SFLAG$	EQU	FLGTAB$+'S'-'A'
TFLAG$	EQU	FLGTAB$+'T'-'A'
VFLAG$	EQU	FLGTAB$+'V'-'A'
@KITSK	EQU	FLGTAB$+31
	ORG	200H+START$
;*=*=*
;	Page 2 - Device Control Blocks
;*=*=*
BUR$	DB	00H		;Bank use RAM
BAR$	DB	0FEH		;Bank available RAM
LBANK$	DB	77/2		;Dir cyl & logical bank
JCLCB$	DB	1,0,0		;Mini-DCB for JCL gets
DVRHI$	DW	DVREND$
KIDCB$	DB	5		;Permit CTL, GET
	DW	KIDVR
	DB	0,0,0,'KI'
DODCB$	DB	7		;Permit CTL, PUT, GET
	DW	DODVR
	DB	0,0,0,'DO'
PRDCB$	DB	6		;Permit CTL, PUT
	DW	PRDVR
	DB	0,0,0,'PR'
SIDCB$	DB	15H
	DW	KIDCB$
	DB	0DH,0,0,'SI'
SODCB$	DB	17H
	DW	DODCB$
	DB	0FH,0,0,'SO'
JLDCB$	DB	0AH,0,0,0AH,0,0,'JL'
S1DCB$	EQU	$
DCBKL$	EQU	JLDCB$&0FFH+1	;non-killable DCB's
;*=*=*
;	Now load the BOOT loader - part in this page
;*=*=*
*GET	BOOT42:3
;*=*=*
;	Page 3 - System stack area - 256 bytes
;*=*=*
STACK$	EQU	$-128		;Start stack 96 bytes low
PAUSE@	EQU	STACK$+2	;Were pause WILL be
;*=*=*
;	Page 4 - Miscellaneous stuff
;*=*=*
	DB	60H		;Operating system version
ZERO$	DB	0C9H		;Config on BOOT then 0
MAXDAY$	EQU	$-1
	DB	31,28,31,30,31,30,31,31,30,31,30,31
HIGH$	DS	2		;Highest available memory
PAKNAM$	DB	'TRSDOS62Level-AD'
;*=*=*
;	Command line input buffer & AUTO buffer area
;*=*=*
INBUF$	DB	0DH		;Input buffer - 80 bytes
	DC	79,0
;*=*=*
;	System drive code tables
;*=*=*
DCT$	EQU	$		;System drive code tables
	JP	FDCDVR		;Floppy drive 0
	DB	00100010B	;+3
	DB	01000001B	;+4
	DB	0		;+5
	DB	76		;+6
	DB	0<5+29		;+7
	DB	2<5+9		;+8
	DB	77/2		;+9
;
	JP	FDCDVR		;Floppy drive 1
	DB	01100010B	;+3
	DB	01000010B	;+4
	DB	-1		;+5
	DB	76		;+6
	DB	0<5+29		;+7
	DB	2<5+9		;+8
	DB	77/2		;+9
;
	RET			; Disable drive #2
	DW	FDCDVR		;Floppy drive 2
	DB	01100010B	;+3
	DB	01000100B	;+4
	DB	-1		;+5
	DB	76		;+6
	DB	0<5+29		;+7
	DB	2<5+9		;+8
	DB	77/2		;+9
;
	RET			; disable #3
	DW	FDCDVR		;Floppy drive 3
	DB	01100010B	;+3
	DB	01001000B	;+4
	DB	-1		;+5
	DB	76		;+6
	DB	0<5+29		;+7
	DB	2<5+9		;+8
	DB	77/2		;+9
;
	RET			;Logical drive 4
	DW	FDCRET
	DB	0,0,0,27H,0,0,0
	RET			;Logical drive 5
	DW	FDCRET
	DB	0,0,0,27H,0,0,0
	RET			;Logical drive 6
	DW	FDCRET
	DB	0,0,0,27H,0,0,0
	RET			;Logical drive 7
	DW	FDCRET
	DB	0,0,0,27H,0,0,0
;*=*=*
;	SYSINFO - miscellaneous information
;*=*=*
DSKTYP$	DB	-1		;0 = DATA, <> 0 = SYS
	DB	0		;spare
DTPMT$	DB	0		;Date prompt at boot
TMPMT$	DB	-1		;Time prompt at boot
RSTOR$	DB	0		;Suppress restores @ BOOT
	DS	2		;spare
DAYTBL$	DB	'SunMonTueWedThuFriSat'
MONTBL$	DB	'JanFebMarAprMayJunJulAugSepOctNovDec'
;*=*=*
;	End of low core assignments
;*=*=*
*GET	IODVR:3		;I/O driver, KEYIN, etc
*GET	MULDIV:3	;16-bit MULT & DIV
*GET	CLOCKS2:3	;hardware task stuff
;
;	setup mode 2 interrupt table
;	must be on even paragraph
;
DMY$	EQU	$&0FFF0H	;last even paragraph
	IFEQ	$,DMY$		;check if already on even
	ELSE
	DC	DMY$+10H-$,0	;else pad to next para.
	ENDIF
;
$M2VECS	DW	RSINTB$		;sio B TX
	DW	RSINTB$		;sio B extl
	DW	RSINTB$		;sio B RX
	DW	RSINTB$		;sio B spcl
;
	DW	RSINTA$		;sio A TX
	DW	RSINTA$		;sio A extl
	DW	RSINTA$		;sio A RX
	DW	RSINTA$		;sio A spcl
;
	DW	-1		;CTC0
	DW	-1		;CTC1
	DW	-1		;CTC2
	DW	KIINT$		;CTC3 - keyboard
;
	IFNE	$M2VECS&0FH,0
	ERR	'Mode 2 vectors not on even paragraph!'
	ENDIF
;
	IFNE	$<-8,$M2VECS<-8
	ERR	'Mode 2 vectors cross page boundary!'
	ENDIF
;
;	SIO interrupt handler
;
RSINTA$	PUSH	HL		;save HL
	LD	HL,(RSVECA)	;get vector
	JR	RSINTC		;go common
;
RSINTB$	PUSH	HL		;save HL
	LD	HL,(RSVECB)	;get vector
;
RSINTC	PUSH	DE
	PUSH	BC
	PUSH	AF
	PUSH	IX
	LD	A,(LBANK$)	;get last bank
	PUSH	AF		;save it
	XOR	A		;set now in bank 0
	LD	(LBANK$),A	;update
	LD	A,(MODOUT$)	;get memory image
	PUSH	AF		;save for restore
	AND	01110000B	;no video
	OR	1		;bank 0
	CALL	SET_MOD		;select
	PUSH	HL		;leave vector
	LD	HL,RSINTR	;return vector
	EX	(SP),HL		;get vector, leave return
	JP	(HL)		;go vector!
;
RSINTR	POP	AF		;restore memory image
	CALL	SET_MOD		;reset
	POP	AF		;restore last bank
	LD	(LBANK$),A	;update
	POP	IX
	POP	AF
	POP	BC
	POP	DE
	POP	HL
ENAINT	EI
	RETI			;return from interrupt
;
@$SYS	EQU	$	;Pointer for @GTMOD
	IF	@USA
*GET	KIDVR2:3	;Keyboard driver
	ENDIF
	IF	@GERMAN
FREN	EQU	00
GERM	EQU	-1
*GET	KIDVRFG:3
	ERR	'Cannot have GERMAN with Mod II'
	ENDIF
	IF	@FRENCH
FREN	EQU	-1
GERM	EQU	00
*GET	KIDVRFG:3
	ERR	'Cannot have FRENCH with Mod II'
	ENDIF
*GET	DODVR2:3	;Video driver
*GET	PRDVR2:3	;Printer driver & filter
*GET	FDCDVR2:3	;Floppy disk driver
DVREND$	EQU	$
	IFGT	$,1200H+START$
	ERR	'Drivers overflow available RAM
	ENDIF
	ORG	1300H+START$
@BYTEIO	EQU	$
	END
