;LOWCORE/ASM - LDOS-6.2 - 09/26/83
*LIST OFF
	TITLE	'<TRSDOS 6.2 - Low memory>'
@MOD2	EQU	00
@MOD4	EQU	-1
;*=*=*
;	LDOS 6.x Low Core RAM storage assignments
;	Copyright (C) 1982 by Logical Systems, Inc.
;*=*=*
@GERMAN	EQU	0
@FRENCH	EQU	0
	IF	@GERMAN.AND.@FRENCH
	ERR	'*** CAN'T DO BOTH!! ***'
	ENDIF
	IF	@GERMAN.OR.@FRENCH
@INTL	EQU	-1
@USA	EQU	00
@HZ50	EQU	-1
	ELSE
@INTL	EQU	00
@USA	EQU	-1
@HZ50	EQU	00
	ENDIF
START$	EQU	0
FDDINT$	EQU	0EH
PDRV$	EQU	1BH
TIMSL$	EQU	2BH
TIMER$	EQU	2CH
TIME$	EQU	TIMER$+1
DATE$	EQU	33H
INTVC$	EQU	3EH
FLGTAB$	EQU	6AH
CFLAG$	EQU	FLGTAB$+'C'-'A'
DFLAG$	EQU	FLGTAB$+'D'-'A'
IFLAG$	EQU	FLGTAB$+'I'-'A'
KFLAG$	EQU	FLGTAB$+'K'-'A'
MODOUT$	EQU	FLGTAB$+'M'-'A'
NFLAG$	EQU	FLGTAB$+'N'-'A'
OPREG$	EQU	FLGTAB$+'O'-'A'
RFLAG$	EQU	FLGTAB$+'R'-'A'
SFLAG$	EQU	FLGTAB$+'S'-'A'
VFLAG$	EQU	FLGTAB$+'V'-'A'
@KITSK	EQU	FLGTAB$+31
	ORG	200H+START$
;*=*=*
;	Page 2 - Device Control Blocks
;*=*=*
BUR$	DB	00H		;Bank use RAM
BAR$	DB	0FEH		;Bank available RAM
LBANK$	DB	20		;Dir cyl & logical bank
JCLCB$	DB	1,0,0		;Mini-DCB for JCL gets
DVRHI$	DW	DVREND$
KIDCB$	DB	5		;Permit CTL, GET
	DW	KIDVR
	DB	0,0,0,'KI'
DODCB$	DB	7		;Permit CTL, PUT, GET
	DW	DODVR
	DB	0,0,0,'DO'
PRDCB$	DB	6		;Permit CTL, PUT
	DW	PRDVR
	DB	0,0,0,'PR'
SIDCB$	DB	15H
	DW	KIDCB$
	DB	0DH,0,0,'SI'
SODCB$	DB	17H
	DW	DODCB$
	DB	0FH,0,0,'SO'
JLDCB$	DB	0AH,0,0,0AH,0,0,'JL'
S1DCB$	EQU	$
DCBKL$	EQU	JLDCB$&0FFH+1	;non-killable DCB's
;*=*=*
;	Now load the BOOT loader - part in this page
;*=*=*
*GET	BOOT4:3
;*=*=*
;	Page 3 - System stack area - 256 bytes
;*=*=*
STACK$	EQU	$-128		;Start stack 96 bytes low
PAUSE@	EQU	STACK$+2	;Were pause WILL be
;*=*=*
;	Page 4 - Miscellaneous stuff
;*=*=*
	DB	62H		;Operating system version
ZERO$	DB	0C9H		;Config on BOOT then 0
MAXDAY$	EQU	$-1
	DB	31,28,31,30,31,30,31,31,30,31,30,31
HIGH$	DS	2		;Highest available memory
;PAKNAM$	DB	'BetaTESTLevel-AC'
PAKNAM$	DB	'TRSDOS62Level-AD'
;*=*=*
;	Command line input buffer & AUTO buffer area
;*=*=*
INBUF$	DB	0DH		;Input buffer - 80 bytes
	DC	79,0
;*=*=*
;	System drive code tables
;*=*=*
DCT$	EQU	$		;System drive code tables
	JP	FDCDVR		;Floppy drive 0
	DB	44H,0C1H,0,27H,17,3-1<5+6-1,20
	JP	FDCDVR		;Floppy drive 1
	DB	44H,42H,-1,27H,17,3-1<5+6-1,20
	RET			; Disable drive #2
	DW	FDCDVR		;Floppy drive 2
	DB	44H,44H,-1,27H,17,3-1<5+6-1,20
	RET			; disable #3
	DW	FDCDVR		;Floppy drive 3
	DB	44H,48H,-1,27H,17,3-1<5+6-1,20
	RET			;Logical drive 4
	DW	FDCRET		
	DB	0,0,0,27H,0,0,0
	RET			;Logical drive 5
	DW	FDCRET
	DB	0,0,0,27H,0,0,0
	RET			;Logical drive 6
	DW	FDCRET
	DB	0,0,0,27H,0,0,0
	RET			;Logical drive 7
	DW	FDCRET
	DB	0,0,0,27H,0,0,0
;*=*=*
;	SYSINFO - miscellaneous information
;*=*=*
DSKTYP$	DB	-1		;0 = DATA, <> 0 = SYS
	DB	0		;spare
DTPMT$	DB	0		;Date prompt at boot
TMPMT$	DB	-1		;Time prompt at boot
RSTOR$	DB	0		;Suppress restores on BOOT
	DS	2		;spare
DAYTBL$	DB	'SunMonTueWedThuFriSat'
MONTBL$	DB	'JanFebMarAprMayJunJulAugSepOctNovDec'
;*=*=*
;	End of low core assignments
;*=*=*
*GET	IODVR:3		;I/O driver, KEYIN, etc
*GET	MULDIV:3	;16-bit MULT & DIV
*GET	CLOCKS:3	;hardware task stuff
@$SYS	EQU	$	;Pointer for @GTMOD
	IF	@USA
*GET	KIDVR:3		;Keyboard driver
	ENDIF
	IF	@GERMAN
FREN	EQU	00
GERM	EQU	-1
*GET	KIDVRFG:3
	ENDIF
	IF	@FRENCH
FREN	EQU	-1
GERM	EQU	00
*GET	KIDVRFG:3
	ENDIF
*GET	DODVR:3		;Video driver
*GET	PRDVR:3		;Printer driver & filter
*GET	FDCDVR:3	;Floppy disk driver
DVREND$	EQU	$
	IFGT	$,1200H+START$
	ERR	'Drivers overflow available RAM
	ENDIF
	ORG	1300H+START$
@BYTEIO	EQU	$
	END
