;LDOSDCT/ASM - LDOS 6.2 - 10/29/83
	TITLE	<LDOS/DCT - LDOS 6.2>
;*=*=*
;	Program installs a standard DCT into a logical
;	drive slot as specified by:
;		SYSTEM (DRIVE=d,DRIVER="LDOS")
;	The default DCT is taken from slot 0 of the
;	System Information Sector (70H-79H).
;
;	Change Log
;*=*=*
;
; 05/03/83 - Moved POP DE instruction after successful
;	   - input from prompt.
;
;*=*=*
CR	EQU	13
LF	EQU	10
 COM '<Copyright (C) 1983 by Logical Systems Inc.>'
*GET	SVCMAC:3
;
	ORG	2C00H
;
BEGIN
	@@CKBRKC
	JR	Z,BEGINA	;Continue if no break
	LD	HL,-1		; else abort
	RET
;
BEGINA	PUSH	DE
	@@DSPLY	HELLO$
	POP	DE
LDOS	LD	A,D		;Make sure that a
	OR	E		;  drive # was entered
	JP	Z,NODRV		;Go if no drive
;*=*=*
;	Check if entry from SET command
;*=*=*
	@@FLAGS
	BIT	3,(IY+'C'-'A')	;System request?
	JP	Z,VIASET
	LD	A,(DE)
	CP	0C9H		;Is drive disabled?
	JP	NZ,ACTIVE
	PUSH	DE		;Save DCT address
	CALL	GETCFG		;Load sysinfo sector
	JP	NZ,IOERR
	BIT	4,(IY+'L'-'A')	;Suppress 8" queries?
	JR	NZ,LDOS3
;*=*=*
;	Query as to 5" or 8" floppy
;*=*=*
DRVTYP	LD	HL,DRVTYP$	;"Enter drive code...
	@@DSPLY
	LD	HL,BUF		;pt to buffer
	LD	BC,1<8
	@@KEYIN			;get response
	JP	C,BREAK
	LD	A,(HL)
	SUB	'0'		;adjust to binary
	CP	2		;make sure requested
	JR	NC,DRVTYP	;type is supported
	LD	(LX805+1),A
;*=*=*
;	Prompt user for physical drive address
;*=*=*
LDOS3	@@DSPLY	DRVADR$		;"Enter physical...
	LD	HL,BUF		;input buffer
	LD	BC,1<8
	@@KEYIN			;get response
	JR	C,BREAK
	LD	A,(HL)
	SUB	'1'		;adjust to binary
	CP	3+1
	JR	NC,LDOS3
;*=*=*
;	Convert drive address to select code
;*=*=*
	CP	3		;Convert 3 to 4
	CCF
	ADC	A,0
	CP	1		;Convert <0,1,2,4>
	RLA			;  to <1, 2, 4, 8>
	LD	B,A		;Hang on to request
;*****
;	index the default drive code table
;*****
LX805	EQU	$
	IF	@MOD2
	LD	A,1		;8"
	ENDIF
	IF	@MOD4
	LD	A,0		;5"
	ENDIF
	LD	C,A
	ADD	A,A		;times 2
	ADD	A,C		;Times 3
	ADD	A,A		;Times 6
	ADD	A,C		;Times 7
	LD	HL,DRVTAB$	;Index into 5" or 8"
	ADD	A,L		;  default table
	LD	L,A
	ADC	A,H
	SUB	L
	LD	H,A
	INC	HL
	LD	A,(HL)		;P/u default DCT+4
	AND	0F0H		;Remove drive select
	OR	B		;Merge in new one
	LD	(HL),A		;Update the DCT
	DEC	HL
	LD	BC,7		;init for 7-byte move
	POP	DE		;DE => DCT$
	PUSH	DE		;Save DCT$ pointer
	INC	DE
	INC	DE
	INC	DE		;Index to DCT+3
	LDIR
	POP	DE
	PUSH	DE		;save start again
	LD	HL,BUFFER+70H	;Index the default vector
	LD	C,3		;Move in driver vector
	LDIR
	POP	DE
;
;	compute the actual drive number used
;
	@@GTDCT			;get drive 0(ldir set C=0
	PUSH	IY		;pass to HL for sub
	POP	HL		;HL => start DCT's
	EX	DE,HL		;DE=start, HL=current
	OR	A		;clear carry
	SBC	HL,DE		;HL = offset from start
	LD	C,10		;DCT length
	@@DIV16			;HL+A = HL/C
	LD	C,L		;result = drive #
	@@RSTOR			;restore drive
	LD	HL,0		;set no error return
	RET			;init complete
;*=*=*
;	Routines to read/write the config sector
;*=*=*
GETCFG	LD	HL,BUFFER	;Use buffer for I/O
	IF	@MOD2
	LD	DE,1<8+2	;config sector
	ENDIF
	IF	@MOD4
	LD	DE,0<8+2	;config sector
	ENDIF
	LD	C,L		; in system drive
	@@RDSEC			;Read it into core
	RET
;
IOERR	LD	L,A
	LD	H,0
	OR	0C0H
	@@ERROR
	@@CKBRKC
	RET
VIASET	LD	HL,VIASET$
	DB	0DDH
ACTIVE	LD	HL,ACTIVE$
	DB	0DDH
BREAK	LD	HL,BREAK$
	DB	0DDH
NODRV	LD	HL,NODRV$
	@@LOGOT
	LD	HL,-1
	@@CKBRKC
	RET
HELLO$	DB	LF,'FLOPPY Setup'
*GET	CLIENT:3
VIASET$	DB	'Must install via SYSTEM (DRIVER=',CR
ACTIVE$	DB	'Drive slot is already enabled',CR
NODRV$	DB	'Logical drive number required',CR
BREAK$	DB	'Command aborted',CR
DRVTYP$	DB	'   Enter drive code (0=5", 1=8") > ',3
DRVADR$	DB	'   Enter drive I/O address <1-4> > ',3
DRVTAB$
;	5" drive table
	DB	01000100B	;5", 6ms, delay=n
	DB	01000000B	;DDEN
	DB	0FFH		;Start cylinder
	DB	40-1		;40 track drive
	DB	18-1		;18 sec per cyl
	DB	3-1<5+6-1	;6 sec/gran, 3 gran/cyl
	DB	40/2		;directory track
;
;	8" table
;
	IF	@MOD4
	DB	00100001B	;8", 6ms step
	DB	01000000B	;DDEN
	DB	0FFH		;Start cylinder
	DB	77-1		;77 track drive
	DB	16-1		;16 sec per cyl
	DB	2-1<5+8-1	;8 sec/gran, 2 gran/cyl
	DB	77/2		;directory track
	ENDIF
;
	IF	@MOD2
	DB	01100010B	;+3 - 8", DD, 10ms, delay
	DB	01000000B	;+4 - DDen capable
	DB	-1		;+5 - current cyl
	DB	77-1		;+6 - high cylinder
	DB	0<5+29		;+7 - sides + high sec
	DB	2<5+9		;+8 - grans/cyl + sec/grn
	DB	77/2		;+9 - dir cylinder
	ENDIF
;
BUF	DS	2
	ORG	$<-8+1<+8
BUFFER	DS	256
	END	BEGIN
