;LBSYSTEM/ASM - SYSTEM Command - 11/03/83
	TITLE	<SYSTEM - LDOS 6.2>
;*=*=*
;	Change Log
;
; 09/14/83 - added SMOOTH parameter for DI in FDCDVR
; 09/19/83 - Added 'HERTZ50' and 'HERTZ60' parms
; 10/03/83 - Added 'CKDRV' parm to set/res BIT 7 (IY+4)
; 10/28/83 - Reorganized code & added break cleanup. DK
;
;*=*=*
*GET	SVCMAC:3
*LIST	OFF
MODPORT	EQU	0ECH
*GET	SYS0/EQU:2
*LIST	ON
CR	EQU	13
	ORG	2400H
SYSTEM
	@@CKBRKC		;Check for <BREAK>
	JR	Z,SYSTEM1	; if not continue
	LD	HL,-1		; else abort
	RET
;
;
SAVESP	LD	SP,$-$		;p/u stack
	@@CKBRKC		;clear any <BREAK>
	RET
;
;*=*=* Internal Error Message Handling *=*=*
;
NOMEM	LD	HL,NOMEM$
	DB	0DDH
PRMERR	LD	HL,PRMERR$
SETERR	@@LOGOT
FRCERR	LD	HL,-1
	JR	SAVESP		;p/u stack & clr <BREAK>
;
;*=*=* I/O Error Handler *=*=*
;
IOERR	LD	L,A
	LD	H,0
	OR	0C0H		;Set brief to return
	LD	C,A
	@@ERROR			;Display the error
	JR	SAVESP		;p/u stack & clr <BREAK>
;
;
;********************************************************
;***						      ***
;*** SYSTEM1 - Set the O/S's parameters		      ***
;***						      ***
;********************************************************
;
SYSTEM1
	LD	(SAVESP+1),SP	;save the stack
;
	LD	DE,PRMTBL$	;get parms
	@@PARAM
	JP	NZ,PRMERR	;jump on parm error
	@@FLAGS			;Get IY = flagtab
SLOW	LD	BC,0		;test SLOW parm
	LD	A,B
	OR	C
	JR	NZ,SETSLOW	;jump if SLOW entered
FPARM	LD	BC,0		;p/u FAST parm
	LD	A,B
	OR	C
	JR	Z,FPEND		;neither SLOW nor FAST?
	SET	3,(IY+'S'-'A')	;set fast in flag
	IF	@MOD4
	SET	6,(IY+'M'-'A')	;Set bit 6 in port mask
	ENDIF
	LD	B,55H		;Set time slice byte
	JR	SETCLK		;Go set it
;*****
;	turn off FAST
;*****
SETSLOW	RES	3,(IY+'S'-'A')	;reset the FAST bit
	IF	@MOD4
	RES	6,(IY+'M'-'A')
	ENDIF
SETCLK	LD	A,B
	LD	(TIMSL$),A	;Set 55H=fast, FFH=slow
	IF	@MOD4
	LD	A,(IY+'M'-'A')	;Update the port
	OUT	(MODPORT),A
	ENDIF
FPEND	EQU	$
;*=*=*
;	Trace entry
;*=*=*
TRACE	LD	BC,1		;Init to pass by
	LD	A,B
	OR	C
	JR	Z,TROFF		;Go if suppress
	INC	A
	JR	NZ,TREND	;Go if not entered
	IF	@MOD4
	LD	DE,TRACE_INT	;pt to trace SYSRES rtn
	ENDIF
	IF	@MOD2
	LD	DE,DO_TRACE	;address
	ENDIF
	LD	C,7		;init to task 7
	@@ADTSK			;turn TRACE (ON)
	JR	TREND
TROFF	LD	C,7		;init to task 7
	@@RMTSK			;remove TRACE task
TREND	EQU	$
;*=*=*
;	Routine to handle BREAK
;*=*=*
BREAK	LD	BC,1		;init BREAK=ON
	LD	A,B
	OR	C
	JR	Z,BRKOFF	;jump if BREAK=OFF
	INC	A
	JR	NZ,BRKEND
	RES	4,(IY+'S'-'A')	;Correct system flag
	JR	BRKEND
;*****
;	disable <BREAK> key
;*****
BRKOFF	SET	4,(IY+'S'-'A')
BRKEND	EQU	$
;*=*=*
;	Date prompt suppression during BOOT
;*=*=*
DATE	LD	BC,1		;Init to pass by
	LD	A,B
	OR	C
	LD	B,0FFH		;Init to DATE Suppress
	JR	Z,DOFF		;Go if suppress
	INC	A
	JR	NZ,DATEND	;Go if not entered
	LD	B,A		;B=0 on no suppress
DOFF	CALL	GETCFG		;Get track 0, sector 2
	LD	A,B		;Get back the code byte
	LD	(DTPMT$&0FFH+SBUFF$),A
	CALL	PUTCFG
DATEND	EQU	$
;*=*=*
;	Time prompt suppression during BOOT
;*=*=*
TIME	LD	BC,1		;Init to pass by
	LD	A,B
	OR	C
	LD	B,0FFH		;Init to TIME Suppress
	JR	Z,TOFF		;Go if suppress
	INC	A
	JR	NZ,TIMEND	;Go if not entered
	LD	B,A		;B=0 on no suppress
TOFF	CALL	GETCFG		;Get track 0, sector 2
	LD	A,B		;Get back the code byte
	LD	(TMPMT$&0FFH+SBUFF$),A
	CALL	PUTCFG
TIMEND	EQU	$
;*=*=*
;	BOOT Step rate adjust
;*=*=*
BSPARM	LD	BC,-1		;P/u parm
	INC	B		;User entry?
	JR	Z,BSPEND	;Go if not entered
	LD	A,C		;Transfer parm
	CP	4
	JR	C,GUDBS		;Go if ok
	LD	HL,BADBS$
	CALL	SETERR
	JR	BSPEND
GUDBS	LD	B,A		;Save step
	CALL	GETCFG
	LD	L,70H+3		;offset to data
	LD	A,(HL)		;P/u DCT+3 parms
	AND	0FCH		;Strip off boot step
	OR	B		;Merge new
	LD	(HL),A		;Stuff back
	CALL	PUTCFG
BSPEND	EQU	$
;*****
;	BLINK parm
;*****
BLINK	LD	BC,1		;P/U parm
	LD	A,B
	OR	C
	DEC	A		;Specified?
	JR	Z,BLIEND	;Go if not
	INC	A
	JR	NZ,BLNKON	;Go if BLINK=ON
	SET	6,(IY+'V'-'A')	;  & turn off blinking
	IF	@MOD2
	LD	A,($CRSCHAR)	;get current char
	AND	1FH		;keep size only!
	JR	SETBLK		;setup
	ENDIF
	IF	@MOD4
	JR	BLIEND		;continue
	ENDIF
BLNKON	RES	6,(IY+'V'-'A')	;Turn on blinking
	CP	0FFH		;If not just BLINK,
	IF	@MOD4
	JR	NZ,SETBLK	;set user cursor
	ENDIF
	IF	@MOD2
	JR	Z,LARGE		;go if not
BLIADJ	SUB	7		;force in range 0-7
	JR	NC,BLIADJ	;go till in range
	ADD	A,7		;add back last sub
	OR	01000000B	;set blink enable 1/16
	JR	SETBLK		;continue
	ENDIF
LARGE	LD	BC,0		;  else test if large,
	INC	C		;  small, or default
	IF	@MOD2
	LD	A,01000111B	;standard cursor
	ENDIF
	IF	@MOD4
	LD	A,'_'		;standard cursor
	ENDIF
	JR	NZ,SMALPRM
	IF	@MOD2
	LD	A,01000000B	;to large
	ENDIF
	IF	@MOD4
	LD	A,8FH		;to large
	ENDIF
SMALPRM	LD	BC,0
	INC	C
	JR	NZ,SETBLK
	IF	@MOD2
	LD	A,01000101B	;small
	ENDIF
	IF	@MOD4
	LD	A,88H		;small
	ENDIF
SETBLK	LD	C,A		;Xfer cursor char to C
	LD	B,8		;Cursor update function
	@@VDCTL
BLIEND	EQU	$
;*****
;	RESTORE parameter
;*****
RPARM	LD	BC,1		;P/U parm
	LD	A,B
	OR	C
	DEC	A		;Specified?
	JR	Z,REND		;Go if not
	INC	A
	JR	NZ,RSTRON	;Go if RESTORE=on
	DB	3EH		;Make LD A,n
RSTRON	XOR	A
	LD	B,A		;Save step
	CALL	GETCFG		;Get config sector
	LD	L,RSTOR$&0FFH	;Pt to RESTORE flag
	LD	(HL),B		;Stuff back
	CALL	PUTCFG		;Put it back
REND	EQU	$
;*****
;	type ahead processing
;*****
TYPE	LD	BC,1
	LD	A,B
	OR	C
	DEC	A
	JR	Z,TYPEND	;jump if TYPE not entered
	INC	A
	JR	NZ,TYPEON	;jump if TYPE=ON
	RES	1,(IY+'D'-'A')	;Turn TYPE off
	JR	TYPEND
TYPEON	SET	1,(IY+'D'-'A')	;Turn TYPE on
TYPEND	EQU	$
;*****
;	Process SMOOTH
;*****
SMOOTH	LD	BC,1
	LD	A,B
	OR	C
	DEC	A
	JR	Z,SMEND		;Skip if not entered
	INC	A
	JR	NZ,SMON
	IF	@MOD4
	RES	3,(IY+'D'-'A')	;Show OFF in DFLAG$
	LD	A,00		;Set to store NOP
	LD	(FDDINT$),A	; put it there
	ENDIF
	JR	SMEND
SMON	EQU	$
	IF	@MOD4
	SET	3,(IY+'D'-'A')	;Show ON in DFLAG$
	LD	A,0F3H		;DI opcode
	LD	(FDDINT$),A	; put it there
	ENDIF
SMEND	EQU	$
;*****
;  	Routine to process HERTZ selection
;*****
HERTZ50	LD	BC,1
	LD	A,B
	OR	C
	DEC	A		;Check if parm entered
	JR	Z,HZ50END
	LD	A,25
	LD	(HERTZ$),A	;Put value in timer code
HZ50END	EQU	$
HERTZ60	LD	BC,1
	LD	A,B
	OR	C
	DEC	A		;check if parm entered
	JR	Z,HZ60END	;go if not
	LD	A,30		;Value for 60 hertz use
	LD	(HERTZ$),A	; load it to timer
HZ60END	EQU	$
;*=*=*
;	Routine to process GRAPHIC
;*=*=*
GRAPHI	LD	BC,1		;Init for bypass
	LD	A,B
	OR	C
	DEC	A		;Check if parm entered
	JR	Z,GRAEND	;Go if not entered
	INC	A		;Test of GRAPHIC=off
	JR	Z,GROFF		;Go if off
	SET	7,(IY+'D'-'A')	;Else turn on
	JR	GRAEND
GROFF	RES	7,(IY+'D'-'A')	;Turn graphic off
GRAEND	EQU	$
;*=*=*
;	Routine to process ALIVE
;*=*=*
ALIVE	LD	BC,1
	LD	A,B
	OR	C
	DEC	A
	JR	Z,ALVEND	;bypass if parm omitted
	INC	A
	JR	NZ,ALIVEON	;jump if ALIVE=ON
	IF	@MOD2
	LD	C,6		;slot alive
	ENDIF
	IF	@MOD4
	LD	C,3		;slot alive
	ENDIF
	@@RMTSK
	JR	ALVEND
;
ALIVEON	EQU	$
	IF	@MOD2
	LD	C,6		;slot alive
	LD	DE,DO_ALIVE	;task address
	@@ADTSK			;add task
	ENDIF
	IF	@MOD4
	CALL	GOTMEM?		;is HIGH$ frozen?
	JP	C,NOMEM
	CALL	GETHI$
	LD	(ALVBGN+2),HL	;Stuff last byte used
	LD	BC,ALVEND-ALVBGN
	XOR	A
	SBC	HL,BC
	LD	B,0
	@@HIGH$			;Stuff new HIGH$
	INC	HL		;Point to module start
	PUSH	HL		;Save start
	LD	C,ALVTCB-ALVBGN+2
	ADD	HL,BC		;Point to alive task
	LD	(ALVTCB),HL	;  & stuff ALIVE TCB
	EX	(SP),HL		;Rcvr start of module
	EX	DE,HL		;  into DE
	LD	HL,ALVBGN
	LD	BC,ALVEND-ALVBGN
	LDIR			;Move to high memory
	POP	DE		;Rcvr start of task
	DEC	DE		;Back up to TCB
	DEC	DE
	LD	C,3		;add as task 3
	@@ADTSK
	JR	ALVEND
	ENDIF
;*=*=*
;	ALIVE high memory module
;*=*=*
	IF	@MOD4
ALVBGN	JR	$
	DW	$-$
	DB	5,'ALIVE'
	DW	0,0
ALVTCB	DW	0
	LD	HL,79		;Get character at 0,79
	PUSH	HL
	LD	B,1		;Set function 1
	CALL	@VDCTL
	CP	0A3H
	LD	A,93H
	JR	Z,ALIVE1
	LD	A,0A3H
ALIVE1	POP	HL
	LD	B,2		;Function to put char
	LD	C,A
	CALL	@VDCTL			;  at row,col
	RET
	ENDIF
ALVEND	EQU	$
;*=*=*
;	Routine to process SYSRES
;*=*=*
SYSRES	LD	BC,-1
	INC	B		;test if parm entered
	JP	Z,RESEND
	CALL	GOTMEM?		;Is high memory available
	JP	C,NOMEM
	LD	A,C
	OR	A
	JR	Z,BADSYS	;Cannot sysres 0
	CP	2		;Check if it is SYS2
	JR	NZ,TEST6	;go if not
	LD	HL,DCT$+4	;Point to SYSTEM DCT
	RES	7,(HL)		; allow CKDRV now
TEST6	CP	6
	JR	C,GUDSYS	;Can sysres 1-5
	CP	9
	JR	C,BADSYS	;Cannot sysres 6-8
	CP	13		;			*
	JR	NC,BADSYS	;Nothing > 12 yet
GUDSYS	PUSH	AF		;Save sysres req cod
	LD	HL,HKRES$+1	;Check if the driver	*
	LD	E,(HL)		; is already resident
	INC	HL
	LD	D,(HL)
	LD	HL,CKMOD@	;Standard address	*
	OR	A		;reset carry
	SBC	HL,DE		;No driver if =
	JR	Z,PUTDVR
	LD	HL,-32		;Find restab$ pos
	ADD	HL,DE		;Pt to vector table
	RLCA			;Request x 2
	ADD	A,L
	LD	L,A
	JR	NC,$+3
	INC	H		;RESTAB$ + entry index
	INC	HL		;Pt to hi order
	LD	A,(HL)		;P/u hi order
	OR	A
	JR	Z,MOVITIN
	LD	HL,MODRES$
	DB	0DDH
BADSYS	LD	HL,BADSYS$
	CALL	SETERR		;Log & Set error
	POP	AF		;stack integrity
	JP	GETSEC2
RES1	JR	$		;No real entry
	DW	$-$		;Last used
	DB	4,'SYS '
	DW	0,0
RES1E	EQU	$-1
MOVITIN	LD	(OVRLY$),A	;Show no overlay res
	POP	AF		;rcvr requested SYS
	PUSH	AF
	ADD	A,2		;adjust for dec
	OR	80H		;set Sys request
	PUSH	HL		;Save restab$ addr
	CALL	CKMOD@		;Load SYSn, no exec
	CALL	GETHI$		;P/u HIGH$
	LD	(RES1+2),HL
	EX	DE,HL
	LD	BC,(MAXCOR$-2)	;P/u length of SYSx
	LD	HL,1E00H	;pt to end of overlay
	ADD	HL,BC
	DEC	HL		;Point to last byte
	PUSH	BC		;Save length
	LDDR
	POP	BC		;Rcvr length of SYSx
	LD	A,B		;  & stuff in front
	LD	(DE),A		;  of SYSRESed module
	DEC	DE
	LD	A,C
	LD	(DE),A
	POP	HL		;Rcvr RESTAB ptr
	LD	(HL),D		;save hi order addr
	DEC	HL
	LD	(HL),E		;save low order addr
	POP	AF		;Rcvr module requested
	CP	10		;Convert to ASCII
	JR	C,$+4
	ADD	A,7
	ADD	A,'0'
	LD	HL,RES1+8
	LD	(HL),A		;Stuff module name
	DEC	DE		;Pt to 1st free byte
				;  & move in the
	LD	BC,13		;  linkage protocol
	LD	HL,RES1E
	LDDR
	EX	DE,HL
	@@HIGH$			;Stuff new HIGH$ (B=0)
	JP	RESEND
PUTDVR	CALL	GETHI$		;p/u high mem
	LD	(RESBGN+2),HL	;Stuff last used
	LD	BC,RESEND-RESBGN
	SBC	HL,BC		;make space for driver
	LD	B,0
	@@HIGH$			;Stuff new value
	PUSH	HL		;Save new HIGH$
	LD	DE,13		;pt to RESTAB$-3
	ADD	HL,DE
	LD	(RESD1+1),HL	;stuff ptr to RESTAB$-3
	POP	HL
	INC	HL		;resbgn
	PUSH	HL
	EX	DE,HL		;Where it goes to DE
	LD	HL,RESBGN	;Where it's now
	LDIR			;move up to high
	POP	HL		;Rcvr where it got to
	LD	DE,32+RESTAB$-RESBGN ;index start of dvr
	ADD	HL,DE		;pt to driver entry
	LD	(HKRES$+1),HL	;Hook into SYS0		*
	POP	AF		;Rcvr code & loop
	JP	GUDSYS		; to get the request
RESBGN	JR	$		;No real entry
	DW	$-$
	DB	6,'SYSRES'
	DW	0,0
RESTAB$	DW	1,0,0,0,0,0,1,1
	DW	0,0,0,0,0,0,0,0
RESDVR	PUSH	HL
	PUSH	AF		;Save SYS needed
	LD	HL,OVRLY$	;Check if already in
	XOR	(HL)		; overlay area
	AND	0FH		;strip garbage
	JR	Z,NOTRES
	POP	AF
RESD1	LD	HL,RESTAB$+1	;p/u table ptr
	PUSH	AF
	AND	0FH		;Check if in high mem
	RLCA			;x 2
	ADD	A,L
	LD	L,A
	JR	NC,$+3
	INC	H
	LD	A,(HL)		;p/u hi order
	OR	A
	JR	Z,NOTRES	;Go if not in high
	DEC	HL		;Pt to low
	LD	L,(HL)		;p/u lo order vector
	LD	H,A		;xfer hi order
	PUSH	DE		;SAve these regs
	PUSH	BC
	LD	C,(HL)		;P/u module length
	INC	HL		;  into BC
	LD	B,(HL)
	INC	HL		;Point to module start
	LD	DE,1E00H	;Point to overlay region
	LD	(HKRES$+9),DE	;Upd TRAADR		*
	PUSH	BC		;Save the length
	LDIR
	POP	HL		;Rcvr the length
	LD	(MAXCOR$-2),HL	;Stuff pointer
	POP	BC		;Restore regs
	POP	DE
	POP	AF
	LD	(HKRES$+4),A	;Show its resident
	POP	HL		;  in tempy loc'n
	RET
NOTRES	POP	AF
	POP	HL
	JP	CKMOD@
RESEND	EQU	$
;*=*=*
;	Routine to process DRIVE parameter
;*=*=*
GETSEC2	LD	A,(CYLPRM+1)	;If CYL=c entered,
	OR	A		;Get config sector
	CALL	NZ,GETCFG
DRIVE	LD	BC,-1
	LD	IX,SBUFF$+70H	;Pt to DCT sector fields
	LD	IY,DCT$		;init to do all DCT$'s	*
	INC	B
	JR	Z,CKEI		;Go if Drive not entered
	LD	A,C
	CP	8		;Drive in range?
	JP	NC,PRMERR	;Go if > 7
	@@GTDCT			;Get its DCT
	PUSH	IY		;save the DCT address
CKEI	EQU	$
;
ADJEI	PUSH	IY		;Calc IY offset into
	POP	HL		;  DCTs to adjust IX
	LD	DE,-DCT$	;  without affecting IY	*
	ADD	HL,DE
	EX	DE,HL
	ADD	IX,DE
DRVLOOP	EQU	$
;*=*=*
;	Routine to process WP parameter
;*=*=*
WPARM	LD	BC,1
	LD	A,B
	OR	C
	DEC	A
	JR	Z,WPEND
	INC	A
	JR	Z,WPOFF
WPON	SET	7,(IY+3)	;Turn on write protect
	JR	WPEND
WPOFF	RES	7,(IY+3)	;Turn off write protect
WPEND	EQU	$
;*=*=*
;	Routine to process CYL parameter
;*=*=*
CYLPRM	LD	BC,0
	LD	A,B
	OR	C
	JR	Z,CYLEND	;Go if parm not entered
	BIT	5,(IX+3)	;If drive is 8",
	JR	Z,CYL1		;  can't do it
	LD	A,(DRIVE+1)	;If drive entered,
	OR	A		;  give error msg
	LD	HL,NOCYL8$
	CALL	NZ,SETERR	;Msg if DRIVE=d
	JR	DISABL
CYL1	LD	A,C		;P/u user entry
	DEC	A
	CP	34
	JR	C,BADCYL	;Go if bad
	CP	96		;Max for 5-1/4" floppy
	JR	C,GUDCYL	;Good if 1-96
BADCYL	LD	HL,BADCYL$
	CALL	SETERR
	XOR	A		;Turn off cyl parm so
	LD	(CYLPRM+1),A	;  SYSINFO not written
	JR	DISABL
GUDCYL	LD	(IX+6),A	;Stuff default DCT
CYLEND	EQU	$
;*=*=*
;	Routine to process DISABL parameter
;*=*=*
DISABL	LD	BC,0
	LD	A,B
	OR	C
	JR	Z,ENABLE	;Go if not DISABLE
	LD	A,(DRIVE+1)	;don't permit disable
	INC	A		; if DRIVE parm not
	JR	Z,STEP		; entered
	LD	A,0C9H
	JR	ENADIS
ENABLE	LD	BC,0
	LD	A,B
	OR	C
	JR	Z,STEP		;Go if not ENABLE
	LD	A,0C3H
ENADIS	LD	(IY),A
;*=*=*
;	Routine to process STEP parameter
;*=*=*
STEP	LD	BC,-1
	INC	B
	JR	Z,STEPEND	;Go if STEP not entered
	LD	A,C
	CP	4
	JP	NC,PRMERR
	BIT	4,(IY+4)	;alien controller?
	JR	NZ,WDESD	;Bypass if alien
	LD	A,(IY+3)	;Update Step rate
	AND	0FCH
	OR	C
	LD	(IY+3),A
STEPEND	EQU	$
;*=*=*
;	Routine to process DELAY parameter
;*=*=*
DELAY	LD	BC,1
	LD	A,B
	OR	C
	DEC	A
	JR	Z,CKDRV		;Go if no delay entered
	INC	A
	LD	B,0		;init delay=on
	JR	NZ,DELAY1
	LD	B,4		;init delay=off
DELAY1	LD	A,(IY+3)	;Update delay
	AND	0FBH
	OR	B
	LD	(IY+3),A
;*=*=*
;	Routine to process CKDRV parameter
;*=*=*
CKDRV	LD	BC,1
	LD	A,B
	OR	C
	DEC	A
	JR	Z,WDESD		;Go if no ckdrv entered
	INC	A
	LD	B,0		;init ckdrv=on
	JR	NZ,CKDRV1
	LD	B,80H		;init ckdrv=off
CKDRV1	LD	A,(IY+4)	;Update ckdrv bit '7'
	AND	7FH
	OR	B
	LD	(IY+4),A
WDESD	LD	A,(DRIVE+1)
	INC	A
	JR	NZ,PUTSEC2	;Go if DRIVE entered
	LD	DE,10
	ADD	IX,DE		;Advance to next DCT
	ADD	IY,DE
	PUSH	IY
	POP	HL
	LD	A,L		;Ck on end of DCTs
	CP	80+70H		;Offset is 70H
	JP	C,DRVLOOP	;loop until done
	LD	HL,0		;show no DCT given
	PUSH	HL
PUTSEC2	LD	A,(CYLPRM+1)	;If CYL=c entered
	OR	A		;  put config sector
	CALL	NZ,PUTCFG
;*=*=*
;	Routine to process DRIVER parameter
;*=*=*
DVRPARM	LD	DE,0
	LD	A,D
	OR	E
	JP	Z,DVR4		;Go if DRIVER not entered
	INC	A		;Full name given?
	JR	Z,GETN3		;Go if not & prompt
	LD	HL,FCB1+1	;Else pick it up
	PUSH	HL		;Save ptr to start
GETN1	LD	A,(DE)		;P/u name char
	CP	CR
	JR	Z,GETN2		;exit on eol
	CP	','
	JR	Z,GETN2		;exit on end of parm
	CP	'"'
	JR	Z,GETN2		;exit on closing quote
	CP	')'
	JR	Z,GETN2		;exit on end of parms
	CP	3
	JR	Z,GETN2		;exit on JCL line end
	LD	(HL),A		;else xfer the char
	INC	DE
	INC	HL
	JR	GETN1		;Loop
GETN2	LD	(HL),CR		;end with CR
	POP	HL
	JR	DVR2
GETN3	@@DSPLY	EIPMPT
	LD	HL,FCB1+1	;pt to buffer
	LD	BC,24<8
	@@KEYIN			;get filespec
	JR	NC,DVR2		;exit unless BREAK
;*=*=*
;	BREAK entered on DRIVER request
;	Reset all drive code table positions
;	if DRIVE not entered
;*=*=*
	CALL	GETCFG		;Get 0/2
	LD	HL,SBUFF$+70H-DCT$ ;Pt to tables "offset"
DDCT1	LD	A,(DRIVE+1)	;was Drive entered?
	INC	A
	POP	DE		;rcvr drive
	JR	NZ,DDCT2
	LD	DE,DCT$		;Else use all 8
DDCT2	ADD	HL,DE		;Index the specific DCT
DVRA	LD	A,E
	CP	40+70H
	LD	A,0C9H		;Disable drives 4-7
	JR	NC,DVRB
	LD	A,0C3H
DVRB	LD	(HL),A		;Stuff vector (JP/RET)
	INC	L		;Pt to default DCT+3
	INC	L
	INC	L
	INC	E		;Pt to resident DCT+3
	INC	E
	INC	E
	LD	BC,7		;Shift defaults to
	LDIR			;  resident DCT
DVRC	LD	A,(DRIVE+1)	;Test if drive entered
	INC	A
	JR	NZ,SYSPRM	;Go if yes
	LD	A,E		;Ck on end of DCTs
	CP	80+70H
	JR	NC,DVRA		;loop until all 8
	JR	SYSPRM
DVR2	LD	A,(HL)		;is first char <ENTER>?
	CP	CR
	JR	Z,DVR4		;bypass if default
	CALL	GOTMEM?
	POP	DE		;Pop to keep stack
	JP	C,NOMEM		;  straight if error
	PUSH	DE
	LD	DE,FCB1		;else fetch spec
	@@FSPEC
	LD	HL,DCTEXT
	@@FEXT			;default extension
	@@FLAGS
	SET	2,(IY+'S'-'A')	;Set RUN bit
	@@LOAD			;load the prog
	POP	DE		;recover drive table
	JP	NZ,IOERR
	PUSH	DE
	PUSH	HL		;save prog's traadr
	LD	HL,DVR4		;pt to our return
	EX	(SP),HL		;exch with his
	SET	3,(IY+'C'-'A')	;Set system request
	JP	(HL)		;go to prog
DVR4	POP	DE		;rcvr drive table
;*=*=*
;	System = new system drive
;*=*=*
SYSPRM	LD	BC,-1
	LD	A,B
	OR	C
	INC	A		;Parm entered?
	RET	Z		;exit if not
	DEC	A
	CP	8		;Drive in range?
	JP	NC,PRMERR	;Go if > 7
;*=*=*
;	Check on diskette in place
;*=*=*
	@@CKDRV
	JR	NZ,SYSP2	;Prompt if no diskette
	@@GTDCT			;Get it's DCT
;*=*=*
;	Perform minimal check for SYSTEM disk
;*=*=*
SYSP1	LD	D,(IY+9)	;P/u the dir cyl
	LD	HL,SBUFF$
	LD	E,L		;Init for GAT read
	@@RDSSC			;Read the sector
	JP	NZ,IOERR
	LD	L,0CDH		;Check the SYSTEM bit
	BIT	7,(HL)
	JR	NZ,SYSP2
	LD	HL,SBUFF$	;Point to buffer
	LD	E,5		;point to dir sec #5
	@@RDSSC			;read the sector
	LD	A,(HL)		;P/u the byte
	AND	01010000B	;check for a system file
	CP	01010000B	;and not killed
				;in this slot, (SYS1)
	JR	Z,SYSP3		;alive and a SYS file
;*=*=*
;	Diskette is not a SYSTEM diskette
;*=*=*
SYSP2	LD	A,C		;Stuff drive # in msg
	ADD	A,'0'		;Cvrt drive to ASCII
	LD	(NDSYS$+32),A
	@@DSPLY	NDSYS$		;"Need system diskette..
	LD	HL,FCB1		;Create response buffer
	LD	BC,0<8		;only  BREAK or ENTER
	@@KEYIN			;Wait for entry
	RET	C		;exit on <BREAK>
	JR	SYSPRM		;Continue to check
SYSP3	LD	HL,DCT$+4
	BIT	7,(HL)		;check the state
	RES	7,(HL)		;Enable CKDRV in DCT
	LD	HL,DCT$
	LD	DE,FCB1		;Use FCB space
	PUSH	DE		;Save where temp
	PUSH	HL		;Save where new SYSTEM
	LD	BC,10		;Save current SYS's DCT
	LDIR
	RES	7,(IY+4)	;make sure OFF
	JR	Z,NOSET		;only set if it was set
				; on the SYSTEM drive
	SET	7,(IY+4)	;CKDRV inhibit drive 0
NOSET	PUSH	IY		;New DCT to HL
	POP	HL
	POP	DE		;Rcvr SYS DCT now
	PUSH	HL		;Save where it goes
	LD	C,10
	LDIR			;New DCT into SYSTEM
	POP	DE		;P/u where old SYS goes
	POP	HL		;P/u temp address
	LD	C,10		;Move old SYS to new DCT
	LDIR
	LD	HL,NWSYS$
	JP	SETERR		;display error
;*=*=*
;	Routines to read/write the config sector
;*=*=*
PUTCFG	LD	A,53		;@WRSEC
	DB	21H		;Ignore next with LD HL,
GETCFG	LD	A,49		;@RDSEC
	IF	@MOD4
	LD	DE,2		;config sector
	ENDIF
	IF	@MOD2
	LD	DE,1<8+2	;config sector
	ENDIF
;
PUTGETC	LD	HL,SBUFF$	;system buffer
	LD	C,0		; in system drive
	RST	40		;Read or Write
	RET	Z
	POP	HL
	JP	IOERR
;*=*=*
;	Routine to get HIGH$
;*=*=*
GETHI$	LD	B,0		;Init to get HIGH$
	LD	H,B
	LD	L,B
	@@HIGH$			;Get current HIGH$
	RET
;*****
;	routine to test if HIGH$ is frozen
;*****
GOTMEM?	LD	A,(CFLAG$)	;Check if memory can
	RRCA			;  be altered
	RET
NOMEM$	DB 'No memory space available',CR
PRMERR$	DB 'Parameter error',CR
NOCYL8$	DB 'CYL=c invalid on 8" drive',CR
BADCYL$	DB 'Cylinder count out of range <35-96>',CR
BADSYS$	DB 'Can''t SYSRES requested module',CR
MODRES$	DB 'System module already resident',CR
EIPMPT	DM 'Enter DCT driver <BREAK=default> : ',3'
NWSYS$	DB 'New SYSTEM drive installed',CR
NDSYS$	DB 'Insert SYSTEM diskette in drive X!',CR
BADBS$	DB 'Boot step out of range <0-3>',CR
DCTEXT	DM	'DCT'
PRMTBL$	EQU	$
	DB	'ALIVE '
	DW	ALIVE+1
	DB	'BSTEP '
	DW	BSPARM+1
	DM	'DRIVER'
	DW	DVRPARM+1
	DB	'FAST  '
	DW	FPARM+1
	DB	'SLOW  '
	DW	SLOW+1
	DB	'SYSRES'
	DW	SYSRES+1
	DB	'SYSTEM'
	DW	SYSPRM+1
	DB	'TYPE  '
	DW	TYPE+1
	DB	'WP    '
	DW	WPARM+1
	DB	'BLINK '
	DW	BLINK+1
	DB	'BREAK '
	DW	BREAK+1
	DB	'CYL   '
	DW	CYLPRM+1
	DB	'DATE  '
	DW	DATE+1
	DB	'DELAY '
	DW	DELAY+1
	DB	'CKDRV '
	DW	CKDRV+1
	DB	'DISABL'
	DW	DISABL+1
	DB	'DRIVE '
	DW	DRIVE+1
	DB	'ENABLE'
	DW	ENABLE+1
	DB	'GRAPHI'
	DW	GRAPHI+1
	DB	'LARGE '
	DW	LARGE+1
	DB	'RESTOR'
	DW	RPARM+1
	DB	'SMALL '
	DW	SMALPRM+1
	DB	'STEP  '
	DW	STEP+1
	DB	'TIME  '
	DW	TIME+1
	DB	'TRACE '
	DW	TRACE+1
	DB	'SMOOTH'
	DW	SMOOTH+1
	DB	'HERTZ5'
	DW	HERTZ50+1
	DB	'HERTZ6'
	DW	HERTZ60+1
	NOP
	DC	25,0		;Patch space
FCB1	DC	32,0
	END	SYSTEM
