;LBSYSGEN/ASM - SYSGEN Command processing - 10/29/83
	TITLE	<SYSGEN - LDOS 6.2>
;*=*=*
;	Change log
; 01/06/83 - Added DRIVE parameter
; 09/09/83 - SYSGEN SVCs 120-127 (ARCNET and USRSVCs)
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
; 10/28/83 - Reorganized code & added <BREAK> cleanup. DK
;*=*=*
PAR_ERR	EQU	44		;Parameter Error
CR	EQU	13
MOD3BUF	EQU	4300H
RST28	EQU	28H
*GET	SVCMAC:3
*LIST	OFF
*GET	SYS0/EQU:2
*LIST	ON
	ORG	2400H
;
;*=*=* Save stack & call the sysgen routine *=*=*
;
SYSGEN	@@CKBRKC		;Break key down?
	JR	Z,BEGINA	;Ok if not
	LD	HL,-1		; else abort
	RET
;
BEGINA	LD	(SAVESP+1),SP	;Save the stack pointer
	CALL	SYSGEN1		;Do the SYSGEN
EXIT	LD	HL,0
SAVESP	LD	SP,$-$
	@@CKBRKC		;clear pending <BREAK>s
	RET
;
;*=*=* I/O Error Handler *=*=*
;
PRMERR	LD	A,PAR_ERR	;Parameter Error
IOERR	LD	L,A
	LD	H,0
	OR	0C0H
	LD	C,A
	@@ERROR
	JR	SAVESP
;
;*=*=* Internal Error Message Handler *=*=*
;
NOMDSK	LD	HL,NOMDSK$
	DB	0DDH
NORTES	LD	HL,NORTES$
	DB	0DDH
NOTFND	LD	HL,NOTFND$	;init none found
	DB	0DDH
NOSPL	LD	HL,NOSPL$
	DB	0DDH
NOINDO	LD	HL,NOINDO$
	DB	0DDH
NOCANDO	LD	HL,NOCANDO$
	CALL	@LOGOT
	LD	HL,-1
	JR	SAVESP		;p/u stack & clr <BREAK>
;
;
;********************************************************
;***						      ***
;*** SYSGEN1 - Save the state of the system	      ***
;***						      ***
;********************************************************
;
SYSGEN1	LD	DE,PRMTBL$
	@@PARAM
	JP	NZ,PRMERR
	@@FLAGS
;*=*=*
;	Routine to process DRIVE parameter
;*=*=*
DRIVE	LD	BC,0
	LD	A,C
	CP	8		;Drive in range?
	JP	NC,PRMERR	;Go if > 7
	OR	'0'		;Make it ASCII
	LD	(CFGSPEC),A	;  & stuff drive spec
	LD	(ATRSPEC),A
	CALL	NPARM		;Ck on yes or no entry
	JP	Z,CFGOFF	;jump if SYSGEN=OFF
	BIT	5,(IY+'S'-'A')	;can't sysgen during DO
	JP	NZ,NOINDO
	BIT	0,(IY+'D'-'A')	;Can't sysgen if spooler
	JP	NZ,NOSPL	;  is active
	BIT	4,(IY+'D'-'A')	;Can't sysgen if memdisk
	JP	NZ,NOMDSK	;  is active
	BIT	5,(IY+'C'-'A')	;CK can NOT sysgen NOW
	JP	NZ,NOCANDO
	CALL	CKRTES		;Ck if any route to file
	JP	NZ,NORTES
;*=*=*
;	Initialize a CONFIG file on disk 0
;*=*=*
	LD	DE,GENDCB
	LD	HL,GENBUF
	LD	B,0
	@@INIT			;create config file
	JP	NZ,IOERR
;*=*=*
;	Generate the file header block
;*=*=*
	LD	A,5		;put file header
	CALL	PUTOUT
	LD	A,6		;put header length
	CALL	PUTOUT
	LD	B,6		;put header name
	LD	HL,CFGNAM$
WRNAM	LD	A,(HL)
	INC	HL
	CALL	PUTOUT
	DJNZ	WRNAM
;*=*=*
;	Generate disabling of all interrupts
;*=*=*
	LD	B,1		;set block length
	LD	DE,@RST38	;set load address
	LD	HL,C9FLD	;point to block (X'C9')
	CALL	WRBLCK		;write the block
;*=*=*
;	Dump memory from (DVRHI$) to DVREND$
;*=*=*
	LD	HL,(DVRHI$)	;point to max memory
	LD	DE,DVREND$	;Point to start
	XOR	A
	SBC	HL,DE		;how much to save?
	LD	B,H
	LD	C,L
	CALL	NZ,DUMP		;file DVREND$ to top
;*=*=*
;	Dump memory from HIGH$ to top-of-memory FIRST
;*=*=*
	LD	DE,(PHIGH$)	;point to max memory
	LD	HL,0
	LD	B,L
	@@HIGH$
	EX	DE,HL
	XOR	A
	SBC	HL,DE		;how much to save?
	LD	B,H
	LD	C,L
	INC	DE
	CALL	NZ,DUMP		;file HIGH$+1 to top
;*=*=*
;	Generate all data from address table
;*=*=*
	LD	HL,ADRTBL$	;point to grab table
WRTBL	LD	C,(HL)		;p/u lo order length
	INC	HL
	LD	B,(HL)		;p/u hi order length
	INC	HL
	LD	A,B
	OR	C
	JR	Z,GENDCT	;exit on zero length
	LD	E,(HL)		;p/u lo order address
	INC	HL
	LD	D,(HL)		;p/u hi order address
	INC	HL
	PUSH	HL		;save table pointer
	CALL	DUMP		;p/u the code & file it
	POP	HL		;restore table pointer
	JR	WRTBL
;*=*=*
;	Generate the DCT$ (offset)
;*=*=*
GENDCT	LD	B,80		;Table is 80 bytes
	LD	DE,MOD3BUF	;Place to stuff DCT$
	LD	C,0
	@@GTDCT			;Write out the DCTs
	PUSH	IY		;  handled by SYS0
	POP	HL
	CALL	WRBLCK
;*=*=*
;	Generate the original interrupt vector JP
;*=*=*
INTVEC	LD	B,1		;file the interrupt
	LD	DE,@RST38	;  vector address
	LD	HL,JPINST	;  with a JP
	CALL	WRBLCK		;write the block
;*=*=*
;	Generate the transfer address
;*=*=*
	LD	A,2		;transfer address
	CALL	PUTOUT
	LD	A,2
	CALL	PUTOUT
	XOR	A		;xfer address is 0000
	CALL	PUTOUT
	XOR	A
	CALL	PUTOUT
	@@CLOSE			;close config file
	JP	NZ,IOERR
;*=*=*
;	Let the config sector know there's a CONFIG/SYS
;*=*=*
	IF	@MOD2
	LD	A,(DRIVE+1)	;drive #
	LD	C,A		;pass drive #
	LD	HL,SBUFF$	;I/O buffer
	@@GTDCT			;fetch DCT
	LD	D,(IY+9)	;get GAT address
	LD	E,0		;DE=>gat
	@@RDSEC			;read sector
	CP	6		;directory?
	JP	NZ,IOERR	;go on disk error
	LD	A,(SBUFF$+60H)	;get cyl 0 lockout byte
	INC	A		;cyl 0 locked out?
	LD	D,0		;init sys info sector
	JR	NZ,$+3		;go if not locked
	INC	D		;else sysinfo on cyl 1!
	LD	E,2		;sysinfo sector
	ENDIF
;
	LD	HL,SBUFF$
	IF	@MOD4
	LD	DE,0<8+2
	ENDIF
	LD	A,(DRIVE+1)	;P/u logical drive #
	LD	C,A		;  of drive (DRIVE)
	@@RDSEC
	JP	NZ,IOERR
	XOR	A		;turn off standard config
	LD	(SBUFF$+1),A
	@@WRSEC			;write it back
	JP	NZ,IOERR
	LD	L,0C0H		;Pt to SYS/DATA byte
	OR	(HL)
	LD	HL,WARN$
	JR	NZ,$+5
	@@LOGOT
;*=*=*
;	Let user know its done
;*=*=*
	@@LOGOT	CFGBLT		;Log completion
	LD	HL,ATRBIT	;Make CONFIG invisible
	LD	A,24		;Init for CMNDI
	JP	RST28		;  & execute
	@@CMNDI
;*=*=*
;	Routine to DUMP core
;*=*=*
DUMP	EX	DE,HL		;load address to HL
	LD	DE,GENDCB
DUMP1	PUSH	HL
	PUSH	BC		;save block length
	LD	H,B
	LD	L,C
	LD	BC,254		;write block in groups
	XOR	A		;of 254 bytes max
	SBC	HL,BC
	JR	NC,DUMP2
	POP	BC
	LD	HL,0
	JR	DUMP3
DUMP2	POP	AF
DUMP3	EX	(SP),HL
	LD	B,C
	LD	A,1		;start of block
	CALL	PUTOUT
	LD	A,B
	ADD	A,2		;add for address
	CALL	PUTOUT		;write block length
	LD	A,L
	CALL	PUTOUT		;write lo order address
	LD	A,H
	CALL	PUTOUT		;write hi order address
DUMP4	LD	A,(HL)
	INC	HL
	CALL	PUTOUT		;write the block
	DJNZ	DUMP4
	POP	BC
	LD	A,B
	OR	C
	JR	NZ,DUMP1	;loop if block not done
C9FLD	RET			;else go back
;*=*=*
;	Routine to write an offset block
;*=*=*
JPINST	DB	0C3H		;JP instruction
WRBLCK	PUSH	HL
	LD	H,D
	LD	L,E
	LD	DE,GENDCB
	LD	A,1		;start of block
	CALL	PUTOUT
	LD	A,B
	ADD	A,2		;adj for address
	CALL	PUTOUT		;write block length
	LD	A,L
	CALL	PUTOUT		;write lo order load
	LD	A,H
	CALL	PUTOUT		;write hi order load
	POP	HL
WRBLK1	LD	A,(HL)
	INC	HL
	CALL	PUTOUT		;write the block
	DJNZ	WRBLK1
	RET
;*****
;	perform SYSGEN OFF
;*****
CFGOFF	LD	HL,SBUFF$
;
	IF	@MOD2
	LD	A,(DRIVE+1)	;get drive
	LD	C,A		;pass to C
	@@GTDCT			;fetch DCT
	LD	D,(IY+9)	;dir cylinder
	LD	E,0		;GAT table
	@@RDSEC			;read sector
	CP	6		;directory read?
	JP	NZ,IOERR	;go if not
	LD	A,(SBUFF$+60H)	;cyl 0 lockout byte
	INC	A		;cyl 0 locked out?
	LD	D,0		;cyl 0 if not
	JR	NZ,$+3		;go if not
	INC	D		;else on cyl 1
	LD	E,2		;sysinfo sector
	ENDIF
;
	IF	@MOD4
	LD	DE,0<8+2
	ENDIF
	LD	A,(DRIVE+1)	;  from drive (DRIVE)
	LD	C,A		;  & note
	@@RDSEC			;  that no config is
	JP	NZ,IOERR	;  on the disk
	LD	A,0C9H
	LD	(SBUFF$+1),A	;A X'C9' indicates
	@@WRSEC			; no config
	JP	NZ,IOERR
;*=*=*
;	Now that none is shown, kill the CONFIG/SYS
;*=*=*
	LD	DE,GENDCB	;pt to FCB
	LD	B,0
	@@OPEN			;try to open the config
	JP	NZ,NOTFND	;jump if not there
	@@REMOV			;Kill the config/sys
	JP	NZ,IOERR
	@@LOGOT	CFGDEL$		;"config deleted..
	RET			;done - return
;*=*=*
;	parameter parsing of yes/no
;*=*=*
NPARM	LD	BC,0		;P/u "no" parm entry
	LD	A,B
	OR	C		;if NO, make Z
	XOR	0FFH
	RET
YPARM	DW	0
;*****
;	Any other device routes to the removed one?
;*****
CKRTES	LD	DE,'IK'		;Point to begin of area
	@@GTDCB
CKRT0	PUSH	HL		;Save pointer
CKRT1	BIT	4,(HL)		;routed device?
	JR	Z,CKRT2		;jump if not
	INC	L		;bypass TYPE code
	LD	A,(HL)		;p/u route vector
	INC	L		; lo-order
	LD	H,(HL)		;p/u vector hi-order
	LD	L,A
	BIT	7,(HL)		;Routed to a file?
	JR	Z,CKRT1		;Ck further route if not
	POP	HL		;  else exit with NZ
	RET
;*****
;	point to next device
;*****
CKRT2	POP	HL
	LD	A,L		;advance to next DCB area
	ADD	A,8		;loop through all
	LD	L,A		;  devices while checking
	JR	NZ,CKRT0	;Loop until table end
	RET
PUTOUT	LD	C,A
	@@PUT
	RET	Z
	JP	IOERR		;I/O Error
GENDCB	DB	'CONFIG/SYS.CCC:0',0
CFGSPEC	EQU	$-2
	DS	32-$+GENDCB
CFGNAM$	DB	'CONFIG'
CFGBLT	DB	'User configuration built',CR
ATRBIT	DB	'Attrib CONFIG/SYS.CCC:d (I)',CR
ATRSPEC	EQU	$-6
CFGDEL$	DB	'User configuration deleted',CR
NOTFND$	DB	'No user configuration found',CR
WARN$	DB 'Warning: Target drive contains no system',CR
NOINDO$	DB 'Command invalid during <DO> processing',CR
NOCANDO$	DB	'** SYSGEN inhibited at this time **',CR
NOSPL$	DB	'Can''t while SPOOL is active',CR
NOMDSK$	DB	'Can''t while MEMDISK is active',CR
NORTES$	DB	'Can''t while route-to-file is active',CR
PRMTBL$	DB	80H,42H,'ON',0
	DW	YPARM
	DB	43H,'OFF',0
	DW	NPARM+1
	DB	53H,'YES',0
	DW	YPARM
	DB	52H,'NO',0
	DW	NPARM+1
	DB	95H,'DRIVE',0
	DW	DRIVE+1
	NOP
;*=*=*
;	Table of regions to sysgen
;*=*=*
ADRTBL$	DW	2,HIGH$		;save HIGH$
	DW	2,LOW$		;Lowest user address
	DW	1,TIMSL$	;Time slice
	DW	250,DVRHI$	;save primary DCBs
	DW	3,EXTDBG$	;Ext DEBUG vector & DBGHK
	DW	50,INTIM$	;Table & TCBs
	DW	34,FLGTAB$	;Flag table & assorted
	DW	2,75*2+SVCTAB$	;save WRITE vector
	DW	3,HKRES$	;Sys overlay hook
	DW	2,KIDATA$+2
	DW	1,DODATA$
	DW	2,DODATA$+3
	DW	16,240+SVCTAB$	;SVCs 120 - 127
	DW	16,@RST08	;RST zones 8 and 10
	DW	1,HERTZ$	;Hertz rate for timer
	IF	@MOD2
	DW	1,$CRSON+1	;cursor char
	ENDIF
	IF	@MOD4
	DW	0,0
	ENDIF
	DW	0,0
	DW	0,0
	DW	0,0
	DW	0,0
	DW	0,0
	DW	0,0
	DW	0,0
	DW	0		;end of table
	DC	20,0		;patch space
	ORG	$<-8+1<+8
GENBUF	EQU	$
	END	SYSGEN
