;LBSETKI/ASM - Set Keyboard Parameters - 10/28/83
	TITLE	<SETKI - LDOS 6.2>
;*=*=*
;	Change Log
; 01/23/83 - changed Delay parm to 'WAIT'
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
; 10/28/83 - Removed unnecessary break handling code &
;          - changed code to use @CKBRKC SVC. DK
;*=*=*
OFFSET	EQU	4	;Length: end of name to data area
DELAY	EQU	OFFSET+2
RPEAT	EQU	OFFSET+3
DMIN	EQU	10
RMIN	EQU	1
DDFALT	EQU	22
RDFALT	EQU	2
ETX	EQU	03H
CR	EQU	0DH
LF	EQU	0AH
PAR_ERR	EQU	44		;Parameter Error
;
FLAG	EQU	01000000B
ABB	EQU	00010000B
NUM	EQU	10000000B
*GET	SVCMAC:3
;
	ORG	2400H
BEGIN	EQU	$
	LD	(SAVESP+1),SP
	CALL	PGRM		;Exit via RET
;*=*=*
;	Set exit conditions 
;*=*=*
$EXIT	LD	HL,0
SAVESP	LD	SP,$-$
	@@CKBRKC		;clear any <BREAK>s
	RET
$ABORT	LD	HL,-1
	JR	SAVESP
;
$DSP	@@DSP
	RET	Z
	JR	IOERR
$DSPLY	@@DSPLY
	RET	Z
	DB	21H		;Skip LD A,##
PRMERR	LD	A,PAR_ERR	;Parameter Error
;
;*=*=* I/O Error Processing *=*=*
;
IOERR	LD	H,0
	LD	L,A		;Save error #
	OR	0C0H
	LD	C,A	
	@@ERROR			;Display message
	JR	SAVESP
;
;
;********************************************************
;***						      ***
;*** PGRM - Set Keyboard Parameters		      ***
;***						      ***
;********************************************************
;
PGRM	PUSH	HL
	LD	DE,MDNAME
	@@GTMOD			;Find module header
	LD	A,8		;Device not available
	JP	NZ,IOERR	;Exit if not found
	PUSH	DE		;Point to next byte
	POP	IX		;  after module name
;
	POP	HL		;=>cmd line
	CALL	SKSP		;Move to non-space
	LD	A,(HL)		;Char fm cmd line
	CP	'('		;Any params?
	JP	Z,GETNEW	;Get/set new values
;*=*=*
;	Display old values
;*=*=*
	CALL	SETMSG
	LD	HL,DMSG
	JP	$DSPLY		;Done
;*=*=*
;	set up values in string
;*=*=*
SETMSG	LD	A,(IX+DELAY)	;P/u old value
	LD	DE,DDELAY	;=>buffer to receive
	CALL	HEXDEC		;To ASCII decimal
	LD	A,(IX+RPEAT)
	LD	DE,DRPEAT
	JP	HEXDEC
;
GETNEW	LD	DE,PRMTBL$
	@@PARAM
	JP	NZ,PRMERR
	LD	DE,$-$
DFPARM	EQU	$-2
	LD	A,D		;Default setting wanted?
	OR	E
	JR	Z,SETSTR	;Keep existing
	LD	(IX+DELAY),DDFALT	;Stuff defaults
	LD	(IX+RPEAT),RDFALT
SETSTR	CALL	SETMSG		;Put numbers in string
QCHK	LD	DE,$-$
QPARM	EQU	$-2		;QUERY?
	LD	A,D
	OR	E
	JR	Z,CKPARM
;
	LD	A,(WRESP)
	AND	NUM		;If a "D" number given,
	JR	NZ,CKR		;  then ask for R only
GETD	LD	HL,DMSG
	CALL	SHOW		;Ask for D time
	CALL	GETIT		;Get it (in DE)
	JR	Z,CKR		;Don't change if CR only
	CALL	DCHECK		;Check if good value
	JR	NZ,GETD		;Don't change if not
	LD	(IX+DELAY),A
;
CKR	LD	A,(RRESP)
	AND	NUM
	JR	NZ,CKPARM	;See what was on cmd line
	LD	HL,RMSG
	CALL	SHOW
	CALL	GETIT
	JR	Z,CKPARM
	CALL	RCHECK		;Check range & don't
	JR	NZ,CKR		;  change if out of range
	LD	(IX+RPEAT),A
;
;Set entries given on cmd line
CKPARM	LD	A,(WRESP)
	AND	NUM
	JR	Z,CKRP
	LD	DE,$-$
WPARM	EQU	$-2
	CALL	DCHECK
	JP	NZ,PRMERR
	LD	(IX+DELAY),A
;
CKRP	LD	A,(RRESP)
	AND	NUM
	RET	Z		;Done
	LD	DE,$-$
RPARM	EQU	$-2
	CALL	RCHECK
	JP	NZ,PRMERR
	LD	(IX+RPEAT),A
	RET			;Done
;
SHOW	LD	B,12		;Col posn
SH2	LD	C,(HL)
	CALL	$DSP		;Print byte fm string
	DEC	B
	INC	HL
	LD	A,'='
	CP	C
	JR	NZ,SH2		;Display up to =
	LD	C,' '		;Then space
	CALL	$DSP
	CALL	SKSP		;Move to number
	LD	C,'{'
	CALL	$DSP		;Enclose
SH3	LD	C,(HL)
	LD	A,'0'-1
	CP	C
	JR	NC,SH4		;Number
	CALL	$DSP
	DEC	B
	INC	HL
	JR	SH3
SH4	LD	C,'}'
	CALL	$DSP
	LD	C,' '
SH5	CALL	$DSP		;Tab remaining distance
	DJNZ	SH5
	LD	HL,ENDSTR	;Print ?
	JP	$DSPLY
;
SKSP	LD	A,' '
SKP2	CP	(HL)
	RET	NZ
	INC	HL
	JR	SKP2
;
;*****
;
DMSG	DB	'Wait   = '
DDELAY	DB	'   , '
RMSG	DB	'Rate   = '
DRPEAT	DB	'   ',CR
MDNAME	DB	'$KI',ETX
ENDSTR	DB	'? ',ETX
;*****
PRMTBL$	DB	80H
;
	DB	FLAG!ABB!7
	DB	'DEFAULT'
	DB	0
	DW	DFPARM
;
	DB	ABB!NUM!4
	DB	'RATE'		;Repeat key rate
RRESP	DB	0
	DW	RPARM	
;
	DB	ABB!NUM!4
	DB	'WAIT'		;Delay before repeat
WRESP	DB	0
	DW	WPARM
;
	DB	ABB!FLAG!5
	DB	'QUERY'
	DB	0
	DW	QPARM
;
	NOP			;Note end of parm table
;
;***
;       HEXDEC - Convert Hex Number to Decimal ASCII
;       A => 8-bit Hex Number to Convert
;       DE => Destination of ASCII characters
;***
;
HEXDEC	PUSH	BC		;Save regs
	PUSH	HL		;
	PUSH	AF		;
;
;*=*=* Xfer number to HL *=*=*
;
	LD	H,0		;Set HL = #
	LD	L,A		;
;
	LD	A,' '
	LD	BC,100
	CALL	CVD1
	LD	BC,10
	CALL	CVD1
	LD	A,L
	ADD	A,'0'
	LD	(DE),A
;
	POP	AF		;Recover #
	POP	HL		;And other regs
	POP	BC		;
	RET
;
CVD1	PUSH	DE
	LD	E,A
	LD	D,0FFH
	XOR	A
CVD2	INC	D
	SBC	HL,BC
	JR	NC,CVD2
	ADD	HL,BC
	LD	A,E
	LD	B,D
	POP	DE
	LD	(DE),A
	INC	B
	DEC	B
	JR	Z,CVD3
	LD	A,B
	ADD	A,'0'
	LD	(DE),A
	LD	A,'0'
CVD3	INC	DE
	RET
;
RCHECK	LD	D,RMIN
	JR	CHECK
DCHECK	LD	D,DMIN
CHECK	LD	A,E		;Get number
	AND	7FH		;Keep positive
	CP	D		;Lowest allowed
	RET	C		;Too low
	CP	A		;Set Z if good value
	RET
;
GETIT	LD	HL,INBUF	
	LD	BC,3<8
	@@KEYIN
	JP	C,$ABORT
;***
;*** DECHEX - Decimal ASCII to Hex
;*** DE <= returns the Hex num
;*** HL => points to the start of Dec asc string
;*** A <= # of characters converted
;***
;
DECHEX	LD	B,0
	LD	D,B
	LD	E,B
CVDEC	LD	A,(HL)
	SUB	30H
	CP	10
	JR	NC,DONECON
	PUSH	HL
	LD	H,D
	LD	L,E
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,DE
	ADD	HL,HL
	EX	DE,HL
	ADD	A,E
	LD	E,A
	LD	A,0
	ADC	A,D
	LD	D,A
	POP	HL
	INC	HL
	INC	B
	JR	CVDEC
DONECON	LD	A,B
	OR	A
	RET
INBUF	EQU	$
;
	END	BEGIN
