;LBSETCOM/ASM - Set RS232 Parameters - 11/11/83
;
	TITLE	'<SETCOM - LDOS 6.2>'
;****
;	Change Log
;
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
; 10/28/83 - Removed unnecessary break handling code &
;          - changed code to use @CKBRKC SVC. DK
;
;****
;	data area offsets
;
OFFSET	EQU	4
MSMASK	EQU	OFFSET+0
UCIMAGE	EQU	OFFSET+1
BAUDRT	EQU	OFFSET+2
BRK	EQU	OFFSET+3
;
;	default settings
;
DEFMS	EQU	000H
DEFUC	EQU	0A5H
DEFBA	EQU	055H
DEFBR	EQU	003H
;
;	ASCII/init equivalences
;
_INIT	EQU	02H		;Ctl value to init driver
_ETX	EQU	03H
_CR	EQU	0DH
_LF	EQU	0AH
_APOS	EQU	27H
PAR_ERR	EQU	44		;Parameter Error
;
;	@PARAM evaluation types
;
FLAG	EQU	01000000B
ABB	EQU	00010000B
NUM	EQU	10000000B
STR	EQU	00100000B
;
*GET	SVCMAC:3		;macro definitions
;
	ORG	2400H
BEGIN	EQU	$
	LD	(SAVESP+1),SP	;save entry stack
	CALL	PGRM		;perform operations
;
;	set up exit condition
;
$EXIT	LD	HL,0		;No errors
SAVESP	LD	SP,$-$
	@@CKBRKC		;clear <BREAK>s
	RET
;
;	abort program
;
$ABORT	LD	HL,-1		;init error return
	JR	SAVESP		;exit program
;
;	display char in C
;
$DSP	@@DSP			;display
	RET	Z		;return if NO error
	JR	IOERR		;else error!
;
;	display text @ (HL)
;
$DSPLY	@@DSPLY			;display
	RET	Z		;return if NO error
;
;	I/O error, display what
;
IOERR	LD	L,A		;Save error code
	OR	0C0H		;set return+short message
	LD	C,A		;pass error code
	@@ERROR			;display error
;
ERROR$	LD	H,0		;set exit code
	JR	SAVESP		;terminate program
;
BADMOD	LD	HL,BADDCB	;'COM/DVR not installed'
	@@LOGOT			;log error
	LD	L,8		;'device not available'
	JR	ERROR$		;Return error in HL
;
;	parameter error
;
PRMERR	LD	A,PAR_ERR	;"Parameter Error"
	JP	IOERR		;later
;
;
;********************************************************
;***						      ***
;*** PGRM - Set up RS-232 Parameters		      ***
;***						      ***
;********************************************************
;
PGRM	EQU	$
;
	IF	@MOD4
	PUSH	HL		;save command line pntr
	LD	DE,MDNAME	;$CL name header
	@@GTMOD			;Find module header
	JR	NZ,BADMOD	;Exit if not found
	PUSH	DE		;pass pointer to IX
	POP	IX		;IX=>next byte after
	POP	HL		;=>cmd line
	ENDIF
;
;	check if any parameters entered
;
	DEC	HL		;setup for immed INC
SPLP	INC	HL		;bump to next char
	LD	A,(HL)		;fetch input char
	CP	' '		;nil char?
	JR	Z,SPLP		;ignore if space
	CP	'('		;param marker?
	JP	NZ,SHOW		;No, show settings 
;
	LD	DE,PRMTBL$	;parameter table
	@@PARAM			;evaluate user input
	JP	NZ,PRMERR	;go if parameter error
;
	IF	@MOD2
	LD	A,(PORTP)	;get port param
	OR	A		;anything input?
	LD	DE,MDNAME1	;$CL
	JR	Z,PORTF		;go default
	LD	BC,(PORTD)	;get port value
	INC	B		;test msb
	DEC	B
	JR	NZ,PRMERR	;param error if >256!
	LD	A,C		;get lsb
	OR	A		;0?
	JR	Z,PRMERR	;go if yes
	DEC	A		;1?
	JR	Z,PORTF		;yes, $CL
	DEC	A		;2?
	JR	NZ,PRMERR	;param error if not
	LD	DE,MDNAME2	;$CM
PORTF	@@GTMOD			;locate it
	JR	NZ,BADMOD	;go if not found
	PUSH	DE		;else pass to IX
	POP	IX		;IX => block
	ENDIF
;
;	check if DEFAULT param entered
;
	LD	DE,(DFPARM)	;get user input
	LD	A,D		;get msb
	OR	E		;DE=0 (not entered?)
	CALL	NZ,DEFALT	;Stuff default data image
;
	LD	DE,(QPARM)	;query param
	LD	A,D		;check input
	OR	E		;DE=0000 (not entered?)
	JP	Z,CKPARM	;check input if not query
;
;	prompt user for input not entered on command line
;
;	fetch BAUD
;
ASKBAUD	LD	HL,DMSG2	;BAUD param display
	LD	DE,BTYP		;BAUD param
	CALL	GETIT		;get user input
	JR	NC,ASKWORD	;continue on ENTER
	CALL	CKBAUD		;Test response for valid
	JR	Z,ASKWORD	;Move on if valid entry
BADBAUD	XOR	A		;else clear
	LD	(BRESP),A	;Clear for re-try
	JR	ASKBAUD		;Bad entry - retry
;
;	fetch WORD
;
ASKWORD	LD	HL,DMSG3	;WORD display
	LD	DE,WTYP		;param type
	CALL	GETIT		;get user input
	JR	NC,ASKSTOP	;nil input, leave it
	LD	A,(WORDP)	;fetch input
	CP	5		;<5?
	JR	C,BADWORD	;Bad entry
	CP	8+1		;>8?
	JR	C,ASKSTOP	;go if OK
BADWORD	XOR	A		;clear param
	LD	(WRESP),A	;load flag
	JR	ASKWORD		;Re-try
;
;	fetch STOP
;
ASKSTOP	LD	HL,DMSG4	;STOP
	LD	DE,STYP		;=>type byte
	CALL	GETIT		;get user input
	JR	NC,ASKPAR	;nil input, leave it
	LD	A,(STOPP)	;Chk range
	OR	A		;0?
	JR	Z,BADSTOP	;invalid if yes
	CP	2+1		;>1?
	JR	C,ASKPAR	;go if OK
BADSTOP	XOR	A		;load zero
	LD	(SRESP),A	;clear input param
	JR	ASKSTOP		;ask again
;
;	fetch PARITY
;
BADPAR	XOR	A		;load zero
	LD	(PRESP),A	;clear response byte
ASKPAR	LD	HL,DMSG5	;PARITY display driver
	LD	DE,PTYP		;param type
	CALL	GETIT		;get user input
	JR	NC,ASKBRK	;nil input, leave
;
;	check if user entered 'O' or 'E' or ON/OFF
;
	LD	A,(PRESP)	;get response byte
	LD	DE,(PARITYP)	;get param pointer
	BIT	6,A		;switch?
	JR	NZ,ASKBRK	;yes, continue
;
;	check for ODD/EVEN input
;
	LD	A,(DE)		;get input
	CALL	UCASE		;make upper case
	CP	'E'		;even?
	JR	Z,ASKBRK	;continue if yes
	CP	'O'		;odd?
	JR	NZ,BADPAR	;invalid, re-prompt
;
;	fetch BREAK
;
ASKBRK	LD	HL,DMSG6	;display sub
	LD	DE,BRTYP	;param type
	CALL	GETIT		;get input
;
;	fetch DTR
;
ASKDTR	LD	HL,DMSG8	;display driver
	LD	DE,DTYP		;param type
	CALL	GETIT		;get input
;
;	fetch RTS
;
ASKRTS	LD	HL,DMSG9	;display driver
	LD	DE,RTYP		;param type
	CALL	GETIT		;get input
;
;	fetch RI
;
ASKRI	LD	HL,DMSG11	;display driver
	LD	DE,RITYP	;param type
	CALL	GETIT		;get user input
;
;	fetch DSR
;
ASKDSR	LD	HL,DMSG12	;display driver
	LD	DE,DSTYP	;param type
	CALL	GETIT		;get user input
;
;	fetch CD
;
ASKCD	LD	HL,DMSG13	;display driver
	LD	DE,CDTYP	;param type
	CALL	GETIT		;get user input
;
;	fetch CTS
;
ASKCTS	LD	HL,DMSG14	;display driver
	LD	DE,CTTYP	;param type
	CALL	GETIT		;get response from user
;
;	check params and issue INIT to device
;
CKPARM	CALL	SETPARAM	;check entered params
	LD	E,(IX+0)	;pickup DCB address lsb
	LD	D,(IX+1)	;pickup DCB address msb
	LD	C,_INIT		;init code
	@@CTL			;setup channel for values
	RET			;completed!
;
;	display drivers for text
;
DMSG1	LD	HL,MSG1		;RS232 params:
	CALL	$DSPLY		;display and return
	LD	(HL),_LF	;Set for next time
	RET
;
DMSG2	LD	HL,MSG2		;BAUD=
	CALL	$DSPLY		;display
	LD	A,(IX+BAUDRT)	;get baud rate
	AND	0FH		;low 4 bits only
	ADD	A,A		;*2
	LD	HL,BAUDTBL	;baud lookup table
	ADD	A,L		;add to lsb table
	LD	L,A		;update lsb table
	JR	NC,$+3		;go if no page cross
	INC	H		;else bump page
	LD	A,(HL)		;get LSB baud
	INC	HL		;bump table pointer
	LD	H,(HL)		;get MSB baud
	LD	L,A		;HL = baud rate
	LD	DE,MSG20	;text to load
	@@HEXDEC		;convert to decimal
	LD	A,_ETX		;end text char
	LD	(DE),A		;terminate text
;
;	strip leading zeroes from display
;
	LD	HL,MSG20	;text loaded
	LD	A,' '		;test char
STRIP1	CP	(HL)		;leading zero?
	INC	HL		;bump pointer
	JR	Z,STRIP1	;go till non-zero found
	DEC	HL		;adjust pointer
	JP	$DSPLY		;display remainder
;
DMSG3	LD	HL,MSG3		;WORD=
	CALL	$DSPLY		;display header
	LD	A,(IX+UCIMAGE)	;get data
	RLCA			;align to low bits
	RLCA
	RLCA
	AND	3		;2 bits only
	JP	PE,$+5		;go if set
	XOR	3		;else reverse 6/7
	ADD	A,5+'0'		;correct + ascii
	LD	C,A		;pass char
	JP	$DSP		;display and return
;
DMSG4	LD	HL,MSG4		;STOP=
	CALL	$DSPLY		;display header
	LD	C,'1'		;set one bit
	BIT	4,(IX+UCIMAGE)	;get data
	JR	Z,$+3		;go if one stop
	INC	C		;else bump to '2'
	JP	$DSP		;display and return
;
DMSG5	LD	HL,MSG5		;PARITY=
	CALL	$DSPLY		;display
	LD	HL,MSG16	;OFF
	BIT	3,(IX+UCIMAGE)	;is off?
	JP	NZ,$DSPLY	;yes, go!
	LD	HL,MSG17	;ODD
	BIT	7,(IX+UCIMAGE)	;is odd?
	JR	Z,$+5		;go if yes
	LD	HL,MSG18	;EVEN
	JP	$DSPLY		;display and return
;
DMSG6	LD	HL,MSG6		;BREAK=
	CALL	$DSPLY		;display header
	LD	C,(IX+BRK)	;get break char
	LD	HL,MSG21A	;text to load
	@@HEX8			;convert to ascii
	LD	HL,MSG21	;text start
	JP	$DSPLY		;display and return
;
DMSG7	LD	HL,MSG7		;input:
	JP	$DSPLY		;display and return
;
DMSG8	LD	HL,MSG8		;DTR=
	CALL	$DSPLY		;display
	BIT	1,(IX+UCIMAGE)	;is on?
	JR	DMSG89		;display
;
DMSG9	LD	HL,MSG9		;RTS=
	CALL	$DSPLY		;display header
	BIT	0,(IX+UCIMAGE)	;is on?
;
DMSG89	LD	HL,MSG15	;ON?
	JR	Z,$+5		;go if yes
	LD	HL,MSG16	;OFF
	JP	$DSPLY		;display and return
;
DMSG10	LD	HL,MSG10	;output:
	JP	$DSPLY		;display and return
;
DMSG11	LD	HL,MSG11	;RI=
	LD	A,00010001B	;enable bits
	JR	DMSG0		;go common
;
DMSG12	LD	HL,MSG12	;DSR=
	LD	A,01000100B	;enable bits
	JR	DMSG0		;go common
;
DMSG13	LD	HL,MSG13	;CD=
	LD	A,00100010B	;enable bits
	JR	DMSG0		;go common
;
DMSG14	LD	HL,MSG14	;CTS=
	LD	A,10001000B	;enable bits
;
DMSG0	PUSH	AF		;save bits
	CALL	$DSPLY		;display prefix
	POP	AF		;restore
	AND	(IX+MSMASK)	;and with mask
	LD	HL,MSG19	;IGNORE
	JR	Z,DMSG0X	;go if yes
	LD	HL,MSG15	;ON
	JP	PO,DMSG0X	;go if yes
	LD	HL,MSG16	;OFF
DMSG0X	JP	$DSPLY		;display and return
;
DMSG22	LD	HL,MSG22	;CR
	JP	$DSPLY		;display and return
;
DMSG23	LD	HL,MSG23	;', '
	JP	$DSPLY		;display and return
;
;	display entire parameter set
;
DSPALL	PUSH	IY		;save
	LD	IY,DSPTBL	;display table
DSPSET	LD	L,(IY+0)	;get lsb vector
	LD	H,(IY+1)	;get msb vector
	LD	A,H		;check for term
	OR	L		;HL = 0000?
	JR	Z,DSPDONE	;yes, go!
	PUSH	HL		;save address
	LD	HL,DSPRET	;return vector
	EX	(SP),HL		;leave return, get vector
	JP	(HL)		;display
DSPRET	INC	IY		;bump table
	INC	IY		;2 byte entries
	JR	DSPSET		;continue
DSPDONE	POP	IY		;restore
	RET			;display complete
;
;	QUERYing for parameter
;
GETIT	PUSH	HL		;Save display driver
	PUSH	DE		;Save type byte
	EX	DE,HL		;Type byte to HL
	CALL	CKRSP		;check if response enterd
	POP	DE		;Restore type byte
	POP	HL		;Restore prompt
	RET	NZ		;Already have this one
;
;	setup for prompt display
;
	PUSH	HL		;save for repeat prompt
	PUSH	DE
	CALL	GETRSP		;get user response
	POP	DE		;restore data
	POP	HL
	JR	NZ,GETIT	;invalid, ask again!
	RET			;else param loaded!
;
;	check if correct response entered
;
CKRSP	LD	(TTYP),HL	;save type position
;
MVUP	LD	A,0FH		;low 4 bits for length
	LD	C,(HL)		;get type byte
	AND	C		;fetch length
UP	INC	HL		;bump pointer
	DEC	A		;less length
	JR	NZ,UP		;go for length
	INC	HL		;bump to next
	LD	A,(HL)		;get response byte
	AND	NUM!FLAG!STR	;response type bits
	AND	C		;compare to entered
	RET			;return with status
;
;	query on, param not entered, prompt for it
;
GETRSP	PUSH	HL		;save driver address
	LD	HL,GETRSPR	;return vector
	EX	(SP),HL		;leave get display driver
	JP	(HL)		;display prompt
;
GETRSPR	LD	B,4		;command get cursor
	@@VDCTL			;fetch cursor
	LD	L,20		;column to position to
	LD	B,3		;command put cursor
	@@VDCTL			;setup new cursor
	LD	HL,PROMPT	;prompt text
	CALL	$DSPLY		;display prompt
	XOR	A		;load zero
	LD	(FRESP),A	;clear response byte
;
	LD	HL,INBUF	;key input buffer
	LD	BC,10<8+0	;max input length
	@@KEYIN			;get user input
	JP	C,$ABORT	;terminate on BREAK
;
;	evaluate user input
;
	INC	B		;check if nil input
	DEC	B		;B=0?
	RET	Z		;no input, go!
;
	LD	HL,0		;get param pointer
TTYP	EQU	$-2
	LD	A,(HL)		;get response type
	AND	0F0H		;attribute only
	OR	1		;single byte char
	LD	(FTYP),A	;pass to new block
;
	LD	HL,FSTR		;set command pointer
	LD	DE,PTBL2	;mini-param table
	@@PARAM			;evaluate input
	RET	NZ		;invalid, go!
;
	LD	HL,(TTYP)	;get response pointer
	CALL	MVUP		;move to response byte
	LD	A,(FRESP)	;get input response
	LD	(HL),A		;to param block
	INC	HL		;bump to word pointer
	CALL	GETHL		;get pointer
	LD	BC,(FPARM)	;get temp param
	LD	(HL),C		;load into param block
	INC	HL		;bump pointer
	LD	(HL),B		;new param loaded!
	XOR	A		;set NO error
	SCF			;carry = input
	RET			;done
;
;	init default settings
;
DEFALT	LD	(IX+MSMASK),DEFMS
	LD	(IX+UCIMAGE),DEFUC
	LD	(IX+BAUDRT),DEFBA
	LD	(IX+BRK),DEFBR
	RET
;
;	text area
;
	IF	@MOD4
MDNAME	DB	'$CL'
	DB	_ETX
	ENDIF
;
	IF	@MOD2
MDNAME1	DB	'$CL'
	DB	_ETX
MDNAME2	DB	'$CM'
	DB	_ETX
	ENDIF
;
BADDCB	DB	'COM/DVR not installed'
	DB	_CR
;
PROMPT	DB	'? '
	DB	_ETX
;
;	valid baud rate lookup table
;
BAUDTBL	DW	50,75,110,135,150,300,600,1200,1800
	DW	2000,2400,3600,4800,7200,9600,19200
;
;	display driver lookup table
;
DSPTBL	DW	DMSG1		;'RS232 params: '
	DW	DMSG2		;'BAUD='
	DW	DMSG23		;', '
	DW	DMSG3		;'WORD='
	DW	DMSG23		;', '
	DW	DMSG4		;'STOP='
	DW	DMSG23		;', '
	DW	DMSG5		;'PARITY='
	DW	DMSG23		;', '
	DW	DMSG6		;'BREAK='
;
	DW	DMSG7		;'output: '
	DW	DMSG8		;'DTR='
	DW	DMSG23		;', '
	DW	DMSG9		;'RTS='
;
	DW	DMSG10		;'input: '
	DW	DMSG11		;'RI='
	DW	DMSG23		;', '
	DW	DMSG12		;'DSR='
	DW	DMSG23		;', '
	DW	DMSG13		;'CD='
	DW	DMSG23		;', '
	DW	DMSG14		;'CTS='
	DW	DMSG22		;_cr
	DW	0		;terminator
;
;	parameter pointer table
;
BREAKP	DW	0
QPARM	DW	0
BAUDP	DW	0
WORDP	DW	0
STOPP	DW	0
PARITYP	DW	0
EVENP	DW	0
ODDP	DW	0
DTRP	DW	0
RTSP	DW	0
RIP	DW	0
CDP	DW	0
DSRP	DW	0
CTSP	DW	0
DFPARM	DW	0
PORTD	DW	0
FPARM	DW	0
;
MSG1	DB	0		;Will be LF after 1st DSP
	DB	'RS232'
	IF	@MOD2
MSG1A	DB	'A'
	ENDIF
	DB	' parameters: '
	DB	_ETX
;
MSG2	DB	'Baud='
	DB	_ETX
;
MSG3	DB	'Word='
	DB	_ETX
;
MSG4	DB	'Stop='
	DB	_ETX
;
MSG5	DB	'Parity='
	DB	_ETX
;
MSG6	DB	'Break='
	DB	_ETX
;
MSG7	DB	_LF
	DB	'Output control: '
	DB	_ETX
;
MSG8	DB	'DTR='
	DB	_ETX
;
MSG9	DB	'RTS='
	DB	_ETX
;
MSG10	DB	_LF
	DB	'Input control: '
	DB	_ETX
;
MSG11	DB	'RI='
	DB	_ETX
;
MSG12	DB	'DSR='
	DB	_ETX
;
MSG13	DB	'CD='
	DB	_ETX
;
MSG14	DB	'CTS='
	DB	_ETX
;
MSG15	DB	'ON'
	DB	_ETX
;
MSG16	DB	'OFF'
	DB	_ETX
;
MSG17	DB	'ODD'
	DB	_ETX
;
MSG18	DB	'EVEN'
	DB	_ETX
;
MSG19	DB	'IGNORE'
	DB	_ETX
;
MSG20	DB	'00000'
	DB	_ETX
;
MSG21	DB	'X',_APOS
MSG21A	DB	'00',_APOS
	DB	_ETX
;
MSG22	DB	_CR
;
MSG23	DB	', '
	DB	_ETX
;
;	parameter evaluation table
;
PRMTBL$	DB	80H		;extended param
;
BRTYP	DB	5!FLAG!NUM
	DB	'BREAK'
BRRESP	DB	0
	DW	BREAKP
;
	DB	5!ABB!FLAG
	DB	'QUERY'
QRESP	DB	0
	DW	QPARM
;
BTYP	DB	4!ABB!NUM
	DB	'BAUD'
BRESP	DB	0
	DW	BAUDP
;
WTYP	DB	4!ABB!NUM
	DB	'WORD'
WRESP	DB	0
	DW	WORDP
;
STYP	DB	4!ABB!NUM
	DB	'STOP'
SRESP	DB	0
	DW	STOPP
;
PTYP	DB	6!ABB!FLAG!STR
	DB	'PARITY'
PRESP	DB	0
	DW	PARITYP
;
ETYP	DB	4!ABB!FLAG
	DB	'EVEN'
ERESP	DB	0
	DW	EVENP
;
OTYP	DB	3!ABB!FLAG
	DB	'ODD'
ORESP	DB	0
	DW	ODDP
;
DTYP	DB	3!FLAG
	DB	'DTR'
DTRESP	DB	0
	DW	DTRP
;
RTYP	DB	3!FLAG
	DB	'RTS'
RTRESP	DB	0
	DW	RTSP
;
RITYP	DB	2!FLAG
	DB	'RI'
RIRESP	DB	0
	DW	RIP
;
CDTYP	DB	2!FLAG
	DB	'CD'
CDRESP	DB	0
	DW	CDP
;
DSTYP	DB	3!FLAG
	DB	'DSR'
DSRESP	DB	0
	DW	DSRP
;
CTTYP	DB	3!FLAG
	DB	'CTS'
CTRESP	DB	0
	DW	CTSP
;
	DB	7!ABB!FLAG
	DB	'DEFAULT'
	DB	0
	DW	DFPARM
;
	IF	@MOD2
	DB	4!NUM
	DB	'PORT'
PORTP	DB	0
	DW	PORTD
	ENDIF
;
	DB	0		;list terminator
;
;	evaluate and setup user parameters
;
SETPARAM
	LD	HL,PRMERR	;param error exit vector
	PUSH	HL		;leave for quick exits
;
;	evaluate BAUD
;
SETBAUD	LD	A,(BRESP)	;get baud response
	OR	A		;anything?
	JR	Z,SETWORD	;nope, go!
	CALL	CKBAUD		;Get baud setting
	RET	NZ		;go if error
	LD	(IX+BAUDRT),A	;else save new baud
;
;	evaluate WORD
;
SETWORD	LD	C,(IX+UCIMAGE)	;P/u current setings
	LD	A,(WRESP)	;get word response
	OR	A		;anything?
	JR	Z,SETSTOP	;nope, continue
	LD	DE,(WORDP)	;get param
	INC	D		;check msb
	DEC	D		;D<>0?
	RET	NZ		;>256?
	LD	A,E		;get lsb
	SUB	5		;adjust 0 relative
	RET	C		;go if out of range
	CP	4		;5-8?
	RET	NC		;out of range!
	OR	A		;clear carry, set PV
	JP	PE,$+5		;go if 5/8
	XOR	3		;change 6=>7=>6
	RRCA			;align to bits 6/5
	RRCA
	RRCA
	LD	B,01100000B	;for bit setup
	CALL	SETBITS		;setup in C register
;
;	evaluate STOP
;
SETSTOP	LD	A,(SRESP)	;get response byte
	OR	A		;anything?
	JR	Z,SETPAR	;nope, continue
	LD	DE,(STOPP)	;get input
	INC	D		;check for out of range
	DEC	D		;D<>0?
	RET	NZ		;>256!
	LD	A,E		;get lsb
	OR	A		;0?
	RET	Z		;invalid!
	CP	3		;1/2?
	RET	NC		;invalid!
	DEC	A		;change 1|2 to 0|1
	RLCA			;align result
	RLCA
	RLCA
	RLCA
	LD	B,00010000B	;init mask
	CALL	SETBITS		;setup in C register
;
;	evaluate PARITY
;
SETPAR	LD	A,(PRESP)	;get parity response
	OR	A		;any input?
	JR	Z,SETPEO	;nope, check EVEN|ODD
;
;	check if response was string or switch
;
	LD	DE,(PARITYP)	;get user pointer
	BIT	6,A		;switch?
	JR	NZ,SETPOF	;yes, set ON/OFF
;
;	response was string, check 'E'|'O'
;
	LD	A,(DE)		;get input
	CALL	UCASE		;make upper case
	CP	'O'		;odd?
	JR	Z,SETPO		;yes, go!
	CP	'E'		;even?
	RET	NZ		;neither, invalid!
SETPE	SET	7,C		;set EVEN parity
	JR	SETPAEO		;continue
SETPO	RES	7,C		;set ODD parity
SETPAEO	RES	3,C		;set ON parity
	JR	SETBRK		;continue
;
;	response was switch, check ON|OFF
;
SETPOF	LD	A,D		;check input
	OR	E		;=0000?
	SET	3,C		;set OFF
	JR	Z,SETBRK	;continue if yes
	RES	3,C		;set ON
;
;	check for ODD|EVEN params
;
SETPEO	LD	A,(ORESP)	;get odd response
	OR	A		;anything?
	JR	Z,SETPAE	;nope, check EVEN
	LD	DE,(ODDP)	;get user input
	LD	A,D		;check for nil
	OR	E		;DE=0000?
	SET	7,C		;ODD=off?
	JR	Z,SETPAE	;go if yes
	RES	7,C		;ODD=on!
;
SETPAE	LD	A,(ERESP)	;get even response
	OR	A		;anything?
	JR	Z,SETBRK	;nope, continue
	LD	DE,(EVENP)	;get param
	LD	A,D		;check for nil
	OR	E		;DE=0000?
	RES	7,C		;EVEN=off?
	JR	Z,SETBRK	;go if yes
	SET	7,C		;EVEN=on!
;
;	evaluate BREAK
;
SETBRK	LD	A,(BRRESP)	;get user response
	OR	A		;anything?
	JR	Z,SETDTR	;nope, continue
	LD	DE,(BREAKP)	;get user input
	BIT	6,A		;switch?
	JR	NZ,SETBOF	;yes, check ON|OFF
;
;	value entered, check if in range
;
	INC	D		;check msb
	DEC	D		;D<>0?
	RET	NZ		;>256?
	JR	UPDBRK		;continue
;
;	switch entered, check if on/off
;
SETBOF	LD	A,D		;get input
	OR	E		;DE=0000?
	LD	E,80H		;default
	JR	Z,UPDBRK	;go if off
	LD	E,03H		;default
UPDBRK	LD	(IX+BRK),E	;update data
;
;	evaluate DTR
;
SETDTR	LD	A,(DTRESP)	;get user response byte
	OR	A		;anything?
	JR	Z,SETRTS	;continue if not
	LD	DE,(DTRP)	;get user param
	LD	A,D		;check if anything
	OR	E		;DE=0000?
	SET	1,C		;set OFF
	JR	Z,SETRTS	;go if yes
	RES	1,C		;set ON
;
;	evaluate RTS
;
SETRTS	LD	A,(RTRESP)	;get user response byte
	OR	A		;anything?
	JR	Z,UPDCI		;continue if not
	LD	DE,(RTSP)	;get user param
	LD	A,D		;check if 0
	OR	E		;DE=0000?
	SET	0,C		;set OFF
	JR	Z,UPDCI		;go if yes
	RES	0,C		;set ON
UPDCI	SET	2,C		;enable transmit
	LD	(IX+UCIMAGE),C	;update new data
;
;	evaluate RI
;
SETRI	LD	HL,RIRESP	;response byte
	LD	C,00000001B	;Bit to set
	CALL	SETIT		;setup data
;
;	evaluate DSR
;
SETDSR	LD	HL,DSRESP	;response byte
	LD	C,00000100B	;bit mask
	CALL	SETIT		;evaluate
;
;	evaluate CD
;
SETCD	LD	HL,CDRESP	;response byte
	LD	C,00000010B	;bit mask
	CALL	SETIT		;setup response
;
;	evaluate CTS
;
SETCTS	LD	HL,CTRESP	;response byte
	LD	C,00001000B	;bit mask
	CALL	SETIT		;setup
;
;	evaluation complete
;
	POP	AF		;remove param error vect
	RET			;return from evaluate
; 
SETIT	INC	(HL)		;any response?
	DEC	(HL)		;(HL) = 00?
	RET	Z		;yes, no change
	INC	HL		;point to response data
	CALL	GETHL		;load HL with (HL)
	CALL	GETHL		;get user response
	LD	A,C		;get response data ON
	RLCA			;align to upper 4 bits
	RLCA
	RLCA
	RLCA
	OR	C		;combine
	LD	B,A		;set response data OFF
	CPL			;reverse bits
	AND	(IX+MSMASK)	;drop desired bits
	LD	E,A		;save new mask
	LD	A,H		;check if OFF
	OR	L		;HL = 0000?
	LD	A,B		;get OFF bits
	JR	Z,$+3		;go if off
	LD	A,C		;get ON bits
	OR	E		;combine with remainder
	LD	(IX+MSMASK),A	;update mask
	RET			;done!
;
;	set bits in C from A using B as mask
;
SETBITS	AND	B		;mask others
	PUSH	AF		;save data
	LD	A,B		;get mask
	CPL			;reverse for mask off
	AND	C		;remove undesired bits
	POP	BC		;B = new bits
	OR	B		;combine
	LD	C,A		;update
	RET			;new bits set!
;
;	fetch HL from (HL)
;
GETHL	LD	A,(HL)		;get lsb
	INC	HL		;bump pointer
	LD	H,(HL)		;get msb
	LD	L,A		;HL = (HL)
	RET			;done
;
;	convert char in A to upper case
;
UCASE	CP	'a'		;in range?
	RET	C		;nope, go!
	CP	'z'+1		;in range?
	RET	NC		;nope, go!
	AND	5FH		;else make upper case
	RET			;done
;
;	check for valid baud rate entered
;
CKBAUD	LD	DE,(BAUDP)	;Baud parm (default 300)
	LD	HL,BAUDTBL	;Point to baud table
	LD	BC,16<8+0	;B=count, C=position
;
BLOOP	LD	A,(HL)		;fetch LSB baud
	INC	HL		;bump table
	CP	E		;lsb match?
	JR	NZ,NOMATB	;nope, go next entry
	LD	A,(HL)		;get MSB baud
	CP	D		;msb match?
	JR	Z,MATCHB	;yes, baud found!
;
NOMATB	INC	HL		;bump to next entry
	INC	C		;bump position count
	DJNZ	BLOOP		;go for table length
	RET			;param error!
;
MATCHB	LD	A,C		;Pick up baud rate code
	RLCA			;align to high bits
	RLCA
	RLCA
	RLCA
	OR	C		;Use for xmit and rcv
	CP	A		;Z=good value
	RET			;return with BAUD setting
;
;	nil params entered, display current settings
;
SHOW	EQU	$
	IF	@MOD2
	LD	A,-1		;set NO flag
	LD	(SHOWF),A	;save flag
	LD	DE,MDNAME1	;CL1
	LD	A,'A'		;comm A
	LD	(MSG1A),A	;to text
	CALL	SHOW1		;display
	LD	DE,MDNAME2	;CL2
	LD	A,'B'		;comm B
	LD	(MSG1A),A	;to text
	CALL	SHOW1		;display
	LD	A,-1		;get flag
SHOWF	EQU	$-1
	OR	A		;any found?
	JP	NZ,BADMOD	;not installed!
	RET			;else OK
;
SHOW1	@@GTMOD			;locate module
	RET	NZ		;module not found
	XOR	A		;set module found
	LD	(SHOWF),A	;init flag
	PUSH	DE		;pass to IX
	POP	IX		;IX => module
	ENDIF
;
	JP	DSPALL		;display all settings
;
;	mini param block for 'query' evaluation
;
PTBL2	DB	80H		;extended param
;
FTYP	DB	FLAG!NUM!1
	DB	'F'
FRESP	DB	0
	DW	FPARM
;
	DB	0
;
;	text string passed to @PARAM for query eval
;
FSTR	DB	'(F='
INBUF	EQU	$		;keyboard input buffer
;
	END	BEGIN
