;LBROUTE/ASM - ROUTE Command - 10/28/83
	TITLE	<ROUTE - LDOS 6.2>
;*=*=*
;	Change Log
;
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
; 10/28/83 - Reorganized code & added <BREAK> cleanup. DK
;
;*=*=*
CR	EQU	13
PAR_ERR	EQU	44		;Parameter Error
*GET	SVCMAC:3
	ORG	2400H
;
;*=*=* Save stack & call Route routine *=*=*
;
ROUTE	LD	(SAVESP+1),SP	;Save Stack
	CALL	ROUTE1		;Call route routine
EXIT	LD	HL,0		;Clean Exit
	JR	SAVESP		;
;
;*=*=* I/O Error Handling *=*=*
;
PRMERR	LD	A,PAR_ERR	;Parameter Error
IOERR	LD	L,A
	LD	H,0
	OR	0C0H		;Set abbrev & return
	LD	C,A
	@@ERROR
	JR	SAVESP		;p/u stack & return
;
;*=*=* Internal Error Message Handling *=*=*
;
CANT	LD	HL,CANT$
	DB	0DDH
SPCERR	LD	HL,SPCERR$
	@@LOGOT
ERREXIT	LD	HL,-1		;Set return code
;
;*=*=* P/u stack & Clear any pending <BREAK>s *=*=*
;
SAVESP	LD	SP,$-$		;p/u stack
	@@CKBRKC		;clear any <BREAK>s
	RET			;
;
;
;********************************************************
;***						      ***
;*** ROUTE1 - Route spec to spec		      ***
;***						      ***
;********************************************************
;
ROUTE1	LD	DE,FCBSRC	;fetch source spec
	@@FSPEC
	JR	NZ,SPCER	;jump on error
	LD	A,(DE)
	CP	'*'		;must be a device
	JR	NZ,SPCER	;jump if not
	LD	DE,PRMTBL$	;get parameters
	@@PARAM
	JR	NZ,PRMERR	;jump on parm error
	LD	DE,(FCBSRC+1)	;Stuff source name
	LD	(RTENAM+3),DE
	@@FLAGS			;Get flag table pointer
;*=*=*
;	Test NIL parameter
;*=*=*
NPARM	LD	BC,0		;p/u NIL parm
	LD	A,B
	OR	C
	JP	NZ,NILDCB	;jump if NIL entered
;*=*=*
;	Route to device/file - check which
;*=*=*
	LD	DE,FCBDST	;fetch destination spec
	@@FSPEC
SPCER	JP	NZ,SPCERR	;jump on error
	PUSH	DE
	LD	DE,PRMTBL$
	@@PARAM			;Need in case REWIND
	POP	DE
	JR	NZ,PRMERR
	LD	A,(DE)
	CP	'*'		;test device/file
	JR	NZ,INITFCB	;jump on file
;*=*=*
;	Destination spec is a device
;*=*=*
	LD	DE,(FCBDST+1)	;p/u device name
	LD	HL,(FCBSRC+1)	;Make sure SRC<>DST
	SBC	HL,DE		;  CF is reset
	JP	Z,SPCERR
	@@GTDCB			;find in tables
	JP	NZ,IOERR	;jump if not found
CKDCBS	PUSH	HL		;save DCB address of dest
	CALL	CKSRC		;Locate source DCB
	JP	NZ,IOERR
CKDCB1	EQU	$
	DI
	POP	BC		;rcvr dest route vector
	PUSH	HL		;Save DCB+0
;*=*=*
;	Save the old device vector while stuffing new
;*=*=*
	INC	L		;Bump to vector
	LD	A,(HL)		;Save what's there
	LD	(HL),C		;stuff dest route
	LD	C,A		;  into DCB of source
	INC	L		;  while saving old
	LD	A,(HL)		;  vector for storage
	LD	(HL),B		;  (could be a FCB)
	LD	B,A
;*=*=*
;	Now set ROUTE bit and rest of DCB block
;*=*=*
	POP	HL		;rcvr ptr to DCB+0
	LD	A,(HL)		;Init the ROUTE bit
	PUSH	AF		;Save old TYPE byte
	AND	7		;Strip any flag bits
	OR	10H
	LD	(HL),A		;show source is routed
	LD	A,L
	ADD	A,7		;point to name field
	LD	L,A
	LD	(HL),D		;and stuff in the name
	DEC	L		;  in case this is a
	LD	(HL),E		;  new DCB block
	POP	AF		;P/u old TYPE byte &
	BIT	4,A		;  save old data if
	JR	NZ,CKDCB2	;  not already routed
	DEC	L
	LD	(HL),B		;Stuff old vector
	DEC	L		;  for reclamation
	LD	(HL),C
	DEC	L
	LD	(HL),A		;Stuff old TYPE
CKDCB2	EQU	$
	EI
	RET			;Successful
;*****
;	destination is file - init it & posn to end
;*****
INITFCB	PUSH	DE
	LD	DE,RTENAM	;See if space already
	@@GTMOD			;  allocated for this
	POP	DE
	JR	NZ,NOTRES	;  device name
;*=*=*
;	Space in memory, re-use it
;*=*=*
	INC	HL		;Point to last byte used
	INC	HL
	LD	A,(HL)
	INC	HL
	LD	H,(HL)
	LD	L,A
	XOR	A
	LD	(CKIFRES+1),A
	JR	SETBUF
;*=*=*
;	not yet resident, get space
;*=*=*
NOTRES	BIT	0,(IY+'C'-'A')	;Can we alter HIGH$?
	JP	NZ,CANT		;Can't if frozen
	LD	HL,0		;get high!
	LD	B,L
	@@HIGH$
SETBUF	LD	(RTEDVR+2),HL	;Stuff highest used
	INC	HL		;Reserve a page for
	DEC	H		;  the I/O buffer
	PUSH	HL		;don't lose it
	LD	B,0		;LRL = 0
	@@INIT			;init the file
	JR	NZ,INITF1	;what? an error?
RPARM	LD	BC,0		;Ck on rewind (no peof)
	INC	B		;Keep file at start
	JR	Z,INITF1	;  if REWIND specified
	@@PEOF			;we open these things
	JR	Z,INITF1	;  at their end
	CP	1CH		;at End Of File?
INITF1	POP	HL		;get back buffer pointer
	JP	NZ,IOERR	;any other error, JuMp
	LD	BC,32+14	;back up another 32
	XOR	A		;  for the FCB storage
	SBC	HL,BC		;  + 14 for linkage
	PUSH	HL		;save module start
;*=*=*
;	Bypass HIGH$ stuff if "ISRES"
;*=*=*
CKIFRES	OR	-1		;"OR 0" if "ISRES"
	JR	Z,ISRES1
	DEC	HL		;reset HIGH$ (B=0)
	@@HIGH$			;Stuff new high$
ISRES1	POP	DE		;rcvr module pointer
	PUSH	DE
	LD	HL,RTEDVR	;move module to memory
	LDIR
	POP	DE		;Now adjust to true
	LD	HL,14		;  FCB loc'n
	ADD	HL,DE
	JP	CKDCBS		;go check dcbs
;*=*=*
;	Scan device tables for source device
;*=*=*
CKSRC	LD	DE,(FCBSRC+1)	;P/u source device name
	PUSH	DE		;  & save it for later
	@@GTDCB			;Find device in table
	JR	Z,CKSRC1	;Use it if found
	LD	DE,0		;  else find a spare
	@@GTDCB			;  DCB block
	LD	A,33		;init "No device space...
	JR	NZ,CKSRC2	;abort if no space
CKSRC1	PUSH	HL
	CALL	CLSFILS
	POP	HL
CKSRC2	POP	DE		;Recover source name
	RET
;*****
;	NIL entered, close up any open file
;*****
NILDCB	CALL	CKSRC
	LD	A,(HL)
	OR	8
	LD	(HL),A		;Show is NIL device
	LD	A,L		;Pt to name field
	ADD	A,6
	LD	L,A
	DI
	LD	(HL),E		;stuff in our name
	INC	L		;  in case it's a new
	LD	(HL),D		;  DCB block
	EI
	RET			;successful
;*****
;	find the last device route & close any open file
;*****
CLSFILS	BIT	4,(HL)		;jump if no route
	JR	Z,CLSFIL1
	INC	HL		;else p/u link address
	LD	A,(HL)		;  and test that one
	INC	HL		;  for a chain
	LD	H,(HL)
	LD	L,A
	JR	CLSFILS
CLSFIL1	BIT	7,(HL)		;a file?
	RET	Z		;ret if not
	LD	DE,FCBFIL	;pt to fcb area
	PUSH	DE
	LD	BC,32
	LDIR			;fill from device vector
	POP	DE		;recover start
	@@CLOSE			;close the file
	RET			;Ret with Z, NZ status
;*=*=*
;	Messages
;*=*=*
CANT$	DB	'No memory space available',CR
SPCERR$	DB	'Device spec required',CR
PRMTBL$	DB	80H,53H,'NIL',0
	DW	NPARM+1
	DB	56H,'REWIND',0
	DW	RPARM+1
	NOP
RTEDVR	JR	$		;No real jump
	DW	$-$		;Stuff of high
	DB	5
RTENAM	DB	'RTExx'
	DW	0,0
FCBDST	DB	0
	DS	31
FCBFIL	DB	0
	DS	31
FCBSRC	DB	0
	DS	31
	END	ROUTE
