;LBRESET/ASM - RESET Command - 10/28/83
	TITLE	<RESET - LDOS 6.2>
;*=*=*
;	change log
; 10/28/83 - Reorganized & added <BREAK> cleanup. DK
;
;*=*=*
CR	EQU	13
*GET	SVCMAC:3
	ORG	2400H
;
;*=*=* Save stack & call reset code *=*=*
;
RESET	LD	(SAVESP+1),SP	;Save Stack ptr
	CALL	RESET1		;Call Reset routine
	LD	HL,0		;init successful
	JR	Z,SAVESP	;Z - Exit clean
;
;*=*=* I/O Error Processing *=*=*
;
IOERR	LD	L,A
	LD	H,0
	OR	0C0H
	LD	C,A
	@@ERROR
	JR	SAVESP		;p/u stack & return
;
;*=*=* Internal Message Exit *=*=*
;
SPCREQ	LD	HL,SPCREQ$
	@@LOGOT
	LD	HL,-1
;
;*=*=* P/u stack & clear any pending <BREAK>s *=*=*
;
SAVESP	LD	SP,$-$		;p/u stack ptr
	@@CKBRKC		;clear any <BREAK>s
	RET
;
;
;********************************************************
;***						      ***
;*** RESET1 - Reset a Filespec or Devspec	      ***
;***						      ***
;********************************************************
;
RESET1	LD	DE,FCBDEV	;Get file/device spec
	@@FSPEC
	JP	NZ,SPCREQ	;Must reset something
	LD	A,(DE)		;File reset used to
	CP	'*'		;  reset the
	JP	NZ,RESFIL	;  "file open bit
	LD	DE,(FCBDEV+1)	;P/u the device name
	@@GTDCB			;Find in device tables
	RET	NZ		;NZ - "Device not Avail"
	PUSH	HL		;Save pointer to table
	CALL	CLSFILS		;Reset routes to files
	POP	HL		;Get DCB pointer
	RET	NZ		;NZ - I/O Error
;*=*=*
;	Unhook the device chain
;*=*=*
	PUSH	HL
	DI			;Don't stop me now!
	CALL	FIXDCB		;Fixup the DCB
	EI			;Now you can interrupt
	LD	HL,FCBDEV	;Determine if system
	LD	D,H		;  device by attempting
	LD	E,L		;  to rename it
	@@RENAM			;The error code will be
	POP	HL		;  either 19 or 40
	CP	40		;Protected system device?
	JR	Z,SYSDVC
	LD	(HL),8		;Show device is NIL
	XOR	A		;set Z
	RET			;Z - successful
;*=*=*
;	RESET of system device
;*=*=*
SYSDVC	PUSH	HL
	INC	L		;If DCB vector is X'0000'
	LD	A,(HL)		;  then do NOT reset the
	INC	L		;  NIL bit
	OR	(HL)
	POP	HL
 	RET	Z		;Z - return
	RES	3,(HL)		;Make sure NIL is off
	XOR	A		;Set Z & Return
	RET			;
;*=*=*
;	Reset the "file open bit" of a file
;*=*=*
RESFIL	@@FLAGS			;Get flag table pointer
	SET	0,(IY+'S'-'A')	;Inhibit file open bit
	@@OPEN
	RET	NZ		;NZ - I/O Error
	LD	A,(HL)		;Make sure access level
	AND	7		;  is at least UPDATE
	CP	5
	LD	A,37
	RET	NZ		;NZ - I/O error
	EX	DE,HL
	SET	6,(HL)		;Set "close authority
	EX	DE,HL
	@@CLOSE
	RET			;return w/ condition
;*****
;	find the last device route & close any open file
;*****
CLSFILS	BIT	4,(HL)		;jump if no route
	JR	Z,CLSFIL1
	INC	HL		;Else p/u link address
	LD	A,(HL)		;  and test that one
	INC	HL		;  for a chain
	LD	H,(HL)
	LD	L,A
	JR	CLSFILS
CLSFIL1	BIT	7,(HL)		;A file?
	RET	Z		;Ret if not
	LD	DE,FCBFIL	;Pt to fcb area
	PUSH	DE
	LD	BC,32
	LDIR			;Fill from device vector
	POP	DE		;Recover start
	@@CLOSE			;Close the file
	RET			;Ret with Z, NZ status
;*=*=*
;	Routine to fix up a system DCB
;*=*=*
FIXDCB	BIT	4,(HL)		;If routed, recover the
	JR	Z,FIX1		;  original data from
	PUSH	HL		;  DCB+3 to DCB+5
	LD	D,H
	LD	E,L
FIX0	INC	L
	INC	L
	INC	L
	LD	BC,3
	LDIR
	POP	HL
	RES	4,(HL)		;Guard against screwup
	JR	FIXDCB
FIX1	BIT	5,(HL)		;If linked, recover the
	JR	Z,FIX2		;  original data from
	PUSH	HL		;  the LINK DCB source &
	INC	L		;  clear the LINK DCB
	LD	E,(HL)		;P/u the LINK vector
	INC	L
	LD	D,(HL)
	POP	HL
	PUSH	HL
	EX	DE,HL		;Link to HL, DCB to DE
	PUSH	HL		;Save for clearing
	LD	BC,3
	LDIR
	POP	HL
	LD	B,8
FIX1A	LD	(HL),0		;Clear the LINK DCB
	INC	L
	DJNZ	FIX1A
	POP	HL		;Rcvr DCB pointer
	JR	FIXDCB
FIX2	BIT	6,(HL)		;If filtered, recover the
	RET	Z		;  original data by
	PUSH	HL		;  swapping back the
	LD	D,H
	LD	E,L
	INC	L		;  1st three bytes with
	LD	A,(HL)		;  the FILTER DCB
	INC	L
	LD	H,(HL)
	LD	L,A
	LD	BC,4		;HL now points to the
	ADD	HL,BC		;  entry point. Get its
	LD	C,(HL)		;  DCB address by peeking
	INC	C		;  past the name field
	ADD	HL,BC
	LD	A,(HL)		;Get low-order
	INC	HL
	LD	H,(HL)		;Get hi-order
	LD	L,A
	PUSH	HL		;If DCB is itself, then
	SBC	HL,DE		;  bring in the NIL
	POP	HL
	JR	Z,FIX0
	LD	B,3
FIX2A	LD	C,(HL)
	LD	A,(DE)
	LD	(HL),A
	LD	A,C
	LD	(DE),A
	INC	L
	INC	E
	DJNZ	FIX2A
	POP	HL
	JR	FIXDCB
;*=*=*
;	Data area
;*=*=*
SPCREQ$	DB	'Device spec required',CR
	DC	32,0		;Patch space
FCBDEV	DB	0
	DS	31
FCBFIL	DB	0
	DS	31
	END	RESET
