;LBREMOVE/ASM - REMOVE command - 10/29/83
	TITLE	<REMOVE - LDOS 6.2>
;*=*=*
;	Change Log
;
; 05/05/83 - Added Routine to transfer filespec
;	   - (excluding password) into buffer &
; 	   - Moved Display of filename after a
;	   - successful @OPEN - DK
; 09/26/83 - Fixed Routine to display drivespec of
;	   - the file(s) being removed, & won't display
;	   - that it's removing a file unless it will.
;	   - Also Fixed it to display removing message
;	   - even if it's a device.
; 10/24/83 - Inserted Stack Save for errors - DK.
; 10/28/83 - Reorganized to the max, & added <BREAK>
;          - clean-up code. DK
;*=*=*
*GET	SVCMAC:3
*GET	VALUES:3
	ORG	2400H
;
;*=*=* Save Stack, Call remove routine *=*=*
;
REMOVE	@@CKBRKC		;Break key down?
	JR	Z,BEGINA	;Ok if not
	LD	HL,-1		; else abort
	RET
;
BEGINA	LD	(SAVESP+1),SP	;Save Stack
	CALL	REMOV		;Remove file(s)
	JR	EXIT
;
;*=*=* Exit Routine - Clear any <BREAK> & return *=*=*
;
BRKABT
	LD	HL,-1
	JR	SAVESP		;abort with error
;
EXIT	LD	HL,0		;Set retcod if exiting
SAVESP	LD	SP,$-$		;p/u stack
	@@CKBRKC		;clear <BREAK> if entered
	RET			;and Return
;
;*=*=* Special Message Exit *=*=*
;
SPCREQ	LD	HL,SPCREQ$
	@@LOGOT
ERREXIT	LD	HL,-1
	JR	SAVESP		;get stack & RET
;
;*=*=* I/O Error Exit *=*=*
;
IOERR	LD	L,A
	LD	H,0
	OR	0C0H		;Abbrev, return
	LD	C,A		;Error code to reg C
	@@ERROR
	JR	SAVESP		;p/u stack & return
;
;
;********************************************************
;***						      ***
;*** REMOV - Remove file(s) on the command line       ***
;***						      ***
;********************************************************
;
REMOV	PUSH	HL		;Save INBUF$ pointer
REMOV0	XOR	A		;Set Z-flag for loop
REMOV1	POP	HL
	JP	NZ,IOERR
;
;*=*=* Skip leading spaces - exit on terminator *=*=*
;
	@@CKBRKC		;Check for break
	JR	NZ,BRKABT	; abort if so
;
	DEC	HL		;
REMOV2	INC	HL		;skip past spaces
	LD	A,(HL)		;
	CP	' '
	JR	Z,REMOV2	;
	RET	C		;Return on terminator
;
;*=*=* Hit a non-space char - is this a filespec ? *=*=*
;
REMOV3	LD	DE,FCB		;fetch the filespec
	@@FSPEC
	JP	NZ,SPCREQ	;jump on spec error
	PUSH	HL		;Save INBUF$ pointer
;
;*=*=* Transfer Filespec to buff without password *=*=*
;
	PUSH	DE
	EX	DE,HL		;pt HL => FCB
	LD	DE,FILESPC	;DE => Filespec
	CALL	MOVSPC		;Move filespec
	LD	A,CR		;end spec with C/R
	LD	(DE),A		;
	POP	DE
;
;*=*=* Are we Removing a Device ? *=*=*
;
	LD	A,(DE)		;Is it a device?
	CP	'*'
	JR	Z,RMVDVC
;
;*=*=* Removing a File - Does it exist ? *=*=*
;
	@@OPEN			;open the file
	JR	Z,GOODOPN	;Z - it does exist
	CP	42		;LRL Open Fault ?
	JR	NZ,REMOV1	;no - abort
;
;*=*=* Successful Open - Can we Remove the file ? *=*=*
;
GOODOPN	LD	A,(FCB+1)	;p/u access level
	AND	7		;
	CP	2		;REMOVE access ?
	LD	A,37		;no - "Illegal access
	JP	NC,IOERR	;attempted to ..."
;
;*=*=* Is there a drivespec in the filespec ? *=*=*
;
	LD	HL,FILESPC	;HL => Filespec
FLOOP	LD	A,(HL)		;p/u char
	CP	CR+1		;end of Filespec ?
	JR	NC,CHKDSPC	;
;
;*=*=* Drivespec wasn't specified - put it on *=*=*
;
	LD	(HL),':'	;append drivespec onto
	INC	HL		; end of filespec
	LD	A,(FCB+6)	;xfer drive # to A
	ADD	A,'0'		;convert to ASCII
	LD	(HL),A		;
	INC	HL		;bump
	LD	(HL),CR		;end of filespec
	JR	SHOWFIL		;get defaults
;
;*=*=* Stop when ":" hit or terminator *=*=*
;
CHKDSPC	CP	':'		;Already have one ?
	INC	HL		;
	JR	NZ,FLOOP	;
;
;*=*=* Display "Removing Filespec" & remove it *=*=*
;
SHOWFIL	CALL	SHOWIT		;"Removing:"
	@@REMOV			;Remove the file
	JR	REMOV1		;jump on remove error
;
;*=*=* Display Filespec or Devspec *=*=*
;
SHOWIT	LD	HL,SHOW$	;Show what we are
	PUSH	DE		;Save FCB ptr
	@@DSPLY			;  removing
	POP	DE		;
	JR	NZ,REMOV1	;NZ - abort
	RET			;else RETurn Z
;*****
;	routine to Remove a device
;*****
RMVDVC	PUSH	DE		;Xfer FCB ptr to IX
	POP	IX
	LD	E,(IX+1)	;p/u device name
	LD	D,(IX+2)
;*****
;	routine to find a device in the device tables
;*****
	@@GTDCB
	JR	NZ,REMOV1
;*****
;	found device in tables, is it killable?
;*****
DEV4	LD	(RENDEV+1),DE	;Try to rename it!
	PUSH	HL		;Save address pointer
	LD	HL,RENDEV	;New & old names same
	LD	E,L
	LD	D,H
	@@RENAM
	POP	HL		;Rcvr address pointer
	CP	19		;If not "illegal name"
	JP	NZ,REMOV1	;  error, is protected!
;*****
;	device not system device - is it in use?
;*****
CKNILL	BIT	3,(HL)		;test NIL device
	JR	NZ,REMOVIT	;jump if NIL (not in use)
	LD	A,27H		;"device in use"
	OR	A
	JP	REMOV1
;*****
;	remove the device
;*****
REMOVIT	CALL	SCND4		;zero 8-byte DCB area
;*****
;	Any other device routes to the removed one?
;*****
SCNDCB	LD	DE,'IK'		;Point to begin of area
	@@GTDCB
SCND1	BIT	4,(HL)		;routed device?
	JR	Z,SCND2		;jump if not
	PUSH	HL		;Save DCB pointer
	INC	L		;bypass TYPE code
	LD	A,(HL)		;p/u route vector
	INC	L		; lo-order
	LD	H,(HL)		;p/u vector hi-order
	LD	L,A
	LD	A,(HL)		;p/u TYPE code of nest
	POP	HL		;rcvr DCB pointer
	OR	A		;if TYPE=0, we killed
	JR	NZ,SCND2	;  the routed device
	LD	A,8
	OR	(HL)		;convert to NIL if so
	LD	(HL),A
	JR	SCNDCB
;*****
;	point to next device
;*****
SCND2	LD	A,L		;advance to next DCB area
	ADD	A,8		;loop through all
	LD	L,A		;  devices while checking
	JR	NZ,SCND1	;Loop until table end
;*****
;	device table cleared, now zero the DCB/FCB
;*****
	PUSH	IX		;xfer vector to HL
	POP	HL
	CALL	SCND4
	CALL	SHOWIT		;Show "Removing:"
	JP	REMOV0		;next ...
SCND4	LD	B,8		;clear 8 bytes
	XOR	A
SCND5	LD	(HL),A		;go for it!
	INC	HL
	DJNZ	SCND5
	RET
;
;*=*=* Transfer a filespec from HL to DE *=*=*
;
MOVSPC	LD	A,(HL)		;P/u a spec character
	CP	'/'		;extension ?
	JR	NZ,CKSPACE	;no - check if space
	INC	HL		;Is the next character
	LD	A,(HL)		; valid ?
	CP	'A'		;
	JR	C,CKSPACE	; no - don't output it
	DEC	HL		;back one
	LD	A,(HL)		;p/u slash
CKSPACE	CP	' '
	RET	C		;stop on space or less
	CP	'.'		;Password ?
	JR	NZ,MOVSPC1
SKIPPW	INC	HL
	LD	A,(HL)
	CP	' '
	RET	C		;Back on terminator
	CP	':'
	JR	NZ,SKIPPW
MOVSPC1	LDI			;Move the char
	JR	MOVSPC
;
SPCREQ$	DB	'File spec required',CR
RENDEV	DB	'*LS'
SHOW$	DB	'Removing: '
FILESPC	DS	15
FCB	DB	0
	DS	31
	END	REMOVE
