;LBPURGE/ASM - PURGE Command - 10/31/83
	TITLE	<PURGE - LDOS 6.2>
;*****
;	Change Log
; 03/28/83 - Add screening for drivespec range (0-7), &
;	   - Write Protected Disk.
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
; 10/28/83 - Removed unnecessary break handling code &
;          - changed code to use @CKBRKC SVC. Also
;	   - purged extraneous code to reset the <BREAK>
;	   - bit before purging. DK
; 10/31/83 - Added @@FLAGS call for Q=N request. DK
;*****
LF	EQU	10
CR	EQU	13
PAR_ERR	EQU	44		;Parameter Error
PASSWORD	EQU	42E0H
*GET	SVCMAC:3
	ORG	2400H
PURGE	@@CKBRKC		;Break key down?
	JR	Z,BEGINA	;Ok if not
	LD	HL,-1		; else abort
	RET
;
BEGINA	LD	(SAVESP+1),SP	;Save stack pointer
PURGE1	LD	A,(HL)		;bypass cmd line blanks
	INC	HL
	CP	' '
	JR	Z,PURGE1
	LD	DE,BLANKS	;pt to filespec area
	LD	B,8		;init for file name
	CP	'-'		;If -, set up flag
	JR	NZ,PUR0
	LD	(MFLG+1),A
	LD	A,(HL)
	INC	HL
PUR0	CALL	PRSPEC
	CP	'/'		;ck on file EXT entered
	JR	NZ,PUR1		;jump if no extension
	LD	DE,BLANKS+8	;point to ext field
	LD	B,3		;max 3 chars
	LD	A,(HL)
	INC	HL
	CALL	PRSPEC		;ck on EXT
PUR1	CP	':'		;drive entered?
	LD	C,0		;init to drive 0
	JR	NZ,PRMERRA
	LD	A,(HL)		;p/u drive #
	INC	HL		;bump to next field
	CALL	PATCH1
PUR2	LD	A,C		;xfer drive to regA
	LD	(TSTMPW+1),A	;  & stuff for later
	@@CKDRV			;ck if drive available
	LD	A,32		;"drive not avail...
	CALL	PATCH2
	@@GTDCT			;DCT to reg IY
	LD	DE,PRMTBL$	;get parm
	@@PARAM
PRMERRA	JP	NZ,PRMERR	;jump on error
DATPRM	LD	HL,0		;P/u date="from-to"
	LD	A,H
	OR	L
	JR	Z,PUR3		;Bypass if not entered
	LD	A,(HL)		;check for "-to"
	CP	'-'
	JR	Z,CKTO
	LD	A,80H		;set from bit
	LD	(FTFLG),A	;note from entered
	CALL	PAKDAT		;Pack the date entry
	JP	NZ,IOERR
	LD	(FMPAKD),BC
	LD	A,(HL)
	CP	'"'
	JR	Z,FRCTO
	CP	'-'		;check for "-to"
	JR	NZ,PUR3
CKTO	INC	HL		;bypass the '-'
	LD	A,(HL)		;ck for end of parm
	CP	'"'
	JR	Z,PUR3
	CALL	PAKDAT
	JP	NZ,IOERR
FRCTO	LD	A,(FTFLG)
	OR	1		;set TO bit
	LD	(FTFLG),A
	LD	(TOPAKD),BC	;Stuff for later
PUR3	LD	A,(QPARM+1)
	OR	A
	JR	Z,DOEVER
	CALL	CKINDO		;invalid command during
	JP	NZ,IOERR	;  <DO> processing
DOEVER	CALL	TSTMPW		;ck on master password
	JP	NZ,IOERR
	LD	A,(TSTMPW+1)	;p/u drive
	LD	C,A
	LD	D,(IY+9)	;Get DIR cylinder
	LD	E,1		;pt to HIT sector
	LD	HL,HITBUF
	@@FLAGS			;Pt IY => Flags
	@@RDSSC			;read the HIT
	LD	A,16H		;init "HIT read error...
	JP	NZ,IOERR	;abort on read error
	JR	SCNH3
;*****
;	major loop to scan HIT for files
;*****
SCNHIT	POP	HL
SCNH1	POP	BC		;rcvr HIT ptr DEC
	LD	H,HITBUF<-8	;pt to hi-order buffer
	LD	L,B		;set lo-order DEC
SCNH2	LD	A,L
	ADD	A,32		;pt to next one in
	LD	L,A		;same dir sector
	JR	NC,SCNH3	;jump if still in sector
	INC	L		;bump to next dir sector
	CP	1FH		;end of the line?
	JR	NZ,SCNH3	;loop if not
	LD	C,CR
	@@DSP			;write new line & exit
	JP	EXIT
;*****
;	routine to check on dir record in use
;*****
SCNH3	LD	A,L		;ignore BOOT & DIR
	AND	0FEH
	JR	Z,SCNH2
	LD	A,(HL)		;p/u HIT hash byte
	OR	A
	JR	Z,SCNH2		;ignore if spare
	LD	B,L		;save DEC
	PUSH	BC
	LD	A,L		;get record # in L
	AND	0E0H
	LD	L,A
	XOR	B		;get sector # in A
SCNH3A	CP	0FFH		;same as what's in core?
	JR	Z,SCNH4		;bypass if same
	LD	(SCNH3A+1),A	;update indicator byte
	@@DIRRD			;read this directory
	JP	NZ,IOERR
	LD	A,H		;Set SBUFF pointer
	LD	(SCNH4+1),A
SCNH4	LD	H,0		;pt to dir buf hi-order
	LD	A,(HL)		;'L' set to lo-order
	BIT	4,A		;ignore if not assigned
	JR	Z,SCNH1
	BIT	7,A		;ignore if its an
	JR	NZ,SCNH1	;  extended dir record
	BIT	6,A		;jump if not a SYS file
	JR	Z,CKINV
SPARM	LD	DE,0		;p/u S-parm
	LD	A,D
	OR	E		;ignore this one if
	JP	Z,SCNH1		;  S-parm not entered
	JR	CKNAM
;*****
;	non-SYS file
;*****
CKINV	BIT	3,A		;jump if invisible
	JR	Z,CKNAM
IPARM	LD	DE,0		;I-parm
	LD	A,D		;ignore if I-parm not
	OR	E		;  entered as this file
	JP	Z,SCNH1		;  is invisible
;*****
;	parms match, grab filename & check class
;*****
CKNAM	PUSH	HL		;save ptr to record
	LD	A,L		;pt to filename in dir
	ADD	A,5
	LD	L,A
	LD	DE,BLANKS	;pt to parsed input
	LD	B,11		;ck name/ext (11-chars)
SCNH5	LD	A,(DE)
	CP	'$'		;wild char?
	JR	Z,SCNH6		;always a match!
	CP	(HL)		;not global, char match?
	JR	Z,SCNH6		;ck more if match
	CP	' '		;blank = end of ck
	JR	NZ,MFLG		;if not blank, no match
SCNH6	INC	HL		;bump pointers
	INC	DE
	DJNZ	SCNH5		;loop for 11 chars
	LD	A,(MFLG+1)	;Bypass if a match but
	OR	A		;  - exclude given
	JP	NZ,SCNHIT
	JR	SCNH6A
MFLG	LD	A,0		;Ignore if no match &
	OR	A		;  no exclude given
	JP	Z,SCNHIT
SCNH6A	POP	HL		;Rcvr ptr to DIR+0
	PUSH	HL
;*=*=*
;	Now check if date matches
;*=*=*
	INC	HL		;Pt to date field
	CALL	UNPACK		;Alter date for cpr
	LD	A,(FTFLG)
	RLCA			;tst fm bit
	JR	NC,SCNH6B
	LD	A,D		;Ignore if no date
	OR	E		;  in DIR for file
	JP	Z,SCNHIT
	LD	HL,(FMPAKD)	;P/u user entry
	EX	DE,HL
	CALL	CPHLDE		;HL-DE
	EX	DE,HL
	JP	C,SCNHIT
SCNH6B	LD	A,(FTFLG)
	RRCA			;tst TO bit
	JR	NC,MATCHES	;Go if no TOPARM
	LD	A,D		;Else ck if file is dated
	OR	E
	JP	Z,SCNHIT
	LD	HL,(TOPAKD)	;P/u user's packed date
	CALL	CPHLDE		;HL-DE
	JP	C,SCNHIT
MATCHES	POP	HL		;Rcvr pointer to DIRREC
DONAM	PUSH	HL
	LD	A,L		;  & point to file name
	ADD	A,5
	LD	L,A
	LD	DE,FCB1$	;pt to name/ext buffer
	LD	B,8		;max 8-char name
DONAM1	LD	A,(HL)		;move filename into
	CP	' '		;  buffer until space
	JR	Z,DONAME2	;  or 8 characters
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	DONAM1
DONAME2	LD	A,L		;point to file ext
	ADD	A,B
	LD	L,A
	LD	A,(HL)		;is there an extension?
	CP	' '
	JR	Z,DONAM5	;bypass if not
	LD	A,'/'
	LD	(DE),A		;stuff ext separator
	INC	DE
	LD	B,3		;init 3-char ext max
DONAM4	LD	A,(HL)		;transfer up to space
	CP	' '		;  or 3 chars
	JR	Z,DONAM5
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	DONAM4
DONAM5	LD	A,':'		;Add the drivespec
	LD	(DE),A
	INC	DE
	LD	A,(TSTMPW+1)	;P/u drivespec
	OR	'0'		;Make it ASCII & stuff
	LD	(DE),A
	INC	DE
	LD	A,3		;Terminate with ETX
	LD	(DE),A
	PUSH	DE		;Save pointer
QPARM	LD	DE,-1		;Query each file?
	LD	A,D
	OR	E
	JP	Z,NOPRMPT	;Not if not Q=N
	@@DSPLY	PRGFIL$		;purge file?
	POP	DE		;Rcvr ptr to file buf ETX
	POP	HL		;Rcvr ptr to 1st dir byte
	PUSH	DE
	INC	HL		;Pt to MOD bit
	BIT	6,(HL)		;test MOD flag
	JR	Z,SCDAT1
	LD	A,' '		;Put a space
	LD	(DE),A
	INC	DE
	LD	A,'+'
	LD	(DE),A
	INC	DE
SCDAT1	LD	A,' '		;write a space
	LD	(DE),A
	INC	DE
	INC	HL		;advance to date field
	EX	DE,HL
	LD	(HL),'{'	;Stuff left brace
	INC	HL
	EX	DE,HL
	LD	A,(HL)
	OR	A
	JR	Z,SCDAT4	;ignore if no date saved
	RRCA			;has date, get day
	RRCA
	RRCA
	AND	1FH
	LD	B,2FH		;convert day to decimal
SCDAT2	INC	B		;  by counting # of 10's
	SUB	10		;sub 10 from day #
	JR	NC,SCDAT2
	ADD	A,3AH		;cvrt lo order to ASCII
	PUSH	AF		;save day low order
	LD	A,B		;stuff day hi order
	LD	(DE),A
	INC	DE		;bump
	POP	AF		;rcvr lo order day #
	LD	(DE),A		;stuff low order
	INC	DE		;bump pointer to msg
	LD	A,'-'		;init to current
	LD	(DE),A		;Stuff '-' or '+'
	INC	DE		;  to pt to month field
	PUSH	HL		;save DIR ptr
	DEC	HL		;pt to DIR+1 (month+)
	LD	A,(HL)		;p/u month etc
	AND	0FH		;strip off flags
	DEC	A		;(mon-1)*3 indexes string
	LD	C,A		;  conversion table
	RLCA
	ADD	A,C
	LD	C,A
	LD	B,0
	LD	HL,MONTBL
	ADD	HL,BC		;add offset to tbl start
	LD	C,3
	LDIR			;move 3-char month
	LD	A,'-'
	LD	(DE),A
	INC	DE		;advance to year field
	LD	A,'8'		;stuff 8 of 1980
	LD	(DE),A
	INC	DE		;bump msg ptr
	POP	HL		;rcvr DIR+2
	LD	A,(HL)		;p/u year field
	AND	7		;remove day
	ADD	A,'0'		;cvrt to ASCII
	LD	(DE),A		;stuff -> msg
	INC	DE
SCDAT4	LD	A,3		;show etx for display
	LD	(DE),A
	@@DSPLY	FCB1$		;display filename
	@@DSPLY	QMARK$		;display ???
	LD	HL,LILBUF$	;get response y,n
	LD	BC,3<8		;For Yes, No
	@@KEYIN
	JP	C,BREAK		;Abort on <BREAK>
	LD	A,(HL)		;p/u response
	RES	5,A		;strip l/c if entered
	CP	'Y'		;is it yes?
	JP	NZ,SCNHIT	;bypass if not
	EX	(SP),HL		;Place dummy HL below
	PUSH	HL		;  pointer
NOPRMPT	BIT	0,(IY+'K'-'A')	;Ck if BREAK bit in
	JP	NZ,BREAK	;  KFLAG is active
	@@LOGOT	PURGE$
	POP	HL		;Get pointer where ETX is
	LD	(HL),CR		;  & replace with CR
	@@LOGOT	FCB1$		;Log purged file
	POP	HL		;Pop dummy or DIRREC ptr
	POP	BC		;get drive & DEC
	PUSH	BC
	LD	A,B
	LD	(FCB+7),A	;& stuff
	LD	A,(TSTMPW+1)	;p/u drive
	LD	(FCB+6),A	;stuff drive
	LD	A,1		;set up FCB for remove
	LD	(FCB+1),A
	LD	A,80H		;show FCB as open
	LD	(FCB),A
	LD	DE,FCB		;remove the file
	@@REMOV
	JP	NZ,IOERR	;jump on error
	LD	A,0FFH		;show we don't have the
	LD	(SCNH3A+1),A	;  latest dir record
	JP	SCNH1		;loop
;*****
;	routine to get the master password & match it
;*****
TSTMPW	LD	C,0		;Init to drive requested
	CALL	GATRD		;Read GAT into GATBUF
	RET	NZ		;Back on error
	LD	HL,(GATBUF+0CEH)
	LD	DE,PASSWORD	;Password=PASSWORD?
	XOR	A
	SBC	HL,DE
	RET	Z		;Back if PASSWORD
;*=*=*
;	MPW is not "PASSWORD" - check entry match
;*=*=*
PWPARM	LD	DE,0		;P/u MPW string addr
	LD	HL,MPW$		;Init prompt
	CALL	GETMPW		;Hash parm or entry
	RET	NZ
	EX	DE,HL		;Xfer haashed MPW to DE
	LD	HL,(GATBUF+0CEH) ;Grab pack MPW &
	XOR	A		;  check if user entered
	SBC	HL,DE		;  the pack MPW
	LD	HL,BADMPW$	;Init error pointer
	LD	A,63		;Set extended error
	RET			;Z or NZ
;*****
;	routine to get 8-char password
;*****
GETMPW	CALL	GMPW1		;Test if user entered MPW
	RET	NZ
	LD	A,0E4H		;Hash password (DE) to HL
	RST	28H		;Ret to what called
GMPW1	LD	A,D		;Test if user entered MPW
	OR	E
	JR	Z,GMPW3		;prompt if not
	INC	A		;  or no operand
	JR	Z,GMPW3
;*=*=*
;	Place entered password into buffer
;*=*=*
	LD	HL,BUFFER
	PUSH	HL
	LD	B,8		;max entry of 8 chars
GMPW2	LD	A,(DE)		;p/u pswd char
	CP	CR		;end of the line?
	JR	Z,GMPW4		;space out if so
	CP	','		;comma separator?
	JR	Z,GMPW4
	CP	'"'		;closing quote?
	JR	Z,GMPW4
	INC	DE
	LD	(HL),A		;xfer the char
	INC	HL
	DJNZ	GMPW2		;loop for 8
	JR	GMPW5
;*****
;	not entered as parm, grab from keyboard
;*****
GMPW3	CALL	CKINDO		;Can't prompt in <DO>
	RET	NZ
	@@DSPLY			;display request
	RET	NZ
	LD	BC,8<8		;max 8 chars input
	LD	HL,BUFFER	;pt to buffer
	PUSH	HL
	@@KEYIN			;Get parm input
	JP	C,BREAK
	EX	DE,HL		;buf start to DE
	LD	H,0		;buf len to HL
	LD	L,B
	ADD	HL,DE		;pt to 1st unused pos
	LD	A,8		;calculate spaces needed
	SUB	B
	JR	Z,GMPW5		;ret if none needed
	LD	B,A		;set counter for spaces
GMPW4	LD	(HL),' '	;  & put them in
	INC	HL
	DJNZ	GMPW4
;*=*=*
;	Convert (SP) through (SP)+7 to upper case
;*=*=*
GMPW5	POP	HL		;rcvr pointer to buf
	PUSH	HL
	LD	B,8		;loop through field
GMPW6	LD	A,(HL)
	CP	'a'
	JR	C,GMPW7
	CP	'z'+1
	JR	NC,GMPW7
	RES	5,(HL)		;l/c -> U/C
GMPW7	INC	HL
	DJNZ	GMPW6
	POP	DE		;rcvr ptr to start
	XOR	A		;Indicate no error
	RET
;*****
;	routine to read the granule allocation table
;*****
GATRD	PUSH	DE
	PUSH	HL
	LD	D,(IY+9)
	LD	HL,GATBUF
	LD	E,L		;Set to sector 0
	@@RDSSC
	POP	HL
	POP	DE
	LD	A,14H		;Set in case error
	RET
;*=*=*
;	Routine to check if <DO> active
;*=*=*
CKINDO	PUSH	IY
	@@FLAGS
	BIT	5,(IY+'S'-'A')
	POP	IY
	RET	Z
	LD	HL,NOINDO$
	LD	A,63
	RET
;*****
;	parse file name or ext on command line
;*****
PRSPEC	CP	'$'		;wild character?
	JR	Z,PRS2
	CP	'A'		;ck on filename entry
	JR	NC,PRS1		;jump if possible alpha
	CP	'9'+1		;ck on 0-9
	RET	NC
	CP	'0'
	RET	C
PRS1	CP	'a'		;cvrt to UC if needed
	JR	C,PRS2
	CP	'z'+1
	JR	NC,PRS2
	RES	5,A
PRS2	LD	(DE),A		;xfer max 8 chars
	INC	DE
	LD	A,(HL)
	INC	HL
	DJNZ	PRSPEC
	RET
;*=*=*
;	Routine to extract date from directory
;*=*=*
UNPACK	LD	A,(HL)		;P/u DIR+1
	AND	0FH		;Remove flags
	LD	D,A		;Save month
	INC	HL		;Pt to DIR+2
	LD	A,(HL)
	AND	0F8H		;strip year
	LD	E,A
	LD	A,(HL)
	XOR	E		;get year
	RRCA			;Shift year to 5-7
	RRCA
	RRCA
	OR	D		;Merge with month
	LD	D,A
	RET
;*=*=*
;	Pack user date string
;*=*=*
PAKDAT	LD	A,(HL)
	LD	C,'/'		;init separator
	CALL	PARSDAT		;parse entry
	JR	NZ,BADFMT	;jump on format error
	EX	DE,HL
	LD	A,(LILBUF$)	;is year a leap year?
	AND	3
	LD	HL,MAXDAYS+1	;Set Feb to have 29 days
	JR	NZ,$+3		; if so
	INC	(HL)
	LD	A,(LILBUF$+2)	;p/u month
	DEC	A		;Range check
	CP	12
	JR	NC,BADFMT	;Go if 0 or >12
	DEC	HL		;Point to Jan entry
	ADD	A,L		;index the month
	LD	L,A
	LD	A,H
	ADC	A,0
	LD	H,A
	LD	A,(LILBUF$+1)	;p/u day entry
	DEC	A		;reduce for test (0->FF)
	CP	(HL)
	JR	NC,BADFMT	;Go if too large (or 0)
	LD	HL,LILBUF$+2	;Pt to month
	LD	A,(HL)		;P/u month
	DEC	HL		;Pt to day
	LD	B,A		;Save it
	LD	A,(HL)		;P/u day
	DEC	HL		;Pt to year
	RLCA			;Shift day to 3-7
	RLCA
	RLCA
	LD	C,A
	LD	A,(HL)		;P/u year
	SUB	80		;adjust for offset
	JR	NC,$+3		;If entry < 1980,
	XOR	A		; then use 1980
	RRCA			;Shift into bits 5-7
	RRCA
	RRCA
	OR	B		;& merge with month
	LD	B,A
	EX	DE,HL
	XOR	A
	RET
BADFMT	LD	HL,BADFMT$	;Init error pointer
	LD	A,63		;Set extended error
	OR	A
	RET
;*****
;	routine to parse DATE/TIME entry
;*****
PARSDAT	LD	DE,LILBUF$+2	;point to buf end
	LD	B,3		;process 3 fields
PRSD1	PUSH	DE		;save pointer
	CALL	PRSD2		;get a digit pair
	POP	DE		;recover pointer
	RET	NZ		;ret if bad digit pair
	LD	(DE),A		;else stuff the value
	DEC	DE		;backup the pointer
	DEC	B		;loop countdown
	RET	Z
	LD	A,(HL)		;ck for valid separator
	INC	HL		;bump pointer
	CP	C		;separator char required
	JR	Z,PRSD1		;loop if match
	RET			;else ret bad (NZ)
;*****
;	routine to parse a digit pair
;*****
PRSD2	CALL	PRS4		;get a digit
	JR	NC,PRSD3	;jump if bad digit
	LD	E,A		;multiply by ten
	RLCA
	RLCA
	ADD	A,E
	RLCA
	LD	E,A
	CALL	PRS4		;get another digit
	JR	NC,PRSD3	;jump on bad digit
	ADD	A,E		;accumulate new digit
	LD	E,A		;save 2-digit value
	XOR	A		;clear flags
	LD	A,E		;xfer field value
	RET
PRSD3	OR	A		;set NZ
	RET
PRS4	LD	A,(HL)		;p/u a digit &
	INC	HL		;  convert to binary
	SUB	'0'
	CP	10
	RET
;*=*=*
;	Routine to compare DE to HL
;*=*=*
CPHLDE	LD	A,H
	SUB	D
	RET	NZ
	LD	A,L
	SUB	E
	RET
;*****
;	error processing
;*****
PRMERR	LD	A,PAR_ERR	;Parameter Error
IOERR	CP	63		;Extended error?
	JR	Z,EXTERR
	LD	L,A
	LD	H,0
	OR	0C0H		;Abbrev & return
	LD	C,A
	@@ERROR
	JR	SAVESP
;*=*=*
;	BREAK handler routine
;*=*=*
BREAK	@@CKBRKC		;Clear Break Bit
ERREXIT	LD	HL,-1
SAVESP	LD	SP,$-$		;Restore the stack
	LD	(RETCOD),HL
EXIT	EQU	$		;Exit restores BREAK
	LD	HL,0
RETCOD	EQU	$-2
	@@CKBRKC
	RET
EXTERR	@@LOGOT
	JR	ERREXIT
NOINDO$	DB	'Invalid command during <DO> '
	DB	'processing',CR
MPW$	DB	'Master password ?      ',3
BADMPW$	DB	'Invalid master password',CR
MAXDAYS	DB	31,28,31,30,31,30,31,31,30,31,30,31
BADFMT$	DB	'Bad date format',CR
PRGFIL$	DB	'Purge file: ',3
QMARK$	DB	'} ?  ',3
PURGE$	DB	'Purging: ',3
MONTBL	DM	'JanFebMarAprMayJunJulAugSepOctNovDec'
BLANKS	DM	'           '
FTFLG	DB	0
FMPAKD	DS	2
TOPAKD	DS	2
LILBUF$	DS	4
FCB1$	DS	27
;*****
;	parameter table
;*****
PRMTBL$	DB	80H
VAL	EQU	80H
SW	EQU	40H
STR	EQU	20H
SGL	EQU	10H
	DB	SW!SGL!3,'INV',0
	DW	IPARM+1
	DB	SW!SGL!3,'SYS',0
	DW	SPARM+1
	DB	SW!STR!SGL!3,'MPW',0
	DW	PWPARM+1
	DB	SW!SGL!5,'QUERY',0
	DW	QPARM+1
	DB	STR!SGL!4,'DATE',0
	DW	DATPRM+1
	NOP
FCB	DS	32
PATCH1	SUB	'0'		;cvrt to binary
	CP	7+1
	JP	NC,PRMERR
	LD	C,A
	RET
PATCH2	JP	NZ,IOERR
	LD	A,15
	JP	C,IOERR
	RET
	ORG	$<-8+1<+8
BUFFER	DS	256
GATBUF	DS	256
HITBUF	DS	256
LAST	EQU	$-1
	END	PURGE
