;LBLOAD/ASM - LOAD & RUN Commands - 10/27/83
	TITLE	<LOAD/RUN - LDOS 6.2>
;*****
;	Routine to load a file or run a program
;	at the command level. 
;*=*=*
;	Change Log
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
; 10/27/83 - Removed unnecessary break handling code &
;          - changed code to use @CKBRKC SVC. Also
;	   - fixed flashing message problem. DK
;*****
CR	EQU	13
RST28	EQU	28H
*GET	SVCMAC:3
;
	ORG	2400H
RUN	JP	RUN0
LOAD	CALL	COMMON		;parse parms & filespec
	JR	NZ,IOERR
	LD	A,(XPARM+1)	;if not (X), go to it
	OR	A
	JR	NZ,NEEDPR
	LD	DE,FCB		;pt to fcb
	@@LOAD
	JR	NZ,IOERR	;Go on error
	JR	EXIT		;  or just exit
;*****
;	need to prompt for the system disk
;*****
NEEDPR	CALL	LOADIT		;Load the file
	JR	NZ,IOERR	;Exit if error
	LD	HL,0		;Init no error
;*=*=*
;	Get the system disk back in system drive
;*=*=*
PMTSYS	PUSH	HL		;save cmd line ptr
	LD	HL,PMTSYS$
	CALL	FLASH
	POP	HL		;rcvr cmnd line ptr
	RET
;*****
;	RUN command entry
;*****
RUN0	CALL	COMMON		;Parse common args
	JR	NZ,IOERR	;Go on error
	LD	A,(XPARM+1)
	OR	A
	LD	DE,FCB
	JR	NZ,RUN1		;Prompt if (X)
	LD	A,77		;@RUN SVC
	JP	RST28
RUN1	PUSH	HL		;save cmnd line ptr
	LD	DE,FCB
	CALL	LOADIT
	EX	(SP),HL		;get cmd ptr & save ept
	JR	Z,PMTSYS	;Run if prog OK or
	POP	HL		;  pop TRAADR & error
;*=*=*
;	Error handling
;*=*=*
IOERR	CP	63		;If extended error
	JR	Z,EXTERR	;  handle by @LOGOT
	LD	L,A
	LD	H,0
	OR	0C0H
	LD	C,A
	@@ERROR
	RET
EXTERR	@@LOGOT
	LD	HL,-1
	RET
EXIT	LD	HL,0
	RET
;*****
;	flash the prompt & await reply
;*****
FLASH0	CALL	RESKFLG		;Reset 3-bit field
FLASH	LD	BC,16893	;Delay for 250 ms
	@@PAUSE
	LD	A,(IY+'K'-'A')
	AND	4!1		;Wait for no ENTER!BRK
	JR	NZ,FLASH0
	CALL	RESKFLG		;Reset in case BREAK
FLS1	@@DSPLY			;Display the message
	JP	NZ,IOERR	;abort on error
	LD	BC,4000H
	CALL	FLS2		;Blink start
	JR	NZ,GOTBRK	;Handle BREAK
	LD	C,1EH		;Cursor erase to EOL
	CALL	DSP
	LD	BC,3333H	;Wait
	CALL	FLS2		;Wait & ck enter
	JR	NZ,GOTBRK	;Handle BREAK
	JR	FLS1		;Loop until ENTER
;
;*=*=* FLS2 - Delay a while & ck on <BREAK/ENTER> *=*=*
;
FLS2	@@CKBRKC		;<BREAK> hit ?
	JR	Z,CKENT		;no - check <ENTER>
	LD	C,1EH		;Erase Line
	CALL	DSP		;output byte
	XOR	A		;Set NZ
	INC	A		;
	RET			;and RETurn
CKENT	BIT	2,(IY+'K'-'A')	;Ck ENTER bit
	JR	NZ,FLS4		;Go on ENTER down
	DEC	BC		;Count down
	LD	A,B
	OR	C
	JR	NZ,FLS2
	RET			;Return with Z-flag
;*=*=*
;	ENTER condition found
;*=*=*
FLS4	POP	AF		;Pop return code
FLS5	@@KBD			;Clear type ahead buffer
	JR	Z,FLS5		;Loop if have character
	LD	C,1EH		;Wipe line
	CALL	DSP
	LD	C,14		;Cursor on
	CALL	DSP
RESKFLG	LD	A,(IY+'K'-'A')	;Reset 3-bit field
	AND	0F8H
	LD	(IY+'K'-'A'),A
	XOR	A		;Set Z-flag
	RET
GOTBRK	LD	HL,STOP$	;Point to error message
	LD	A,63		;Init extended error
	RET			;  & return NZ
;*****
;	common initialization routine
;*****
COMMON	LD	DE,PRMTBL	;parm of X?
	@@PARAM			;
	RET	NZ		;Ret with error code
COMM1	@@FLAGS			;Get flag table pointer
COMM1A	LD	A,(HL)		;Skip past spaces
	CP	' '
	JR	NZ,COMM2
	INC	HL
	JR	COMM1A
COMM2	LD	DE,FCB		;get filespec
	@@FSPEC
	JR	NZ,COMM3	;Go on error
	LD	A,(DE)		;device specs not allowed
	CP	'*'
	JR	NZ,COMM4	;Go if OK
COMM3	LD	HL,SPCREQ$	;Point to error message
	LD	A,63		;Init extended error
	OR	A		;Set NZ condition
	RET
COMM4	PUSH	HL		;save cmdline ptr
	LD	HL,CMDEXT	;default to CMD
	@@FEXT
	CALL	GOSYS2		;get SYS2 for open
	POP	HL		;Pop the INBUF$ pointer
	RET	NZ
XPARM	LD	DE,0		;ck on X parm
	LD	A,D
	OR	E
	RET	Z		;Back on no (X)
	PUSH	HL		;Save pointer
	LD	HL,PMTSRC$	;init prompt
	CALL	FLASH		;prompt for source disk
	POP	DE		;Pointer to DE
	RET	NZ		;Back on error in HL
	EX	DE,HL		;If no error, pointer
	RET			;  back to HL
;*****
;	call SYS2 for open routine
;*****
GOSYS2	LD	A,84H		;load sys2
	RST	28H
;*****
;	loading routine
;*****
LOADIT	LD	DE,FCB
	SET	2,(IY+'S'-'A')	;turn on RUN flag
	@@LOAD			;load the file
	RET	Z
	PUSH	AF		;save error ret code
	CALL	PMTSYS		;get system disk back
	POP	AF		;rcvr error ret code
	RET
;
;
DSP	@@DSP			;display byte
	RET	Z		;return if OK
	JP	IOERR		;
;
;
SPCREQ$	DB	'File spec required',CR
PMTSYS$	DB 15,29,30,'Insert SYSTEM disk <ENTER>',29,3
PMTSRC$	DB 15,29,30,'Insert SOURCE disk <ENTER>',29,3
STOP$	DB	14,29,'Command aborted',CR
PRMTBL	DB	80H,41H,'X',0
	DW	XPARM+1
	NOP
CMDEXT	DB	'CMD'
FCB	DB	0
	DS	31
	END	LOAD
