;LBLIST - List Command - 10/31/83
	TITLE	<LIST - LDOS 6.2>
;
;*****
;
; 10/22/82 - Changed over to SVC & use 6.2 @PARAM
; 11/12/82 - Restore <BREAK> vector, & changed Hex format
;          - Added "File Open" bit depressor
; 11/29/82 - Modified exit routine to handle JCL
; 12/27/82 - Set Tab default = ON
; 01/07/83 - Clear <BREAK> bit on entry & exit
; 01/24/83 - Move @PARAM call to beginning to avoid
;	   - extra drive 0 access, & check if parameter
;	   - error before @FSPEC.
;	   - Fixed TAB = ON,OFF & changed EQUates at
;	   - end of module to DS expr.
; 01/26/83 - Corrected primary scan for parms to properly
;	     catch an ETX (or any char CR & below).
; 02/04/83 - Fixed LRL parameter & last line listed
;	   - in HEX mode.
; 02/11/83 - Corrected CKPAWS - RS
; 09/16/83 - Correct 'PUTLINE' routine to handle ETX
;            correctly.
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
; 10/27/83 - Removed unnecessary break handling code &
;          - changed code to use @CKBRKC SVC. DK
; 10/31/83 - Reorganized Code & Fixed PAUSE problem. DK
;*****
;
*GET SVCMAC:3
*GET VALUES:3
;
@PRT	EQU	6
@DSP	EQU	2
;
;
	ORG	2400H
;
;*=*=* Save SP address in case of error *=*=*
;
START
	@@CKBRKC		;Check break
	JR	Z,LISTA		; go if not
	LD	HL,-1		; else abort
	RET
;
;*=*=* <BREAK> not hit, Execute Module *=*=*
;
LISTA
	LD	(SAVESP+1),SP	;save SP
	CALL	LIST		;List a file
SAVESP	LD	SP,$-$		;p/u SP address
	@@CKBRKC
	RET			;Abort
;
;*=*=* I/O Error Processing - Display & Abort *=*=*
;
IOERR	LD	H,0		;Set HL = Error #
	LD	L,A		;
	OR	0C0H		;short error message
	LD	C,A		;stuff error # in C
	@@ERROR			;display error
	JR	SAVESP		;Abort
;
;*=*=* Internal Error Message Display Routine *=*=*
;
SPCREQ	LD	HL,SPCREQ$	;File spec Required
	@@LOGOT			;Log error message
ABORT	LD	HL,-1		;Internal error = -1
	JR	SAVESP		;p/u stack & return
;
;
;********************************************************
;***						      ***
;*** LIST - List a file in hex or ASCII		      ***
;***						      ***
;********************************************************
;
LIST	CALL	RESKFL		;reset pause, & enter
;
;*=*=* Find parameter entries if existent *=*=*
;
	PUSH	HL		;Save command ptr
FPLP	LD	A,(HL)		;p/u character
	CP	'('		;parameter(s) ?
	JR	Z,GETPRM	;yes - go get 'em
	CP	CR+1		;End of line ?
	JR	C,RESTPTR	;yes - restore ptr
	INC	HL		;no - bump til end
	JR	FPLP		;do til eol or "("
;
;*=*=* Process any parameters entered *=*=*
;
GETPRM	LD	DE,PRMTBL$	;DE => Parameter table
	@@PARAM			;@PARAM
	JP	NZ,IOERR	;NZ - "Parameter Error"
RESTPTR	POP	HL		;recover ptr
;
;*=*=* Skip command line blanks *=*=*
;
IGSPC	LD	A,(HL)		;p/u character
	INC	HL		;bump ptr
	CP	' '		;space ?
	JR	Z,IGSPC		;yes - ignore them
	DEC	HL		;HL => First non-space
;
;*=*=* Check if the filespec is legal in format *=*=*
;
	LD	DE,FCB1		;fetch file spec
	@@FSPEC			;Filespec legal ?
	JP	NZ,SPCREQ	;no - filespec required
;
;*=*=* If this is a device - don't LIST *=*=*
;
	LD	A,(DE)		;Is this a device ?
	CP	'*'		;
	JP	Z,SPCREQ	;yes - Filespec req
;
;*=*=* Save the original filespec *=*=*
;
	EX	DE,HL		;HL => Source FCB
	LD	DE,FCB2		;DE => Duplicate FCB
	LD	BC,32		;32 bytes tm xfer
	PUSH	HL		;Save source ptr
	LDIR			;xfer
	POP	DE		;DE => Source FCB
;
;*=*=* Stuff default extension of /TXT to source *=*=*
;
	LD	HL,TXTEXT	;HL => TXT
	@@FEXT			;stuff TXT if no ext
;
;*=*=* Open the file with LRL of 256 *=*=*
;
	LD	B,0		;Set LRL (B) = 256
	CALL	OPEN		;Open file with LRL=256
	JR	Z,INITLRL	;good - LIST it
;
;*=*=* Error - Was it a "File not Found" Error ? *=*=*
;
	CP	24		;"File not Found" ?
	JP	NZ,IOERR	;no - I/O Error
;
;*=*=* OPEN original filespec instead of TXT *=*=*
;
	LD	C,32		;BC = 32 bytes to xfer
	PUSH	DE		;DE => FCB1
	PUSH	HL		;Save I/O buff ptr
	LD	HL,FCB2		;HL => Filespec
	LDIR			;xfer original filespec
	POP	HL		;HL => I/O buffer
	POP	DE		;DE => unopen FCB
;
;*=*=* Open Original Filespec without extension *=*=*
;
	CALL	OPEN		;Open the file
	JP	NZ,IOERR	;I/O error - abort
;
;*=*=* Pick up the DEC from the FCB *=*=*
;
INITLRL	PUSH	DE		;xfer fcb to IX
	POP	IX
	LD	B,(IX+7)	;p/u DEC
	LD	C,(IX+6)	;& drive #
	@@DIRRD			;Read in Entry
;
;*=*=* Was the LRL parm specified ? *=*=*
;
	LD	A,(LRESP)	;p/u response
	OR	A		;
	JR	NZ,SKIPLRL	;entered - skip check
;
;*=*=* Point HL => LRL byte of Directory entry *=*=*
;
	LD	A,L		;Position to DIR+4
	ADD	A,4		;
	LD	L,A		;HL => LRL byte (DIR+4)
;
;*=*=* Pick up LRL & stuff into LRL parameter *=*=*
;
	LD	A,(HL)		;p/u LRL
	LD	(LPARM+1),A	;set dir LRL into parm
;
;*=*=* Pick up LRL & stuff into FCB *=*=*
;
SKIPLRL	LD	A,(LPARM+1)	;P/u possible new LRL
	LD	(IX+9),A	;Put into FCB
	SET	7,(IX+1)	;Mark for byte I/O
;
;*=*=* Check if TAB (T) parm is flag or numeric *=*=*
;
	LD	A,(TRESP)	;p/u response byte
	AND	40H		;Flag response ?
	LD	A,(TPARM+1)	;p/u value
	JR	Z,NOTFLG	;no - numeric
;
;*=*=* Flag Response - Is it ON (T=8) or OFF (T=1) *=*=*
;
	INC	A		;Tab=OFF (NZ) or ON (Z) ?
	JR	NZ,NOTFLG	;Tab = OFF ---> TABEXP=1
	LD	A,8		;Tab = ON ---> TABEXP=8
;
;*=*=* P/u TAB (T) parm value & stuff into routine *=*=*
;
NOTFLG	LD	(TABEXP+1),A	;stuff away
	DEC	A		;Range can
	CP	32		;only be between 1-32.
	LD	A,PAR_ERR	;greater - Parm Error
	JP	NC,IOERR	;
;
;*=*=* Was the P parameter entered ? *=*=*
;
PPARM	LD	BC,$-$		;p/u P parameter
	LD	A,B		;Was it specified ?
	OR	C		;
	JR	Z,HPARM		;no - use @DSP
;
;*=*=* Stuff @PRT SVC # in output routine *=*=*
;
	LD	A,@PRT		;@PRT SVC Number
	LD	(PUTOUT1+1),A	;overwrite @DSP
;
;*=*=* Hex Parameter Entered ? *=*=*
;
HPARM	LD	BC,$-$		;p/u Hex parm
	LD	A,B		;entered ?
	OR	C		;
	JP	NZ,RPARM	;yes - check out Records
;
;*=*=* Routine to LIST a file in ASCII *=*=*
;
	LD	(BYTCTR),A	;init counter to 0
;
LINPRM	LD	BC,1		;p/u line parm
	DEC	BC		;count down for start
	LD	A,B		;Ready to list ?
	OR	C		;
	JR	Z,BGNLIN	;go list/print if ready
	LD	DE,FCB1		;DE => FCB
;
;*=*=* Ignore this line and position to next *=*=*
;
FND1ST	@@GET			;get a character
	JP	NZ,IOERR	;error - abort
	CP	CR		;end of line?
	JR	NZ,FND1ST	;keep reading
;
;*=*=* Finished with line - decrement LINE count *=*=*
;
	DEC	BC		;dec line counter
	LD	A,B		;Finished
	OR	C		;ignoring lines ?
	JR	NZ,FND1ST	;no - loop until LINES=0
;
;*=*=* Start LISTing File *=*=*
;
BGNLIN	LD	HL,(LINPRM+1)	;P/u original line #
	LD	BC,VARDOT	;convert to Decimal ASCII
	CALL	CVTDEC		;and stuff into string.
;
;*=*=* Read in a character from the file *=*=*
;
GETCHR	LD	DE,FCB1		;DE => FCB
	@@GET			;Get a byte
	JR	NZ,GOTERR	;error - write line
	LD	(PUCHAR+1),A	;hang on to char
;
;*=*=* Test if NUM parameter was entered *=*=*
;
NPARM	LD	BC,$-$		;p/u N parameter
	LD	A,B		;was it entered ?
	OR	C		;
	JR	Z,PUCHAR	;no - don't print line #
;
;*=*=* N parm entered - print line # & Increment it *=*=*
;
	LD	HL,VARDOT	;HL => Buffer with line #
	PUSH	HL		;save ptr
	CALL	PUTLINE		;output line @ HL
	POP	HL		;restore line # ptr
	CALL	INCNUM		;Increment line #
;
;*=*=* Pick up character and Check if high bit set *=*=*
;
PUCHAR	LD	A,$-$		;P/u character
DLOOP	RLCA			;Get HB into Carry flag
;
;*=*=* Reset High bit unless A8 parameter entered *=*=*
;
A8PARM	LD	DE,$-$		;p/u A8 parm
	INC	D		;Was it entered ?
	DEC	D		;
	JR	NZ,A8BIT	;yes - don't change byte
	SRL	A		;Reset Bit 7
	DB	1EH		;LD E,nn instruction
A8BIT	RRCA			;Use all 8 bits
;
;*=*=* Is the character a Tab ? *=*=*
;
	PUSH	AF		;Save C flag
	CP	TAB		;Was it a tab ?
	JR	NZ,NOTTAB	;no - don't check TAB
;
;*=*=* Character is a Tab - Was T=N specified ? *=*=*
;
TPARM	LD	DE,0008H	;p/u TAB parm (Default=8)
	INC	E		;TAB = N ?
	DEC	E		;
	JR	Z,NOTTAB	;yes - don't expand
;
;*=*=* P/u column # & calculate # of spaces to pad *=*=*
;
	LD	A,(BYTCTR)	;p/u column number
TABEXP	LD	C,8		;p/u TAB expansion #
CLOOP	SUB	C		;
	JR	NC,CLOOP	;
	NEG			;subtract A from Col #
;
;*=*=* Output A blank spaces for tab expansion *=*=*
;
	LD	B,A		;Put # spaces in B
TP1	LD	A,' '		;Pad with a space
	CALL	PUTOUT		;Output character
	DJNZ	TP1		;B spaces to output
	JR	WASTAB		;check byte counter
;
;*=*=* Character was not a tab, display it *=*=*
;
NOTTAB	CALL	PUTOUT		;Print the character
WASTAB	LD	A,(BYTCTR)	;p/u byte counter
	OR	A		;If C/R printed
	CALL	Z,CKPAWS	;then check for <PAUSE>
;
;*=*=* Check for <PAUSE> if hi bit set on character *=*=*
;
	POP	AF		;Get back char
	CALL	C,CKPAWS	;If high bit was set
;
;*=*=* If character = C/R then read in another line *=*=*
;
	CP	CR		;Was it C/R ?
	JR	Z,GETCHR	;yes - get new line
;
;*=*=* Get another byte from file *=*=*
;
	LD	DE,FCB1		;DE => FCB
	@@GET			;Get a byte
	JR	Z,DLOOP		;good - check character
;
;*=*=* I/O Error on @GET - Output a Carriage Return *=*=*
;
GOTERR	PUSH	AF		;save error code
	LD	A,CR		;write end of line
	CALL	PUTOUT		;
	POP	AF		;rcvr error code
;
;*=*=* If End of File Error - Exit normally *=*=*
;
	LD	HL,0		;Set HL = 0 (normal exit)
	CP	1CH		;EOF?
GTBK	JP	Z,SAVESP	;p/u old <BREAK> & RETurn
	CP	1DH		;NRN > ERN?
	JR	Z,GTBK		;yes - p/u <BREAK> & exit
	JP	IOERR		;other - Abort
;
;*=*=* LIST a file in HEX format *=*=*
;
RPARM	LD	BC,$-$		;p/u starting Record #
	LD	DE,FCB1		;DE => FCB
	@@POSN			;Position to Record BC
	JP	NZ,IOERR	;abort on position error
;
;*=*=* Reset byte counter to Zero *=*=*
;
DOHEX	XOR	A		;init byte counter to 0
	LD	(DOHEX1+1),A	;
;
;*=*=* Stuff Record Number in Line Number buffer *=*=*
;
	LD	DE,(RPARM+1)	;p/u Record Number
	LD	HL,VARCLN+1	;HL => Hex ASCII dest
	@@HEX16			;convert DE to ASCII
;
;*=*=* Bump Record Number & stuff into RPARM *=*=*
;
	INC	DE		;bump by one
	LD	(RPARM+1),DE	;& store for next time
;
LPARM	LD	BC,$-$		;p/u LRL
;
;*=*=* Convert Byte counter to Hex & stuff in buff *=*=*
;
DISBYTE	PUSH	BC		;Save bytes left in Rec
DOHEX1	LD	C,$-$		;p/u byte counter
	LD	HL,VAREQU	;HL => Hex ASCII dest
	@@HEX8			;cvrt C to ASCII @ HL
	POP	BC		;BC = Bytes left in Rec
;
;*=*=* Display Record Number/Starting byte string *=*=*
;
	LD	HL,VARCLN	;HL => Display buffer
	CALL	PUTLINE		;display Rec # byte
;
;*=*=* P/u byte counter & add 16 (BPL) & stuff away *=*=*
;
	LD	A,(DOHEX1+1)	;p/u byte counter
	LD	B,16		;Set B = 16 bytes
	ADD	A,B		;add 16 to byte count
	LD	(DOHEX1+1),A	;& stuff into LD C inst
;
	LD	HL,LINBUF	;HL => Line buffer
;
;*=*=* Get a byte from the File *=*=*
;
DOHEX2	LD	DE,FCB1		;DE => FCB
	@@GET			;get a byte
	JR	Z,DOHEX4	;good - stuff byte
;
;*=*=* End of File Error ? *=*=*
;
	PUSH	AF		;save error code
	CP	1CH		;EOF?
	JR	Z,DOHEX3	;yes - Okay
;
;*=*=* Past End of File Error ? *=*=*
;
	CP	1DH		;NRN>ERN?
	JP	NZ,IOERR	;another error
;
;*=*=* Recover Flags & check type of Error *=*=*
;
DOHEX3	POP	AF		;recover error code
DOHEX4	JR	NZ,DOHEX5	;bypass if at end of file
;
;*=*=* Stuff Character in buffer & bump *=*=*
;
	LD	(HL),A		;stuff byte in buffer
	INC	HL		;bump ptr
;
;*=*=* Output byte in Hex & follow with a space *=*=*
;
	CALL	CVTHEX		;output the byte in hex
	LD	A,' '		;followed by a space
	CALL	PUTOUT		;
;
;*=*=* Output an extra space if halfway in line *=*=*
;
	LD	A,B		;p/u byte counter
	CP	9		;halfway yet?
	CALL	Z,WR1SPA	;yes - display space
;
;*=*=* Dec Chars/Line & # of chars left in Rec *=*=*
;
	DEC	B		;count down
	DEC	C		;count down the LRL
	JR	Z,DOHEX5	;done - get next record
;
;*=*=* Finished with Line ? *=*=*
;
	LD	A,B		;Done with line ?
	OR	A		;
	JR	NZ,DOHEX2	;no - do til 16 chars
;
;*=*=* Finished with Line or Logical Record *=*=*
;
DOHEX5	PUSH	AF		;end the line
	LD	A,B		;p/u byte counter
	CP	16		;done with this line ?
	JR	Z,PRTLIN2	;yes - get another record
;
;*=*=* Display ASCII equivalent of line *=*=*
;
PRTLIN	PUSH	BC		;save counters
;
;*=*=* Multiply # of chars not printed by three *=*=*
;
	LD	A,B		;p/u # chars not printed
	ADD	A,A		;x 2
	ADD	A,B		;x 3
	LD	B,A		;stuff in B
;
;*=*=* Add two extra spaces if more than halfway *=*=*
;
	CP	27		;need extra space if
	CCF			;not halfway
	LD	A,1		;plus 1 more spaces
	ADC	A,B		;carry set for 3 spaces
;
;*=*=* Position to ASCII portion of line *=*=*
;
	LD	B,A		;set loop counter
	CALL	WRSPA		;output B spaces
	POP	BC		;recover the counters
;
;*=*=* Calculate # of characters to print *=*=*
;
	LD	A,16		;get # to print
	SUB	B
	LD	B,A		;xfer to B for DJNZ
	LD	HL,LINBUF	;HL => Line buffer
	PUSH	BC		;Save C
	LD	C,8		;space after 8
;
;*=*=* Display ASCII part of line *=*=*
;
PRTLIN1	LD	A,(HL)		;p/u character
	INC	HL		;bump ptr
	CALL	CVTDOT		;output each char
	DEC	C		;Space yet ?
	CALL	Z,WR1SPA	;yes - display space
	DJNZ	PRTLIN1		;output line
	POP	BC		;recover C
;
;*=*=* End of Line - Output C/R & check for EOF *=*=*
;
PRTLIN2	LD	A,CR		;Output C/R
	CALL	PUTOUT		;
	POP	AF		;recover @GET ret code
	LD	A,1CH		;init to EOF
	JP	NZ,GOTERR	;End of file - Abort
;
	CALL	CKPAWS		;<PAUSE> or <BREAK> ?
;
;*=*=* Are we done with the Record ? *=*=*
;
	LD	A,C		;p/u # of bytes left
	OR	A		;finished ?
	JP	NZ,DISBYTE	;no - get next line
;
;*=*=* Finished with record - Output space & C/R *=*=*
;
	LD	A,' '		;Space
	CALL	PUTOUT		;
	LD	A,CR		;Carriage Return
	CALL	PUTOUT		;
;
;*=*=* Increment Line Number *=*=*
;
	LD	HL,VARCLN	;HL => Line Number
	CALL	INCNUM		;Increment
	JP	DOHEX		;loop for more
;
;
;********************************************************
;***						      ***
;*** CVTDOT - Output chars & convert non-printables   ***
;***						      ***
;********************************************************
;
CVTDOT	CP	' '		;don't print controls
	JR	C,CVTDOT1	;
	CP	7FH		;print X'20' thru X'7E'
	JR	C,PUTOUT	;
CVTDOT1	LD	A,'.'		;otherwise change to "."
	JR	PUTOUT		;
;
;
;********************************************************
;***						      ***
;*** CVTHEX - Convert A tm Hex ASCII & Output it      ***
;***						      ***
;********************************************************
;
CVTHEX	PUSH	AF		;Save Lower digit
	RRCA			;Get most sig nibble
	RRCA			;
	RRCA			;
	RRCA			;
	CALL	CVTH1		;Output upper nibble
	POP	AF		;recover #
;
CVTH1	AND	0FH		;Mask off upper nibble
	ADD	A,90H		;Convert to Hex digit
	DAA			;
	ADC	A,40H		;
	DAA			;Fall into Output byte
;
;
;********************************************************
;***						      ***
;*** PUTOUT - Put out a byte to *DO/*PR		      ***
;***						      ***
;********************************************************
;
PUTOUT	PUSH	BC		;Save BC
	LD	C,A		;xfer char to C
;
;*=*=* Output byte to *DO or *PR *=*=*
;
PUTOUT1	LD	A,@DSP		;@DSP or @PRT SVC #
	RST	28H		;
	JP	NZ,IOERR	;NZ - I/O Error
;
;*=*=* Increment byte counter *=*=*
;
	PUSH	HL		;Save HL
	LD	HL,BYTCTR	;HL => Byte counter
	INC	(HL)		;bump counter
	LD	A,C		;p/u byte
	CP	CR		;end of line ?
	JR	NZ,NOTCR	;no - rest regs & RETurn
;
	LD	(HL),0		;reset byte counter
NOTCR	POP	HL		;restore registers
	POP	BC		;
	RET			;& RETurn
;
;
;*=*=* Output B spaces to Display or Printer *=*=*
;
WRSPA	CALL	WR1SPA		;Write a space
	DJNZ	WRSPA		;do it B times
	RET			;RETurn
;
;*=*=* Output a space to Display or Printer *=*=*
;
WR1SPA	LD	A,' '		;Space Character
	JR	PUTOUT		;output byte
;
;
;********************************************************
;***						      ***
;*** PUTLINE - Output a line to the video or printer  ***
;***						      ***
;*** HL => Line of data to output		      ***
;***						      ***
;********************************************************
;
PUTLINE	LD	A,(HL)		;p/u byte
	INC	HL		;prepare for next
	CP	ETX		;check if done none
	RET	Z		; return if so
	CALL	PUTOUT		;char OK output it
	CP	CR		;Check for CR
	RET	Z		; return if so
	JR	PUTLINE
;
;
;********************************************************
;***						      ***
;*** CKPAWS - Check for Pause (SHIFT @)		      ***
;***						      ***
;********************************************************
;
CKPAWS	@@FLAGS			;IY => System flags
;
;*=*=* Was the <BREAK> key pressed ? *=*=*
;
	@@CKBRKC		;<BREAK> hit ?
	JR	NZ,GOTBRK	;
;
;*=*=* Was the <SHIFT><@> pressed ? *=*=*
;
	BIT	1,(IY+KFLAG$)	;Is the <PAUSE> bit set ?
	RET	Z		;return if not <SHIFT><@>
;
;*=*=* Pause - Wait for key to continue *=*=*
;
CKWAIT	@@KEY			;wait for key press
CKWAIT1	CP	60H		;was key a <SHIFT @>?
	JR	Z,CKWAIT	;ignore if it was
	CP	80H
	JR	Z,GOTBRK
;
;*=*=* Reset <PAUSE> & <ENTER> bits & RETurn *=*=*
;
RESKFL	@@FLAGS			;IY => Flag Table
	LD	A,(IY+KFLAG$)	;p/u KFLAG$
	AND	0F9H		;Reset Pause and Enter
	LD	(IY+KFLAG$),A	;stuff into KFLAG$
	RET
;
;*=*=* <BREAK> hit - Display C/R & Abort *=*=*
;
GOTBRK	LD	A,CR		;send end of line
	CALL	PUTOUT		;output byte
	JP	ABORT		;and abort due to BREAK
;
;
;********************************************************
;***						      ***
;*** CVTDEC - Convert HL to Decimal & stuff in BC     ***
;***						      ***
;********************************************************
;
CVTDEC	LD	DE,10000	;Divide by 10000
	CALL	CVD1		;
	LD	DE,1000		;Divide by 1000
	CALL	CVD1		;
	LD	DE,100		;Divide by 100
	CALL	CVD1		;
	LD	DE,10		;Divide by 10
	CALL	CVD1		;
	LD	DE,1		;Divide by 1
;
;*=*=* Divide Quotient in HL by value in DE *=*=*
;
CVD1	XOR	A		;Clear carry set A=0
CVD2	SBC	HL,DE		;Subtract Divisor
	JR	C,CVD3		;done -	add back divisor
	INC	A		;bump counter
	JR	CVD2		;subtract until a Carry
;
;*=*=* Add divisor to neg rem & cvrt A to ASCII *=*=*
;
CVD3	ADD	HL,DE		;HL = New quotient
	ADD	A,'0'		;A = ASCII numeric digit
	CP	'0'		;Zero ?
	JR	NZ,CVD4		;no - stuff in buff (BC)
;
;*=*=* Char is a Zero - use space if leading zero *=*=*
;
	DEC	BC		;backspace buff ptr
	LD	A,(BC)		;p/u last char
	INC	BC		;bump to currentt
	CP	' '		;last char a space ?
	JR	Z,CVD4		;yes - don't use lead 0
	LD	A,'0'		;no - use zero
;
;*=*=* Stuff Numeric ASCII character into buffer *=*=*
;
CVD4	LD	(BC),A		;stuff char in buff
	INC	BC		;bump ptr
	RET			;RETurn
;
;
;********************************************************
;***						      ***
;*** INCNUM - Increment Line number in buffer (HL)    ***
;***						      ***
;********************************************************
;
INCNUM	INC	HL		;point to lo-order digit
	INC	HL		;
	INC	HL		;
	INC	HL		;
;
;*=*=* Loop to Increment digit and return if done *=*=*
;
INCNUM1	LD	A,(HL)		;p/u digit
	OR	'0'		;start with possible 0
	INC	A		;add 1
	LD	(HL),A		;restuff
	SUB	'9'+1		;see if went to 10
	RET	C		;ret if not
	LD	(HL),'0'	;make it 0
	DEC	HL		;b/u one
	JR	INCNUM1		;& loop
;
;
;********************************************************
;***						      ***
;*** OPEN - Open a file				      ***
;***						      ***
;********************************************************
;
OPEN	@@FLAGS			;IY => System Flags
	SET	0,(IY+SFLAG$)	;p/u SFLAG$
	LD	HL,IOBUFF	;HL => I/O buffer
	@@OPEN			;open the file
	RET			;& RETurn with condition
;
SPCREQ$	DB	'File spec required',CR
;
;
VARDOT	DB	'     . ',ETX
VARCLN	DB	'     :'
VAREQU	DB	'XX =  ',ETX
TXTEXT	DB	'TXT'
;
;
;##########  PARAMETER TABLE  ############
;
PRMTBL$	DB	80H
;
;***  ASCII8 (A8) - Flag input only  ***
;
	DB	FLAG!6
	DB	'ASCII8'
	DB	0
	DW	A8PARM+1
;
	DB	FLAG!2
	DB	'A8'
	DB	0
	DW	A8PARM+1
;
;***  LINE - Numeric input only  ***
;
	DB	NUM!4
	DB	'LINE'
	DB	0
	DW	LINPRM+1
;
;***  NUM (N) - Flag input only  ***
;
	DB	FLAG!ABB!3
	DB	'NUM'
	DB	0
	DW	NPARM+1
;
;***  HEX (H) - Flag input only  ***
;
	DB	FLAG!ABB!3
	DB	'HEX'
	DB	0
	DW	HPARM+1
;
;***  REC (R) - Numeric input only  ***
;
	DB	NUM!ABB!3
	DB	'REC'
	DB	0
	DW	RPARM+1
;
;***  LRL (L) - Numeric input only  ***
;
	DB	NUM!ABB!3
	DB	'LRL'
LRESP	DB	0
	DW	LPARM+1
;
;***  P - Flag input only  ***
;
	DB	FLAG!1
	DB	'P'
	DB	0
	DW	PPARM+1
;
;***  TAB (T) - Flag input only  ***
;
	DB	FLAG!ABB!3
	DB	'TAB'
TRESP	DB	0
	DW	TPARM+1
;
	DB	0
;
;
;################  Buffer Area  ###############
;
BYTCTR	DS	1
LINBUF	DS	16
FCB1	DS	32
FCB2	DS	32
;
	ORG	$<-8+1<+8
IOBUFF	DS	256
;
;
	END	START
