;LBLIB/ASM - LIB/CLS/TOF Commands - 11/05/83
	TITLE	<LIB - LDOS 6.2>
*GET	SVCMAC:3
;*****
;	Change log
;
; 09/15/83 - Change method of finding sys1 LIB TABLE
; 09/25/83 - Added 'CLS' and 'TOF' to module
;
;
;*****
CR	EQU	13
LF	EQU	10
OVLAY$	EQU	1E00H
	ORG	2400H
;
LIB	JP	JPLIB		;skip around to 'LIB'
	JP	CLS		;skip around to 'CLS'
;
TOF
	LD	C,12		;load TOF character
	@@PRT			; do @PRT SVC
	LD	HL,0
	RET	Z
TOFERR	LD	L,A		;P/u ERROR code
	LD	H,0
	OR	0C0H		;Set brief & return
	LD	C,A		;short error message
	@@ERROR
	RET
;
CLS	LD	A,105		; @CLS svc
	RST	40		; do it
	XOR	A		;ret without ERROR
	LD	L,A
	LD	H,A
	RET
;
JPLIB	LD	B,3		;Init for 3 libraries
LIB0	PUSH	BC
	@@DSPLY	LIBMSG
	LD	(HL),LF		;Put LF at start of
				; string fo next time
	LD	HL,(OVLAY$+2)	;PU table pointer
LIB1	LD	B,2		;space codes
	CALL	TAB
	LD	C,7		;init for 7-across
LIB2	LD	A,(HL)
	OR	A
	JR	Z,LIB4		;jump on end
	PUSH	HL
	LD	DE,7
	ADD	HL,DE
LIBX	LD	A,80H		;Init for LIB-A
	CP	(HL)		;Is this command in
	JR	Z,LIB2A		;  the current library?
	POP	AF		;Is not, skip past it
	INC	HL
	JR	LIB2
LIB2A	POP	HL		;Get 1st char of command
	PUSH	BC		;Save reg C
	LD	C,(HL)		;  and display in upper
	@@DSP
	LD	B,5		;write 6-char LIB word
LIB3	INC	HL		;Point to next char
	LD	A,(HL)
	CP	' '		;If space, don't lower
	JR	Z,$+4		;  case the char
	XOR	20H
	LD	C,A		;Xfer to C & display it
	@@DSP
	DJNZ	LIB3
	LD	B,5		;space over a tad
	CALL	TAB
	INC	HL		;bypass LIB parm vector
	INC	HL
	INC	HL
	POP	BC		;Get across counter
	DEC	C		;  & decrement
	JR	NZ,LIB2		;loop on < 5
	LD	C,CR		;write a new line
	@@DSP
	JR	LIB1		;loop
LIB4	LD	C,CR		;end with new line
	@@DSP
	LD	HL,LIBMSG+10
	INC	(HL)		;Bump to next lib
	LD	A,(LIBX+1)	;Advance RST code also
	ADD	A,20H
	LD	(LIBX+1),A
	POP	BC
	DJNZ	LIB0
	LD	HL,0		;Set no error
	RET
TAB	LD	C,' '
	@@DSP
	DJNZ	TAB
	RET
LIBMSG	DB	0,'Library <A>',CR
	END	LIB
