;LBFORMS - Set Line Printer Values - 10/31/83
;
	TITLE	<FORMS - LDOS 6.2>
;
;*****
;
;	Change Log
;
; 01/26/83 - Added Default (D) parm which sets back all
;	   - values to original values.
; 02/04/83 - Double checked by DK.
; 02/06/83 - Cleaned up a bit - RS
; 02/15/83 - Change $PF to $FF
; 02/25/83 - Revise order of STRTAB
; 03/01/83 - Fixed (Q) option.
; 04/28/83 - Added Validity check on values & changed
;	   - default setting to use a table, &
;	   - (Q) overrides any values entered on CL - DK
; 05/06/83 - Fixed XLATE used in Command line & added
;	   - check for INDENT default being less than
;	   - or equal to CHARS-MARGIN - DK.
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
; 10/27/83 - Added call to @CKBRKC in Abort routine. DK
; 10/31/83 - Reorganized Code. DK
;
;*****
;
PAR_ERR	EQU	44		;Parameter Error Code
FLAGBT	EQU	7		;Flag byte offset
ADDLF	EQU	7		;Add Line Feed = Bit 0
FFHARD	EQU	7		;Form Feed Hard = Bit 1
TABV	EQU	7		;Tab Expansion = Bit 2
CHARS	EQU	8		;Characters per line
INDENT	EQU	6		;Indent after wrap-around
LINES	EQU	2		;Maximum Lines to Print
MARGIN	EQU	9		;left hand margin value
PAGE	EQU	0		;Maximum Lines per page
XLATEF	EQU	4		;Xlate From
XLATET	EQU	5		;Xlate To
;
PDEF	EQU	66		;Page Default = 66
LDEF	EQU	66		;Line Default = 66
;
CURON	EQU	0EH		;Cursor on
CUROFF	EQU	0FH		;Cursor off
SKIP	EQU	0DDH		;Skip 3 byte instruction
;
;
*GET SVCMAC:3
*GET VALUES:3
;
	ORG	2400H
;
START
	LD	(SAVESP+1),SP	;save SP loc
	CALL	FORMS		;Execute Form Code
EXIT	LD	HL,0		;set HL = 0
	JR	SAVESP		;exit
;
;*=*=* I/O Error Handling *=*=*
;
PRMERR	LD	A,PAR_ERR	;Parameter Error
IOERR	LD	L,A		;xfer error # to HL
	LD	H,0		;
	OR	0C0H		;short mess & RETurn
	LD	C,A		;xfer to C
	@@ERROR			;display error
	JR	SAVESP		;go to exit routine
;
;*=*=* Internal Error Message Handling *=*=*
;
NOPF	LD	HL,NOPF$	;no filter !!!
	@@LOGOT			;Log Message
ABORT	LD	HL,-1		;Abort JCL
SAVESP	LD	SP,$-$		;p/u original SP
	@@CKBRKC		;clear any <BREAK>
	RET			;and RETurn to DOS
;
;
;********************************************************
;***						      ***
;*** FORMS - Process the Forms Filter Parameters      ***
;***						      ***
;********************************************************
;
FORMS
	CALL	DOINIT		;Do initialization
;
;*=*=* Ignore Leading Spaces *=*=*
;
	DEC	HL		;
IGSPCS	INC	HL		;
	LD	A,(HL)		;Skip leading spaces
	CP	' '		;
	JR	Z,IGSPCS	;
;
;*=*=* Any Parameters Entered ? *=*=*
;
	CP	CR+1		;End of line ?
	JR	NC,GETPRM	;yes - Display Defaults
;
;*=*=* Display current parameter settings *=*=*
;
DISPFRM	CALL	DSFORMS		;create default string
	CALL	DSPLY		;display defaults
	RET			;and RETurn
;
;*=*=* Display "Paramter Error" if Illegal input *=*=*
;
GETPRM	LD	DE,PRMTBL$	;Any Paramters ?
	@@PARAM			;
	JP	NZ,PRMERR	;NZ - "Parameter Error"
;
;*=*=* Create Xlate From Data Area *=*=*
;
	LD	A,(XTRESP)	;p/u xlate TO response
	LD	(XFRESP),A	;xfer to FROM response
	LD	HL,XTPARM+1	;HL => XLATE From
	LD	A,(HL)		;p/u Xlate from
	LD	(HL),0		;set Xlate To msb = 0
	LD	(XFPARM),A	;xfer to FROM parm
;
;*=*=* Over-ride all other parms if <D>efault *=*=*
;
	LD	A,(DRESP)	;<D>efault Parm entered ?
	OR	A		;
	JR	Z,CHECKQ	;no - check for <Q>uery
;
;*=*=* Overwrite $FF data area with default values *=*=*
;
	LD	DE,(DATAREA+2)	;DE => Data area start
	LD	BC,10		;BC = 10 bytes in table
	LD	HL,DEFTAB	;HL => Default Table
	PUSH	HL		;save regs
	PUSH	BC		;
	LDIR			;xfer to $FF data area
	POP	BC		;
	POP	HL		;
	LD	DE,DUPDA	;
	LDIR			;xfer to duplicate DA
	JR	DISPFRM		;display forms & exit
;
;*=*=* Prompt for any parms not entered & stuff *=*=*
;
CHECKQ	EQU	$
	CALL	INITVAL		;Init parm values = def's
	CALL	DSFORMS		;Create string
	LD	A,(QRESP)	;<Q>uery ?
	OR	A		;
	CALL	Z,CKCOMM	;check comm line values
	CALL	NZ,PROMPT	;Prompt if "Q"
STUFFIN	CALL	STFPRMS		;Stuff parms in $FF data
	JP	EXIT		;good exit
;
;*=*=* Display Current FORMS value settings *=*=*
;
DSFORMS	BIT	0,(IX+ADDLF)	;Add line feed ?
	LD	DE,SADDLF	;
	CALL	NZ,XFERON	;
;
;*=*=* Display "OFF" if zero, or value if <> zero *=*=*
;
	LD	A,(IX+CHARS)	;CHARS value if it wasn't
	OR	A		;OFF ?
	LD	DE,SCHARS	;Convert to decimal
	CALL	NZ,HEXDEC	;
	JR	NZ,DOFFHRD	;go to FFHARD
;
CHAROFF	LD	HL,OFFSTR	;Xfer OFF into string
	CALL	XFER		;
;
;*=*=* FFHARD specified ? *=*=*
;
DOFFHRD	BIT	1,(IX+FFHARD)	;FFHARD ?
	LD	DE,SFFHARD	;
	CALL	NZ,XFERON	;xfer ON if set
;
;*=*=* Xfer INDENT value into string *=*=*
;
	LD	A,(IX+INDENT)	;default
	LD	DE,SINDENT	;convert to decimal
	CALL	HEXDEC		;
;
;*=*=* Xfer LINES value into string *=*=*
;
	LD	A,(IX+LINES)	;p/u LINES value
	LD	DE,SLINES	;
	CALL	HEXDEC		;convert to decimal
;
;*=*=* Xfer MARGIN value into string *=*=*
;
	LD	A,(IX+MARGIN)	;p/u MARGIN value
	LD	DE,SMARGIN	;convert to decimal
	CALL	HEXDEC		;
;
;*=*=* Xfer PAGE value into string *=*=*
;
	LD	A,(IX+PAGE)	;entered on the cl.
	LD	DE,SPAGE	;convert to decimal
	CALL	HEXDEC		;
;
;*=*=* Xfer "ON" into string if Tab set *=*=*
;
	BIT	2,(IX+TABV)	;Tab set
	LD	DE,STAB		;
	CALL	NZ,XFERON	;xfer off if set
;
;*=*=* Is Xlate FROM = Xlate TO ? *=*=*
;
	LD	A,(IX+XLATEF)	;p/u FROM byte
	LD	B,(IX+XLATET)	;p/u TO byte
	CP	B		;same
	JR	Z,NOSHOW	;yes - no show
;
;*=*=* To distinct values - convert to Hex *=*=*
;
	LD	HL,DOXLATE	;change LF to CR
	LD	(HL),LF		;
;
	LD	HL,SXLFROM	;Destination
	CALL	HEX8		;convert A to Hex @ HL
	LD	A,B		;p/u TO
	LD	HL,SXLTO	;Destination
	CALL	HEX8		;convert A to Hex @ HL
;
;*=*=* Point HL to string & RETurn *=*=*
;
NOSHOW	LD	HL,VALUES	;HL => Default val string
	RET			;RETurn
;
;
;***
;	CKCOMM - Check command line parameter values
;***
;
CKCOMM	LD	E,10		;10 values to check
	LD	IY,STRTAB	;IY => Response table
;
CKCOMML	LD	L,(IY+1)	;p/u address of response
	LD	H,(IY+2)	;
;
;*=*=* Set BC = Parameter Response *=*=*
;
	LD	A,(HL)		;Was anything entered ?
	OR	A		;
	INC	HL		;Parm addr follows resp
	LD	C,(HL)		;set HL = (HL)
	INC	HL		;
	LD	H,(HL)		;
	LD	L,C		;
	LD	C,(HL)		;p/u response
	INC	HL		;
	LD	B,(HL)		;
;
;*=*=* Call routine to Range check parm entry *=*=*
;
	LD	L,(IY+5)	;p/u address of routine
	LD	H,(IY+6)	;to check value validity.
	LD	(CALLINS+1),HL	;stuff addr to CALL instr
CALLINS	CALL	NZ,$-$		;BC = response, A = type
	JP	NZ,PRMERR	;NZ - "Parameter Error"
;
;*=*=* Position to next table entry *=*=*
;
	LD	BC,9		;pos to next STRTAB entry
	ADD	IY,BC		;
	DEC	E		;done ?
	JR	NZ,CKCOMML	;
	RET			;yes - RETurn
;
;
;***
;	PROMPT - for any vals not entered in parm line
;***
;
PROMPT	LD	B,10		;Eight normal + Xlates
	LD	IY,STRTAB	;Prompt, response table
;
;*=*=* P/u type byte from table & set length = 1 *=*=*
;
PROMPTL	LD	A,(IY)		;p/u type byte
	INC	A		;Length = 1
	LD	(FAKETAB+1),A	;type byte
;
;*=*=* P/u address of response byte *=*=*
;
REINPUT	LD	E,(IY+1)	;p/u address
	LD	D,(IY+2)	;in DE
;
;*=*=* Pick up Prompt string address & display it *=*=*
;
DOPRMPT	LD	L,(IY+3)	;p/u address in HL
	LD	H,(IY+4)	;
	CALL	DISPROM		;p/u default & display
;
;*=*=* Input response & stuff into Parm table *=*=*
;
	CALL	INPUT		;input value
	PUSH	BC		;Save count
	CALL	NZ,STUFVAL	;stuff in valid input
	POP	BC		;restore count
	JR	NZ,REINPUT	;else re-input
;
;*=*=* Position to next table entry *=*=*
;
NEXTPR	LD	DE,9		;9 bytes per entry
	ADD	IY,DE		;
	DJNZ	PROMPTL		;B prompts
	RET			;done
;
;
;***
;	DISPROM - Display Prompt
;***
;
DISPROM	PUSH	DE		;Save regs
	PUSH	BC		;
	LD	C,CUROFF	;Turn off cursor
	CALL	DSP		;
	LD	B,32		;space padding base
;
PRLP	LD	C,(HL)		;p/u character
	INC	HL		;pos to next
	DEC	B		;dec count
	CALL	DSP		;output byte
	LD	A,C		;p/u char
	CP	'{'		;Bracket ?
	JR	NZ,PRLP		;no - go til bracket
	CALL	STUFDEF		;Display default
	LD	A,B		;p/u base #
	ADD	A,C		;& calculate # of
	LD	B,A		;spaces to print
	LD	C,' '		;
;
SPLP	CALL	DSP		;output spaces
	DJNZ	SPLP		;
;
	LD	HL,ENDPROM	;end of prompt
	CALL	DSPLY
	POP	BC		;Recover regs
	POP	DE		;
	RET			;and RETurn
;
;
;
;***
;	STUFDEF - Stuff default value in prompt
;***
;
STUFDEF	LD	L,(IY+7)	;p/u default string
	LD	H,(IY+8)	;address
	LD	C,5		;5 chars max
PNLP	LD	A,(HL)		;
	INC	HL		;bump source
	CP	LF		;done ?
	JR	Z,DUNLP		;
	CP	' '		;leading space ?
	JR	Z,PNLP		;yes - ignore it
	CALL	DISPA		;output A
;
PNLP2	DEC	C		;dec count
	JR	NZ,PNLP
;
DUNLP	LD	A,'}'		;output end bracket
DISPA	PUSH	BC		;Save C
	LD	C,A		;xfer char to C
	CALL	DSP		;output byte
	POP	BC		;recover C
	RET			;and RETurn
;
;
;***
;	STUFVAL - Stuff values into Parm Table
;***
;
STUFVAL	PUSH	DE		;DE => Response Byte
	LD	HL,FAKEPRM	;HL => Fake Parm Entry
	LD	DE,FAKETAB	;DE => Fake Parm Table
	@@PARAM			;parse entry
	POP	HL		;HL => Response
	RET	NZ		;NZ - Re-input
;
;*=*=* Stuff response into Parameter Table *=*=*
;
	PUSH	HL		;save response dest
	LD	A,(FAKERES)	;p/u response
VALUE	LD	BC,$-$		;p/u value
	INC	HL		;HL => Parm Address
	LD	E,(HL)		;p/u parm address
	INC	HL		;
	LD	D,(HL)		;
	EX	DE,HL		;HL => Parm lsb
	LD	(HL),C		;stuff response in table
;
;*=*=* CALL range checking routine *=*=*
;
	LD	HL,RETADR	;put RET addr on stack
	PUSH	HL		;
	LD	L,(IY+5)	;p/u addr of range
	LD	H,(IY+6)	;checking in HL
	JP	(HL)		;routine sets Z for stat
RETADR	POP	HL		;HL => Response byte
	RET	NZ		;don't change if NZ
	LD	(HL),80H	;else stuff non-zero
	RET			;value for response
;
;***
;	STFPRMS - Stuff Numeric & Flag Parms into $FF
;***
;
;*=*=* Pt HL => Response byte addr & offset Table *=*=*
;
STFPRMS	LD	HL,RESPTAB	;HL => Response Table
DATAREA	LD	IX,$-$		;p/u Data Area pointer
	LD	B,7		;7 numeric values
;
;*=*=* P/u response byte & offset byte to $FF data *=*=*
;
STUFLP	LD	E,(HL)		;p/u response address
	INC	HL		;
	LD	D,(HL)		;
	INC	HL		;HL => $FF data offset
	LD	C,(HL)		;p/u offset in data area
	INC	HL		;
;
	LD	A,(DE)		;p/u response
	OR	A		;Parm entered ?
;
;*=*=* Parm entered - calculate Parm's Location *=*=*
;
	INC	DE		;DE => Parameter Dest
	EX	DE,HL		;xfer to HL
	LD	A,(HL)		;Set HL = (HL)
	INC	HL		;
	LD	H,(HL)		;
	LD	L,A		;
;
;*=*=* Stuff parm response into $FF data region *=*=*
;
	LD	A,C		;xfer offset to A
	LD	C,(HL)		;p/u lsb of Parm response
	EX	DE,HL		;recover HL (Table ptr)
NOPOUT	JR	Z,NOPARM	;no - don't stuff
	LD	(IXINST+2),A	;modify offset in IX inst
IXINST	LD	(IX+$-$),C	;xfer parm resp to $FF
;
NOPARM	DJNZ	STUFLP		;next entry
;
;*=*=* Set Flag bits in $FF data area if parms set *=*=*
;
GETFLAG	LD	B,3		;3 flag values
FLOOP	LD	E,(HL)		;p/u response address
	INC	HL		;
	LD	D,(HL)		;
	INC	HL		;
	LD	A,(DE)		;entered ?
	OR	A		;
	JR	Z,NEXTFLG	;no - get next one
;
;*=*=* Response - If true (SET), False (RES) *=*=*
;
	INC	DE		;pos to parm address
	EX	DE,HL		;p/u Parm
	LD	A,(HL)		;Set HL = (HL)
	INC	HL		;
	LD	H,(HL)		;
	LD	L,A		;
	EX	DE,HL		;put into DE
	LD	C,10000110B	;Default = Reset bit inst
	LD	A,(DE)		;p/u lsb of parm
	OR	A		;set ?
	JR	Z,SKIPSET	;no - skip SET inst
	SET	6,C		;change to Set bit inst
;
;*=*=* Create Post opcode for IX instruction *=*=*
;
SKIPSET	LD	A,B		;p/u bit # (0-2)
	DEC	A		;
	RLCA			;move to bits 3-5
	RLCA			;
	RLCA			;
	OR	C		;post op code
	LD	(IXINST2+3),A	;change RES b,(IX+nn) ins
IXINST2	RES	$-$,(IX+FLAGBT)	;Set/Reset bit B in $FF
NEXTFLG	DJNZ	FLOOP		;get next flag
	RET			;done - RETurn
;
;
;***
;	INITVAL - Initial Parm values
;***
;
INITVAL	LD	B,5		;5 values to stuff
	LD	HL,RESPTAB	;HL => Response & offsets
;
SDLP	LD	E,(HL)		;p/u response byte addr
	INC	HL		;
	LD	D,(HL)		;
	INC	HL		;
	LD	A,(DE)		;p/u response byte
;
;*=*=* Get parm table address - DE = (DE) *=*=*
;
	EX	DE,HL		;
	INC	HL		;parm address after resp
	LD	C,(HL)		;p/u lsb
	INC	HL		;
	LD	H,(HL)		;p/u msb
	LD	L,C		;HL = (HL)
	EX	DE,HL		;get back to DE
;
;*=*=* P/u default value from $FF data area *=*=*
;
	PUSH	DE		;Save HL & DE
	PUSH	HL		;
	LD	E,(HL)		;p/u offset
	LD	D,0		;DE = offset to default
	LD	HL,(DATAREA+2)	;HL => Data Area
	ADD	HL,DE		;
	LD	C,(HL)		;p/u default value
	POP	HL		;restore regs
	POP	DE		;
;
;*=*=* If parm wasn't entered - stuff default value *=*=*
;
	INC	HL		;posn to next entry
	OR	A		;parm entered ?
	JR	Z,STFDEF	;no - stuff default
	LD	A,(QRESP)	;<Q>uery ?
	OR	A		;
	JR	Z,PRMENT	;no - don't stuff
STFDEF	LD	A,C		;yes - stuff default
	LD	(DE),A		;
PRMENT	DJNZ	SDLP		;
	RET			;done
;
;
;***
;	Range Checking Code of Values
;***
;
;*=*=* Is the Page length valid ? *=*=*
;
RPAGE	CALL	MORE0?		;number between 1 - 255 ?
	RET	NZ		;no - NZ
	LD	A,(LPARM)	;p/u LINES value
	DEC	A		;
	CP	C		;LINES > PAGE ?
	PUSH	AF		;save status
	LD	A,(QRESP)	;<Q>uery ?
	OR	A		;
	JR	NZ,PQUERY	;yes - set L=P if L>P
	POP	AF		;no
	JR	VALID2?		;return NZ if L>P
PQUERY	POP	AF		;L > P ?
	JR	C,SETZ		;no - Set Z flag
	LD	A,C		;yes - Set LINES = PAGE
	LD	(DUPDA+LINES),A	;
	LD	(LRESP),A	;pretend that LINES was
	LD	(LPARM),A	;responded to
	CALL	DSFORMS		;reset defaults
SETZ	CP	A		;set Z flag
	RET			;
;
;*=*=* Is the lines printed per page valid ? *=*=*
;
RLINES	CALL	MORE0?		;number between 1 - 255 ?
	RET	NZ		;no - NZ
	DEC	A		;
	LD	HL,PPARM	;HL => Page length
	JR	VALID1?		;set status accordingly
;
;*=*=* Is the Characters printed per line valid ? *=*=*
;
RCHARS	BIT	6,A		;Flag response ?
	JR	NZ,SETZ		;yes - Set Z
	CALL	MORE0?		;no - More than zero ?
	RET	NZ		;no - NZ
	LD	A,(QRESP)	;<Q>uery ?
	OR	A		;
	RET	Z		;no - Z
;
;*=*=* <Q>uery - Make sure CHARS > INDENT+MARGIN *=*=*
;
	LD	HL,MPARM	;HL => Margin value
	LD	A,(IPARM)	;A = Indent value
	ADD	A,(HL)		;A = Indent + Margin
	CP	C		;Less than CHARS ?
	JR	C,SETZ		;yes - Set Z
	XOR	A		;Reset INDENT & MARGIN=0
	LD	(DUPDA+INDENT),A
	LD	(DUPDA+MARGIN),A
	LD	(IPARM),A	;
	LD	(MPARM),A	;
	INC	A		;pretend that INDENT &
	LD	(MRESP),A	;to
CHNGIND	LD	(IRESP),A	;MARGIN were responded
	CALL	DSFORMS		;change defaults
	XOR	A		;Set Z & RETurn
	RET			;
;
;*=*=* Is Margin less than Characters/Line ? *=*=*
;
RMARGIN	CALL	NUMERIC		;number between 0 - 255 ?
	RET	NZ		;no - NZ
	CALL	VALID?		;yes - less than CHARS ?
	RET	NZ		;no - RETurn NZ
	LD	A,(IPARM)	;p/u INDENT
	ADD	A,C		;add to MARGIN
	CALL	VALID?		;M + I < CHARS ?
	RET	Z		;yes - RETurn Z
	XOR	A		;no - Set INDENT default
	LD	(IPARM),A	;equal to Zero
	LD	(DUPDA+INDENT),A
	INC	A		;pretend I was responded
	JR	CHNGIND		;
;
;*=*=* Is Margin + Indent less than chars/line ? *=*=*
;
RINDENT	CALL	NUMERIC		;number between 0 - 255 ?
	RET	NZ		;no - NZ
	LD	A,(MPARM)	;p/u MARGIN val
	ADD	A,C		;A = MARGIN + INDENT
VALID?	LD	HL,CPARM	;HL => Characters/Line
VALID1?	CP	(HL)		;Response > (HL) ?
VALID2?	JR	NC,SETNZ	;yes - Reset Z flag
	CP	A		;no - Set Z flag
	RET			;
SETNZ	XOR	A		;reset Z flag
	INC	A		;
	RET			;
;
;*=*=* Is the response a number between 1-255 ? *=*=*
;
MORE0?	CALL	NUMERIC		;Is the response a number
	RET	NZ		;between 0 - 255 ?
	OR	A		;Is the response zero ?
	JR	Z,SETNZ		;yes - reset Z flag
	CP	A		;no - set Z flag
	RET			;
;
;*=*=* Is the response a 1 byte number ? *=*=*
;
NUMERIC	AND	80H		;Bit 7 is set if the
	XOR	80H		;response is numeric.
	RET	NZ		;NZ <= if Bit is reset
	INC	B		;Is the response only
	DEC	B		;1 byte (msb = 0) ?
	LD	A,C		;set A = response
	RET			;yes (Z), no (NZ)
;
;*=*=* Is the response a flag (ON/YES, OFF/NO) ? *=*=*
;
FLAG?	AND	40H		;Bit 6 is set if the
	XOR	40H		;response is a flag.
	RET			;yes (Z), no (NZ)
;
;
;***
;	XFER - Xfer string @ HL to DE
;	XFERON - Xfer "ON" string to DE
;***
;
XFERON	LD	HL,ONSTR	;HL => "ON"
XFER	LD	BC,3		;3 chars to xfer
	LDIR			;
	RET			;
;
;
;***
;	DSP - Display a byte
;***
;
DSP	PUSH	DE		;Save DE
	@@DSP			;output byte
	JR	EXDSP		;
;
;
;***
;	DSPLY - Display a string
;***
;
DSPLY	PUSH	DE		;Save DE
	@@DSPLY			;display it
EXDSP	POP	DE		;
	RET	Z		;return if good
	JP	IOERR		;NZ - I/O Error
;
;
;***
;	DOINIT - Sign on message & Get Data area
;***
;
DOINIT	PUSH	HL		;Save command ptr
	@@FLAGS			;Only display sign-on
;
;*=*=* Point IX to Filter Data area *=*=*
;
	LD	DE,$FF		;DE => "$FF"
	@@GTMOD			;Find start
	JP	NZ,NOPF		;Can't Find It !!
;
	EX	DE,HL		;HL => Data Area
	LD	BC,4		;Add 4 to ptr
	ADD	HL,BC		;
	LD	(DATAREA+2),HL	;Save $FF pointer
	LD	DE,DUPDA	;DE => Duplicate D area
	PUSH	DE		;Save ptr
	LD	C,10		;BC = 10 bytes to xfer
	LDIR			;
	POP	IX		;
	POP	HL		;recover HL
	RET			;and RETurn
;
;
;
;***
;	HEXDEC - Convert Hex Number to Decimal ASCII
;	A => 8-bit Hex Number to Convert
;	DE => Destination of ASCII characters
;***
;
HEXDEC	PUSH	BC		;Save regs
	PUSH	HL		;
	PUSH	AF		;
;
;*=*=* Transfer ASCII chars into temporary buffer *=*=*
;
	PUSH	DE		;save real destination
	LD	DE,TEMBUF	;DE => Temporary buffer
	LD	H,0		;Xfer # to HL
	LD	L,A		;
	@@HEXDEC		;convert to ASCII
	DEC	DE		;pos to 3-byte field
	DEC	DE
	DEC	DE
	POP	HL		;
	EX	DE,HL
	LD	BC,3
	LDIR			;
;
	POP	AF		;Recover #
	POP	HL		;and other regs
	POP	BC		;
	RET
;
;
;***
;	HEX8 - Convert HEX Number in A to HEX @ HL
;***
;
HEX8	PUSH	BC		;Save regs
	LD	C,A		;xfer char to C
	@@HEX8			;do it
	POP	BC		;
	RET			;and RETurn
;
;
;
;***
;	INPUT - Input a string into INBUFF$
;***
;
INPUT	PUSH	HL		;Save regs
	PUSH	DE		;
	PUSH	BC		;
;
	LD	BC,300H		;3 chars max
	LD	HL,INBUFF$	;Key input buffer
	@@KEYIN			;input line
	JP	C,ABORT		;Abort if <BREAK>
;
	INC	B		;Set Z flag if
	DEC	B		;no input
;
	POP	BC		;Restore regs
	POP	DE		;
	POP	HL		;
	RET			;& RETurn with condition
;
;*=*=* Default Value Table *=*=*
;
DEFTAB	DB	PDEF,0,LDEF,0,0,0,0,00000100B,0,0
;
;*=*=* PARAMTER TABLE *=*=*
;
PRMTBL$	DB	80H		;6.2 @PARAM
;
;*=*=* ADDLF (A) - Flag Input Only *=*=*
;
	DB	FLAG!ABB!5
	DB	'ADDLF'
ARESP	DB	0
	DW	APARM
;
;*=*=* CHARS (C) - Accept Numeric or Flag input *=*=*
;
	DB	FLAG!ABB!NUM!5
	DB	'CHARS'
CRESP	DB	0
	DW	CPARM
;
;*=*=* FFHARD (F) - Accept Flag input only *=*=*
;
	DB	FLAG!ABB!6
	DB	'FFHARD'
FRESP	DB	0
	DW	FPARM
;
;*=*=* INDENT (I) - Accept Numeric Input only *=*=*
;
	DB	NUM!ABB!6
	DB	'INDENT'
IRESP	DB	0
	DW	IPARM
;
;*=*=* LINES (L) - Accept Numeric Input only *=*=*
;
	DB	NUM!ABB!5
	DB	'LINES'
LRESP	DB	0
	DW	LPARM
;
;*=*=* MARGIN (M) - Accept Numeric Input only *=*=*
;
	DB	NUM!ABB!6
	DB	'MARGIN'
MRESP	DB	0
	DW	MPARM
;
;*=*=* PAGE (P) - Accept Numeric Input only *=*=*
;
	DB	NUM!ABB!4
	DB	'PAGE'
PRESP	DB	0
	DW	PPARM
;
;*=*=* QUERY (Q) - Accept Flag Input Only *=*=*
;
	DB	FLAG!ABB!5
	DB	'QUERY'
QRESP	DB	0
	DW	QPARM
;
;*=*=* TAB (T) - Accept Flag input only *=*=*
;
	DB	FLAG!ABB!3
	DB	'TAB'
TRESP	DB	0
	DW	TPARM
;
;*=*=* XLATE (X) - Accept Numeric input only *=*=*
;
	DB	NUM!ABB!5
	DB	'XLATE'
XTRESP	DB	0
	DW	XTPARM
;
;*=*=* DEFAULT (D) - Accept Flag input only *=*=*
;
	DB	FLAG!ABB!7
	DB	'DEFAULT'
DRESP	DB	0
	DW	DPARM
;
	DB	0
;
QPARM	DW	0
CPARM	DW	0
IPARM	DW	0
LPARM	DW	0
MPARM	DW	0
PPARM	DW	0
XTPARM	DW	0
;
APARM	DW	0
FPARM	DW	0
TPARM	DW	0
DPARM	DW	0
;
XFRESP	DB	0
	DW	XFPARM
XFPARM	DW	0
;
;***
;	Response Table - Response Addr, $FF Offset
;***
;
;*=*=* 8-bit Numeric Responses *=*=*
;
RESPTAB	DW	CRESP
	DB	CHARS
;
	DW	IRESP
	DB	INDENT
;
	DW	LRESP
	DB	LINES
;
	DW	MRESP
	DB	MARGIN
;
	DW	PRESP
	DB	PAGE
;
	DW	XTRESP
	DB	XLATET
;
	DW	XFRESP
	DB	XLATEF
;
;*=*=* Flag Response Table *=*=*
;
	DW	TRESP
	DW	FRESP
	DW	ARESP
;
;
FAKEPRM	DB	'(F='
INBUFF$	DS	12
;
;***
;	STRTAB - 10 entries each with 9 bytes:
;
; 1 byte : Type of expected response - flag or numeric
; 2 bytes: Address of response byte
; 2 bytes: Address of prompt string
; 2 bytes: Address of routine to range check response
; 2 bytes: Address of default value string
;
;***
;
STRTAB	EQU	$
	DB	NUM			;PAGE
	DW	PRESP,PPROMPT,RPAGE,SPAGE
	DB	NUM			;LINES
	DW	LRESP,LPROMPT,RLINES,SLINES
	DB	NUM			;CHARS
	DW	CRESP,CPROMPT,RCHARS,SCHARS
	DB	NUM			;MARGIN
	DW	MRESP,MPROMPT,RMARGIN,SMARGIN
	DB	NUM			;INDENT
	DW	IRESP,IPROMPT,RINDENT,SINDENT
	DB	FLAG			;ADDLF
	DW	ARESP,APROMPT,FLAG?,SADDLF
	DB	FLAG			;FFHARD
	DW	FRESP,FPROMPT,FLAG?,SFFHARD
	DB	FLAG			;TAB
	DW	TRESP,TPROMPT,FLAG?,STAB
	DB	NUM			;XLATE From
	DW	XFRESP,XPROMF,NUMERIC,SXLFROM-2
	DB	NUM			;XLATE To
	DW	XTRESP,XPROMT,NUMERIC,SXLTO-2
;
;*=*=* Fake Parameter Table for prompts (QUERY) *=*=*
;
FAKETAB	DB	80H		;6.2 @ PARAM
	DB	0		;type byte
	DB	'F'
FAKERES	DB	0
	DW	VALUE+1		;destination
	DB	0
;
;
$FF	DB	'$FF',ETX
ONSTR	DB	' ON'
OFFSTR	DB	'OFF'
;
NOPF$	DB	'Forms Filter not Resident',CR
;
ENDPROM	DB	'? ',CURON,ETX
VALUES	DB	'PAGE   = '
SPAGE	DB	' 66',LF,'LINES  = '
SLINES	DB	' 66',LF,'CHARS  = '
SCHARS	DB	'OFF',LF,'MARGIN = '
SMARGIN	DB	'  0',LF,'INDENT = '
SINDENT	DB	'  0',LF,'ADDLF  = '
SADDLF	DB	'OFF',LF,'FFHARD = '
SFFHARD	DB	'OFF',LF,'TAB    = '
STAB	DB	'OFF',LF
DOXLATE	DB	CR,'XLATE  = X',AP
SXLFROM	DB	'00',AP,' => X',AP
SXLTO	DB	'00',AP,LF,CR
;
;
APROMPT	DB	'Add Line Feed after C/R {'
CPROMPT	DB	'Maximum Characters per Line {'
FPROMPT	DB	'Real Form Feeds {'
IPROMPT	DB	'Indent after Wrap-around {'
LPROMPT	DB	'Lines Printed per Page {'
MPROMPT	DB	'Margin Setting {'
PPROMPT	DB	'Physical Page Length {'
TPROMPT	DB	'Tab Expansion {'
XPROMF	DB	'Xlate From {'
XPROMT	DB	'Xlate To {'
;
;
	DB	' '
TEMBUF	DS	5
DUPDA	DS	10
;
	END	START
