;LBDUMP/ASM - DUMP Command - 10/29/83
	TITLE	<DUMP - LDOS 6.2>
;
;****
;	Change Log
;
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
;
;****
*GET	SVCMAC:3
CR	EQU	13
PAR_ERR	EQU	44		;"Parameter Error" #
SINIT	EQU	3000H
EINIT	EQU	SINIT
	ORG	2400H
DUMP	@@CKBRKC		;Break key down?
	JR	Z,BEGINA	;Ok if not
	LD	HL,-1		; else abort
	RET
;
BEGINA	LD	DE,FCB1		;fetch the filespec
	@@FSPEC
	JP	NZ,SPCREQ	;jump on error
	LD	A,(DE)		;cannot be a device
	CP	'*'
	JP	Z,SPCREQ
	@@FLAGS
	PUSH	HL
	LD	H,(IY+26)	;P/u SVC table MSB
	LD	L,22*2		;  & point to @EXIT entry
	LD	A,(HL)		;Get @EXIT LSB
	INC	L
	LD	H,(HL)		;Get @EXIT MSB
	LD	L,A
	LD	(TPARM+1),HL	;Init transfer to @EXIT
	POP	HL
;*=*=*
;	Search for parameters
;*=*=*
	LD	DE,PRMTBL$	;get the parms
	@@PARAM
	JP	NZ,PRMERR	;jump on parm error
	LD	HL,(EPARM+1)	;ck on end > start
	LD	BC,(SPARM+1)
	XOR	A
	SBC	HL,BC
	JP	C,ENLTST	;jump on end < start
	LD	HL,SINIT	;pt to lowest possible
	DEC	HL		;reduce for compare
	SBC	HL,BC		;ck on start > minimum
	JP	NC,STLT30	;jump if start < minimum
APARM	LD	BC,0		;ASCII txt or code cim
	LD	A,B
	OR	C
	JR	NZ,DUMPTXT
	LD	DE,NAMFLD	;get up to a 6-character
	LD	HL,FCB1		;filename to stuff
	LD	B,6		;as file header
$?1	LD	A,(HL)
	CP	'0'		;stop on non-alpha
	JR	C,$?3
	CP	'9'+1		;use if 0-9
	JR	C,$?2
	CP	'A'		;ck on A-Z
	JR	C,$?3
	CP	'Z'+1
	JR	NC,$?3		;exit if not A-Z
$?2	LD	(DE),A		;xfer this char
	INC	HL		;bump input ptr
	INC	DE		;  & output pointer
	DJNZ	$?1		;loop 6-chars max
	JR	$?4
$?3	LD	A,' '		;place blanks to
	LD	(DE),A		;fill out to 6 chars
	INC	DE
	DJNZ	$?3
$?4	LD	HL,LMFEXT
	JR	DUMPCIM
DUMPTXT	LD	HL,TXTEXT
DUMPCIM	LD	DE,FCB1		;default the EXT
	@@FEXT
LPARM	LD	BC,0		;p/u LRL
	LD	A,B		;test for > 256
	OR	A		;if hi-order = 0,
	JR	Z,LP1		;just use lo-order
	DEC	A		;test hi-order = 1
	JP	NZ,PRMERR
	OR	C		;p/u lo-order
	JP	NZ,PRMERR	;lo-order must be 0
LP1	OR	C		;merge lo-order
	LD	B,A
	LD	HL,BUFFER	;pt to buffer
	@@INIT			;init the file
	JP	NZ,IOERR
;*=*=*
;	Display the filespec being dumped
;*=*=*
	LD	BC,(FCB1+6)	;P/u DEC & drive
	LD	DE,FCB2		;Point to FCB area
	PUSH	DE
	@@FNAME			;Fetch the name
	POP	HL
	JP	NZ,IOERR
	LD	A,20H		;Scan until ETX
FNLP	INC	HL
	CP	(HL)
	JR	C,FNLP
	LD	(HL),CR		;Replace with CR
	@@LOGOT	DUMP$
	LD	DE,FCB1
	LD	A,(APARM+1)
	OR	A
	JR	NZ,SPARM
	LD	A,5		;name header
	CALL	PUTOUT
	LD	A,6		;nam length
	CALL	PUTOUT
	LD	B,6		;init loop
	LD	HL,NAMFLD
$?5	LD	A,(HL)
	INC	HL
	CALL	PUTOUT		;output the filename
	DJNZ	$?5
SPARM	LD	HL,SINIT	;p/u starting addr
$?7	PUSH	HL		;ck on write of
	LD	B,H		;last byte
	LD	C,L
EPARM	LD	HL,EINIT-1
	INC	HL
	XOR	A
	SBC	HL,BC
	JR	Z,$?10
	LD	B,254		;254-byte blocks
	LD	A,H		;a full sector left
	OR	A		;to write?
	JR	NZ,$?8
	LD	A,L
	CP	0FFH
	JR	NC,$?8		;If less than full,
	LD	B,L		;  reset len
$?8	POP	HL
	LD	A,(APARM+1)
	OR	A
	JR	NZ,$?9		;bypass if TXT
	INC	A		;init start of block
	CALL	PUTOUT
	LD	A,B		;get block length
	ADD	A,2		;add 2 for load address
	CALL	PUTOUT		;  & put it out
	LD	A,L
	CALL	PUTOUT		;lo-order load address
	LD	A,H
	CALL	PUTOUT		;hi-order load address
$?9	LD	A,(HL)		;write a load block
	INC	HL
	CALL	PUTOUT
	DJNZ	$?9
	JR	$?7		;loop for more
$?10	POP	HL
	LD	A,(APARM+1)	;no TRAADR if TXT
	OR	A		;  or TRAADR if not TXT
	JR	Z,TRAADR
ETXPARM	LD	BC,3		;p/u etx character
	LD	A,C
	LD	HL,ETXRESP
	BIT	7,(HL)		;Value input means
	JR	NZ,PUTETX	;  put the ETX given
	LD	A,(BC)		;In case string
	BIT	5,(HL)		;String input puts the
	JR	NZ,PUTETX	;  entered char
	BIT	6,(HL)		;Flag input gives ETX=3
	JR	Z,CLSFIL	;  if ETX=on
	LD	A,3
	JR	PUTETX
TRAADR	LD	A,2		;put traadr header
	CALL	PUTOUT
	LD	A,2
	CALL	PUTOUT
TPARM	LD	HL,$-$		;p/u transfer address
	LD	A,L
	CALL	PUTOUT		;tra lo-order
	LD	A,H
PUTETX	CALL	PUTOUT		;tra hi-order or ETX
CLSFIL	@@CLOSE			;close er up
	LD	HL,0
	RET	Z		;Back on no error
	JR	IOERR		;Go on error
PUTOUT	LD	C,A		;Xfer the char
	@@PUT			;test each byte transfer
	RET	Z		;  for i/o error
	POP	HL		;Pop the RET addr
	DB	21H		;skip LD A,## instruction
PRMERR	LD	A,PAR_ERR	;"Parameter Error"
IOERR	LD	L,A
	LD	H,0
	OR	0C0H		;Abbrev & return
	LD	C,A
	@@ERROR
	RET
STLT30	LD	HL,STLT30$	;pt to error msg
	DB	0DDH
ENLTST	LD	HL,ENLTST$	;pt to error msg
	DB	0DDH
SPCREQ	LD	HL,SPCREQ$
	@@LOGOT
	LD	HL,-1
	RET
ENLTST$	DB	'START or END error!',CR
STLT30$	DB	'Start less than X''3000''',CR
SPCREQ$	DB	'File spec required',CR
LMFEXT	DB	'LMF'
TXTEXT	DB	'TXT'
VAL	EQU	80H
SW	EQU	40H
STR	EQU	20H
SGL	EQU	10H
PRMTBL$	DB	80H
	DB	VAL!SGL!5,'START',0
	DW	SPARM+1
	DB	VAL!SGL!3,'END',0
	DW	EPARM+1
	DB	VAL!SGL!3,'TRA',0
	DW	TPARM+1
	DB	SW!SGL!5,'ASCII',0
	DW	APARM+1
	DB	VAL!SGL!3,'LRL',0
	DW	LPARM+1
	DB	VAL!3,'ETX',0
ETXRESP	EQU	$-1
	DW	ETXPARM+1
	NOP
DUMP$	DB	'Dumping: '		;FCB2 must follow
FCB2	DS	32
NAMFLD	DS	6
FCB1	DS	32
	ORG	$<-8+1<+8
BUFFER	DS	256
LAST	EQU	$-1
	END	DUMP
