;LBDO/ASM - Library 'DO' command - 02/07/83
	TITLE	<DO - LDOS 6.2>
;*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
JFCB$	EQU	0C0H		;Low core EQU*
;*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
;	Change Log
;*****
SMALL	EQU	0
CR	EQU	13
*GET	SVCMAC:3
	ORG	2400H
DO	EQU	$
;*=*=*
;	Note: The first 80 bytes (until PARSINP) are
;	used as a line buffer during processing.
;*=*=*
JCLBUF2	EQU	$
	LD	(SPSAV+1),SP	;Save stack pointer
;
	IF	SMALL
	JR	NOCPL+1
	ENDIF
	LD	(INBUF+1),HL	;Save start of command
;
*LIST	OFF
	IF	.NOT.SMALL
*LIST	ON
	@@FLAGS			;Get flag table pointer
	LD	A,(HL)
	CP	'*'		;execute last DO file?
	JP	Z,NOCPL2
	CP	'='		;execute without compile?
	JP	Z,NOCPL
	CP	'$'		;compile only?
	JR	NZ,GETSPEC
	LD	(NOEXEC?+1),A
	INC	HL
	LD	A,(HL)
	CP	' '		;bypass space separator
	JR	NZ,GETSPEC	;  if present
	INC	HL
GETSPEC	LD	DE,DOFCB	;get DO filespec
	@@FSPEC
	JP	NZ,SPCREQ
	PUSH	HL		;save INBUF$ pointer
	LD	HL,SYSJCL+7	;default ext to "/JCL"
	@@FEXT
	LD	HL,INPBUF	;open DO file
	LD	B,L		;LRL=256
	SET	0,(IY+'S'-'A')	;Inhibit file open bit
	@@OPEN
	JP	NZ,IOERR	;jump on open error
	CALL	MOVFCB		;move SYSTEM/JCL into FCB
	LD	DE,JFCB$	;init FCB pointer
	LD	HL,OUTBUF
	@@INIT
	JP	NZ,DSKFUL	;jump on error
	POP	HL		;rcvr pointer to INBUF$
;*=*=*
;	Routine to parse a command line
;*=*=*
PARSINP	LD	A,(HL)		;p/u line char
	CP	CR		;end of line?
	JP	Z,TSTLBL
	INC	HL		;bump pointer
	CALL	CKSPCOM		;Ignore spaces & commas
	JR	Z,PARSINP
	CP	'('		;beginning of parms?
	JP	Z,PARAM
	CP	';'		;line continuation?
	JP	NZ,PRMERR
	LD	C,'?'		;prompt for line continue
	@@DSP
INBUF	LD	HL,$-$		;input continuation line
	DEC	L		;Backup to start
	DEC	L
	LD	BC,79<8		;max 79 chars input
	@@KEYIN
	JP	C,PRMERR	;jump if break
	@@LOGER			;log the line
	JR	PARSINP		;go parse it
;*****
;	routine to move to higher level nest
;*****
UNNEST	LD	HL,(NESTPTR)	;Shift the last nest's
	DEC	HL		;  FCB into FCB area
	LD	DE,DOFCB+31
	LD	BC,32
	LDDR
	INC	HL
	LD	(NESTPTR),HL	;reset current FCB ptr
	LD	DE,DOFCB	;reread last sector of
	@@RREAD			;  nested FCB
	JP	NZ,IOERR
	RET
CKNEST	LD	HL,(NESTPTR)	;p/u current FCB pointer
	LD	DE,NESTFCB	;is it the first nest?
	XOR	A
	SBC	HL,DE
	JR	Z,CPLFIN	;Jump if so & exit
	CALL	UNNEST		;  processing
	JP	CPLJCL
;*=*=*
;	Finished compilation - Close 'er up
;*=*=*
CPLFIN	LD	DE,JFCB$	;close SYSTEM/JCL file
	@@CLOSE
	JP	NZ,IOERR
NOEXEC?	LD	A,0		;set to non-zero on
	OR	A		;  compile only
	LD	HL,0
	RET	NZ		;exit on compile only
	ENDIF
*LIST	ON
;
CPLFIN1	LD	DE,JFCB$	;point to SYSTEM/JCL FCB
	LD	HL,0		;Correct bufptr later
	LD	B,L		;LRL=256
	SET	0,(IY+'S'-'A')	;Inhibit file open bit
	@@OPEN			;open it up
	JP	NZ,IOERR	;jump on error
	LD	BC,(JFCB$+6)	;Get SBUFF$
	@@DIRRD
	LD	A,H		;Stuff high order to
	LD	(JFCB$+4),A	;  use for JFCB$ buffer
	LD	A,9DH		;call SYS11, entry 1
	RST	28H
;*****
;	Process execution without compilation
;*****
NOCPL	INC	HL
	LD	A,(HL)		;Bypass space separator
	CP	' '		;  if present
	JR	Z,NOCPL
NOCPL1	LD	DE,JFCB$	;fetch DO filespec
	@@FSPEC
	JP	NZ,SPCREQ	;jump on error
	LD	HL,SYSJCL+7	;default to /JCL
	@@FEXT
	JR	CPLFIN1
;
*LIST	OFF
	IF	.NOT.SMALL
*LIST	ON
NOCPL2	CALL	MOVFCB
	JR	CPLFIN1
MOVFCB	LD	HL,SYSJCL	;move SYSTEM/JCL into
	LD	DE,JFCB$	;  FCB area
	LD	BC,32
	LDIR
	RET
;*****
;	found a parm entered
;*****
PARAM	CALL	PARSNAM		;parse symbol -> current
	JR	NZ,PARAM1	;jump if bad symbol
	PUSH	AF		;save separator char
FNDLBL	LD	A,0		;test if a label
	OR	A		;  was found
	JR	NZ,MOVLBL
	CALL	FINDSYM		;search symbol table
	JP	Z,MULDEF	;multiply defined if in
	CALL	MOVNAME		;add symbol to table
	POP	AF		;recover separator
	CP	'='		;assignment?
	JR	Z,PARAM2
PARAM1	CALL	CKSPCOM		;Ck space or comma
	JR	Z,PARAM
	CP	')'		;exit parm scan on
	JP	Z,PARSINP	;  closing paren
	CP	CR		;Also accept closing CR
	JR	Z,TSTLBL
	JP	PRMERR		;else parm error
PARAM2	CALL	PARSVAL		;parse value into buf
	PUSH	AF		;save separator char
	CALL	MOVALUE		;symbol value into table
GETSEP	POP	AF		;recover separator
	JR	PARAM1		;loop
MOVLBL	PUSH	HL
	LD	HL,CURSYM	;pt to current sym buf
	LD	DE,LBLSAV	;  & save label for
	LD	BC,8		;  later testing
	LDIR
	XOR	A		;turn off "found label"
	LD	(FNDLBL+1),A
	POP	HL		;rcvr line ptr
	JR	GETSEP		;back for more
;*****
;	got to end of JCL command line
;*****
TSTLBL	LD	A,(GOTLBL+1)	;was @LABEL a parm?
	OR	A
	JR	Z,CPLJCL	;if not, don't look
;*****
;	find the procedure block named @LABEL
;*****
FINDLBL	CALL	RDJCL		;read JCL line
	JR	Z,GOTLIN	;if end, ck nest
	LD	HL,(NESTPTR)
	LD	DE,NESTFCB
	XOR	A
	SBC	HL,DE
	JP	Z,NOFIND
	CALL	UNNEST
	JR	FINDLBL
GOTLIN	LD	HL,JCLBUF1	;pt to start
	LD	A,(HL)		;is 1st char a label
	CP	'@'		;  indicator?
	JR	NZ,FINDLBL
;*****
;	found a label - is it the one needed?
;*****
	INC	HL		;pt to 1st char
	EX	DE,HL		;ptr to DE
	LD	HL,LBLSAV
	LD	BC,808H		;symbol & field len =8
	CALL	FNDPRM		;a match?
	JR	NZ,FINDLBL	;no match? look for next
	JR	CPLJCL		;  else you're the one!
CONDCPL	CALL	TSTCOND
CPLJCL	CALL	RDJCL		;read line from JCL file
	JP	NZ,CKNEST	;exit on end of file
	LD	HL,JCLBUF1	;parse the line just read
	LD	DE,JCLBUF2
	LD	A,(HL)
	INC	HL
	CP	'@'		;end procedure if found
	JP	Z,CKNEST	;  another label
	CP	'/'		;slash?
	JR	NZ,CPLJCL1
	CP	(HL)		;double slash?
	JP	Z,MACRO		;jump on double slash
CPLJCL1
;*=*=*
;	Modification for HEX parsing
;*=*=*
	CP	'#'		;substitution?
	JR	Z,CPLJCL4
	CP	'%'		;Hex value?
	JR	NZ,CPLJCL2	;Back to take char if not
	CALL	CPLJCL7		;Go test double %
	JR	CPLJCL3
CPLJCL7	CP	(HL)		;Double %?
	JR	Z,CPLJCL6
	CALL	CVRTHEX		;Convert digit
	INC	HL		;Bump to next char
	RLCA
	RLCA
	RLCA
	RLCA			;Rotate into left nybble
	LD	C,A		;Save for now
	CALL	CVRTHEX		;Convert 2nd digit
	OR	C		;Merge left nybble
	JR	CPLJCL6
CPLJCL2	LD	(DE),A		;nothing special, xfer
	INC	DE
	CP	CR
	JR	Z,CONDCPL	;exit on end of line
CPLJCL3	LD	A,(HL)		;grab next input char
	INC	HL
	JR	CPLJCL1		;  & loop
CPLJCL4	CALL	CPLJCL5		;ck on double '#'
	JR	CPLJCL3		;substitute if not ##
CPLJCL5	CP	(HL)		;double #?
	JR	NZ,SUBSYM	;jump to substitute if
CPLJCL6	INC	HL		;  only single #
	LD	(DE),A		;  else xfer the char
	INC	DE
	RET
CVRTHEX	LD	A,(HL)		;P/u the digit
	SUB	30H		;Start conversion
	JR	C,CVRTHE1	;Error if < 0
	CP	10
	RET	C		;Go if 0-9
	RES	5,A		;In case l/c
	SUB	7		;Adjust A-F -> 10-15
	CP	16
	RET	C		;Go if 10-15
CVRTHE1	JR	BADHDR
;*****
;	symbol substitution routine
;*****
SUBSYM	PUSH	HL
	PUSH	DE
	CALL	PARSNAM		;parse symbol
	CP	'#'		;must have closing #
	JR	NZ,BADHDR	;bad JCL format if not
	EX	(SP),HL
	PUSH	HL
	CALL	FINDSYM		;get symbol value
	JR	NZ,SUBSYM1	;bypass if not in table
	LD	A,(DE)		;get symbol length
	OR	A
	JR	Z,SUBSYM1	;bypass if zero length
	LD	B,0
	LD	C,A
	INC	DE		;point to 1st symbol char
	POP	HL		;rcvr where we need to
	EX	DE,HL		;  substitute then move
	LDIR			;  symbol value into pos
	POP	HL
	POP	AF
	RET
SUBSYM1	POP	DE
	POP	AF
	POP	HL
	LD	A,'#'
SUBSYM2	LD	(DE),A
	INC	DE
	LD	A,(HL)
	INC	HL
	CP	CR
	JR	Z,BADHDR
	CP	'#'
	JR	NZ,SUBSYM2
	LD	(DE),A
	INC	DE
	RET
;*=*=*
;	Check if conditional is at top level
;*=*=*
CKCOND	LD	DE,(CONDPTR)	;p/u conditional pointer
	LD	HL,CONDFLG	;test if still on 1st one
	XOR	A
	SBC	HL,DE
	EX	DE,HL		;Pointer back to HL
	RET	NZ		;Ok if nested else error
;*****
;	output invalid JCL format message
;*****
BADHDR	LD	DE,BADHDR$+5
	LD	HL,(LINENO)
	@@HEXDEC
	LD	HL,BADHDR$
	@@LOGOT
BADH1	LD	HL,BADJCL$
	JP	EXTERR
;*****
;	compile "//" line
;*****
MACRO	INC	HL
	CALL	PARSNAM		;get symbol name
	JR	NZ,MACRO2
	CALL	CK4COND		;ck for IF, ELSE, END
	PUSH	DE		;Stack the routine entry
	RET	Z		;  & branch if found
	POP	DE		;  else remove RET &...
;*****
;	test the conditional logic state
;*****
	LD	DE,(CONDPTR)	;p/u conditional pointer
	LD	A,(DE)		;  & conditional state
	OR	A
	JP	NZ,CPLJCL	;jump if logic FALSE
	CALL	CK4ASSN		;Test for SET, RESET,
;				;  ASSIGN, INCLUDE, QUIT
	PUSH	DE		;Stack the routine entry
	RET	Z		;  & branch if found
	POP	DE
MACRO2	LD	DE,JCLBUF1	;point to where we left
	XOR	A		;  off and continue to
	SBC	HL,DE		;  parse the input line
	LD	B,H		;  from the JCL file
	LD	C,L
	LD	HL,JCLBUF1
	LD	DE,JCLBUF2
	LDIR
	JP	CPLJCL3
;*****
;	read a line from the JCL file
;*****
RDJCL	LD	HL,(LINENO)	;Bump line counter
	INC	HL
	LD	(LINENO),HL
	LD	HL,JCLBUF1	;point to line buffer
	LD	DE,DOFCB	;point to FCB
	LD	B,80		;Permit only 80 chars
RDJCL1	@@GET			;get a char
	JR	NZ,RDJCL2	;jump on error
	OR	A
	JR	Z,RDJCL3	;bypass on null byte
	LD	(HL),A		;xfer byte to line buf
	INC	HL
	CP	CR		;end of line?
	RET	Z
	DJNZ	RDJCL1		;loop if not
	LD	(HL),CR		;Stuff CR & provide
	LD	HL,LINLNG$	;  error log message
	LD	(BADH1+1),HL
	JR	BADHDR
RDJCL2	CP	1CH		;EOF?
	JP	NZ,IOERR	;jump on any other error
RDJCL3	LD	A,1CH
	OR	A
	RET
;*****
;	Act on JCL line if conditional state = TRUE
;*****
TSTCOND	LD	HL,(CONDPTR)	;grab conditional pointer
	LD	A,(HL)		;grab conditional state
	OR	A
	RET	NZ		;return if logic FALSE
	LD	HL,JCLBUF2	;point to processed line
	LD	DE,JFCB$	;SYSTEM/JCL FCB
	LD	A,(HL)		;ck on double /
	CP	'/'
	JR	NZ,WRCPLD
	INC	HL
	CP	(HL)
	DEC	HL
	JR	NZ,WRCPLD	;jump if not //
	LD	A,(JCLBUF2+2)	;ck on comment
	CP	'.'		;//. ?
	JR	NZ,WRCPLD	;bypass if not comment
	@@DSPLY			;else display the comment
	RET
;*****
;	write compiled line to SYSTEM/JCL
;*****
WRCPLD	LD	C,(HL)		;p/u a char
	@@PUT			;put it out
	JP	NZ,IOERR	;jump on error
	LD	A,(HL)		;grab again to test
	INC	HL		;bump pointer
	CP	CR		;end of line?
	JR	NZ,WRCPLD	;loop if not
	RET
;*****
;	parameter tables
;*****
CONDTBL	DB	'IF   '
	DW	IF01
	DB	'ELSE '
	DW	ELSE1
	DB	'END  '
	DW	END1
	NOP
ASSNTBL	DB	'SET     '
	DW	SET1
	DB	'RESET   '
	DW	RESET1
	DB	'ASSIGN  '
	DW	ASSIGN
	DB	'INCLUDE '
	DW	INCLUD
	DB	'QUIT    '
	DW	QUIT
	NOP
;*****
;	process IF command
;*****
IF01	CALL	IF05		;parse expression
	JR	Z,IF02		;Z=true, NZ=false
	CP	CR		;false & end of line?
	JR	Z,IF03
	CP	'+'		;logical OR?
	JR	Z,IF01
;*****
;	test for FALSE and logical AND (&)
;*****
	CP	'&'		;separator AND?
	JR	NZ,BADHDR0	;invalid format if not
IF01A	INC	HL		;ignore rest of line
	LD	A,(HL)
	CP	CR
	JR	NZ,IF01A
	JR	IF03
IF02	XOR	A		;logic = true
	JR	IF04
IF03	LD	A,0FFH		;logic = false
IF04	LD	HL,(CONDPTR)	;get conditional pointer
	OR	(HL)		;set logic state
	INC	HL		;bump pointer
	LD	(HL),A		;stuff state result
	LD	(CONDPTR),HL	;save pointer
	JR	GOJCL
;*****
;	process ELSE command
;*****
ELSE1	CALL	CKCOND		;Ck nest of conditional
	LD	A,(HL)		;flip state of flag based
	CPL			;  on previous test
	DEC	HL
	OR	(HL)
	INC	HL
	LD	(HL),A
	JR	GOJCL
;*****
;	process END command
;*****
END1	CALL	CKCOND		;Ck nest level
	DEC	HL		;Backup conditional one
	LD	(CONDPTR),HL	;  level & reset pointer
	JR	GOJCL
;*****
;	parse conditional expression logic
;*****
IF05	CALL	IF06		;get if symbol is true
	RET	NZ		;  or false & ret if false
	CP	'&'		;logical AND separator?
	JR	Z,IF05		;if TRUE AND -> ck next
	XOR	A		;true and not AND,
	RET			; ret true
IF06	LD	A,(HL)
	CP	'-'		;logical NOT?
	JR	NZ,IF08
	INC	HL		;bypass '-' 12/30/80
	CALL	IF08		;grab symbol logic state
	JR	NZ,IF07		;Z=true, NZ=false
	DB	0F6H		;was true, not => false
IF07	XOR	A		;was false, not => true
	LD	A,B		;Rcvr separator
	RET
IF08	CALL	PARSNAM		;get symbol name into buf
	RET	NZ		;ret if bad symbol
	PUSH	AF
	PUSH	HL
	CALL	FINDSYM		;find symbol in table
	POP	HL
	POP	BC
	LD	A,B		;put zero in A & use flag
	RET			;from search
;*****
;	process SET command
;*****
SET1	CALL	PARSNAM		;parse symbol name
BADHDR0	JP	NZ,BADHDR	;jump if bad symbol
	CALL	FINDSYM		;find in table
	CALL	NZ,MOVNAME	;move name into table
GOJCL	JP	CPLJCL
;*****
;	process RESET command
;*****
RESET1	CALL	PARSNAM		;parse symbol name
	JR	NZ,BADHDR0
	CALL	FINDSYM		;find symbol in table
	JR	NZ,GOJCL	;no problem if not there
	LD	HL,-8		;point to start of name
	ADD	HL,DE		;  & put in a blank
	LD	(HL),' '	;  to remove symbol
	JR	GOJCL
;*****
;	process ASSIGN command
;*****
ASSIGN	CALL	PARSNAM		;parse symbol name
	JR	NZ,BADHDR0	;jump on bad name
	PUSH	AF		;save separator char
	CALL	FINDSYM		;find in table
	CALL	NZ,MOVNAME	;add to table if not in
	POP	AF		;recover separator
	CP	'='		;error if not =
	JR	NZ,BADHDR0
	CALL	PARSVAL		;parse value of symbol
	JR	NZ,BADHDR0
	CALL	MOVALUE		;place value into table
	JR	GOJCL
;*****
;	process INCLUDE command
;*****
INCLUD	PUSH	HL
	LD	DE,(NESTPTR)	;Point to next FCB save
	LD	HL,NESTEND	;  area & check if room
	XOR	A		;  to store another FCB
	SBC	HL,DE
	JP	Z,NESTS		;Error if 5 nests already
	LD	HL,DOFCB	;Shift current FCB into
	LD	BC,32		;  INCLUDE FCB save area
	LDIR
	LD	(NESTPTR),DE	;Update new nest pointer
	POP	HL
	LD	DE,DOFCB	;point to FCB
	@@FSPEC			;fetch included file
	JR	NZ,BADHDR0	;jump on error
	LD	HL,SYSJCL+7	;default to /JCL
	@@FEXT
	LD	HL,INPBUF	;open the included file
	LD	B,L
	SET	0,(IY+'S'-'A')	;Inhibit file open bit
	@@OPEN
	JR	NZ,BADHDR0
	JR	GOJCL
;*****
;	process QUIT command
;*****
QUIT	LD	HL,JCLBUF1	;Log the //QUIT command
	JP	EXTERR
;*****
;	parse symbol name
;	 A <= separator char
;	 Z  = ok, NZ = bad symbol char
;*****
PARSNAM	PUSH	DE
	LD	B,8		;8 chars max
	LD	DE,CURSYM	;symbol buffer area
	CALL	PARSER		;parse it
	POP	DE
	RET
;*****
;	parse a symbol value
;*****
PARSVAL	PUSH	DE
	LD	B,32		;32 chars max
	LD	DE,VALBUF	;value buffer
	CALL	XFRSTR		;transfer from input
	PUSH	AF
	PUSH	HL
	EX	DE,HL		;calculate length of
	LD	DE,VALBUF	;  the string
	XOR	A
	SBC	HL,DE
	LD	A,L
	CP	33
	JP	NC,TOOLNG	;jump if > 32 chars
	LD	(STRLEN),A	;stuff string length
	POP	HL
	POP	AF
	POP	DE
	RET
;*****
;	transfer a string field
;*****
XFRSTR	CALL	PARSER		;xfer max of 32 chars
XFRSTR1	CALL	CKSPCOM		;Return on space
	RET	Z		;  or comma
	CP	CR
	RET	Z		;ret on end of line
	CP	'='
	RET	Z		;ret on =
	CP	'('
	RET	Z		;ret on left paren
	CP	')'
	RET	Z		;ret on right paren
	CP	'#'
	JR	NZ,XFRSTR	;loop if not #
	CALL	CPLJCL5		;ck on substitution
	LD	A,(HL)
	JR	XFRSTR1		;then loop
;*=*=*
;	Parse a field
;*=*=*
PARSER	LD	A,B		;set max length of field
	LD	(PAR6+1),A
	INC	B
PAR2	LD	A,(HL)		;p/u entry char
	CP	3		;ETX?
	JR	Z,PAR5
	CP	CR
	JR	Z,PAR5
	INC	HL		;not ending char, bump
	CP	'"'		;Ck on string quote
	JR	NZ,NOTQT
	XOR	'"'		;Ck if opening or closing
STUFQT	EQU	$-1
	LD	(STUFQT),A
	JR	PAR2		;Loop until terminator
NOTQT	LD	C,A		;Save char & test if
	LD	A,(STUFQT)	;  within quoted string
	OR	A
	LD	A,C		;Get back the char
	JR	Z,PAR3		;Allow all within "..."
	CP	'@'		;start of label?
	JR	NZ,NOLBL
GOTLBL	SUB	0		;make sure only one!
	JP	Z,LBLERR
	LD	(GOTLBL+1),A	;stuff '&' into test
	LD	(FNDLBL+1),A	;  & also for check
	JR	PAR2		;loop through start
NOLBL	CP	'.'		;accept (., /, 0-9, :)
	JR	C,PAR5
	CP	':'+1
	JR	C,PAR3
	CP	'A'		;test for A-Z
	JR	C,PAR5
	CP	'Z'+1
	JR	C,PAR3
	CALL	CKLCA2Z		;test for a-z
	JR	C,PAR5
PAR3	DEC	B		;char count down
	JR	Z,PAR4
	LD	(DE),A		;save the char
	XOR	A		;show we found at
	LD	(PAR6+1),A	;  least one valid char
	INC	DE		;bump receiving buffer
	JR	PAR2		;loop
PAR4	INC	B		;ignore trailing chars
	JR	PAR2		;  past max length
PAR5	LD	C,A		;found char out of range
	PUSH	DE		;save current end of buf
	JR	PAR5B
PAR5A	LD	A,' '		;fill out remaining field
	LD	(DE),A		;  with blanks
	INC	DE
PAR5B	DJNZ	PAR5A
	POP	DE		;recover pointer to last
PAR6	LD	A,0		;char xfered, get max len
	OR	A		;note if we found a char
	LD	A,C		;xfer separator char
	RET
;*****
;	xfer symbol name to table & init value
;*****
MOVNAME	PUSH	HL
	LD	HL,CURSYM	;current symbol buffer
	LD	BC,8		;8 chars to move
	LDIR
	XOR	A		;zero accumulator
	LD	(DE),A		;show symbol length=0
	LD	HL,33		;point to 1st byte
	ADD	HL,DE		;  of next symbol pos and
	LD	(HL),A		;  show it spare
	POP	HL
	RET
;*****
;	place symbol value into table
;*****
MOVALUE	PUSH	HL
	LD	HL,STRLEN	;current value buffer
	LD	BC,33		;length & value
	LDIR
	POP	HL
	RET
;*****
;	find symbol in table
;*****
FINDSYM	PUSH	HL
	LD	DE,CURSYM	;symbol buffer
	LD	HL,SYMTAB	;start of table
	LD	BC,8<8!41	;CP8, field (8,1,32)
	CALL	FNDPRM		;search in progress
	LD	D,H		;xfer pointer of symbol
	LD	E,L		;  or to spare slot
	POP	HL
	RET
;*****
;	;routine to check for IF, ELSE, END
;*****
CK4COND	PUSH	HL
	LD	HL,CONDTBL	;parm table
	LD	BC,5<8!7	;5 chars, 7-char field
	JR	CK4AS1
;*****
;	check on SET, RESET, ASSIGN, INCLUDE, QUIT
;*****
CK4ASSN	PUSH	HL
	LD	HL,ASSNTBL	;parm table
	LD	BC,8<8!10	;parm length, field len
CK4AS1	LD	DE,CURSYM	;buffer area
	CALL	FNDPRM		;ck for match
	LD	E,(HL)		;xfer vector address
	INC	HL
	LD	D,(HL)
	POP	HL
	RET
;*****
;	scan parm table for match
;*****
FNDPRM	LD	A,(HL)		;end of parm table?
	OR	A
	JR	NZ,FND1		;jump if not
	INC	A		;else show not found
	RET
FND1	LD	A,(DE)		;char match?
	CALL	CKLCA2Z		;Convert a-z to A-Z
	CP	(HL)
	JR	Z,FND3		;jump if 1st matches
FND2	PUSH	BC		;else bypass complete
	LD	B,0		;field & go to next one
	ADD	HL,BC
	POP	BC
	JR	FNDPRM
FND3	PUSH	HL		;1st matches, ck rest
	PUSH	DE
	PUSH	BC
	DEC	B		;adj for 1st match
FND4	INC	DE
	INC	HL
	LD	A,(DE)
	CP	' '
	JR	Z,FND7		;stop checking on space
	CP	CR
	JR	Z,FND7		;or end of line
	CALL	CKLCA2Z		;Ck & convert a-z to A-Z
	CP	(HL)		;compare remaining chars
	JR	NZ,FND6		;jump on mismatch
	DJNZ	FND4		;loop to count
FND5	POP	BC		;must have matched
	POP	DE		;bypass remaining part
	POP	HL		;  of field and point to
	PUSH	BC		;  address vector of parm
	LD	C,B		;  in parm table
	LD	B,0
	ADD	HL,BC
	POP	BC
	XOR	A
	RET
FND6	CP	'0'		;no match, is it ASCII?
	JR	C,FND7
	CP	'9'+1		;0-9?
	JR	C,FND8
	CP	'A'		;A-Z?
	JR	C,FND7
	CP	'Z'+1
	JR	C,FND8
FND7	LD	A,(HL)		;if table entry also a
	CP	' '		;  space, we have a match
	JR	Z,FND5
FND8	POP	BC
	POP	DE
	POP	HL
	JR	FND2
	ENDIF
;*=*=*
;	Routine to ck on space or comma
;*=*=*
CKSPCOM	CP	' '
	RET	Z
	CP	','
	RET
;*=*=*
;	Routine to convert a-z to A-Z & set C-flag
;*=*=*
CKLCA2Z	CP	'a'		;Back with C-flag if
	RET	C		;  not a-z
	CP	'z'+1
	CCF
	RET	C
	XOR	20H		;Make U/C & reset CF
	RET
*LIST	ON
;
;*****
;	error processing
;*****
IOERR	LD	L,A		;Xfer errnum to HL
	LD	H,0
	OR	0C0H		;Set brief, return
	LD	C,A
	@@ERROR			;Display error
	JR	ERREXIT
SPCREQ	LD	HL,SPCREQ$	;"filespec required"
;
*LIST	OFF
	IF	.NOT.SMALL
*LIST	ON
	DB	0DDH
NESTS	LD	HL,NESTS$
	DB	0DDH
TOOLNG	LD	HL,TOOLNG$	;"symbol too long..
	DB	0DDH
NOFIND	LD	HL,NOFIND$	;"proc not found..
	DB	0DDH
LBLERR	LD	HL,LBLERR$	;"too many proc labels..
	DB	0DDH
DSKFUL	LD	HL,DSKFUL$	;"can't create SYS/JCL"
	DB	0DDH
PRMERR	LD	HL,PRMERR$	;"parameter error"
	DB	0DDH
MULDEF	LD	HL,MULDEF$	;"multiply defined
	ENDIF
*LIST	ON
;
EXTERR	@@LOGOT
	LD	HL,-1		;Set error exit
ERREXIT	EQU	$
	LD	DE,JFCB$	;If the output JCL file
	LD	A,(DE)		;  is open, then we need
	BIT	7,A		;  to close it
	JR	Z,SPSAV
	@@CLOSE
SPSAV	LD	SP,$-$
	RET
;
*LIST	OFF
	IF	.NOT.SMALL
*LIST	ON
DOFCB	DS	32
CURSYM	DS	8
STRLEN	DS	1
VALBUF	DS	32
LBLSAV	DS	8
	NOP			;must be zero
	ENDIF
;
*LIST	ON
LINENO	DW	0		;JCL line #
SYSJCL	DB	'SYSTEM/JCL',3
SPCREQ$	DB	'File spec required',CR
*LIST	OFF
	IF	.NOT.SMALL
*LIST	ON
LINLNG$	DB	'Line too long',CR
TOOLNG$	DB	'Symbol string too long',CR
NOFIND$	DB	'Procedure not found',CR
LBLERR$	DB	'Too many Proc labels',CR
DSKFUL$	DB	'Can''t create SYSTEM/JCL file',CR
MULDEF$	DB	'Multiply defined ' ;follow with PRMERR$
PRMERR$	DB	'Parameter error',CR
BADJCL$	DB 'Invalid JCL format, processing aborted',CR
NESTS$	DB	'Too many nested INCLUDEs',CR
NESTPTR	DW	NESTFCB		;Pointer to nest FCB
NESTFCB	DS	32*5		;Space for 5 levels
NESTEND	EQU	$		;Ck for too many includes
CONDPTR	DW	CONDFLG		;Conditional pointer
CONDFLG	DB	0		;Init 1st state to TRUE
	DS	31		;32 conditional levels
BADHDR$	DB	'Line xxxxx -->'
JCLBUF1	DS	80
	ORG	$<-8+1<+8
INPBUF	DS	256
OUTBUF	DS	256
SYMTAB	DB	0
	ENDIF
*LIST	ON
CORE$	DEFL	$
;
	END	DO
