;LBDIRC/ASM - DIR math, strings, & buffers - 11/04/83
*LIST OFF
	SUBTTL	'<LBDIRC - Math Routines>'
	PAGE
*LIST ON
;
;********************************************************
;***						      ***
;*** CALCK - Calculate the # of K given # of Grans    ***
;***						      ***
;*** DE => # of Granules			      ***
;*** HL => Destination of #K ASCII string	      ***
;***						      ***
;********************************************************
;
CALCK	LD	(CALCK2+1),HL	;Stuff dest address
;
;*=*=* Calc # of Free Sects (Sectors/Gran x Grans) *=*=*
;
	EX	DE,HL		;HL = # of Free Grans
CALCK1	LD	C,$-$		;C = Sectors/Gran
	@@MUL16			;Mult HL x C
;
;*=*=* LA = Total # of Sectors - Divide by 4 for K *=*=*
;
	PUSH	AF		;save offset
	LD	H,L		;Set HL = LA
	LD	L,A		;
	SRL	H		;Divide HL / 4
	RR	L		;
	SRL	H		;
	RR	L		;
;
;*=*=* P/u dest address & stuff in # of FULL K *=*=*
;
CALCK2	LD	DE,$-$		;p/u destination address
	CALL	CVDDEC		;stuff in message
	INC	DE		;DE => Hundredths
;
;*=*=* Stuff hundredths value into string *=*=*
;
	POP	AF		;rcvr offset to
	AND	3		;Get offset
	ADD	A,A		;
	LD	B,0		;
	LD	C,A		;BC = offset
	LD	HL,HUNDTAB	;HL => Hundredths table
	ADD	HL,BC		;HL => Hundredths offset
	LD	C,2		;BC = 2 characters
	LDIR			;Transfer to DE
	RET
;
;
;********************************************************
;***						      ***
;*** CPHLDE - Compare HL to DE			      ***
;***						      ***
;********************************************************
;
CPHLDE	LD	A,H		;P/u high byte
	CP	D		;Same ?
	RET	NZ		;no - Return C or NC
	LD	A,L		;p/u low byte
	CP	E		;Less than or greater ?
	RET			;return - C, NC, or Z
;
;
;********************************************************
;***						      ***
;*** UNPACK - Unpack the Date from a directory entry  ***
;***						      ***
;*** HL => DIR+1				      ***
;*** DE <= Date in DATE$ format			      ***
;***						      ***
;********************************************************
;
UNPACK	LD	A,(HL)		;P/u DIR+1
	AND	0FH		;Bits 3-0 contain month
	LD	D,A		;Save month in D
;
;*=*=* D = Month (1-12) *=*=*
;
	INC	HL		;HL => DIR+2
	LD	A,(HL)		;p/u Day/Year byte
	AND	0F8H		;Bits 0-2 contain year
	LD	E,A		;stuff in E
;
;*=*=* E 9 Year (0-7) *=*=*
;
	LD	A,(HL)		;p/u Day/Year byte
	XOR	E		;strip off year
	RRCA			;Bits 7-3 contain day
	RRCA			;
	RRCA			;
	OR	D		;Merge with month
	LD	D,A
	RET
;
;
;*****
;	conversion of grans to decimal
;*****
CVDDEC	LD	A,' '
	LD	BC,10000
	CALL	CVD0
	LD	BC,1000
	CALL	CVD0
CVD100	LD	BC,100
	CALL	CVD0
CVD10	LD	BC,10
	CALL	CVD0
	LD	A,L
	ADD	A,30H
	LD	(DE),A
	INC	DE
	RET
CVD0	PUSH	DE
	LD	E,A
	LD	D,0FFH
	XOR	A
CVD1	INC	D
	SBC	HL,BC
	JR	NC,CVD1
	ADD	HL,BC
	LD	A,E
	LD	B,D
	POP	DE
	LD	(DE),A
	INC	B
	DEC	B
	JR	Z,CVD2
	LD	A,B
	ADD	A,30H
	LD	(DE),A
	LD	A,30H
CVD2	INC	DE
	RET
;
;
;********************************************************
;***						      ***
;*** CKPAGE - Check for Page Pause		      ***
;***						      ***
;********************************************************
;
CKPAGE	LD	A,$-$		;Ck for display pause
	DEC	A		;count down
	LD	(CKPAGE+1),A	;update
	RET	NZ		;ret if not yet full
;
;*=*=* Displayed a full page - Reset Counter *=*=*
;
	LD	A,22		;reset to max lines/page
	LD	(CKPAGE+1),A	;
;
;*=*=* Don't pause if NOPAUSE (N) parm entered *=*=*
;
NPARM	LD	DE,0		;p/u NOPAUSE parm
	LD	A,E		;specified ?
	OR	D		;
	RET	NZ		;nonstop if non-zero
;
;*=*=* Non-Stop if <DO> in effect *=*=*
;
SFLAG	LD	A,$-$		;p/u SFLAG$
	AND	20H		;strip all but <DO> bit
	RET	NZ		;return if do in effect
;
;*=*=* There isn't a <DO> in effect - Wait for key *=*=*
;
	@@KEY			;wait for key entry
IOERR5	JP	NZ,IOERR
;
;*=*=* Clear Screen *=*=*
;
	@@CLS			;Clear Screen
	JR	NZ,IOERR5	;
;
;*=*=* If the NOTITLE flag is set - don't display *=*=*
;
NOTITLE	LD	A,$-$		;p/u flag
	OR	A		;No title ?
	RET	NZ		;then RETurn
;
;*=*=* Display a title if There were matching files *=*=*
;
	LD	A,(FILFLAG)	;Was a matching file
	OR	A		;Displayed ?
	CALL	NZ,CKTITL	;yes - display title
	RET			;Return
;
;
;********************************************************
;***						      ***
;*** CKPAWS - Check for <SHIFT><@> or <BREAK>	      ***
;***						      ***
;********************************************************
;
CKPAWS
;
;*=*=* Was the <BREAK> key hit ? *=*=*
;
KFLAG	LD	A,($-$)		;p/u KFLAG$
	RRCA			;<BREAK> hit ?
	JP	C,ABORT		;yes - cease DIR
;
;*=*=* Is the <PAUSE> bit set ? *=*=*
;
	RRCA			;<PAUSE> bit set ?
	RET	NC		;Ret if not pause
;
;*=*=* The <PAUSE> bit is set - Wait for Char *=*=*
;
CKPAW1	@@KEY			;Scan keyboard
;
;*=*=* Character entered - Ignore it if <SHIFT><@> *=*=*
;
CKPAW2	CP	60H		;<SHIFT><@> ?
	JR	Z,CKPAW1	;yes - get another char
	CP	BREAK
	JP	Z,ABORT
;
;*=*=* Reset <PAUSE> & <ENTER> bits *=*=*
;
RESKFL	LD	A,($-$)		;p/u KFLAG$
	AND	0F9H		;reset <PAUSE> & <ENTER>
KFLAG1	LD	($-$),A		;stuff into KFLAG$
	RET			;& RETurn
;
;
;********************************************************
;***						      ***
;*** CKTITL - Display Title			      ***
;***						      ***
;********************************************************
;
;*=*=* Display Disk type Header *=*=*
;
CKTITL	LD	HL,DSTRING	;HL => Heading
	CALL	LINOUT		;output line
	CALL	CKPAGE		;Bump line count
	CALL	CKPAGE		;twice.
;
;*=*=* Display Attributes header if A parm spec'd *=*=*
;
	CALL	CKPAGE		;bump line count
	LD	A,(APARM+1)	;Was the A parm spec'd
	OR	A		;
	LD	A,CR		;Output a C/R if A
	JP	Z,BYTOUT	;not specified.
;
	LD	HL,HEADING	;HL => Attr heading
	CALL	LINOUT		;output line
;
;*=*=* Display Underline *=*=*
;
	PUSH	BC		;Save BC
	LD	B,79		;Display underline
D79L	LD	A,'-'		;
	CALL	BYTOUT		;output byte
	DJNZ	D79L		;79 times
	POP	BC		;Restore BC
	LD	A,CR		;One C/R between
	CALL	BYTOUT		;
	JP	CKPAGE		;Check page pause & RET
	SUBTTL '<LBDIRC - Sort Code>'
;
;
;********************************************************
;***						      ***
;*** SORTIT - Set up Directory Records for Shell Sort ***
;***						      ***
;********************************************************
;
SORTIT	LD	HL,(DIRPTR)	;Calculate # of records
	LD	DE,MEMORY	;Point to buf start
	LD	(HL),E		;Prime the 1st index
	INC	HL		;  in case there is
	LD	(HL),D		;  only one record
	DEC	HL		;  to sort
	XOR	A
	SBC	HL,DE		;PTREND - PTRBGN
	RET	Z		;Ret if nothing
;
;*=*=* Set HL = # of directory entries *=*=*
;
	LD	B,5		;Divide by
SORT1	SRL	H		;  32 bytes/record
	RR	L
	DJNZ	SORT1
;
;*=*=* Set B = # of entries & init count *=*=*
;
	LD	B,L		;Set loop counter
	PUSH	BC		;Save it for printing
	LD	(COUNTM1),HL	;Init the count
;
;*=*=* Skip sort if # of entries = 0 *=*=*
;
	LD	A,H		;If length = 0
	OR	L		;  then no need to sort
	JR	Z,SORT2A
	ADD	HL,HL		;Make sure enuff room
	EX	DE,HL
	LD	HL,(MAXMEM)
	XOR	A
	SBC	HL,DE
	JP	C,NOMEM
	LD	HL,(DIRPTR)	;Set up the index array
	LD	DE,MEMORY	;Starting record pointer
SORT2	LD	(HL),E		;Place record pointers
	INC	HL		;  into index array
	LD	(HL),D
	INC	HL
	LD	A,E		;Increment pointer by 32
	ADD	A,32
	LD	E,A
	JR	NC,$+3		;Go if no overflow
	INC	D		;  else bump high order
	DJNZ	SORT2		;Loop for all records
	CALL	SHELL		;Sort the dir records
SORT2A	POP	BC		;Recover loop counter
	LD	HL,(DIRPTR)	;P/u starting record
SORT3	LD	E,(HL)		;Grab its address
	INC	HL
	LD	D,(HL)
	INC	HL
	PUSH	HL		;Save index pointer
	PUSH	BC		;Save loop counter
	EX	DE,HL		;Record address -> HL
	CALL	MATCH		;Display the record
	POP	BC		;Rcvr loop counter
	POP	HL		;Rcvr index pointer
	DJNZ	SORT3
	RET
;
;
;********************************************************
;***						      ***
;*** SHELL - Shell Sort Routine			      ***
;***						      ***
;********************************************************
;
SHELL	LD	HL,$-$		;P/u count minus 1
COUNTM1	EQU	$-2
	LD	(STORM),HL
;*=*=*
;	Start Select & Compare
;*=*=*
CYCLE	LD	DE,0		;M = M / 2
STORM	EQU	$-2
	SRL	D
	RR	E
	LD	A,D		;return when M=0
	OR	E
	RET	Z
	LD	(STORM),DE
	LD	HL,(COUNTM1)	;K = N - M
	SBC	HL,DE
	LD	(STORK),HL
	LD	HL,0		;J = 0
	LD	(STORJ),HL
AGAIN	LD	HL,$-$		;I = J
STORJ	EQU	$-2
	LD	(STORI),HL
REPEAT	LD	HL,$-$		;L = I + M
STORI	EQU	$-2
	LD	DE,(STORM)
	ADD	HL,DE
	ADD	HL,HL		;L * 2 -> regHL
	PUSH	HL		;save L
	LD	HL,(STORI)	;I * 2 -> regHL
	ADD	HL,HL
	LD	BC,(DIRPTR)	;p/u string parm ptr
	ADD	HL,BC		;pt to A$(I) parm
	EX	DE,HL		;ptr -> DE
	POP	HL		;pt to A$(L) parm
	ADD	HL,BC		;ptr -> HL
	PUSH	HL		;save ptr to A$(L)
	PUSH	DE		;save ptr to A$(I)
	LD	B,11		;Set compare length
	PUSH	BC		;save cpr len & flag
	LD	A,(HL)		;p/u string2 ptr
	INC	HL
	LD	H,(HL)
	LD	L,A
	LD	BC,5		;key is 5 bytes in
	ADD	HL,BC
	EX	DE,HL		;string2 ptr -> rDE
	LD	A,(HL)		;p/u string1 ptr
	INC	HL
	LD	H,(HL)
	LD	L,A
	ADD	HL,BC		;key is 5 bytes in
	POP	BC		;rcvr len & flag
BACK	LD	A,(DE)		;go swap if str1>str2
	SUB	(HL)
	JR	C,POP
	JR	NZ,FINIS	;next str if str2>str1
	INC	DE		;loop if this matches
	INC	HL
	DJNZ	BACK
	JR	FINIS		;None really should match
POP	POP	DE		;else swap
	POP	HL
	LD	B,2		;swap 2-byte
SWAP	LD	C,(HL)		;string pointer
	EX	DE,HL
	LD	A,(HL)
	LD	(HL),C
	EX	DE,HL
	LD	(HL),A
	INC	HL
	INC	DE
	DJNZ	SWAP
	LD	HL,(STORM)	;p/u M
	EX	DE,HL
	LD	HL,(STORI)	;p/u I
	XOR	A
	SBC	HL,DE
	LD	(STORI),HL	;I = I - M
	JR	NC,REPEAT	;repeat if I => 0
	JR	EXITSRT		;else exit the loop
FINIS	POP	DE
	POP	HL
EXITSRT	LD	HL,(STORJ)
	INC	HL		;J = J + 1
	LD	(STORJ),HL
	XOR	A
	LD	DE,$-$		;			*
STORK	EQU	$-2
	SBC	HL,DE		;J - K
	JP	NC,CYCLE	;cycle if J => K	*
	JP	AGAIN		;else again
	SUBTTL '<LBDIRC - Data>'
;
;
;###############  PARAMETER TABLE  #################
;
PRMTBL$	DB	80H		;6.x parameters
;
;*** A - Flag input only ***
;
	DB	FLAG!1
	DB	'A'
	DB	0
	DW	APARM+1
;
;*** INV (I) - Flag input only ***
;
	DB	FLAG!ABB!3
	DB	'INV'
	DB	0
	DW	IPARM+1
;
;*** P - Flag input only ***
;
	DB	FLAG!1
	DB	'P'
	DB	0
	DW	PPARM+1
;
;*** SYS (S) - Flag input only ***
;
	DB	FLAG!ABB!3
	DB	'SYS'
	DB	0
	DW	SPARM+1
;
;*** N - Flag input only ***
;
	DB	FLAG!1
	DB	'N'
	DB	0
	DW	NPARM+1
;
;*** DATE (D) - Flag or String input ***
;
	DB	FLAG!STR!ABB!4
	DB	'DATE'
DRESP	DB	0
	DW	DATPRM+1
;
;*** MOD (M) - Flag input only ***
;
	DB	FLAG!ABB!3
	DB	'MOD'
	DB	0
	DW	CKMOD+1
;
;*** SORT (O) - Flag input only ***
;
	DB	FLAG!4
	DB	'SORT'
	DB	0
	DW	SORTPRM+1
;
	DB	FLAG!1
	DB	'O'
	DB	0
	DW	SORTPRM+1
;
;
	DB	0
;
DEN	DB	'xDEN'
HARD	DB	'Hard'
;
DSTRING	DB	'Drive :'
DRIVE	DB	'd  '
NAME	DB	'diskname  '
CYLCNT	DB	'    Cyl, '
DENSITY	DB	'nDEN, Free ='
KFREE	DB	'     .  K / '
KPOSS	DB	'     .  K,  Date '
DATBUF	DB	'dd-mmm-yy',CR
;
HEADING	DB	'Filespec    MOD   Attr   Prot   LRL'
	DB	'  #Recs   EOF  File Size   Ext     Mod '
	DB	'Date ',CR
;
PLEVEL	DB	'Prot   '
LRL	DB	'     '
RECORDS	DB	'        '
OFFSET	DB	'     '
KSIZE	DB	'     .  K    '
EXTENTS	DB	'       '
DATEFLD	DB	'dd-mmm-yy',ETX
;
FSTRING	DB	'           '
FDISP	DB	'    files out of '
FUSED	DB	'    selected, Space = '
SPUSED	DB	'     .  K',LF,CR
;
NODISK	DB	'Drive :'
NDRIVE	DB	'n  [No  Disk]',LF,CR
;
TDATE	DB	'mm/dd/yy"'
BLANKS	DB	'            '
PROTS$	DB	'FULLREMVNAMEWRITUPDTREADEXECNO  '
MAXDAYS	DB	31,28,31,30,31,30,31,31,30,31,30,31
HUNDTAB	DB	'00255075'
NOMEM$	DB	'Insufficient memory for SORT buffer',CR
BADFMT$	DB	'Bad date format',CR
MONTBL	DB	'JanFebMarAprMayJunJulAugSepOctNovDec'
STARS	DB	'*****'
FTFLG	DB	0
FILFLAG	DB	0
DIRPTR	EQU	$
MAXMEM	EQU	DIRPTR+2
FMPAKD	EQU	MAXMEM+2
TOPAKD	EQU	FMPAKD+2
LILBUF$	EQU	TOPAKD+2
;
;
;
GAT	EQU	LILBUF$+3<-8+1<+8
HIT	EQU	GAT
BUF2	EQU	GAT+256
MEMORY	EQU	GAT+512
;
*LIST OFF
	PAGE
	SUBTTL '<LBDIRC - Initialization Code>'
*LIST ON
;
;*=*=* DIR Entry Point - Initialization code *=*=*
;
DIR
	@@CKBRKC		;Check for break
	JR	Z,DIRA		;if not go
	LD	HL,-1		; else abort
	RET
;
;
DIRA
	LD	(SAVESP+1),SP	;Save SP address
	PUSH	HL		;Save command ptr
;
;*=*=* Pick up Flag Table base Address *=*=*
;
	@@FLAGS			;IY => System Flag table
	PUSH	IY		;Xfer to HL too
	POP	DE		;
;
;*=*=* Calculate KFLAG$ address & stuff away *=*=*
;
	LD	HL,KFLAG$	;KFLAG$ offset
	ADD	HL,DE		;HL => KFLAG$
	LD	(KFLAG+1),HL	;put in LD A,(0000) inst
	LD	(RESKFL+1),HL	;put in LD A,(0000) inst
	LD	(KFLAG1+1),HL	;put in LD (0000),A inst
;
	CALL	RESKFL		;Reset bits 0-2 of KFLAG$
	POP	HL		;rvr command ptr
;
;*=*=* Pick up SFLAG
;
	LD	A,(IY+'S'-'A')	; Get that guy
	LD	(SFLAG+1),A	;Put it away
;
;
;*=*=* Find parameter entry if existent *=*=*
;
	PUSH	HL		;Save command ptr
FPLP	LD	A,(HL)		;p/u character
	CP	'('		;parameter(s) ?
	JR	Z,GETPRM	;yes - go get 'em
	CP	CR		;End of line ?
	JR	Z,RESTPTR	;yes - restore ptr
	INC	HL		;no - bump til end
	JR	FPLP		;do til eol or "("
;
;*=*=* Process any parameters entered *=*=*
;
GETPRM	LD	DE,PRMTBL$	;DE => Parameter table
	@@PARAM			;@PARAM
RESTPTR	POP	HL		;recover ptr
	JP	NZ,IOERR	;NZ - "Parameter Error"
;
;*=*=* If first character is a "8" or "9" abort *=*=*
;
	LD	A,(HL)		;Is this a "8" or "9" ?
	CP	CR		;If CR, then global!
	JR	Z,DIR2
	CP	'8'		; if so - Illegal drive #
	JR	Z,ILLDRV	;
	CP	'9'		;
	JR	NZ,CKITOUT	; must be a partspec
;
;*=*=* Illegal Drive Number *=*=*
;
ILLDRV	JP	ERR32		;Go to I/O error handler
;
;*=*=* Pick up Drive # Range field if any *=*=*
;
CKITOUT	PUSH	HL		;Save source ptr
	CALL	CKDSPEC		;Legal Drive range ?
	POP	DE		;save source ptr in DE
	JR	Z,DIR3		;legal - use HL
;
;*=*=* Point DE => Partspec match field, B=8 chars *=*=*
;
	EX	DE,HL		;illegal - use DE
	LD	A,(HL)		;p/u first char
	INC	HL		;and bump to next
DIR0	LD	DE,BLANKS	;DE => Partspec area
	LD	B,8		;B = 8 chars/filename
;
;*=*=* Was the NOT switch entered ? *=*=*
;
	CP	'-'		;NOT ?
	JR	NZ,DIR1		;no - continue
;
;*=*=* NOT "-" entered - set flag & bump cmd ptr *=*=*
;
	LD	(MFLG+1),A	;stuff "-" in flag
	LD	A,(HL)		;p/u next char & bump
	INC	HL		;command ptr
;
;*=*=* Transfer Filename to Filespec buffer *=*=*
;
DIR1	CALL	PRSPC		;Parse 8 chars
	CP	'/'		;Extension ?
	JR	NZ,DIR2		;no - don't check
;
;*=*=* Transfer Extension to Filespec buffer *=*=*
;
	LD	DE,BLANKS+8	;DE => Extension field
	LD	B,3		;max 3 chars
	LD	A,(HL)		;p/u next character
	INC	HL		;bump
	CALL	PRSPC		;xfer extension
;
;*=*=* Was a drivespec entered ? *=*=*
;
DIR2	CP	':'		;drive entered?
	LD	BC,7		;st = 0, terminating = 7
	JR	NZ,DIR3		;no - use drive 0
;
;*=*=* Check if char following is a legal drive # *=*=*
;
	CALL	CKDSPEC		;legal Drive field ?
	JR	NZ,ILLDRV	;illegal - abort
	CP	8		;Trap DIR :8
	JR	Z,ILLDRV
;
;*=*=* B = Start drv #, C = Term drv # - save 'em *=*=*
;
DIR3	LD	A,B		;Save starting drive
	LD	(DIR3A+1),A	;
	SUB	C		;Set Specific Drive flag
	LD	(SPECIF+1),A	;
	LD	A,C		;Save term drive
	LD	(TERMDRV+1),A	;
;
;*=*=* Command line parsed - check available mem *=*=*
;
	BIT	1,(IY+CFLAG$)	;BIT 1 of CFLAG$ set ?
	LD	HL,0		;Set SORT (O) parm = 0
	JR	Z,GETHI		;no - fine
;
;*=*=* Executing from @CMNDR - Turn off SORT *=*=*
;
	LD	(SORTPRM+1),HL	;
;
;*=*=* Pick up Current HIGH$, & set max mem to use *=*=*
;
GETHI	LD	B,L		;B=0
	@@HIGH$			;
	LD	DE,-33		;Subtract 33 from it
	ADD	HL,DE		;
	LD	(MAXMEM),HL	;stuff in maximum memory
;
;*=*=* Turn on N parm if P parm specified *=*=*
;
	LD	HL,(PPARM+1)	;P/u P-parm
	LD	A,H		;Specified ?
	OR	L		;
	JR	Z,GTDATE	;no - don't change N
	LD	(NPARM+1),HL	;Turn on N-parm
;
;*=*=* Was the DATE parameter specified ? *=*=*
;
GTDATE	LD	A,(DRESP)	;Check out response
	OR	A		;any response ?
	JR	Z,DIR3A		;none entered - no date
;
;*=*=* Something was specified - Check type *=*=*
;
DATPRM	LD	HL,$-$		;P/u date
	BIT	6,A		;Flag input ?
	JR	Z,CHKSTR	;no - must be string
;
;*=*=* Flag input - if YES, then use today's date *=*=*
;
	LD	A,H		;DATE = OFF ?
	OR	L		;
	JR	Z,DIR3A		;yes - ignore it
;
;*=*=* DATE parameter entered - get today's date *=*=*
;
	LD	HL,TDATE	;HL => Todays Date
	PUSH	HL		;Save position
	@@DATE			;get today's date
	POP	HL		;HL => Today's Date
;
;*=*=* Display dates before "-mm/dd/yy" ? *=*=*
;
CHKSTR	LD	A,(HL)		;p/u first char
	CP	'-'		;"to-" ?
	JR	Z,CKTO		;yes - do it
;
;*=*=* Not before - set flag accordingly *=*=*
;
	LD	A,80H		;set from bit
	LD	(FTFLG),A	;note from entered
;
;*=*=* Pack Date entry *=*=*
;
	CALL	PAKDAT		;Pack the date entry
	LD	(FMPAKD),BC	;stuff away date
;
;*=*=* End of first date ? *=*=*
;
	LD	A,(HL)		;p/u terminator
	CP	'"'		;end of date ?
	JR	Z,FRCTO		;yes - use spec'd date
;
;*=*=* Is there a to "-" symbol following date ? *=*=*
;
	CP	'-'		;check for "-to"
	JR	NZ,DIR3A	;no - check if legal
;
;*=*=* Is there a date following ? *=*=*
;
CKTO	INC	HL		;bypass the '-'
	LD	A,(HL)		;p/u next char
	CP	'"'		;End of parm ?
	JR	Z,DIR3A		;yes - use that date
;
	CP	CR		;End of parm ?
	JR	Z,DIR3A		;yes - use that date
;
;*=*=* Something following - parse date *=*=*
;
	CALL	PAKDAT		;Pack Date
;
;*=*=* Stuff in "TO" packed date & set TO flag *=*=*
;
FRCTO	LD	A,(FTFLG)	;p/u From-To Flag
	OR	1		;set TO bit
	LD	(FTFLG),A	;Stuff in flag
	LD	(TOPAKD),BC	;Stuff for later
;
;*=*=* P/u starting drive #, & init page counter *=*=*
;
DIR3A	LD	C,$-$		;p/u starting drive
	LD	A,22		;24 lines on video
	LD	(CKPAGE+1),A	;Stuff in counter
	JP	DIR4		;Directory Start
;
;
;********************************************************
;***						      ***
;*** CKDSPEC - Check if a drive spec field is legal   ***
;***						      ***
;*** HL => Drive specification Field		      ***
;***						      ***
;*** Z - Set if Drive spec Field is Legal	      ***
;*** B <= Starting Drive # (0-7)		      ***
;*** C <= Terminating Drive # (0-7)		      ***
;***						      ***
;********************************************************
;
CKDSPEC	LD	A,(HL)		;p/u first character
	CP	'-'		;"TO" or "NOT" ?
	JR	NZ,NOTDASH	;no - check if drive #
;
;*=*=* Char is a "-" ---- Could be "TO" or "NOT" *=*=*
;
	CALL	LEGDRV		;Legal Drive Number ?
	RET	C		;no - RETurn NZ
;
;*=*=* Legal Drive # - Next char must be a term *=*=*
;
	LD	C,A		;C = Terminating Drive
	INC	HL		;HL => Following char
	CALL	TERM		;Does a term follow ?
	LD	B,0		;B  default start 0
	RET			;RETurn Z or NZ
;
;*=*=* Is the First character a legal drive # ? *=*=*
;
NOTDASH	CALL	LEGDRV+1	;Legal drive (0-7) ?
	RET	C		;no - RETurn NZ (ex 8)
	LD	B,A		;Set B = Starting Drive
	LD	C,A		;Set C = Terminator
;
;*=*=* Legal Drive - a "-" or term MUST follow *=*=*
;
	INC	HL		;bump to next char
	LD	A,(HL)		;If next char is not a
	CP	'-'		; "-", RETurn Z or NZ
	JR	Z,CKTDRIV	; depending on next char.
	CALL	TERM		;legal terminator ?
	JP	NZ,ILLDRV	;no - Illegal Drive #
	RET			;yes - Return
;
;*=*=* Is the character a terminator ? *=*=*
;
TERM	LD	A,(HL)		;p/u char
	CP	' '		;Space is legal
	RET	Z		;RETurn Z if space
	CP	CR		;C/R is legal
	RET	Z		;RETurn Z if C/R
	CP	'('		;Paren is legal
	RET			;RETurn w/ condition
;
;*=*=* Next char must be a valid drive # or term *=*=*
;
CKTDRIV	CALL	LEGDRV		;Legal Drive # ?
	LD	C,7		;C = Default term drive 7
	JR	C,TERM		;not drv # - ck for term
;
;*=*=* Make sure Term Drive # > or = Start Drive # *=*=*
;
	LD	C,A		;Set C = Term drive #
	CP	B		;> or = start drive # ?
	RET	C		;Less - Return
;
;*=*=* Drive span range good - make sure term legal *=*=*
;
	INC	HL		;bump ptr
	JR	TERM		;RETurn Z or NZ
;
;
;********************************************************
;***						      ***
;*** LEGDRV - Is a character a legal drive #	      ***
;***						      ***
;*** HL => One before Character to check	      ***
;*** HL <= Character in question		      ***
;*** A  <= Drive Number (0-7)			      ***
;*** CF <= Set if Character is not a legal drive #    ***
;***						      ***
;********************************************************
;
LEGDRV	INC	HL		;bump to next
	LD	A,(HL)		;p/u char
	SUB	'0'		;convert to binary
	CP	7+1		;Greater than "7" ?
	CCF			;C - Illegal
	RET			;RETurn with condition
;
;
;********************************************************
;***						      ***
;*** PRSPC - Parse a line and stuff in buffer	      ***
;***						      ***
;*** HL => Source Buffer			      ***
;*** DE => Destination of converted field	      ***
;*** B = # of characters to parse		      ***
;***						      ***
;********************************************************
;
PRSPC	CP	'$'		;wild character?
	JR	Z,PS2		;yes - stuff in buff
	CP	'A'		;Alphabetic ?
	JR	NC,PS1		;maybe - convert to U/C
;
;*=*=* Is the character a numeric value (0-9) ? *=*=*
;
	CP	'9'+1		;Greater than "9" ?
	RET	NC		;yes - return
	CP	'0'		;Less than "0" ?
	RET	C		;yes - return
;
;*=*=* Convert character to Upper Case *=*=*
;
PS1	CP	'a'		;lower case alpha ?
	JR	C,PS2		;no - stuff in buffer
	CP	'z'+1
	JR	NC,PS2
	RES	5,A		;convert to U/C
;
;*=*=* Put char in buffer, & bump cmd & buffer ptrs *=*=*
;
PS2	LD	(DE),A		;stuff in buffer
PS3	INC	DE		;bump
	LD	A,(HL)		;p/u command buff char
	INC	HL		;bump
	DJNZ	PRSPC		;B times
	RET			;
;
;
;********************************************************
;***						      ***
;*** PAKDAT - Pack Date & Stuff into buffer	      ***
;***						      ***
;*** HL => Buffer containing Date string	      ***
;*** BC <= Packed Date in lsb,msb format	      ***
;***						      ***
;********************************************************
;
PAKDAT	LD	A,(HL)		;p/u character
	LD	C,'/'		;init separator
;
;*=*=* Is the date a valid entry ? *=*=*
;
	CALL	PARSDAT		;parse entry
	JP	NZ,BADFMT	;abort on format error
;
;*=*=* If year = 1980 or 84 then set FEB = 29 days *=*=*
;
	EX	DE,HL		;save command ptr
	LD	A,(LILBUF$)	;p/u year (80-87)
	AND	3		;mask off bits 7-2
	LD	HL,MAXDAYS+1	;Set Feb to have 29 days
	JR	NZ,NOTLEAP	;no - don't inc it
	INC	(HL)		;leap year - inc max days
;
;*=*=* Check Range of month - must be 1-12 *=*=*
;
NOTLEAP	LD	A,(LILBUF$+2)	;p/u month
	DEC	A		;set month = 1-11
	CP	12		;Valid month ?
	JP	NC,BADFMT	;abort if 0 or >12
;
;*=*=* Valid month - point HL to max days/month *=*=*
;
	DEC	HL		;Point before JAN entry
	ADD	A,L		;add the month
	LD	L,A		;HL => max days for month
	JR	NC,NOINC	;Bump H if C set
	INC	H		;
;
;*=*=* Check if day entry is valid *=*=*
;
NOINC	LD	A,(LILBUF$+1)	;p/u day entry
	DEC	A		;reduce for test (0->FF)
	CP	(HL)		;more than max days ?
	JP	NC,BADFMT	;Go if too large (or 0)
;
;*=*=* Pick up month from buffer *=*=*
;
	LD	HL,LILBUF$+2	;HL => Month
	LD	A,(HL)		;P/u month
	LD	B,A		;save month
;
;*=*=* Transfer Day to Bit positions 3-7 *=*=*
;
	DEC	HL		;HL => Day
	LD	A,(HL)		;P/u day
	DEC	HL		;HL => Year
	RLCA			;Shift day to 3-7
	RLCA			;
	RLCA			;
	LD	C,A		;save in C
;
;*=*=* Pick up year & convert to binary (0-7) *=*=*
;
	LD	A,(HL)		;P/u year
	SUB	80		;adjust for offset
	JR	NC,GDATE	;If entry < 1980,
	XOR	A		; then use 1980
;
;*=*=* Shift year into positions 7-5 *=*=*
;
GDATE	RRCA			;Shift into bits 7-5
	RRCA			;
	RRCA			;
;
;*=*=* Merge with month & Return *=*=*
;
	OR	B		;& merge with month
	LD	B,A		;stuff in B
	EX	DE,HL		;HL => Buffer
	RET			;RETurn
;
;
;********************************************************
;***						      ***
;*** PARSDAT - Parse TIME/DATE string entry	      ***
;***						      ***
;*** HL => Buffer containing string to parse	      ***
;*** C  => Delimiter ("/" = DATE, ":" = TIME)	      ***
;***						      ***
;*** LILBUF$-LILBUF$+2 <= Data in compressed format   ***
;*** Z  - Set if successful			      ***
;***						      ***
;********************************************************
;
PARSDAT	LD	DE,LILBUF$+2	;point to buf end
	LD	B,3		;process 3 fields
;
;*=*=* Parse a field - Return NZ if bad *=*=*
;
PRS1	PUSH	DE		;save pointer
	CALL	PRS2		;get a digit pair
	POP	DE		;recover pointer
	RET	NZ		;ret if bad digit pair
;
;*=*=* Good field - Stuff in buff, dec ptr, & count *=*=*
;
	LD	(DE),A		;else stuff the value
	DEC	DE		;backup the pointer
	DEC	B		;loop countdown
	RET	Z		;do for 3 fields
;
;*=*=* Parsed a field - is the separator valid ? *=*=*
;
	LD	A,(HL)		;p/u separator
	INC	HL		;bump pointer
	CP	C		;correct ?
	JR	Z,PRS1		;yes - continue
	RET			;no - RET NZ
;
;
;********************************************************
;***						      ***
;*** PRS2 - Parse a digit pair at HL		      ***
;***						      ***
;********************************************************
;
PRS2	CALL	PRS4		;get a digit
	JR	NC,PRS3		;illegal - clr stc & RET
;
;*=*=* Legal Digit - Multiply by 10 *=*=*
;
	LD	E,A		;multiply by ten
	RLCA			;x 2
	RLCA			;x 4
	ADD	A,E		;x 5
	RLCA			;x 10
	LD	E,A		;stuff in E
;
;*=*=* Get another digit *=*=*
;
	CALL	PRS4		;get ones digit
	JR	NC,PRS3		;bad - return NZ
;
;*=*=* Legal digit - Add to tens digit & set Z flag *=*=*
;
	ADD	A,E		;accumulate new digit
	LD	E,A		;save 2-digit value
	CP	A		;clear flags
	RET			;return Z
;
;*=*=* Force NZ & Return *=*=*
;
PRS3	OR	A		;set NZ
	RET			;RETurn
;
;*=*=* Pick up a digit and convert to binary *=*=*
;
PRS4	LD	A,(HL)		;p/u a digit &
	INC	HL		;bump ptr
	SUB	'0'		;convert to binary
	CP	10		;Legal ?
	RET			;C - legal, NC - illegal
;
ENDMEM	EQU	$		;
