;LBDIRB/ASM - Display Filespec & attributes - 10/27/83
*LIST OFF
	SUBTTL	'<LBDIRC - File Attribute Output>'
	PAGE
*LIST ON
;
;********************************************************
;***						      ***
;*** MATCH - Display a File's Name and Extension      ***
;***						      ***
;********************************************************
;
MATCH	PUSH	HL		;Save HIT posn
	LD	HL,COUNT+1	;bump file count
	INC	(HL)		;
;
;*=*=* Was the Drive Header Displayed ? *=*=*
;
	LD	HL,FILFLAG	;HL => File Header flag
	XOR	A		;If (HL) is Non-Zero
	CP	(HL)		; then the header has not
	LD	(HL),A		; printed.
	CALL	NZ,CKTITL	;Display title if NZ
;
;*=*=* Position HL to Directory Entry Filename *=*=*
;
ALRPRT	POP	HL		;recover DEC
	LD	A,L		;p/u DEC
	AND	0E0H		;posn to entry
	ADD	A,5		;pt to start of filename
	LD	L,A		;HL => Filename field
;
;*=*=* Init B=8 chars for filename, C=19 to col *=*=*
;
	LD	C,19		;Chars to next column
	LD	B,8		;filename
;
;*=*=* Loop to Output the Filename *=*=*
;
DONAM1	LD	A,(HL)		;p/u character
	INC	HL		;bump DIR ptr
	CP	' '		;space ?
	JR	Z,DONAM2	;yes - done with filename
	CALL	BYTOUT2		;no - output char
	DJNZ	DONAM1		;field loop
	JR	DONAM3		;bypass ext calculation
;
;*=*=* Filename has < 8 chars, Pt to extension *=*=*
;
DONAM2	LD	A,L		;p/u low byte
	ADD	A,B		;add # of chars left
	DEC	A		;back one
	LD	L,A		;HL => Extension
;
;*=*=* Does this file have an extension ? *=*=*
;
DONAM3	LD	A,(HL)		;p/u first char
	CP	' '		;Non-blank ?
	JR	Z,DONAM5	;no - no extension
;
;*=*=* Output a "/" & Set up for Extension loop *=*=*
;
	LD	A,'/'		;display slash
	CALL	BYTOUT2		;
	LD	B,3		;3 chars max for EXT
;
;*=*=* Loop to output the extension *=*=*
;
DONAM4	LD	A,(HL)		;p/u char
	INC	HL		;bump ptr
	CP	' '		;space ?
	JR	Z,DONAM5	;exit on 1st blank
	CALL	BYTOUT2		;else display the char
	DJNZ	DONAM4		;loop 3 chars
;
;*=*=* Was the (A) parameter specified ? *=*=*
;
DONAM5	LD	A,(APARM+1)	;A parm specified ?
	OR	A		;
	JR	Z,DONAM5A	;no - continue
;
;*=*=* (A) parameter specified - Tab to column 14 *=*=*
;
	LD	A,C		;p/u chars left to col 20
	SUB	6		;adjust to column 14
	LD	B,A		;stuff into B for DJNZ
	CALL	OUTSPC		;Output B spaces
;
;*=*=* Output mod flag (if modified) & tab to 19 *=*=*
;
	LD	A,L		;Pt HL => DIR+0
	AND	0E0H		;
	LD	L,A		;
	CALL	OUTMOD		;output "+" if mod
	LD	B,3		;output 3 spaces
	CALL	OUTSPC		;output B spaces
;
;*=*=* Display the File's Attributes *=*=*
;
DONAM5A	LD	B,1		;Set B=1 space
	CALL	OUTSPC		;after filespec.
;
;*=*=* Point HL => DIR+0 (Attributes) *=*=*
;
	LD	A,L		;pt to 1st byte of
	AND	0E0H		;directory record
	LD	L,A		;
;
;*=*=* Display "?" if File OPEN bit set *=*=*
;
	LD	A,'?'		;"?" character
	INC	HL		;HL => DIR + 1
	BIT	5,(HL)		;File Open ?
	DEC	HL		;HL => DIR + 0
	CALL	NZ,BYTOUT2	;yes - output byte
;
;*=*=* Display an "*" if this is a PDS file *=*=*
;
	LD	B,(HL)		;p/u attributes byte
	LD	A,'*'		;Init for PDS display
	BIT	5,B		;
	CALL	NZ,BYTOUT2	;Display if PDS
;
;*=*=* Display an "S" if file is a SYS file *=*=*
;
	BIT	6,B		;is it a SYS file?
	LD	A,'S'		;
	CALL	NZ,BYTOUT2	;display S if so
;
;*=*=* Display an "I" if file is invisible *=*=*
;
	BIT	3,B		;is it an INV file?
	LD	A,'I'		;
	CALL	NZ,BYTOUT2	;display I if so
;
;*=*=* Point HL => Password Hash (DIR+16) *=*=*
;
	PUSH	HL		;save ptr to 1st dir byte
	LD	A,L		;pt to owner password
	ADD	A,16		;
	LD	L,A		;HL => DIR+16
;
;*=*=* Pick up Password in DE *=*=*
;
	LD	E,(HL)		;p/u in password in DE
	INC	L		;
	LD	D,(HL)		;
;
;*=*=* Is this a password protected File ? *=*=*
;
	PUSH	HL		;save ptr to user psw
	LD	HL,BLKHASH	;init to blanks hash
	SBC	HL,DE		;is password blanks?
	POP	HL		;
	JR	Z,DONAM6	;blanks - no "P"assword
;
;*=*=* Password - Display "P" if access <> ALL *=*=*
;
	LD	A,B		;p/u attributes byte
	AND	7		;get protection level
	LD	A,'P'		;init for protected
	JR	NZ,DONAM7	;stuff the 'P' if prot
;
;*=*=* Access = ALL, Pick up USER password in DE *=*=*
;
	INC	L		;HL => User Password
	LD	E,(HL)		;p/u in DE
	INC	L		;
	LD	D,(HL)		;
;
;*=*=* Set A = "P" is User Password <> blank *=*=*
;
	LD	HL,BLKHASH	;init to blanks hash
	SBC	HL,DE		;
	LD	A,'P'		;init to Protected
	JR	NZ,DONAM7	;stuff 'P' if acc<>blank
DONAM6	LD	A,' '		;else stuff a blank
;
;*=*=* Set Password flag if protected & display "P" *=*=*
;
DONAM7	LD	(ALL02+1),A	;stuff 'P' or blank
	CP	' '		;Space ?
	CALL	NZ,BYTOUT2	;display char if needed
	POP	HL		;HL => DIR+0
;
;*=*=* Display a "C" if the file was Created *=*=*
;
	INC	HL		;HL => DIR+1
	LD	A,(HL)		;p/u attributes
	DEC	HL		;HL => DIR+0
	RLCA			;Created ?
	LD	A,'C'		;"C"reate character
	CALL	C,BYTOUT2	;yes - output byte
;
;*=*=* Display Mod flag here if (A) not specified *=*=*
;
	LD	A,(APARM+1)	;p/u A-parm
	OR	A		;
	PUSH	AF		;Save condition
	CALL	Z,OUTMOD	;output mod flag if -A
	POP	AF		;NZ - (A) parm
;
;*=*=* If (A) parameter given - then tab to col 26 *=*=*
;
	JR	Z,DONAM8	;not A - go to 20
	LD	A,6		;Add 6 to column #
	ADD	A,C		;
	LD	C,A		;C = # of spaces
;
;*=*=* Position to Next designated column *=*=*
;
DONAM8	LD	A,' '		;write a space
	CALL	BYTOUT		;output byte
	DEC	C		;Dec column counter
	JR	NZ,DONAM8	;display trailing spaces
;
;*=*=* Display other neat things if (A) parm set *=*=*
;
APARM	LD	DE,-1		;p/u (A) parm
	LD	A,D		;specified ?
	OR	E		;
	CALL	NZ,ALL01	;full info if A-parm
;
;*=*=* Check for end of line *=*=*
;
DONAM9	LD	A,0		;count down 4-across
	DEC	A		;
	LD	(DONAM9+1),A	;update count
	RET	NZ		;loop if more to go
	LD	A,4		;else re-init to 4/line
	LD	(DONAM9+1),A	;
;
;*=*=* Finished with one line - end with C/R *=*=*
;
ENDLINE	LD	A,CR		;End line
	CALL	BYTOUT		;
	CALL	CKPAGE		;check for page pause
	CALL	CKPAWS		;scan pause or break
	RET			;loop
;
;
;********************************************************
;***						      ***
;*** ALL01 - Display Full Allocation of a file	      ***
;***						      ***
;********************************************************
;
ALL01	PUSH	HL		;save pointer to 1st byte
ALL02	LD	A,0		;bypass if not
	SUB	20H		;password protected
	JR	Z,ALL03
	LD	A,(HL)		;get prot level &
	AND	7		;multiply by 4
ALL03	RLCA			;to index string array
	RLCA
	LD	C,A
	LD	B,0
	LD	HL,PROTS$	;pt to 4-char abbrevs
	ADD	HL,BC		;pt to proper one
	LD	DE,PLEVEL	;move into output line
	LD	C,4
	LDIR
	POP	HL		;recover pointer to
	PUSH	HL		;1st byte of dir record
	INC	L
	INC	L
	INC	L
;
;*=*=* Pick up EOF offset byte & Stuff for later *=*=*
;
	LD	A,(HL)		;p/u EOF offset byte
	LD	(EOFBYTE+1),A	;stuff into LD DE,$-$
;*****
;	calculate EOF record according to the formula:
;	EOFREC= ((ERN-1)*256+EOF+LRL-1)/LRL if ERN<>0
;	EOFREC= 0 if ERN=0
;*****
	LD	A,(HL)		;p/u EOF offset byte
	PUSH	AF		;& save it
	INC	L		;pt to LRL
	LD	A,(HL)		;p/u LRL
	LD	(ALL04+1),A	;& stuff it
;*****
;	get LRL into message
;*****
	PUSH	HL		;save ptr
	LD	L,A		;transfer LRL to HL
	LD	H,0
	OR	A		;test for 0 => 256
	JR	NZ,$+3
	INC	H		;show 256
	LD	DE,LRL		;DE => LRL destination
	LD	A,' '		;init the ASCII byte
	CALL	CVD100		;cvrt to msg field
	POP	HL
;*=*=*
;	continue to calculate EOF
;*=*=*
	LD	A,L		;pt to ERN
	ADD	A,16
	LD	L,A
	LD	E,(HL)		;p/u into regDE
	INC	L
	LD	D,(HL)
	POP	BC		;rcvr EOF byte in regB
	EX	DE,HL		;xfer EOFREC -> regHL
ALL04	LD	A,0		;P/u LRL
	OR	A
	JR	Z,TSTSIZ	;Go use ERN if LRL=0
	LD	E,A		;Xfer LRL to reg E
	INC	B		;Test EOF
	DEC	B
	JR	Z,DONTDEC	;Don't dec ERN if EOF=0
	DEC	HL		;Reduce ERN for 0 offset
DONTDEC	CALL	DIVIDE
	LD	C,L
	LD	D,H
	LD	H,A
	LD	L,B		;P/u EOF
	LD	A,E
	CALL	DIVIDE
	LD	H,C
	OR	A
	JR	Z,DONTINC
	INC	HL		;Round up partial record
DONTINC	LD	A,D		;Ck if overflow
	OR	A
TSTSIZ	JR	Z,EOFBYTE	;Use calc'd ERN if not
;
;*=*=* Overflow in # of Records - use "*****" *=*=*
;
	LD	HL,STARS
	LD	DE,RECORDS	;DE => Destination
	LD	BC,5
	LDIR
	JR	DIR_0
;
;*=*=* If # Records = 0 then set EOF = 0 *=*=*
;
EOFBYTE	LD	DE,00		;p/u EOF offset byte
	LD	A,H		;# Records = 0 ?
	OR	L		;
	JR	NZ,KEEPEOF	;no - keep EOF
	LD	E,1		;Set EOF=1 (gets DECed)
KEEPEOF	PUSH	HL		;Save # Records
	LD	HL,OFFSET	;HL => Destination
	DEC	E		;DE = EOF byte
	EX	DE,HL		;Swap for conversion
	LD	A,' '		;init
	CALL	CVD100		;convert
;
;*=*=* Stuff # of Records used into string *=*=*
;
	POP	HL		;Recover # of Records
	LD	DE,RECORDS	;DE => Destination
	CALL	CVDDEC		;& stuff into message
;
;*=*=* Get # of extents & Granules used *=*=*
;
DIR_0	POP	HL		;rcvr ptr to 1st byte
	PUSH	HL
	CALL	ALL09		;get total grans in use
	PUSH	DE
	LD	L,C		;xfer # extents
	LD	H,B
	LD	DE,EXTENTS
	LD	A,' '
	CALL	CVD10		;cvrt to decimal & stuff
	POP	DE
;
;*=*=* DE = # Grans used - Add to Grans Counter *=*=*
;
	LD	HL,(TOTGRNS+1)	;p/u total grans
	ADD	HL,DE		;add this file's count
	LD	(TOTGRNS+1),HL	;& stuff into counter.
;
	LD	HL,KSIZE	;pt to where to stuff
	CALL	CALCK		;cvrt to K
	LD	HL,DATEFLD-1	;blank out day-mo-yr
	LD	DE,DATEFLD
	LD	BC,9
	LDIR
	POP	HL		;rcvr ptr to DIR+0
	LD	DE,DATEFLD
	INC	HL		;
	INC	HL		;advance to date field
	LD	A,(HL)
	OR	A
	JR	Z,ALL08		;ignore if no date saved
	RRCA			;has date, get day
	RRCA
	RRCA
	AND	1FH
	LD	B,2FH		;convert day to decimal
ALL06	INC	B		;by counting # of 10's
	SUB	10		;sub 10 from day #
	JR	NC,ALL06
	ADD	A,3AH		;cvrt lo order to ASCII
	PUSH	AF		;save day low order
	LD	A,B		;stuff day hi order
	LD	(DE),A
	INC	DE		;bump
	POP	AF		;rcvr lo order day #
	LD	(DE),A		;stuff low order
	INC	DE		;bump pointer to msg
	INC	DE		;to pt to month field
	PUSH	HL		;save DIR ptr
	DEC	HL		;pt to DIR+1 (month+)
	LD	A,(HL)		;p/u month etc
	AND	0FH		;strip off flags
	DEC	A		;(mon-1)*3 to index
	LD	C,A		;string conversion table
	RLCA
	ADD	A,C
	LD	C,A
	LD	B,0
	LD	HL,MONTBL
	ADD	HL,BC		;add offset to table
	LD	C,3
	LDIR			;move 3-char month
	INC	DE		;advance to year field
	LD	A,'8'		;stuff 8 of 1980
	LD	(DE),A
	INC	DE		;bump msg ptr
	POP	HL		;rcvr DIR+2
	PUSH	HL
	LD	A,(HL)		;p/u year field
	AND	7		;remove day
	ADD	A,'0'		;cvrt to ASCII
	LD	(DE),A		;stuff -> msg
	POP	HL		;rcvr DIR+2
	DEC	HL		;b/u to DIR+1
	LD	A,'-'		;else change to not cur
	LD	(DATEFLD+2),A	;stuff indicator
	LD	(DATEFLD+6),A	;between mo&day, day&yr
ALL08	LD	HL,PLEVEL	;pt to start of message
	CALL	LINOUT		;& output entire string
	LD	A,1		;show only one entry
	LD	(DONAM9+1),A	;per line if A-parm
	RET
;********************************************************
;***						      ***
;*** DIVIDE - Divide HL by A			      ***
;***						      ***
;********************************************************
;
DIVIDE	PUSH	BC		;Save BC
	LD	C,A		;xfer Divisor in C
	@@DIV16			;Divide HL / C
	POP	BC		;Restore BC
	RET			;
;
;********************************************************
;***						      ***
;*** OUTMOD - Output a "+" if file has been modified  ***
;***						      ***
;********************************************************
;
OUTMOD	INC	HL		;HL => DIR+1
	LD	A,' '		;default to no mod
	BIT	6,(HL)		;test MOD flag
	JR	Z,OUTCHR	;output space
	LD	A,'+'		;Mod flag char
OUTCHR	CALL	BYTOUT2		;display '+' if MOD
	DEC	HL		;repoint to 1st byte
	RET			;done
;
;*****
;	routine calculates total # of grans in use
;*****
ALL09	LD	A,(SORTPRM+1)	;If sorted, then data
	OR	A		;  already calculated
	JR	Z,ALL09A	;Go if not sorted
	PUSH	HL
	POP	IX		;P/u the saved data
	LD	E,(IX+22)
	LD	D,(IX+23)	;P/u Space used
	LD	C,(IX+24)
	LD	B,(IX+25)	;P/u # of extents
	RET
;
;********************************************************
;***						      ***
;*** ALL09A - Calculate space allocated to a file     ***
;***						      ***
;*** HL => DIR+0 of an FPDE			      ***
;*** BC <= # of Extents in the file		      ***
;*** DE <= # of Grans allocated to the file	      ***
;***						      ***
;********************************************************
;
ALL09A	LD	DE,0		;init gran counter to 0
	LD	B,E		;init extent ctr to 0
	LD	C,E
;
;*=*=* Point to First Extent of a directory entry *=*=*
;
ALL10	LD	A,L		;p/u low byte
ALL11	ADD	A,22		;
	LD	L,A		;HL => DIR + 22
;
;*=*=* Is the Extent Field in Use ? *=*=*
;
ALL14	LD	A,(HL)		;p/u cylinder
	INC	L		;bump to alloc info
	CP	0FEH		;another extent or done ?
	JR	NC,ALL15	;Either X'FE' or X'FF'
;
;*=*=* Extent Field is in use - Get allocation info *=*=*
;
	INC	BC		;bump extent counter
	LD	A,(HL)		;p/u alloc info
	INC	L		;bump ptr to next extent
	AND	1FH		;keep # of grans
	INC	A		;adj for zero offset
;
;*=*=* A = # of contig grans, add to gran counter *=*=*
;
	ADD	A,E		;accumulate # of grans
	LD	E,A		;
	JR	NC,ALL14	;forget hi if no carry
	INC	D		;bump hi
	JR	ALL14		;get next extent field
;
;*=*=* P/u DEC if (X'FE') or RET if done (X'FF') *=*=*
;
ALL15	RET	NZ		;ret if not extended
	LD	A,(HL)		;p/u DEC of FXDE
;
;*=*=* Point HL => Extended Directory Entry posn *=*=*
;
	AND	1FH		;get dir sector of DEC	PUSH	AF		;save it
	XOR	(HL)		;get dir record of FXDE
	LD	L,A		;save dir record position
	POP	AF		;recover DEC of FXDE
;
;*=*=* Is the Dir Sector with FXDE already in mem ? *=*=*
;
	PUSH	HL		;save ptr to 1st extent
	LD	HL,CKHIT6+1	;do we have this dir
	CP	(HL)		;sector in core?
	POP	HL		;restore ptr
SBUFFER	LD	H,00		;buffer hi order
	JR	Z,ALL10		;jump if we have it
;
;*=*=* Dir Sector not res - Is Ext buf resident ? *=*=*
;
ALL16	CP	0		;same as extended area?
	LD	H,BUF2<-8	;pt to extended buf area
	JR	Z,ALL10		;jump if we have it there
	LD	(ALL16+1),A	;else upd the test byte
;
;*=*=* Set B = Directory Entry Code of FXDE *=*=*
;
	PUSH	BC		;Save Gran counter
	PUSH	DE		;& Extent counter
	OR	L		;combine sector & record
	LD	B,A		;pointers to retrieve DEC
;
;*=*=* Set C = Logical Drive #, D = Directory Cyl *=*=*
;
	LD	A,(DRIVE)	;p/u ASCII drive #
	SUB	'0'		;adjust ot binary
	LD	C,A		;save in C
	LD	D,(IY+9)	;p/u Directory cyl in D
;
;*=*=* Set E = FXDE's Dir Sector, HL => I/O buffer *=*=*
;
	LD	A,B		;p/u DEC
	AND	1FH		;get sector #
	ADD	A,2		;adj for GAT & HIT
	LD	E,A		;stuff in E
	LD	HL,BUF2		;HL => I/O Buffer
;
;*=*=* Read in the FXDE's Directory Sector *=*=*
;
	@@RDSEC			;Read a system sector
	CP	6		;Expecting Error #6
	LD	A,11H		;read error?
	JP	NZ,IOERR	;jump if got error
;
;*=*=* Set A = offset into Sector of entry *=*=*
;
	LD	A,B		;p/u FXDE DEC
	AND	0E0H		;pt to dir record
	POP	DE		;restore counters
	POP	BC		;
	JR	ALL11		;loop through extents
;
;
;********************************************************
;***						      ***
;*** LINOUT - Output line to *DO/*PR		      ***
;***						      ***
;*** HL => Buffer to output			      ***
;***						      ***
;********************************************************
;
LINOUT	@@DSPLY			;Output line to *DO
	JR	NZ,IOER1	;NZ - Abort
	LD	A,(PPARM+1)	;ck P-parm
	OR	A
	RET	Z		;not spec'd - don't print
	@@PRINT			;output line to *PR
IOER1	JP	NZ,IOERR	;NZ - Abort
	RET
;
;
;********************************************************
;***						      ***
;*** BYTOUT - Output a byte to *DO/*PR		      ***
;***						      ***
;*** A = Character to output			      ***
;***						      ***
;********************************************************
;
BYTOUT2	DEC	C		;Decrement col #
BYTOUT	PUSH	BC		;Save BC
	LD	C,A		;Save char in C
	@@DSP			;display char
	JR	NZ,IOER1	;NZ - Abort
PPARM	LD	DE,0		;p/u P-parm
	INC	E		;specified ?
	JR	NZ,NOPRT	;no - don't print
	@@PRT			;output byte
	JR	NZ,IOER1	;NZ - Abort
	LD	A,C		;get back char
NOPRT	POP	BC		;restore BC
	RET			;and return
;
;
;********************************************************
;***						      ***
;*** OUTSPC - Output B spaces			      ***
;***						      ***
;********************************************************
;
OUTSPC	LD	A,' '		;space char
	CALL	BYTOUT2		;output space
	DJNZ	OUTSPC		;
	RET			;RETurn
