;LBDIRA - DIR main processing loop - 10/27/83
*LIST OFF
	SUBTTL	'<LBDIRA - Mainline Program>'
	PAGE
*LIST ON
;
;
;*****
;	error processing
;*****
;
NOMEM	LD	HL,NOMEM$
	DB	0DDH
BADFMT	LD	HL,BADFMT$
	@@LOGOT
;
ABORT	LD	HL,-1		;Set HL = -1
	JR	SAVESP		;abort
;
;*=*=* I/O Error Routine *=*=*
;
ERR32	LD	A,32		;"Illegal Drive Number"
IOERR	LD	L,A		;Set HL = Error #
	LD	H,0		;
	OR	0C0H		;Set short error
	LD	C,A		;stuff in C
	@@ERROR			;display error
	JR	SAVESP		;abort
;
;*=*=* Clear stack & wait a little while *=*=*
;
EXIT	LD	HL,0		;good exit
SAVESP	LD	SP,$-$		;p/u old SP address
ABORT3	@@CKBRKC		;clear break
	RET			;go home now
;
;*=*=* Init to 4 files/line & Drive # in string *=*=*
;
DIR4	PUSH	BC		;Save drive #
	LD	A,4		;4 filespecs/line
	LD	(DONAM9+1),A	;save
	LD	A,C		;p/u drive #
	ADD	A,'0'		;convert to ASCII
	LD	(DRIVE),A	;& stuff in message
	LD	(NDRIVE),A	;also stuff in No mount
;
;*=*=* Is the starting Drive available ? *=*=*
;
	@@GTDCT			;IY => DCT+0
	@@CKDRV			;Drive alive ?
	PUSH	AF		;Save RETurn condition
	CALL	CKPAWS		;<BREAK> hit ?
	POP	AF		;NZ - couldn't log drive
	JR	Z,GDCKDRV	;Z - Logged drive succ
;
;*=*=* Is this Drive enabled ? *=*=*
;
	LD	A,(IY)		;p/u Enable/Disable byte
	CP	0C3H		;Enabled ?
	JR	Z,NO_DISK	;yes - display No Disk
;
;*=*=* If this is not global - Illegal Drive # *=*=*
;
	LD	A,(SPECIF+1)	;specific drive # ?
	OR	A		;
	JP	Z,ERR32		;yes - illegal drive #
	JR	NEXTDRV		;no - get next drive
;
;*=*=* Enabled Drive - Display "No Disk" string *=*=*
;
NO_DISK	LD	(NOTITLE+1),A	;Turn off title
	CALL	CKPAGE		;check for scroll
	LD	HL,NODISK	;HL => "No Disk" string
	CALL	LINOUT		;display line
	CALL	CKPAGE		;check for scroll
	XOR	A		;Turn on Title
	LD	(NOTITLE+1),A	;
;
NEXTDRV	JP	CKHIT4		;Get next drive
;
;*=*=* Calculate quantity of Sectors/Gran *=*=*
;
GDCKDRV	PUSH	BC		;Save Drive #
	LD	A,(IY+8)	;p/u # Sectors/Gran
	AND	1FH		;mask off junk
	INC	A		;bump for zero offset
	LD	(CALCK1+1),A	;stuff it
;
;*=*=* P/u # Cylinders from DCT & stuff in string *=*=*
;
	LD	L,(IY+6)	;p/u cyl count
	INC	L		;offset from 0
	LD	H,0		;stuff in HL
	LD	DE,CYLCNT	;DE => Destination
	LD	A,' '		;leading space
	CALL	CVD100		;stuff in string
;
;*=*=* Create "DDEN" String or "HARD" string *=*=*
;
	LD	DE,DENSITY	;Destination
	LD	HL,DEN
	LD	A,'D'
	BIT	6,(IY+3)	;Ck density
	JR	NZ,DUBDEN
	LD	A,'S'
DUBDEN	LD	(HL),A
	LD	BC,4		;4 chars to Xfer
	BIT	3,(IY+3)	;Hard Drive ?
	JR	Z,DOLDIR
	LD	HL,HARD		;HL => "HARD"
DOLDIR	LDIR			;xfer string
;
;*=*=* Drive logged in - Read in GAT *=*=*
;
	POP	BC		;recover Drive #
	LD	HL,GAT		;HL => GAT buffer
	LD	D,(IY+9)	;D = Directory Cyl
	LD	E,0		;E = Gat Sector
	@@RDSSC			;Read Sector
	LD	A,20		;init "Direc Read Error"
	JP	NZ,IOERR	;"GAT Read Error"
	CALL	CKPAWS		;<BREAK> hit ?
;
;
;*=*=* Calculate the FREE space on the disk *=*=*
;
;
	LD	DE,0		;DE = Gran count
	LD	L,0CCH		;HL => GAT + X'CC'
	LD	A,(HL)		;p/u excess cyl byte
	ADD	A,35		;cyl excess of 35
	LD	B,A		;set loop counter
	LD	L,D		;HL => GAT + X'00'
	PUSH	BC		;Save cyl count in B
;
;*=*=* HL => GAT, B = # of cyls, DE = Gran count *=*=*
;
FS1	LD	A,(HL)		;p/u a GAT byte & set
FS2	SCF			;carry so bit 7 stays 1
;
;*=*=* Is the granule in use ? *=*=*
;
	RRA			;shift gran bit -> carry
	JR	C,FS3		;don't inc if in use
;
;*=*=* Free Granule - bump Free Granule Count *=*=*
;
	INC	DE		;another spare gran
FS3	CP	0FFH		;fin with this GAT byte?
	JR	NZ,FS2		;loop if not
;
;*=*=* Finished with GAT byte, advance to next *=*=*
;
	INC	L		;advance to next byte
	DJNZ	FS1		;B cylinders to check
;
;*=*=* DE = Free Grans, Calculate # Grans/cyl *=*=*
;
	POP	BC		;B = # of cylinders
	LD	A,(IY+8)	;p/u DCT+8
	RLCA			;move Grans/Cyl into
	RLCA			;bits 0-2
	RLCA			;
	AND	7		;
	INC	A		;A = Grans/Cylinder
	BIT	5,(IY+4)	;double-bit set ?
	JR	Z,NOTDUB	;no - don't double
	ADD	A,A		;double grans/cylinder
;
;*=*=* A = # Grans/Cyl, Calculate Total # of Grans *=*=*
;
NOTDUB	LD	HL,0		;init HL = 0
	PUSH	DE		;Save Free Grans
	LD	D,H		;Set DE = # cyls
	LD	E,B		;
	LD	B,A		;B = Grans/Cyl
;
;*=*=* Multiply Grans/Cyl (B) x # Cyls (DE) *=*=*
;
GPCLOOP	ADD	HL,DE		;Add cylinder count
	DJNZ	GPCLOOP		;grans/cyl times
;
;*=*=* HL = # of grans/disk, Is this a hard drive ? *=*=*
;
	BIT	3,(IY+3)	;Hard Drive ?
	JR	NZ,SKIPLOC	;yes-don't check lockout
;
;*=*=* Floppy disk - check for locked out cylinders *=*=*
;
	LD	B,E		;B = cylinder count
	EX	DE,HL		;Save total cnt in DE
	LD	HL,GAT+60H	;HL => Lockout table
	LD	C,0		;C = Locked out cyl count
	PUSH	AF		;Save Grans/Cyl in A
;
;*=*=* Loop to count up Locked out cylinders in C *=*=*
;
LKLOOP	LD	A,1		;init cyl checker
	AND	(HL)		;locked out ?
	JR	Z,GOODCYL	;no - good cylinder
	INC	C		;bump locked out count
GOODCYL	INC	L		;bump ptr
	DJNZ	LKLOOP		;B cylinders
;
;*=*=* Multiply Cylinders (BC) x Grans/Cyl *=*=*
;
	POP	AF		;A = Grans/Cyl
	PUSH	AF		;save it
	LD	H,B		;init HL = 0
	LD	L,B		;
;
GTUSED	ADD	HL,BC		;Add cylinder count
	DEC	A		;Grans/cyl times
	JR	NZ,GTUSED	;
	POP	AF		;A = Grans/Cyl
;
;*=*=* Subtract # of Grans locked out from total *=*=*
;
	OR	A		;clear carry
	EX	DE,HL		;
	SBC	HL,DE		;HL = Grans possible
SKIPLOC	POP	DE		;rcvr # of Free Grans
;
;*=*=* HL = # Grans possible, DE = # Grans Free *=*=*
;
	PUSH	HL		;Save Grans used
	LD	HL,KFREE	;Convert Grans Free
	CALL	CALCK		; to ASCII K & stuff
	POP	DE		; into string.
;
;*=*=* Calculate # of K used & stuff into header *=*=*
;
	LD	HL,KPOSS	;pt to where to stuff
	CALL	CALCK		;calculate K & stuff
;
;*=*=* Transfer Diskette Name into string buffer *=*=*
;
	LD	HL,GAT+0D0H	;HL => Diskette Name
	LD	DE,NAME		;move pack name -> header
	LD	C,8		;BC = 8 chars to xfer
	LDIR			;xfer into buff
;
;*=*=* Clear out Date buffer *=*=*
;
	LD	DE,DATBUF	;DE => Start of buffer
	LD	A,' '		;space
	LD	B,9		;9 chars to clear
CLRLP	LD	(DE),A		;stuff in space
	INC	DE		;bump
	DJNZ	CLRLP		;
;
;*=*=* HL => Date in mm/dd/yy format - p/u month *=*=*
;
	LD	A,(HL)		;p/u month
	SUB	'0'		;convert tens to binary
	LD	C,A		;save in C
;
;*=*=* Multiply first digit of month x 10 *=*=*
;
	ADD	A,A		;x 2
	ADD	A,A		;x 4
	ADD	A,C		;x 5
	ADD	A,A		;x 10
	LD	C,A		;Stuff in C
;
;*=*=* Pick up second digit of month & add to 10's *=*=*
;
	INC	HL		;bump to ones
	LD	A,(HL)		;p/u ones of month
	SUB	'0'		;convert to binary
	ADD	A,C		;A = Month (1-12)
	JR	Z,ILLDATE	;abort if NO DATE
	CP	13		;Legal Month ?
	JR	NC,ILLDATE	;no - illegal date
;
;*=*=* Legal Month - Mult x 3 & pt to month string *=*=*
;
	LD	C,A		;xfer month to C
	ADD	A,A		;x 2
	ADD	A,C		;x 3
	LD	C,A		;BC = offset
	PUSH	HL		;save date pointer
	LD	HL,MONTBL-3	;HL => Month String table
	ADD	HL,BC		;HL => Month String
;
;*=*=* HL => Month String, Stuff into Buffer *=*=*
;
	LD	DE,DATBUF+3	;DE => Destination
	LD	C,3		;BC = 3 chars to xfer
	LDIR			;xfer date to buffer
;
;*=*=* Transfer Day (00-31) into date buffer *=*=*
;
	POP	HL		;recover ptr
	INC	HL		;bump
	INC	HL		;HL => Day of month
	LD	DE,DATBUF	;DE => date buffer
	LD	C,2		;Xfer into buffer
	LDIR			;
;
;*=*=* Transfer Year into buffer *=*=*
;
	INC	HL		;HL => Year (80-87)
	LD	C,2		;2 chars to xfer
	LD	DE,DATBUF+7	;DE => Destination
	LDIR			;xfer into buffer
;
;*=*=* Stuff "-" after day & month *=*=*
;
	LD	A,'-'		;separator
	LD	(DATBUF+2),A	;
	LD	(DATBUF+6),A	;
;
;<><><>    Display the files in the directory     <><><>
;
;*=*=* Init DIR rec ptr = mem start, count = 0 *=*=*
;
ILLDATE	INC	A		;set flag
	LD	(FILFLAG),A	;set file alr disp flag
	LD	HL,MEMORY	;Init DIRPTR to start
	LD	(DIRPTR),HL	;of available memory
	XOR	A		;Set File display
	SBC	HL,HL		;Set HL = 0
	LD	(TFILES+1),HL	;Total Files = 0
	LD	(COUNT+1),HL	;count = 0
	LD	(TOTGRNS+1),HL	;Total Grans = 0
;
;*=*=* Read in the HIT of the disk *=*=*
;
	POP	BC		;recover Drive # in C
	LD	D,(IY+9)	;p/u directory cylinder
	LD	E,1		;pt to HIT sector
	LD	HL,HIT		;HL => I/O buffer
	@@RDSSC			;Read System Sector
	LD	A,16H		;"HIT read error"?
	JP	NZ,IOERR	;jump if read error
	CALL	CKPAWS		;<BREAK> hit ?
$JP0	JP	CKHIT5		;jump into middle of loop
;
;*=*=* Loop to Process HIT entries *=*=*
;
CKHIT	POP	HL
CKHIT1	POP	BC		;recover HIT pointer lo
;
;*=*=* Point HL => Last HIT entry *=*=*
;
	LD	H,HIT<-8	;set H = hi byte of HIT
	LD	L,B		;HL => Last HIT entry
;
;*=*=* Position to next entry of the Record *=*=*
;
CKHIT2	LD	A,L		;p/u current entry
	ADD	A,32		;add 32 (bytes/entry)
	LD	L,A		;HL => Next entry
	JR	NC,$JP0		;Go to next record ?
;
;*=*=* Position to entry zero of next record *=*=*
;
	INC	L		;posn to next record
	BIT	5,L		;done with drive ?
	JR	Z,$JP0		;no - process entry
;
;*=*=* Finished with drive - Sort data unless (O=N) *=*=*
;
	LD	A,(SORTPRM+1)	;If sort requested,
	OR	A		;  then need to output
	CALL	NZ,SORTIT	;  the sorted data
;
;*=*=* Were there any files displayed ? *=*=*
;
	LD	HL,(COUNT+1)	;p/u displayed file count
	LD	A,H		;any entered ?
	OR	L		;
	JR	NZ,FILES	;yes - dsp under if (A)
;
;*=*=* Display Title & line feed *=*=*
;
	LD	HL,DSTRING	;HL => Title
	CALL	LINOUT		;display title
	CALL	CKPAGE		;check for scroll
	CALL	CKPAGE		;check for scroll
	JR	NOTAP		;get next drive
;
;*=*=* Get next drive # if the A parm was specified *=*=*
;
FILES	LD	A,(APARM+1)	;Don't display if A
	OR	A		;
	JR	Z,NOTAP		;Not A - Output C/R
;
;*=*=* Were there any files shown in directory ? *=*=*
;
COUNT	LD	HL,$-$		;p/u count
	LD	A,H		;any files shown ?
	OR	L		;
	JR	Z,TERMDRV	;no - get next drive
;
;*=*=* Display Line of equal signs "=" *=*=*
;
	LD	B,79		;output 79 "="
D79EQ	LD	A,'='		;
	CALL	BYTOUT		;output "="
	DJNZ	D79EQ		;
;
;*=*=* End line & check for scroll *=*=*
;
	LD	A,CR		;end line with C/R
	CALL	BYTOUT		;
	CALL	CKPAGE		;
;
;*=*=* Stuff # of files used into footer string *=*=*
;
	PUSH	BC		;Save Drive #
	LD	DE,FDISP	;DE => Destination
	LD	A,' '		;Stuff # of files
	CALL	CVD100		; used in string.
;
;*=*=* Pick up # of used files & stuff in string *=*=*
;
TFILES	LD	HL,$-$		;p/u total files used
	LD	DE,FUSED	;DE => Destination
	LD	A,' '		;
	CALL	CVD100		;stuff in string
;
;*=*=* P/u Total # of Grans & stuff into string *=*=*
;
TOTGRNS	LD	DE,$-$		;p/u total # of Grans
	LD	HL,SPUSED	;HL => Destination
	CALL	CALCK		;stuff into string
	POP	BC		;C = drive #
;
;*=*=* Display Footer String *=*=*
;
	LD	HL,FSTRING	;HL => Files disp string
	CALL	LINOUT		;display line
	CALL	CKPAGE		;check for title
	JR	TERMDRV		;get next drive
;
;*=*=* A parm not spec'd, was a header displayed ? *=*=*
;
NOTAP	LD	A,(FILFLAG)	;Was a header displayed ?
	OR	A		;
	JR	NZ,TERMDRV	;no - get next drive
;
;*=*=* Output a C/R if a full line wasn't displayed *=*=*
;
	LD	A,(DONAM9+1)	;Full line ?
	CP	4		;
	CALL	NZ,ENDLINE	;End line
	CALL	ENDLINE		;Do a blank line
;
;*=*=* Position to next drive - or exit if finished *=*=*
;
TERMDRV	LD	A,$-$		;p/u term drive
	INC	C		;bump current drive #
	CP	C		;done ?
	JP	NC,DIR4		;loop if in range
	JP	EXIT		;Exit if NZ
;
;*=*=* Get next drive unless drivespec specified *=*=*
;
CKHIT4	POP	BC		;get drive # in C
SPECIF	LD	A,$-$		;p/u specific flag
	OR	A		;
	LD	HL,0		;Init in case exit
	RET	Z		;not global
;
;*=*=* Bump Drive number *=*=*
;
	LD	A,(TERMDRV+1)	;p/u term drive #
	INC	C		;bump
	CP	C		;finished ?
	JP	NC,DIR4		;loop til 8
	RET			;else return
;
;*=*=* Is the HIT entry in use ? *=*=*
;
CKHIT5	LD	A,(HL)		;p/u HIT entry
	OR	A		;in use ?
	JP	Z,CKHIT2	;no - get next entry
;
;*=*=* HIT entry in use - Point HL to that entry *=*=*
;
	LD	B,L		;save DEC in B
	PUSH	BC		; & to stack
	LD	A,L		;point L to Entry posn
	AND	0E0H		;
	LD	L,A		;
;
;*=*=* Do we need to Read in another sector ? *=*=*
;
	XOR	B		;Done with 8 entries ?
CKHIT6	CP	0FFH		;
	JR	Z,CKDIR1	;no - check out entry
;
;*=*=* Read in the next directory sector *=*=*
;
	LD	(CKHIT6+1),A	;stuff in last entry posn
	@@DIRRD			;& read it into buffer
	JP	NZ,IOERR	;jump on read error
	LD	A,H		;p/u high byte
	LD	(CKDIR1+1),A	;and save
	LD	(SBUFFER+1),A	;for later
;
;*=*=* Valid File (Alive & FPDE) ? *=*=*
;
CKDIR1	LD	H,$-$		;p/u high byte
	BIT	4,(HL)		;Alive ?
	JP	Z,CKHIT1	;no - get next entry
	BIT	7,(HL)		;FPDE ?
	JP	NZ,CKHIT1	;no - get next entry
;
;*=*=* Alive FPDE - Bump Total File counter *=*=*
;
	PUSH	HL		;Save ptr
	LD	HL,(TFILES+1)	;HL => Total Files
	INC	HL		;bump total files
	LD	(TFILES+1),HL	;
	POP	HL		;
;
;*=*=* Is this a SYStem File ? *=*=*
;
	BIT	6,(HL)		;SYS file ?
	JR	Z,CKDIR3	;no - continue
;
;*=*=* SYS file - don't check unless S parm entered *=*=*
;
SPARM	LD	DE,$-$		;p/u S-parm
	LD	A,D		;specified ?
	OR	E		;
	JP	Z,CKHIT1	;no - don't check it
	JR	CKMOD		;skip INV check
;
;*=*=* Non-SYS file - Is the file Visible ? *=*=*
;
CKDIR3	BIT	3,(HL)		;Visible ?
	JR	Z,CKMOD		;yes - skip I check
;
;*=*=* File is invisible - was INV (I) specified ? *=*=*
;
IPARM	LD	DE,$-$		;I-parm
	LD	A,D		;ignore if I-parm not
	OR	E		;  entered as this file
	JP	Z,CKHIT1	;  is invisible
;
;*=*=* Was the MOD parm entered ? *=*=*
;
CKMOD	LD	DE,$-$		;p/u mod parm
	LD	A,D		;Was it entered ?
	OR	E		;
	JR	Z,CKNAM		;Go if MOD not entered
;
;*=*=* MOD parm entered - was this file modified ? *=*=*
;
	INC	L		;HL => DIR + 1
	BIT	6,(HL)		;Was the file modified ?
	JP	Z,CKHIT1	;no - get next entry
	DEC	L		;Adjust back to start
;
;*=*=* Attributes match - check if filespec matches *=*=*
;
CKNAM	PUSH	HL		;save ptr to record
	LD	A,L		;pt to filename in dir
	ADD	A,5
	LD	L,A		;HL => DIR filename
	LD	DE,BLANKS	;DE => Partspec input
	LD	B,11		;ck name/ext (11-chars)
;
;*=*=* Loop to check if partspec matches dir name *=*=*
;
CKNAM1	LD	A,(DE)		;p/u partspec
	CP	'$'		;wild char?
	JR	Z,CKNAM2	;yes - match
;
;*=*=* Does Directory char match partspec char ? *=*=*
;
	CP	(HL)		;not global, char match?
	JR	Z,CKNAM2	;ck more if match
;
;*=*=* Chars don't match - Dir char a space ? *=*=*
;
	CP	' '		;blank = end of ck
	JR	NZ,MFLG		;if not blank, no match
;
;*=*=* Bump Dir ptr & Partspec ptr & continue loop *=*=*
;
CKNAM2	INC	HL		;bump pointers
	INC	DE
	DJNZ	CKNAM1		;loop for 11 chars
;
;*=*=* Entries Match - Was the "-" Exclude given ? *=*=*
;
	LD	A,(MFLG+1)	;p/u flag
	CP	'-'		; - exclude given ?
	JR	CK2HIT		;yes - get next entry
;
;*=*=* Entries Don't match - Was exclude given ? *=*=*
;
MFLG	LD	A,$-$		;p/u Exclude flag
	OR	A		; no exclude given
CK2HIT	JP	Z,CKHIT		;get next entry
;
;*=*=* Recover DIR+0 pointer *=*=*
;
CKNAM2A	POP	HL		;Rcvr ptr to DIR+0
	PUSH	HL		;save
;
;*=*=* Unpack Date of Directory entry *=*=*
;
	INC	HL		;HL => DIR+1
	CALL	UNPACK		;Unpack date
;
;*=*=* Use Dates before user-specified date ? *=*=*
;
	LD	A,(FTFLG)	;p/u From/To flag
	RLCA			;tst fm bit
	JR	NC,CKNAM2B	;no - check to
;
;*=*=* "FROM" flag set - does file have a date ? *=*=*
;
	LD	A,D		;Ignore if no date
	OR	E		; in DIR for file
	JP	Z,CKHIT		;no date - get next entry
;
;*=*=* Is the Specified date >= the file's date ? *=*=*
;
	LD	HL,(FMPAKD)	;P/u user date entry
	EX	DE,HL		;
	CALL	CPHLDE		;Compare HL to DE
	EX	DE,HL		;File date < User date ?
	JR	C,$JP1		;yes - get next entry
;
;*=*=* Use Dates after user-specified Date ? *=*=*
;
CKNAM2B	LD	A,(FTFLG)	;P/u FROM/TO flag
	RRCA			;Test TO bit
	JR	NC,SORTPRM	;Go if no TOPARM
;
;*=*=* "TO" Flag set - Does file have a date ? *=*=*
;
	LD	A,D		;file have a valid date ?
	OR	E		;
	JP	Z,CKHIT		;no - get next entry
;
;*=*=* File has a date - Is spec'd date less ? *=*=*
;
	LD	HL,(TOPAKD)	;P/u user's packed date
	CALL	CPHLDE		;User date < File date ?
$JP1	JP	C,CKHIT		;yes - get next entry
;
;*=*=* Was the Sort Parameter turned off ? *=*=*
;
SORTPRM	LD	DE,-1		;P/u default parm
	POP	HL		;HL => DIR+0
	LD	A,D		;Default to SORT=ON
	OR	E		;
	JR	Z,DODSP		;Go display if no sort
;
;*=*=* SORT = ON --- Calculate allocation & extents *=*=*
;
	PUSH	HL		;Save DIR + 0 ptr
	CALL	ALL09A		;Calc alloc & extents
	POP	HL		;recover DIR+0 ptr
;
;*=*=* Overwrite FPDE's 22-25 with # Grans & # exts *=*=*
;
	PUSH	HL		;Point IX = DIR+22
	POP	IX		;
	LD	(IX+22),E	;Stuff in # Grans
	LD	(IX+23),D	;
	LD	(IX+24),C	;Stuff in # Extents
	LD	(IX+25),B	;
;
;*=*=* Transfer Record into Memory For Sort *=*=*
;
	LD	DE,(DIRPTR)	;p/u last used mem addr
	PUSH	HL		;save current DIR ptr
	LD	BC,32		;Move record to buffer
	LDIR			;xfer
	LD	(DIRPTR),DE	;Update the pointer
;
;*=*=* Is there an overflow of available memory ? *=*=*
;
	LD	HL,(MAXMEM)	;p/u approximate hi-mem
	SBC	HL,DE		;did it overflow ?
	JP	NC,CKHIT	;no - get next entry
	JP	NOMEM		;Insuf mem for sort buff
;
;*=*=* Display A Filename *=*=*
;
DODSP	CALL	MATCH		;Display Entry
	JP	CKHIT1		;Loop to next DIR entry
;
;
