;LBDEVICE/ASM - DEVICE Command - 10/31/83
	TITLE	<DEVICE - LDOS 6.2>
;*=*=*
;	Change Log
;
; 10/06/83 - Added Smooth to 'OPTIONS' table
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
; 10/27/83 - Removed unnecessary break handling code &
;          - changed code to use @CKBRKC SVC. DK
; 10/31/83 - Changed some label names & changed RESKFL
;	   - so as not to reset <BREAK> bit. DK
;
;*=*=*
LF	EQU	10
CR	EQU	13
*GET	SVCMAC:3
	ORG	2400H
;
DEVICE
	@@CKBRKC		;Check for break
	JR	Z,DEVICEA	; go if not
	LD	HL,-1		; else abort
	RET
;
DEVICEA	LD	(SAVESP+1),SP	;Save stack pointer
	LD	DE,PRMTBL$
	@@PARAM
	JP	NZ,IOERR	;Go if parm error
	@@FLAGS			;Get flag table pointer
	CALL	RESKFL
	EI			;Make sure they're on
DPARM	LD	HL,-1		;Init drives to on
	LD	A,H
	OR	L
	JP	Z,DEND
	LD	C,0		;init to drive 0
DEV1	PUSH	BC		;save drive #
	XOR	A		;Reset flag stuff
	LD	(WPTEST+1),A	;  location
	@@GTDCT			;get DCT address
	LD	A,(IY+0)	;Is this drive disabled?
	CP	0C3H
	JP	NZ,POPDRV	;ignore if it is
	@@CKDRV			;This drive available?
	JR	NZ,DEV2		;Go if no diskette
	RRA			;Shift C-flag to bit-7
	LD	(WPTEST+1),A	;  & save for WP test
	LD	HL,BUFFER	;Pick up the GAT for the
	LD	D,(IY+9)	;  pack name
	LD	E,L
	@@RDSSC
	LD	A,20		;"GAT read error
	JP	NZ,IOERR
	LD	HL,BUFFER+0D8H	;Shove bracket ETX
	LD	(HL),']'
	INC	L
	LD	(HL),' '
	INC	L
	LD	(HL),3
	LD	L,0D0H		;Point to start of name
	JR	DEV2A
;*=*=*
;	drive info for this active drive
;*=*=*
DEV2	LD	HL,NOPACK$	;Display pack name
	LD	DE,BUFFER+0D0H
	LD	BC,12
	LDIR
DEV2A	LD	A,':'		;output the colon
	CALL	BYTOUT
	POP	BC
	PUSH	BC
	LD	A,C		;get drive # converted
	ADD	A,'0'		;  to ASCII & display it
	CALL	BYTOUT
	LD	A,' '		;space out one
	CALL	BYTOUT
WPTEST	LD	A,0		;P/u CKDRV FDC status
	RLCA			;Hardware write protect?
	JR	C,DEV2B		;Force "WP" if it is
	BIT	7,(IY+3)	;test software WP
	LD	A,' '		;Output '  ' for read &
	LD	B,' '		;  write access or
	JR	Z,$+6
DEV2B	LD	A,'W'		;  WP for read only
	LD	B,'P'
	CALL	BYTOUT
	LD	A,B		;Xfer the 2nd char
	CALL	BYTOUT		;  & display it
	LD	A,' '
	CALL	BYTOUT
	LD	A,'['		;Left bracket
	CALL	BYTOUT
	LD	HL,BUFFER+0D0H	;Write the pack name
	CALL	LINOUT
;*=*=*
;	Determine if 5" or 8"
;*=*=*
	BIT	5,(IY+3)	;test 5"/8" drive
	LD	A,'5'		;init to 5
	JR	Z,$+4		;bypass if not 8
	LD	A,'8'		;  else init to 8
	CALL	BYTOUT
	BIT	3,(IY+3)	;test rigid/floppy
	LD	HL,FLOPY$	;init to floppy
	JR	Z,$+5		;bypass if that kind
	LD	HL,RIGID$	;  else is hard
	CALL	LINOUT
	LD	A,(IY+4)	;output drive select addr
	AND	0FH		;  in ASCII
	ADD	A,90H
	DAA
	ADC	A,40H
	DAA
	CALL	BYTOUT
DEV3	LD	L,(IY+6)	;p/u highest cylinder
	LD	H,0
	INC	HL		;adjust for zero offset
	BIT	3,(IY+3)	;hard drive?
	JR	Z,DEV4		;bypass if soft
	BIT	5,(IY+4)	;2-sided hard drives
	JR	Z,DEV4		;  are 2*cyl
	ADD	HL,HL		;  & multiply by 2
DEV4	LD	DE,COMMA$	;convert # of cyls to
	CALL	CVRTDEC		;  decimal & stuff in msg
	LD	HL,CYLS$	;display cyls=xxx
	CALL	LINOUT
	BIT	3,(IY+3)	;bypass if soft drive
	JR	Z,FLOPPY
	BIT	2,(IY+3)	;test fixed/removable
	LD	HL,REMOV$	;init to removable
	JR	Z,$+5		;bypass if that way
	LD	HL,FIXED$	;  else init fixed
	CALL	LINOUT
	JR	ENDLINE		;bypass DEN, STEP, DLY
;*****
;	next section deals only with floppies
;*****
FLOPPY	BIT	6,(IY+3)	;test SDEN/DDEN
	LD	A,'S'		;init to sden
	JR	Z,$+4		;bypass if sden
	LD	A,'D'		;  else init to dden
	CALL	BYTOUT
	LD	HL,DEN$		;now display "den"
	CALL	LINOUT
	BIT	5,(IY+4)	;test # of sides
	LD	A,'1'		;init to 1
	JR	Z,$+3		;bypass if single sided
	INC	A		;  else bump to 2
	CALL	BYTOUT
	LD	HL,STEP$	;display "step="
	CALL	LINOUT
	LD	A,(IY+3)	;p/u step rate & 8/5
	AND	23H		;convert step rate to an
	LD	B,A		;  index into the table
	RRCA
	RRCA
	RRCA
	OR	B
	RLCA
	AND	0EH
	LD	HL,STPRAT$
	ADD	A,L		;add table lo order
	LD	L,A		;set lo-order
	ADC	A,H
	SUB	L
	LD	H,A
	LD	A,(HL)		;p/u 1st step char
	INC	HL		;bump to second
	CALL	BYTOUT		;display the first
	LD	A,(HL)		;p/u the second
	CALL	BYTOUT		;display the second
	LD	HL,MS$		;display "ms,"
	CALL	LINOUT
	BIT	5,(IY+3)	;bypass DELAY if 8"
	JR	NZ,ENDLINE	;8" drives always running
	LD	HL,DLY$		;display "dly="
	CALL	LINOUT
	BIT	2,(IY+3)	;test off/on
	LD	A,' '		;1 sec if DELAY=ON
	LD	B,'1'
	JR	Z,$+6
	LD	A,'.'		;0.5 sec if DELAY=OFF
	LD	B,'5'
	CALL	BYTOUT
	LD	A,B
	CALL	BYTOUT
	LD	A,'s'		;indicate seconds
	CALL	BYTOUT
ENDLINE	CALL	CKPAWS
POPDRV	POP	BC		;recover drive #
	INC	C		;bump to next drive
	LD	A,C
	CP	8		;loop thru all 8
	JP	NZ,DEV1
DEND	EQU	$
;*=*=*
;	Byte I/O devices
;*=*=*
BPARM	LD	HL,$-$		;Init to display
	LD	A,H
	OR	L
	JP	Z,BEND
;*****
;	display the device vectoring
;*****
	LD	DE,'IK'		;start of device tables
	@@GTDCB
	JP	NZ,IOERR
LOGDCB	LD	A,(HL)		;bypass this device if
	OR	A		;  table shows spare
	JP	Z,DVRB2
	LD	DE,STRBUF	;pt to string buffer
	PUSH	HL		;save origin ptr
	CALL	MOVNAM		;move dev name -> strbuf
	POP	HL		;rcvr org of table
	PUSH	HL
LOGDCB1	BIT	3,(HL)		;If NIL, don't show
	JR	NZ,DVRADDR	;  any routes
	BIT	4,(HL)		;is device routed?
	JR	Z,DVRADDR	;bypass if not
;*****
;	this device is routed
;*****
LOGRTE	INC	L		;pt to vector & get it
	LD	A,(HL)
	INC	L
	LD	H,(HL)
	LD	L,A
	BIT	7,(HL)		;is the route to a file?
	JP	NZ,RTEFCB	;jump if a file
	PUSH	HL		;hang onto this vector
	CALL	DCBDIR		;get device direction
	CALL	MOVNAM		;move dev name -> strbuf
	POP	HL		;rcvr org of routee
	BIT	4,(HL)		;is routee also routed?
	JR	NZ,LOGRTE	;loop de loop if yes
	JR	DVRB1		;else go display the line
;*****
;	device has no routes - show its driver address
;*****
DVRADDR	CALL	DCBDIR		;get device direction
	BIT	3,(HL)		;is this a NIL device
	JP	NZ,MOVNIL	;no address if NIL
;*=*=*
;	If linked, show device name of link
;*=*=*
	BIT	5,(HL)		;Any link DCB?
	JR	Z,DVRA0		;Go if none
	INC	L		;Get address of link DCB
	LD	A,(HL)
	INC	L
	LD	H,(HL)
	LD	L,A
;*=*=*
;	Now move in the name of the linked DCB
;*=*=*
	PUSH	HL
	PUSH	HL
	CALL	MOVNAM		;Move name of LINK DCB
	LD	A,'|'
	LD	(DE),A
	INC	DE
	POP	IY
	LD	L,(IY+4)	;P/u linked DCB address
	LD	H,(IY+5)
	CALL	MOVNAM		;Move name of linked DCB
	POP	HL
	EX	DE,HL
	LD	(HL),' '
	INC	HL
	LD	(HL),'&'	;Show the link
	INC	HL
	EX	DE,HL
	JR	LOGDCB1		;Go ck this one
;*=*=*
;	If filtered, find the filter DCB
;*=*=*
DVRA0	BIT	6,(HL)		;If filtered, recover the
	JR	Z,DVRB0		;  original data by
	PUSH	HL		;  swapping back the
	LD	A,'['
	LD	(DE),A
	INC	DE
	PUSH	DE
	LD	D,H
	LD	E,L
	INC	L		;  1st three bytes with
	LD	A,(HL)		;  the FILTER DCB
	INC	L
	LD	H,(HL)
	LD	L,A
	LD	BC,4		;HL now points to the
	ADD	HL,BC		;  entry point. Get its
	LD	C,(HL)		;  DCB address by peeking
	INC	C		;  past the name field
	ADD	HL,BC
	LD	A,(HL)		;Get low-order
	INC	HL
	LD	H,(HL)		;Get hi-order
	LD	L,A
	PUSH	HL		;If DCB is itself, then
	SBC	HL,DE		;  bring in the "inactive
	POP	HL
	POP	DE		;Recover string buf ptr
	JR	NZ,DVRA1
	LD	HL,INACT$
	LD	BC,8
	LDIR
	JR	DVRA2
DVRA1	CALL	MOVNAM		;Move name of filter DCB
DVRA2	LD	A,']'
	LD	(DE),A
	INC	DE
	LD	A,' '
	LD	(DE),A
	INC	DE
	POP	HL		;Recover orig DCB ptr
;*=*=*
;	Routine to construct address "X'xxxx'"
;*=*=*
DVRB0	LD	A,'X'		;show address as
	LD	(DE),A		;  X'dddd'
	INC	DE
	LD	A,27H		;single quote
	LD	(DE),A
	INC	DE
	INC	L
	LD	A,(HL)		;p/u lo-order vector
	INC	L
	LD	H,(HL)		;p/u hi-order vector
	LD	L,A		;put lo in place
	EX	DE,HL		;vector value to DE
	@@HEX16			;convert to hex digits
	EX	DE,HL		;restore strbuf ptr to DE
	LD	A,27H		;closing '
	LD	(DE),A
	INC	DE
DVRB1	LD	A,CR
	LD	(DE),A		;stuff end-of-line
	LD	HL,STRBUF	;display the info
	CALL	LINOUT
	CALL	CKPAWS0		;Ck with no CR
	POP	HL		;rcvr table org
DVRB2	LD	A,L		;advance to next table
TABLEN	ADD	A,8
	LD	L,A
	JP	C,SPARM		;Exit if fin
	JP	LOGDCB		;tables & then loop
;*****
;	device routes to a file - grab its filespec
;*****
RTEFCB	PUSH	HL		;save control block org
	LD	HL,IO$		;show 2-way device
	LD	BC,5
	LDIR
	POP	HL
	LD	A,L		;pt to file route data
	ADD	A,6
	LD	L,A
	ADC	A,H
	SUB	L
	LD	H,A
	LD	C,(HL)		;p/u drive #
	INC	HL
	LD	B,(HL)		;p/u DEC
	PUSH	DE
	@@FNAME			;fetch filename
	POP	DE
	JP	NZ,IOERR
RTEF1	LD	A,(DE)		;find end of filename
	CP	3
	JR	Z,DVRB1		;exit on ETX to put CR
	INC	DE
	JR	RTEF1
;*=*=*
;	Move in 'NIL' as driver address
;*=*=*
MOVNIL	LD	HL,NIL$		;move in NIL
	LD	BC,3
	LDIR
	JR	DVRB1
;*****
;	routine to denote i/o direction
;*****
DCBDIR	LD	A,' '		;1st need a space
	LD	(DE),A
	INC	DE
	BIT	0,(HL)		;test if input device
	JR	Z,DCBD1		;put another space if not
	LD	A,'<'		;else show input capable
DCBD1	LD	(DE),A
	INC	DE
	LD	A,'='		;always need this
	BIT	6,(HL)		;If a filter, then
	JR	Z,$+4		;  reset to '#'
	LD	A,'#'
	LD	(DE),A
	INC	DE
	LD	A,' '		;init a space
	BIT	1,(HL)		;output device?
	JR	Z,DCBD2		;use space if not
	LD	A,'>'		;else show output capable
DCBD2	LD	(DE),A
	INC	DE
	LD	A,' '		;close with a space
	LD	(DE),A
	INC	DE
	RET
;*****
;	convert HL to 3-place decimal & stuff into (DE)
;*****
CVRTDEC	PUSH	DE		;Save place
	LD	DE,BUFFER
	@@HEXDEC
	LD	HL,BUFFER+2
	POP	DE
	LD	BC,3
	LDIR
	RET
;*****
;	move device name into string buffer
;*****
MOVNAM	LD	A,L		;pt to name field
	ADD	A,6
	LD	L,A
	LD	A,'*'		;stuff * in string buf
	LD	(DE),A
	INC	DE		;bump ptr to next pos
	LD	A,(HL)		;p/u 1st char of name
	LD	(DE),A		;  & stuff it
	INC	DE		;do the same for char 2
	INC	L
	LD	A,(HL)
	LD	(DE),A
	INC	DE
	RET
BEND	EQU	$
;*=*=*
;	Show high memory device drivers
;*=*=*
SPARM	LD	HL,-1
	LD	A,H
	OR	L
	JP	Z,EXIT		;Exit if through
	LD	HL,DVCHDR$	;Display header
	CALL	LINOUT
	@@FLAGS			;Get flag table pointer
	LD	A,(IY+'D'-'A')	;p/u flag
	OR	A		;Exit if none in use
	PUSH	AF		;Save flag
	JR	Z,SHOWFS	;Go if nothing on
	LD	HL,DVCS$	;Pt to word string
	LD	BC,8<8!0FFH	;init for 8 flag bits
DOD1	POP	AF		;rcvr link
	RRCA			;Test if active
	PUSH	AF
	JR	NC,DOD3		;bypass if inactive
	INC	C		;Do we do the comma?
	LD	A,','		;End of word, do comma
	CALL	NZ,BYTOUT
	LD	A,' '		;Start with a space
	CALL	BYTOUT
DOD2	LD	A,(HL)		;Display word until carry
	INC	HL
	PUSH	AF
	AND	7FH		;Strip possible carry
	CALL	BYTOUT		;Display the char
	POP	AF
	RLCA			;Was carry set
	JR	NC,DOD2		;Loop if not
	DJNZ	DOD1		;Loop for 8 bits
	JR	SHOWFS		;Exit the loop
DOD3	LD	A,(HL)		;loop & ignore word
	INC	HL
	RLCA			;Carry set on last char
	JR	NC,DOD3
	DJNZ	DOD1		;Loop for 8 bits
SHOWFS	BIT	3,(IY+'S'-'A')	;Show FAST or SLOW
	JR	NZ,FAST
	LD	HL,SLOW$	;point to slow$
	JR	SHOWIT
FAST	LD	HL,FAST$	;point to fast$
SHOWIT	LD	A,(IY+'D'-'A')	;Check is others shown
	OR	A
	JR	NZ,COMAOK
	INC	HL		;By pass coma
COMAOK	CALL	LINOUT
;*=*=*
;	Display system modules resident
;*=*=*
DORES	POP	AF		;stack integrity
NOTON	CALL	CKPAWS
	LD	DE,RES$		;Check if driver resident
	@@GTMOD			; in memory
	JP	NZ,EXIT
	LD	HL,5
	ADD	HL,DE		;Point to hi-order table
	PUSH	HL
	LD	HL,SYSRES$	;Display header
	CALL	LINOUT
	POP	HL
	LD	BC,16<8!0FFH	;Init for 16 modules
DORES1	LD	A,(HL)		;P/u a high-order vector
	INC	HL		;Bump pointer to next
	INC	HL
	OR	A		;Is this module resident?
	JR	Z,DORES3	;Go if not
	INC	C
	LD	A,','		;Need comma if 2nd
	CALL	NZ,BYTOUT
	LD	A,' '		;Start with a space
	CALL	BYTOUT
	LD	A,16
	SUB	B		;Calculate module #
	LD	D,-1
DORES2	INC	D
	SUB	10
	JR	NC,DORES2
	PUSH	AF		;Save units place
	LD	A,D		;Test tens place
	ADD	A,'0'		;  for non-zero
	CP	'0'
	CALL	NZ,BYTOUT	;Output if non-zero
	POP	AF		;Get units
	ADD	A,'0'+10	;Adjust to ASCII
	CALL	BYTOUT
DORES3	DJNZ	DORES1
	CALL	CKPAWS		;One last ck for CR
	JR	EXIT
;*****
;	output display routines
;*****
LINOUT	@@DSPLY
	JR	NZ,IOERR
	LD	A,(PPARM+1)	;ck P-parm
	OR	A
	RET	Z
	@@PRINT			;also print if needed
	JR	NZ,IOERR
	RET
BYTOUT	PUSH	BC
	LD	C,A
	@@DSP			;display it
	JR	NZ,POPBC
PPARM	LD	DE,0		;p/u P-parm
	LD	A,E
	OR	D
	JR	Z,POPBC
	@@PRT			;print chr if needed
POPBC	POP	BC
	RET	Z
IOERR	LD	L,A		;Save error code
	LD	H,0
	OR	0C0H		;Abbrev & return
	LD	C,A
	@@ERROR
	JR	SAVESP
;*****
;	routine to ck on pause or break
;*****
CKPAWS	LD	A,CR		;end line first
	CALL	BYTOUT
CKPAWS0	@@FLAGS			;Get flag table pointer
	LD	A,(IY+'K'-'A')
	BIT	0,A		;check for break
	JR	NZ,BREAK	; if so exit
	BIT	1,A		;check for pause
	RET	Z		;Ret if not
CKPAW1	@@KEY			;Wait for key input
	CP	60H
	JR	Z,CKPAW1	;Loop on pause
	CP	80H		;Abort on BREAK
	JR	Z,BREAK
RESKFL	LD	A,(IY+'K'-'A')	;Reset Pause & Enter bits
	AND	0F9H		;
	LD	(IY+'K'-'A'),A
	RET
;*=*=*
;	BREAK handler routine
;*=*=*
BREAK	CALL	RESKFL
	LD	HL,-1
SAVESP	LD	SP,$-$		;Restore the stack
	@@CKBRKC		;clear any <BREAK>
	RET			;and RETurn
EXIT	LD	HL,0
	JR	SAVESP		;p/u stack & return
;*****
;	string area
;*****
NOPACK$	DB	'No  Disk] ',3
INACT$	DB	'Inactive'
DVCHDR$	DB	LF,'Options:',3
DVCS$	DB	'Spoole','r'!80H,'Typ','e'!80H
	DB	'Verif','y'!80H,'Smoot','h'!80H
	DB	'Memdis','k'!80H,'Form','s'!80H
	DB	'KS','M'!80H,'Graphi','c'!80H
FAST$	DB	', Fast',3
SLOW$	DB	', Slow',3
RES$	DB	'SYSRES',3
SYSRES$	DB	'System modules resident:',3
STPRAT$	DB	' 6122030 3 61015'
FLOPY$	DB	'" Floppy #',3
RIGID$	DB	'" Rigid  #',3
CYLS$	DB	', Cyls='
COMMA$	DB	'   , ',3
REMOV$	DB	'Removable',3
FIXED$	DB	'Fixed',3
DEN$	DB	'den, Sides=',3
STEP$	DB	', Step=',3
MS$	DB	'ms',3
DLY$	DB	', Dly=',3
NIL$	DB	'Nil'
IO$	DB	' <=> '
PRMTBL$	EQU	$
VAL	EQU	80H
SW	EQU	40H
STR	EQU	20H
SGL	EQU	10H
	DB	80H
	DB	SW!SGL!6,'BYTEIO',0
	DW	BPARM+1
	DB	SW!SGL!6,'DRIVES',0
	DW	DPARM+1
	DB	SW!SGL!5,'PRINT',0
	DW	PPARM+1
	DB	SW!SGL!6,'STATUS',0
	DW	SPARM+1
	DB	SW!SGL!6,'OPTION',0
	DW	SPARM+1
	NOP
	ORG	$<-8+1<8
BUFFER	DS	256
STRBUF	EQU	$
	END	DEVICE
