;LBDEBUG/ASM - DEBUG VERIFY Commands - 10/21/83
;		14  1B
	TITLE	<DEBUG/VERIFY - LDOS 6.2>
;*=*=*
;	Change Log
; 04/12/83 - Added force of SPACE COMP during DEBUG (ON)
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
;*=*=*
CR	EQU	13
*GET	SVCMAC:3
*LIST	OFF
*GET	SYS0/EQU:2
*LIST	ON
	ORG	2400H
	JP	VERIFY
;*=*=*
;	Debug entry
;*=*=*
DEBUG	LD	DE,PRM1TBL	;Pt to y/n on/off parms
	@@PARAM			;get parameters
	JP	NZ,IOERR	;jump on parm error
	CALL	NPARM		;Ck on yes or no entry
	JR	Z,DBG2
	LD	A,(EPARM)	;Ck on extended DEBUG
	OR	A		;  requested
	JR	Z,DBG0
	BIT	0,(IY+'C'-'A')	;Can't put extended DEBUG
	JP	NZ,CANT		;  if himem not available
	CALL	DBG3		;call if EXT entered
DBG0	SET	7,(IY+'S'-'A')	;turn on DEBUG flag
	LD	D,8		;Set to mask bit 3
	CALL	GET$DO
DBG0A	XOR	A		;  & enable DEBUG
DBG1	LD	(@DBGHK),A
EXIT	LD	HL,0		;Set no error
	RET
DBG2	RES	7,(IY+'S'-'A')	;turn off DEBUG flag
	LD	D,80H		;Set to mask bit 7
	CALL	GET$DO
DBG2A	LD	A,(EPARM)	;Ck on extended DEBUG
	OR	A		;  requested
	JR	Z,DBG4
;*=*=*
;	User requested we remove extended DEBUG
;*=*=*
	BIT	0,(IY+'C'-'A')	;Can we alter HIGH$?
	JR	NZ,DBG4
	LD	DE,(EXTDBG$)	;Is extended resident?
	LD	HL,-ORARET@	;Ck if vector same as
	ADC	HL,DE		;  the default
	JR	Z,DBG4		;Go if not resident
	LD	HL,0		;Set to get HIGH$
	LD	B,L
	@@HIGH$			;P/u current pointer
	INC	HL		;Point to assumed module
	XOR	A		;  & check if extended
	SBC	HL,DE		;  debugger is lowest
	JR	NZ,DBG4		;Can't release if not
	INC	DE		;Point to last byte used
	INC	DE
	EX	DE,HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL		;New high to HL
	@@HIGH$			;Reset high$
	LD	HL,ORARET@	;Reset extended debugger
	LD	(EXTDBG$),HL	;  vector to default
DBG4	LD	A,0C9H		;turn off DEBUG vector
	JR	DBG1
EPARM	DW	0
DBG3	LD	A,9BH		;get SYS9 loaded & up
	RST	28H
;*=*=*
;	Verify entry
;*=*=*
VERIFY	LD	DE,PRM2TBL	;pt to ext + above
	@@PARAM
	JR	NZ,IOERR
	CALL	NPARM		;Ck yes/no
	LD	HL,@WRITE	;init to vector WRITE
	RES	2,(IY+'D'-'A')	;Indicate VERIFY=OFF
	JR	Z,VER1		;use WRITE if VER=(OFF)
	LD	HL,@VER		;init to vector VERIFY
	SET	2,(IY+'D'-'A')	;Indicate VERIFY=ON
VER1	LD	(75*2+SVCTAB$),HL ;change SVCTAB vector
	JR	EXIT
;*=*=*
;	Routine to save or restore SPACE COMPRESSION state
;*=*=*
GET$DO	PUSH	DE		;Save mask value
	LD	DE,$DO$
	@@GTMOD
	LD	HL,4		;Point to 1st data byte
	ADD	HL,DE
	POP	DE		;Rcvr mask value
	RET	NZ		;Return if not found
	LD	A,(HL)		;P/u existing state
	AND	D		;Strip state of space comp
	RLCA			;  & move to bit 7 or 3
	RLCA
	RLCA
	RLCA
	LD	E,A		;Tempy save
	LD	A,(HL)
	AND	77H		;Strip bits 3 and 7
	OR	E		;Merge comp state
	LD	(HL),A
	RET
$DO$	DB	'$DO',3
;*=*=*
;	parameter parsing of yes/no
;*=*=*
NPARM	LD	BC,0		;P/u "no" parm entry
	@@FLAGS			;Point to flag table
	LD	A,B
	OR	C		;if NO, make Z
	XOR	0FFH
	RET
YPARM	DW	0
;*=*=*
;	I/O Error Processing
;*=*=*
;
IOERR	LD	L,A		;Set HL = error code
	LD	H,0		;
	OR	0C0H		;short error
	LD	C,A		;xfer error # to C
	@@ERROR			;display error
	RET			;return to DOS
;*=*=*
;	Error exits
;*=*=*
CANT	LD	HL,CANT$
	@@LOGOT
	LD	HL,-1
	RET
CANT$	DB	'No memory space available',CR
PRM1TBL	DB	'EXT   '
	DW	EPARM
	DB	'E     '
	DW	EPARM
PRM2TBL	DB	'ON    '
	DW	YPARM
	DB	'OFF   '
	DW	NPARM+1
	DB	'Y     '
	DW	YPARM
	DB	'N     '
	DW	NPARM+1
	NOP
	END	DEBUG
