;LBDATE/ASM - Date/Time - 10/31/83
	TITLE	<DATE/TIME - LDOS 6.2>
;*=*=*
;	Change Log
;
; 01/07/83 - Changed Error message to "Illegal Date/Time"
; 02/07/83 - Made uniform - RS
; 05/04/83 - Added International Date Conditional Block
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
; 10/27/83 - Rewrote & recommented Model II clock on/off
;	   - code. DK
; 10/31/83 - Added sub-titles. DK
;
;*=*=*
;
*GET SVCMAC:3
*GET LDOS60/EQU:2
;
;*=*=* ASCII character symbols *=*=*
;
ETX	EQU	3
BS	EQU	8
TAB	EQU	9
LF	EQU	10
CR	EQU	13
BREAK	EQU	80H
AP	EQU	39
@ADTSK	EQU	29		;Add Task SVC #
@RMTSK	EQU	30		;Remove Task SVC #
CLK_SLT	EQU	5		;Clock Task Slot #
;
;*=*=* @PARAM select bit values *=*=*
;
NUM	EQU	10000000B	;Numeric Input
FLAG	EQU	01000000B	;Flag/Switch Input
STR	EQU	00100000B	;String Input
ABB	EQU	00010000B	;Take 1st Letter Abbrev.
;*=*=*=*=*=*=*=*=*=*=*
;			DATE$ Storage
;
; DATE$+0			Year (80-87)
; DATE$+1			Day of the month (1-31)
; DATE$+2			Month (1-12)
; DATE$+4-5	Bits 0-8	Day of Year (1-366)
;		Bits 9-11	Day of week (1-7)
;		Bits 12-14	reserved
;		Bit  15		Leap Year Flag
;
;			TIME$ Storage
;
; TIME$+0			Seconds (0-59)
; TIME$+1			Minutes (0-59)
; TIME$+2			Hours (0-23)
;
;*=*=*=*=*=*=*=*=*=*=*
;
	ORG	2400H
;
;*=*=* Branch to TIME entry point *=*=*
;
	JP	TIME		;go do it
	SUBTTL '<LBDATE - DATE Code>'
;
;*=*=* DATE - Pick up DATE$+0 pointer & stuff in IY *=*=*
;
DATE	@@CKBRKC		;Break key down?
	JR	Z,BEGINA	;Ok if not
	LD	HL,-1		; else abort
	RET
;
BEGINA	PUSH	HL		;Save command ptr
	LD	HL,DUMBUF	;HL => Dummy Buffer
	@@DATE			;DE <= DATE$+0
	POP	HL		;recover command ptr
	PUSH	DE		;Xfer ptr to IY
	POP	IY		;
;
;*=*=* Was a Date entered on the command line ? *=*=*
;
	LD	A,(HL)		;p/u character
	CP	CR+1		;Date entry ?
	JP	C,DSPDATE	;no - display date
;
;*=*=* Date entered - check if legal format *=*=*
;
	LD	C,'0'		;init separator
	CALL	PARSDAT		;parse entry
	JP	NZ,BADFMT	;bad entry - abort
;
;*=*=* Legal Date - If Intl date - swap DTBUF+1 & 2 *=*=*
;
	IF	@INTL
	INC	DE		;DE => DTBUF+1
	LD	H,D		;HL => DTBUF+1
	LD	L,E		;
	LD	C,(HL)		;C = Intl MONTH
	INC	HL		;HL => DTBUF+2
	LD	A,(HL)		;A = Intl DAY
	LD	(DE),A		;Set DTBUF+1 = DAY
	LD	(HL),C		;Set DTBUF+2 = MONTH
	DEC	DE		;DE => DTBUF+0
	ELSE
	DC	9,0		;Same Size
	ENDIF
;
;*=*=* Is the year legal ? *=*=*
;
	LD	A,(DE)		;P/u year entry
	SUB	80		;Accept only 80-87
	JP	C,BADFMT	;less than 80 - bad
	CP	8		;greater than 87 ?
	JR	NC,BADFMT2	;yes - bad
;
;*=*=* If Year is 1980 or 84 then set FEB = 29 days *=*=*
;
	AND	3		;0 or 4 ?
	LD	HL,MAXDAYS+2	;Set Feb to have 29 days
	JR	NZ,NOTLEAP	;no - don't inc
	INC	(HL)		;leap year - inc max days
;
;*=*=* Check Range of month - must be 1 - 12 *=*=*
;
NOTLEAP	LD	A,(DTBUF+2)	;p/u month
	DEC	A		;set month = 0-11
	CP	12		;Valid Month ?
	JR	NC,BADFMT2	;abort if 0 or >12
;
;*=*=* Valid month - point HL to max days/month *=*=*
;
	DEC	HL		;HL => Max day table
	ADD	A,L		;Add month # to start
	LD	L,A		;HL => Max days for month
;
;*=*=* Check for Day entry is valid *=*=*
;
	LD	A,(DTBUF+1)	;p/u day entry
	DEC	A		;reduce for test (0->FF)
	CP	(HL)		;more than max days ?
BADFMT2	JP	NC,BADFMT	;Go if too large (or 0)
;
;*=*=* Transfer Date into buffer *=*=*
;
	EX	DE,HL		;Point HL to DTBUF
	PUSH	IY		;Point DE = DATE$
	POP	DE		;
	LD	C,3		;BC = 3 chars to xfer
	LDIR			;xfer 3 chars
;
;*=*=* Display "No Date in System" if illegal Date *=*=*
;
DSPDATE	LD	A,(IY+2)	;p/u month
	LD	HL,NODATE$	;"No Date in system"
	OR	A		;better no be zero
	JP	Z,LOGABRT	;log & abort
;
;*=*=* Create European Date string *=*=*
;
GOTDATE	LD	B,A		;xfer month to B
	LD	HL,MAXDAYS+2	;Adjust February if
	LD	A,(HL)		;  year is leap year
	SUB	29		;  & not already adjusted
	JR	Z,PUDAY		;  in parsing date entry
;
;*=*=* Pick up Year & increment max days if leap yr *=*=*
;
	LD	A,(IY)		;P/u year
	AND	3		;1980 and 1984 are lp yrs
	JR	NZ,PUDAY	;not leap year - fine
	INC	(HL)		;Bump to 29
;
;*=*=* Set HL = day # this month, DE => Max table *=*=*
;
PUDAY	LD	L,(IY+1)	;p/u day # this month
	LD	H,0		;stuff in HL
	LD	DE,MAXDAYS	;DE => Max day table
;
;*=*=* Loop to Count up total # of days up to now *=*=*
;
DAYLP	LD	A,(DE)		;p/u max day
	ADD	A,L		;
	LD	L,A		;
	ADC	A,H		;
	SUB	L		;
	LD	H,A		;
	INC	DE		;bump
	DJNZ	DAYLP		;B months of max days
;
;*=*=* Stuff year (9 bits) into DATE$ *=*=*
;
	LD	(IY+3),L	;stuff in lsb
	LD	A,H		;get bit "8"
	OR	(IY+4)		; and OR it in
	LD	(IY+4),A	;Then put it back
;
;*=*=* Pick up year in E (0-7) *=*=*
;
	LD	A,(IY)		;P/u year
	SUB	80		;offset from 80
	LD	E,A		;Put 0-7 in E
;
;*=*=* I don't know what this does *=*=*
;
	ADD	A,3		; offset
	RRCA
	RRCA
	AND	3
	ADD	A,E
	LD	E,A		;And add it in
	LD	D,0
	ADD	HL,DE
	INC	HL		;To start in right place
;
;*=*=* HL = desired number to divide by seven *=*=*
;
	LD	BC,7		;Now divide by 7
	XOR	A		;
DIV7	SBC	HL,BC		;subtract weeks (7-days)
	JR	NC,DIV7		;until under flow
;
;*=*=* Correct # for division, & put in bits 1-3 *=*=*
;
	LD	A,L		;p/u (8-day of year)
	ADD	A,8		;add back to get 1-7
	LD	B,A		;Save in reg B
	RLCA			;shift to bits 1-3
	LD	C,A		;save tempy
;
;*=*=* Merge day of week with bit 9 of day of year *=*=*
;
	LD	A,(IY+4)	;P/u DATE$ + 4
	AND	0F1H		;keep lp yr bit & bit 0
	OR	C		;merge day of week
	LD	(IY+4),A	;stuff back in
;
;*=*=* Transfer Day string into display buffer *=*=*
;
	LD	HL,DAYTBL	;HL => Day string table
	LD	DE,DATEBUF	;Date display buffer
	PUSH	DE		;save start
	CALL	DSPMDY		;write out the day
;
;*=*=* Position DE to month destination in buffer *=*=*
;
	INC	DE		;bump
	INC	DE		;
;
;*=*=* Pick up month, & stuff string into buffer *=*=*
;
	LD	A,(IY+2)	;P/u month number
	LD	B,A		;stuff in B
	LD	HL,MONTBL	;HL => Month string table
	CALL	DSPMDY		;Write out the month name
;
;*=*=* P/u day of the month & convert to ASCII *=*=*
;
	INC	DE		;DE => Day destination
	LD	A,(IY+1)	;p/u day
	LD	B,-1		;init # of tens to -1
;
;*=*=* Divide day of the month by 10 *=*=*
;
DIV10	INC	B		;Divide by 10
	SUB	10		; with quotient in B
	JR	NC,DIV10	;subtract until carry
;
;*=*=* Convert to tens digit to ASCII *=*=*
;
	PUSH	AF		;save (10-remainder)
	LD	A,B		;P/u quotient
	ADD	A,'0'		;Change to ASCII
;
;*=*=* Change to a space if it's a leading zero *=*=*
;
	CP	'0'		;Zero?
	JR	NZ,NOTLD0	;no - use it
	LD	A,' '		;Change leading 0 to ' '
NOTLD0	LD	(DE),A		;stuff in buffer
;
;*=*=* Convert remainder to ASCII & stuff in buffer *=*=*
;
	INC	DE		;DE => ones destination
	POP	AF		;Get back remainder
	ADD	A,3AH		;Change to ASCII
	LD	(DE),A		;stuff in buffer
;
;*=*=* P/u year & stuff lower digit + "0" in buffer *=*=*
;
	LD	A,(IY)		;Form last year digit
	SUB	80		;A = 0-7
	ADD	A,'0'		;convert to ASCII
	LD	(DATEBUF+16),A	;Stuff year
;
;*=*=* Set B = 0 (Normal Exit) *=*=*
;
LOGDT	LD	B,0		;B = 0 (normal exit)
	POP	HL		;HL => Date/Time string
;
;*=*=* Display Date or Time String *=*=*
;
LOGMSG	PUSH	BC		;Save Error #, B (exit)
	@@LOGOT			;Log message
	POP	BC		;B = exit condition
;
;*=*=* If B = 0 then exit HL = 0, otherwise HL = -1 *=*=*
;
	LD	H,B		;Set HL = -1 or 0
	LD	L,B		;
	@@CKBRKC		;Clear any break
	RET			;RETurn with condition
;
;*=*=* Bad Format - display error & abort *=*=*
;
BADFMT	LD	HL,BADDAT$	;Illegal Date/Time
LOGABRT	LD	B,-1		;Abort Condition
	JR	LOGMSG		;Log Message
*LIST OFF
	SUBTTL '<LBDATE - TIME code>'
	PAGE
*LIST ON
;
;*=*=* TIME entry point - Any Parms entered ? *=*=*
;
TIME	@@CKBRKC		;Break key down?
	JR	Z,BEGINB	;Ok if not
	LD	HL,-1		; else abort
	RET
;
BEGINB	PUSH	HL		;Save pointer
TLOOP	LD	A,(HL)		;p/u character
	CP	'('		;any parameters ?
	JR	Z,GETPRMS	;yes - get 'em
	CP	CR		;end of line ?
	JR	Z,CLRSTK	;yes - TIME entered ?
	INC	HL		;bump ptr
	JR	TLOOP		;do til terminator
;
;*=*=* Process any Parameters *=*=*
;
GETPRMS	LD	DE,PRMTBL$	;DE => Parameter Table
	@@PARAM			;Get parameters
;
;*=*=* Stuff "Illegal Time" Mess in error routine *=*=*
;
CLRSTK	LD	HL,BADTIM$	;Illegal time
	LD	(BADFMT+1),HL	;overwrite "Illegal Date"
	POP	HL		;recover command ptr
	JR	Z,GDPARMS	;Z - valid parameters
;
;*=*=* Parameter Error - Display & abort *=*=*
;
IOERR	LD	L,A		;xfer errcod to HL
	LD	H,0		;
	OR	0C0H		;Short error
	LD	C,A		;xfer to C
	@@ERROR			;log error
	RET			;
;
;*=*=* Was there a TIME string entered ? *=*=*
;
GDPARMS	LD	A,(HL)		;p/u char
	CP	'('		;No entry ?
	JP	Z,DSPTIME	;display time
	CP	CR		;Display or Set ?
	JP	Z,DSPTIME	;C/R - Display time
;
;*=*=* Time set - Check if legal format *=*=*
;
	LD	C,'0'		;init separator
	CALL	PARSDAT		;parse entry
	JR	NZ,BADFMT	;bad - abort
;
;*=*=* Legal Format - Check if Hours are legal *=*=*
;
	LD	HL,DTBUF+2	;HL => Hours byte
	LD	A,23		;Greater than 23 ?
	CP	(HL)		;
	JR	C,BADFMT	;yes - bad format
;
;*=*=* Hours legal - Check if minutes legal *=*=*
;
	DEC	HL		;HL => Minutes
	LD	A,59		;Greater than 59 ?
	CP	(HL)		;
	JR	C,BADFMT	;yes - bad format
;
;*=*=* Minutes legal - Check if seconds legal *=*=*
;
	DEC	HL		;HL => Seconds
	CP	(HL)		;Greater than 59 ?
	JR	C,BADFMT	;yes - bad format
;
;*=*=* Legal input - transfer to TIME$ storage area *=*=*
;
	PUSH	HL		;Save TIME buffer ptr
	LD	HL,DUMBUF	;HL => dummy buffer
	@@TIME			;DE <= TIME$+0
	POP	HL		;Recover TIME buffer ptr
	LD	BC,3		;3 bytes to xfer
	LDIR			;xfer
;
;*=*=* Was the CLOCK (C) parameter entered ? *=*=*
;
DOCLOCK	LD	HL,0		;HL = 0 (Normal Exit)
	LD	A,(CRESP)	;p/u response
	OR	A		;
	RET	Z		;RETurn if no response
;
;*=*=* CLOCK (C) parameter entered - ON or OFF ? *=*=*
;
CLOCK	LD	DE,$-$		;p/u parm = FFFF or 0000
	@@FLAGS			;IY => System Flags
;
;*=*=* Just Set/Reset CLOCK bit if Model IV version *=*=*
;
	IF	@MOD4
	SET	4,(IY+'V'-'A')	;Set Clock bit
	INC	E		;Return if CLOCK = YES
	RET	Z		;
	RES	4,(IY+'V'-'A')	;Otherwise Reset bit
	DEC	E		;Set Z flag
	RET			;done - RETurn
	ENDIF
;
;*=*=* Also Add or Remove Task if Model II Version *=*=*
;
	IF	@MOD2
	RES	4,(IY+'V'-'A')	;reset clock bit
	LD	C,CLK_SLT	;Set C = Clock Slot #
	LD	A,@RMTSK	;A = Remove Task SVC #
	INC	E		;Clock Off ?
	JR	NZ,CLOFF	;yes - remove task
CLON	LD	DE,DO_CLOCK	;Clock on - DE => Address
	SET	4,(IY+'V'-'A')	;set clock bit
	LD	A,@ADTSK	;A = Add Task SVC #
CLOFF	RST	40		;issue SVC
	XOR	A		;Set Z regardlessly
	RET			;
	ENDIF
;
;*=*=* Display the Time *=*=*
;
DSPTIME	LD	HL,DATEBUF+9	;Pt to space for time str
	PUSH	HL		;Save pointer
	@@TIME			;xfer time into buffer
	CALL	DOCLOCK		;Set/Reset Clock bit
	JP	LOGDT		;Log it & exit
*LIST OFF
	SUBTTL '<LBDATE - DATE/TIME Common Routines>'
	PAGE
*LIST ON
;
;
;********************************************************
;***						      ***
;*** DSPMDY - Xfer 3 char string from table to buffer ***
;***						      ***
;*** B  => Entry # in table to display		      ***
;*** HL => Table to fetch data from		      ***
;*** DE => Buffer to receive string		      ***
;***						      ***
;********************************************************
;
DSPMDY	DEC	B		;B = Day of week (0-6)
	LD	A,L		;p/u lsb of table start
	ADD	A,B		;Add 3 x Day of week
	ADD	A,B		;
	ADD	A,B		;
	LD	L,A		;HL => Table entry
;
;*=*=* Transfer string into buffer *=*=*
;
	LD	B,3		;Three chars to xfer
DSPM1	LD	A,(HL)		;p/u char from table
	LD	(DE),A		;stuff into buffer
	INC	HL		;bump
	INC	DE		;
	DJNZ	DSPM1		;three chars to xfer
	RET			;done - RETurn
;
;
;********************************************************
;***						      ***
;*** PARSDAT - Parse TIME/DATE string entry	      ***
;***						      ***
;*** HL => Buffer containing string to parse	      ***
;*** C  => Delimiter (<"0" = DATE, <"0"or=":" = TIME) ***
;***						      ***
;*** DTBUF-DTBUF+2 <= Data in compressed format	      ***
;*** Z  - Set if successful			      ***
;***						      ***
;********************************************************
;
PARSDAT	LD	DE,DTBUF+2	;point to buf end
	LD	B,3		;process 3 fields
;
;*=*=* Parse a field - Return NZ if bad *=*=*
;
PRS1	PUSH	DE		;save pointer
	CALL	PRS2		;get a digit pair
	POP	DE		;recover pointer
	RET	NZ		;ret if bad digit pair
;
;*=*=* Good field - Stuff in buff, dec ptr, & count *=*=*
;
	LD	(DE),A		;else stuff the value
	DEC	B		;loop countdown
	RET	Z		;do for 3 fields
	DEC	DE		;backup the pointer
;
;*=*=* Parsed a field - is the separator valid ? *=*=*
;
	LD	A,(HL)		;p/u separator
	INC	HL		;bump pointer
	CP	':'		;Check for ':'
	JR	Z,PRS1		; loop if so
	CP	C		;correct ?
	JR	NC,PRSRET	;yes - continue
	JR	PRS1		; loop if OK
PRSRET	OR	A		;set NZ
	RET			;no - RET NZ
;
;
;********************************************************
;***						      ***
;*** PRS2 - Parse a digit pair at HL		      ***
;***						      ***
;********************************************************
;
PRS2	CALL	PRS4		;get a digit
	JR	NC,PRS3		;illegal - clr stc & RET
;
;*=*=* Legal Digit - Multiply by 10 *=*=*
;
	LD	E,A		;multiply by ten
	RLCA			;x 2
	RLCA			;x 4
	ADD	A,E		;x 5
	RLCA			;x 10
	LD	E,A		;stuff in E
;
;*=*=* Get another digit *=*=*
;
	CALL	PRS4		;get ones digit
	JR	NC,PRS3		;bad - return NZ
;
;*=*=* Legal digit - Add to tens digit & set Z flag *=*=*
;
	ADD	A,E		;accumulate new digit
	LD	E,A		;save 2-digit value
	CP	A		;clear flags
	RET			;return Z
;
;*=*=* Force NZ & Return *=*=*
;
PRS3	OR	A		;set NZ
	RET			;RETurn
;
;*=*=* Pick up a digit and convert to binary *=*=*
;
PRS4	LD	A,(HL)		;p/u a digit &
	INC	HL		;bump ptr
	SUB	'0'		;convert to binary
	CP	10		;Legal ?
	RET			;C - legal, NC - illegal
;
;
;##############  PARAMETER TABLE  ###############
;
PRMTBL$	DB	80H		;6.x Parameter Table
;
	DB	FLAG!ABB!5
	DB	'CLOCK'
CRESP	DB	0
	DW	CLOCK+1
	DB	0
;
	ORG	$<-8+1<+8
;
DAYTBL	DB	'SunMonTueWedThuFriSat'
MONTBL	DB	'JanFebMarAprMayJunJulAugSepOctNovDec'
DATEBUF	DB	'Day, Mon xx, 198x',CR
MAXDAYS	DB	0,31,28,31,30,31,30,31,31,30,31,30,31
NODATE$	DB	'Date not in system',CR
BADDAT$	DB	'Bad Date format',CR
BADTIM$	DB	'Bad Time format',CR
;
;
DTBUF	EQU	$
DUMBUF	EQU	$+3
;
	END	DATE
