;LBCREATE/ASM - CREATE command - 10/29/83
	TITLE	<CREATE - LDOS 6.2>
;
;***
;	Change Log
;
; 02/04/83 - Xlated naughty words to Whoa, & double
;	   - checked by DK.
; 02/06/83 - Cleaned up a bit - RS
; 04/11/83 - Corrected FNAME call for device/file
; 10/21/83 - Changed code to use "Parameter Error"
;          - error code instead of hard coded. DK
; 10/27/83 - Removed unnecessary break handling code &
;          - changed code to use @CKBRKC SVC. DK
;***
;
*GET SVCMAC:3
*GET VALUES:3
PAR_ERR	EQU	44		;Parameter Error
;
	ORG	2400H
;
;*=*=* Save SP in case of error & CALL create code *=*=*
;
CREATE	EQU	$
	@@CKBRKC		;Break key down?
	JR	Z,BEGINA	;Ok if not
	LD	HL,-1		; else abort
	RET
;
BEGINA	LD	(SAVESP+1),SP	;save SP address
	CALL	CREATCD		;Do the CREATE code
;
;*=*=* Set ERN & offset in FCB = value at @INIT *=*=*
;
ERN	LD	HL,$-$		;p/u ERN (probably 0)
	LD	(FCB+12),HL	;stuff into FCB
OFFSET	LD	A,$-$		;p/u offset byte
	LD	(FCB+8),A	;stuff into FCB
;
;*=*=* CLOSE the file if possible *=*=*
;
	LD	DE,FCB		;DE => FCB
	@@CLOSE			;close file
	JP	NZ,IOERR	;NZ - I/O Error
;
;*=*=* Exit Routine *=*=*
;
	LD	HL,0		;successful - HL = 0
	RET			;return
;
;*=*=* Parse the Filespec given *=*=*
;
CREATCD	LD	DE,FCB		;fetch filespec
	@@FSPEC			;
	JP	NZ,SPCREQ	;jump on error
;
;*=*=* Check out parameter input *=*=*
;
	LD	DE,PRMTBL$	;get parms
	@@PARAM			;
	JP	NZ,IOERR	;jump on parm error
;
;*=*=* Check If Rec or LRL were specified *=*=*
;
	LD	A,(LRESP)	;p/u LRL response
	LD	B,A		;save in B
	LD	A,(RRESP)	;p/u REC response
	OR	B		;Either specified ?
	JR	Z,RPARM		;no - check # records
;
;*=*=* If Size Parm was specified - Parameter Error *=*=*
;
	LD	A,(SRESP)	;size can't be used
	OR	A		;with REC or LRL
	JP	NZ,PRMERR	;specified ? - Error
;
;*=*=* Check Record count *=*=*
;
RPARM	LD	BC,$-$		;p/u # of records
	LD	A,B
	OR	C
	JR	NZ,LPARM
;
;*=*=* Zero Records - Use Size instead *=*=*
;
SPARM	LD	HL,$-$		;p/u size parm
	LD	A,H
	OR	L
	JP	Z,PRMERR	;err if size not entered
;
;*=*=* Multiply HL x 4 to get # of sectors *=*=*
;
	ADD	HL,HL		;x 2
	ADD	HL,HL		;x 4
	LD	(RPARM+1),HL	;Pretend its rec input
;
;*=*=* Make sure LRL input is valid *=*=*
;
LPARM	LD	BC,$-$		;p/u LRL
	LD	A,B		;test for > 256
	OR	A		;if hi-order = 0,
	JR	Z,LP1		;just use lo-order
	DEC	A		;test hi-order = 1
	JP	NZ,PRMERR
	OR	C		;p/u lo-order
	JP	NZ,PRMERR	;lo-order must be 0
LP1	OR	C		;merge lo-order
;
;*=*=* Open the File with the LRL specified *=*=*
;
	LD	DE,FCB		;open the file
	LD	HL,BUFFER
	LD	B,A		;LRL = 256, or user entry
	@@INIT			;
	JP	NZ,IOERR	;jump on init error
;
;*=*=* Display "Creating : Filespec" String *=*=*
;
	LD	DE,FILESP	;DE => Filespec
	LD	BC,(FCB+6)	;p/u drive #, DEC
	LD	A,(FCB)	;P/u to test device/file
	CALL	$FNAME
	JP	NZ,IOERR	;NZ - whoa
	LD	HL,CREATE$	;"Creating : "
	@@DSPLY			;display it
	JP	NZ,IOERR	;
	LD	C,CR		;end line
	@@DSP
	JP	NZ,IOERR
;
;*=*=* Save ERN & offset from FCB for later *=*=*
;
	LD	HL,(FCB+12)	;p/u ERN
	LD	(ERN+1),HL	;stuff into LD HL,0000
	LD	A,(FCB+8)	;p/u offset byte
	LD	(OFFSET+1),A	;stuff into LD A,00
;
;*=*=* Check if the New Size > Old Size ? *=*=*
;
BIGGER	LD	DE,FCB		;DE => FCB+0
	@@LOF			;Get length of file
	LD	H,B
	LD	L,C
	LD	BC,(RPARM+1)	;p/u # of records
	XOR	A		;clear carry
	PUSH	HL		;Save ERN
	SBC	HL,BC		;is new ERN > old ERN?
	POP	HL		;HL = ERN
	JP	NC,BADSIZ	;Gp if not
;
;*=*=* Position FCB to Ending Record Number *=*=*
;
	DEC	BC		;reduce to offset from 0
	@@POSN			;Position to new ERN
;
;*=*=* Fill a 256 byte buffer with X'E5' bytes *=*=*
;
	LD	HL,BUFFER	;buffer area
	LD	DE,BUFFER+1	;"format" a sector
	LD	BC,255
	LD	(HL),0E5H
	LDIR
;
;*=*=* Write the last Record of the file *=*=*
;
	LD	DE,FCB		;write the new ERN sector
	DEC	H		;Set HL = buffer start
	INC	HL
	CALL	WRITE		;Write the last record
	@@REW			;Rewind File
;
;*=*=* Read in the directory entry *=*=*
;
	LD	BC,(FCB+6)	;get drive # & DEC
	@@DIRRD			;Read in record
	JR	NZ,IOERR	;jump on error
;
;*=*=* Set the CREATE bit, and write it back out *=*=*
;
	INC	HL		;point to FCB+1 &
	SET	7,(HL)		; set the CREATE bit
	@@DIRWR			;Write entry back
	JR	NZ,IOERR	;jump on error
;
;*=*=* Do we have to Fill the file ? *=*=*
;
FILL	LD	BC,0100H	;p/u FILL parm
	DEC	B		;
	RET	Z		;RETurn
;
;*=*=* Create a Buffer with the FILL bytes *=*=*
;
	PUSH	DE		;Save FCB pointer
	LD	HL,BUFFER	;I/O buffer
	LD	(HL),C		;byte to xfer
	LD	DE,BUFFER+1	;
	LD	BC,255+256	;Hit both buffers
	LDIR			;xfer into buffer
;
;*=*=* Pt HL => User Buff, DE => FCB, BC = last Rec *=*=*
;
	POP	DE		;restore FCB pointer
	LD	BC,(RPARM+1)	;p/u last record
	LD	HL,UBUFF	;User Buffer
;
;*=*=* Loop to write logical records *=*=*
;
WRLOOP	LD	A,B		;Is rec cnt = 0 ?
	OR	C		;
	RET	Z		;yes - done
	CALL	WRITE		;Write Record
	DEC	BC		;dec one
	JR	WRLOOP		;do til BC = 0
;
;*=*=* Write the buffer contents *=*=*
;
WRITE	@@WRITE			;Write buffer
	RET	Z		;good - RETurn
	DB	21H		;Skip LD A,## instruction
PRMERR	LD	A,PAR_ERR	;Parameter Error
;
;*=*=* I/O error display & abort routine *=*=*
;
IOERR	LD	L,A		;Save error # in HL
	LD	H,0		;
	OR	0C0H		;Short error message
	LD	C,A		;stuff in C for @ERROR
	@@ERROR			;display error message
SAVESP	LD	SP,$-$		;p/u original SP
	RET			;done RETurn
;*=*=*
;	Routine to pick up device/file name
;*=*=*
$FNAME	BIT	7,A		;Test device/file
	JR	Z,FNAME1
	@@FNAME
	RET
FNAME1	LD	A,'*'		;Stuff device indicator
	LD	(DE),A
	INC	DE
	LD	A,C		;Stuff 1st character
	LD	(DE),A
	INC	DE
	LD	A,B		;Stuff 2nd character
	LD	(DE),A
	INC	DE
	LD	A,3		;Stuff ETX
	LD	(DE),A
	RET
;
;*=*=* Error Message Display routine *=*=*
;
SPCREQ	LD	HL,SPCREQ$
	DB	0DDH
BADSIZ	LD	HL,BADSIZ$
;
;*=*=* Log Error Message & Abort *=*=*
;
	@@LOGOT			;log error message
	LD	HL,-1		;Internal Error
	JR	SAVESP		;get old <BREAK> & abort
;
;*=*=* Messages *=*=*
;
SPCREQ$	DB	'File spec required',CR
BADSIZ$	DB	'File exists larger',CR
CREATE$	DB	'Creating: '
FILESP	DS	15
;
;
;#############  PARAMETER TABLE  ##############
;
PRMTBL$	DB	80H		;6.x Parameter Table
;
;*** SIZE (S) - Accept Numeric Input only ***
;
	DB	NUM!ABB!4
	DB	'SIZE'
SRESP	DB	0
	DW	SPARM+1
;
;*** REC (R) - Accept Numeric input only ***
;
	DB	NUM!ABB!3
	DB	'REC'
RRESP	DB	0
	DW	RPARM+1
;
;*** LRL (L) - Accept Numeric input only ***
;
	DB	NUM!ABB!3
	DB	'LRL'
LRESP	DB	0
	DW	LPARM+1
;
;*** FILL (F) - Accept Numeric or Flag input ***
;
	DB	FLAG!NUM!ABB!4
	DB	'FILL'
FRESP	DB	0
	DW	FILL+1
	DB	0
;
;*=*=* I/O buffer *=*=*
;
FCB	DB	0
	DS	31
	ORG	$<-8+1<8
BUFFER	DS	256
UBUFF	DS	256
;
	END	CREATE
