;LBCOPYB/ASM - COPY/APPEND Common Routines - 11/02/38
*LIST OFF
	SUBTTL '<LBCOPYB - COPY/APPEND Common Routines>'
	PAGE
*LIST ON
;
;********************************************************
;***						      ***
;*** CVRTUC - Transfer partspec & convert to U/C      ***
;***						      ***
;*** HL => Buffer containing characters to parse      ***
;*** DE => Destination of converted line	      ***
;***						      ***
;********************************************************
;
CVRTUC	CALL	CVRT		;convert line
	LD	A,CR		;ensure end-of-line
	LD	(DE),A		;with a Carriage Return
	RET			;
;
;*=*=* Position to First non-space character *=*=*
;
CVRT0	INC	HL
CVRT	LD	A,(HL)		;P/u possible dest char
	CP	CR		;Exit on CR
	RET	Z
	CP	' '		;Loop on space
	JR	Z,CVRT0
	DEC	HL		;backup to 1st separator
;
;*=*=* HL => Filespec or Devspec, convert to U/C *=*=*
;
	LD	B,32		;max 32 chars
COP1	LD	A,(HL)		;transfer the partial
	CP	'a'		;cvrt lc to uc
	JR	C,COP2
	CP	'z'+1		;*** 12/06/82 - RS
	JR	NC,COP2
	RES	5,A
COP2	LD	(DE),A		;filespec until paren
	CP	CR		;RETurn if terminator
	RET	Z		;
	CP	'('		;Parameter ?
	RET	Z
	INC	HL		;bump ptr
	INC	DE		;or 32 chars max
	DJNZ	COP1
	RET
;
;
;********************************************************
;***						      ***
;*** PRSPC - Match Source & Dest. specs for defaults  ***
;***						      ***
;********************************************************
;
PRSPC	LD	HL,FCB1		;HL => Source FCB
	LD	DE,FCB2		;DE => Destin FCB
;
;*=*=* Abort if first character is illegal *=*=*
;
	LD	A,(DE)		;p/u 1st char of dest
	CP	CR		;Is it a C/R ?
	JP	Z,DSTREQ	;"Destination spec req"
	CP	'0'		;Numeric ?
	JR	C,CHKDEST	;
	CP	'9'+1
	JP	C,DSTREQ	;yes - "Dest spec req"
;
CHKDEST	PUSH	DE		;save Destination FCB ptr
;
;*=*=* If no dest. filename, xfer source filename *=*=*
;
	LD	A,(DE)		;p/u a dest char
	CP	'A'		;Filename present ?
	CALL	C,PRSPC7	;no - xfer src filename
;
	LD	B,'/'		;with an alpha, init to
	CALL	PRSPC2		; test for extension
;
	LD	B,'.'		;init to test for pswd
	CALL	PRSPC2
;
	POP	DE
	RET
;
;
;********************************************************
;***						      ***
;*** PRSPC2 - Transfer Field to destination	      ***
;***						      ***
;*** DE => Start of Destination Field		      ***
;***  B  = Delimiter to Position one byte after	      ***
;***						      ***
;********************************************************
;
PRSPC1	INC	DE
;
;*=*=* Finished with Field (Delimiter hit) ? *=*=*
;
PRSPC2	LD	A,(DE)		;is the next char the
	CP	B		;separator to look for
	JR	Z,PRSPC3
;
;*=*=* Skip over an existing destination field *=*=*
;
	CP	'A'		;Alphabetic ?
	JR	NC,PRSPC1	;yes - skip it
	CP	'0'		;Numeric ?
	JR	C,PRSPC4	;no - use source field
	CP	'9'+1		;Numeric ?
	JR	C,PRSPC1	;yes - skip it
;
	JR	PRSPC4		;Use source field
;
;*=*=* Hit the delimiter - Position to next char *=*=*
;
PRSPC3	INC	DE		;position to next field
	RET			;and RETurn
;
;*=*=* Scan Source spec & see if it contains field *=*=*
;
PRSPC4	PUSH	HL		;save ptr to source
PRSPC5	LD	A,(HL)		;grab a source char
	INC	HL		;Position to next char
;
;*=*=* Is the character a Terminator ? *=*=*
;
	CP	ETX		;end of line ?
	JR	Z,PRSPC6	;if so, not in source
	CP	CR		;end of line?
	JR	Z,PRSPC6	;if so, not in source
;
;*=*=* is the character the field delimiter ? *=*=*
;
	CP	B		;delimiter ?
	JR	NZ,PRSPC5	;nope, continue
;
;*=*=* Transfer Source Field to Destination *=*=*
;
	CALL	MVFLD1		;yes, xfer the SRC field
;
PRSPC6	POP	HL		;rcvr source ptr
	RET
;
;
;*******************************************************
;***						     ***
;*** PRSPC7 - Shoehorn source into destination field ***
;***						     ***
;*******************************************************
;
;*=*=* Check if 1st char in (HL) is alphanumeric *=*=*
;
PRSPC7	LD	A,(HL)		;p/u source char
	CP	'0'		;RET NC if alphanumeric
	RET	C		;C - not alphanumeric
	CP	'9'+1		;Numeric (0-9) ?
	JR	C,MVFLD		;xfer if it is
	CP	'A'		;Not numeric -
	RET	C		;must be alphabetic
;
;*=*=* Shoehorn a source field byte into dest FCB *=*=*
;
MVFLD	INC	HL		;bump source pointer
MVFLD1	PUSH	HL
	LD	H,D		;xfer dest ptr to HL
	LD	L,E
;
;*=*=* P/u current char, & stuff in last char *=*=*
;
MVFLD2	LD	C,(HL)		;p/u dest char
	LD	(HL),A		;stuff in last character
	INC	HL		;posn to next char
;
;*=*=* Finished with field ? *=*=*
;
	LD	A,C		;test dest for 
	CP	ETX		;end of line ?
	JR	Z,MVFLD3
;
	CP	CR		;end of line ?
	JR	NZ,MVFLD2	;ripple the destination
;
;*=*=* Done stuffing 1 source byte into dest field *=*=*
;
MVFLD3	LD	(HL),A		;stuff the terminator
	POP	HL		;Restore Source FCB
	INC	DE		;advance to next pos
	JR	PRSPC7		;go get next source byte
;
;
;********************************************************
;***						      ***
;*** DOSVC - Get Filespec/Devspec & Issue @OPEN/@INIT ***
;***						      ***
;********************************************************
;
DOSVC	PUSH	AF		;Save SVC #
	PUSH	HL		;Buffer ptr
	PUSH	DE		;FCB
;
;*=*=* Transfer Filespec/Devspec into TEMBUF *=*=*
;
	LD	HL,TEMBUF
TLP	LD	A,(DE)		;p/u byte from FCB
	CP	'/'		;extension ?
	JR	NZ,STUFCHR	;no - check if space
	INC	DE		;Is the next character
	LD	A,(DE)		; valid ?
	CP	'A'		;
	JR	C,STUFCHR	; no - don't output it
	DEC	DE		;back one
	LD	A,(DE)		;p/u slash
STUFCHR	LD	(HL),A		;xfer to TEMBUF
	INC	HL
	INC	DE
	CP	CR+1		;Done ?
	JR	C,DUN
	CP	':'
	JR	Z,DUN
	CP	'.'
	JR	NZ,TLP
;
;*=*=* Found valid terminator - Is this a device ? *=*=*
;
DUN	DEC	HL		;back up to term
	POP	DE		;DE => FCB+0
	LD	A,(DE)		;Device ?
	CP	'*'
	JR	Z,DUN2		;yes - done
	LD	(HL),':'	;no - overwrite with ":"
	INC	HL		;bump
	LD	(DSPEC+1),HL	;save drivespec location
	INC	HL		;bump
DUN2	LD	(HL),ETX	;end with X'03'
	POP	HL		;HL => Disk I/O buffer
	POP	AF		;A = SVC #
	LD	(SVCNUM+1),A	;Save SVC #
;
;*=*=* Issue Supervisory Call *=*=*
;
	RST	28H		;do it
	PUSH	AF		;Save SVC condition
	CALL	GETDRIV		;p/u drv (in C) if file
	JR	Z,DEVICE	;Z - this is a device
;
;*=*=* This is a file - did we @INIT it ? *=*=*
;
	LD	A,(SVCNUM+1)	;p/u SVC #
	CP	@INIT		;is it @INIT ?
	JR	NZ,DEVICE	;no - don't worry
;
;*=*=* Was the @INIT successful ? *=*=*
;
	POP	AF		;Don't you dare perform
	PUSH	AF		; a @CKDRV if you didn't
	JR	Z,DO_CKDR	; successfully @INIT it.
	CP	42		;LRL Open Fault ?
	JR	NZ,DEVICE	;no - Don't @CKDRV
;
;*=*=* @INIT was ok - is this a Write Prot Disk? *=*=*
;
DO_CKDR	@@CKDRV			;Write Protected Disk ?
	LD	A,15		;init WP disk error code
	JP	C,IOERR		;yes - abort
;
;*=*=* Check status on the @INIT we did *=*=*
;
DEVICE	POP	AF		;Recover status
	JR	Z,CHKPROT	;check PROTection status
;
;*=*=* Ignore Error #42 - "LRL Open Fault" *=*=*
;
	CP	42		;Ignore this error
	RET	NZ		;NZ - Abort
;
;*=*=* Check if File has proper Access *=*=*
;
CHKPROT	BIT	7,(IX)		;Is this a filespec ?
	JR	Z,OKYDOKY	;no - don't check
	LD	A,(IX+1)	;p/u protection byte
	AND	7
	LD	B,A		;xfer to B
SVCNUM	LD	A,$-$		;p/u SVC #
	CP	@INIT		;@INIT ?
	LD	A,B		;p/u protection level
	JR	Z,INIT1		;Z - Must be < 5
	CP	6		;Read Access ?
	JR	C,OKYDOKY	;yes - set Z & RETurn
;
;*=*=* Illegal Access to protected file *=*=*
;
ILLACC	@@CLOSE			;Close File
	LD	A,25		;File Access Denied
	JP	IOERR		;Error - Regardless
;
INIT1	CP	5		;Update Access ?
	JR	NC,ILLACC	;no - Illegal Access
;
OKYDOKY	XOR	A		;Set Z flag
	RET			;and RETurn
;
;
;***
;	GETDRIV - P/u Drive # from FCB & convert to ASCII
;***
;
GETDRIV	PUSH	DE		;Get fcb to
	POP	IX		; here.
	LD	A,(DE)		;Device ?
	BIT	7,A		;
	RET	Z		;device - RETurn
;
;*=*=* Stuff Drive # into Buffer *=*=*
;
	LD	A,(IX+6)
	LD	C,A		;xfer to C
	ADD	A,'0'		;convert to ASCII
DSPEC	LD	($-$),A		;
	RET			;RETurn w/ condition
;
;
;********************************************************
;***						      ***
;*** PUTSOUR/PUTDEST - Create Src/Dest File/Dev specs ***
;***						      ***
;********************************************************
;
PUTSOUR	PUSH	HL		;Save HL
	LD	HL,FROM		;xfer there
	JR	XBUFF		;
PUTDEST	PUSH	HL		;Save HL
	LD	HL,TO2		;
;
;
;********************************************************
;***						      ***
;*** XBUFF - Transfer TEMBUF contents to User Buffer  ***
;***						      ***
;*** HL => Destination of Filespec/Devspec	      ***
;***						      ***
;********************************************************
;
XBUFF	PUSH	DE		;save FCB ptr
	LD	DE,TEMBUF	;DE => Source
	EX	DE,HL		;swap for LDIR
	LD	BC,15		;15 bytes Max
	LDIR			;xfer
	POP	DE		;DE => FCB+0
	POP	HL		;Recover Buffer ptr
	RET			;done
;
;
;********************************************************
;***						      ***
;*** CPYFILE - Display Copying/Appending Message      ***
;***						      ***
;********************************************************
;
CPYFILE	PUSH	HL		;Save registers
	PUSH	DE		;
	LD	HL,COPYMS	;"Copying : "
APPFLAG	LD	A,$-$+1		;Append or Copy ?
	OR	A		;
	JR	NZ,ITSCOPY	;
	LD	HL,APPDMS	;"Appending : "
ITSCOPY	CALL	DSPLY		;
	LD	HL,FROM		;Source
	CALL	DSPLY		;
	LD	HL,TO		;" TO "
	CALL	DSPLY		;
	LD	C,CR		;end line
	CALL	DISPB		;display byte
	POP	DE		;Restore Regs
	POP	HL		;
	RET			;
;
;
;********************************************************
;***						      ***
;*** GETLRL - Get LRL from a Directory Entry	      ***
;***						      ***
;*** DE => FCB of filespec			      ***
;*** IX <= FCB of filespec			      ***
;*** A  <= LRL of file				      ***
;***						      ***
;********************************************************
;
GETLRL	PUSH	DE		;xfer fcb to IX
	POP	IX		;
	LD	A,(IX+7)	;p/u DEC
	AND	0E0H		;calculate Record Number
	ADD	A,4		;pt to LRL
	LD	L,A		;
SYSBUF	LD	H,$-$		;p/u hi-byte of SBUFF$
	LD	A,(HL)		;p/u LRL
	RET
;
;********************************************************
;***						      ***
;*** GETCLON - Recover Cloning info from Source	      ***
;***						      ***
;********************************************************
;
GETCLON	PUSH	DE
	POP	IX		;xfer FCB to ix
	LD	A,(IX+7)	;p/u source DEC
	AND	0E0H		;pt to start of record
	LD	L,A		;pt to core record
SYSBUF2	LD	H,$-$		;p/u hi-byte of SBUFF$
	LD	DE,CLONSAV	;save clone info
	LD	BC,3
	LDIR
	LD	A,13		;pt to password fields
	ADD	A,L
	LD	L,A
	LD	BC,4		;save them also
	LDIR
	RET
;
;********************************************************
;***						      ***
;*** DOINIT - Initialization for APPEND or COPY	      ***
;***						      ***
;********************************************************
;
DOINIT	EQU	$
;
;*=*=* Calculate high byte of available memory *=*=*
;
	PUSH	HL		;Save HL
	@@FLAGS			;IY => System Flags
	LD	HL,0		;p/u HIGH$
	LD	B,L		;
	BIT	1,(IY+CFLAG$)	;@CMNDR ?
	JR	Z,USEHI		;no  - use HIGH$
	INC	B		;yes - use LOW$
USEHI	@@HIGH$			;
;
;*=*=* Stuff high byte into memory check locations *=*=*
;
	INC	HL		; 256-byte block
	DEC	H
	LD	A,H		;set up test bytes
	LD	(RDREC3+1),A
	LD	(RDREC5+1),A
	LD	(GEOF6+1),A
;
;*=*=* Pick up high byte of System Buffer (SBUFF$) *=*=*
;
	LD	BC,0		;DEC = 0, Drive = 0
	@@DIRRD			;Read in BOOT/SYS
	LD	A,H		;p/u high byte of SBUFF$
	LD	(SYSBUF+1),A	;stuff away for LRL
	LD	(SYSBUF2+1),A	;stuff away for CLONE
;
;*=*=* Reset <PAUSE> & <ENTER> bits *=*=*
;
	CALL	RESKFLG		;Reset bits 0-2
	POP	HL
	RET
;
;
;********************************************************
;***						      ***
;*** GEOF5 - Write out the last sector of destination ***
;***						      ***
;********************************************************
;
GEOF5	LD	A,H		;p/u hi-order pointer
	CP	BUF1<-8		;same as start?
	RET	Z		;ret if finished
;
;*=*=* At the end of buffer area ? *=*=*
;
GEOF6	CP	$-$		;GEOF6+1 = msb of top
	RET	Z		;return if finished
;
;*=*=* Flash "Insert Dest. Disk" & write remainder *=*=*
;
	CALL	PMTDST		;prompt destination
	LD	B,H		;save highest used
	LD	HL,BUF1		;pt to start
;
;*=*=* Loop to write out remainder of dest. file *=*=*
;
GEOF7	LD	(FCB2+3),HL	;set dest buffer address
	LD	DE,FCB2		;DE => Dest. FCB
	@@WRITE			;write a record
	JP	NZ,IOERR	;jump on write error
;
;*=*=* Finished writing ? *=*=*
;
	INC	H		;bump buff ptr
	LD	A,H		;
	CP	B		;finished?
	JR	NZ,GEOF7	;loop if not
	RET			;Return
;
;
;********************************************************
;***						      ***
;*** CKBRK - Check for BREAK			      ***
;***						      ***
;*** NZ - <BREAK> key was depressed		      ***
;***						      ***
;********************************************************
;
;*=*=* Was the <BREAK> key hit ? *=*=*
;
CKBRK
	@@CKBRKC		;<BREAK> hit ?
	RET			;Z - No, NZ - Yes
;
;
;********************************************************
;***						      ***
;*** PMTSYS - Prompt for a system disk		      ***
;***						      ***
;********************************************************
;
PMTSYS	LD	A,(XPARM+1)	;X parameter entered ?
	OR	A		;
	RET	Z		;no - need to prompt
;
;*=*=* If Xfer drive number isn't 0 - don't prompt *=*=*
;
XFRDRV	LD	A,$-$		;XFRDRV+1 contains drv #
	OR	A		;Is it zero ?
	RET	NZ		;ret if not SYSTEM drive
;
;*=*=* Flash "Insert SYSTEM disk" message *=*=*
;
	PUSH	HL		;save HL
	LD	HL,PMTSYS$	;"Insert SYSTEM disk"
	CALL	FLASH		;Flash, & RET if <ENTER>
	POP	HL		;restore HL
;
	RET			;
;
;
;********************************************************
;***						      ***
;*** PMTSRC - Prompt for Source Disk		      ***
;***						      ***
;********************************************************
;
PMTSRC	LD	A,(XPARM+1)	;X parameter entered ?
	OR	A		;
	RET	Z		;no - don't display it
;
;*=*=* Flash "Insert Source disk" message *=*=*
;
	PUSH	HL
	LD	HL,PMTSRC$	;init for source
	CALL	FLASH		;dsp msg & await reply
;
;*=*=* Read in the GAT from the Source Disk *=*=*
;
	LD	A,(XFRDRV+1)	;p/u drive
	LD	C,A		;stuff in C
	CALL	RDGAT		;get GAT
;
;*=*=* Is this the correct source disk ? *=*=*
;
	LD	HL,GAT+0CEH	;HL => Name & Date field
	LD	DE,SRCSTR	;DE => Original Source
	LD	B,18		;same source disk ?
	CALL	CPRHLDE		;Z - same, NZ - different
	POP	HL		;Restore HL
;
	JR	NZ,PMTSRC	;re-request if not match
	RET			;okay
;
;
;********************************************************
;***						      ***
;*** PMTDST - Prompt for Destination disk	      ***
;***						      ***
;********************************************************
;
PMTDST	LD	A,(XPARM+1)	;X parameter entered ?
	OR	A		;
	RET	Z		;no - RETurn
;
;*=*=* Flash "Insert Destination disk" message *=*=*
;
	PUSH	HL
	LD	HL,PMTDST$	;pt to msg
	CALL	FLASH		;prompt & await reply
;
;*=*=* Read in GAT from original destination disk *=*=*
;
	LD	A,(XFRDRV+1)	;p/u drive #
	LD	C,A		;stuff in C
	CALL	RDGAT		;get GAT
;
;*=*=* Is this the same destination disk ? *=*=*
;
	LD	HL,GAT+0CEH	;HL => Name & Date field
	LD	DE,DSTSTR	;DE => Original dest
	LD	B,18		;same destination disk ?
	CALL	CPRHLDE		;Z - Same, NZ - different
	POP	HL		;restore HL
;
	JR	NZ,PMTDST	;re-request if wrong disk
	RET			;
;
;
;********************************************************
;***						      ***
;*** CPRHLDE - Compare string @ HL to string @ DE     ***
;***						      ***
;*** B => Number of characters to compare	      ***
;*** Z -  Set if strings match		      	      ***
;***						      ***
;********************************************************
;
CPRHLDE	LD	A,(DE)		;p/u character @ DE
	CP	(HL)		;Same ?
	RET	NZ		;ret (NZ) if no match
	INC	HL		;bump each
	INC	DE		;
	DJNZ	CPRHLDE		;check B characters
	RET			;matched - RETurn Z
;
;
;********************************************************
;***						      ***
;*** FLASH & FLASH0 - Flash a message string	      ***
;***						      ***
;*** HL => Message string to flash		      ***
;***						      ***
;********************************************************
;
FLASH0	CALL	RESKFLG		;Reset 3-bit field
;
;*=*=* Pause for 1/4 second *=*=*
;
FLASH	LD	BC,16893	;Delay for 250 ms
	@@PAUSE			;
;
;*=*=* Clear out <ENTER> or <BREAK> in KFLAG$ *=*=*
;
	LD	A,(IY+KFLAG$)	;p/u KFLAG$
	AND	4!1		;Wait until no ENTER!BRK
	JR	NZ,FLASH0	;no - keep flashing
;
	CALL	RESKFLG		;Reset in case <BREAK>
;
;*=*=* Display the message & wait for 1/4 second *=*=*
;
FLS1	CALL	DSPLY		;
	LD	BC,4000H	;Delay 4000 iterations
	CALL	FLS2		;& scan for <ENTER>
;
;*=*=* Erase the message & wait for 1/5 second *=*=*
;
	LD	C,EL		;erase line
	CALL	DISPB		;
;
	LD	BC,3333H	;Delay 3333 iterations
	CALL	FLS2		;& check for <ENTER>
	JR	FLS1		;Loop until ENTER
;
;
;********************************************************
;***						      ***
;*** FLS2 - Delay BC loops & scan for <ENTER>	      ***
;***						      ***
;********************************************************
;
FLS2	CALL	CKBRK		;check for <BREAK>
	JP	NZ,ABORT	;
;
;*=*=* Was the <ENTER> pressed ? *=*=*
;
	BIT	2,(IY+KFLAG$)	;<ENTER> hit ?
	JR	NZ,FLS4		;Go on ENTER down
;
;*=*=* Nothing hit - Count down *=*=*
;
	DEC	BC		;Decrement count
	LD	A,B		;done ?
	OR	C		;
	JR	NZ,FLS2		;no - check again
	RET			;yes - RETurn
;
;*=*=* <ENTER> hit - POP ret addr & clr type ahead *=*=*
;
FLS4	POP	AF		;Pop return address
CLRTYPE	@@KBD			;Clear type ahead
	JR	Z,CLRTYPE	;good - get another
	OR	A		;O.K. ?
	JP	NZ,IOERR	;no - I/O Error
;
;*=*=* Erase message line *=*=*
;
	LD	C,EL		;erase line
	CALL	DISPB		;fall into RESKFLG
;
;
;********************************************************
;***						      ***
;*** RESKFLG - Reset <PAUSE> & <ENTER> bits in KFLAG  ***
;***						      ***
;********************************************************
;
RESKFLG	@@FLAGS			;IY => Flag Table
	LD	A,(IY+KFLAG$)	;p/u KFLAG$
	AND	0F9H		;Reset bits 2 & 1
	LD	(IY+KFLAG$),A	;stuff in KFLAG$
	RET			;RETurn
;
;
;********************************************************
;***						      ***
;*** DISPB - Output a byte to the Video		      ***
;***						      ***
;********************************************************
;
DISPB	@@DSP			;Output byte
	RET	Z		;good - RETurn
	JP	IOERR		;bad - I/O error
;
;
;********************************************************
;***						      ***
;*** DSPLY - Display line to video		      ***
;***						      ***
;********************************************************
;
DSPLY	@@DSPLY			;display
	RET	Z		;
	JP	IOERR		;bad - I/O Error
;
;
;********************************************************
;***						      ***
;*** STOP - Display Transfer aborted & Abort	      ***
;***						      ***
;********************************************************
;
STOP	LD	HL,STOP$	;"Transfer Aborted"
	@@LOGOT			;Log message
	CALL	PMTSYS		;"Insert SYSTEM disk"
	JP	ABORT		;Abort
;
;
;********************************************************
;***						      ***
;*** GETSYS2 - Bring in SYS2 to OPEN a file	      ***
;***						      ***
;********************************************************
;
GETSYS2	LD	A,84H
	RST	28H
;
;
;********************************************************
;***						      ***
;*** GETSYS3 - Bring in SYS3 to check out GAT	      ***
;***						      ***
;********************************************************
;
GETSYS3	LD	A,85H
	RST	28H
;
;*******************************************************
;***						     ***
;*** CKDEV - Is the source or Destination a device ? ***
;***						     ***
;*** Z - Either Source or Destination is a device    ***
;***						     ***
;*******************************************************
;
CKDEV	LD	A,(FCB1)	;is source a device?
	CP	'*'
	RET	Z
	LD	A,(FCB2)	;is destination a device?
	CP	'*'
	RET
;
;
;********************************************************
;***						      ***
;*** RDGAT - Read GAT of Drive C		      ***
;***						      ***
;********************************************************
;
RDGAT	PUSH	DE		;Save DE & HL
	PUSH	HL		;
	PUSH	IY		;Save IY
;
;*=*=* Set D = Cyl, E = Sector, HL => Buffer *=*=*
;
	@@GTDCT			;point IY to DCT
	LD	D,(IY+9)	;p/u dir cyl in D
	LD	E,0		;GAT is sector 0
	LD	HL,GAT		;HL => GAT I/O Buffer
	@@RDSSC			;Read Track D, Sector E
;
;*=*=* Restore Registers *=*=*
;
	POP	IY		;restore IY
	POP	HL		;Restore HL & DE
	POP	DE		;
	LD	A,14H		;else reset to GAT error
	RET			;RETurn with condition
;
;
;********************************************************
;***						      ***
;*** OPENDES - OPEN Destination File		      ***
;***						      ***
;********************************************************
;
OPENDES	LD	HL,BUF2		;HL => Dest I/O Buffer
	LD	DE,FCB2		;DE => Dest FCB
	JR	OPENFIL		;Open the file
;
;********************************************************
;***						      ***
;*** INITDES - INIT the destination file	      ***
;***						      ***
;********************************************************
;
INITDES	LD	A,@INIT		;A = @INIT SVC Number
	JR	INITFIL		;Go into OPEN routine
;
;
;********************************************************
;***						      ***
;*** OPENSRC - Open Source File			      ***
;***						      ***
;********************************************************
;
;*=*=* Set HL => I/O buffer, DE => FCB & Open file *=*=*
;
OPENSRC	LD	DE,FCB1		;DE => Source FCB
;
;*=*=* Set the File OPEN inhibit flag *=*=*
;
	@@FLAGS			;IY => System Flag Table
	SET	0,(IY+SFLAG$)	;Set file open inhibit
;
OPENSR2	LD	HL,BUF1		;HL => Source I/O buffer
OPENFIL	LD	A,@OPEN		;A = @OPEN SVC number
INITFIL	LD	B,0		;B = LRL = 256
;
;*=*=* OPEN or INIT the File *=*=*
;
GETFILE	CALL	DOSVC		;OPEN or INIT the file
	RET	Z		;RETurn with Z set
	JP	IOERR		;NZ - I/O Error
;
;*=*=* Error & Informative message strings *=*=*
;
COPYMS	DB	'Copying: ',ETX
APPDMS	DB	'Appending: ',ETX
;
DIFLRL$	DB	'Files have different LRLs',CR
DSTREQ$	DB	'Destination spec required',CR
STOP$	DB	BL,'Transfer aborted',CR
SPCREQ$	DB	'File spec required',CR
NOINDO$	DB	'Invalid command during <DO> '
	DB	'processing',CR
SAMERR$	DB	'Source and destination disks'
	DB	' are the same',CR
;
PMTSYS$	DB	BL,EL,' Insert SYSTEM disk <ENTER>'
	DB	BL,ETX
;
PMTSRC$	DB	BL,EL,' Insert SOURCE disk '
	DB	'in drive :'
SRC_DR	DB	'0 and press <ENTER>'
	DB	BL,ETX
;
PMTDST$	DB	BL,EL,' Insert DESTINATION disk '
	DB	'in drive :'
DEST_DR	DB	'0 and press <ENTER>'
	DB	BL,ETX
;
;
;===========  APPEND PARAMETER TABLE  ==============
;
APPTBL	DB	80H
;
;+++ STRIP (S) parm -> Accept Flag input only +++
;
	DB	FLAG!ABB!5
	DB	'STRIP'
	DB	0
	DW	SPARM+1
;
;+++ ECHO (E) parm -> Accept Flag input only +++
;
	DB	FLAG!ABB!4
	DB	'ECHO'
	DB	0
	DW	EPARM+1
	DB	0
;
;============= COPY PARAMETER TABLE ==============
;
COPYTBL	DB	80H		;New @PARAM
;
;+++ ECHO (E) parm -> Accept Flag input only +++
;
	DB	FLAG!ABB!4
	DB	'ECHO'
	DB	0
	DW	EPARM+1
;
;+++ LRL (L) parm -> Accept Numeric input only +++
;
	DB	NUM!ABB!3
	DB	'LRL'
	DB	0
	DW	LPARM+1
;
;+++ CLONE (C) parm -> Accept flag input only +++
;
	DB	FLAG!ABB!5
	DB	'CLONE'
	DB	0
	DW	CPARM+1
;
;+++ X parameter -> Accept FLAG input only +++
;
	DB	FLAG!1
	DB	'X'
	DB	0
	DW	XPARM+1
	DB	0		;End of COPY parm table
;
;*=*=* I/O & Storage Buffers *=*=*
;
FCB2	DB	0		;Show closed on LOAD
	DS	31
TEMBUF	DS	16
FROM	DS	16
TO	DB	' to '
TO2	DS	16
FCB1	DB	0
	DS	31
SRCSTR	DS	18
DSTSTR	DS	18
CLONSAV	DS	7
;
	ORG	$<-8+1<+8
;
GAT	DS	256
BUF1	DS	256
BUF2	DS	256
;
	END	COPY
