;LBAUTO/ASM - AUTO Commands - 10/31/83
;
	TITLE	<AUTO - LDOS 6.2>
;
;***
;	Change Log
;
; 02/04/83 - Double checked by DK
; 02/06/83 - Removed unnecessary exit code - RS
; 04/26/83 - Fixed AUTO :d command - DK
; 10/27/83 - Removed Break handling code & reorganized
;	   - everything. DK
; 10/31/83 - Reorganized code. DK
;
;***
;
*GET SVCMAC:3
*GET VALUES:3
;
SECTOR	EQU	0<8+2
OFFSET	EQU	20H		;Offset to Auto Buffer
RST28	EQU	28H		;SVC restart
@CMNDR	EQU	25		;Execute & return
@RDSEC	EQU	49		;Read a sector SVC #
@WRSEC	EQU	53		;Write a sector SVC #
;
	ORG	2400H
AUTO
	LD	(SAVESP+1),SP	;Save SP address
	CALL	PARSE		;Do AUTO command
	LD	HL,0		;Set HL = 0
;
;*=*=* Reinstall SP & RETurn *=*=*
;
SAVESP	LD	SP,$-$		;p/u old SP
	RET			;
;
;*=*=* Skip any leading spaces *=*=*
;
PARSE	DEC	HL		;back one
PARSE2	INC	HL		;bump buff ptr
	LD	A,(HL)		;p/u character
	CP	' '		;Space ?
	JR	Z,PARSE2	;go til non-space
;
;*=*=* Display auto Buffer on drive :d ? *=*=*
;
	CP	'?'		;Display auto buffer ?
	JR	Z,DISAUTO	;
;
;*=*=* Execute Auto Buffer on drive :d ? *=*=*
;
	CP	'='		;Execute auto buffer ?
	JR	Z,EXAUTO	;
;
;*=*=* Install the command in the auto buffer *=*=*
;
	CALL	GETDRV		;p/u drive #
	JR	WRBUFF		;Write new auto & RETurn
;
;*=*=* Display command in auto buffer *=*=*
;
DISAUTO	CALL	GETAUTO		;p/u drive #
	@@LOGOT			;display it
	JP	NZ,IOERR	;NZ - I/O Error
	RET			;Z - done
;
;*=*=* Execute command in auto buffer *=*=*
;
EXAUTO	CALL	GETAUTO		;p/u drive #
	@@FLAGS
	LD	A,(HL)		;p/u first character
	CP	'*'		;non-<BREAK>able auto ?
	JR	NZ,DOAUTO	;no - do it
;
;*=*=* Non <BREAK>able auto command - skip "*" *=*=*
;
	INC	HL		;bump to next char
	SET	4,(IY+SFLAG$)	;Disable <BREAK>
;
;*=*=* Exit via @CMNDI or @CMNDR if requested *=*=*
;
DOAUTO	BIT	1,(IY+CFLAG$)	;If CMNDR executing, then
	LD	A,@CMNDR	;  exit via CMNDR
	JP	NZ,RST28
	DEC	A		;  else readjust to
	RST	40		;  CMNDI & exit
;
;
;********************************************************
;***						      ***
;*** GETAUTO - Get Auto Command from BOOT sector      ***
;***						      ***
;********************************************************
;
;*=*=* Advance to next byte in line *=*=*
;
GETAUTO	INC	HL		;bump to next char
	LD	A,(HL)		;& p/u 1st char of drvspc
	CALL	GETDRV		;Get drive #
	CALL	RDBOOT		;Read BOOT sector
	EX	DE,HL		;pt HL to auto buffer
	RET			;RETurn
;
;
;********************************************************
;***						      ***
;*** GETDRV - Check if (HL) contains a legal drive #  ***
;***						      ***
;********************************************************
;
;*=*=* First character a terminator ? *=*=*
;
GETDRV	CP	CR+1		;No drivespec ?
	RET	C		;use drive 0 as default
;
;*=*=* Drivespec indicator entered ? *=*=*
;
	CP	':'		;Drivespec indicator ?
	RET	NZ		;no - use drive 0
;
;*=*=* Drivespec ":" entered - p/u drive # *=*=*
;
	INC	HL		;position to drive #
	LD	B,(HL)		;p/u drive #
;
;*=*=* Position to command following drivspec *=*=*
;
	INC	HL		;position to command
	LD	A,(HL)		;C/R following spec ?
	CP	CR+1		;
	JR	C,SKIPINC	;yes - don't INC
	INC	HL		;Position to command
;
;*=*=* Is the drive number in legal range ? *=*=*
;
SKIPINC	LD	A,B		;p/u Drive #
	SUB	'0'		;Less than "0" ?
	LD	(DRIVE+1),A	;stuff away drive #
	JR	C,ILDRIVE	;C - Illegal drive #
	CP	7+1		;Greater than 7 ?
	RET	C		;RETurn if legal
;
;*=*=* Illegal Drive Number - Display & abort *=*=*
;
ILDRIVE	LD	A,32		;Illegal drive #
	JR	IOERR		;I/O error
;
;
;********************************************************
;***						      ***
;*** WRBUFF - Write Auto Command to Boot	      ***
;***						      ***
;********************************************************
;
WRBUFF	CALL	RDBOOT		;Read in BOOT
;
;*=*=* Skip Leading spaces *=*=*
;
	DEC	HL		;Skip leading spaces
SKPSPCS	INC	HL		;
	LD	A,(HL)		;p/u char
	CP	' '		;space ?
	JR	Z,SKPSPCS	;yes - skip it
;
;*=*=* Transfer command into buffer *=*=*
;
XFLP	LD	A,(HL)		;p/u byte
	LDI			;(HL) => (DE) INC HL & DE
	CP	CR+1		;eol ?
	JR	NC,XFLP		;
;
;********************************************************
;***						      ***
;*** RDBOOT/WRBOOT - Read/Write BOOT sector	      ***
;***						      ***
;********************************************************
;
;*=*=* Set A = @WRSEC Supervisory CALL # *=*=*
;
WRBOOT	LD	A,@WRSEC	;Write Sector SVC #
	JR	BOOTIO		;go to I/O routine
;
;*=*=* RDBOOT - Check if the Drive is there *=*=*
;
RDBOOT	LD	A,(DRIVE+1)	;p/u drive #
	LD	C,A		;xfer to C for @CKDRV
	@@CKDRV			;Drive alive
	LD	A,32		;init illegal drive #
	JR	NZ,IOERR	;NZ - go to error handler
;
;*=*=* Read GAT from directory if Model II *=*=*
;
	IF	@MOD2
	PUSH	IY		;save
	@@GTDCT			;locate DCT
	LD	D,(IY+9)	;dir cyl
	POP	IY		;restore
	PUSH	HL		;save
	LD	HL,BUFF		;start buffer
	LD	E,0		;GAT table
	@@RDSSC			;read directory
	LD	DE,(BUFF+60H)	;E=cyl 0 lockout byte
	POP	HL		;restore buffer
	JR	NZ,IOERR	;go on disk error
	INC	E		;cyl 0 locked out?
	LD	DE,SECTOR	;sysinfo sector
	JR	NZ,$+3		;go if not locked
	INC	D		;sysinfo on cyl 1
	LD	(SYSINFO),DE	;save sysinfo sector
	ENDIF
	LD	A,@RDSEC	;A = @RDSEC SVC #
;
;*=*=* Pt HL => Buffer, DE = T/S, C = :d, A = SVC # *=*=*
;
BOOTIO	PUSH	HL		;Save command ptr
	LD	HL,BUFF		;HL => I/O buffer
DRIVE	LD	C,$-$		;p/u drive # in C
;
	LD	DE,SECTOR	;DE = Track 0, Sector 2
SYSINFO	EQU	$-2
;
;*=*=* Issue SVC & point DE => Auto comm buffer *=*=*
;
	RST	40		;Read or Write Sector
	POP	HL		;Recover command ptr
	LD	DE,BUFF+OFFSET	;DE => Auto command buff
	RET	Z		;RETurn if successful
;
;*=*=* I/O Error Handler - Clean up stack & Abort *=*=*
;
IOERR	LD	L,A		;Set HL = Error #
	LD	H,0		;
	OR	0C0H		;Short error message
	LD	C,A		;xfer to C for @ERROR
	@@ERROR			;display error
	JP	SAVESP		;save stack & return
;
;
BUFF	EQU	$<-8+1<+8	;Next page boundary
	END	AUTO
