;KSM/ASM - LDOS 6.2 - 10/29/83
	TITLE	<KSM/FLT - LDOS 6.2.0>
;*=*=*
;	Change Log
; 02/06/83 - Corrected exit conditions on X'0D'
; 02/25/83 - Corrected NOROOM test if old high = FFFF
; 05/02/83 - Corrected pointer update if resident
;*=*=*
LF	EQU	10
CR	EQU	13
	COM '<Copyright 1982 by Logical Systems, Inc.>'
*GET	SVCMAC:3
	ORG	2400H
;
KSM
	@@CKBRKC		;check for break
	JR	Z,KSMA		; if not continue
	LD	HL,-1		; else abort
	RET
;
KSMA	LD	(KSMDCB),DE	;save ptr to DCB table
	PUSH	HL		;save ptr to cmdline buf
	@@DSPLY	HELLO$		;display copyright msg
	@@FLAGS			;Get device flag
	POP	HL		;rcvr cmndline pointer
;*=*=*
;	Check if entry from SET command
;*=*=*
	BIT	3,(IY+'C'-'A')	;System request?
	JP	Z,VIASET
	LD	DE,KSMFCB	;point to FCB
	@@FSPEC			;fetch the KSM filespec
	JP	NZ,SPCREQ	;jump on bad spec
	PUSH	DE		;Save FCB pointer
	LD	DE,PRMTBL$	;Load param table pointer
	@@PARAM			;parse parms
	POP	DE		;Recover FCB pointer
	JP	NZ,IOERR	;go on error
	LD	HL,DFTKSM	;init to default ext
	@@FEXT			;fetch if not entered
;*=*=*
;	Transfer requested ENTER char to test loc
;*=*=*
EPARM	LD	HL,';'		; set default ";"
	LD	A,(ERSP)	;Test parm response
	BIT	6,A		;Flag is no good!
	JP	NZ,PRMERR
	BIT	5,A		;Test string or value
	LD	A,(HL)		;P/u assumed string
	JR	NZ,$+3		;Go if string entry
	LD	A,L		;P/u hex or dec entry
	LD 	(ECHAR+1),A	;stuff it in there
	PUSH	DE
	LD	DE,KSM$		;Check if filter is
	@@GTMOD			;  already resident
	LD	(KSMMEM+1),HL	;Stuff start
	EX	DE,HL		;Put DCB ptr to HL
	POP	DE
	JR	NZ,OPENKSM	;Go if not
;*=*=*
;	Make sure that the new DCB is same as the old
;*=*=*
	PUSH	HL		;Save where to stuff
	LD	C,(HL)		;P/u DCB pointer LSB
	INC	HL
	LD	B,(HL)		;P/u DCB pointer MSB
	LD	HL,6		;Get old DCB name &
	ADD	HL,BC		;  stuff into error
	LD	A,(HL)		;  message in case
	INC	L		;  a different DCB
	LD	H,(HL)		;  is referenced
	LD	L,A
	LD	(DCBNAM$),HL
	OR	H		;If DCB name is null,
	LD	HL,(KSMDCB)
	PUSH	HL		;Save pointer to stuff
	JR	Z,UPDPTR	;  then OK to use
	OR	A
	SBC	HL,BC		;Same DCB pointer?
UPDPTR	POP	BC		;Rcvr pointer to stuff
	POP	HL		;Rcvr address to put pointer
	JP	NZ,DCBERR
;*=*=*
;	Same DCB - Okay to stuff
;*=*=*
	LD	(HL),C
	INC	HL
	LD	(HL),B
KSMMEM	LD	HL,$-$		;If res, ptr to start
	LD	BC,ECHAR-DVRBGN+1
	ADD	HL,BC		;Resident, stuff ECHAR
	LD	A,(ECHAR+1)	;  where it is in memory
	LD	(HL),A		;Stuff in upper mem
OPENKSM	LD	HL,KSMBUF	;pt to buffer area
	LD	B,0		;init LRL=256
	@@OPEN			;open the file
	JP	NZ,IOERR	;jump on open error
	LD	HL,DVREND	;Place file in memory 1st
	LD	B,26		;init for 26 lines
KSM1	@@GET			;get a char from file
	JR	NZ,KSM2		;jump on error
	LD	(HL),A		;stuff into memory
	INC	HL		;inc memory pointer
	CP	CR		;found end-of-line?
	JR	NZ,KSM1		;loop if not
	DJNZ	KSM1		;decrement the A-Z loop
	DEC	HL		;Backup over last CR &
	INC	B		;  adjust for one more
	LD	A,1CH		;No error here, just EOF
KSM2	PUSH	AF		;Save error code
	@@CLOSE			;Close the file
	POP	AF
	CP	1CH		;ck for eof
	JP	NZ,IOERR	;jump on not eof error
KSM3	LD	(HL),CR		;end with a <ENTER>
	INC	HL		;for all remaining
	DJNZ	KSM3		;"letters" not entered
	LD	IX,(KSMDCB)	;rcvr user DCB entry
	LD	DE,DVREND	;Calculate the length
	XOR	A		; of the KSM file just
	SBC	HL,DE		; loaded
	LD	B,H		;Xfer length
	LD	C,L
	LD	HL,(KSMMEM+1)	;If not previously res,
	LD	A,L		; move to HIGH$
	OR	H
	JR	Z,MOVTOHI
	PUSH	BC		;Save length
	PUSH	HL		;Save old start
	ADD	HL,BC		;Start + data
	JR	C,KSM3A		;Bad if wrap past 0
	LD	BC,DVREND-DVRBGN+1
	ADD	HL,BC		;start + data + filter
	JR	C,KSM3A		;Bad if wrap past 0
	EX	DE,HL		;Save in reg DE
	POP	HL		;Rcvr old start
	INC	HL		;Pt to last byte used
	INC	HL
	LD	A,(HL)		;P/u last byte used
	INC	HL
	LD	H,(HL)
	LD	L,A
	PUSH	HL
	XOR	A		;Clear carry flag
	SBC	HL,DE		;Is req > available?
KSM3A	POP	HL		;Rcvr old start to reuse
	POP	BC		;Rcvr length of req
	JP	C,NOROOM
	JR	KSM0A
MOVTOHI	PUSH	BC		;Save data length
	LD	HL,0		;p/u current high memory
	LD	B,L
	@@HIGH$
	POP	BC		;Recover data length
KSM0A	LD	(DVRBGN+2),HL	;Stuff last byte used
	LD	(RX1),HL	;stuff ptr to flag byte
	LD	(HL),0		;init the KSM char ptr
	DEC	HL		;  to zero to show no
	LD	(HL),0		;  char avail at startup
	DEC	HL
	LD	DE,DVREND	;Move data to high
MOVLP	LD	A,(DE)		;Data is in reverse order
	LD	(HL),A
	DEC	HL
	INC	DE
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,MOVLP
	LD	BC,DVREND-DVRBGN
	XOR	A		;Reduce potential HIGH$
	SBC	HL,BC		; by driver length
	LD	A,(KSMMEM+1)	;Don't update HIGH$
	OR	A		;  if previously res
	JR	Z,DOHIGH	;Go if not resident
;*=*=*
;	Module already resident
;*=*=*
	LD	DE,(KSMMEM+1)	;P/u module entry point
	LD	HL,KSMRPL$	;  & reuse the filter
	JR	KSM8
;*=*=*
;	Stuff new HIGH$ value (Note: B=0 for driver
;	length so there is no damage on the @@HIGH$ SVC
;*=*=*
DOHIGH	LD	B,0
	@@HIGH$
	INC	HL
	EX	DE,HL
	PUSH	DE		;Save start of driver
	LD	HL,KSMDCB-DVRBGN
	ADD	HL,DE		;Point to filter DCB ptr
	LD	(RX2),HL
	LD	HL,DVRBGN	;Move parms also
	LDIR
	POP	DE		;rcvr driver ept
	LD	HL,KSMACT$	;Advise KSM installed
KSM8	LD	(IX),40H!5	;init DCB type to "input"
	LD	(IX+1),E	;  & filter & stuff the
	LD	(IX+2),D	;  filter address
	SET	6,(IY+'D'-'A')	;Turn on device flag bit
	@@LOGOT
	LD	HL,0
	RET
;*****
;	error processing
;*****
VIASET	LD	HL,VIASET$
	DB	0DDH
DCBERR	LD	HL,DCBERR$
	DB	0DDH
NOROOM	LD	HL,NOROOM$
	DB	0DDH
SPCREQ	LD	HL,SPCREQ$
	@@LOGOT
	LD	HL,-1
	RET
PRMERR	LD	A,44		;init PARM ERROR
IOERR	LD	L,A
	LD	H,0
	OR	0C0H
	LD	C,A
	@@ERROR
	RET
;*****
;	data and message area
;*****
KSM$	DB	'$KSM',3
DFTKSM	EQU	$		;Note: HELLO$ must follow
HELLO$	DB	'KSM Filter'
*GET	CLIENT:3
;
VIASET$	DB	'Must install via SET',CR
SPCREQ$	DB	'Filespec required',CR
KSMACT$	DB	'KSM is now operational',CR
KSMRPL$	DB	'KSM filter data replaced',CR
DCBERR$	DB	'KSM filter already attached to *xx',CR
DCBNAM$	EQU	$-3
NOROOM$	DB	'Request exceeds available memory',CR
PRMTBL$	DB	'R'!80H,0F5H,'ENTER',0
ERSP	EQU	$-1
	DW	EPARM+1
	DB	0
KSMFCB	DEFS	32
KSMBUF	DEFS	256
;*****
;	Key-Stroke Multiplication driver
;*****
DVRBGN	JR	START
	DW	$-$		;Last byte used
	DB	4,'$KSM'
KSMDCB	DW	$-$		;Pointer to KSM's DCB
	DW	0
START	LD	HL,0		;p/u possible address to
RX1	EQU	$-2
	LD	D,(HL)		;  a KSM that was parsed
	DEC	HL		;  to a ';' logical ENTER
	LD	E,(HL)		;If this vector is zero,
	DEC	HL		;  no KSM continuation is
	EX	DE,HL		;  pending - find a new
	PUSH	AF		;  entry. Save flags.
	LD	A,H		;  If <> 0, grab the KSM
	OR	L		;  line continuation
	JR	NZ,DVR4A	;  pronto!
	POP	AF		;Rcvr flags
	PUSH	DE		;save ptr to 'A'-KSM
DVR1	LD	IX,(KSMDCB)	;Chain to next DCB module
RX2	EQU	$-2
	@@CHNIO
	POP	DE		;rcvr 'A'-KSM pointer
	RET	NZ		;Back if nothing or error
	BIT	7,A		;Is it a CLEAR function?
	RET	Z		;ret if <CLEAR> not down
	PUSH	AF		;save key entry
	CP	'A'+80H		;ck for range A-Z
	JR	C,DVR2		;exit if < 'A'
	CP	'Z'+1+80H
	JR	C,DVR3		;use it if A-Z
DVR2	POP	AF		;rcvr orig flag
	CP	A		;Set Z-flag
	RET
;*****
;	key code entry includes <CLEAR> key
;*****
DVR3	POP	AF		;rcvr orig flag
	LD	H,D		;rcvr ptr to 'A'-KSM
	LD	L,E		;  & xfer to reg HL
	SUB	80H+'A'		;adjust offset to index
	JR	Z,DVR5		;bypass if was 'A'
	LD	B,A		;set loop counter
	LD	A,CR		;read past the KSM lines
DVR4	CP	(HL)		;  for letters preceding
	DEC	HL		;  key entry to find the
	JR	NZ,DVR4		;  KSM line for entered
	DJNZ	DVR4		;  key code
	DB	3EH		;Ignore next inst
;*****
;	routine to pick up the next KSM character
;	& return it to the system KI request
;*****
DVR4A	POP	AF		;Clean the stack
DVR5	LD	A,(HL)		;p/u the next KSM char
	DEC	HL		;dec pointer to next one
	EX	DE,HL		;Put either a pointer to
	INC	HL		;  the next KSM char to
	CP	CR		;If got last, zero the
	JR	Z,DVR6		;  data pointer
	LD	(HL),E		;Stuff pointer to next
	INC	HL		;  character to fetch
	LD	(HL),D		;
ECHAR	CP	';'		;ck on logical line end
	JR	NZ,DVR7		;  & convert to <ENTER>
	LD	A,CR		;  if it was semi-colon
DVR7	CP	A		;tell the system we have
	RET			;  retrieved a char
;*=*=*
;	Got the terminating X'0D' - Clear the pointer
;*=*=*
DVR6	XOR	A		;Clear the KSM char ptr
	LD	(HL),A		;  as next request is new
	INC	HL
	LD	(HL),A
	CP	0FFH		;Set NZ & A = 0
	RET
DVREND	EQU	$
	END	KSM
