;FORMS/FLT - LDOS 6.2 - 10/29/83
	TITLE	'<Device forms formatter>'
;*=*=*
;	Change Log
; 05/14/83 - Check for error on soft formfeed
; 05/20/83 - give msg if loaded high
; 05/26/83 - Don't destroy MODDCB when cking residentcy
; 10/07/83 - Set bit-5 of DFLAG$ when filter installs
;
;*=*=*
LF	EQU	10
CR	EQU	13
	COM '<Copyright 1982 by Logical Systems, Inc.>'
*GET	SVCMAC:3
	SUBTTL	'<Driver Initialization Routines>'
	ORG	2400H
;
BEGIN
	@@CKBRKC		;Check for break
	JR	Z,BEGINA	; go if no break
	LD	HL,-1
	RET			; else abort
;
BEGINA	PUSH	DE		;save DCT address
	POP	IX		;  in index reg
	LD	(PFDCB),DE	;Stuff prologue
	@@DSPLY	HELLO$		;Welcome the user
;*=*=*
;	Check if entry from SET command
;*=*=*
	@@FLAGS
	BIT	3,(IY+'C'-'A')	;System request?
	JP	Z,VIASET
;*=*=*
;	Check if filter is already resident
;*=*=*
	LD	DE,FF$		;Check if filter is
	@@GTMOD			;  already resident
	EX	DE,HL		;Put DCB ptr to HL
	JR	NZ,NOTRES	;Go if not
;*=*=*
;	Make sure that the new DCB is same as the old
;*=*=*
	LD	BC,(PFDCB)	;Replace DCB pointer
	LD	A,C		;  with new one
	LD	C,(HL)		;P/u DCB pointer LSB
	NOP
	INC	HL
	LD	A,B
	LD	B,(HL)		;P/u DCB pointer MSB
	LD	HL,6		;Get old DCB name &
	ADD	HL,BC		;  stuff into error
	LD	A,(HL)		;  message in case
	INC	L		;  a different DCB
	LD	H,(HL)		;  is referenced
	LD	L,A
	LD	(DCBNAM$),HL	;Stuff message with spec
	OR	H
	JR	Z,ISRES
	LD	HL,(PFDCB)	;P/u DCB existing DCB
	OR	A		;  pointer
	SBC	HL,BC		;Same DCB pointer?
	JP	NZ,DCBERR	;Can't install if diff
	JR	ISRES
;*=*=*
;	Module is not resident
;*=*=*
NOTRES	LD	DE,'IK'
	@@GTDCB			;Locate low memory ptr
	JP	NZ,IOERR
	DEC	L
	LD	D,(HL)		;P/u pointer to
	DEC	L		;  start of free
	LD	E,(HL)		;  low core
	LD	(LCPTR+1),DE	;Save loc for later
	PUSH	HL		;Save low core ptr
	LD	HL,PFEND-PFFLT
	ADD	HL,DE		;Start + driver length
	PUSH	HL
	DEC	HL		;Point to last byte
	LD	(SVEND+1),HL
	LD	BC,1300H	;Max addr + 1
	XOR	A
	SBC	HL,BC
	POP	DE		;Rcvr new lc
	POP	HL		;Rcvr low core ptr
	JR	C,PUTLOW	;If room, put low
;*=*=*
;	Check if high memory available
;*=*=*
	@@FLAGS
	BIT	0,(IY+'C'-'A')	;Memory frozen?
	JP	NZ,NOROOM	;"No memory...
	LD	HL,0		;Get HIGH$
	LD	B,L
	@@HIGH$
	LD	(SVEND+1),HL
	LD	E,L		;Xfer new last
	LD	D,H		;  to reg DE
	XOR	A		;Calc new start
	LD	BC,PFEND-PFFLT
	SBC	HL,BC
	LD	B,0
	@@HIGH$			;Set new HIGH$
	INC	HL		;Point to new start
	EX	DE,HL
	PUSH	DE
	CALL	RELO
	POP	DE
	LD	A,0FFH
	LD	(HGHFLG),A	;flag to notify user
	JR	MOVMOD
;*=*=*
;	Room in low core - move driver low
;*=*=*
PUTLOW	LD	(HL),E		;Stuff low core ptr
	INC	L		;  with new low
	LD	(HL),D
	CALL	RELO		;Relocate vectors
LCPTR	LD	DE,$-$		;Low core pointer
;*=*=*
;	Move module to memory
;*=*=*
MOVMOD	PUSH	DE		;Save start
	LD	HL,PFFLT
	LD	BC,PFEND-PFFLT	;Calc driver length
	LDIR
	POP	DE		;Pop filter start
	SET	5,(IY+'D'-'A')	;Set PF in DFLAG$
;
ISRES	LD	HL,PFACT$	;Advise FORMS installed
	LD	(IX),40H!7	;init DCB type to "C/P/G"
	LD	(IX+1),E	;  & filter & stuff the
	LD	(IX+2),D	;  filter address
	@@LOGOT
	LD	A,$-$
HGHFLG	EQU	$-1	;flag filter went high
	OR	A
	JR	Z,NTHGH
	LD	HL,HMEM$
	@@LOGOT
NTHGH	LD	HL,0	;no error
	RET
;*=*=*
;	Relocate internal references in driver
;*=*=*
RELO	PUSH	IX
	LD	IX,RELTAB	;Point to relocation tbl
SVEND	LD	HL,$-$		;Find distance to move
	LD	(PFFLT+2),HL	;Set last byte used
	LD	DE,PFEND-1
	OR	A		;Clear carry flag
	SBC	HL,DE
	LD	B,H		;Move to BC
	LD	C,L
	LD	A,TABLEN	;Get table length
RLOOP	LD	L,(IX)		;Get address to change
	LD	H,(IX+1)
	LD	E,(HL)		;P/U address
	INC	HL
	LD	D,(HL)
	EX	DE,HL		;Offset it
	ADD	HL,BC
	EX	DE,HL
	LD	(HL),D		;And put back
	DEC	HL
	LD	(HL),E
	INC	IX
	INC	IX
	DEC	A
	JR	NZ,RLOOP	;Loop till done
	POP	IX
	RET
;*=*=*
;	Error exits
;*=*=*
VIASET	LD	HL,VIASET$
	DB	0DDH
DCBERR	LD	HL,DCBERR$
	DB	0DDH
NOROOM	LD	HL,NOROOM$
	@@LOGOT
	LD	HL,-1
	RET
IOERR	LD	L,A
	LD	H,0
	OR	0C0H
	LD	C,A
	@@ERROR
	RET
;*=*=*
;	Messages & Data tables
;*=*=*
FF$	DB	'$FF',3
HELLO$	DB	'FORMS Filter'
*GET	CLIENT:3
;
VIASET$	DB	'Must install via SET',CR
NOROOM$	DB	'No memory space available',CR
DCBERR$	DB	'Filter already attached to *xx',CR
DCBNAM$	EQU	$-3
PFACT$	DB	'Forms filter is now resident',CR
HMEM$	DB	LF,'Note: filter installed in high memory.',CR
;
;*=*=*
;	Printer Filter - PF
;	Provides hard or soft form feed, line wraparound,
;	automatic form feeds between pages, tabs, blank
;	lines, 1 byte translation table, left margins,
;	and set-top-of-form character.  Compatible with
;	LDOS 6.2 spooler.
;*=*=*
*MOD
PFBIT	EQU	3	;Position in DFLAG
SPLBIT	EQU	0	;Position in DFLAG
LF	EQU	10
CR	EQU	13
PFFLT	JR	PFBGN		;Branch around linkage
	DW	PFEND-1		;Last byte used
	DB	3,'$FF'		;Name length/name
PFDCB	DW	$-$		;Link to DCB
	DW	0
;*=*=*
;	Filter data area
;*=*=*
PFDATA$	EQU	$
PMAX	EQU	$-PFDATA$
	DB	66	;Page size (max lines per page)
LCOUNT	EQU	$-PFDATA$
	DB	0	;Line counter
LMAX	EQU	$-PFDATA$
	DB	66	;Max lines to pront
CCOUNT	EQU	$-PFDATA$
	DB	0	;Chas per line printed
XL1	EQU	$-PFDATA$
	DB	0	;Translate from
XL2	EQU	$-PFDATA$
	DB	0	;Translate to
INDENT	EQU	$-PFDATA$
	DB	0	;Indent after line wraparound
ADDLF	EQU	$-PFDATA$
	DB	4	;Bit-0, LF after CR; bit-1=FF
;			;  Bit-2, TAB expand (1)
CMAX	EQU	$-PFDATA$
	DB	0	;Max CPL before wraparound
MARGIN	EQU	$-PFDATA$
	DB	0	;Left hand margin
;*=*=*
;	Start of filter
;*=*=*
PFBGN	JR	Z,$?1		;Go if @PUT
	DB	011H		;Ignore next inst
PFPUT	LD	B,2		;Init for @PUT
	PUSH	IX
	LD	IX,(PFDCB)	;Grab the DCB vector
RX01	EQU	$-2
	@@CHNIO			;  & chain to it
	POP	IX
	RET
;*=*=*
;	Peform the tab function
;*=*=*
$?16	LD	A,(IX+CCOUNT)	;How many spaces to
	AND	7		;  next tab stop?
	SUB	8
	NEG
	JR	$?5		;Space over to it
;
;*=*=*
;	Filter code
;*=*=*
$?1	LD	IX,PFDATA$	;Base register
RX02	EQU	$-2
;
$?2	LD	A,(IX+XL1)	  ;Get xlate in
	CP	C		;Translate this char?
	JR	NZ,$?3		;Go if not xlated char
	LD	A,(IX+XL2)	;Xlated to this
	LD	C,A
$?3	LD	A,C		;P/u char to test
	CP	CR	  	;CR?
	JR	Z,$?11
	CP	LF	  	;LF?
	JR	Z,$?11
	CP	0CH	  	;FF?
	JR	Z,$?12
	BIT	2,(IX+ADDLF)	;Expand tabs?
	JR	Z,$?3A
	CP	9		;Tab?
	JR	Z,$?16
$?3A	CP	6	  	;SET TOF?
	JR	Z,$?15
	CP	20H		;Other control code?
	JR	C,PFPUT		;Pass on unchanged if so
;*=*=*
;	Got a character to output
;*=*=*
	LD	A,(IX+MARGIN)	;Left margin to do?
	AND	A
	CALL	NZ,$?17		;Call if so
RX03	EQU	$-2
$?4	CALL	Z,PFPUT		;Now put the char
RX04	EQU	$-2
	RET	NZ
;*=*=*
;	Do the end of line check
;*=*=*
	INC	(IX+CCOUNT) 	;Inc char counter
	LD	A,(IX+CMAX)	;Wraparound needed?
	AND	A
	RET	Z		;Quit if feature is off
	DEC	A
	CP	(IX+CCOUNT)
	JR	NC,$?18		;Done if not needed
	CALL	$?11		;Do carriage return
RX05	EQU	$-2
	RET	NZ
;*=*=*
;	Check on indent needed
;*=*=*
	LD	A,(IX+INDENT)  	;Do indent
	AND	A
	RET	Z	   	;Done if none
$?5	PUSH	BC	 	;In case of recursive
	LD	B,A		;  calls
	LD	C,' '		;Print spaces
$?6	PUSH	BC		;Save counter
	XOR	A
	CALL	$?4
RX06	EQU	$-2
	POP	BC		;Recover counter
	JR	NZ,$+4		;Exit on PUT error
	DJNZ	$?6
	POP	BC
	RET
$?8	LD	A,(IX+CCOUNT)
	AND	A	   	;Line empty?
	LD	C,CR		;Do CR if not
	JR	NZ,$?10
$?9	LD	C,LF		;Do LF if so
$?10	CALL	PFPUT
RX07	EQU	$-2
	LD	(IX+CCOUNT),0	;Starting new line
	RET
;
$?11	CALL	$?7		;CRLF & check if page end
RX08	EQU	$-2
	RET	NZ
;
	INC	(IX+LCOUNT)
	LD	A,(IX+LCOUNT) 	;Time to do form feed?
	CP	(IX+LMAX)
	JR	C,$?18	   	;Return if not
;
$?12	LD	A,(IX+PMAX)  	;How many lines to feed?
	SUB	(IX+LCOUNT)
	JR	Z,$?15		;Skip if zero
	PUSH	BC	 	;In case called by $?16
	LD	B,A
	BIT	1,(IX+ADDLF)  	;Hardware form feed?
	JR	Z,$?13		;Go if not
	LD	C,0CH
	CALL	PFPUT
RX09	EQU	$-2
	JR	$?14
$?13	PUSH	BC
	CALL	$?7		;Do LF's
RX10	EQU	$-2
	POP	BC
	JR	Z,CHRGONE	;This linefeed sent OK
	POP	BC		; else clean stack
	RET			; and return error
CHRGONE	DJNZ	$?13
$?14	POP	BC
;*=*=*
;	Set the top-of-form
;*=*=*
$?15	LD	(IX+LCOUNT),0	;Reset line counter
$?18	CP	A
	RET
$?7	BIT	0,(IX+ADDLF)
	JR	Z,$?8		;Go if hardware auto-LF
	LD	C,CR		;Else do CR and LF
	CALL	PFPUT
RX11	EQU	$-2
	RET	NZ
	JR	$?9
;*=*=*
;	Perform the margin function
;*=*=*
$?17	INC	(IX+CCOUNT)	;Back if we don't
	DEC	(IX+CCOUNT)	;  need the margin
	JR	Z,$?5		;Do left margin
	XOR	A
	RET
PFEND	EQU	$
RELTAB	DW	RX01,RX02,RX03,RX04,RX05,RX06,RX07,RX08
	DW	RX09,RX10,RX11
TABLEN	EQU	$-RELTAB/2
	END	BEGIN
