;FORMAT1/ASM - LDOS 6.2 - 11/02/83
	TITLE	<FORMAT - LDOS 6.2>
;*=*=*
;	Change Log
; 05/04/83 - Corrected @MULT8 call
; 05/07/83 - Corrected MAJOR screw up by ROY in setting
;	     up register "D" before calling the FDCDVR
; 08/20/83 - Change boot sector of data disk to not use
;            ROM during boot process.
; 10/18/83 - Changed interleave and skew for 5 & 8 DDEN
;
;*=*=*
PASSWORD	EQU	42E0H
RLS	EQU	62H
LF	EQU	10
CR	EQU	13
CRT3	EQU	3C00H
CRT4	EQU	0F800H
*GET	SVCMAC:3
 COM	'<(C) 1982 by LSI>'
*LIST	ON
	ORG	2600H
	IF	@MOD4
BOOTST$	DB	9DH		;Boot step rate offset
	ENDIF
	IF	@MOD2
BOOTST$	DB	03H
	ENDIF
GOFMT	BIT	4,(IY+4)	;jump if alien controller
	JP	NZ,HRDRV
FMTTBL	LD	DE,0		;P/u table pointer
	LD	A,(DE)		;P/u # of sectors to fmt
	INC	DE		;Adj for zero offset
	LD	(SECTRK),A
	LD	B,A
	BIT	5,(IY+4)	;Need twice as many
	JR	Z,$+3		;  if 2-sided drive
	RLCA
	LD	(SECCYL),A
SYSPRM	LD	HL,0		;P/u system info only
	LD	A,H		;Don't format if system
	OR	L		;  info only is req
	JP	NZ,MOVFREE
	LD	A,(DE)		;P/u track skew (3,5,2,3)
	INC	DE
	LD	(TRKSKEW+1),A
	LD	(SECSKEW+1),DE	;Format sector skew
	INC	A		;Add DE -> begin of sec #
	ADD	A,B		;B -> # of sectors/side
	ADD	A,E		; A+1 -> a code byte
	LD	E,A
	ADC	A,D
	SUB	E
	LD	D,A
	LD	HL,FORMAT
	LD	BC,HITBUF
;*****
;	create the formatting data
;*****
FMTDAT	LD	A,(DE)		;P/u table format byte
	INC	DE
	CP	0F1H		;Start of sector header
	JR	Z,CODF1
	CP	0F2H		;Start of track trailer
	JR	Z,CODF2
	CP	0F3H		;Start of track ID info
	JR	Z,CODF3
	CP	0F4H		;End of table parms?
	JR	Z,CODF4
	CP	0F5H
	PUSH	BC
	JR	NZ,CODE1
	LD	A,(DE)
	INC	DE
	LD	B,A		;Xfer header count
	LD	A,(DE)		;P/u a header byte
	INC	DE
	LD	C,A		;Xfer 1st byte
	LD	A,(DE)		;P/u 2nd byte
CODF5	LD	(HL),C		;Stuff into buf
	INC	HL
	LD	(HL),A
	INC	HL
	DJNZ	CODF5
	JR	CODRET
CODE1	LD	B,A
	LD	A,(DE)
CODE1A	LD	(HL),A		;Fill buf with byte
	INC	HL
	DJNZ	CODE1A
CODRET	POP	BC
	INC	DE
	JR	FMTDAT
CODF1	LD	A,(SECTRK)	;P/u # of sectors/side
CODF1A	PUSH	DE		;Save table pointer
	PUSH	AF		;Save value
	JR	FMTDAT
CODF2	POP	AF		;Count down the # of
	DEC	A		;  sectors to format
	JR	Z,CODF2A
	POP	DE		;Loop if not finished
	JR	CODF1A
CODF2A	POP	AF
	JR	FMTDAT
CODF3	LD	A,L		;Stuff pointer to where
	LD	(BC),A		;  track & sector info
	INC	BC		;  is to be placed
	LD	A,H
	LD	(BC),A
	INC	BC
	JR	FMTDAT
CODF4	LD	(VERSKEW+1),DE	;Verify sector skew
	XOR	A		;Stuff two X'00's to
	LD	(BC),A		;  indicate the end
	INC	BC
	LD	(BC),A
	LD	B,0		;Now give it 256 X'FF's
	LD	A,0FFH
	LD	(HL),A
	INC	HL
	DJNZ	$-2
;*=*=*
;	Begin the formatting
;*=*=*
	@@DSPLY	FMTCYL$		;"formatting clinder...
BGNFMT	LD	A,(IY+5)	;P/u cylinder position
	CALL	CVDEC		;Cvrt to decimal
	CALL	DSPCYL
SECSKEW	LD	BC,0		;Begin of sector table
BFMT1	LD	HL,HITBUF	;P/u ptr to memory 
;
BFMT2
	@@CKBRKC		;Check for break
	JP	NZ,BREAK	;go if so
;
	LD	E,(HL)		;  positions having
	INC	HL		;  sector & cylinder
	LD	D,(HL)		;  info to be stuffed
	INC	HL		;  into format data
	LD	A,D		;Finished?
	OR	E
	JR	Z,BFMT4
	LD	A,(IY+5)	;P/u cylinder # & stuff
	LD	(DE),A		;  into format data
	INC	DE
	LD	A,(IY+3)	;Stuff the side-select
	AND	10H		;  bit
	RRCA
	RRCA
	RRCA
	RRCA
	LD	(DE),A
	INC	DE
	LD	A,(BC)		;P/u the sector number
	OR	A
	JP	P,BFMT3		;Bypass if a sector #
	ADD	A,C		;Calculate the beginning
	LD	C,A		;  of the sector table
	JR	C,BFMT3
	DEC	B
BFMT3	LD	A,(BC)
	LD	(DE),A		;Stuff the sector #
	INC	DE
	INC	BC
	JR	BFMT2
BFMT4	LD	(SECSKEW+1),BC	;Save end of sector table
	LD	D,(IY+5)	;P/u current cylinder
	LD	HL,FORMAT	;Pt to format data
	CALL	SELECT		;Drive select
	JP	NZ,IOERR	;go on error
	CALL	WRCYL		;Cylinder write
	JP	NZ,IOERR
	BIT	5,(IY+4)	;Double sided?
	JR	Z,BFMT5
	BIT	4,(IY+3)	;Flip bit for 2nd side
	JR	NZ,BFMT5	;  if not already on it,
	SET	4,(IY+3)	;  else go to next
	INC	BC		;Bump to start side 2
	JR	BFMT1		;  at different sector #
BFMT5	RES	4,(IY+3)	;Turn off side 2
TRKSKEW	LD	A,0		;P/u the track skew byte
	ADD	A,C		;Repoint to beginning
	LD	C,A		;  of sector table
	ADC	A,B		;Skew start of next track
	SUB	C
	LD	B,A
	LD	(SECSKEW+1),BC
	LD	A,(IY+5)	;Finished?
	CP	(IY+6)
	JR	Z,BGNVER
	LD	BC,1000/15	;Approx 1 ms pause
	@@PAUSE			;  before STEPIN
	CALL	STEPIN		;Step in
	JP	NZ,IOERR	;go on error
	LD	BC,BGNFMT	;Place RET addr on stack
CKWAIT	CALL	RSELCT		;Wait for idle FDC
	JP	NZ,IOERR	;go on error
	PUSH	BC		;Save RET addr
;*=*=*
;	WAIT parameter for time delay after STEPIN
;*=*=*
WAITPRM	LD	BC,3000/15	;Approx 3 ms delay
	LD	A,B		;  after STEPIN
	OR	C
	RET	Z		;Do next track if no wait
	@@PAUSE			;  else wait for count
	RET
;*****
;	begin the verification process
;*****
BGNVER	LD	C,CR
	@@DSP
	CALL	RESTOR		;Restore to cyl 0
	JR	NZ,BVER9	;go on error
	@@DSPLY	VERCYL$		;"verifying cylinder...
	LD	D,0		;Init track ctr
BVER1
	@@CKBRKC		;Check for break
	JP	NZ,BREAK	; abort if so
;
	LD	L,D		;Pt to GAT byte for this
	LD	H,GATBUF<-8	; track & bypass verify
	LD	A,(HL)		; if track not formatted
	INC	A
	JR	Z,BVER8
;
	LD	A,D
	CALL	CVDEC		;Cvrt to decimal
	PUSH	DE
	CALL	DSPCYL
	POP	DE
	XOR	A		;Initialize starting
	LD	(BVER5+1),A
	LD	(BVER4+1),A
VERSKEW	LD	BC,0		;P/u start of sector tbl
BVER3	LD	A,(BC)		;P/u sector #
BVER4	ADD	A,0		;Add in a side's sectors
	LD	E,A		;  if on side 2
	CALL	VERSEC		;Sector verify
	JR	NZ,BVER9	;Go on error
	INC	BC		;Bump sector table ptr
BVER5	LD	A,0		;P/u sector #
	INC	A		;Bump it up
	LD	(BVER5+1),A	;  and save new #
	LD	E,A		;Xfer to sector register
	LD	A,(SECCYL)	;Is this = a cyl?
	CP	E
	JR	Z,BVER8		;Go if cyl done
	LD	A,(SECTRK)	;Is this a track's worth?
	CP	E
	JR	NZ,BVER3	;Loop if not
	LD	(BVER4+1),A	;Update the add for side2
	INC	BC
	JR	VERSKEW
;*=*=*
;	readjust for end of cylinder
;*=*=*
BVER8	LD	A,D		;P/u current cyl position
	INC	D		;Bump to next cyl
	CP	(IY+6)		;Cp to highest # cyl
	LD	BC,BVER1	;Go if more to verify
	JR	NZ,CKWAIT	;  after checking WAIT
;*=*=*
;	Shift the FREE table to LOCKOUT table
;*=*=*
MOVFREE	LD	HL,GATBUF
	LD	DE,GATBUF+60H
	LD	B,0
	LD	C,(IY+6)
	INC	C
	LDIR
	LD	C,CR
	@@DSP
	JR	CALCDIR
;*=*=*
;	Got verify error
;*=*=*
BVER9	CP	5		;Data rec not found?
	JR	Z,BVER10
	CP	4		;Parity error?
	JP	NZ,IOERR
BVER10	PUSH	DE
	@@DSPLY	STAR$		;Show the * lockout
	POP	DE
	LD	L,D
	LD	H,GATBUF<-8
	LD	(HL),0FFH	;Lockout this cylinder
	JR	BVER8
;*****
;	Hard drive format - most work done by controller
;*****
HRDRV	LD	HL,LASTMSG	;Give one last chance to
	BIT	3,(IY+3)	;  abort before wiping
	JR	Z,AFLOP		;  disk unless floppy
	CALL	GET3		;Is hard, get response
	LD	A,(HL)		;P/u 1st char of resp
	CP	'Y'		;Must be yes to continue
	JP	NZ,FMTABT
AFLOP	LD	A,(SYSPRM+1)	;Bypass the formatting
	OR	A		; if system info only
	JR	NZ,HRDRV1
	@@DSPLY	FMTG$		;"formatting - be patient
	CALL	FMTHD		;Format hard drive
	JP	NZ,IOERR
HRDRV1	LD	A,(IY+7)	;# of sectors/gran
	LD	D,A		;-> reg E
	AND	1FH
	LD	E,A
	INC	E		;Bump for 0 offset
	XOR	D
	RLCA			;Get # of heads
	RLCA			;Into reg D
	RLCA
	INC	A		;Adjust for zero offset
	LD	C,A
	@@MUL8			;Multiply E x C
	BIT	5,(IY+4)	;2-sided?
	JR	Z,$+3
	ADD	A,A		;Twice the number
	LD	(SECCYL),A
	BIT	3,(IY+3)	;Floppy?
	JR	Z,MOVFREE	;Form lock table instead
;*****
;	routine to calculate the directory cylinder
;*****
CALCDIR	CALL	RESTOR		;Step in
	JP	NZ,IOERR	;go on error
	LD	H,GATBUF<-8
	LD	L,(IY+6)	;P/u highest # cylinder
DIRPARM	LD	BC,0000		;P/U 'DIR=' parm
	LD	A,C		;Ckeck if entered
	OR	B		; test it
	JR	Z,NODIR		;calc one if not
	CP	L		;Entered so check if
	JR	NC,NODIR	; within cylinders
	LD	L,A		;Is ok, use it
	JR	DIRSET
NODIR	INC	L		;Adj for zero offset
	SRL	L		;Divide by 2 to find
DIRSET	LD	C,0		;Disk midpoint
;*****
;	perform expanding binary search to find
;	a cylinder available for the directory
;*****
CALC1	LD	A,(HL)		;Is this cylinder
	INC	A		;Available or locked out?
	JR	NZ,GENSYS	;Bypass if available
	INC	C		;Bump C
	LD	A,C
	RRCA			;Test if odd or even
	LD	A,L		;Get current test pos
	JR	NC,CALC2	;jump if C was even
	ADD	A,C		;Add to previous pos
	LD	L,A
	CP	(IY+6)		;Go over the top?
	JR	NZ,CALC1	;Loop if not
	JR	CALC3		;Else abort
CALC2	SUB	C		;Try a lower cylinder #
	LD	L,A
	JR	NZ,CALC1	;At cylinder 0?
CALC3	LD	HL,NOCYL$	;"no dir space avail...
	JP	FMTABT
;*=*=*
;	Generate the system initialization
;*=*=*
GENSYS	LD	(IY+9),L	;Stuff the dir cyl
	LD	A,L
	CALL	CVDEC		;Cvrt reg A to 2 dec digs
	LD	(DIRASC$),BC	;Stuff into the message
	@@DSPLY	DIRCYL$		;"dir will be placed...
	@@DSPLY	IPLSYS$		;"initializing...
	LD	HL,GATBUF
	LD	A,(HL)		;P/u GAT byte for 1st
	OR	1		;  cylinder & show 1st
	LD	(HL),A		;  gran in use for BOOTs
	LD	A,(IY+9)	;Dir cyl # into DIR/SYS
	LD	(DIRDIR+16H),A
	LD	L,A		;Show entire directory
	LD	(HL),0FFH	;Cylinder locked out
;*=*=*
;	Update BOOT for DIR & step rate
;*=*=*
	LD	A,(IY+9)	;Dir cyl into BOOT
	LD	(BOOT+2),A
	LD	A,(BOOTST$)	;P/u offset
	LD	L,A
	LD	H,BOOT<-8
	LD	A,(STEPDFT)	;P/u boot step rate
	IF	@MOD2
	OR	80H		;create single byte opcod
	ENDIF
	LD	(HL),A		;  & set into BOOT
	LD	DE,0		;Init for cyl 0, sect 0
	CALL	VERSEC		;Test if formatted
	LD	HL,NOTFMT$
	JP	NZ,EXTERR	;Error if not
	LD	HL,BOOT		;Pt to Data disk BOOT
	CALL	WRSEC		;  & write it
	CALL	Z,WRDIR+3	;Verify after write
	JP	NZ,IOERR	;  & display '.'
	LD	DE,1		;Pt to cyl 0, sector 1
	LD	HL,BOOT		;Pt to the sector 1 boot
	CALL	WRSEC		;Write 0/1
	CALL	Z,WRDIR+3	;Verify after write
	JP	NZ,IOERR
;*=*=*
;	Complete GAT construction
;*=*=*
	LD	A,(IY+6)	;P/u highest # cylinder
	SUB	22H		;  & adj offset from 34
	LD	(GATBUF+0CCH),A	;Stuff GAT cyl excess
	LD	A,(IY+4)	;P/u sec siz & # of sides
	AND	80H+20H
	LD	B,A
	LD	A,(IY+3)	;P/u density
	AND	40H
	OR	B
	LD	B,A
	LD	A,(IY+8)	;P/u # of grans/cyl
	RLCA
	RLCA
	RLCA
	AND	7
	LD	(CYLGRN+1),A
	OR	B		;Merge the two
	OR	80H		;Show it's a data disk
	LD	(GATBUF+0CDH),A	;Stuff into GAT
;
	LD	DE,GATBUF+255-10;6.2 Media Data Block
	LD	HL,LSIID	;point to header
	LD	BC,04		;set length
	LDIR			; move it
	PUSH	IY
	POP	HL		;This drive's DCT
	INC	HL
	INC	HL
	INC	HL		;Bypass the JP addr
	LD	C,7		; bytes to move
	LDIR			; move it in
	JR	WRGAT1		;skip around string
LSIID	DB	03,'LSI'
;
;*=*=*
;	Write copy of GAT into 0/3
;*=*=*
WRGAT1
	LD	HL,GATBUF	;Pt to GAT buffer
	LD	D,0		;Write it out to
	LD	E,3		;Cyl 0, sector 3
	CALL	WRSEC		;Write 0/3
	CALL	Z,WRDIR+3	;Verify after write
	JP	NZ,IOERR
;*=*=*
;	Write the system information sector
;*=*=*
	LD	HL,HITBUF	;Zero out buffer
GSYS1	LD	(HL),0
	INC	L
	JR	NZ,GSYS1
	LD	HL,HITBUF	;Set first byte to OSVER
	LD	(HL),RLS	;  for release number
	LD	L,20H		;point hl to AUTO buffer
	LD	(HL),0DH	;put in terminator
	LD	DE,2		;Pt to cyl 0, sector 2
	LD	L,D		;hl now points to HITBUF
	CALL	WRSEC		;Write 0/2
	CALL	Z,WRDIR+3	;Verify after write
	JP	NZ,IOERR
	LD	L,20H		;Zero this out for use
	LD	(HL),0		; when writing HIT
;*=*=*
;	Write out the directory GAT
;*=*=*
	LD	HL,GATBUF	;Pt to GAT sector buffer
	LD	D,(IY+9)	;P/u the dir cyl
	LD	E,L		;Denote sector 0
	CALL	WRDIR		;Write the GAT
	JP	NZ,IOERR
;*=*=*
;	Construct the HIT
;*=*=*
	LD	HL,HITBUF	;Point to the HIT buffer
	LD	(HL),0A2H	;Stuff BOOT/SYS hash code
	INC	HL
	LD	(HL),0C4H	;Stuff DIR/SYS hash code
	DEC	HL
	LD	D,(IY+9)	;P/u dir cyl #
	LD	E,1		;Pt to sector 1
	CALL	WRDIR		;Write the HIT
	JP	NZ,IOERR
	LD	DE,HITBUF	;Establish buffer for
	LD	HL,BOOTDIR	;  dir records
	LD	BC,32		;Move BOOT/SYS dir record
	LDIR			;  into 1st slot
	LD	D,(IY+9)	;P/u dir cyl
	LD	E,2		;This will be sector 2
	LD	HL,HITBUF	;Pt to buffer start
	CALL	WRDIR		;Write the sector
	JP	NZ,IOERR
	LD	A,(SECCYL)	;P/u # of records
	LD	(DIRDIR+14H),A	;  & stuff into DIR/SYS
CYLGRN	LD	A,0		;P/u # grans/cyl
	BIT	5,(IY+4)	;Test 2-sided
	JR	Z,$+4
	ADD	A,A		;Double count on 2-sided
	INC	A		;Plus 1 for 0 offset adj
	LD	(DIRDIR+23),A	;Stuf in DIR/SYS
	LD	A,(IY+9)	;P/u the dir cyl # &
	LD	(DIRDIR+16H),A	;  stuff into the DIR rec
	LD	HL,DIRDIR	;Pt to start of DIR data
	LD	DE,HITBUF	;Pt to start of dir buf
	LD	BC,32		;Move DIR/SYS into buf
	LDIR
	LD	D,(IY+9)	;P/u dir cyl #
	LD	E,3		;Write as sector 3
	LD	HL,HITBUF	;Pt to start of buffer
	CALL	WRDIR		;Write the sector
	JR	NZ,IOERR
	LD	HL,HITBUF	;Zero the 1st 32 bytes
	LD	B,32		;Of the buffer to clear
GSYS2	LD	(HL),0		;Where we stuffed the
	INC	HL		;BOOT & DIR dir records
	DJNZ	GSYS2
	LD	D,(IY+9)	;P/u dir cyl #
	LD	E,4		;Cont writing at sect 4
GSYS3	LD	HL,HITBUF	;Pt to start of buffer
	CALL	WRDIR		;Write the sector
	JR	NZ,IOERR
;*=*=*
;	write the remaining directory
;*=*=*
	INC	E		;Bump the sector pointer
	LD	A,(SECCYL)	;P/u highest # sector
	CP	E		;Are we finished yet?
	JR	NZ,GSYS3	;Loop if not
	CALL	EXIT2		;Get system disk
	@@DSPLY	FMTCAO$		;"formatting complete...
	JR	EXIT
;*=*=*
;	exit procedures
;*=*=*
IOERR	PUSH	AF		;Save errcod
	CALL	EXIT2		;Interrupts on if needed
	POP	AF		;Rcvr retcod
	CP	63
	JR	Z,EXTERR
	LD	L,A
	LD	H,0
	OR	0C0H		;Mask to ABORT with brief
	LD	C,A
	@@ERROR
	JR	ERREXIT
BREAK	EQU	$
FMTABT	LD	HL,FMTABT$
EXTERR	@@LOGOT			;Some error to abort job
	CALL	EXIT2		;Get system disk
	LD	HL,-1
ERREXIT	LD	(RETCOD),HL
EXIT	LD	HL,0
RETCOD	EQU	$-2
	PUSH	HL
	PUSH	IY		;Transfer the saved
	POP	DE		;  system DCT back
	LD	HL,SYSDCT	;  into the system
	LD	BC,10		;  DCT slot
	LDIR
	POP	HL
SPSAV	LD	SP,$-$		;P/u the stack pointer
	@@CKBRKC		;Clear break bit
	RET			;  & exit to caller
EXIT2	LD	A,(FMTDRV+1)	;P/u drive # just fmtd
	INC	A		;If drive never entered,
	RET	Z		; just return
	DEC	A		;If 0, we need a system
	JR	NZ,EXIT4
	LD	HL,PMTSYS$	;"load system disk...
	@@DSPLY
EXIT3	@@KEY			;Request a key
	CP	CR		;Must be <ENTER>
	JR	NZ,EXIT3
EXIT4	JR	RESTOR		;Restore disk to cyl 0
;*****
;	disk I/O requests
;*****
DRVNOP	PUSH	BC
	XOR	A
	JR	FMTDRV
SELECT	PUSH	BC
	LD	A,1
	JR	FMTDRV
RESTOR	PUSH	BC
	LD	A,4
	JR	FMTDRV
STEPIN	PUSH	BC
	LD	A,5
	JR	FMTDRV
RSELCT	PUSH	BC
	LD	A,7
	JR	FMTDRV
WRCYL	PUSH	BC
	LD	A,15
	JR	FMTDRV
FMTHD	PUSH	BC
	LD	A,12
	JR	FMTDRV
WRSEC	PUSH	BC
	LD	A,13
	JR	FMTDRV
WRSYS	PUSH	BC
	LD	A,14
	JR	FMTDRV
RDSEC	PUSH	BC
	LD	A,9
	JR	FMTDRV
VERSEC	PUSH	BC
	LD	A,10
FMTDRV	LD	C,-1		;P/u drive #
	ADD	A,40		;Adjust SVC #
	RST	40
	POP	BC
	RET
;*****
;	perform a verification to ensure system sector
;*****
VERSYS	CALL	VERSEC		;Sector verify
	JR	Z,VERS1		;Bypass if not system
	SUB	6		;Test read system retcod
	RET	Z		;Go if that's what it was
	ADD	A,6		;Restore orig retcod
	RET
VERS1	OR	1		;S/b system, found data
	LD	A,0
	RET
WRDIR	CALL	WRSYS		;Write the DIR sector
	CALL	NZ,VERSYS	;Verify after write
	RET	NZ
	PUSH	DE
	LD	C,'.'
	@@DSP
	POP	DE
	RET
;*****
;	routine to convert reg A to 2 decimal digits
;*****
CVDEC	LD	C,30H
CVD1	SUB	10
	JR	C,CVD2
	INC	C
	JR	CVD1
CVD2	ADD	A,3AH
	LD	B,A
	RET
;*****
;	routines to convert input strings to lc
;*****
GET3	@@DSPLY
	LD	BC,3<8
	JR	$+5
GET8	LD	BC,8<8		;8-chars max
	LD	HL,HITBUF	;Buffer area
GET8A	@@KEYIN			;Enter them
	JP	C,FMTABT
	LD	A,B
	OR	A
	RET	Z
;*=*=*
;	Routine to convert n-character string to UC
;*=*=*
	PUSH	AF
	PUSH	BC
	PUSH	HL
GETUC	LD	A,(HL)
	CP	'a'
	JR	C,GETUC1
	CP	'z'+1
	JR	NC,GETUC1
	RES	5,(HL)
GETUC1	INC	HL
	DJNZ	GETUC
	POP	HL
	POP	BC
	POP	AF
	RET
;*=*=*
;	Routine to display the cylinder number
;*=*=*
DSPCYL	PUSH	BC		;Save cylinder #
	LD	C,8		;Back up twice &
	@@DSP			;  output new position
	LD	C,8
	@@DSP
	POP	BC
	@@DSP
	LD	C,B
	@@DSP
	RET
;*****
;	formatting data and tables
;*****
BOOTDIR	DB	5EH,0,0,0,0,'BOOT    SYS',0F6H,37H
	DB	0F5H,9CH,5,0,0,0,0FFH,0FFH,-1,-1,-1,-1,-1,-1
DIRDIR	DB	5DH,0,0,0,0,'DIR     SYS',0F6H,37H
	DB	96H,42H,10,0,11H,1,0FFH,0FFH,0,0,0,0,0,0
SYSDCT	DS	10
STEPDFT	DB	0		;Boot step rate default
SECCYL	DS	1		;# of sectors per cyl
SECTRK	DS	1		;# of sectors per trk
;*****
;	single density 5" format table
;*****
S5TBL	DB	10,7
	DB	0,5,1,6,2,7,3,8,4,9
	DB	-10,-10,-10,-10,-10,-10,-10,-10,14,0FFH
	DB	0F1H,6,0,1,0FEH
	DB	0F3H,3,0,1,1,1,0F7H,1,0FFH,11,0FFH
	DB	6,0,1,0FBH,0,0E5H,1,0F7H,1,0FFH,13,0FFH
	DB	0F2H,47H,0FFH,0F4H
	DB	0,1,2,3,4,5,6,7,8,9
;*****
;	double density 5" format table
;*****
D5TBL	DB	18,10
	DB	0,9,1,10,2,11,3,12,4
	DB	13,5,14,6,15,7,16,8,17
	DC	11,-18
	DB	20,4EH
	DB	0F1H,12,0,3,0F5H,1,0FEH
	DB	0F3H,3,0,1,1,1,0F7H,22,4EH,12,0,3,0F5H
	DB	1,0FBH,0F5H,128,6DH,0B6H
	DB	1,0F7H,1,0FFH,17,04EH
	DB	0F2H,182,4EH,0F4H
	DB	0,1,2,3,4,5,6,7,8,9
	DB	10,11,12,13,14,15,16,17
;*****
;	single density 8" format table
;*****
S8TBL	DB	16,2
	DB	10,5,0,11,6,1,12,7,2,13,8,3,14,9,4,15
	DB	-16,-16,-16,28H,0FFH
	DB	0F1H,6,0,1,0FEH
	DB	0F3H,3,0,1,1,1,0F7H,11,0FFH,6,0,1,0FBH
	DB	0,0E5H,1,0F7H,1,0FFH,20,0FFH
	DB	0F2H,208,0FFH,0F4H
	DB	10,0,6,12,2,8,14,4,5,11,1,7,13,3,9,15
;*****
;	double density 8" format table
;*****
D8TBL	DB	30,12
	DB	0,10,20,1,11,21,2,12,22,3,13,23,4,14,24
	DB	5,15,25,6,16,26,7,17,27,8,18,28,9,19,29
	DC	13,-30
	DB	20,4EH
	DB	0F1H,0CH,0,3,0F5H,1,0FEH
	DB	0F3H,3,0,1,1,1,0F7H,22,4EH,12,0,3,0F5H
	DB	1,0FBH,0F5H,128,6DH,0B6H
	DB	1,0F7H,1,0FFH,17,4EH
	DB	0F2H,0,4EH,61,4EH,0F4H
	DB	0,20,11,2,22,13,4,24,15,6,26,17,8,28,19
	DB	10,1,21,12,3,23,14,5,25,16,7,27,18,9,29
FMTCYL$	DB	29,'Formatting cylinder   ',3
VERCYL$	DB	29,'Verifying  cylinder   ',3
STAR$	DB	'*   ',3
FMTG$	DB	'Formatting...',CR
NOCYL$	DB	'No cylinders available for directory',CR
DIRCYL$	DB	'Directory will be placed on cylinder '
DIRASC$	DB	'00',CR
IPLSYS$	DB	LF,'Initializing DIRECTORY information: ',3
PMTSYS$	DB	LF,'Load SYSTEM diskette  <ENTER>',CR
FMTCAO$	DB	LF,LF,'Formatting complete',CR
FMTABT$	DB	LF,'Command aborted',CR
NOTFMT$	DB	LF,'Can''t, Diskette not formatted',CR
;*=*=*
;	Patch area
;*=*=*
	ORG	$<-8+1<+8
GATBUF	DS	203		;GAT sector buffer
	DB	RLS,0,0,0,0	;Ver, cyl exc, type, pswd
	DB	'        MM/DD/YY'
	DC	32,0
BOOT	EQU	$
CORE$	DEFL	$
	ORG	4300H		;Execute at ROM BOOT
	LORG	CORE$		;  but load here
	NOP
	CP	0		;P/u the DIR track
;
	IF	@MOD2
	DB	83H
	ENDIF
	IF	@MOD4
	DI
	ENDIF
	DC	12,0
	LD	DE,80*11+CRT4+29
	LD	HL,DATADSK$
	LD	BC,STRLEN
	LDIR
	LD	DE,64*8+CRT3+21
	LD	HL,DATADSK$
	LD	BC,STRLEN
	LDIR
STOP	JP	STOP
DATADSK$	DB	'Cannot boot, DATA DISK!'
STRLEN	EQU	$-DATADSK$
	DC	-$&0FFH,0
SAFESP	EQU	$
	ORG	CORE$+256
	LORG	CORE$+256
HITBUF	DS	256
	PAGE
*GET	FORMAT2:3
	END	FORMAT
