;FDCDVR/ASM - 11/08/83 - Model IV - 6.2
;*=*=*
;	Change Log
;
; 04/29/83 - Changed retry count to 4 from 6
; 05/27/83 - Correct to NOT set PRECOMP in SDEN
; 09/25/83 - Pick up retry count from RFLAG$
; 09/25/83 - Allow restore at ANY RATE
;
;
;*=*=*
;	Model IV LDOS 6.2 disk I/O routines
;	 HL=> buffer address
;	  D=> track desired
;	  E=> sector desired
;	  C=> drive desired
;	  B=> disk primitive command
;*****
WRNMIPORT	EQU	0E4H	;NMI mask register
FDCADR		EQU	0F0H	;fdc command
FDCSTAT		EQU	0F0H	;fdc status
TRKREG		EQU	0F1H	;fdc track register
SECREG		EQU	0F2H	;fdc sector register
DATREG		EQU	0F3H	;fdc data register
DSELCT		EQU	0F4H	;drive select port
;
;*****
;	Disk Driver Entry Point
;*****
FDCDVR	JR	FDCBGN
	DW	FDCEND
	DB	3,'$FD'
SWDEN
	LD	A,3		;Check counter for 2
	CP	B		; tries left
	JR	Z,RESTOR	; if so try a RESTORE
;
	LD	A,(IY+3)	;flip the density bit
	XOR	40H
	LD	(IY+3),A
	LD	BC,2409H	;set alloc to SDEN
	BIT	6,A		;test SDEN/DDEN
	JR	Z,SDEN
	LD	BC,4511H	;set alloc to DDEN
SDEN	LD	(IY+7),C
	LD	(IY+8),B
	RET			; All set
;*****
;	verify routine
;*****
VERFIN	LD	HL,BUCKET	;Set byte bucket
	LD	A,2DH		;Set for DEC L,...
	DB	1EH		;Ignore next with LD E,n
;*****
;	read routine
;*****
RDIN	XOR	A		;Set for NOP
	LD	(CKVER),A
	CALL	RWINIT		;initialize
	LD	E,16H		;Status mask
RDIN1	IN	A,(FDCSTAT)	;get status
	AND	E		;Loop until DRQ
	JR	Z,RDIN1		; or error
	INI			;grab byte
	DI			;Shut them guys off
	LD	A,D		;Get drive sel + WSGEN
RDIN2	OUT	(DSELCT),A	;Initiate wait state
CKVER	NOP			;DEC L: if verify
	INI			;xfer byte
	JR	NZ,RDIN2	;Loop then TSTBSY
;*****
;	Reselect drive while controller is busy
;*=*=*
TSTBSY	IN	A,(FDCSTAT)	;ck FDC status
	BIT	0,A		;busy?
	RET	Z		;RET if not
	LD	A,(PDRV$)	;p/u drive
	OUT	(DSELCT),A	;& reselect
	JR	TSTBSY		;loop until idle
;*=*=*
;	Driver start
;*=*=*
FDCBGN	LD	A,B		;p/u primitive request
	AND	A		;NOP?
	RET	Z		;Quit if so
	CP	7
	JR	Z,TSTBSY	;jump on TSTBSY request
	JP	NC,IORQST	;Jump on I/O request
	CP	6
	JR	Z,SEEKTRK	;jump on track seek
	DEC	A
	JR	Z,SELECT	;Jump on drive select
	INC	(IY+5)		;bump current cylinder
	CP	4
	LD	B,58H		;FDC step-in command
	JR	Z,STEPIN
RESTOR	LD	(IY+5),0	;set track to 0
	LD	B,8		;restore drive
	JR	STEPIN
;
SELECT	CALL	TSTBSY		;Check drive status
	RLCA
	PUSH	AF		;Save NOT READY flag
	PUSH	BC
	LD	A,(IY+3)	;p/u SDEN/DDEN
	RLA			;Bit 6=>7, bit 4=>4
	SRA	A
	AND	90H		;Keep only DDEN & side 1
	LD	C,A		;Save the bits
	BIT	7,A		;Check if SDEN or DDEN
	JR	Z,NOPCMP	; NO PRECOMP if SDEN!!!
	LD	A,(IY+9)	;Set precomp on all
	CP	D		;  tracks above DIR
	JR	NC,NOPCMP	;Go if no precomp needed
	SET	5,C		;Request precomp
NOPCMP	LD	A,(IY+4)	;Get drive sel code
	AND	0FH		;Keep only sel bits
	OR	C		;Merge in bits 4,5,7
	POP	BC
	OUT	(DSELCT),A	;select drive
	LD	(PDRV$),A	;store port byte
	POP	AF		;Retrieve NOT READY bit
	RET	NC		;ret if was ready
	BIT	2,(IY+3)	;Check DELAY=0.5 or 1.0
	CALL	Z,FDCDLY	;Double delay if 1.0
FDCDLY	PUSH	BC		;delay routine
	LD	B,7FH
	CALL	PAUSE@
	POP	BC
	RET
;*****
;	routine to seek a track
;*****
SEEKTRK	CALL	TSTBSY		;Wait till not busy
	LD	A,(IY+5)	;p/u current cylinder
	OUT	(TRKREG),A	;& set FDC to current
	LD	A,(IY+7)	;p/u alloc data
	AND	1FH		; get highest # sector
	SUB	E		;Form req sector minus
	CPL			; max, setting CY flag if
	RES	4,(IY+3)	;init side select to 0
	JR	NC,SETSECT	;Go if sector on side 0
	BIT	5,(IY+4)	;If not 2-sided media,
	JR	Z,FRCSID0	;  don't set side 1
	SET	4,(IY+3)	;set side 1
	DB	1EH		;Ignore next with LD E,n
SETSECT	LD	A,E		;Restore unaltered sec #
FRCSID0	OUT	(SECREG),A	;set sector & cylinder
	LD	A,D
	OUT	(DATREG),A	;set desired track
	CP	(IY+5)		;Use seek with verify
	LD	B,18H		;  if need to step
	JR	Z,STEPIN	;  else only seek
	LD	(IY+5),D	;update current cylinder
	LD	B,1CH		;FDC seek cmd
STEPIN	CALL	SELECT		;Select drive
	LD	A,(IY+3)
	AND	3		;strip all but step rate
	OR	B
PASSCMD	OUT	(FDCADR),A	;give FDC its command
	LD	B,12H
	DJNZ	$		;wait
	XOR	A
FDCRET	RET
;*****
;	Read and write init routines
;*****
RWINIT	LD	A,D		;Restuff trk reg
	OUT	(TRKREG),A
	LD	A,(PDRV$)	;Get select code
	OR	40H		;Set WSGEN bit
	LD	D,A		;Save code in D
	AND	10H		;Get side sel bit
	RRCA			;  to bit 3
	BIT	1,C		;Check if doing side cmp
	JR	NZ,GETCMD	;Go if so
	XOR	A
GETCMD	OR	C
	LD	C,DATREG	;B has zero from PASSCMD
	CALL	FDDINT$		; INT on or off handled
				; at 0Eh
	JR	PASSCMD		;Pass command to ctrlr
;*****
;	I/O request handler
;*****
IORQST	BIT	2,B		;write command?
	LD	BC,(RFLAG$-1)	;P/u retry count
	LD	C,82H		;FDC cmd=readsec
	JR	NZ,WRCMD	;Go if write command
	CP	10		;verify sector?
	JR	Z,VERFY
	CALL	GRABNDO		;grab next code & insert
	DB	1		;error code start
	DW	RDIN
VERFY	CALL	GRABNDO		;stuff I/O direction
	DB	1		;error code start
	DW	VERFIN
WRCMD	BIT	7,(IY+3)	;Software WP?
	JR	Z,WRCMD1	;Bypass if not
	LD	A,15		;Else set WP error
	RET
WRCMD1	LD	C,0A2H		;write sector FDC command
	CP	14		;directory sector?
	JR	C,DOWRIT
	LD	C,0A3H		;write protected
	JR	Z,DOWRIT	;  if directory else
	LD	C,0F0H		;  write track
DOWRIT	CALL	GRABNDO		;switch code
	DB	9		;error code start
	DW	WROUT
;*****
;	routine stuffs error start byte & I/O vector
;*****
GRABNDO	EX	(SP),HL		;save HL & get ret addr
	LD	A,(HL)		;p/u & stuff error code
	INC	HL		;start byte
	LD	(ERRSTRT+1),A
	LD	A,(HL)		;set up data transfer
	INC	HL		;  direction vector
	LD	H,(HL)
	LD	L,A
	LD	(CALLIO),HL	;stuff CALL vector
	POP	HL		;Restore buffer addr
;*****
;	main I/O handler routine
;*****
RETRY	PUSH	BC		;save retry &FDC command
	PUSH	DE		;save track/sector
	PUSH	HL		;save buffer
	BIT	4,C		;test for track command
	CALL	Z,SEEKTRK	;seek if not track write
	CALL	TSTBSY		;Wait till not busy
	CALL	0		;call I/O routine
CALLIO	EQU	$-2		;data xfer direction
DISKEI	NOP		;Will be changed to a EI after
			; BOOT has read in SYS0
	IN	A,(FDCSTAT)	;get status
	AND	7CH		;strip all but 2-6
	POP	HL
	POP	DE		;rcvr track & sector
	POP	BC		;rcvr retry count & cmd
	RET	Z		;ret if no error
	BIT	2,A		;lost data?
	JR	NZ,RETRY	;Don't count this retry
	PUSH	AF
	AND	18H		;record not found or CRC
	JR	Z,DISKDUN	;No retries if otherwise
	BIT	4,A		;RNF?
	PUSH	BC		;If so, switch
	CALL	NZ,SWDEN	;  density or restore
	POP	BC
	POP	AF
	DJNZ	RETRY		;count down retry
	DB	6
DISKDUN	POP	AF		;adjust ret code
	LD	B,A
ERRSTRT	LD	A,0		;start with R=1, W=9
ERRTRAN	RRC	B
	RET	C
	INC	A
	JR	ERRTRAN
;*=*=*
;	write routine
;*=*=*
WROUT	CALL	RWINIT		;set up initialization
	LD	E,76H		;Status mask
WRO1	IN	A,(FDCSTAT)	;p/u status
	AND	E		;Fall out on DRQ or error
	JR	Z,WRO1		;Else loop
	OUTI			;xfer byte to FDC
	DI			;Now kill the interrupts
	IN	A,(FDCSTAT)	;Check for errors
	RRA			;Did BUSY drop?
	RET	NC		;Quit now if so
	LD	A,0C0H		;Enable INTRQ and timeout
	OUT	(WRNMIPORT),A
	LD	B,50H		;Time delay for WRSEC
	DJNZ	$
	LD	B,(HL)		;Get next byte early
	INC	HL
WRO3	LD	A,D		;Enable wait states
	OUT	(DSELCT),A
	IN	A,(FDCSTAT)	;Check if timed out
	AND	E		;Loop back if it timed
	JR	Z,WRO3		;  out (must be WRTRK)
	OUT	(C),B		;Pass 2nd byte
	LD	A,D		;Get sel code + WSGEN bit
WRO2	OUT	(DSELCT),A	;pass until FDC times out
	OUTI			;  & generates NMI
	JR	WRO2
	IFEQ	$&0FFH,0FFH
	ERR	'Warning... BUCKET position error
	ENDIF
BUCKET	DB	'S'
;
@RSTNMI	XOR	A		;NMI vectors here
	OUT	(WRNMIPORT),A	;disable INTRQ & timeout
	LD	BC,100		;Need to wait a moment
	CALL	PAUSE@		;call pause
	POP	HL		;Discard return
	RET
FDCEND	EQU	$-1
