;DDIO - DISKDISK System routines - 10/12/83
;
	SUBTTL	<'DDIO - System Interface routines'>
	PAGE
;
;********************************************************
;*** IOINIT - initialize 5.1 System I/O routines      ***
;********************************************************
;
IOINIT
	IF	V5
	LD	A,(125H)	;Model I or III ?
	CP	'I'		;
	RET	NZ		;Model I - don't change
;
;*=*=* Overwrite Mod I Addr's w/ Mod III addresses *=*=*
;
	PUSH	HL		;Save command ptr
	LD	HL,HIGH3	;HIGH$
	LD	(HIGHA+1),HL	;
	LD	(HIGHB+1),HL	;
	LD	HL,SFLAG3	;SFLAG$
	LD	(SFLAG+1),HL	;
	LD	HL,MULT3	;@MUL16 in driver
	LD	(M16A+1),HL	;
	LD	(M16B+1),HL	;
	LD	(MUL16+2),HL	;not in driver
	LD	HL,MUL3		;@MUL8 in driver
	LD	(MUL8+2),HL	;@MUL8 routine
	LD	(M8+1),HL	;
	LD	HL,PARAM3	;@PARAM
	LD	(PARAM+1),HL	;
	LD	HL,DATE3	;@DATE
	LD	(DATE+1),HL	;
	LD	HL,LOGOT3	;@LOGOT
	LD	(LOGOT+1),HL	;
	LD	HL,FEXT3	;@FEXT
	LD	(FEXT+1),HL	;
	LD	HL,CKDRV3	;@CKDRV
	LD	(CKDRV+1),HL	;
	POP	HL		;HL => Command ptr
	ENDIF
	RET			;done
;
;
LD___A	EQU	3EH		;LD A,nn opcode
@EXIT	EQU	402DH		;5.1 @EXIT vector
@ABORT	EQU	4030H		;5.1 @ABORT vector
@OPEN	EQU	4424H		;5.1 @OPEN vector
@INIT	EQU	4420H		;5.1 @INIT vector
@KILL	EQU	442CH		;5.1 @KILL vector
@READ	EQU	4436H		;5.1 @READ vector
@WRITE	EQU	4439H		;5.1 @WRITE vector
@POSN	EQU	4442H		;5.1 @POSN vector
@REW	EQU	443FH		;5.1 @REW vector
@CLOSE	EQU	4428H		;5.1 @CLOSE vector
@DIRRD	EQU	4B10H		;5.1 @DIRRD
@DIRWR	EQU	4B1FH		;5.1 @DIRWR vector
@FSPEC	EQU	441CH		;5.1 @FSPEC vector
@GTDCT	EQU	478FH		;5.1 @GTDCT vector
@ERROR	EQU	4409H		;5.1 @ERROR vector
PARAM1	EQU	4476H		;5.1 M1 @PARAM vector
PARAM3	EQU	4454H		;5.1 M3 @PARAM vector
DATE1	EQU	4470H		;5.1 M1 @DATE vector
DATE3	EQU	3033H		;5.1 M3 @DATE vector
@KEYIN	EQU	40H		;5.1 @KEYIN vector
@DSPLY	EQU	4467H		;5.1 @DSPLY vector
LOGOT1	EQU	447BH		;5.1 M1 @LOGOT vector
LOGOT3	EQU	428AH		;5.1 M3 @LOGOT vector
FEXT1	EQU	4473H		;5.1 M1 @FEXT vector
FEXT3	EQU	444BH		;5.1 M3 @FEXT vector
CKDRV1	EQU	44B8H		;5.1 M1 @CKDRV vector
CKDRV3	EQU	4209H		;5.1 M3 @CKDRV vector
MULT1	EQU	44C1H		;5.1 M1 @MULT
MULT3	EQU	444EH		;5.1 M3 @MULT
MUL1	EQU	4B6CH		;5.1 M1 @MULTEA
MUL3	EQU	4B6BH		;5.1 M3 @MULTEA
SFLAG1	EQU	430FH		;5.1 M1 SFLAG$
SFLAG3	EQU	442BH		;5.1 M3 SFLAG$
HIGH1	EQU	4049H		;5.1 M1 HIGH$
HIGH3	EQU	4411H		;5.1 M3 HIGH$
;
;
;
PARAM
	IF	V5		;5.1 @PARAM
	JP	PARAM1		;M I/III @PARAM
	ENDIF			;
	IF	V6		;6.0 @PARAM
	@@PARAM			;
	RET			;
	ENDIF			;
;
WRITE
	IF	V5		;5.1 @WRITE
	JP	@WRITE		;
	ENDIF			;
	IF	V6		;6.0 @WRITE
	@@WRITE			;
	RET			;
	ENDIF			;
;
OPEN
	IF	V5		;5.1 @OPEN
	JP	@OPEN		;
	ENDIF			;
	IF	V6		;6.0 @OPEN
	@@OPEN			;
	RET			;
	ENDIF			;
;
INIT
	IF	V5		;5.1 @INIT
	JP	@INIT		;
	ENDIF			;
	IF	V6		;6.0 @INIT
	@@INIT			;
	RET			;
	ENDIF			;
;
CLOSE
	IF	V5		;5.1 @CLOSE
	JP	@CLOSE		;
	ENDIF			;
	IF	V6		;6.0 @CLOSE
	@@CLOSE			;
	RET			;
	ENDIF			;
;
FEXT
	IF	V5		;5.1 @FEXT
	JP	FEXT1		;M I/III @FEXT
	ENDIF			;
	IF	V6		;6.0 @FEXT
	@@FEXT			;
	RET			;
	ENDIF			;
;
FSPEC
	IF	V5		;5.1 @FSPEC
	JP	@FSPEC		;
	ENDIF			;
	IF	V6		;6.0 @FSPEC
	@@FSPEC			;
	RET			;
	ENDIF			;
;
CKDRV
	IF	V5		;5.1 @CKDRV
	JP	CKDRV1		;M I/III @CKDRV
	ENDIF			;
	IF	V6		;6.0 @CKDRV
	@@CKDRV			;
	RET			;
	ENDIF			;
;
LOGOT
	IF	V5		;5.1 @LOGOT
	JP	LOGOT1		;M I/III @LOGOT
	ENDIF			;
	IF	V6		;6.0 @LOGOT
	@@LOGOT			;
	RET			;
	ENDIF			;
;
DATE
	IF	V5		;5.1 @DATE
	JP	DATE1		;M I/III @DATE
	ENDIF			;
	IF	V6		;6.0 @DATE
	@@DATE			;
	RET			;
	ENDIF			;
;
DIRRD
	IF	V5		;5.1 @DIRRD
	JP	@DIRRD		;
	ENDIF			;
	IF	V6		;6.0 @DIRRD
	@@DIRRD			;
	RET			;
	ENDIF			;
;
DIRWR
	IF	V5		;5.1 @DIRWR
	JP	@DIRWR		;
	ENDIF			;
	IF	V6		;6.0 @DIRWR
	@@DIRWR			;
	RET			;
	ENDIF			;
;
KILL
	IF	V5		;5.1 @KILL
	JP	@KILL		;
	ENDIF			;
	IF	V6		;6.0 @KILL
	@@REMOV			;
	RET			;
	ENDIF			;
;
READ
	IF	V5		;5.1 @READ
	JP	@READ		;
	ENDIF			;
	IF	V6		;6.0 @READ
	@@READ			;
	RET			;
	ENDIF			;
;
POSN
	IF	V5		;5.1 @POSN
	JP	@POSN		;
	ENDIF			;
	IF	V6		;6.0 @POSN
	@@POSN			;
	RET			;
	ENDIF			;
;
REW
	IF	V5		;5.1 @REW
	JP	@REW		;
	ENDIF			;
	IF	V6		;6.0 @REW
	@@REW			;
	RET			;
	ENDIF			;
;
GTDCT
	IF	V5		;5.1 @GTDCT
	JP	@GTDCT		;
	ENDIF			;
	IF	V6		;6.0 @GTDCT
	@@GTDCT			;
	RET			;
	ENDIF			;
;
DSPLY@
	IF	V5		;5.1 @DSPLY
	JP	@DSPLY		;
	ENDIF			;
	IF	V6		;6.0 @DSPLY
	@@DSPLY			;
	RET			;
	ENDIF			;
;
ERROR
	IF	V5		;5.1 @ERROR
	JP	@ERROR		;
	ENDIF			;
	IF	V6		;6.0 @ERROR
	@@ERROR			;
	RET			;
	ENDIF			;
;
KEYIN
	IF	V5		;5.1 @KEYIN
	JP	@KEYIN		;
	ENDIF			;
	IF	V6		;6.0 @KEYIN
	@@KEYIN			;
	RET			;
	ENDIF			;
;
MUL16
	IF	V5		;5.1 @MUL16
	LD	A,C		;p/u multiplicand
	JP	MULT1		;
	ENDIF			;
	IF	V6		;6.0 @MUL16
	@@MUL16			;
	RET			;
	ENDIF			;
;
MUL8
	IF	V5		;5.1 @MUL8
	LD	A,C		;p/u multiplier
	JP	MUL1		;
	ENDIF			;
	IF	V6		;6.0 @MUL8
	@@MUL8			;
	RET			;
	ENDIF			;
;
GTMOD
	IF	V6		;6.0 @GTMOD
	@@GTMOD			;
	RET			;
	ENDIF			;
	IF	V5		;5.1 @GTMOD
	LD	HL,0		;p/u HIGH$
	CALL	GTHIGH		;
;
;*=*=* Are we done searching memory ? *=*=*
;
GTMDLP	INC	HL		;bump mem ptr
	LD	A,H		;done ?
	OR	L		;
	JR	NZ,NOT_DUN	;no
;
;*=*=* Done searching memory - RETurn NZ *=*=*
;
	INC	L		;L was = 0
	RET			;RETurn NZ
;
;*=*=* Does the first character match ? *=*=*
;
NOT_DUN	LD	A,(DE)		;p/u source char
	CP	(HL)		;match ?
	JR	NZ,GTMDLP	;no - go til match
;
;*=*=* First character matches - does the rest ? *=*=*
;
	PUSH	HL		;Save current pos
	PUSH	DE		;Save start of mod name
GTMDLP2	INC	HL		;bump mem ptr
	INC	DE		;bump mod ptr
;
;*=*=* Are we done matching - (DE) = terminator ? *=*=*
;
	LD	A,(DE)		;p/u module char
	CP	' '		;terminator ?
	JR	NC,CK_CHR	;no - check character
;
;*=*=* Found match - does it have a valid header ? *=*=*
;
	POP	DE		;DE => Module name
	POP	HL		;HL => Mem
	PUSH	HL		;save
	LD	BC,-5		;posn to JR
	ADD	HL,BC		;
	POP	BC		;BC => Original posn
	LD	A,(HL)		;JR instruction ?
	CP	18H		;
	RET	Z		;Return Z if JR
	LD	H,B		;xfer original posn
	LD	L,C		;to HL
	JR	GTMDLP		;back to main loop
;
;*=*=* Check module character with mem ptr *=*=*
;
CK_CHR	CP	(HL)		;match ?
	JR	Z,GTMDLP2	;yes - continue
	POP	DE		;restore registers
	POP	HL		;
	JR	GTMDLP		;go back to main loop
	ENDIF			;
;
GTHIGH
	IF	V6		;6.0 @HIGH$
	@@HIGH$			;
	RET			;
	ENDIF			;
	IF	V5		;5.1 @HIGH$
	LD	A,H		;p/u or set ?
	OR	L		;
	JR	Z,HIGHA		;Z - pick up
HIGHB	LD	(HIGH1),HL	;set HIGH$
	RET			;return
HIGHA	LD	HL,(HIGH1)	;p/u HIGH$
	RET			;return
	ENDIF			;
