;DDFORMA - DiskDISK Formatter/Creator Program - 11/10/83
;
	SUBTTL	<'DDFORMA - Formatter/Creator'>
	PAGE
;
;*=*=* Make a DiskDISK Dude *=*=*
;
START
	IF	V6
	@@CKBRKC		;Check for break
	JR	Z,STARTA	; if not continue
	LD	HL,-1
	RET			; if so abort
	ENDIF
;
STARTA	LD	(SAVESP),SP	;Save return address
	CALL	DOINIT		;P/u parms & filespec
	CALL	PROMPT		;Issue prompts
	CALL	SETDCT		;Set up DCT
	CALL	CREATE		;Create DiskDISK
	CALL	FORMDSK		;Format DiskDISK
	CALL	DISPEXM		;Display Exit message
;
;*=*=* Clean Exit - Set HL = 0 and return *=*=*
;
EXIT	LD	HL,0		;Issue a clean exit
;
	IF	V5
	JP	@EXIT
	ELSE
	@@CKBRKC
	RET			;
	ENDIF
;
;*=*=* Internal error exit routine *=*=*
;
EXISTS	LD	HL,EXISTS$	;File Already Exists
	CALL	LOGOT		;Log error
	LD	HL,-1
	JR	EXIT3		;Don't kill file!
BADNEWS	CALL	LOGOT		;
;
;*=*=* Version 5.1 I/O Error & internal error exit *=*=*
;
	IF	V5		;Version 5
EXIT2	EQU	$
ABORT	CALL	CKOPN
EXIT3	JP	@ABORT
	ENDIF
;
;*=*=* Version 6.x I/O Error & internal error exit *=*=*
;
	IF	V6		;Version 6
ABORT	LD	HL,-1		;Abort JCL
EXIT2	PUSH	HL
	CALL	CKOPN
	POP	HL
EXIT3	LD	SP,(SAVESP)	;P/u original SP
	@@CKBRKC
	RET			;RETurn w/ condition
	ENDIF
;
;*=*=* Kill File if it is open *=*=*
;
CKOPN	LD	DE,DISKFCB	;DE => DiskDISK FCB
	LD	A,(DE)		;Aborting w/file OPEN?
	RLCA			;Bit 7
	CALL	C,KILL		;KILL it!
	RET
;
;*=*=* Sign in Please ... *=*=*
;
DOINIT
	PUSH	HL		;Sign on
	LD	HL,HELLO$	;DiskDISK bogus
	CALL	DSPLY		;
	POP	HL		;
	CALL	IOINIT		;Initialize I/O stuff
;
;*=*=* Any parameters entered *=*=*
;
	PUSH	HL		;Save command ptr
	DEC	HL		;
PLOOP	INC	HL		;Bump cmd line ptr
	LD	A,(HL)		;P/u char
	CP	CR		;End of line ?
	JR	Z,NOPARMS	;Yes - no parameters
	CP	'('		;Parms ?
	JR	NZ,PLOOP	;No - go til terminator
;
;*=*=* Process any parameter(s) entered *=*=*
;
GETPRM	LD	DE,PARMTBL	;DE => parameter table
	CALL	PARAM		;Process parameter(s)
	CALL	Z,CKPARMS	;Make sure valid parms
	JP	NZ,PRMERR	;Abort on Parameter Error
;
;*=*=* Was a filespec entered ? *=*=*
;
NOPARMS	POP	HL		;HL => command line
	CALL	SKIPSPC		;Skip any leading spaces
PRFSP2	LD	DE,DISKFCB	;DE => DiskDISK FCB
	CALL	FSPEC		;
PRFSP	CALL	NZ,PRFSPEC	;NZ - prompt for filespec
	CALL	NZ,AB_JCL	;Abort if JCL
	JR	NZ,PRFSP	;
;
;*=*=* Got filespec - use default extension of /DSK *=*=*
;
	LD	HL,DEF_EXT	;File has a default
	CALL	FEXT		;Extension of /DSK.
;
;*=*=* Are we able to make this file a DiskDISK ? *=*=*
;
	LD	HL,IOBUFF	;HL => I/O Buffer
	LD	B,L		;B = 0 = LRL of 256
	CALL	INIT		;Init File
	JR	NZ,BADINIT	;NZ - I/O Error
	JP	NC,EXISTS	;NC - File Already Exists
	RET			;Z - Good Job
;
;*=*=* Something went wrong - What ? *=*=*
;
BADINIT	CP	37		;Illegal Access attempt ?
	JR	Z,FEXISTS	;
	CP	25		;File Access Denied ?
	JR	Z,FEXISTS	;
	CP	41		;File already Open ?
	JR	Z,FEXISTS	;
	CP	42		;LRL Open Fault ?
;
;*=*=* Reset File open bit in directory *=*=*
;
	PUSH	AF		;Save Error code, CP stat
	CALL	CLOSE		;CLOSE file, ignore error
	POP	AF		;
;
;*=*=* Display "File already Exists" or I/O error *=*=*
;
FEXISTS	JP	Z,EXISTS	;File Already Exists
	CALL	IOERR		;Go to I/O error handler
;
;
;********************************************************
;***                                                  ***
;*** CKPARMS - Check if parameter types are legal     ***
;***                                                  ***
;***         - Z <= Set if legal parameters entered   ***
;***                or no entry                       ***
;***         - TVAL = Type of DiskDISK (1,2,5 or 8)   ***
;***         - CVAL = Quantity of Cylinders (3-255)   ***
;***         - DVAL = Density (1=SDEN, 0=DDEN)        ***
;***         - SVAL = Sides (0 = 1 side, 1 = 2 sides) ***
;***                                                  ***
;********************************************************
;
CKPARMS
	CALL	CKTYPE		;TYPE legal ?
	RET	NZ		;No - RETurn NZ
	CALL	CKCYLS		;CYLINDERS legal ?
	RET	NZ		;No - RETurn NZ
	CALL	CKDENS		;DENSITY legal ?
	RET	NZ		;No - RETurn NZ
	CALL	CKSIDES		;SIDES legal ?
	RET	NZ		;Return w/ condition
;
;	Init stored values
;
	CALL	CALSIZE
	RET
;
;*=*=*     Check CYLINDERS     *=*=*
;
	IF	V5
CKCYLS	LD	HL,(CPARM)	;Get parm value
	LD	A,H
	CP	0FEH		;Still default?
	RET	Z
	LD	A,0FFH		;Flag value
	LD	(CRESP),A	;Was entered
	JR	CKCYLS3		;check value
CKCYLS2	OR	A		;entered ?
	RET	Z		;no - use default
	ENDIF
;
	IF	V6
CKCYLS	LD	A,(CRESP)	;P/u CYLINDERS
	LD	HL,(CPARM)	;P/u CYLS
CKCYLS2	OR	A		;CYLS entered ?
	RET	Z		;No - RETurn Z
	XOR	NUM		;NZ if not numeric
	RET	NZ		;
	ENDIF
;
CKCYLS3	INC	H		;256 not acceptable
	DEC	H		;
	RET	NZ		;
	LD	A,L		;P/u low byte
	CP	3		;Less than 3 ?
	RET	C		;Yes - return NZ
	CP	97		;Greater than 96 ?
	JR	NC,BADCYL	;Yes - return NZ
	LD	(CVAL),A	;No - save val
	CP	A		;Legal - Set Z flag
	RET			;
BADCYL	OR	A		;
	RET			;RETurn NZ
;
;*=*=*     Check TYPE     *=*=*
;
	IF	V5
CKTYPE	LD	HL,(TPARM)	;P/u resp
CKTYPE2	LD	A,H
	CP	0FEH		;Still default?
	RET	Z		;Then leave
	LD	A,0FFH		;Entered..
	LD	(TRESP),A	;Set TRUE
	ENDIF
;
	IF	V6
CKTYPE	LD	A,(TRESP)	;P/u TYPE
	LD	HL,(TPARM)	;P/u TYPE
CKTYPE2	OR	A		;Entered ?
	RET	Z		;No RETurn Z
	XOR	NUM		;NZ if not numeric
	RET	NZ		;
	ENDIF
;
	INC	H		;High byte must = 0
	DEC	H		;
	RET	NZ		;
	LD	A,L		;P/u low byte
	LD	D,A		;D = Type
	LD	(TVAL),A	;Save type
	DEC	A		;TYPE = 1 ?
	RET	Z		;Yes - RETurn
	DEC	A		;TYPE = 2 ?
	RET	Z		;Yes - RETurn
	CP	5-2		;TYPE = 5 ?
	RET	Z		;Yes - RETurn
	CP	8-2		;TYPE = 8
	RET			;RETurn w/ condition
;
;*=*=*     Check DENSITY     *=*=*
;
	IF	V5
CKDENS	LD	HL,(DPARM)
	LD	A,H
	CP	0FEH
	RET	Z
	LD	A,0FFH
	LD	(DRESP),A
	ENDIF
;
	IF	V6
CKDENS	LD	A,(DRESP)	;P/u DENSITY
	LD	HL,(DPARM)	;P/u address of string
	AND	11100000B	;Mask off length
	RET	Z		;Z - not entered
	XOR	STR		;NZ if not a string
	RET	NZ		;
	ENDIF
;
;*=*=* P/u DENSITY response *=*=*
;
CKDENS2	LD	A,(HL)		;P/u char
	LD	HL,DVAL		;HL => Density Value
	LD	(HL),1		;SDEN = 1
	RES	5,A		;Convert to U/C
	CP	'S'		;
	RET	Z		;
	DEC	(HL)		;DDEN = 0
	CP	'D'		;Double Density ?
	RET			;Return w/ condition
;
;*=*=*     Check SIDES     *=*=*
;
	IF	V5
CKSIDES	LD	HL,(SPARM)	;Get value
	LD	A,H
	CP	0FEH		;Default?
	RET	Z
	LD	A,0FFH		;Set TRUE
	LD	(SRESP),A
	JR	CKSIDE3		;check value
CKSIDE2	OR	A		;entered ?
	RET	Z		;no - use default
	ENDIF
;
	IF	V6
CKSIDES	LD	A,(SRESP)	;P/u SIDES
	LD	HL,(SPARM)	;P/u SIDES
CKSIDE2	OR	A		;Entered ?
	RET	Z		;No - RETurn Z
	XOR	NUM		;NZ if not numeric
	RET	NZ		;
	ENDIF
;
CKSIDE3	INC	H		;Msb must = 0
	DEC	H		;
	RET	NZ		;
	LD	A,L		;P/u lsb
	DEC	A		;Sides = 1 ?
	LD	(SVAL),A	;
	RET	Z		;Yes - RETurn Z
	DEC	A		;Sides = 2 ?
	RET			;RETurn w/ condition
;
;
;********************************************************
;***                                                  ***
;*** CALSIZE - Calculate DCT+7 and DCT+8 bytes        ***
;***                                                  ***
;********************************************************
;
CALSIZE
	LD	A,(TVAL)	;P/u TYPE
	LD	DE,T1		;DE => Type 1
	DEC	A		;
	JR	Z,GOTIT		;
	INC	DE		;
	INC	DE		;DE => Type 2
	DEC	A		;
	JR	Z,GOTIT		;
	INC	DE		;
	INC	DE		;DE => Type 5
	CP	5-2		;
	JR	Z,GOTIT2	;
	LD	DE,T8		;DE => Type 8
GOTIT2	LD	A,(DVAL)	;P/u density
	OR	A		;
	JR	NZ,GOTIT	;Single Density ?
	INC	DE		;No - pos to DDEN
	INC	DE		;
GOTIT	LD	A,(DE)		;P/u DCT+7
	LD	(DCT+7),A	;
	INC	A		;Offset from zero
	LD	HL,SVAL		;Sides = 2 ?
	BIT	0,(HL)		;
	JR	Z,$+3		;
	ADD	A,A		;Yes - mult S/C x 2
	LD	(SPC),A		;
	DEC	A		;Driver INCs it
	LD	(DS_P_C),A	;Stuff into Linkage
	INC	DE		;
	LD	A,(DE)		;P/u DCT+8
	LD	(DCT+8),A	;
	RLCA			;Get G/T
	RLCA			;
	RLCA			;
	AND	7		;Mask off other junk
	LD	(GPT),A		;Save Grans/Track
	INC	A		;Offset from zero
	BIT	0,(HL)		;Sides = 2 ?
	JR	Z,$+3		;
	ADD	A,A		;Yes - double it
	LD	(GPC),A		;
	CP	A		;Show no errors here
	RET			;
;
T1	DB	7,7<5,15,7<5!1,9,1<5!4,17,2<5!5
T8	DB	15,1<5!7,29,2<5!9
;
;
;********************************************************
;***                                                  ***
;*** CREATE - Create DiskDISK file                    ***
;***                                                  ***
;********************************************************
;
;*=*=* Calculate ERN - Sectors/Cyl x Cyls - 1 *=*=*
;
CREATE	CALL	CALSIZE		;Get SPC/GPC
	LD	A,(CVAL)	;P/u # of cylinders
	LD	C,A		;Xfer to C
	LD	A,(SPC)		;P/u # of sectors/cyl
	LD	L,A		;Xfer to HL
	LD	H,0		;HL = S/C, C = cylinders
	CALL	MUL16		;Multiply HL x C
	LD	B,L		;Move into BC
	LD	C,A		;
;
;*=*=* Create DiskDISK file by @WRITing ERN *=*=*
;
	LD	DE,DISKFCB	;DE => DiskDISK FCB
	CALL	POSN		;Position to ERN
	CALL	WRITE		;Write ERN
	JR	NZ,KILLFIL	;Bad - Kill File
;
;*=*=* Set the PDS bit in the file's DIR entry *=*=*
;
	PUSH	DE		;Save FCB Ptr
	LD	BC,(DISKFCB+6)	;p/u DEC/Drive #
	CALL	DIRRD		;Read directory entry
	JR	NZ,KILLFIL	;bad - kill file
	SET	PDSBIT,(HL)	;indicate PDS file type
	PUSH	HL		;save pointer
	CALL	DIRWR		;Write back to directory
	POP	HL		;recover pointer
	JR	NZ,KILLFIL	;bad - kill file
;
;*=*=* Transfer Filename to ID field *=*=*
;
	LD	BC,5		;posn to filename
	ADD	HL,BC		;
	LD	DE,GAT_ID	;DE => Disk name
	LD	C,8		;8 chars to xfer
	LDIR			;transfer
;
;*=*=* Successful Directory Write - Close File *=*=*
;
	POP	DE		;DE => FCB
	PUSH	DE		;Save FCB ptr
	EX	DE,HL		;Xfer to HL
	LD	DE,CL_FCB	;DE => FCB to @CLOSE
	LD	BC,32		;
	PUSH	DE		;Save ptr
	LDIR			;Xfer
	POP	DE		;
	CALL	CLOSE		;Can we close it ?
	POP	DE		;DE => Open FCB
	RET	Z		;Yes - RETurn
;
;*=*=* I/O Error - KILL file, display error & abort *=*=*
;
KILLFIL	PUSH	AF		;Save error code
	CALL	KILL		;Kill the file
	POP	AF		;Restore error code
	JP	IOERR		;Display error
;
;
;********************************************************
;***                                                  ***
;*** FORMDSK - Format a NEW DiskDISK                  ***
;***                                                  ***
;********************************************************
;
FORMDSK
	CALL	GET_DAT		;Stuff S/C & G/C in link
	CALL	GET_EXT		;Get extents into linkage
	LD	HL,TOOMANY	;Error msg
	JP	NZ,BADNEWS	;Z - good job
	CALL	WRIDSEC		;Write ID sector
	CALL	WRBOOT		;Write BOOT/SYS
	CALL	WRDIR		;Write Directory
	RET			;Done
;
WRDIR
	LD	HL,IOBUFF	;HL => I/O buffer
FILLIOB	LD	(HL),0		;Fill I/O buffer
	INC	L		;
	JR	NZ,FILLIOB	;
	LD	A,(SPC)		;P/u Sectors/Cyl
	CP	34		;Max of 34 records
	JR	C,NOTMAX	;
	LD	A,34		;Init to max
NOTMAX	LD	B,A		;Xfer to B for DJNZ
	LD	DE,100H		;D = Cyl 1, E = Sector 0
FILDIR	CALL	WRSEC		;Fill up directory
	INC	E		;Bump sector #
	DJNZ	FILDIR		;
	CALL	WRGAT		;Initialize GAT
	CALL	WRHIT		;Initialize HIT
	CALL	WRENT		;Put DIR & BOOT entries
	RET			;Done
;
WRIDSEC
	LD	HL,IOBUFF	;HL => I/O buffer
CLBF	LD	(HL),0		;Clear out buffer
	INC	L		;
	JR	NZ,CLBF		;
	EX	DE,HL		;Pt DE => Buffer
	LD	HL,PACK_ID	;Xfer name into ID sector
	LD	BC,8		;
	LDIR			;
	LD	HL,DCT		;Xfer DCT into ID
	LD	C,10		;10 bytes to xfer
	LDIR			;
;
;*=*=* Put DiskDISK type (1,2,5, or 8) in ID *=*=*
;
	LD	A,(TVAL)	;p/u type of DiskDISK
	LD	(DE),A		;xfer into ID sector
	LD	DE,DISKFCB	;DE => DiskDISK FCB
	CALL	REW		;Write Record X'0000'
	CALL	WRITE		;
	RET	Z		;RETurn if ok
	JP	IOERR2		;Go to I/O error routine
;
;***
;       WRBOOT - Write BOOT/SYS information
;***
;
WRBOOT	XOR	A		;Fill byte
	LD	HL,IOBUFF	;HL => I/O buffer
;
;*=*=* Fill BOOT/SYS with Zeroes *=*=*
;
FILBUF	LD	(HL),A		;Stuff in byte
	INC	L		;One sector to
	JR	NZ,FILBUF	;Fill
;
;*=*=* Write # of Sectors in BOOT *=*=*
;
	LD	D,A		;Cylinder 0
	LD	E,A		;Sector 0
BTSECS	LD	B,6		;6 sectors to write
BTLP	CALL	WRSEC		;Write sector
	INC	E		;Bump
	DJNZ	BTLP		;
;
;*=*=* Write Directory Cylinder byte in Sector Zero *=*=*
;
	LD	L,2		;Byte 2
	LD	(HL),1		;Directory cyl = 1
;
;*=*=* Write Sector 0 of Cylinder 0 *=*=*
;
	LD	DE,0		;Cylinder 0, Sector 0
	CALL	WRSEC		;Write Sector
;
;*=*=* Make a duplicate of sector 0 in sector 1 *=*=*
;
	INC	E		;Sector 1
	CALL	WRSEC		;Write sector
;
;*=*=* Write C/R in Auto Buffer in Sector 2 *=*=*
;
	LD	E,2		;Sector 2
	LD	L,20H		;Byte X'20'
	LD	(HL),CR		;No auto
	LD	L,0C0H		;HL => System Disk byte
	LD	(HL),0		;0 = Not a System Disk
;
;*=*=* 6.x type 2 disks need X'FF' in X'C0' sect 2 *=*=*
;
	IF	V6		;Force system disk
	LD	A,(TVAL)	; on type 2 DiskDISKs
	CP	2		;
	JR	NZ,$+3		;
	DEC	(HL)		; show system disk
	ENDIF			;
;
;*=*=* Write sector & return *=*=*
;
	CALL	WRSEC		;Write sector
	RET			;RETurn for now
;
;
;***
;       WRGAT - Write Granule Allocation Table
;***
;
WRGAT
;
;*=*=* Create a Free GAT allocation byte *=*=*
;
	LD	A,(GPC)		;P/u grans/cylinder
	LD	B,A		;Xfer to B
	XOR	A		;Set GAT byte = X'00'
	SCF			;
GLOOP	RLA			;Shift bit into byte
	DJNZ	GLOOP		;
	LD	B,A		;Copy to B
	DEC	A		;Set bits below it
	OR	B		;And that bit
	CPL			;Now flip byte
	LD	(FBYTE),A	;Stuff into loop
	INC	A		;
	LD	C,A		;C = BOOT Allocation byte
	LD	HL,IOBUFF	;HL => I/O buffer
	LD	A,(TVAL)	;P/u TYPE
	LD	B,0FH		;Type 1 = 4 grans
	DEC	A		;
	JR	Z,GAT0		;
;
;*=*=* 6.x type 2 = X'FF', 5.1 type 2 = X'03' *=*=*
;
	IF	V6		;use entire cylinder on
	LD	B,0FFH		;type 2 for 6.x
	ENDIF			;
	IF	V5		;use 2 grans on cylinder
	LD	B,03H		; zero, on type 2 for 5.1
	ENDIF			;
;
;*=*=* Is this a type 5 or 8 diskdisk ? *=*=*
;
	DEC	A		;
	JR	Z,GAT0		;
	LD	B,C		;Else use 1 gran
GAT0	LD	(HL),B		;Stuff BOOT/SYS byte
	INC	HL		;Bump
;
;*=*=* Lock out next X'CA' bytes in GAT *=*=*
;
	LD	B,0CAH		;Lock out the bytes
LOCKOUT	LD	(HL),0FFH	;GAT + X'01' through
	INC	HL		;GAT + X'CA'
	DJNZ	LOCKOUT		;
;
;*=*=* GAT + X'CB' *=*=*
;
	LD	(HL),RLS	;GAT + X'CB'= Version num
;
;*=*=* GAT + X'CC' *=*=*
;
CYLCNT	LD	A,$-$		;P/u cylinder count
	PUSH	AF		;Save Cylinder count
	SUB	35		;Tracks in excess of 35
	INC	HL		;HL => next GAT byte
	LD	(HL),A		;GAT + X'CC'= tracks - 35
;
;*=*=* GAT + X'CD' *=*=*
;
	INC	HL		;GAT + X'CD' =
GATCD	LD	(HL),$-$	;Density, Sides, G/C
;
;*=*=* If this is a type 2 on 6.0 - use X'47' *=*=*
;
	IF	V6		;
	LD	A,(TVAL)	;p/u type
	CP	2		;Is it type 2 ?
	JR	NZ,$+4		;no
	LD	(HL),47H	;yes - use X'47'
	ENDIF			;
;
;*=*=* GAT + X'CE' & X'CF' *=*=*
;
	INC	HL		;GAT + X'CE' & X'CF' =
	LD	(HL),0E0H	;16-bit Hash code of
	INC	HL		;"PASSWORD"
	LD	(HL),42H	;Hash = X'E042'
;
;*=*=* GAT + X'D0' - X'D7' *=*=*
;
	INC	HL		;HL => next GAT byte
	LD	DE,GAT_ID	;DE => Disk Name
	LD	C,8		;Eight bytes
	EX	DE,HL		;Swap 'em for LDIR
	LDIR			;Stuff in ID
	EX	DE,HL		;HL => GAT + X'D8'
;
;*=*=* GAT + X'D8' - X'DF' *=*=*
;
	CALL	DATE		;Stuff date in GAT
;
;*=*=* Fill GAT with allocation bytes *=*=*
;
	LD	HL,IOBUFF+2	;HL => GAT + X'02'
	POP	BC		;B = # cylinders
	DEC	B		;Subtract 2 to account
	DEC	B		;For BOOT and DIR
;
;*=*=* Stuff open cylinder bytes into GAT *=*=*
;
	LD	A,(FBYTE)	;P/u FREE byte
FREETRK	LD	(HL),A		;Free track
	INC	HL		;Next GAT byte
	DJNZ	FREETRK		;Do it B times
;
;*=*=* Put 2 free Cyl bytes in lockout - BOOT & DIR *=*=*
;
	LD	L,60H		;HL => Lockout
	LD	(HL),A		;
	INC	L		;
	LD	(HL),A		;
;
	IF	V6
	LD	DE,IOBUFF+255-11;6.2 Media Data Block
	LD	HL,LSIID	;point to header
	LD	BC,04		;set length
	LDIR			; move it
	LD	HL,DCT+3	; The data to move
	LD	C,7		; bytes to move
	LDIR			; move it in
	JR	WRGAT1		;skip around string
LSIID	DB	03,'LSI'
	ENDIF
;
;*=*=* GAT + X'62' - GAT + X'BF' *=*=*
;
WRGAT1	LD	HL,IOBUFF+2	;HL => GAT+X'02'
	LD	DE,IOBUFF+60H+2	;DE => GAT+X'62'
	LD	C,60H-2		;Create Lockout table
	LDIR			;HL => GAT, DE => Lockout
	LD	DE,100H		;D = Cyl 1, E = Sector 0
	LD	A,(TVAL)	;If type 1 or 2
	CP	3
	JR	NC,GATWR1
	LD	L,60H		;Lock out gran 0 
	SET	0,(HL)		;Stop mirror BACKUP!
GATWR1	JP	WRSEC		;
;
;
;***
;       WRHIT - Write HIT sector in directory
;***
;
WRHIT	XOR	A		;Set A = 0
ZEROHIT	LD	(HL),A		;Zero HIT position
	INC	L		;Bump HIT pointer
	JR	NZ,ZEROHIT	;256 positions
	LD	(HL),0A2H	;Hash for BOOT/SYS
	INC	L		;HL => HIT + X'01'
	LD	(HL),0C4H	;Hash for DIR/SYS
	INC	E		;D = Cyl 1, Sector 1
	JP	WRSEC		;Write Sector & RETurn
;
;
;***
;       WRENT - Write DIR/SYS & BOOT/SYS entries
;***
;
WRENT
	LD	A,(TVAL)	;P/u TYPE
	DEC	A		; type 1 = 4 grans
	LD	B,4-1		;
	JR	Z,GT_GRN	;
	DEC	A		; type 2 ?
;
;*=*=* 6.x type 2 = 8 grans, 5.1 type 2 = 2 grans *=*=*
;
	IF	V6		;6.x uses 8 grans
	LD	B,8-1		;
	ENDIF			;
	IF	V5		;5.1 uses 2 grans
	LD	B,2-1		;
	ENDIF			;
	JR	NZ,GT_GRN2	;
;
;*=*=* Stuff Gran info in BOOT/SYS directory entry *=*=*
;
GT_GRN	LD	A,B		;P/u # of cont grans
	LD	(BOOTGRN),A	;Stuff into entry
;
;*=*=* 6.x type 2 ERN = 16 *=*=*
;
	IF	V6		;6.x ?
	LD	A,(TVAL)	;type 2 ?
	CP	2		;
	JR	NZ,GT_GRN2	;no
	LD	A,10H		;ERN = X'10'
	LD	(BOOTERN),A	;
	ENDIF			;
;
;*=*=* Transfer BOOT/SYS entry into buffer *=*=*
;
GT_GRN2	LD	DE,BOOT		;BOOT/SYS byte field
	EX	DE,HL		;Swap for LDIR
	LD	BC,32		;32 bytes in entry
	LDIR			;Block move
	LD	DE,102H		;D = Cyl 1, E = Sector 2
	CALL	WRSEC		;Write Sector
;
	LD	A,(GPC)		;P/u Grans/Cylinder
	DEC	A		;
	LD	(DIRGRN),A	;Stuff into entry
	LD	A,(SPC)		;P/u Sectors/Cylinder
	LD	(DIRERN),A	;Stuff into entry
	LD	BC,32		;
	EX	DE,HL		;Xfer buffer ptr to DE
	LD	HL,DIR		;HL => DIR/SYS bytes
	LDIR			;Xfer
	LD	DE,103H		;D = Cyl 1, E = Sector 3
	JP	WRSEC		;Write sector & RETurn
;
;*=*=* BOOT/SYS directory entry data *=*=*
;
BOOT	DB	01011110B	;No access,inv,sys,FPDE
	DW	0		;Date = 00/00/00
	DW	0		;EOF offset = 0, LRL=256
	DB	'BOOT    '	;Name field
	DB	'SYS'		;Extension
;
	IF	V5
	DW	01AEH
	DW	9CF5H
	ELSE
	DW	037F6H		;Owner password hash
	DW	09CF5H		;User password hash
	ENDIF
;
BOOTERN	DW	4		;ERN = 4
	DB	0		;First extent = Cyl 0
BOOTGRN	DB	0		;St gran = 0, 1 cont gran
	DW	0FFFFH		;No more extents
	DW	0FFFFH		;
	DW	0FFFFH		;
	DW	0FFFFH		;
;
;*=*=* DIR/SYS directory entry data *=*=*
;
DIR	DB	01011101B	;Read only,inv,sys,FPDE
	DW	0		;Date= 00/00/00
	DW	0		;EOF offset=0, LRL=256
	DB	'DIR     '	;Name field
	DB	'SYS'		;Extension
;
	IF	V5
	DW	01AEH
	DW	4296H
	ELSE
	DW	037F6H		;Owner password hash
	DW	4296H		;User password hash
	ENDIF
;
DIRERN	DW	18		;ERN+1 = 10 or 18
	DB	1		;Starts on cylinder 1
DIRGRN	DB	00000010B	;St. gran=0, 3 cont grans
	DW	0FFFFH		;No Second Extent
	DW	0FFFFH		;No Third Extent
	DW	0FFFFH		;No Fourth Extent
	DB	0FFH		;No further records
	DB	0FFH		;No DEC for DIR/SYS
;
;
;***
;       RDSEC/WRSEC - Read/Write a DiskDISK Sector
;***
;
RDSEC	LD	A,9		;@RDSEC function #
	JR	DO_IO		;
WRSEC	LD	A,13		;@WRSEC SVC #
DO_IO	LD	HL,IOBUFF	;HL => I/O buffer
	LD	IY,DCT		;Pt IY => DCT
	PUSH	BC		;Save B
	LD	B,A		;Xfer fcn # to B
	CALL	LINKAGE		;CALL the driver
	POP	BC		;Restore B
	RET	Z		;Z - RETurn
	CP	6		;Read system sec err ?
	RET	Z		;Yes - it's O.K.
IOERR2	CALL	IOERR		;Use CALL for debugging
;
;
;********************************************************
;***                                                  ***
;*** SETDCT - Create DCT & GAT information            ***
;***                                                  ***
;********************************************************
;
SETDCT
;
;*=*=* DCT+3 *=*=*
;
	XOR	A		;Set DCT+3=0
	LD	B,A		;B = GAT+X'CD' byte
	LD	HL,TVAL		;HL => Type (1,2,5,8)
	BIT	3,(HL)		; Set Bit 5 of DCT+3
	JR	Z,$+4		; only if TYPE = 8"
	SET	5,A		;
	LD	HL,DVAL		;HL => Density (1=SDEN)
	BIT	0,(HL)		;Set Bit 6 of DCT+3
	JR	NZ,$+6		; and Bit 6 of GAT+X'CD'
	SET	6,A		; if Double density.
	SET	6,B		;
	LD	(DCT+3),A	;Save DCT+3
;
;*=*=* DCT+4 *=*=*
;
	LD	A,(DISKFCB+6)	;P/u drive # DD is on
	LD	(DD_DRV),A	;Stuff into Linkage
	LD	C,A		;Xfer to C for @GTDCT
	CALL	GTDCT		;Pt IY to DCT of DD drive
	LD	A,(IY+4)	;P/u DCT+4
	AND	00010000B	;Save bit 4
	LD	HL,SVAL		;HL => Sides (1=2 sides)
	BIT	0,(HL)		;Double sided ?
	JR	Z,$+6		;No - don't set it
	SET	5,A		;Set Double bit
	SET	5,B		;Show in GAT+X'CD'
	LD	(DCT+4),A	;
	LD	A,(GPT)		;P/u Grans/Track
	OR	B		;Merge Density/Sides
	IF	V6		;For 6.x..
	SET	7,A		;Show as data disk
	ENDIF
	LD	(GATCD+1),A	;Save for GAT creation
;
;*=*=* DCT+6 *=*=*
;
DO_CYL	LD	A,(CVAL)	;P/u # of cylinders
	LD	(CYLCNT+1),A	;Save cylinder count
	DEC	A		;
	LD	(DCT+6),A	;DCT+6 = highest # cyl
	RET			;And RETurn
;
;
;*******************************************************
;***                                                 ***
;*** CALCK - Calculate Kilobyte value                ***
;***                                                 ***
;***       - A  => Number of Sectors                 ***
;***       - HL => Destination of ASCII string       ***
;***                                                 ***
;*******************************************************
;
CALCK	LD	B,A		;Save # of sectors
;
;*=*=* Create Full K string *=*=*
;
	SRL	A		;Divide by 4
	SRL	A		;
	LD	(HL),' '	;Init first digit to spc
	CP	9+1		;Less than 10 ?
	JR	C,GTDIG		;
	LD	(HL),'1'	;Must be 1x
	ADD	A,'0'-10	;Cvt second dig to ASCII
	INC	HL		;Bump
	JR	DO_HUN		;Get hundredths
GTDIG	INC	HL		;Bump
	OR	'0'		;Cvt to ASCII
DO_HUN	LD	(HL),A		;
;
;*=*=* P/u partial K from string table *=*=*
;
	INC	HL		;Go past dec pt
	INC	HL		;
	EX	DE,HL		;Xfer into DE
	LD	A,B		;P/u total sectors
	AND	3		;
	ADD	A,A		;Multiply offset by 2
	LD	C,A		;
	LD	B,0		;BC = offset into
	LD	HL,HUNDTAB	;HL => Hundredths table
	ADD	HL,BC		;Pt to partial K string
	LD	C,2		;Two chars to xfer
	LDIR			;
	RET			;Done
;
;
;********************************************************
;***                                                  ***
;*** PROMPT  - Issue prompts for DiskDISK parameters  ***
;***                                                  ***
;********************************************************
;
PROMPT
	LD	HL,TVAL		;HL => TYPE
	LD	A,(HL)		;P/u TYPE
	OR	A		;Entered ?
	JR	NZ,T1OR2?	;Yes - ck if 1 or 2
	LD	(HL),5		;Default = 5
;
;*=*=* TYPE was not entered - was anything else ? *=*=*
;
	CALL	GETCYL		;Get CYLs default
	LD	A,(CRESP)	;
	LD	HL,DRESP	;
	OR	(HL)		;
	LD	HL,SRESP	;
	OR	(HL)		;
	JR	Z,PTYPE2	;No - prompt for 'em all
	RET			;Yes - RETurn
;
;*=*=* Is TYPE = 1 or 2 ? *=*=*
;
T1OR2?	CALL	GETCYL		;Get default cyls
	LD	A,(TVAL)	;P/u TYPE
	DEC	A		;
	JR	Z,CK_CYLS	;If TYPE = 1 or 2
	DEC	A		; then CYLS must
	RET	NZ		; be known.
;
;*=*=* TYPE 1 or 2 - must have CYLINDER value *=*=*
;
CK_CYLS	LD	A,(CRESP)	;CYLs entered ?
	OR	A		;
	JP	Z,PCYL		;No - prompt for it
	RET			;Yes - got all we need
;
;*=*=* Prompt for TYPE of DiskDISK *=*=*
;
PTYPE2
	LD	A,5		;Set TYPE default = 5
	LD	(TVAL),A	;
	LD	HL,P_TYPE	;Input TYPE
	CALL	INPUT1		;Input 1 char
	LD	HL,(FPARM)	;P/u answer
	CALL	CKTYPE2		;Check if TYPE is valid
	CALL	NZ,AB_JCL	;Abort JCL if Bad
	JR	NZ,PTYPE2	;No - reprompt
;
;*=*=* Skip SIDES & DENSITY if TYPE = 1 or 2 *=*=*
;
	LD	A,(TVAL)	;P/u TYPE
	CP	3		;Skip SIDES & DENSITY
	JR	C,PCYL		;If TYPE 1 or 2
;
;*=*=* Prompt for SIDES *=*=*
;
PSIDES
	XOR	A		;Set Default = 1 (SVAL=0)
	LD	(SVAL),A	;
	LD	HL,P_SIDES	;Prompt for sides
	CALL	INPUT1		;
	LD	HL,(FPARM)	;Get answer
	CALL	CKSIDE2		;Check sides
	CALL	NZ,AB_JCL	;Abort if JCL
	JR	NZ,PSIDES	;Reprompt if invalid
;
;*=*=* Prompt for DENSITY *=*=*
;
PDENS
	LD	HL,P_DENS	;Prompt for density
	CALL	DSPLY		;
	LD	B,1		;<S> or <D>
	CALL	INPUT		;Input string
	CALL	NZ,CKDENS2	;Check density
	CALL	NZ,AB_JCL	;Abort if JCL
	JR	NZ,PDENS	;Reprompt if invalid
;
;*=*=* Create CYLINDER prompt *=*=*
;
PCYL
	CALL	CALSIZE		;Calculate size stuff
	LD	A,(SPC)		;P/u sectors/cylinder
	LD	HL,K_CYL	;HL => K value
	CALL	CALCK		;Stuff into string
	CALL	GTCYLDF		;Get CYL default
	JR	Z,PCYL2		;Skip LDIR if 5" or 8"
;
;*=*=* TYPE 1 or 2 - Erase default cyls *=*=*
;
ERDEF	LD	HL,CYLS+2	;HL => End of Cyl str
	LD	DE,K_CYL2	;DE => 1 past K string
	LD	BC,5		;BC = 5 bytes to xfer
	LDIR			;
;
;*=*=* Prompt for CYLINDERS *=*=*
;
PCYL2
	LD	HL,P_CYL	;Input 2 chars max
	LD	B,2		;
	CALL	INPUT2		;
	LD	HL,(FPARM)	; get answer
	CALL	CKCYLS2		;Check if legal
	CALL	NZ,AB_JCL	;Abort if JCL
	JR	NZ,PCYL2	;Reprompt if illegal
	RET			;Done - RETurn Z
;
;
;********************************************************
;***                                                  ***
;*** GTCYLDF - Get Cylinder Default value into CVAL   ***
;***                                                  ***
;********************************************************
;
GETCYL
	LD	A,(CRESP)	;CYLs entered ?
	OR	A		;
	RET	NZ		;Yes - RETurn
GTCYLDF
	LD	HL,CVAL		;HL => Cyls value
	LD	(HL),77		;Default = 77
	LD	DE,'77'		;DE = string
	LD	A,(TVAL)	;8" SDEN or DDEN
	CP	8		;
	JR	Z,GOTCYL	;
	LD	(HL),35		;Default = 35 for
	LD	DE,'53'		;DE = string
	LD	A,(DVAL)	;For 5" SDEN
	OR	A		;
	JR	NZ,GOTCYL	;Got default cyl cnt
	LD	(HL),40		;Default = 40 for
	LD	DE,'04'		;DE = string
	CP	5		;For 5"
GOTCYL	LD	(CYLS),DE	;Save CYL count
	RET			;RETurn w/ condition
;
PARMTBL
	IF	V6		;6.0 Parameter Table
	DB	80H		;6.0 @PARAM
;
;*=*=* CYLINDERS (C) parameter *=*=*
;
	DB	NUM!ABB!9
	DB	'CYLINDERS'
CRESP	DB	0
	DW	CPARM
;
;*=*=* TYPE (T) parameter *=*=*
;
	DB	NUM!ABB!4
	DB	'TYPE'
TRESP	DB	0
	DW	TPARM
;
;*=*=* SIDES (S) parameter *=*=*
;
	DB	NUM!ABB!5
	DB	'SIDES'
SRESP	DB	0
	DW	SPARM
;
;*=*=* DENSITY (D) parameter *=*=*
;
	DB	STR!ABB!7
	DB	'DENSITY'
DRESP	DB	0
	DW	DPARM
;
	DB	0
	ENDIF
;
	IF	V5
	DB	'CYLIND'
	DW	CPARM
	DB	'CYLS  '
	DW	CPARM
	DB	'C     '
	DW	CPARM
	DB	'TYPE  '
	DW	TPARM
	DB	'T     '
	DW	TPARM
	DB	'SIDES '
	DW	SPARM
	DB	'S     '
	DW	SPARM
	DB	'DENSIT'
	DW	DPARM
	DB	'DEN   '
	DW	DPARM
	DB	'D     '
	DW	DPARM
	DW	0
CRESP	DB	0
TRESP	DB	0
SRESP	DB	0
DRESP	DB	0
	ENDIF
;
DISPEXM
	LD	HL,EX_MESS	;DiskDISK created
	CALL	LOGOT		;
	RET			;RETurn
;
CL_FCB	DS	32		;FCB for @CLOSing created
CPARM	DW	0FE00H		;CYLS parm storage
SPARM	DW	0FE00H		;SIDES parm storage
TPARM	DW	0FE00H		;TYPE parm storage
CVAL	DB	0		;Cylinder value
DVAL	DB	0		;Density value
SVAL	DB	0		;Sides value
TVAL	DB	0		;Type value
SPC	DB	0		;Sectors/Cylinder
GPC	DB	0		;Grans/Cylinder
GPT	DB	0		;Grans/Track
FBYTE	DB	0		;Free GAT byte
;
;
;
HELLO$	DB	'DDFORM - DiskDISK Creation Utility',LF
;
	IF	V5.OR.LSI
	DB	'Copyright (C) 1983 by Logical Systems Inc.'
	DB	LF,'Version 1.0.1 ',LF,CR
	ELSE
	DB	'Version'
*GET	CLIENT
	ENDIF
;
;
PRMMSG	DB	'Parameter error',CR
EX_MESS	DB	'DiskDISK File Created',CR
TOOMANY	DB	'Requested file would require more than '
	DB	'12 extents !',CR
;
P_CYL	DB	'Enter Cylinders {Note : 1 Cyl = '
K_CYL	DB	'  .  K'
K_CYL2	DB	', 3-'
CYLS	DB	'96} : ',ETX
P_TYPE	DB	'Enter Disk Type {1, 2, 5, or 8 - '
	DB	'default = 5} : ',ETX
P_DENS	DB	'Enter Density   {Default = double} : '
	DB	ETX
P_SIDES	DB	'Enter Sides     {Default = 1 side} : '
	DB	ETX
EXISTS$	DB	'File Already Exists',CR
FILESP$	DB	'Enter Filespec : ',ETX
HUNDTAB	DB	'00255075'
$DD	DB	'$DD',ETX
DEF_EXT	DB	'DSK'
GAT_ID	DB	'Diskname'
;
	ORG	$<-8+1<+8
;
IOBUFF	DS	256		;I/O Buffer
