;DDCOMMON - DiskDISK Common routines - 11/09/83
;
	SUBTTL	<'DDCOMMON - Common routines'>
	PAGE
;
PACK_ID	DB	'DiskDISK'
;
;
;********************************************************
;***            DiskDISK Driver Program               ***
;***                                                  ***
;*** 1) The Linkage CALLs the Driver Program leaving  ***
;***    the Address of the DiskDISK data zone on the  ***
;***    stack.                                        ***
;*** 2) The Driver program checks function request,   ***
;***    and passes control to the Outside disk        ***
;***    driver for non-I/O functions (0-7) with       ***
;***    D converted to current head position on       ***
;***    the outside disk.  Functions 2 to 5 are       ***
;***    converted to 6 (SEEK on current cyl)          ***
;*** 3) For I/O Functions (8-15), the Cylinder/Sector ***
;***    request (DE) is converted into a relative     ***
;***    sector number in the DiskDISK file. Fcn 14    ***
;***    is changed to 13, also updating new DIR CYL.  ***
;*** 4) The relative sector number is then converted  ***
;***    to a Cylinder/Sector number, and the same     ***
;***    I/O function is passed to the outside disk    ***
;***    driver.                                       ***
;*** 5) If Fcn 7, soft WP is merged with returned     ***
;***    status.  For READ or verify function an error ***
;***    6 is returned if the diskdisk DIR was read.   ***
;***                                                  ***
;********************************************************
;
;
;*=*=* DiskDISK linkage module *=*=*
;
LINKAGE	JR	LENTRY		;6.0 Header
OLDMEML	DW	0		;What mem was before
	DB	3,'$DL'		;Name = "$DL
LENTRY	CALL	DRIVER		;CALL disk driver
DD_DRV	DB	0		;Outside Disk drive #
DD_ST	DB	0		;DiskDISK status byte
DD_DEC	DB	0		;DiskDISK File DEC
DS_P_C	DB	0		;DiskDISK Sectors/Cyl
S_P_C	DB	0		;Outside Sectors/Cylinder
S_P_G	DB	0		;Outside Sectors/Granule
D_CYL	DB	1		;DiskDISK directory cyl
EXTENT	DC	24,0		;Extent Space
;
;
;********************************************************
DD_OFF	EQU	LENTRY-LINKAGE+1 ;Offset to LENTRY+1
LNKLEN	EQU	$-LINKAGE	;LNKLEN=length of module
LNKLEN2	EQU	$-LENTRY	;LNKLEN2=bottom of module
DD_DRV$	EQU	0		;Drive # offset
DD_ST$	EQU	DD_DRV$+1	;Offset to status byte
DD_DEC$	EQU	DD_ST$+1	;offset to DiskDISK DEC
DS_P_C$	EQU	DD_DEC$+1	;Offset to DiskDISK S/C
S_P_C$	EQU	DS_P_C$+1	;Sectors/Cyl offset
S_P_G$	EQU	S_P_C$+1	;Sectors/Gran offset
D_CYL$	EQU	S_P_G$+1	;Directory cyl offset
EXTENT$	EQU	D_CYL$+1	;Extent info offset
EXT0	EQU	EXTENT-DD_DRV-2	;Extent byte 0
EXT1	EQU	EXT0+1		;Extent byte 1
MAX_EXT	EQU	12		;Max # of extents
;********************************************************
;
DRIVER	JR	ENTRY		;6.0 Header
OLDMEM	DW	0		;What mem was before
	DB	3,'$DD'		;Name = "$DD"
CNT_BT	DB	0		;# of linkages
COUNT	EQU	$-DRIVER-1	;Offset to CNT_BT
;
;*=*=* Set IX => Linkage Data Area, & PUSH old IX *=*=*
;
ENTRY	EX	(SP),IX		;IX =>data, (SP) = old IX
;
;*=*=* Update DiskDISK DCT with new Directory Cyl *=*=*
;
	LD	A,(IX+D_CYL$)	;P/u directory cylinder
	LD	(IY+9),A	;Stuff into DCT
;
;*=*=* Save IY (DCT ptr), DE (T/S), & HL (I/O Buff) *=*=*
;
	PUSH	IY		;Save IY, too
	PUSH	DE		;Save C/S request
;
;*=*=* Set C = Outside drive #, IY => DCT & Save BC *=*=*
;
	LD	C,(IX)		;P/u outside disk #
	PUSH	BC		;Save fcn number
;
	IF	V5		;5.1 @GTDCT
	CALL	@GTDCT		;
	ENDIF			;
	IF	V6		;6.0 @GTDCT
	@@GTDCT			;
	ENDIF			;
;
;*=*=* Save Address following JP (IY) inst on stack *=*=*
;
	PUSH	HL		;Save I/O Buffer
	LD	H,(IX-1)	;P/u msb of driver addr
	LD	A,RTADD$	;Offset to JP (IY) + 2
	ADD	A,(IX-2)	;Add lsb of driver addr
	LD	L,A		;Xfer to L
	JR	NC,$+3		;Add 256 more if carry
	INC	H		;
	EX	(SP),HL		;HL => buff, (SP) = ret
;
;*=*=* Adjust function request *=*=*
;
	LD	A,B		;I/O Function
	CP	2		; pass fcn 0,1
	JR	C,DO_FNC	; unchanged
	CP	7		;TSTBSY?
	JR	Z,DO_FNC	; unchanged
	JR	NC,CK_FNC	;>7 is I/O request
;
;*=*=* Xlate functions 2,3,4,5 & 6 to SEEK (func 6) *=*=*
;
	LD	BC,0608H	;B = 6 (SEEK), C = 8
;
; *=*=* Don't SEEK if Outside disk is a hard drive *=*=*
;
	LD	A,(IY+3)	;Bit 3 of DCT + 3
	AND	C		;is hard drive bit
	XOR	C		;set Z if bit Set
	RET	Z		;don't go to driver
;
;*=*=* Pass function through to driver *=*=*
;
DO_FNC	LD	D,(IY+5)	;P/u current cylinder
	JP	(IY)		;Cvt function # to SVC #
;
;*=*=* Is this Function #8 to 11 (read or verify)? ***
;
CK_FNC	SUB	12		;Read Request ? (8-11)
	JR	C,CK_RNG	;Go ahead to driver
;
;*=*=* WRITE sector (Function 13) ? *=*=*
;
	DEC	A		;Function 13 ?
	JR	Z,CK_RNG	; yes - check range
;
;*=*=* Write a system sector (Function 14) ? *=*=*
;
	DEC	A		;Function 14 ?
	JR	Z,DO_WSEC	;yes - WRITE sector
;
;*=*=* Type 1/2 <= NZ error 8, type 5/8 <= Z A=0 *=*=*
;
	LD	A,8		;No - 12, & 15 are errors
;;	AND	(IX+DD_ST$)	;Type 1/2 has bit 3 set
	OR	A		;Set NZ
	RET			;return with status
;
;*=*=* Translate function 14 to function 13 *=*=*
;
DO_WSEC	DEC	B		;WRSSC (14) => WRSEC (13)
	LD	(IX+D_CYL$),D	;update directory cyl
;
;*=*=* Is the sector request out of range ? *=*=*
;
CK_RNG	LD	A,(IX+DS_P_C$)	;P/u DiskDISK's S/C - 1
	CP	E		;Legal Request ?
	INC	A		;A = DiskDISK's S/C
	JR	NC,DOCALC	;Yes - calculate log rec#
;
;*=*=* Sector number out of range *=*=*
;
NODIZE	LD	A,1DH		;Record # out of range
	OR	A		;Set NZ
	RET			;Go to RET_ADD
;
;*=*=* Save I/O Buffer (HL) & Function # (B) *=*=*
;
DOCALC	PUSH	HL		;Save I/O buffer
	PUSH	BC		;And disk function #
;
;*=*=* Save Outside disk's Sectors/Cyl - 1 on stack *=*=*
;
	LD	H,0		;Set HL = Outside disk's
	LD	L,(IX+S_P_C$)	; sectors/cylinder - 1.
	PUSH	HL		;Need later for division
;
;*=*=* Save DiskDISK's Sectors/Cylinder on stack *=*=*
;
	LD	L,A		;HL = DiskDISK's Sec/Cyl
	PUSH	HL		;Need S/C for @MUL16, too
	LD	L,E		;HL = Sector Request
	EX	(SP),HL		;HL = S/C, & PUSH sec req
;
;*=*=* Multiply DiskDISK's Sectors/Cyl x Cyl req *=*=*
;
	IF	V5		;5.1 multiply
	LD	A,D		;P/u cylinder number
M16A	CALL	MULT1		;M I/III multiply HL x A
	ENDIF			;
;
	IF	V6		;6.0 multiply
	LD	C,D		;Set C = Req Cylinder
	@@MUL16			;Multiply HL x C = HLA
	ENDIF			;
;
;*=*=* Add Sector # to Sectors/Cyl x Cylinder # *=*=*
;
	LD	C,A		;BC = Cyl (D) x Sec/cyl
	LD	B,L		;
	POP	HL		;HL=Sector (E) on Cyl (D)
	ADD	HL,BC		;HL = Relative sec #
	INC	HL		;Skip ID sector
	LD	C,(IX+S_P_G$)	;C = Outside Disk's S/Grn
;
;*=*=* Position to next extent field *=*=*
;
NEXT_EX	INC	IX		;Two bytes per field
	INC	IX		;
;
;*=*=* P/u # of contiguous grans from extent field *=*=*
;
	LD	A,(IX+EXT1)	;Bits 0-4 contain:
	AND	00011111B	;# of contiguous grans
	INC	A		;
;
;*=*=* Multiply Contiguous grans x sectors/gran *=*=*
;
	PUSH	HL		;Save count
	LD	H,0		;Set HL = cont grans
;
	IF	V5		;5.1 multiply
	LD	L,C		;P/u Sectors/Gran
M16B	CALL	MULT1		;M I/III multiply HL x A
	ENDIF			;
;
	IF	V6		;6.0 multiply
	LD	L,A		;
	@@MUL16			;Multiply HL x C
	ENDIF			;
;
	LD	D,L		;Xfer result into
	LD	E,A		; register DE.
	POP	HL		;HL = requested
;
;*=*=* Is the requested sector in this extent ? *=*=*
;
	XOR	A		; Is the result in this
	SBC	HL,DE		; extent ?
	JR	NC,NEXT_EX	;No - get next extent
	ADD	HL,DE		;HL = relative sec in ext
;
;*=*=* Sector in this extent - p/u starting gran *=*=*
;
	LD	A,(IX+EXT1)	;Bits 5-7 contain:
	RLCA			; first granule
	RLCA			; of starting cylinder
	RLCA			;
	AND	00000111B	;
;
;*=*=* Multiply starting gran x sectors/gran *=*=*
;
	IF	V5		;5.1 multiply
	LD	E,C		;P/u sectors/gran
M8	CALL	MUL1		;M I/III multiply E x A
	ENDIF			;
;
	IF	V6		;6.0 multiply
	LD	E,A		;E = Starting gran #
	@@MUL8			;Multiply E x C
	ENDIF			;
;
;*=*=* Add start sect # (A) to sec offset in extent *=*=*
;
	LD	E,A		;Set DE = Start sector #
	XOR	A		;Set A = 0
	LD	D,A		;D = 0
	ADD	HL,DE		;Add to sectors into ext
;
;*=*=* Set D = Starting Cyl - 1, & BC = Sectors/Cyl *=*=*
;
	LD	D,(IX+EXT0)	;P/u starting cylinder
	DEC	D		;
	POP	BC		;Get Sectors/Cylinder
;
;*=*=* C = S/C - 1, B = 0, if S/C = 0 change to 256 *=*=*
;
	INC	BC		;Set BC = X'100' if X'FF'
;
;*=*=* Keep subtracting S/C off of secs into extent *=*=*
;
SUB_LP	LD	E,L		;E = Remainder
	INC	D		;Bump cylinder #
	SBC	HL,BC		;
	JR	NC,SUB_LP	;Go til carry
;
;*=*=* DE = T/S, p/u f#, I/O buff, & JP to driver *=*=*
;
GO_DRIV	POP	BC		;P/u function #, drive #
	POP	HL		;HL => I/O Buffer
	JP	(IY)		;Return address on stack
;
;*=*=* Restore Registers & check if not I/O request *=*=*
;
RTADD$	EQU	$-DRIVER	;Offset to JP (IY) + 2
	POP	BC		;Restore registers used
	POP	DE		;
	POP	IY		;
	POP	IX		;
	RET	NZ		;RETurn with status
;
;*=*=* Check if we need to bring back an error #6 *=*=*
;
	LD	C,A		;Save byte in case TSTBSY
	LD	A,B		;P/u function
	CP	7		;Was it TSTBSY?
	JR	C,SET_Z		;No, lower
	JR	Z,CK_WP		;Yes - Merge soft WP
;
;*=*=* Is this a READ type request ? *=*=*
;
	CP	12		;Fcn 8-11 to carry
	JR	NC,SET_Z	;>7 but <12 is read type
;
;*=*=* Set Directory read status if DiskDISK dir *=*=*
;
WAS_RD	LD	A,D		;P/u Cylinder request
	SUB	(IY+9)		;Subtract DCTs dir cyl
	JR	NZ,SET_Z	;NZ - not directory cyl
	OR	6		;Z - Show Error #6 & NZ
	RET			;
SET_Z	XOR	A		;Not the directory, set
	RET			;Z, and A = 0.
;
;*=*=* TSTBSY - Merge Software WP into status *=*=*
;
CK_WP	LD	A,(IY+3)	;Bit 7 of DCT+3 =
	AND	80H		;Software Write Protect
	RRA			;Xfer to Bit 6
	OR	C		;Merge with status byte
	CP	A		;Exit with Z set
	RET			;
;
DRVLEN	EQU	$-DRIVER	;DRVLEN=driver length
;
DCT	DB	0C3H		;DiskDISK DCT slot
	DW	LINKAGE		;Linkage address
	DC	6,0		;Fill in later
	DB	1		;DIR cyl = 1 ?
;
DPARM	DW	0FEFEH
FPARM	DW	0FEFEH
SAVESP	DS	2		;SP location on entry
DRIVE	DB	0		;DD drive #
LENTH	DW	LNKLEN		;Mod lenth storage loc
DISKFCB	DB	0		;Force 0 byte
	DS	31		;DiskDISK FCB
DCTSTRT	DS	2		;DiskDISK drive DCT
;
	IF	V6
FAKEPRM	DB	80H,1,'F'	;Length of one
FRESP	DB	0		;Fake response
	DW	FPARM		;Parm destination
	DB	0
	ENDIF
	IF	V5
FAKEPRM	DB	'F     '
	DW	FPARM
	DB	'FILE  '
	DW	FPARM
FRESP	DB	0		;
	ENDIF
;
INBUF$	DB	'(F='
	DS	25
;
;
;********************************************************
;***                                                  ***
;*** AB_JCL - Abort if in JCL                         ***
;***                                                  ***
;********************************************************
;
AB_JCL
	PUSH	AF		;Save AF
	PUSH	IY		;Save IY
;
	IF	V5		;5.1 - get SFLAG$
SFLAG	LD	A,(SFLAG1)	;M I/III SFLAG$
	ENDIF			;
;
	IF	V6		;6.0 - get SFLAG$
	@@FLAGS			;P/u Base address
	LD	A,(IY+SFLAG$)	;P/u SFLAG$
	ENDIF			;
;
	BIT	5,A		;JCL Active ?
	JP	NZ,ABORT	;Yes - abort
	POP	IY		;Restore registers
	POP	AF		;
	RET			;RETurn
;
;
;********************************************************
;***                                                  ***
;*** DSPLY - Display a line                           ***
;***                                                  ***
;********************************************************
;
DSPLY	PUSH	DE		;Save DE from @DSPLY
	CALL	DSPLY@		;Display line
	POP	DE		;
	RET			;
;
; *=*=* INIT Parameter error, fall into IOERR
;
	IF	V5
PRMERR	LD	HL,PRMMSG
	JP	BADNEWS
	ELSE
PRMERR	LD	A,44		;Set param error
	ENDIF
;
;*=*=* I/O Error - HL = error #, display, & abort *=*=*
;
IOERR	LD	L,A		;Set HL = error number
	LD	H,0		;
	OR	0C0H		;Short error message
	LD	C,A		;And C = error #
	CALL	ERROR		;Process error
	JP	EXIT2		;Clear stack & abort
;
;
;********************************************************
;***                                                  ***
;*** INPUT1 - Input 1 character and check validity    ***
;***                                                  ***
;***         - HL => Prompt string to display         ***
;***         - HL <= Parameter response in binary     ***
;***         - A  <= Type of response                 ***
;***                                                  ***
;********************************************************
;
INPUT1
	LD	B,1		;1 char to input
INPUT2	CALL	DSPLY		;Display prompt
	CALL	INPUT		;Input response
	RET	Z		;RETurn if nothin entered
	LD	HL,0FEFEH	;Invalid value
	LD	(FPARM),HL	;For default
INPUT3	PUSH	DE		;Save DE
	LD	DE,FAKEPRM	;DE => Fake Parm table
	LD	HL,INBUF$	;HL => "(F=response"
	CALL	PARAM		;Process parms
	POP	DE		;Restore DE
	LD	HL,(FPARM)	;P/u parm response
	IF	V5		;Set A <> 0 if 5.1
	LD	A,NUM		;
	ENDIF			;
	IF	V6
	LD	A,(FRESP)	;Response byte
	ENDIF
	RET			;And RETurn w/ condition
;
;
;********************************************************
;***                                                  ***
;*** INPUT  - Input a line                            ***
;***        - B  => Max # of characters to input      ***
;***        - HL <= Buffer containing input           ***
;***        - Z  <= Set if no characters entered      ***
;***                                                  ***
;********************************************************
;
INPUT	LD	HL,INBUF$+3	;Skip "(F="
	LD	C,0		;Field char = 0
	PUSH	DE		;@KEYIN smashes DE
	CALL	KEYIN		;Input line
	POP	DE		;
	JP	C,ABORT		;Abort on <BREAK>
	XOR	A		;Set A=0
	CP	B		;Z if no chars entered
	RET			;RETurn
;
;
;
;
;********************************************************
;***                                                  ***
;*** SKIPSPC - Point HL to first non-space character  ***
;***                                                  ***
;********************************************************
;
SKIPSPC	DEC	HL		;Back one
	INC	HL		;P/u current character
	LD	A,(HL)		;
	CP	' '		;Space character ?
	JR	Z,SKIPSPC+1	;Yes - bump pointer
	RET			;No - RETurn
;
;
;********************************************************
;***                                                  ***
;*** PRFSPEC - Prompt for Filespec                    ***
;***        - Z <= Set if Legal filespec              ***
;***                                                  ***
;********************************************************
;
PRFSPEC	PUSH	HL		;Save cmd line ptr
	LD	HL,FILESP$	;"Enter Filespec :"
	CALL	DSPLY		;
	LD	B,24		;Filename/ext.password:d
	CALL	INPUT		;Input filespec
	LD	DE,DISKFCB	;DE => FCB
	CALL	FSPEC		;Legal filespec ?
	POP	HL		;HL => Command Line
	RET			;
;
;
;********************************************************
;***                                                  ***
;*** GET_EXT - Get File's Extents into linkage        ***
;***                                                  ***
;********************************************************
;
GET_EXT
	LD	BC,(DISKFCB+6)	;P/u DEC/drive #
	LD	DE,EXTENT	;DE => Extent Storage
	LD	IX,EXT_CNT	;IX => Extent Counter
;
;*=*=* Read in a DiskDISK directory entry *=*=*
;
GT_EXT	CALL	DIRRD		;Read entry
	JP	NZ,IOERR	;Abort on error
;
;*=*=* Point HL to the extent fields of the entry *=*=*
;
	LD	A,L		;P/u lsb of ext ptr
	ADD	A,22		;22 bytes to extent #1
	LD	L,A		;Xfer back to L
	LD	B,4		;B = 4 entries max
;
;*=*=* Is this a valid extent ? *=*=*
;
EX_LP	LD	A,(HL)		;P/u Starting Cylinder
	INC	A		;Is it X'FF' ?
	RET	Z		;yes - done
;
;*=*=* This is a valid extent - xfer to linkage *=*=*
;
	PUSH	BC		;Save ext counter/drive #
	LD	BC,2		;Xfer two bytes
	LDIR			;
	POP	BC		;Restore counter/drive #
;
;*=*=* Are there too many extents ? *=*=*
;
	INC	(IX)		;Bump extent counter
	LD	A,(IX)		;P/u # of extents
	CP	MAX_EXT+1	;Too many ?
	JR	NC,SETNZ	;Yes - return NZ
	DJNZ	EX_LP		;4 max
;
;*=*=* Finished an entry - is there an FXDE ? *=*=*
;
	INC	(HL)		;FXDE ?
	INC	HL		;HL => DIR + 31
	LD	B,(HL)		;P/u DEC
	JR	NZ,GT_EXT	;Get next extent if NZ
	RET			;
;
SETNZ	OR	A		;set NZ
	RET			;return
;
EXT_CNT	DB	0		;Extent Counter
;
;
;********************************************************
;***                                                  ***
;*** GET_DAT - Get Outside Disk's S/C & S/G in linkage***
;***                                                  ***
;********************************************************
;
GET_DAT
	LD	BC,(DISKFCB+6)	;Set C = drive #
	CALL	GTDCT		;IY => Outside DCT
	LD	A,(IY+8)	;Bits 0-4 contain:
	AND	00011111B	; sectors/Granule
	INC	A		;
	LD	(S_P_G),A	;Xfer into linkage
	LD	A,(IY+7)	;Bits 0-4 contain:
	AND	00011111B	;# of sectors/track
	INC	A		;
	BIT	3,(IY+3)	;Hard Drive ?
	JR	Z,NOT_HD	;No
	LD	C,A		;Multiply Sectors/Track
	LD	A,(IY+7)	;Bits 5-7 contain:
	RLCA			; # of heads
	RLCA			; on a hard drive
	RLCA			;
	INC	A		;
	LD	E,A		;Xfer to E
	CALL	MUL8		;Multiply E x C
NOT_HD	BIT	5,(IY+4)	;Double bit set ?
	JR	Z,$+3		;No
	ADD	A,A		;Yes - mult S/C x 2
	DEC	A		;Driver INCs it
	LD	(S_P_C),A	;Xfer into linkage
	RET			;Done - RETurn
