;DDA - Install a DiskDISK file - 11/09/83
;
	SUBTTL	<'Install a DiskDISK'>
	PAGE
START
	IF	V6
	@@CKBRKC
	JR	Z,STARTA	;Continue if no break
	LD	HL,-1
	RET			;else abort
	ENDIF
;
;
STARTA
	LD	(SAVESP),SP	;Save SP
	CALL	DOINIT		;P/u drivespec/Filespec
	CALL	Z,ENABLE	;Z = Enable DiskDISK
	CALL	NZ,DISABLE	;NZ = Disable DiskDISK
;
;*=*=* Clean Exit - Set HL = 0 and return *=*=*
;
EXIT	LD	HL,0		;Issue a clean exit
	IF	V5
	JP	@EXIT
	ELSE
	@@CKBRKC
	RET			;
	ENDIF
;
;*=*=* Internal error exit routine *=*=*
;
SM_DRV	LD	HL,SM_DRV$	;Same Drive number
	DB	0DDH		;
BAD_DD	LD	HL,BAD_DD$	;Illegal DiskDISK file
	DB	0DDH		;
FROZEN	LD	HL,FROZEN$	;Memory Frozen
	DB	0DDH		;
NTDISK	LD	HL,NTDISK$	;Not a DiskDISK
	DB	0DDH		;
EXT_ER	LD	HL,EXT_ER$	;Too many extents in file
BADNEWS	CALL	LOGOT		;Log error
;
;*=*=* Internal & I/O Error exit - set HL = -1 *=*=*
;
	IF	V5
EXIT2
ABORT	JP	@ABORT
	ENDIF
	IF	V6
ABORT	LD	HL,-1		;Abort JCL
EXIT2	LD	SP,(SAVESP)	;P/u original SP
	@@CKBRKC
	RET			;RETurn w/ condition
	ENDIF
;
;
;********************************************************
;***                                                  ***
;*** ENABLE - Install a DiskDISK                      ***
;***                                                  ***
;********************************************************
;
ENABLE
	CALL	CHECKID		;Existing - check ID
	CALL	INSTALL		;Install driver/linkage
	LD	HL,INSMESS	;DiskDISK now operational
	CALL	DSPLY		;
	XOR	A		;RETurn Z
	RET			;
;
;
;********************************************************
;***                                                  ***
;*** CHECKID - Read in ID record & check if valid     ***
;***                                                  ***
;********************************************************
;
CHECKID
;
;*=*=* Read ID record *=*=*
;
	LD	DE,DISKFCB	;DE => DiskDISK FCB
	CALL	READ		;Read Record X'0000'
	JP	NZ,IOERR	;NZ - Abort
;
;*=*=* Is this a DiskDISK ? *=*=*
;
	LD	HL,IOBUFF	;Is this a DiskDISK ?
	LD	DE,PACK_ID	;
	LD	B,8		;8 chars
CKIDLP	LD	A,(DE)		;P/u DiskDISK char
	CP	(HL)		;Match ?
	JP	NZ,BAD_DD	;No - Abort
	INC	DE		;
	INC	HL		;
	DJNZ	CKIDLP		;Need all 8
;
;*=*=* This is a DiskDISK, get DCT & use it *=*=*
;
	LD	DE,DCT		;DE => My DCT
	LD	C,10		;10 bytes in DCT
	LDIR			;
;
;*=*=* Set bit 3 of DD_ST in linkage if type 1/2 *=*=*
;
	LD	A,(HL)		;p/u type byte
	CP	5		;type 1 or 2 ?
	JR	NC,$+7		;no - fine
	LD	HL,DD_ST	;HL => Status byte
	SET	3,(HL)		;show type 1/2
;
;*=*=* Merge alien bit from outside disk *=*=*
;
	LD	BC,(DISKFCB+6)	;P/u drive #/DEC
	LD	(DD_DRV),BC	;Xfer into linkage
	CALL	GTDCT		;Pt IY to DCT of DD drive
	LD	HL,DCT+4	;HL => DCT + 4
	RES	4,(HL)		;Reset alien bit
	LD	A,(IY+4)	;P/u DCT+4
	AND	00010000B	;Save bit 4
	OR	(HL)		;Merge DCT+4
	LD	(HL),A		;New DCT+4
;
;*=*=* Set Directory Cylinder in DCT+9 to BOOT's *=*=*
;
	LD	DE,DISKFCB	;Read in Cyl 0, Sec 0
	CALL	READ		;Ignore error
	JP	NZ,IOERR	;Abort if Bad
	LD	A,(IOBUFF+2)	;P/u DIR cylinder
	LD	(DCT+9),A	;Stuff new DIR cyl in DCT
	LD	(D_CYL),A	;Stuff into linkage
;
;*=*=* Xfer DiskDISK's Sectors/Cyl into linkage *=*=*
;
	LD	A,(DCT+7)	;P/u Sectors/track
	INC	A		;
	LD	HL,DCT+4	;HL => DiskDISK DCT + 4
	BIT	5,(HL)		;Double bit set ?
	JR	Z,$+3		;
	ADD	A,A		;Multiply x 2
	DEC	A		;Driver incs it
	LD	(DS_P_C),A	;Xfer into linkage
;
;*=*=* Xfer # of extents into Linkage *=*=*
;
	CALL	GET_DAT		;Xfer S/C & S/G in link
	CALL	GET_EXT		;Xfer extents to linkage
	RET	Z		;Good - RETurn
	JP	EXT_ER		;No - Bad news
;
;
;********************************************************
;***                                                  ***
;*** INSTALL - Install DiskDISK driver/linkage        ***
;***                                                  ***
;********************************************************
;
INSTALL
	CALL	INSTDRV		;Install Driver
	LD	BC,COUNT	;Pt HL => byte containing
	ADD	HL,BC		;# linkages using driver.
;
;*=*=* Install Linkage or overwrite existing one *=*=*
;
INSTLNK	CALL	LNK_IN?		;Linkage in memory ?
	JR	Z,XFDCT		;Overwrite DCT
	INC	(HL)		;Bump counter
	LD	HL,LINKAGE	;HL => Start of module
	LD	BC,LNKLEN	;BC = # of bytes
	CALL	INSTMOD		;Install module
XFDCT	LD	(DCT+1),DE	;New driver address
	LD	HL,DCT		;HL => DCT
	LD	DE,(DCTSTRT)	;DE => Dest
	LD	BC,10		;10 bytes to xfer
	LDIR			;
	RET			;For now
;
;*=*=* Install Master DiskDISK driver *=*=*
;
INSTDRV	CALL	DRV_IN?		;Driver in memory ?
	JR	Z,ITS_IN	;Yes - don't install it
	LD	HL,DRIVER	;HL => Driver start
	LD	BC,DRVLEN	;BC = # bytes in driver
	CALL	INSTMOD		;Install module
	EX	DE,HL		;HL => Driver start
ITS_IN	LD	(LENTRY+1),HL	;Plug linkage vector
	RET			;
;
;
;********************************************************
;***                                                  ***
;*** LNK_IN? - Does this drive have a linkage ?       ***
;***                                                  ***
;***         - Z  <= If it does, and overwrites it    ***
;***         - NZ <= Do it yourself, Jack             ***
;***         - DE <= Linkage Address                  ***
;***                                                  ***
;********************************************************
;
LNK_IN?
	PUSH	HL		;Save counter ptr
	LD	HL,(DCTSTRT)	;P/u DCT start
	INC	HL		;Pt to driver
	LD	A,(HL)		;P/u lsb
	INC	HL		;
	LD	H,(HL)		;P/u msb
	LD	L,A		;
	PUSH	HL		;Save Driver start
	CALL	LNKIN		;Is the linkage in ?
	POP	DE		;DE => Driver start
	POP	HL		;
	RET			;RETurn w/ condition
;
;*=*=* Position to the drive's disk driver mod ID *=*=*
;
LNKIN
	CALL	LKMATCH		;Is this a Linkage ?
	RET	NZ		;No - RETurn NZ
;
;*=*=* This drive has a linkage - overwrite it *=*=*
;
	EX	DE,HL		;HL =>DiskDISK, DE => Mem
	LD	C,LNKLEN2	;BC = length of rest
	LDIR			;Overwrite existing link
	RET			;RETurn (Z set)
;
;*=*=* Is this a Linkage ? *=*=*
;
LKMATCH
	LD	BC,4		;
	ADD	HL,BC		;HL => Driver module ID
;
;*=*=* Is this a DiskDISK linkage ID ? *=*=*
;
	LD	DE,LINKAGE+4	;DE => 3,"$DL"
	LD	B,C		;Set B = 4 chars in ID
CKID	LD	A,(DE)		;P/u source
	CP	(HL)		;Match ?
	RET	NZ		;No - RETurn NZ
	INC	HL		;Bump each
	INC	DE		;
	DJNZ	CKID		;
	RET			;This is a linkage
;
;
;********************************************************
;***                                                  ***
;*** INSTMOD - Install a module into memory           ***
;***                                                  ***
;***         - HL => First byte of module             ***
;***         - BC => # of bytes contained in module   ***
;***         - Z  <= Set if successfully installed    ***
;***         - DE <= Location of installed module     ***
;***                                                  ***
;********************************************************
;
INSTMOD
;
;*=*=* Get first available address in driver zone *=*=*
;
	PUSH	HL		;Save module start ptr
	IF	V6		;Check low ONLY under 6.0
	INC	HL		;Pt HL => Old mem storage
	INC	HL		;
	LD	(ST_OLD+1),HL	;Save ptr
	LD	DE,'IK'		;Find KI DCB
	@@GTDCB			;
	DEC	HL		;P/u address @ DVRPTR$
	LD	D,(HL)		;;
	DEC	HL		;
	LD	E,(HL)		;DE => 1st avail loc
;
;*=*=* Is there sufficient memory in driver zone ? *=*=*
;
	PUSH	HL		;Save DVRPTR$
	LD	H,D		;Set HL => 1st Avail loc
	LD	L,E		;
	ADD	HL,BC		;Add length
	LD	A,H		;Will the module over-run
	DEC	HL		;HL => Last byte used
ST_OLD	LD	($-$),HL	;Save last used in header
	CP	13H		; address X'1300' ?
	POP	HL		;HL => DVRPTR$
	JR	NC,INSF_DV	;Yes - try HIGH mem
;
;*=*=* Enough driver zone memory - install module *=*=*
;
	EX	(SP),HL		;HL => Module start
	PUSH	DE		;Save destination
	LDIR			;Xfer into driver zone
	POP	BC		;BC => Where it is
	POP	HL		;HL => DVRPTR$
	LD	(HL),E		;Show next available
	INC	HL		; location in DVRPTR$
	LD	(HL),D		;
	LD	D,B		;Set DE = start of module
	LD	E,C		;
	RET			;
;
;*=*=* Abort if executed via BASIC or mem frozen *=*=*
;
INSF_DV
	@@FLAGS			;IY => Flag Table
	BIT	0,(IY+CFLAG$)	;Memory Frozen ?
	ENDIF			;
	IF	V5		;Check if executed
	LD	A,(@EXIT)	; via LBASIC
	CP	LD___A		; well ?
	ENDIF			;
	JP	NZ,FROZEN	;Yes - abort
;
;*=*=* Get 1st usable location for module (HIGH$) *=*=*
;
	LD	HL,0		;Set HL = 0
	POP	DE		;DE => Module start
	PUSH	BC		;Save count
	LD	B,L		;Function 0
	CALL	GTHIGH		;P/u current HIGH$
;
;*=*=* Stuff mem loc before installation in header *=*=*
;
	EX	DE,HL		;DE => Destination of mod
	PUSH	HL		;Save Module start
	INC	HL		;Pt HL => Start+2
	INC	HL		;
	LD	(HL),E		;Stuff lsb of HIGH$
	INC	HL		;
	LD	(HL),D		;Stuff msb of HIGH$
	POP	HL		;HL => Module start
;
;*=*=* Pt HL => Mod end, DE => Dest, BC = # bytes *=*=*
;
	POP	BC		;Recover length
	ADD	HL,BC		;HL => Module end + 1
	DEC	HL		;HL => last byte used
;
;*=*=* Transfer module into hi-mem, & set new HIGH$ *=*=*
;
	LDDR			;Copy to hi-mem
	LD	H,D		;Pt HL to New HIGH$
	LD	L,E		;
	CALL	GTHIGH		;(B=0), set new HIGH$
	INC	DE		;Pt DE to module
	RET			;RETurn with status
;
;
;********************************************************
;***                                                  ***
;*** DRV_IN? - Is the DiskDISK driver in memory ?     ***
;***                                                  ***
;********************************************************
;
DRV_IN?
	LD	DE,$DD		;DE => DiskDISK name
	CALL	GTMOD		;In memory ?
	RET			;RETurn w/ condition
;
;
;********************************************************
;***                                                  ***
;*** DISABLE - Disable a DiskDISK & reclaim memory    ***
;***                                                  ***
;********************************************************
;
DISABLE
;
;*=*=* Set (LENTH) = length of linkage module *=*=*
;
	LD	HL,LNKLEN	;Set (LENTH) = Linkage
	LD	(LENTH),HL	; length.
;
;*=*=* P/u DiskDISK linkage address from DCT *=*=*
;
	LD	HL,(DCTSTRT)	;P/u drive start
	INC	HL		;Pt to driver addr
	LD	A,(HL)		;P/u address @ HL
	INC	HL		;
	LD	H,(HL)		;
	LD	L,A		;
;
;*=*=* Is this an active DiskDISK ? *=*=*
;
	PUSH	HL		;Save ptr
	CALL	LKMATCH		;Linkage Match ?
	POP	BC		;BC => Driver start
	JP	NZ,NTDISK	;No - not a DiskDISK
;
;*=*=* P/u $DD address (in case we erase linkage) *=*=*
;
	LD	D,B		;Set DE = Driver address
	LD	E,C		;
	LD	HL,DD_OFF	;P/u offset to $DD addr
	ADD	HL,DE		;
	LD	A,(HL)		;P/u $DD driver addr
	INC	HL		;
	LD	H,(HL)		;
	LD	L,A		;
	PUSH	HL		;Save it
;
;*=*=* Reclaim memory used by linkage if possible *=*=*
;
	LD	HL,LINKAGE+4	;HL => Linkage ID
	CALL	DIS_MOD		;Disable module
	JR	Z,MEMREC	; message
;
;*=*=* Change Disable exit message if not reclaimed *=*=*
;
	LD	HL,DIS1$	;HL => Mem not reclaimed
	LD	(HL),LF		;change to line feed
;
;*=*=* Decrement linkage counter in driver *=*=*
;
MEMREC	POP	DE		;DE => $DD driver
	LD	HL,COUNT	;HL => Driver count byte
	ADD	HL,DE		;
	DEC	(HL)		;Any other linkages used?
	JR	NZ,LEAVEIN	;Yes - leave in mem
;
;*=*=* No more linkages active, reclaim driver mem *=*=*
;
	LD	HL,DRVLEN	;Set (LENTH) = driver
	LD	(LENTH),HL	; length
	LD	HL,DRIVER+4	;HL => 3,"$DD" ID field
	CALL	DIS_MOD		;Disable module
;
;*=*=* Disable DCT slot *=*=*
;
LEAVEIN	LD	HL,(DCTSTRT)	;Stuff an X'C9' in
	LD	(HL),0C9H	;DCT+0
	INC	HL		;erase driver address
	LD	(HL),0		;so we don't find it
	INC	HL		;
	LD	(HL),0		;
	JR	Z,GO_EX		;Go to exit
;
;*=*=* Change Disable message *=*=*
;
	LD	HL,DIS1$	;HL => Mem message
	LD	(HL),LF		;Overwrite ETX	
;
;*=*=* Display disable exit message *=*=*
;
GO_EX
	LD	HL,DISABE$	;HL => Disable message
	CALL	DSPLY		;
	LD	HL,DIS1$	;Memory string
	JP	DSPLY		;Display & RETurn
;
;
;********************************************************
;***                                                  ***
;*** DIS_MOD - Disable Memory module & reclaim mem    ***
;***                                                  ***
;***         - HL => ID lenth but                     ***
;***         - DE => Module Start                     ***
;***         - (LENTH) = Length of module             ***
;***                                                  ***
;********************************************************
;
;*=*=* Is this a DiskDISK ? *=*=*
;
DIS_MOD
	PUSH	DE		;Save driver start
	INC	DE		;Pt to ID
	INC	DE		;
	INC	DE		;
	INC	DE		;DE => Lenth but
	LD	B,4		;
CKID2LP	LD	A,(DE)		;P/u char
	CP	(HL)		;Match ?
	JP	NZ,NTDISK	;No - NOT A DiskDISK !
	INC	HL		;Bump
	INC	DE		;
	DJNZ	CKID2LP		;4 chars
;
;*=*=* Valid DiskDISK, get DVRPTR$ if 6.0 *=*=*
;
	IF	V6		;Get DRIVER$ for 6.0
	LD	DE,'IK'		;Find *KI DCB
	@@GTDCB			;
	DEC	HL		;P/u last used
	LD	D,(HL)		;Driver address
	DEC	HL		;
	LD	E,(HL)		;
	PUSH	HL		;Xfer to IX
	POP	IX		;
	ENDIF			;
;
;*=*=* P/u current HIGH$ in HL *=*=*
;
	PUSH	DE		;Save driver address
	LD	HL,0		;P/u current HIGH$
	LD	B,L		;
	CALL	GTHIGH		;
	POP	BC		;Xfer to BC
	POP	DE		;DE => driver address
;
;*=*=* Is the module the last one in high memory ? *=*=*
;
	OR	A		;Is HIGH$+1=module start?
	INC	HL		;
	SBC	HL,DE		;
	EX	AF,AF'		;Save status of SBC HL,DE
;
;*=*=* Set HL => Last byte used by module *=*=*
;
	LD	HL,(LENTH)	;P/u length of module
	ADD	HL,DE		; HL => End of module
;
;*=*=* Check if module is in low memory (for 6.0) *=*=*
;
	IF	V6		;Check low mem for 6.0
	LD	A,D		;Is da module hi or low?
	CP	13H		;
	JR	C,LOWMEM	;Under X'1300' is DVRPTR$
	ENDIF			;
;
;*=*=* Module is in high memory *=*=*
;
HIMEM	EX	AF,AF'		;Return if something
	RET	NZ		; installed after module.
	LD	B,0		;Reset HIGH$
	DEC	HL		;
	CALL	GTHIGH		;
	JR	ER_MOD		;Erase module
;
;*=*=* Module is low (6.0 only) - check DVRPTR$ *=*=*
;
	IF	V6		;Check low mem (6.0)
LOWMEM	XOR	A		;Anything installed after
	SBC	HL,BC		;The module ?
	RET	NZ		;Yes - can't reclaim mem
;
;*=*=* Reset DVRPTR$ to reflect new mem pointer *=*=*
;
	LD	(IX),E		; driver before module
	LD	(IX+1),D	;
	ENDIF			;
;
;*=*=* Erase Linkage so we don't ever find header *=*=*
;
ER_MOD	LD	H,D		;Set HL => Module start
	LD	L,E		;
	INC	DE		;DE => Module start + 1
	LD	BC,(LENTH)	;Set BC = lenth of module
	DEC	BC		;Dec count
	XOR	A		;Set Z flag & A=0
	LD	(HL),A		;Clear out mem
	LDIR			;
	RET			;And RETurn
;
;*=*=* Sign in Please ... *=*=*
;
DOINIT
	PUSH	HL		;Sign on Dude
	LD	HL,HELLO$	;
	CALL	DSPLY		;
	POP	HL		;
	CALL	IOINIT		;Initialize I/O stuff
;
;*=*=* Any parameters entered ? *=*=*
;
	PUSH	HL		;Save command ptr
	DEC	HL		;
PLOOP	INC	HL		;Bump cmd line ptr
	LD	A,(HL)		;P/u char
	CP	CR+1		;End of line ?
	JR	C,NOPARMS	;Yes - no parameters
	CP	'('		;Parms ?
	JR	NZ,PLOOP	;No - go til terminator
;
;*=*=* Process any parameter(s) entered *=*=*
;
GETPRM	LD	DE,PARMTBL	;DE => parameter table
	CALL	PARAM		;Process parameter(s)
	JP	NZ,PRMERR	;NZ - parameter error
;
;*=*=* Was DISABLE entered incorrectly ? *=*=*
;
	IF	V6
	LD	A,(DRESP)	;Was DISABLE entered
	XOR	FLAG		;Incorrectly ?
	JP	NZ,PRMERR	;
	ENDIF
;
;*=*=* Was a legal drivespec entered ? *=*=*
;
NOPARMS	POP	HL		;HL => Command line
	CALL	SKIPSPC		;Skip any leading spaces
	CALL	CKDSPEC		;Check if valid drivespec
PRDSP	CALL	NZ,PRDSPEC	;Prompt for drivespec
	JR	NZ,PRDSP	; if illegal or invalid.
;
;*=*=* Got drivespec - does he wish to DISABLE it ? *=*=*
;
	LD	A,(DPARM)	;DISABLE ?
	CP	0FEH
	RET	NZ		;Yes - RETurn NZ
;
;*=*=* Enable DiskDISK - Check if first char alpha *=*=*
;
	CALL	SKIPSPC		;Make sure that first
	LD	A,(HL)		; character is not
	RES	5,A		; numeric, because @FSPEC
	CP	'A'		; sucks !!!
	JR	C,PRFSP		;Pmt for Fspec if -alpha
;
;*=*=* First character alphabetic - check if legal *=*=*
;
PRFSP2	LD	DE,DISKFCB	;DE => DiskDISK FCB
	CALL	FSPEC		;
PRFSP	CALL	NZ,PRFSPEC	;NZ - prompt for filespec
	JR	NZ,PRFSP	;
;
;*=*=* Legal Filespec - stuff /DSK extension *=*=*
;
	LD	HL,DEF_EXT	;File has a default
	CALL	FEXT		;Extension of /DSK.
;
;*=*=* Does this File exist ? *=*=*
;
	LD	HL,IOBUFF	;HL => I/O Buffer
	LD	B,L		;B = 0 = LRL of 256
	CALL	OPEN		;File exist ?
	JR	Z,CK_OPEN	;Yes - check it out
;
;*=*=* Ignore "File already Open" & "LRL fault" *=*=*
;
	CP	41		;File already Open ?
	JR	Z,CK_OPEN	;
	CP	42		;LRL Open Fault ?
	JP	NZ,IOERR	;No - I/O Error
;
;*=*=* Good @OPEN - Are both drive #'s the same ? *=*=*
;
CK_OPEN
	LD	BC,(DRIVE)	;p/u DiskDISK drive #
	LD	A,(DISKFCB+6)	;P/u drive #
	CP	C		;Same drive Number ?
	JP	Z,SM_DRV	;yes - abort !!
;
;*=*=* Do we have UPDATE access ? *=*=*
;
	EX	DE,HL		;HL => FCB+0
	BIT	6,(HL)		;UPDATE access ?
	JR	NZ,NOTWP	;Yes - RETurn
;
;*=*=* We don't have UPDATE access - is the disk WP *=*=*
;
	LD	C,A		;
	CALL	CKDRV		;WP disk ?
	JR	NC,NOTWP	;No
;
;*=*=* Disk is write protected - Make a note of it *=*=*
;
	LD	A,LF		;Overwrite C/R with a L/F
	LD	(EX_MESS),A	; to display "WP disk"
;
;*=*=* Give yourself FULL access to this file *=*=*
;
NOTWP	SET	6,(HL)		;Force UPDATE access
	INC	HL		;HL => FCB+1
	LD	A,(HL)		;P/u attributes byte
	AND	0FCH		;Set PROT level = FULL
	LD	(HL),A		;
	XOR	A		;Set Z flag
	RET			;
;
PARMTBL
	IF	V6
	DB	80H		;6.0 @PARAM
	DB	FLAG!ABB!7	;Lenth but of 7
	DB	'DISABLE'	;
DRESP	DB	0		;Response byte
	DW	DPARM		;Disable Parm
	DB	0		;
	ENDIF
;
	IF	V5
	DB	'DISABL'
	DW	DPARM
	DB	'D     '
	DW	DPARM
DRESP	DB	0
	ENDIF
;
;********************************************************
;***                                                  ***
;*** PRDSPEC - Prompt user for drivespec (1-7)        ***
;***         - Z <= Set if valid drivespec entered    ***
;***                                                  ***
;********************************************************
;
PRDSPEC	PUSH	HL		;Save command line ptr
	LD	HL,PRDRV$	;"Enter Drivespec (1-7) "
	CALL	DSPLY		;
	LD	B,1		;One character only
	CALL	INPUT		;Input response
	CALL	CKDSPEC		;Legal Drivespec ?
	POP	HL		;Restore C/L ptr
	RET			;Return w/ condition
;
;
;********************************************************
;***                                                  ***
;*** CKDSPEC - Check if drivespec is legal            ***
;***         - HL => Drivespec field                  ***
;***         - Z  <= Set if legal Drivespec           ***
;***         - A  <= Drive number (1-7) in binary     ***
;***                                                  ***
;********************************************************
;
CKDSPEC	LD	A,(HL)		;P/u char
	CP	':'		;Drivespec ?
	JR	NZ,NOTCOLN	;No - is it numeric ?
	INC	HL		;Bump ptr
	LD	A,(HL)		;P/u char following ":"
;
;*=*=* Is the drive number between 1-7 ? *=*=*
;
NOTCOLN	SUB	'1'		;Less than one ?
	RET	C		;Yes - RETurn NZ
	CP	7		;Greater than seven ?
	INC	A		;A = drive # 1-7
	RET	NC		;RETurn NZ if A>7
	LD	(DRIVE),A	;Save drive number
	LD	C,A		;Xfer to C
	CALL	GTDCT		;Get DCT ptr
	LD	(DCTSTRT),IY	;And save for later
	INC	HL		;Bump ptr
	CALL	SKIPSPC		;Skip any spaces
	CP	A		;Set Z flag
	RET			;And RETurn
;
;
HELLO$	DB	'DD - DiskDISK Installation Utility',LF
;
	IF	V5.OR.LSI
	DB	'Copyright (C) 1983 by Logical Systems Inc.',LF
	DB	'Version 1.0.1 ',LF,CR
	ELSE
	DB	'Version'
*GET	CLIENT:3
	ENDIF
;
PRMMSG	DB	'Parameter error',CR
INSMESS	DB	'DiskDISK now operational'
EX_MESS	DB	CR,'Note : DiskDISK is Write Protected'
	DB	CR
FROZEN$	DB	'Can',AP,'t install DiskDISK, memory '
	DB	'not available',CR
SM_DRV$	DB	'DiskDISK drivespec identical to '
	DB	'File drivespec',CR
NTDISK$	DB	'Drive not a DiskDISK',CR
EXT_ER$	DB	'File Contains too many extents',CR
DISABE$	DB	'DiskDISK disabled',ETX
DIS1$	DB	CR,' Unable to reclaim both driver '
	DB	'and linkage memory',CR
BAD_DD$	DB	'Illegal DiskDISK File',CR
PRDRV$	DB	'Enter Logical Drive number (1-7) : ',ETX
FILESP$	DB	'Enter Filespec : ',ETX
$DD	DB	'$DD',ETX
DEF_EXT	DB	'DSK'
;
	ORG	$<-8+1<+8
;
IOBUFF	DS	256		;I/O Buffer
