;CLICK - Keyboard Click Filter - 10/28/83
;
	TITLE	<CLICK/FLT - LDOS 6.2>
;
;*****
;
;	Change Log
;
; 10/10/83 - Added 'CHAR' parm to act on only one char.
;
;*****
	COM '<Copyright 1982 by Logical Systems, Inc.>'
;
	IF	@MOD4
TONE	EQU	48H
LEN	EQU	18H
SNDPORT	EQU	90H
	ENDIF
	IF	@MOD2
LEN	EQU	180H		;length
SNDPORT	EQU	0A0H
	ENDIF
;
*GET SVCMAC:3
*GET VALUES:3
;
	ORG	2400H
;
START
	@@CKBRKC
	JR	Z,STARTA	;Continue if no BREAK
	LD	HL,-1		; set up abort RET
	RET
;
STARTA	LD	(EXIT+1),SP	;in case of error
	CALL	DOINIT		;Do initialization
	CALL	INSTFLT		;relocate/install filter
NORMEX	LD	HL,0		;good exit
	RET			;
;
;*=*=* Xfer DCB ptr to IX & stuff addrs' in driver *=*=*
;
DOINIT	PUSH	DE		;DE => DCB+0
	POP	IX		;xfer to IX
	LD	(DCB),DE	;xfer into header
;
;*=*=* Sign-on 
;
	PUSH	HL
	LD	HL,HELLO$	;sign on message
	CALL	DSPLY		;
;*=*=*
;	Check PARMS and if entry from SET command
;*=*=*
	LD	DE,PRMTBL	;Point to parms
	POP	HL
	@@PARAM
	JP	NZ,IOERR	;Exit on parm error
;
	@@FLAGS			;IY => System Flags Base
	BIT	3,(IY+'C'-'A')	;System request?
	JP	Z,VIASET
;
;*=*=* Before anything - Make sure hi-mem is avail *=*=*
;
	BIT	0,(IY+CFLAG$)	;high memory available ?
	JP	NZ,CANT		;no - display error
;
;*=*=*=* Set up filter for CHAR if entered
;
CHARPRM	LD	DE,00		;Char parm lands here
	LD	A,D
	CP	E		;Check if entered and
				; is normal character
	RET	Z		;done if not entered
	CP	0		;check is MSB is altered
	LD	A,44
	JP	NZ,IOERR	; bad if so
;
	LD	D,E		;Set up CP nn
	LD	E,0FEH		;Reverse it and 
	LD	(CKCHAR),DE	; put it in the filter
	RET
;
;
;********************************************************
;***						      ***
;*** Actual CLICK filter Code			      ***
;***						      ***
;********************************************************
;
HEADER	JR	FILTER		;LDOS 6.2 Header
;
;*=*=* Old HIGH$, Name, DCB pointing to TONE *=*=*
;
OLDHI	DW	0		;HIGH$ before CLICK
	DB	5,'CLICK'
DCB	DW	$-$		;DCB pointing to CLICK
SPARE	DW	0		;system wants it
;
;*=*=* Is there a keyboard character available ? *=*=*
;
FILTER	LD	IX,(DCB)	;p/u DCB address
	JR	C,NOTCTL
	JR	Z,NOTCTL
IS_CTL	@@CHNIO
	RET
NOTCTL	@@CHNIO			;go to next in line
	RET	NZ		;none - RETurn NZ
;
;*=*=* Generate short Click *=*=*
;
SOUND	PUSH	AF		;Save registers
CKCHAR	DW	00		;Space for a CP instruct
	JR	NZ,POPAF	; exit if CP above fails
SNDNOW	PUSH	BC		;
	PUSH	DE		;
	IF	@MOD2
	LD	BC,LEN		;duration
	LD	A,-1		;ON value
	OUT	(SNDPORT),A	;turn on sound
	LD	A,16		;svc @PAUSE
	RST	28H		;delay
	XOR	A		;OFF value
	OUT	(SNDPORT),A	;turn off sound
	ENDIF
;
	IF	@MOD4
;
STFVALS	LD	DE,TONE<8!LEN	;D = Tone, E = Length
	LD	A,0		;Init on/off toggle
	LD	C,SNDPORT	;point to port
;
;	********* ON PORTION
DURLP	INC	A		;hold output high
	OUT	(C),A		;  for count of (B)
	LD	B,D		;play tone
	DJNZ	$
;	********* OFF PORTION
	DEC	A		;  for count of (B)
	OUT	(C),A
	LD	B,D		;hold output low for
	DJNZ	$
;
	DEC	E		;dec the duration
	JR	NZ,DURLP	;
	DJNZ	$		;Hold for 256 count
	ENDIF
;
	POP	DE		;Restore regs
	POP	BC		;
POPAF	POP	AF		;
	RET			;and RETurn
;
LENGTH	EQU	$-HEADER	;Length of Filter
;
;
;***
;	INSTFLT - Relocate & Install Filter
;***
;
INSTFLT	LD	(IX+0),47H	;filter capable of @GET
;
;*=*=* Pick up Old HIGH$ and save in driver *=*=*
;
	LD	HL,0		;Get HIGH$
	LD	B,L		;
	@@HIGH$			;
	LD	(OLDHI),HL	;stuff into header
;
;*=*=* Calculate New HIGH$ & stuff into DCB *=*=*
;
	LD	BC,LENGTH	;Length of driver
	PUSH	BC		;save length
	OR	A		;
	SBC	HL,BC		;HL => New HIGH$
	@@HIGH$			;(B=0) set new HIGH$
	INC	HL		;pt to driver
	LD	(IX+1),L	;Stuff driver address
	LD	(IX+2),H	;into DCB
;
;*=*=* Calc offset between source & dest for relo *=*=*
;
	LD	DE,HEADER	;Start of driver
	PUSH	HL		;Save Source & Dest ptrs
	PUSH	DE		;
	OR	A		;clear carry
	SBC	HL,DE		;get offset
;
;*=*=* Relocate internal references in driver *=*=*
;
	LD	IX,RELTBL	;Point to relocation tbl
	LD	B,H		;Move to BC
	LD	C,L
RLOOP	LD	L,(IX)		;Get address to change
	LD	H,(IX+1)
	LD	A,H
	OR	L
	JR	Z,RELDUN
	LD	E,(HL)		;P/U address
	INC	HL
	LD	D,(HL)
	EX	DE,HL		;Offset it
	ADD	HL,BC
	EX	DE,HL
	LD	(HL),D		;And put back
	DEC	HL
	LD	(HL),E
	INC	IX
	INC	IX
	JR	RLOOP		;Loop till done
;
;*=*=* Relocation Table for Driver *=*=*
;
RELTBL	DW	FILTER+2,0,0,0,0
;
;*=*=* Transfer Filter code to high memory *=*=*
;
RELDUN	POP	HL		;HL => Source DE => Dest
	POP	DE		;
	POP	BC		;BC = length of filter
	LDIR			;block move
	RET			;RETurn
;
;
;***
;	DSPLY - Display a string
;***
;
DSPLY	PUSH	DE		;Save DE
	@@DSPLY			;display it
	POP	DE		;
	RET	Z		;return if good
;
;***
;	IOERR - Any fatal Errors come here
;***
;
IOERR	LD	L,A		;xfer error # to HL
	LD	H,0		;
	OR	0C0H		;short msg & RETurn
	LD	C,A		;*** added 02/19/83 - RS
	@@ERROR			;display error
	JR	EXIT		;go to exit routine
;
;*=*=* Error Handler *=*=*
;
VIASET	LD	HL,VIASET$
	DB	0DDH
CANT	LD	HL,CANT$	;"Unable to install"
;
	@@LOGOT			;log error
	LD	HL,-1		;abort JCL
;
EXIT	LD	SP,$-$		;p/u SP
	@@CKBRKC		;Clear out break
	RET			;and RETurn
;
PRMTBL	DB	'CHAR  '
	DW	CHARPRM+1
	DB	'C     '
	DW	CHARPRM+1
	NOP			;End of table
;
;
CANT$	DB	'No memory space available',CR
VIASET$	DB	'Must install via SET',CR
;
HELLO$	DB	'CLICK'
*GET	CLIENT:3
	END	START
