;BOOT42/ASM - LDOS 6.2 - Model II BOOT - 10/22/83
;
*MOD
;       Model II Boot driver
;
;       Change Log:
; 03/18/83 - Recorrected buffer to use 1200H
;
;	module equates
;
SPCYL	EQU	30		;sectors/cylinder
$HDIO	EQU	0C1H		;hard disk init port
$PIOI	EQU	0E0H		;PIO input (status)
$PIOO	EQU	0E1H		;PIO output (data)
$PIOAC	EQU	0E2H		;PIOA config
$PIOBC	EQU	0E3H		;PIOB config
$FDCCMD	EQU	0E4H		;FDC command
$FDCSTA	EQU	0E4H		;FDC status
$FDCTRK	EQU	0E5H		;FDC track
$FDCSEC	EQU	0E6H		;FDC sector
$FDCDAT	EQU	0E7H		;FDC data
$FDCSEL	EQU	0EFH		;FDC select
$CTC0	EQU	0F0H		;CTC0 config
$CTC1	EQU	0F1H		;CTC1 config
$CTC2	EQU	0F2H		;CTC2 config
$CTC3	EQU	0F3H		;CTC3 config
$SIOAC	EQU	0F6H		;SIOA config
$SIOBC	EQU	0F7H		;SIOB config
$DMA	EQU	0F8H		;DMA command/status
$ROME	EQU	0F9H		;rom enable
$RDKBD	EQU	0FCH		;read keyboard (input)
$CRTC	EQU	0FCH		;CRTC controller (output)
$CRTADD	EQU	0FCH		;CRTC address register
$CRTDAT	EQU	0FDH		;CRTC data register
$RDINT	EQU	0FEH		;clear interrupt latch
$BSEL	EQU	0FFH		;bank/video select port
;
$DMAON	EQU	087H		;DMA ON command
$DMAOFF	EQU	083H		;DMA OFF command
$FREAD	EQU	082H		;floppy read command
$FWRIT	EQU	0A2H		;floppy write command
$FFMT	EQU	0F0H		;floppy format command
$FHOME	EQU	009H		;home drive, min 6ms
$FSEEK	EQU	018H		;seek, head load
$FSTEP	EQU	058H		;step, head load
$FCLER	EQU	0D0H		;floppy force clear
;
;	cursor formats
;
CUR132	EQU	01100101B	;1/32 blink on
CUROFF	EQU	00100101B	;cursor off
CUR116	EQU	01000101B	;1/16 blink on
CURSOL	EQU	00000101B	;cursor solid
$CURON	EQU	CUR132		;cursor ON char
$CUROFF	EQU	CUROFF		;cursor OFF char
;
	DC	-$&0FFH,0	;fill to sector end
CORE$	DEFL	$		;boot loader here
	DC	100H,0		;no need for data here
;
	ORG	CORE$+256
;
	END
;
