;BACKUP3/ASM - LDOS 6.2 - 11/18/83
;*****
;	Module performs special backup by class
;*=*=*
;	Change Log
; 05/13/83 - Added check for WP prot. disk
; 05/31/83 - Correct moving of boot/sys in class BU
;
;*****
	LD	HL,0
	LD	B,L
	@@HIGH$			;Find highest 256-byte
	INC	HL		;  mem block & set test
	DEC	H
	LD	A,H
	LD	(DOFIL06+1),A
	LD	(DOFIL08+1),A
	LD	(LSTBUF1+1),A
	LD	A,0C9H
	LD	(PMTDST1),A	;Ignore dest disk test
	CALL	PMTDST		;Prompt dest drive
;*=*=*
;	Calculate the number of sectors per free disk
;*=*=*
	LD	A,(IY+7)	;P/u # of sectors per cyl
	LD	B,A
	AND	1FH
	LD	C,A
	INC	C		;Adj for zero offset
	XOR	B		;Get # of heads
	RLCA
	RLCA
	RLCA
	INC	A		;Adj to 0 offset
	LD	B,A		;Init loop counter
	XOR	A
	ADD	A,C		;Multiply # sectors/track
	DJNZ	$-1		;  x # of heads/cyl
	LD	L,A
	LD	H,0		;Xfer to 16-bit reg
	BIT	5,(IY+4)	;If 2-sided diskette
	JR	Z,$+3
	ADD	HL,HL		;Double the # of sectors
	LD	C,(IY+6)	;P/u # cyls & adjust for
	DEC	C		;  BOOT & DIR
	@@MUL16			;Calc total records
	LD	H,L
	LD	L,A
	LD	(SIZSAV+1),HL	;Save for later
;*=*=*
;	Read the BOOT sector
;*=*=*
	LD	DE,1		;Read boot sector
	LD	HL,BUF2$
	CALL	RDSEC
	JP	NZ,EXIT3
	LD	A,(BOOTST$)	;P/u the boot step rate
	LD	L,A
	LD	A,(HL)
	AND	3
	LD	(BSCLS+1),A
	LD	A,(BUF2$+2)	;P/u dir cyl
	LD	(IY+9),A	;Stuff into DCT
;***
;	Dec the Prot count
;***
	CALL	CKPROT
;
;*=*=*
;	If a system backup, then check the GAT & HIT
;*=*=*
	LD	A,(PRMTBL$+SYSRSP)
	OR	A
	JP	Z,CLSBU5
;*=*=*
;	If already a SYSTEM disk, don't check BOOT space
;*=*=*
	IF	@MOD2
	CALL	PMTDST		;get dest data
	LD	D,(IY+9)	;get dir cyl
	LD	E,0		;GAT table
	LD	HL,HITBUF	;load here
	CALL	RDSEC		;read it
	CP	6		;directory?
	LD	A,17		;init GAT read error
	JP	NZ,EXIT3	;go on error
	LD	A,(HITBUF+0CDH)	;get Config byte
	BIT	7,A		;System disk ??
	LD	D,0		;cyl 0 if not
	JR	NZ,$+3		;go if system
	INC	D		;sysinfo on cyl 1
	ENDIF
;
	LD	HL,HITBUF	;Read the SYSINFO sector
	LD	E,2
;
;	Mod II save sysinfo sector for later check
;
	IF	@MOD2
	LD	(CKPROT2),DE	;save cyl/sect
	ENDIF
;
	CALL	RDSEC
	JP	NZ,EXIT3
	LD	A,(HITBUF+0C0H)	;P/u & test the SYSTEM
	OR	A		;  disk byte. If already
	LD	D,(IY+9)
	JP	NZ,CLSBU01	;  a system disk, bypass
	LD	E,L		;Point to GAT
	CALL	RDSEC		;Read the GAT
	CP	6
	LD	A,20
	JP	NZ,EXIT3
	LD	B,0		;Need nO more if rigid
	IF	@MOD4
	BIT	3,(IY+3)
	JR	NZ,SETSYS
	ENDIF
;
;	if ALIEN or NOT 8" space is OK
;
	IF	@MOD2
	BIT	3,(IY+3)	;Perchance a hard drive?
	JR	NZ,HRDSYS	;If so, must move boot
	BIT	5,(IY+3)	;8" disk?
	JR	Z,SETSYS	;nope, go!
	BIT	4,(IY+4)	;alien?
	JR	NZ,SETSYS	;yes, go!
	ENDIF
;
;	mod II must have track 0 fully available
;
	IF	@MOD2
	LD	A,(HITBUF+60H)	;track 0 lockout data
	OR	1		;boot/sys allocation
	CP	(HL)		;anything here?
	JP	NZ,NOTSYS	;yes, cannot use!
	ENDIF
;
;	Mod II must have 16 sectors available on cyl 1
;
	IF	@MOD2
	INC	HL		;point to cyl 1
HRDSYS	LD	B,3		;2 grans SD or DD
	ENDIF
;
	IF	@MOD4
	LD	B,2		;If 8" SDEN or DDEN, then
	ENDIF
	BIT	5,(IY+3)	;  need gran 1
	JR	NZ,$+4
	LD	B,6		;5" needs grans 1 & 2
	LD	A,(HL)		;P/u GAT byte for BOOT
	AND	B		;  & ck for needed space
	JR	NZ,NOTSYS
	LD	A,(HL)		;Reserve the GAT space
	OR	B
	LD	(HL),A
;
;	Mod II must make force locked/used cyl 0
;
	IF	@MOD2
	LD	L,0		;reset to beginning
	BIT	3,(IY+3)	;If a hard disk,
	JR	NZ,HRDSYS1	; don't show lockout
	LD	(HL),-1		;allocate cyl 0
	LD	L,60H		;lockout table
	LD	(HL),-1		;lockout cyl 0
;
HRDSYS1	LD	A,-1		;set format/copy 0 flag
	LD	(COPY0),A	;save flag
	ENDIF
;
;*=*=*
;	Mask the config byte "data/system" disk bit
;*=*=*
SETSYS	LD	L,0CDH		;Point to config byte
	RES	7,(HL)		;  & show system disk
	CALL	WRGAT
;*=*=*
;	Adjust the allocation info for BOOT/SYS
;*=*=*
CLSBU0	LD	E,2		;Read the directory
	CALL	RDSEC		;  sector containing
	CP	6		;  BOOT/SYS record
	LD	A,17		;Init "dir read error
	JP	NZ,EXIT3
	INC	B		;Code to 7 3 1
	INC	B		;Code to 8 4 2
	SRA	B		;Code to 4 2 1
	SRA	B		;Code to 2 1 0
;
	IF	@MOD2
	BIT	3,(IY+3)	;rigid drive?
	JR	NZ,CLSBU00	;go if OK
	BIT	4,(IY+4)	;alien?
	JR	NZ,CLSBU01	;go if yes
	BIT	5,(IY+3)	;8"?
	JR	Z,CLSBU01	;go if not
	ENDIF
;
;	Mod II must force BOOT/SYS to new cyl 1
;
	IF	@MOD2
CLSBU00	LD	L,16H		;cylinder start
	LD	(HL),1		;force cyl 1!
	ENDIF
;
	LD	L,17H		;Point tM gran alloc
	LD	(HL),B		;Reset alloc
	LD	L,14H		;Point to ERN
	LD	(HL),16		;Update # BOOT records
	LD	L,0
	CALL	WRSYS		;Write dir sector back
	LD	A,18		;Init "dir write error
	JP	NZ,EXIT3	;exit if so
;*=*=*
;	If OLD entered No SYS file check needed
;*=*=*
CLSBU01
	LD	A,(OLDPRM$)	;Check for OLD entered
	OR	A
	JR	NZ,CLSBU5	;Skip SYS setup if so
;
;*=*=*
;	Now check the HIT positions for /SYS files
;*=*=*
	CALL	HITRD
	JP	NZ,EXIT3
	LD	DE,SYSDEC
	EX	DE,HL		;Dest to DE
	LD	B,16		;Check 16 DECs
CLSBU1	LD	A,(DE)		;If dest spare, stuff
	OR	A		;  with source else
	JR	NZ,CLSBU2	;  test for match
	LD	A,(HL)
	LD	(DE),A
CLSBU2	CP	(HL)		;Dest match source?
	JR	Z,CLSBU3
NOTSYS	LD	HL,NOTSYS$
	JP	EXIT4
CLSBU3	INC	E		;Bump to next DEC
	INC	HL		;  & our table
	LD	A,8		;At midpoint?
	CP	E
	JR	NZ,CLSBU4
	LD	E,20H		;Adjust DEC row #
CLSBU4	DJNZ	CLSBU1
	LD	D,(IY+9)	;Ok to backup SYSTEM
	LD	E,1
	LD	HL,HITBUF
	CALL	WRSYS
	LD	A,23		;Init HIT write error
	CALL	Z,HITRD		;Verify if write OK
	JP	NZ,EXIT3
;*=*=*
; 	Set up byte 'C0' in SYSINFO sector
;*=*=*
	IF	@MOD2
	LD	DE,12H		;P/u Mod-2 SYSINFO Sec.
	ENDIF
	IF	@MOD4
	LD	DE,02		;P/u Mod-4 SYSINFO Sec.
	ENDIF
;	HL => to HITBUF at this point
	CALL 	RDSEC		; Read the sector
	LD	L,0C0H		;Point to type flag
	LD 	(HL),0FFH	;Set it
	LD	L,0		;reset buffer
	CALL	WRSEC		; Write it back
;
CLSBU5
	CALL	PMTSRC		;Prompt source
	CALL	HITRD
	JP	NZ,EXIT3
;*=*=*
;	Start the backup of files
;*=*=*
	LD	HL,HITBUF
	JR	SCNH3		;Branch to start
OPENIT	DB	'R'!80H
SCNHIT	POP	HL
SCNH1	POP	BC
	LD	H,HITBUF<-8	;HIT buf hi-order
	LD	L,B
SCNH2	LD	A,L
	ADD	A,20H		;Advance to next file on
	LD	L,A		;  this dir sector until
	JR	NC,SCNH3	;  end, then go to next
	INC	L		;  dir sector in the HIT
	BIT	5,L		;Did we gO off the end?
	JR	Z,SCNH3		;  (ie from 1F to 20)
	LD	A,0		;Ck if we need to set
SETGAT	EQU	$-1		;  the GAT protect bit
	OR	A
	JR	Z,TOEXIT1	;Exit if not, else set it
	CALL	PMTDST		;Get dest DCT in IY
	LD	HL,HITBUF
	LD	D,(IY+9)	;Get dir cyl
	LD	E,L		;Point to GAT sector
	CALL	RDSEC		;  & read it
	CP	6
	LD	A,20
	JP	NZ,EXIT3
	LD	L,0CDH		;Point to config byte
	SET	4,(HL)
	CALL	WRGAT
TOEXIT1	JP	EXIT1
;*=*=*
;	Continue to scan the major loop
;*=*=*
SCNH3	LD	A,(HL)		;Is HIT entry spare?
	OR	A
	JR	Z,SCNH2
	LD	A,L
	AND	0FEH		;Bypass if BOOT or DIR
	JR	Z,SCNH2
	LD	B,L		;Save DEC
	PUSH	BC
	CALL	PMTSRC		;Prompt for source
	LD	D,(IY+9)	;P/u DIR cyl
	LD	A,B		;Pt to dir sector of
	AND	1FH		;  this file
	ADD	A,2		;Adj for GAT & HIT
	LD	E,A
	LD	HL,BUF2$	;Read dir sector
	CALL	RDSEC
	CP	6		;Proper errcod?
	JP	NZ,DIRERR
	LD	A,B		;Pt to dir record for
	AND	0E0H		;  the source file
	LD	L,A
	LD	H,BUF2$<-8	;Pt to hi-order dir buf
	LD	A,(HL)		;Ignore file if not
	LD	(ATTRIB+1),A	;  assigned in directory
	BIT	4,A
	JR	Z,NODOIT
	BIT	7,A		;Ignore file if FXDE
	JP	NZ,SCNH1
	INC	L		;Bump to DIR+1
	LD	A,(MODPRM$)	;Bypass if parm not
	OR	A		;  entered
	JR	Z,SCNH4
	BIT	6,(HL)		;Not if MOD not set
	JR	Z,NODOIT
;
SCNH4	BIT	4,(HL)		;If not a protected file,
	JR	Z,SCNH4A	;  don't check counter
	LD	A,(SVCTR)	;If counter = 0 or FF,
	OR	A		;  don't backup this file
	JR	Z,NODOIT
	INC	A
	JR	Z,NODOIT
;
SCNH4A	DEC	L
	LD	A,(CLSFLG$)	;P/u CLASS parm byte
	BIT	6,(HL)		;Bypass if not SYS file
	JR	Z,CKINV
	BIT	6,A		;Ok, it is, ck class bit
	JR	Z,NODOIT	;Not this one
	JR	CKNAM		;  else back it
CKINV	BIT	3,(HL)		;Test if file is INV
	JR	Z,CKNAM
	BIT	3,A		;File is, want INV files?
NODOIT	JP	Z,SCNH1		;Don't want invisibles
CKNAM	LD	A,(SPCFLD$)	;Now test filespec match
	CP	' '		;If blank, don't bother
	JR	NZ,CKNAM0	;  to match, take it
	LD	A,(SPCFLD$+8)	;How about the extension?
	CP	' '
	JR	Z,SCNH6
;*****
;	test for a filespec match
;*****
CKNAM0	PUSH	HL
	LD	A,L
	ADD	A,5		;Pt to filename in dir
	LD	L,A
	LD	DE,SPCFLD$
	LD	B,11		;11 char max
CKNAM1	LD	A,(DE)		;P/u user entry
	CP	'$'		;Wild card character?
	JR	Z,CKNAM2
	CP	(HL)		;Same as filespec?
	JR	Z,CKNAM2	;Loop if so
	CP	' '		;Ignore any further?
	JP	NZ,TSTMFLG	;If not blank, nO match
CKNAM2	INC	HL		;Match so far
	INC	DE
	DJNZ	CKNAM1
;*****
;	filespec class matches, does date?
;*****
	LD	A,(MFLG$)	;Bypass if a match but
	OR	A		;  - exclude given
	JP	NZ,SCNHIT
	JR	SCNH5
TSTMFLG	LD	A,(MFLG$)	;Ignore if nG match &
	OR	A		;  no exclude given
	JP	Z,SCNHIT
SCNH5	POP	HL		;Rcvr ptr to DIR+0
SCNH6	PUSH	HL
;*=*=*
;	Now check if date matches
;*=*=*
	INC	HL		;Pt to date field
	CALL	UNPACK		;Alter date for cpr
	LD	A,(FTFLG$)
	RLCA			;Tst fm bit
	JR	NC,SCNH7
	LD	A,D		;Ignore if no date
	OR	E		;  in DIR for file
	JP	Z,SCNHIT
	LD	HL,(FMPAKD$)	;P/u user entry
	EX	DE,HL
	CALL	CPHLDE		;HL-DE
	EX	DE,HL
	JP	C,SCNHIT
SCNH7	LD	A,(FTFLG$)
	RRCA			;Tst TO bit
	JR	NC,MATCHES	;Go if no TOPARM else
	LD	A,D		;  ck if file is dated
	OR	E
	JP	Z,SCNHIT
	LD	HL,(TOPAKD$)	;P/u user's packed date
	CALL	CPHLDE		;HL-DE
	JP	C,SCNHIT
MATCHES	POP	HL
DONAM	LD	A,L		;Pt to start of dir rec
	AND	0E0H
	LD	L,A		;Make sure its on stack
	PUSH	HL
	ADD	A,5		;Pt to start of filename
	LD	L,A
	LD	DE,FCB1$	;Move filename into fcb
	LD	B,8
DONAM1	LD	A,(HL)
	CP	' '
	JR	Z,DONAM2
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	DONAM1
DONAM2	LD	A,L		;Pt to file extension
	ADD	A,B		;  by adding the
	LD	L,A		;  loop remainder
	LD	A,(HL)
	CP	' '
	JR	Z,DONAM5	;Bypass if none there
	LD	A,'/'		;  else set separator
	LD	(DE),A
	INC	DE
	LD	B,3		;Now move in ext
DONAM4	LD	A,(HL)
	CP	' '
	JR	Z,DONAM5
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	DONAM4
DONAM5	LD	A,3		;Terminate with ETX
	LD	(DE),A
	PUSH	DE		;Save pointer
;*=*=*
;	Check for NEW or OLD option
;*=*=*
	LD	A,(OLDPRM$)	;P/u parm & merge
	LD	HL,NEWPRM$	;  with new
	OR	(HL)		;If neither, bypass
	JR	Z,BYPASS
	LD	HL,FCB1$	;Save current spec
	LD	DE,FCB3$
	LD	BC,32
	LDIR
	POP	DE
	PUSH	DE		;Ptr where pswd goes
	CALL	MAKSPC		;Make it a file spec
	CALL	GETDST		;Bring in the dest disk
	LD	HL,(BUFFER$)	;Buffer is irrelevant
	LD	DE,FCB2$	;Pt to dest spec
	PUSH	IY
	@@FLAGS
	SET	0,(IY+'S'-'A')	;Inhibit file open bit
	POP	IY
	@@OPEN			;Attempt to open
	POP	DE		;Keep stack proper
	JR	Z,CKOLD		;If file exists, ck OLD
	CP	25		;File access denied?
	JR	Z,CKOLD		;  means it exists!!!
	CP	24		;File not found?
	JP	NZ,SCNHIT	;Ignore if not
	LD	A,(NEWPRM$)	;Check if NEW  requested
	OR	A
	JR	NZ,GODOIT	;Go if NEW & not found
	JP	SCNHIT
CKOLD	LD	A,(OLDPRM$)	;Was found, backup old
	OR	A		; files this time?
	JP	Z,SCNHIT	;Ignore if not OLD
GODOIT	PUSH	DE
	LD	HL,FCB3$	;Recover the original
	LD	DE,FCB1$	;  file name
	LD	BC,32
	LDIR
;*=*=*
;	Check if prompting or not (Q parm)
;*=*=*
BYPASS	LD	A,(QPARM$+1)	;Query each file?
	OR	A
	JP	Z,NOPRMPT	;Not if not entered
	@@DSPLY	QUERY		;"backup filespec ?
	POP	DE		;Rcvr ptr to file buf
	POP	HL		;Rcvr ptr to 1st dir byte
	PUSH	DE
	INC	HL		;Pt to MOD bit
	BIT	6,(HL)		;Test MOD flag
	JR	Z,SCDAT1
	LD	A,' '		;Put a space
	LD	(DE),A
	INC	DE
	LD	A,'+'
	LD	(DE),A		;Display '+' if MOD
	INC	DE
SCDAT1	LD	A,' '		;Write a space
	LD	(DE),A
	INC	DE
	INC	HL		;Advance to date field
	EX	DE,HL
	LD	(HL),'{'	;Stuff left brace
	INC	HL
	EX	DE,HL
	LD	A,(HL)		;If no date, then skip
	OR	A
	JR	Z,SCDAT4	;Ignore if no date saved
	RRCA			;Has date, get day
	RRCA
	RRCA
	AND	1FH
	LD	B,2FH		;Convert day to decimal
SCDAT2	INC	B		;  by counting # of 10's
	SUB	10		;Sub 10 from day #
	JR	NC,SCDAT2
	ADD	A,3AH		;Cvrt lM order tO ASCII
	PUSH	AF		;Save day low order
	LD	A,B		;Stuff day hi order
	LD	(DE),A
	INC	DE		;Bump
	POP	AF		;Rcvr lo order day #
	LD	(DE),A		;Stuff low order
	INC	DE		;Bump pointer to msg
	LD	A,'-'
	LD	(DE),A		;Stuff '-'
	INC	DE		;Pt tO month field
	PUSH	HL		;Save DIR ptr
	PUSH	AF		;Save cur/notcur
	DEC	HL		;Pt to DIR+1 (month+)
	LD	A,(HL)		;P/u month etc
	AND	0FH		;Strip off flags
	DEC	A		;(mon-1)*3 to index
	LD	C,A		; string conversion table
	RLCA
	ADD	A,C
	LD	C,A
	LD	B,0
	LD	HL,MONTBL
	ADD	HL,BC		;Add offset to tbl start
	LD	C,3
	LDIR			;Move 3-char month
	POP	AF
	LD	(DE),A
	INC	DE		;Advance to year field
	LD	A,'8'		;Stuff 8 of 1980
	LD	(DE),A
	INC	DE		;Bump msg ptr
	POP	HL		;Rcvr DIR+2
	LD	A,(HL)		;P/u year field
	AND	7		;RemOve day
	ADD	A,'0'		;Cvrt tG ASCII
	LD	(DE),A		;Stuff -> msg
	INC	DE
SCDAT4	LD	A,3		;Show etx for display
	LD	(DE),A
	@@DSPLY	FCB1$		;Pt to filespec
	@@DSPLY	QMARK$
	LD	HL,(BUFFER$)	;Get user response
	LD	BC,3<8
	@@KEYIN
	JP	C,ABRTBU
	LD	A,(HL)
	RES	5,A		;Strip lc if present
	CP	'Y'
	JR	Z,CPYMSG
;*=*=*
;	Accept 'C' for response to set QUERY=N
;*=*=*
	SUB	'C'		;Was response "C"?
	JP	NZ,SCNHIT	;Don't backup if not
	LD	(QPARM$+1),A	;Set QUERY=N
CPYMSG	EX	(SP),HL		;Place dummy HL below
	PUSH	HL		;  FCB1$ ETX pointer
;*=*=*
;	Display copying file info
;*=*=*
NOPRMPT	@@CKBRKC		;Ck if BREAK bit in
				;  KFLAG$ is active
	JP	NZ,ABRTBU
	@@LOGOT	CPYFIL$		;"copying file...
	POP	HL		;Get pointer where ETX
	LD	(HL),CR		;  is & replace with CR
	PUSH	HL
	@@LOGOT	FCB1$		;  & the filespec...
	POP	DE		;Rcvr ptr to CR
	POP	HL
;*=*=*
;	Put in the drive spec
;*=*=*
DOBU	CALL	MAKSPC		;Make the filespec
	POP	BC		;Get DEC of source
	PUSH	BC
	LD	A,B		;Test if a SYS file
	AND	0D8H
	JP	NZ,DOFIL0	;jump if not SYS
ATTRIB	LD	A,0		;P/u attribute byte
	BIT	6,A		;Don't do if not SYS
	JP	Z,DOFIL0
;*****
;	routine to copy over SYS files
;*****
	CALL	PMTDST		;Prompt dest drive
	LD	D,(IY+9)	;P/u dir cyl of dest
	LD	A,B		;Get DEC & calc sector
	AND	1FH
	ADD	A,2		;Adj for GAT & HIT
	LD	E,A
	LD	HL,(BUFFER$)	;P/u buffer addr
	CALL	RDSEC		;Read dir sect
	CP	6		;Proper errcod?
	JP	NZ,DIRERR
	LD	A,B		;Pt to 1st byte of
	AND	0E0H		;  dir record
	LD	L,A
	BIT	4,(HL)		;Go if already assigned
	JR	NZ,DOSYS1
	LD	(HL),5FH	;Show assigned, SYS, INV
	INC	HL		;  & no access
	LD	(HL),0		;Zero out DIR+1 to DIR+4
	LD	D,H
	LD	E,L
	INC	DE
	LD	BC,3
	LDIR
	LD	A,L		;Pt HL to DIR+16
	ADD	A,12
	LD	L,A
	INC	A
	LD	E,A		;Pt DE to DIR+17
	LD	(HL),0FFH	;Stuff X'FF' into extent
	LD	C,15		;  & pswd fields
	LDIR
DOSYS1	LD	A,L		;Pt HL to name field
	AND	0E0H		;  of source
	BIT	6,(HL)		;Guard against writing
	JP	Z,NOTSYS	;  over a non-SYS file
	ADD	A,5
	LD	L,A
	LD	E,A		;Pt DE tG name field of
	LD	H,BUF2$<-8	;  destination
	LD	A,(BUFFER$+1)	;P/u buffer hi-orderaddr
	LD	D,A
	LD	BC,13		;Move name/ext into dest
	LDIR
	LD	D,(IY+9)	;P/u dir cyl of dest
	POP	BC		;Rcvr DEC of source
	PUSH	BC
	LD	A,B		;Calc dir sector for
	AND	1FH		;  source SYS module
	ADD	A,2
	LD	E,A
	LD	HL,(BUFFER$)	;P/u buffer ptr for dest
	CALL	WRSYS		;Write the dir tG dest
	LD	A,18
	JP	NZ,EXIT3
;*****
;	The HIT entries were transferred prior
;*****
	POP	BC		;Rcvr DEC of source
	PUSH	BC
	LD	A,B		;Test for SYS0
	CP	2
	JP	NZ,DOFIL0	;Bypass if not SYS0
	CALL	PMTSRC		;Prompt source
	IF	@MOD4
	LD	B,16		;Init to xfer BOOT track
	LD	DE,0		;Read cyl 0, sect 2
	ENDIF
	IF	@MOD2
	LD	DE,(CKPROT2)	;get sysinfo sector
	LD	A,D		;get cyl
	OR	A		;on cyl 0?
	JR	NZ,OKCPYB	;nope, ok to copy boot
	LD	A,(COPY0)	;get copy cyl 0 flag
	OR	A		;need to copy?
	JP	Z,DOFIL0	;nope, continue
OKCPYB	LD	B,16
	LD	DE,1<8+0
	ENDIF
	LD	HL,(BUFFER$)	;  which has the drive
RDBOOT	CALL	RDSEC		;  code table
	JP	NZ,EXIT3
	INC	H		;Pt tG next block
	INC	E		;Point to next sector
	DJNZ	RDBOOT
;
;	turn off CONFIG on destination disk
;
	LD	HL,(BUFFER$)	;start cyl image
	LD	DE,100H*2+1	;offset to sector 2 +1
	ADD	HL,DE		;HL => config byte
	LD	(HL),0C9H	;config off!
;
DOSYS2	CALL	PMTDST		;Prompt destination
	IF	@MOD4
	LD	B,16
	LD	DE,0		;Copy it to the dest
	ENDIF
	IF	@MOD2
	LD	B,16
	LD	DE,1<8+0
	ENDIF
	LD	HL,(BUFFER$)
WRBOOT	LD	A,E		;If sector 0 or 1,
	CP	2		;  correct DIRCYL &
	IF	@MOD4
	JR	NC,WRBOOT2	;  BOOT step rate
	ENDIF
	IF	@MOD2
	JR	WRBOOT2		;no adjust here mod II!
	ENDIF
	OR	A
	JR	Z,WRBOOT1	;if sec 0 only dir cyl
;
	LD	A,(BOOTST$)	;P/u step pointer
	LD	L,A
	LD	A,(HL)		;P/u BOOT step rate
	AND	0FCH		;Strip the rate
BSCLS	OR	0		;Merge dest rate
	LD	(HL),A
WRBOOT1	LD	A,(IY+9)	;P/u DIR cyl
	LD	L,2
	LD	(HL),A
	LD	L,0		;Restart to buf start
WRBOOT2	CALL	WRSEC
	JP	NZ,EXIT3
	INC	H		;Bump buffer page
	INC	E		;Bump sector
	DJNZ	WRBOOT
;*=*=*
;	Verify this track
;*=*=*
	IF	@MOD4
	LD	B,16
	LD	DE,0
	ENDIF
	IF	@MOD2
	LD	B,16
	LD	DE,1<8+0
	ENDIF
VRBOOT	CALL	VERSEC
	JP	NZ,EXIT3
	DJNZ	VRBOOT
;
;	Mod II check if cyl 0 to be formatted on dest
;
	IF	@MOD2
	LD	DE,(CKPROT2)	;get sysinfo sector
	LD	A,D		;get cyl
	OR	A		;on zero?
	JR	NZ,OKWRT0	;go if not!
	LD	A,(COPY0)	;get flag
	OR	A		;FF = copy cyl 0!
	JR	Z,COPY0E	;go if not to copy
OKWRT0	CALL	PMTSRC		;get source disk
	CALL	READ0		;read cyl 0
	JP	NZ,EXIT3	;go on disk error
	CALL	PMTDST		;get dest disk
	CALL	FORMAT0		;format cyl
	JP	NZ,EXIT3	;go on disk error
;
;	setup new track length into boot data
;
	LD	HL,(BUFFER$)	;get I/O buffer
	PUSH	HL		;save start
	INC	HL		;+1
	INC	HL		;+2 (dir cyl)
	LD	A,(IY+9)	;get dir cyl
	LD	(HL),A		;to buffer
	INC	HL		;+3 (boot step rate)
	LD	A,(BSCLS+1)	;get step rate
	AND	3		;step rate only
	LD	(HL),A		;load into buffer
	INC	HL		;bump
	LD	A,(IY+7)	;get data
	AND	1FH		;highest sector #
	INC	A		;sectors / track
	LD	(HL),A		;to buffer
	INC	HL		;bump
	LD	A,(IY+3)	;get data
	ADD	A,A		;density => bit 7
	AND	80H		;keep only
	LD	(HL),A		;to buffer
	POP	HL		;HL => buffer start
	LD	D,H		;pass to DE
	LD	E,L		;DE => buffer start
	LD	BC,80H		;buffer length
	ADD	HL,BC		;HL => dest
	EX	DE,HL		;HL=>source, DE=>dest
	LDIR			;copy sector 0 => sec 1
	CALL	PMTDST		;re-fetch DCT
	CALL	WRITE0		;write the cylinder
	JP	NZ,EXIT3	;go on disk error
COPY0E	EQU	$
	ENDIF
;*****
;	routine to perform the file copy to destination
;*****
DOFIL0	LD	DE,OPENIT	;Permit OPEN of file
	@@RENAM
	LD	B,0		;Lrl = 256
	CALL	GETSRC		;Prompt source & set fcb
	LD	HL,(BUFFER$)	;Get buffer addr
	@@FLAGS
	SET	0,(IY+'S'-'A')	;Inhibit file open bit
	@@OPEN			;Open the source file
	JP	NZ,EXIT3
;*=*=*
;	Check if source file can fit on destination disk
;*=*=*
	LD	HL,(FCB1$+12)	;P/u ERN
SIZSAV	LD	DE,$-$		;P/u disk capacity
	XOR	A
	SBC	HL,DE		;If < size, then OK
	JR	C,SIZOK
	LD	HL,SIZBIG$	;  else file to big
	@@LOGOT			;Inform user & continue
	JP	SCNH1
SIZOK	LD	DE,OPENIT
	@@RENAM
	LD	B,0		;Lrl = 256
	CALL	GETDST		;Prompt dest & set fcb
	LD	HL,(BUFFER$)	;Get buffer addr
	@@INIT			;Init the dest
	JR	Z,LRLOK		;If no error, cont.
	CP	42		;Was it LRL error?
	JR	Z,LRLOK
	JP	EXIT3
LRLOK	LD	A,(FCB2$+7)	;P/u DEC of dest
	LD	(DOFIL11+1),A
	LD	BC,(FCB1$+12)	;P/u ERN & ck for enuf
	CALL	WRERN		;Dest space on disk
	POP	BC		;Recover DEC
	LD	L,B		;Reset HL tO dir
	LD	H,BUF2$<-8
	PUSH	BC		;Save DEC
	JR	Z,DOFIL02
	CALL	PMTSRC		;Prompt for source
	JP	DONAM
DOFIL02	LD	A,L		;If protected file,
	AND	0E0H		;  need to set up
	INC	A		;  for setting dest GAT
	LD	L,A
	BIT	4,(HL)
	JR	Z,$+5
	LD	(SETGAT),A
;
	LD	HL,0
	LD	(FCB2$+12),HL	;Set dest ERN tO 0
	@@REW			;Rewind the dest
DOFIL03	LD	HL,(BUFFER$)	;Buffer addr
DOFIL04	LD	(FCB1$+3),HL	;Set buffer addr in fcb
	CALL	GETSRC		;Prompt source & set fcb
	@@READ
	JR	Z,DOFIL05
	CP	1CH		;Eof?
	JR	Z,DOFIL09
	CP	1DH		;Nrn > ern?
	JR	Z,DOFIL09
	JP	EXIT3
DOFIL05	INC	H
	LD	A,H
DOFIL06	CP	0		;Test out of memory
	JR	NZ,DOFIL04
	LD	HL,(BUFFER$)	;P/u buffer addr
DOFIL07	LD	(FCB2$+3),HL	;  & set into dest fcb
	CALL	GETDST		;Prompt dest & set fcb
	@@VER
	JP	NZ,EXIT3
	INC	H
	LD	A,H
DOFIL08	CP	0		;Out Gf memory?
	JR	NZ,DOFIL07
	JR	DOFIL03
DOFIL09	CALL	LSTBUF		;Write remaining buffer
	LD	HL,(FCB1$+8)	;P/u DEC & LRL
	LD	(FCB2$+8),HL	;  & stuff into dest
	CALL	GETDST		;Prompt dest
	@@CLOSE			;Close er up
	JP	NZ,EXIT3
;*****
;	now remove the mod flag from destination
;*****
	LD	D,(IY+9)	;P/u dir cyl
DOFIL11	LD	B,0		;P/u DEC
	LD	A,B		;Pt to dir sector
	AND	1FH
	ADD	A,2
	LD	E,A
	PUSH	DE		;Save cyl/sect
	LD	HL,(BUFFER$)	;P/u buffer addr
	CALL	RDSEC		;Read the dir sect
	CP	6		;Proper errcod?
	LD	A,17
	JP	NZ,EXIT3
	LD	A,B		;Pt to dir record
	AND	0E0H
	LD	E,A		;Pt to DIR lo order
	LD	A,(BUFFER$+1)	;P/u hi order buffer pos
	LD	D,A
	POP	HL
	POP	BC		;P/u DEC & buffer of src
	PUSH	BC
	PUSH	HL
	LD	A,B
	AND	0E0H		;Pt to start of src dir
	LD	L,A
	LD	H,BUF2$<-8	;Transfer the passwords
	INC	L		;Pt to mod flag byte
	RES	6,(HL)		;Reset the MOD bit
	DEC	L		;Point to 1st DIR+0
	LD	BC,5		;Transfer up thru
	LDIR			;  DIR+4
BYSPACE	LD	A,E		;Point DE to the dest
	ADD	A,11		;  password fields
	LD	E,A
	LD	A,L		;Point HL to the source
	ADD	A,11		;  password fields
	LD	L,A
	LD	BC,4		;Move both pswds
	LDIR
	LD	HL,(BUFFER$)	;P/u buffer addr
	POP	DE		;Rcvr cyl/sect
	CALL	WRSYS		;Write back
	LD	A,18
	JP	NZ,EXIT3
;*****
;	attempt to clear mod flag of source
;*****
DOFIL12	LD	A,0		;Test for write prot src
	OR	A		;Which implies, can't
	JP	NZ,SCNH1	;  clear mod flags
	POP	BC		;P/u DEC of source
	PUSH	BC
	LD	A,B		;Clear mod flag on source
	AND	0E0H		;Dir sector is resident
	INC	A		;In a buffer at BUF2
	LD	L,A
	LD	H,BUF2$<-8
	RES	6,(HL)
	CALL	PMTSRC		;Prompt source
	LD	D,(IY+9)	;P/u dir cyl
	LD	A,B		;Pt to dir sect of source
	AND	1FH
	ADD	A,2
	LD	E,A
	LD	HL,BUF2$
	CALL	WRSYS		;Write it back
	JP	Z,SCNH1
	CP	15		;Accept only "write prot
	LD	A,18
	JP	NZ,EXIT3
	LD	A,0FFH		;Turn off clear mod
	LD	(DOFIL12+1),A	;  flag test
	@@LOGOT	CCMOD$		;"can't clear...
	JP	SCNH1		;Loop to next file
;*=*=*
;	Routine to compare HL to DE
;*=*=*
CPHLDE	LD	A,H
	SUB	D
	RET	NZ
	LD	A,L
	SUB	E
	RET
;*=*=*
;	Routine to construct filespec from name/ext
;*=*=*
MAKSPC	LD	A,':'		;Prepare for drivespec
	LD	(DE),A
	INC	DE
	PUSH	DE		;Save pointer
	LD	A,(DSTDRV$+1)	;P/u dest drive #
	AND	7		;Cvrt to ascii
	ADD	A,'0'
	LD	(DE),A		;& stuff at filespec end
	INC	DE
	LD	A,3		;Terminate with ETX
	LD	(DE),A
	LD	HL,FCB1$	;Copy source fcb to
	LD	DE,FCB2$	;  dest fcb
	LD	BC,32
	LDIR
	POP	DE		;Rcvr where source spec
	LD	A,(SRCDRV$+1)	;P/u source drive #
	AND	7		;Cvrt tM ascii
	ADD	A,'0'
	LD	(DE),A		;Stuff in dest fcb
	RET
;*=*=*
;	Routine tM extract date from directory
;*=*=*
UNPACK	LD	A,(HL)		;P/u DIR+1
	AND	0FH		;Remove flags
	LD	D,A		;Save month
	INC	HL		;Pt to DIR+2
	LD	A,(HL)
	AND	0F8H		;Strip year
	LD	E,A
	LD	A,(HL)
	XOR	E		;Get year
	RRCA			;Shift year to 5-7
	RRCA
	RRCA
	OR	D		;Merge with month
	LD	D,A
	RET
;*=*=*
;	Write the GAT back to disk
;*=*=*
WRGAT	LD	L,0		;  by resetting bit 7
	CALL	WRSYS
	LD	A,21		;Init GAT write error
	JP	NZ,EXIT3
	CALL	VERSEC
	CP	6
	LD	A,20		;Init GAT read error
	JP	NZ,EXIT3
	RET
;*****
;	write last buffer if needed
;*****
LSTBUF	LD	A,(BUFFER$+1)
	CP	H
	RET	Z
LSTBUF1	LD	A,0
	CP	H
	RET	Z
	LD	B,H
	LD	HL,(BUFFER$)	;P/u buffer addr
LSTBUF2	LD	(FCB2$+3),HL
	CALL	GETDST		;Prompt dest
	@@VER
	JP	NZ,EXIT3
	INC	H
	LD	A,H
	CP	B
	JR	NZ,LSTBUF2	;Loop if more
	RET
;*****
;	check if enough space on destination disk
;*****
WRERN	LD	A,B		;If ERN = 0, don't
	OR	C		; write a ERN
	RET	Z
	DEC	BC		;Adjust for 0 offset
	CALL	GETDST		;Prompt dest
	PUSH	DE		;Save fcb pointer
	@@POSN			;Pmsition to end
	LD	HL,(BUFFER$)	;P/u buffer addr
	LD	D,H		;Construct a format
	LD	E,L		;  sector of all X'E5's
	INC	DE
	LD	BC,255
	LD	(HL),0E5H
	LDIR
	POP	DE		;Rcvr fcb ptr
	@@VER
	RET	Z		;Ret if no error
	CP	27		;Disk Full?
	JR	NZ,NOTDF
	@@REMOV			;Remove what can't fit
	BIT	3,(IY+3)	;If rigid fixed drive
	JR	Z,NOTHARD
	BIT	2,(IY+3)
	JR	Z,NOTHARD
	LD	HL,FULDRV$
	JR	DOING1
NOTHARD	@@FLAGS
	BIT	5,(IY+'S'-'A')	;Can't switch while DOing
	JR	NZ,DOING
	LD	HL,NEWDISK	;"disk full, enter new...
	CALL	FLASH
	OR	1		;Show switched dest
	RET
NOTDF	EQU	$
	JP	EXIT3
GETSRC	PUSH	BC
	LD	DE,FCB1$
	CALL	PMTSRC
	POP	BC
	RET
GETDST	PUSH	BC
	LD	DE,FCB2$
	CALL	PMTDST
	POP	BC
	RET
HITRD	LD	D,(IY+9)	;P/u dir cyl of source
	LD	E,1		;Read HIT
	LD	HL,HITBUF	;Into HIT buffer
	CALL	RDSEC
	CP	6		;Errcod correct?
	LD	A,17H
	RET
DOING	LD	HL,DOMSG
DOING1	JP	EXIT4
CPYFIL$	DB	29,'Copying file: ',3
QUERY	DB	'Backup ',3
FULDRV$	DB	'Disk is full!',CR
NEWDISK	DB	'Disk is full! - Enter new formatted '
	DB	'destination disk  <ENTER>',29,3
DOMSG	DB	'Disk is full! - Can''t switch '
	DB	'while <DO> in effect',CR
SIZBIG$	DB	'  File is larger than destination '
	DB	'capacity - backup is bypassed',CR
NOTSYS$	DB	'Can''t create SYSTEM disk - '
	DB	'directory slots in use',CR
QMARK$	DB	'} ? ',3
MONTBL	DM	'JanFebMarAprMayJunJulAugSepOctNovDec'
SYSDEC	DB	0A2H,0C4H,2EH,2FH,2CH,2DH,2AH,2BH
	DB	28H,29H,26H,27H,27H,0A7H,26H,0A6H
;
	DC	64,0	;PATCH space
;
	ORG	$<-8+1<+8
HITBUF	DS	256
