;BACKUP2/ASM - LDOS 6.2 - 11/01/83
*MOD
;*****
;	This section performs the mirror-image backup
;*=*=*
;	Change Log
; 05/13/83 - Added test for switch/prot. disk
;*****
	CALL	DSTDRV$		;Prompt for dest but
	CALL	PMTDST		;  don't test yet
	LD	HL,BUF3$
	LD	D,L
	LD	E,1		;Read sector 1 for step
	CALL	RDSEC		;Read BOOT
	JP	NZ,EXIT3
	LD	A,(BOOTST$)	;P/u the boot step rate
	LD	L,A
	LD	A,(HL)
	AND	3
	LD	(BSMIR+1),A
	LD	A,(BUF3$+2)	;P/u Boot track
	LD	D,A
	LD	HL,BUF2$	;Read dest GAT into buf
	LD	E,L
	CALL	RDSEC
	CP	6
	LD	A,20
	JP	NZ,EXIT3
	LD	HL,BUF1$+0CEH	;Source GAT
	LD	DE,BUF2$+0CEH	;Dest GAT
	LD	B,10		;Compare pack names
CPRID	LD	A,(DE)		;  and passwords
	CP	(HL)
	JR	Z,IDMATCH
;*=*=*
;	Move disk name into message
;*=*=*
	LD	HL,BUF2$+0D0H
	LD	DE,PACKID$+5	;Move name into
	LD	BC,8		;  display message field
	LDIR
	LD	DE,PACKID$+20
	LD	C,8
	LDIR
	@@LOGOT	DIFID$		;"diff pack ids..
	@@FLAGS			;If DOing, don't!
	BIT	5,(IY+'S'-'A')
	JR	NZ,IDMATCH-3
;*=*=*
;	If MPW = "PASSWORD", just query Y,N
;*=*=*
	LD	HL,(BUF2$+0CEH) ;P/u disk MPW
	LD	DE,PASSWORD	;Password=PASSWORD
	XOR	A
	SBC	HL,DE
	JR	Z,PMTYN
;*=*=*
;	User must enter Current Pack's MPW to proceed
;*=*=*
OLDMPW	LD	HL,OLDMPW$	;"What's the old MPW?
	LD	DE,0		;Force prompt of message
	CALL	GETMPW		;Grab user input to match
;*****
;	Routine to test master password for match
;*****
	EX	DE,HL		;Xfer hashed MPW to DE
	LD	HL,(BUF2$+0CEH) ;Else grab pack MPW
	XOR	A		;Clear carry flag
	SBC	HL,DE		;Did user enter pack MPW?
	LD	HL,BADMPW$
	JP	NZ,EXIT4	;Abort if no match
	JR	$?1
PMTYN	@@DSPLY	PMTYN$
	LD	HL,LILBUF$	;Prompt to continue
	LD	BC,3<8		;  since ID's differ
	@@KEYIN
	JP	C,ABRTBU	;Exit on break
	LD	A,(HL)
	RES	5,A
	CP	'Y'
	JR	Z,$?1		;Go if continue
	JP	ABRTBU		;  else abort
IDMATCH	INC	DE
	INC	HL
	DJNZ	CPRID
$?1	LD	HL,BUF2$+60H	;Dest lockout table
	LD	DE,BUF1$+60H	;Source lockout table
	LD	B,60H		;Init to compare
CPRLOK	LD	A,(DE)
	CPL
	LD	C,A
	PUSH	DE
	LD	A,E		;Compare disk lockout
	SUB	60H		;  table for match
	LD	E,A
	LD	A,(DE)
	POP	DE
	AND	C
	AND	(HL)
	JP	NZ,NOTMIR	;"dest disk flawed
	INC	DE
	INC	HL
	DJNZ	CPRLOK
;*=*=*
;	Dest can take backup, insert HALT for swap test
;*=*=*
	CALL	PMTDST		;Prompt dest
	LD	HL,BUF3$	;Read BOOT
	LD	D,L
	LD	E,L
	CALL	RDSEC
	JP	NZ,EXIT3
	LD	(HL),76H	;Insert HALT to guard
	LD	HL,BUF3$	; against incomplete BU
	CALL	WRSEC
	JP	NZ,EXIT3
	LD	A,(BUF3$+2)	;P/U current dest/dir
	LD	(STRDIR$+1),A	; store it for later
;*=*=*
;	Use source directory track for destination
;*=*=*
	CALL	PMTSRC		;Prompt source
	LD	A,(IY+9)	;Get source dir cyl
	LD	(DSTDIR+1),A
;*=*=*
;	Calculate the number of sectors per cylinder
;*=*=*
	LD	A,(IY+7)	;P/u # of sectors per cyl
	LD	B,A
	AND	1FH
	LD	C,A
	INC	C		;Adj for zero offset
	XOR	B		;Get # of heads
	RLCA
	RLCA
	RLCA
	INC	A		;Adj to 0 offset
	LD	B,A		;Init loop counter
	XOR	A
	ADD	A,C		;Multiply # sectors/track
	DJNZ	$-1		;X # of heads/cyl
	BIT	5,(IY+4)	;If 2-sided diskette
	JR	Z,$+3
	ADD	A,A		;Double the # of sectors
	LD	(LDCYL4+1),A
	LD	(DUCYL5+1),A
	LD	(VECYL4+1),A
	LD	(RESMF6+1),A
	LD	(RESMF2+1),A
;*=*=*
;	Calculate the amount of core required
;*=*=*
	LD	B,A		;Calculate amount of
	LD	HL,0		;  core required
	PUSH	BC
	LD	B,L
	@@HIGH$
	POP	BC
	INC	HL
	DEC	H
	LD	DE,(BUFFER$)	;Get buffer addr
	LD	A,H
	SUB	D
	LD	C,-1
$?2	INC	C
	SUB	B
	JR	NC,$?2
	LD	A,C
	LD	(LDCYL6+1),A
;*=*=*
;	Get source & initialize
;*=*=*
	CALL	PMTSRC		;Prompt source
	XOR	A
	LD	(LDCYL5+1),A
	LD	D,A
	CALL	CKPROT		;See if disk switched!
;*=*=*
;	Here each time a new load cycle
;*=*=*
LDTKS	LD	HL,(BUFFER$)
	LD	A,D
	LD	(DUCYL+1),A
;*=*=*
;	Here on each track loaded
;*=*=*
LDTKS1
	@@CKBRKC		;Ckeck for break abort
	JP	NZ,BREAK	; abort if so
;
	PUSH	HL
	LD	H,BUF1$<-8	;Pt to source GAT
	LD	L,D
	LD	C,(HL)		;P/u Free/Alloc byte
	LD	A,D
	ADD	A,60H		;Pt to Lockout byte
	LD	L,A		;If source track is
	LD	A,(HL)		;  locked out, don't
	CPL			;  back it up - BUT
	AND	C		;  show dest is "in use"
	LD	H,BUF2$<-8	;Pt to dest lockout
	LD	C,(HL)		;P/u dest lockout byte
	OR	C		;Merge with source
	LD	L,D		;Xfer pattern to FREE
	LD	(HL),A		;  field of dest
	CP	C
	POP	HL
	JP	Z,LDCYL7	;Go if ignore this track
;*=*=*
;	Get source disk and load
;*=*=*
	CALL	PMTSRC		;Prompt source
	PUSH	HL
	LD	E,0		;Start track at sector 0
	LD	A,D		;This is the cylinder
	LD	HL,CYL$
	CALL	CVTDEC
	PUSH	DE
	@@DSPLY	LDCYL$		;"loading cylinder...
	@@DSPLY	CYL$		;"xx...
	POP	DE
	POP	HL
LDCYL2	CALL	RDSEC		;Copy all sectors
	JR	Z,LDCYL3
	CP	6
	JP	NZ,EXIT3
LDCYL3	INC	H
	INC	E
	LD	A,E
LDCYL4	CP	0		;# of sectors
	JR	NZ,LDCYL2
LDCYL5	LD	A,0
	INC	A
	LD	(LDCYL5+1),A
	LD	B,A
LDCYL6	LD	A,0
	CP	B
	JR	Z,LDCYL8
LDCYL7	INC	D
	LD	A,D
	CP	60H		;Highest track #?
	JP	NZ,LDTKS1
	LD	A,(LDCYL5+1)
	OR	A
	JP	Z,MOVID
LDCYL8	LD	A,(LDCYL5+1)	;P/u last cyl loaded
	LD	(VECYL5+1),A	; & save for VERIFY
;*=*=*
;	Get ready to dump to destination
;*=*=*
	LD	HL,(BUFFER$)
DUCYL	LD	D,0
;
DUCYL1
	@@CKBRKC		;Check for break
	JP	NZ,BREAK	; abort if so
;
	PUSH	HL		;Show all cyls that
	LD	H,BUF1$<-8	;Are backed up as
	LD	L,D		;In use in dest
	LD	C,(HL)
	LD	A,D
	ADD	A,60H
	LD	L,A
	LD	A,(HL)
	CPL
	AND	C
	LD	H,BUF2$<-8
	LD	C,(HL)
	OR	C
	LD	L,D
	LD	(HL),A
	CP	C
	POP	HL
	JP	Z,DUCYL6
	CALL	PMTDST
	LD	E,0
	LD	A,D
	OR	E
	PUSH	HL
	LD	A,D
	LD	HL,CYL$		;"xx...
	CALL	CVTDEC
	PUSH	DE
	@@DSPLY	DUCYL$		;"dumping cyl...
	@@DSPLY	CYL$		;"xx...
	POP	DE
	POP	HL
DUCYL2	LD	A,D		;P/u track # & bypass
	OR	A		;  if not cyl=0
	JR	NZ,DUCYL2B
;
	IF	@MOD2
	LD	A,(BACKUP0)	;get system flag
	OR	A		;system disk?
	JR	NZ,DUCYL2B	;yes, bypass!
	ENDIF
;
	OR	E		;Merge to test for sec=2
	CP	2
	JR	NZ,CKBOOT
	LD	L,0C6H		;Point to backup counter
	LD	A,(HL)
	INC	A		;If X'FF', leave as is
	JR	Z,SET0
	DEC	A		;If X'00', leave as is
	JR	Z,SET0
	LD	(HL),-1		;Set to X'FF'
	JR	SET0
CKBOOT	AND	0FEH		;  not BOOT sectors
	JR	NZ,DUCYL2B
	OR	E		;If sector 0, just
	JR	Z,DUCYL2A	;  bother with HALT
;*=*=*
;	Keep the boot track step rate
;*=*=*
	LD	A,(BOOTST$)	;P/u step pointer
	LD	L,A		;  & update buffer ptr
	LD	A,(HL)		;P/u this step byte
	AND	0FCH		;  & strip the step rate
BSMIR	OR	0		;Merge with the step
	LD	(HL),A
SET0	LD	L,0		;Reset buffer pointer
	DB	1		;Ignore next via LD BC,nn
DUCYL2A	LD	(HL),76H	;Keep the HALT in dest
DUCYL2B	LD	A,D		;P/u the cylinder #
DSTDIR	CP	0		;Is this the dir cyl?
	JR	Z,DUCYL3
	CALL	WRSEC
	JP	NZ,EXIT3
	JR	DUCYL4
DUCYL3	CALL	WRSYS
	LD	A,18
	JP	NZ,EXIT3
DUCYL4	INC	H
	INC	E
	LD	A,E
DUCYL5	CP	0		;Reach end of buffer?
	JR	NZ,DUCYL2	;Go if not
	LD	A,(LDCYL5+1)	;Count down one more
	DEC	A		; cylinder dumped
	LD	(LDCYL5+1),A
DUCYL6	INC	D		;Bump cylinder #
	LD	A,(LDCYL5+1)	;Loop if still more
	OR	A		; to dump
	JP	NZ,DUCYL1
;*=*=*
;	Prepare to verify
;*=*=*
	LD	A,(DUCYL+1)	;P/u cyl # to start
	LD	D,A
VECYL1
	@@CKBRKC
	JP	NZ,BREAK	;Abort on break
;
	LD	H,BUF1$<-8
	LD	L,D
	LD	C,(HL)
	LD	A,D
	ADD	A,60H
	LD	L,A
	LD	A,(HL)
	CPL
	AND	C
	LD	H,BUF2$<-8
	LD	C,(HL)
	OR	C
	LD	L,D
	LD	(HL),A
	CP	C
	JP	Z,VECYL6
	LD	E,0
	LD	A,D
	LD	HL,CYL$		;"xx...
	CALL	CVTDEC
	PUSH	DE
	@@DSPLY	VECYL$		;"verifying cyl...
	@@DSPLY	CYL$		;"xx...
	POP	DE
VECYL2	CALL	VERSEC		;Do all sectors
	JR	Z,VECYL3
	CP	6
	JP	NZ,EXIT3
VECYL3	INC	E
	LD	A,E
VECYL4	CP	0		;# of sectors
	JR	NZ,VECYL2
VECYL5	LD	A,0		;Count down another
	DEC	A		; cyl just verified
	LD	(VECYL5+1),A
VECYL6	INC	D		;Bump cyl # by 1
	LD	A,(VECYL5+1)	;Loop if more cylinders
	OR	A		; to verify, else go
	JP	NZ,VECYL1	; back to "loading"
	JP	LDTKS
;*=*=*
;	All cylinders backed up, move ID info
;*=*=*
MOVID	LD	C,CR
	@@DSP
	LD	HL,BUF1$+0CDH	;Move in the pswd,name,
	LD	DE,BUF2$+0CDH	;  date, "AUTO" buffer,
	LD	BC,33H		;  & config byte
	LDIR
	LD	HL,DATFLD$	;Move in today's date
	LD	DE,BUF2$+0D8H
	LD	C,8
	LDIR
;*=*=*
;	Get destination disk & write new GAT
;*=*=*
	CALL	PMTDST
	LD	A,(DSTDIR+1)	;Get dir cyl
	LD	D,A
	LD	E,0
	LD	HL,BUF2$	;Write the GAT back
	CALL	WRSYS
	LD	A,21
	JP	NZ,EXIT3
	LD	HL,BUF3$
	CALL	VERSEC
	CP	6
	LD	A,20
	JP	NZ,EXIT3
	LD	A,(DSTDIR+1)	;P/u cyl to use for dir
	LD	D,A
	LD	E,2
;*****
;	reset all mod flags on destination
;*****
RESMF	LD	HL,(BUFFER$)
	CALL	RDSEC
	CP	6
	JP	NZ,DIRERR
	INC	L
RESMF1	RES	6,(HL)
	LD	A,L
	ADD	A,20H
	LD	L,A
	JR	NC,RESMF1
	LD	L,0
	CALL	WRSYS
	LD	A,18
	JP	NZ,EXIT3
	INC	E
	LD	A,E
RESMF2	CP	0
	JR	NZ,RESMF
;
	IF	@MOD2
	LD	A,(STRDIR$+1)	;get old dir cyl
	LD	B,A		;pass for jump
	LD	A,(BACKUP0)	;get system backup flag
	OR	A		;system disk?
	JR	NZ,CNTBAK1	;yes, check if dir change
	ENDIF
;
;*=*=*
;	Clear the HALT inst from dest
;*=*=*
	LD	HL,BUF3$
	LD	D,L		;Now read the BOOT
	LD	E,L
	CALL	RDSEC
	JP	NZ,EXIT3
	LD	(HL),0		;Clear the HALT
	INC	HL
	INC	HL		;Pt to old DIR cyl
STRDIR$	LD	B,$-$		;P/u the old DIR cyl
	LD	A,(DSTDIR+1)	;Update the dir cyl
	LD	(HL),A		;  in case it changed
	DEC	HL		;Pt back to buffer start
	DEC	HL
	CALL	WRSEC		;Write back the BOOT
	CALL	Z,VERSEC
	JP	NZ,EXIT3	;Go if write error
	INC	E		;Point to sector 1
	CALL	RDSEC		;Read it
	JP	NZ,EXIT3
	LD	A,(DSTDIR+1)	;Do the same thing again
	INC	HL
	INC	HL
	LD	(HL),A
	DEC	HL
	DEC	HL
	CALL	WRSEC		;Write it back
	CALL	Z,VERSEC	;Verify it if written OK
	JP	NZ,EXIT3	;Quit if we couldn't
;
CNTBAK1	LD	H,BUF2$<-8	;Destination GAT
	LD	A,B		;P/u old DIR cyl
	ADD	A,60H		;Point to lockout table
	LD	L,A
	LD	C,(HL)		;Check lockout byte
	LD	L,B		;Pt to GAT byte
	LD	A,(HL)		;Get GAT byte
	OR	C
	CP	C		;Anything allocated?
	JR	NZ,RESMF2B	;Bypass if yes
	LD	A,B		;Save cylinder
	LD	HL,BUF3$	;Write E5's to cylinder
	LD	DE,BUF3$+1	; to remove system DAM
	LD	BC,255
	LD	(HL),0E5H
	LDIR
	LD	L,C		;Pt back to buf3$
	LD	D,A		;Set cylinder # in D
	LD	E,C		;Start with sector 0
	LD	A,(LDCYL4+1)	;Get # of sectors
	LD	B,A		;Set loop counter
RESMF2A	CALL	WRSEC		;Write normal sector
	JP	NZ,EXIT3
	INC	E		;Step to next sector
	DJNZ	RESMF2A
RESMF2B	CALL	RESTOR		;Restore to track 0
;*=*=*
;	Attempt to clear MOD flags of source
;*=*=*
	CALL	PMTSRC		;Prompt source
	LD	D,(IY+9)
;
	LD	E,2
RESMF3	LD	HL,(BUFFER$)	;P/u buffer addr
	CALL	RDSEC		;Read source dirs
	CP	6
	JP	NZ,DIRERR
	INC	L
RESMF4	RES	6,(HL)		;Turn off mod flag
	LD	A,L
	ADD	A,20H
	LD	L,A
	JR	NC,RESMF4
	LD	L,0
	CALL	WRSYS
	JR	Z,RESMF5
	CP	15		;Write protected source?
	LD	A,18
	JP	NZ,EXIT3	;Exit if some other err
	@@LOGOT	CCMOD$		;"Can't clear mod flags
	IF	@MOD4
	JP	EXIT1
	ENDIF
	IF	@MOD2
	JR	CKWRTK0		;check if write cyl 0
	ENDIF
RESMF5	INC	E
	LD	A,E
RESMF6	CP	0
	JR	NZ,RESMF3
	IF	@MOD4
	JP	EXIT1
	ENDIF
	IF	@MOD2
CKWRTK0	LD	A,(BACKUP0)	;get flag
	OR	A		;anything?
	JP	Z,EXIT1		;nope, go!
	CALL	PMTSRC		;prompt for source
	CALL	READ0		;read cyl 0
	JP	NZ,EXIT3	;go on error
	CALL	PMTDST		;prompt for dest drive
	CALL	FORMAT0		;format cylinder 0
	JP	NZ,EXIT3	;go on disk error
;
;	pass original step rate to new disk
;
	LD	HL,(BUFFER$)	;get I/O buffer
	INC	HL		;bump to step rate
	INC	HL
	INC	HL		;+3
	LD	A,(BSMIR+1)	;get step
	LD	(HL),A		;pass to buffer
	LD	BC,80H		;offset to sector 1
	ADD	HL,BC		;point to it
	LD	(HL),A		;pass to buffer
	CALL	PMTDST		;re-fetch DCT
	CALL	WRITE0		;write cylinder 0
	JP	NZ,EXIT3	;go on disk error
	CALL	PMTDST		;fetch DCT
	LD	A,(DSTDIR+1)	;get new dir cyl
	LD	(IY+9),A	;update DCT
	CALL	UPGAT0		;update GAT table
	JP	NZ,EXIT3	;go on disk error
	JP	EXIT1		;else program completed!
	ENDIF
;*=*=*
;	Routine to convert cylinder # & message stuff
;*=*=*
CVTDEC	LD	(HL),' '	;Init to blank
	LD	B,100
	CALL	CVD1
	LD	(HL),' '	;Init to blank
	LD	B,10
	CALL	CVD1
	LD	(HL),'0'
	LD	B,1
CVD1	LD	C,0
CVD2	SUB	B
	JR	C,CVD3
	INC	C
	JR	CVD2
CVD3	ADD	A,B
	PUSH	AF
	LD	A,C
	OR	A
	JR	Z,CVD7
	ADD	A,30H
	LD	(HL),A
CVD7	POP	AF
	INC	HL
	RET
;*=*=*
;	Message area
;*=*=*
NOTMIR	LD	HL,NOTMIR$
	JP	EXIT4
LDCYL$	DB	29,'Reading < cylinder ',3
DUCYL$	DB	29,'Writing > cylinder ',3
VECYL$	DB	29,'Verifying cylinder ',3
CYL$	DB	'000',3
NOTMIR$	DB	LF,'Backup aborted, '
	DB	'destination not mirror-image',CR
DIFID$	DB	'Destination disk ID is different: '
PACKID$	DB	'Name=XXXXXXXX  Date=mm/dd/yy',CR
OLDMPW$	DB	'  Enter its Master Password'
	DB	' or <BREAK> to abort: ',3
PMTYN$	DB	'Are you sure you want to backup to it '
	DB	'<Y,N> ? ',3
