KLEER.ASM by Nate Salsbury   April 24, 1987
When assembled to CLS.EXE, this can eventually be merged into your GW BASIC
program to clear the screen from the current cursor position to the end of
screen.  It is equvalent to the old Model I, III or 4 BASIC  PRINT CHR$(31).
The instruction for merging with your GWBASIC file will be found after the
end of the KLEER.ASM text.
;**************************************************************************
.;
.;Short program to CLS from cursor position to the 
.;EOS (end of screen).  Equivalent to PRINT CHR$(31) in
.;Model 4 BASIC.
.;**********************************************************
.cls	segment
.;----------------------------------------------------------
.main	proc	far
.	assume	cs:cls
.;First, get current cursor posn
.	mov	bh,0		;Set page # = 0
.	mov	ah,3		;SVC request to get cursor posn
.	int	10h		;Video interrupt
.;
.;On return, cursor row is in dh and cursor col is in dl
.;We want to multiply the row number by 80 
.;
.	mov	al,dh		;Row # into al
.	mov	cl,80		;Number chars/row
.	mul	cl		;# rows * 80 into ax
	mov	dh,0		;[dx] = cursor col # in dl
.	add	ax,dx		;[ax] = char posn of cursor on screen
.	mov	cx,2000		;Total # chars on text screen
.	sub	cx,ax		;Calc # chars left to blank out
.;
.;Now, blank out from cursor posn to end of screen with SVC 9
.	mov	al,20h  	;Char to write is a blank
.	mov	bl,7		;Attribute of character written	
.	mov	ah,9		;SVC request #
.	int	10h		;Do it
.;
.	ret			;To BASIC 
.main	endp
.;-------------------------------------------------------------
.;
.cls	ends
.;**************************************************************
.	end	main
.
.;**************************************************************
The following description is taken from "Assembly Language Primer for the
IBM PC & XT" by Robert LaFore of The Waite Group.
 
.1.  Assemble the file in usual manner =>        asm kleer
.2.  Link (using the DOS LINK) with the HIGH switch =>   link kleer/high
     You have now produced KLEER.EXE. Use DEBUG to load and examine KLEER.EXE
.3.  debug kleer.exe.  When program has loaded, at the  -  prompt, press R
.4.  Note and record the values for the CS register and the IP register.
     The CS value will be the Segment Address while the IP is the Offset.
     Use the DEBUG -d (Display) function to examine the program in memory and
     determine its length.  Make a note of the length.
.5.  Now, load BASIC also while still in DEBUG =>     -n basica.com
.6.  Follow this with  =>      -l    to actually load BASIC
.7.  Execute BASIC by  =>     -g  If all goes well, you will get BASIC's  ok
     prompt
.8.  In BASIC's command mode, type   DEF SEG = &h(put here what you found in
     the CS register in step 4.)
.9   Then, still in the command mode =>  BSAVE "filename.bin",IP,&h(Length)
     The IP entry is the value noted from step 4 (will probably be 0 but, if
     not, specify as &h(IP).  Similarly, insert the program length at the
     end (this tells BSAVE how many bytes to save.)
.10. Note that the () used around IP and Length, in 9 above are NOT typed into
     your commands.
 
You now have a disk file (mine was CLS.BIN) which can be included into any GW
BASIC program.  Early in the program include  DEF SEG = &H (the same address 
originally found in the CS register, step 4). 
 
This would be followed by BLOAD "filename.bin",IP (IP is the same value 
as noted in step 9 ....  probably will be zero).  Then state DEF USR0 = &h(IP)
(that is the same, old IP content we have used all along.... probably 0) and
then return to BASIC's segment with DEF SEG.
 
Now, make a subroutine => 50000 DEF SEG = &H (CS content): X = USR(0): DEF SEG
:RETURN   and GOSUB 50000 whenever you want to clear from your present cursor 
position to the end of screen.
 
