;		m4file/asm
;
;	The close command.  At present, only SESSION is valid
;
CLSFLS	CALL	GETLOGF		;Get the logfile descriptor
	IFNZ	CLSF10		;Skip if not SESSION LOG FILE
	LD	A,(LOGFLG)	;Check to see if session log open
	IFZ	CLSF07		;If already closed, then jump to message
	XOR	A		;Reset the FILE OPEN flag
	LD	(LOGFLG),A
	LD	DE,LFCB		;Get the FCB for the CLOSE
	CALL	XCLOSE		;Close the file if possible
	CALL	NZ,XERROR0	;Print a message if file not closed right
	JR	CLSF08		;Back for another command
CLSF07	STROUT	NOLOGF		;Print LOG FILE NOT OPEN message
CLSF08	JP	KERMIT		;Back for another command
;
;	Check the debug logfile
;
CLSF10	IFANOT	1,CLSF30	;If not debug then try transaction
	LD	A,(DEBLOG)	;Check if logging in effect
	IFZ	CLSF07
	XOR	A		;Zap the open flag
	LD	(DEBLOG),A
	LD	DE,DFCB		;Get the FCB
	CALL	XCLOSE
	CALL	NZ,XERROR0
	JR	CLSF08
;
;	Check the transaction logfile
;
CLSF30	LD	A,(TRANLOG)	;Check if it is open
	IFZ	CLSF07
	XOR	A		;Zap the open flag
	LD	(TRANLOG),A	;Reset it
	LD	DE,TRFCB		;Get the transaction FCB
	CALL	XCLOSE		;Close the file
	CALL	NZ,XERROR0	;Print system message if error
	JR	CLSF08		;Back for another command
;
;	THIS IS THE LOG COMMAND.
;
LOG	EQU	$
	CALL	GETLOGF		;Get the logfile descriptor
	OR	A
	JP	Z,LOGSES	;If zero then session logging
	CP	2
	JP	Z,LOGTRAN	;Go do transaction logging
;
;	Debug logging
;
	LD	A,(DEBLOG)	;See if logging already in effect
	IFZ	LOG_3
LOG_1	STROUT	LOGOPN		;Print LOG OPEN message
	JP	KERMIT		;RETURN TO COMMAND PARSER
LOG_3	LD	DE,DFCB
	PUSH	DE		;Save it for later
	LD	A,CMIFI		;Get a file spec
	CALL	COMND		;Parse it
	JP	KERMT3		;Exit if not confirmed
	IFNZ	LOG_3A
	LD	HL,DEFDEBLOG	;Get the default name
	LD	DE,DFCB
	LD	BC,32
	LDIR			;Move it into place
LOG_3A	POP	DE		;Get the FCB back
	LD	HL,DBUFF	;Get the buffer
	LD	B,0		;Use 256 LRL
	CALL	XINIT		;Create the output file
	JR	Z,LOG_5
	IFA	42,LOG_5	;Ignore a LRL error
LOG_4	CALL	XERROR0
	JP	KERMIT
LOG_5	LD	A,1
	LD	(DEBLOG),A	;Set the log file open flag
	JP	KERMIT
;
;	Session logging
;
LOGSES	LD	A,(LOGFLG)	;Check if session log open
	IFZ	LOG_6
	JP	LOG_1		;Oops, log already open
LOG_6	LD	A,CMIFI		;PARSE AN INPUT FILE SPEC.
	LD	DE,LFCB		;Get the session log FCB
	PUSH	DE		;Save it for later
	CALL	COMND		;Parse it
	JP	KERMT3
	IFNZ	LOG_6A		;Jump if text was given
	LD	HL,DEFSESLOG	;Get the default name
	LD	DE,LFCB		;Get the FCB
	LD	BC,32		;Get the count
	LDIR			;Move the block
LOG_6A	LD	HL,LBUFF	;Get the buffer
	POP	DE		;Get the session log FCB
	LD	B,0		;Select 256 byte records
	CALL	XINIT		;Create a new file
	JR	Z,LOG_8		;Continue on a no error return
	IFANOT	42,LOG_4	;If not LRL error, then abort
LOG_8	XOR	A
	LD	(PREVLCHR),A	;Reset the previous character
	LD	A,2
	LD	(LOGFLG),A	;Turn logging on
	JP	KERMIT		;Jump to get a new command
;
;	Transaction logging
;
LOGTRAN	LD	A,(TRANLOG)	;Get the flag
	IFZ	LOG_9
	JP	LOG_1		;Oops log already open
LOG_9	LD	A,CMIFI		;Get a file spec
	LD	DE,TRFCB
	PUSH	DE		;Save it for later
	CALL	COMND		;Parse a file name
	JP	KERMT3		;Abort if no confirm
	IFNZ	LOG_9A		;Jump if text given
	LD	HL,DEFTRLOG	;Get the default
	LD	DE,TRFCB
	LD	BC,32
	LDIR			;Move it
LOG_9A	POP	DE
	LD	HL,TBUFF	;Get the buffer
	LD	B,0		;Select 256 LRL
	CALL	XINIT		;Create the output file
	JR	Z,LOG_10
	IFANOT	42,LOG_4
LOG_10	LD	A,1		;Set the flag to ON
	LD	(TRANLOG),A
	JP	KERMIT		;Back for another command
;
;	Get a logfile identifier
;
GETLOGF	LD	A,CMKEY		;PARSE A KEYWORD
	LD	DE,CLSTAB	;GET THE PARSE TABLE
	CALL	COMND		;GET A KEYWORD
	JP	KERMT2		;ABORT ON AN ERROR
	RET			;Return to caller
;
;	Output a normal string terminated by EOS.
;
OUTLOG	LD	A,EOS
	JP	OUTLOGCH
;
;	Output a message to a log file
;	HL=message, DE=FCB, A=terminator character
;
OUTLOGCH	EQU	$
	PUSH	HL		;Save the registers
	PUSH	DE
	LD	(ENDCH),A	;Store the terminator
OUTL_1	LD	A,(HL)		;Get a character
	CP	EOS
ENDCH	EQU	$-1		;Address of terminator character
	JR	Z,OUTL_2
	PUSH	HL		;Save the string address, and the FCB
	PUSH	DE
	CALL	XPUT		;@PUT the character
	POP	DE		;Restore the addresses
	POP	HL
	JR	NZ,OUTL_3	;On error, abort
	INC	HL		;Point to next character
	JR	OUTL_1		;Loop on
OUTL_2	POP	DE		;Restore stack
	POP	HL
	JP	RSKP		;Return normal
;
;	Log file error
;
OUTL_3	CALL	XERROR0		;Print system message
	STROUT	LOGERROR	;Print a message on the console
	POP	DE		;Restore the stack
	POP	HL
	RET			;Return error
;end of file
