;	M4CMD/ASM
;
;JUMPING TO THIS LOCATION IS LIKE RETSKP.  IT ASSUMES THE INSTRUCTION
;AFTER THE CALL IS A JMP ADDR.
;
RSKP	POP	HL		;GET THE RETURN ADDRESS.
	INC	HL		;INCREMENT BY THREE.
	INC	HL
	INC	HL
	JP	(HL)  
;
;THIS ROUTINE PRINTS THE NUMBER IN HL ON THE SCREEN IN DECIMAL.
;
NOUT	EQU	$
	PUSH	HL		;Save the value to print
	EXX			;Cheap push everything (kinda anyway)
	POP	HL		;Get it back
	LD	DE,NBUFF	;WHERE TO PUT THE NUMBER
	CALL	XHEXDEC		;Convert from binary to ASCII
	EX	DE,HL		;HL = BUFFER+1
	LD	(HL),EOS	;TERMINATOR FOR PRINT ROUTINE
	LD	HL,NBUFF	;RESTORE ADDRESS OF BUFFER
	LD	A,' '
NOUT1	IFANOT	(HL),NOUT2	;Go if not blank
	INC	HL		;POINT AT NEXT CHARACTER
	JR	NOUT1		;LOOP ON
NOUT2	EX	DE,HL		;DE IS THE ADDRESS NOW FOR PRINTING
	CALL	PRTSTR		;PRINT THE NUMBER
	EXX			;RESTORE THE ACS.
	RET
;
;
;THIS SET OF ROUTINES PROVIDES A USER ORIENTED WAY OF PARSING
;COMMANDS.  IT IS SIMILAR TO THAT OF THE COMND JSYS IN TOPS-20.
;THIS ROUTINE PRINTS THE PROMPT IN DE AND SPECIFIES THE REPARSE
;ADDRESS
;
PROMPT	POP	HL		;GET THE RETURN ADDRESS.
	PUSH	HL		;PUT IT ON THE STACK AGAIN.
	LD	(CMRPRS),HL	;SAVE IT AS THE ADDRESS TO GO TO ON REPARSE.
	LD	(CMOSTP),SP	;SAVE FOR LATER RESTORAL.
	LD	(CMPRMP),DE	;SAVE THE PROMPT LOCATION
	LD	HL,CMDBUF
	LD	(CMCPTR),HL	;INITIALIZE THE COMMAND POINTER.
	LD	(CMDPTR),HL
	XOR	A
	LD	(CMAFLG),A	;ZERO THE FLAGS.
	LD	(CMCCNT),A
	LD	A,0FFH		;TRY IT THIS WAY (DAPHNE.)
	LD	(CMSFLG),A
	LD	A,(TAKFLG)	;CHECK IF TAKE ACTIVE
	IFZ	PRMT10
	LD	A,(TAKLOG)	;IS TAKE DISPLAY ACTIVE?
	IFZ	PRMT20
PRMT10	CALL	NEWLIN
	LD	DE,(CMPRMP)	;PRINT THE PROMPT.
	CALL	PRTSTR
PRMT20	RET
;
;THIS ADDRESS IS JUMPED TO ON REPARSE.
;
REPARS	LD	SP,(CMOSTP)	;GET THE OLD STACK POINTER.
	LD	HL,CMDBUF
	LD	(CMDPTR),HL
	LD	A,0FFH		;TRY IT THIS WAY (DAPHNE.)
	LD	(CMSFLG),A
	LD	HL,(CMRPRS)	;GET THE REPARSE ADDRESS.
	JP	(HL)		;GO THERE.
;
;THIS ADDRESS CAN BE JUMPED TO ON A PARSING ERROR.
;
PRSERR	LD	SP,(CMOSTP)	;GET THE OLD STACK POINTER.
	LD	HL,CMDBUF
	LD	(CMCPTR),HL	;INITIALIZE THE COMMAND POINTER.
	LD	(CMDPTR),HL
	CALL	NEWLIN
	XOR	A
	LD	(CMAFLG),A	;ZERO THE FLAGS.
	LD	(CMCCNT),A
	LD	A,0FFH		;TRY IT THIS WAY (DAPHNE.)
	LD	(CMSFLG),A
	LD	DE,(CMPRMP)	;GET THE PROMPT.
	CALL	PRTSTR
;* INSTEAD RETURN TO BEFORE THE PROMPT CALL.
	LD	HL,(CMRPRS)
	JP	(HL)  
;THIS ROUTINE PARSES THE SPECIFIED FUNCTION IN A.  ANY ADDITIONAL
;INFORMATION IS IN DE AND HL.
;RETURNS +4 ON SUCCESS
;+1 ON FAILURE (ASSUMES A JMP FOLLOWS THE CALL)
COMND	LD	(CMSTAT),A	;SAVE WHAT WE ARE PRESENTLY PARSING.
	CALL	CMINBF		;GET CHARS UNTIL AN ACTION OR A ERASE CHAR.
	CP	CMNUM		;IS IT A DECIMAL NUMBER?
	JP	Z,CMDNUM	;GO GET ONE
	CP	CMCFM		;PARSE A CONFIRM?
	JP	Z,CMCFRM		;GO GET ONE.
	CP	CMKEY		;PARSE A KEYWORD?
	JP	Z,CMKEYW		;TRY AND GET ONE.
	CP	CMIFI		;PARSE AN INPUT FILE SPEC?
	JP	Z,CMIFIL		;GO GET ONE.
	CP	CMIFIN		;INPUT FILE-SPEC SILENT?
	JP	Z,CMIFIL		;DO AS HE WISHES
	CP	CMOFI		;OUTPUT FILE SPEC?
	JP	Z,CMIFIL		;GO GET ONE.
	CP	CMTXT		;PARSE ARBITRARY TEXT?
	JP	Z,CMTEXT		;GO DO IT.
	LD	DE,CMER00	;"?UNRECOGNIZED COMND CALL"
	CALL	PRTSTR
	RET
;THIS ROUTINE PARSES ARBITRARY TEXT UP TO A CR.
;ACCEPTS DE	ADDRESS TO PUT TEXT
;RETURNS IN A	NUMBER OF CHARS IN TEXT (MAY BE 0)
;DE	UPDATED POINTER
CMTEXT	EX	DE,HL  		;PUT THE POINTER TO THE DEST IN HL.
	LD	(CMPTAB),HL	;SAVE THE POINTER.
	LD	B,0		;INIT THE CHAR COUNT
CMTXT1	CALL	CMGTCH		;GET A CHAR.
	OR	A		;TERMINATOR?
	JP	P,CMTXT5		;NO, PUT IN USER SPACE.
	AND	7FH		;TURN OFF MINUS BIT.
	CP	ESC		;AN ESCAPE?
	RET	Z
CMTXT2	IFA	'?',CMTXT7	;Jump if the user needs help
	IFA	' ',CMTXT5	;If blank, add it to text
	LD	A,B		;RETURN THE COUNT.
	LD	HL,(CMPTAB)	;RETURN UPDATED POINTER IN HL.
	LD	(HL),CR		;PUT IN THE TERMINATOR
	EX	DE,HL	
	JP	RSKP		;RETURN SUCCESS.
CMTXT3	LD	HL,CMAFLG	;POINT TO THE ACTION FLAG.
	LD	(HL),0		;SET IT TO ZERO.
CMTXT5	INC	B		;INCREMENT THE COUNT.
CMTXT6	LD	HL,(CMPTAB)	;GET THE POINTER.
	PUTHL	A		;Add the character and increment
	LD	(CMPTAB),HL	;SAVE THE UPDATED POINTER.
	JR	CMTXT1		;GET ANOTHER CHAR.
CMTXT7	LD	DE,TXTHLP	;HELP MESSAGE INTO DE
	CALL	REPRNT		;PRINT THE MESSAGE AND THE PROMPT
	JP	REPARS		;GET SOMEMORE INPUT
;THIS ROUTINE PARSES AN INPUT NUMBER IN ASCII DECIMAL
CMDNUM	LD	B,0		;NO CHARACTERS YET
	LD	HL,0		;SET VALUE TO ZERO FIRST
	LD	(THEVAL),HL
CMNM10	CALL	CMGTCH		;GET A CHARCTER
	OR	A		;IS IT A TERMINATOR?
	JP	P,CMNM50	;GO IF NOT
	AND	7FH		;MAKE IT NORMAL
	CP	ESC		;IS IT ABORT?
	RET	Z		;TAKE THE ERROR EXIT
CMNM20	IFA	'?',CMNM70	;Go if the user needs help
	LD	A,B		;GET COUNT OF CHARACTERS
	LD	DE,(THEVAL)	;GET THE NUMBER FOUND
	JP	RSKP		;RETURN WITH VALUE IN DE
CMNM50	INC	B
	PUSH	HL		;SAVE HL FOR THE MULTIPLY
	PUSH	DE
	PUSH	BC
	LD	HL,(THEVAL)	;GET THE CURRENT NUMBER
	LD	C,10		;TIMES 10
	PUSH	AF
	CALL	XMUL16		;Multiply 8 bit by 16 bit
	LD	H,L		;SHIFT ALL INTO HL
	LD	L,A		;GET LSB IN L
	POP	AF		;RESTORE WHAT TO ADD
	SUB	48		;CHECK FOR A NUMBER
	JP	P,CMNM60	;OK SO FAR
CMNM55	POP	BC		;RESTORE THE REGS
	POP	DE
	POP	HL
	LD	DE,ERMES2	;SAY BAD CHARACTER
	CALL	PRTSTR
	JP	KERMIT		;GET A NEW COMMAND
CMNM60	IFAGE	10,CMNM55	;Jump if too big
	LD	C,A		;GET IT INTO BC FOR 16 BIT MATH
	LD	B,0		;ZERO MSB
	ADD	HL,BC		;COMPUTE THE NEW NUMBER
	LD	(THEVAL),HL
	POP	BC
	POP	DE
	POP	HL
	JR	CMNM10
CMNM70	LD	DE,NUMHLP
	CALL	REPRNT		;PRINT THE PROMPT AND REPARSE
	JP	REPARS
;THIS ROUTINE GETS A CONFIRM.
CMCFRM	CALL	CMGTCH		;GET A CHARACTER FROM THE BUFFER
	OR	A		;WHAT WAS IT, CONTROL?
	RET	P		;NOPE, SO EXIT VIA ERROR RETURN
	AND	7FH		;STRIP THE SIGN BIT FLAG
	IFANOT	'?',CMCFR3	;Go if not help request
	LD	DE,CMIN00	;TELL THEM NO MORE HELP
	CALL	REPRNT		;PRINT THE MESSAGE
	JP	REPARS		;PRINT THE MESSAGE AND THE PROMPT AGAIN
CMCFR3	CP	ESC		;IS IT ABORT?
	RET	Z		;TAKE ERROR EXIT IF SO
	JP	RSKP		;TAKE NORMAL RETURN
;THIS ROUTINE PRINTS THE MESSAGE IN DE AND SETS UP FOR A REPARSE
REPRNT	CALL	PRTSTR
	XOR	A
	LD	(CMAFLG),A
	CALL	NEWLIN
	LD	DE,(CMPRMP)
	CALL	PRTSTR
	LD	HL,(CMCPTR)
	DEC	HL
	LD	(HL),EOS
	LD	(CMCPTR),HL
	LD	DE,CMDBUF
	CALL	PRTSTR
	RET
;THIS ROUTINE PARSES A KEYWORD FROM THE TABLE POINTED
;TO IN DE.  THE FORMAT OF THE TABLE IS AS FOLLOWS
;
;ADDR	DB	N	Where N is the number of entries in the table
;	DB	K	Where K is 2+length of longest keyword.
;	Repeated for each entry in the table...
;	DB	M		Where M is the length of the keyword
;	DB	'STRING',EOS	Where string is the KEYWORD.
;	DB	A,B       	Where A & B are pieces of DATA
;				to be returned, (Must be two bytes worth)
;
;THE KEYWORDS MUST BE IN ALPHABETICAL ORDER.
;**** NOTE  THE DATA VALUE A IS RETURNED IN REGISTERS A AND E.  THE
;****	DATA VALUE B IS RETURNED IN REGISTER D.  THIS ALLOWS THE TWO DATA
;BYTES TO BE STORED AS
;DW	XXX
;AND RESULT IN A CORRECTLY FORMATTED 16-BIT VALUE IN REGISTER PAIR
;DE.
CMKEYW	LD	(CMPTAB),DE	;SAVE THE BEGINNING OF KEYWORD for ?
	LD	A,(DE)		;GET THE NUMBER OF ENTRIES IN THE TABLE.
	LD	B,A		;SAVE IN B
	INC	DE
	INC	DE		;POINT PAST THE MAX LENGTH NUMBER
	LD	(CMKPTR),DE
	LD	HL,(CMDPTR)	;SAVE THE COMMAND POINTER.
	LD	(CMSPTR),HL
CMKEY2	LD	A,B
	OR	A		;ANY LEFT?
	RET	Z		;IF NOT WE FAILED.
	LD	HL,(CMKPTR)
	LD	E,(HL)		;GET THE LENGTH OF THE KEYWORD.
	INC	HL
CMKEY3	DEC	E		;DECREMENT THE NUMBER OF CHARS LEFT.
	LD	A,E
	CP	-1		;HAVE WE PASSED THE END?
	JP	M,CMKEY5	;IF SO GO TO THE NEXT.
	CALL	CMGTCH		;GET A CHAR.
	OR	A		;IS IT A TERMINATER?
	JP	P,CMKEY4	;IF POSITIVE, IT IS NOT.
	AND	7FH		;TURN OFF THE MINUS BIT.
	CP	'?'		;Is this help?
	JP	NZ,CMKY35
	PUSH	HL		;SAVE HL FOR A SEC
	PUSH	DE
	XOR	A
	LD	(CMAFLG),A	;TURN OFF THE ACTION FLAG.
	LD	DE,HLPMES	;PRINT ONE OF THE FOLLOWING...
	CALL	PRTSTR
	LD	HL,CMCCNT	;DECREMENT THE CHAR COUNT.
	DEC	(HL)
	POP	DE
	POP	HL
	LD	HL,(CMPTAB)	;GET THE START OF THE KEYWORD TABLE
	LD	B,(HL)		;B IS HOW MANY IN THE TABLE
	INC	HL		;POINT AT THE FIRST ENTRY
	LD	A,(HL)		;GET THE COLUMN SPACING VALUE
	LD	(MAXLEN),A	;SAVE IT FOR LATER
	XOR	A
	LD	(CURCOL),A	;Set column to starting column
	INC	HL		;POINT AT THE FIRST ENTRY
CM1010	LD	C,(HL)		;C IS HOW MANY CHARACTERS IN NAME
	LD	A,C		;SAVE THE LENGTH FOR LATER
	LD	(CURLEN),A
	INC	HL		;POINT AT THE TEXT FOLLOWING
	LD	(CMKPTR),HL	;SAVE THE ADDRESS TO PRINT FROM ON MATCH
	LD	DE,(CMSPTR)	;GET THE ADDRESS OF THE TYPED KEYWORD
CM1020	LD	A,(DE)		;GET A CHARACTER
	IFA	'?',CM1040	;Go if request for help
	CALL	CAPTAL		;MAKE SURE LETTERS ARE UPPER CASE
	INC	DE		;POINT TO THE NEXT.
	CP	(HL)		;SAME AS IN KEYWORD TABLE?
	INC	HL		;POINT TO THE NEXT
	JR	NZ,CM1050	;JUMP IF NO MATCH
	DEC	C		;ONE LESS CHARACTER IN THE KEYWORD
	JP	P,CM1020
	LD	A,(DE)
	IFA	'?',CM1040	;Jump if help request
	CP	0		;Set flags to P,NZ
	JP	CM1050		;Join other code
CM1040	PUSH	DE		;SAVE THE REGS
	PUSH	HL
	PUSH	BC
	LD	DE,(CMKPTR)	;Get the string
	CALL	STRLEN		;Get length into BC
	LD	A,(MAXLEN)	;Get the padded length
	LD	B,A		;Save it for now
	LD	A,(CURCOL)	;Get current screen column
	ADD	A,B		;Compute new column
	LD	B,A		;Save it
	LD	A,(MAXCOL)	;Get right margin
	IFALT	B,CM1041	;Are we passed the edge? Jump if so
	LD	A,B		;Get new column
	LD	(CURCOL),A	;Save it
	LD	A,(MAXLEN)
	JR	CM1042		;Join code
CM1041	CALL	NEWLIN		;Print a newline
	LD	A,(MAXLEN)	;Get the padded length
	LD	(CURCOL),A	;Set new position
CM1042	SUB	C		;Compute blanks to print
	LD	C,A		;Put it into C
	PUSH	BC		;Save count for now
	LD	DE,(CMKPTR)	;Get the string to print
	CALL	PRTSTR		;Print the keyword
	POP	BC		;Restore count
CM1043	LD	A,' '		;Get a blank
	CALL	CONOUT		;Display it
	DEC	C		;Decrement counter
	JR	NZ,CM1043	;Jump if not there
	POP	BC		;RESTORE THE REGS
	POP	HL
	POP	DE
CM1045	LD	A,3		;SKIP OVER THE EOS AND THE DISCRIPTOR
	ADD	A,C		;PLUS THE CHARACTERS LEFT IN THE STRING
	LD	E,A		;PUT IT IN DE TO ADD
	LD	D,0		;MAKE IT A BYTE VALUE IN 16 BITS
	ADD	HL,DE		;GOT THE NEW ADDRESS
	DJNZ	CM1010		;GET THE NEXT
	JR	CM1190		;END OF THE TABLE
CM1050	DEC	HL		;CORRECT HL FROM LAST INCREMENT
	JP	P,CM1045	;IF (TABLE) > (COMMAND) KEEP LOOKING
	JR	Z,CM1045
	XOR	A		;RESET THE ACTION FLAG
	LD	(CMAFLG),A
CM1190	CALL	NEWLIN		;PRINT A NEW LINE
CM1200	CALL	NEWLIN		;PRINT A NEW LINE
	LD	DE,(CMPRMP)	;GET THE PROMPT TO REPRINT
	CALL	PRTSTR		;PRINT IT
	LD	HL,(CMDPTR)	;GET THE END OF THE COMMAND LINE
	LD	(HL),EOS	;TERMINATOR FOR PRINTING
	LD	HL,(CMCPTR)	;GET THE LAST CHARACTER
	DEC	HL
	LD	(CMCPTR),HL	;IGNORE THE '?' AT THE END
	LD	DE,CMDBUF	;GET THE START OF THE BUFFER
	CALL	PRTSTR		;PRINT THE COMMAND LINE
	JP	REPARS		;REPARSE THE ENTIRE LINE
CMKY35	CP	ESC
	RET	Z
	PUSH	HL
	PUSH	DE
	CALL	CMAMBG
	JP	CMKY36
	LD	HL,(CMCPTR)	;GET THE END OF THE COMMAND
	LD	BC,CMDBUF	;GET THE START OF THE BUFFER
	OR	A		;RESET THE CARRY
	SBC	HL,BC		;COMPUTE THE OFFSET
	LD	DE,CMER01
	CALL	PRTSTR		;SAY ITS AMBIGUOUS.
	JP	PRSERR		;GIVE UP.
CMKY36	POP	DE
	POP	HL
CMKY37	INC	E		;ADD ONE IN CASE IT IS NEGATIVE.
	LD	D,0
	ADD	HL,DE		;INCREMENT PAST THE KEYWORD.
	INC	HL		;PAST THE EOS.
	LD	E,(HL)		;GET THE DATA.
	INC	HL
	LD	D,(HL)
	LD	A,E
	JP	RSKP
CMKEY4	CALL	CAPTAL		;MAKE IT UPPER CASE IF LOWER	
CMKY41	LD	D,(HL)		;GET THE NEXT CHAR OF THE KEYWORD.
	INC	HL
	CP	D
	JP	Z,CMKEY3
CMKEY5	LD	D,0
	LD	A,E		;GET THE NUMBER OF CHARS LEFT.
	OR	A		;IS IT NEGATIVE?
	JP	P,CMKY51
	LD	D,0FFH		;IF SO, SIGN EXTEND.
CMKY51	ADD	HL,DE		;INCREMENT PAST THE KEYWORD.
	INC	HL		;PLUS 3
	INC	HL
	INC	HL
	LD	(CMKPTR),HL
	DEC	B		;DECREMENT THE NUMBER OF ENTRIES LEFT.
	LD	HL,(CMSPTR)	;GET THE OLD CMDPTR.
	LD	(CMDPTR),HL	;RESTORE IT.
	JP	CMKEY2		;GO CHECK THE NEXT KEYWORD.
;CONVERT CONTENTS OF A TO UPPER CASE IF IT IS LOWER
CAPTAL	IFALT	'a',CAPS10
	IFAGE	'z'+1,CAPS10
	AND	137O		;MAKE IT UPPER CASE
CAPS10	RET			;RETURN TO THE CALLER
;CHECK AMBIGUITY OF A COMMAND
CMAMBG	DEC	B		;DECREMENT THE NUMBER OF ENTRIES LEFT.
	RET	M			;IF NONE LEFT THEN IT IS NOT AMBIGUOUS.
	INC	E		;THIS IS OFF BY ONE;ADJUST.
	LD	C,E		;SAVE THE CHAR COUNT.
	LD	A,E
	OR	A		;ANY CHARS LEFT?
	RET	Z			;NO, IT CAN'T BE AMBIGUOUS.
	LD	D,0
	ADD	HL,DE		;INCREMENT PAST THE KEYWORD.
	LD	E,3		;PLUS THE EOS AND DATA.
	ADD	HL,DE
	LD	B,(HL)		;GET THE LENGTH OF THE KEYWORD.
	INC	HL
	EX	DE,HL	
	LD	HL,(CMKPTR)	;GET POINTER TO KEYWORD ENTRY.
	LD	A,(HL)		;GET THE LENGTH OF THE KEYWORD.
	SUB	C		;SUBTRACT HOW MANY LEFT.
	LD	C,A		;SAVE THE COUNT.
	IFA	B,CMAMB0
	RET	P		;IF LARGER THAN THE NEW WORD THEN NOT AMB
CMAMB0	LD	HL,(CMSPTR)	;GET THE POINTER TO WHAT PARSED.
CMAMB1	DEC	C		;DECREMENT THE COUNT.
	JP	M,RSKP		;IF WE ARE DONE THEN IT IS AMBIGUOUS.
	EX	DE,HL		;EXCHANGE THE POINTERS.
	LD	B,(HL)		;GET THE NEXT CHAR OF THE KEYWORD
	INC	HL
	EX	DE,HL		;EXCHANGE THE POINTERS.
	LD	A,(HL)		;GET THE NEXT PARSED CHAR.
	INC	HL
	CALL	CAPTAL		;MAKE IT UPPER IF LOWER
CMAMB2	CP	B		;ARE THEY EQUAL?
	RET	NZ		;IF NOT THEN ITS NOT AMBIGUOUS.
	JP	CMAMB1		;CHECK THE NEXT CHAR.
CMIFIL	LD	(CMFCB),DE	;SAVE WHERE TO PUT THE CHARACTERS
	LD	HL,CLBUF	;GET THE INTERMEDIATE BUFFER
	LD	B,80		;NUMBER OF PLACES TO FILL
CMIFI0	LD	(HL),CR		;FILL THE FCB.
	INC	HL
	DJNZ	CMIFI0
	LD	DE,CLBUF
CMIFI1	CALL	CMGTCH		;GET A CHARACTER
	OR	A		;CHECK FOR A CONTROL CHARACTER ?,CR,ESC
	JP	P,CMIFI3	;GO IF NOT CONTROL
	AND	7FH		;STRIP THE HIGH BIT
	CP	ESC		;WAS IT ABORT?	
	RET	Z		;TAKE THE ERROR EXIT
	IFANOT	'?',CMIFI4	;Go if not help request
	LD	DE,FILHLP	;PRINT A MESSAGE
	CALL	REPRNT		;SET UP FOR REPARSE
	JP	REPARS		;GET A NEW CHARACTER
CMIFI3	LD	(DE),A		;STORE THE CHARACTER
	INC	DE		;POINT TO NEXT POS
	INC	B		;INCREMENT CHARACTER COUNT
	JR	CMIFI1		;GET ANOTHER ONE
CMIFI4	LD	A,B		;GET THE COUNT
	OR	A
	RET	Z
	PUSH	HL		;SAVE HL
	PUSH	BC		;SAVE BC
	LD	HL,CLBUF	;GET THE TEXT TO FSPEC
	LD	DE,(CMFCB)	;WHERE TO PUT THE RESULT
	CALL	XFSPEC		;MAKE IT A FILE SPEC
	PUSH	AF		;SAVE THE FLAGS
	PUSH	DE		;SAVE THE START
	LD	DE,CLBUF	;GET THE START
	OR	A		;RESET THE CARRY
	SBC	HL,DE		;COMPUTE THE OFFSET
	POP	DE		;GET THE START OF NEW BUFF
	ADD	HL,DE		;GET THE END
	LD	(HL),CR		;TERMINATE WITH A CR
	POP	AF		;RESTORE THE FLAGS
	POP	BC		;RESTORE BC
	POP	HL		;RESTORE HL
	JR	Z,CMIFI2	;GO IF FSPEC WAS OK
	CALL	XERROR		;PRINT THE MESSAGE
	RET			;ABORT COMPLETLY
CMIFI2	LD	(CMDPTR),HL
	LD	A,B		;GET THE LENGTH IN A
	JP	RSKP
;
;	Get input characters from the keyboard, up to an action character
;	The actual character input is retrieved via GETSTR().
;
CMINBF	PUSH	AF
	PUSH	DE
	PUSH	HL
	LD	A,(CMAFLG)	;IS THE ACTION CHAR FLAG SET?
	IFNZ	CMINB9		;Go if it is
	LD	HL,(CMCPTR)	;Get the position
	PUSH	HL		;Save it for later
	LD	DE,CMDBUF	;Get EOB
	OR	A		;Reset carry
	SBC	HL,DE		;Compute number of characters typed in
	LD	B,L		;Get number of characters
	POP	HL		;Get the value back
	CALL	GETSTR		;Input up to an action character
	JP	C,PRSERR	;Jump if user pressed break
	LD	A,B		;SAVE THE COUNT
	LD	(CMCCNT),A
	LD	C,B		;GET THE NUMBER OF CHARACTERS IN BUFFER
	LD	B,0
	LD	HL,CMDBUF	;Get the start
	PUSH	HL		;Save it
	ADD	HL,BC		;Add the count
	LD	(CMCPTR),HL	;Save next input position
	POP	BC		;Get the start
	OR	A		;Reset the carry
	SBC	HL,BC		;Are there any characters in the buffer?
	JP	Z,PRSERR	;IF NO CHARACTERS START OVER
CMINB6	LD	A,0FFH		;SET THE ACTION FLAG.
	LD	(CMAFLG),A
CMINB9	POP	HL		;Restore the registers
	POP	DE
	POP	AF
	RET			;Return
;
;	Get a character from the command input buffer.  If an action
;	character is found, then the MSB of the character will be set
;
CMGTCH	PUSH	HL
	PUSH	BC
CMGTC1	LD	A,(CMAFLG)
	OR	A		;IS IT SET.
	CALL	Z,CMINBF	;IS THE ACTION CHAR FLAG SET?
	LD	HL,(CMDPTR)	;GET A POINTER INTO THE BUFFER.
	LD	A,(HL)		;GET THE NEXT CHAR.
	INC	HL
	LD	(CMDPTR),HL
	IFA	' ',CMGTC2
	IFANOT	TAB,CMGTC3
CMGTC2	LD	A,(CMSFLG)	;GET THE SPACE FLAG.
	IFNZ	CMGTC1		;Was last char a space?
	LD	A,0FFH		;SET THE SPACE FLAG.
	LD	(CMSFLG),A
	LD	A,' '
	POP	BC
	POP	HL
	JR	CMGTC5
CMGTC3	PUSH	AF
	XOR	A
	LD	(CMSFLG),A		;ZERO THE SPACE FLAG.
	POP	AF
	POP	BC
	POP	HL
	IFA	ESC,CMGTC5	;Go if escape abort
	IFA	'?',CMGTC4	;Go answer a help request
	IFA	CR,CMGTC4
	CP	LF
	RET	NZ		;NOT AN ACTION CHAR, JUST RETURN.
CMGTC4	PUSH	HL
	LD	HL,(CMDPTR)
	DEC	HL
	LD	(CMDPTR),HL
	POP	HL
CMGTC5	OR	80H		;MAKE THE CHAR NEGATIVE TO INDICATE IT IS
	RET				;A TERMINATOR.
STRLEN	EQU	$
	PUSH	AF
	PUSH	DE
	LD	BC,0
STRLEN_1	EQU	$
	LD	A,(DE)
	IFA	EOS,STRLEN_2
	INC	DE
	INC	BC
	JR	STRLEN_1
STRLEN_2	EQU	$
	POP	DE
	POP	AF
	RET
;end of file
