;	m4set/asm
;
;THIS IS THE SET COMMAND.
;
SETCOM	LD	DE,SETTAB	;Parse a keyword for set table
	LD	A,SHLEN/3	;Patch the number in the table
	LD	(SETTAB),A	;Store the value
	LD	A,MXSLEN	;Patch the other value
	LD	(SETTAB+1),A
	LD	A,CMKEY		;Select keyword parse
	CALL	COMND		;Parse it
	JP	KERMT2		;Quit on an error
	LD	HL,SETJTB	;Get the jump table address.
	LD	C,A
	LD	B,0
	ADD	HL,BC
	JP	(HL) 
;SET COMMAND JUMP TABLE
SETJTB	JP	ESCAPE		;SET ESC
	JP	LOCAL		;SET LOCAL
	JP	FILWAR		;SET WARNING
	JP	SETFILE		;SET FILE
	JP	BLKSET		;SET BLOCK-CHECK-TYPE
	JP	SETEMUL		;SET emulation
	JP	PRINTR		;set printer
	JP	SETBUG		;SET DEBUG
	JP	SETDSK		;SET DEFAULT DISK
	JP	SETBEL		;SET BELL ON OR OFF
	JP	SETSND		;SET SEND PARAMETERS
	JP	SETREC		;SET RECEIVE PARAMTERS
	JP	SETKEY		;SET A KEY FOR TRANSLATION
	JP	SETFLO		;SET FLOW CONTROL
	JP	SETINP		;SET INPUT PARAMETERS
	JP	SETOTP		;SET OUTPUT PARAMETERS
	JP	SETTAK		;Set take display
	JP	SETEIGHT	;Set eighth bit quoting flag
SHLEN	EQU	$-SETJTB	;OFFSET FOR SHOW ALL
;
;	Set file dispostion
;
SETDISP	LD	DE,DISPTAB	;Get the parse table
	LD	A,CMKEY
	CALL	COMND		;Parse a keyword
	JP	KERMT2
	LD	(TEMP1),A	;Save it
	LD	A,CMCFM		;Get a confirm
	CALL	COMND
	JP	KERMT3
	LD	A,(TEMP1)
	LD	(DISCARD),A	;Set the value
	JP	KERMIT
;
;	Set take file display
;
SETTAK	SETFLG	TAKLOG
;
;	Set input options
;
SETINP	LD	A,CMKEY		;GET A KEYWORD
	LD	DE,INPTAB	;WHERE ARE THE KEYWORDS AT?
	CALL	COMND
	JP	KERMT2		;QUIT ON AN ERROR
	LD	C,A
	IFANOT	0,STINP1	;Check for first time
	SETFLG	CSEFLG
STINP1	CP	3
	JP	NZ,KERMT3
	SETFLG	INDSP
;
;	Set output option
;
SETOTP	LD	A,CMKEY
	LD	DE,OUTTAB
	CALL	COMND
	JP	KERMT2
	LD	C,A
	IFANOT	0,STOTP1
	SETFLG	ECHFLG
STOTP1	CP	3
	JP	NZ,KERMT3
	SETFLG	OTDSP
;
;	Set flow control option
;
SETFLO	LD	DE,FLOTAB
	LD	A,CMKEY
	CALL	COMND
	JP	KERMT2
	LD	(TEMP1),A
	LD	A,CMCFM
	CALL	COMND
	JP	KERMT3
	LD	A,(TEMP1)
	LD	(FLOFLG),A	;STORE THE NEW STATUS
	JP	KERMIT
;
;	Set bell on/off
;
SETBEL	SETFLG	BELFLG		;Set the bell ON or OFF
;
;	Set block check type
;
BLKSET	LD	DE,BLKTAB	;GET THE BLOCK-CHECK TABLE
	LD	A,CMKEY		;PARSE A KEYWORD
	CALL	COMND		;GO GET IT
	JP	KERMT2		;COULDN'T, COMPLAIN
	LD	(TEMP1),A	;SAVE THE PARSED ITEM
	LD	C,A
	LD	A,CMCFM		;WANT TO END THE COMMAND
	CALL	COMND		;GO DO IT
	JP	KERMT3		;GIVE UP
	LD	A,(TEMP1)	;GET THE VALUE BACK
	LD	(CHKTYP),A	;SAVE DESIRED CHECKSUM TYPE
	JP	KERMIT		;GO GET ANOTHER COMMAND
;
;	Set send options
;
SETSND	XOR	A		;SET SEND/RECEIVE TO SEND
	JR	SETSOR
;
;	Set receive options
;
SETREC	LD	A,1		;SET SEND/RECEIVE TO RECEIVE
;
;	Common code that uses the contents of A at this point to
;	control where the set value is stored.  All of the SEND/RECV
;	options are set up in memory together, so that to give a
;	particular send option a value, it is stored directly.  The
;	corresponding recv option is one byte in memory beyond the
;	send option, so the flag (What is in A) is checked, and the
;	destination address is incremented if A is non zero
;
;	Memory looks like this
;
;	SEOL	DB	13
;	REOL	DB	13
;	SSOH	DB	1
;	RSOH	DB	1
;
SETSOR	LD	(SORFLG),A	;STORE THE FLAG
	LD	DE,STSNTB	;GET THE PARSE TABLE
	LD	A,CMKEY
	CALL	COMND		;PARSE SOMETHING
	JP	KERMT2		;ABORT
	LD	HL,STSJTB	;GET THE JUMP TABLE
	LD	C,A
	LD	B,0
	ADD	HL,BC
	JP	(HL)
STSJTB	JP	STPDCH		;SET PAD CHARACTER
	JP	STPAD		;SET PADDING ON/OFF
	JP	SSOFP		;SET START OF PACKET
	JP	STIMEO		;SET TIME OUT
	JP	SSEOL		;SET END OF LINE
	JP	SSQUOT		;SET QUOTE CHARACTER
	JP	SSTURN
;
;	Set the padding.  Note that it is only done on output, so
;	SET RECEIVE PADDING doesn't make sense.
;
STPAD	LD	A,CMNUM		;GET A LENGTH COUNT
	CALL	COMND		;PARSE A VALUE
	JP	KERMT3		;NOT CONFIRMED ON AN ERROR
	OR	A		;CHECK FOR NO NUMBER
	JP	Z,KERMT2	;SAY AMBIGUOUS
	LD	A,D		;CHECK FOR OVERFLOW
	IFZ	STPD10		;Go if none
	LD	DE,OUTRNG
	CALL	PRTSTR
	JP	KERMIT
STPD10	LD	A,E
	LD	(SPAD),A	;SET THE STATUS
	JP	KERMIT		;GET A NEW COMMAND
;
;	Set the padding character.  Also applys to SEND only!
;
STPDCH	LD	HL,SPADCH	;GET THE ADDRESS TO STORE AT
SOR010	LD	(SORLOC),HL	;SAVE IT FOR LATER
	LD	A,CMNUM		;GET A DECIMAL NUMBER
	CALL	COMND
	JP	KERMT3
	OR	A		;CHECK FOR NO NUMBER
	JP	Z,KERMT2	;SAY AMBIGUOUS
	LD	A,D		;CHECK FOR TOO BIG
	IFZ	PDCH2		;Go if ok
	LD	DE,OUTRNG	;VALUE OUT OF RANGE ERROR
	CALL	PRTSTR		;PRINT IT
	JP	KERMIT
PDCH2	LD	HL,(SORLOC)	;GET WHERE TO PUT IT
	LD	A,(SORFLG)	;GET THE MODE, SEND/RECEIVE
	OR	A		;CHECK FOR SET OR RESET FLAG
	CALL	Z,SSVAL		;IF ZERO THEN SET RECEIVE VALUE
	CALL	NZ,SRVAL	;ELSE SET THE SEND VALUE
	JP	KERMIT		;GET A NEW COMMAND
;
;	Set START-OF-PACKET (Start Of Header, SOH)
;
SSOFP	LD	HL,SSOHCH
	JP	SOR010
;
;	Set turn around character
;
SSTURN	LD	HL,STURN
	JP	SOR010
;
;	Set time-out value
;
STIMEO	LD	HL,STIME
	JP	SOR010
;
;	Set End Of Line (or End Of Packet) character
;
SSEOL	LD	HL,SEOL
	JP	SOR010
;
;	Set eighth bit quote character
;
SSQUOT	LD	HL,SQUOTE
	JP	SOR010
;
;	Convert ASCII Decimal string to binary in BC, HL is the
;	source buffer.
;
DECHEX	JP	XDECHEX
;
;	Store E at HL+1
;
SSVAL	INC	HL
;
;	Store E at HL
;
SRVAL	LD	(HL),E
	RET
;
;	Convert contents of A to ASCII string, and display
;
ANOUT	PUSH	HL
	LD	L,A
	LD	H,0
	CALL	NOUT
	POP	HL
	RET
;
;	Set the escape character
;
ESCAPE	LD	A,CMCFM
	CALL	COMND		;GET A CONFIRM.
	JP	KERMT3		;DIDN'T GET A CONFIRM.
	LD	DE,ESCMES	;GET THE ADDRESS OF THE ESCAPE MESSAGE.
	CALL	PRTSTR
	CALL	XKEY
	LD	(ESCCHR),A	;STORE THE NEW ESCAPE CHARACTER.
	CALL	ESCPR		;Print the Verbpse description of it
	JP	KERMIT
;
;	Set local echo status
;
LOCAL	SETFLG	ECOFLG
;
;	Set the emulation type
;
SETEMUL	LD	DE,EMLTAB
	LD	A,CMKEY
	CALL	COMND
	JP	KERMT2
	LD	(TEMP1),A
	LD	A,CMCFM
	CALL	COMND
	JP	KERMT3
	LD	A,(TEMP1)
	LD	(EMULFLAG),A
	JP	KERMIT
;
;	Set file-warning status
;
FILWAR	SETFLG	FLWFLG		;Set the file-warning flag
;
;	Set file type, BINARY or ASCII
;
SETFILE	LD	DE,FILETAB	;Get the table of choices
	LD	A,CMKEY		;Select keyword parse
	CALL	COMND		;Parse the input
	JP	KERMT2		;Abort on an error
	LD	C,A
	LD	B,0
	LD	HL,FILJTAB	;Get the jump table
	ADD	HL,BC
	JP	(HL)		;Go to the routine
;
;	SET FILE jump table
;
FILJTAB	JP	SETDISP		;Set file disposition
	JP	SETTYPE		;Set file type
;
;	SET FILE TYPE
;
SETTYPE	LD	DE,TYPETAB	;Get the table
	LD	A,CMKEY
	CALL	COMND
	JP	KERMT2		;Abort on an error
	LD	(TEMP1),A	;Save the value
	LD	A,CMCFM		;Get a confirm
	CALL	COMND
	JP	KERMT3		;Say not confirmed
	LD	A,(TEMP1)	;Get the value back
	LD	(FILTYPE),A	;Set the type chosen
	JP	KERMIT		;Get another command
;
;	Set Printer command
;
PRINTR	SETFLG	PRTFLG
;
;	Set status of DEBUG
;
SETBUG	SETFLG	DBFLG
;
;	SET EIGHTH-BIT quoting status
;
SETEIGHT	CALL	ONOFF
	XOR	1
	LD	(EBQFLG),A
	JP	KERMIT
;
;	Get an ON/OFF value in A, with a confirm
;
ONOFF	LD	DE,ONTAB
ONOFFA	LD	A,CMKEY
	CALL	COMND
	JP	KERMT2
	LD	(TEMP1),A
	LD	A,CMCFM
	CALL	COMND
	JP	KERMT3
	LD	A,(TEMP1)
	RET
;
;	Set a KEY mapping
;
SETKEY	LD	A,CMNUM		;Get the key number
	CALL	COMND
	JP	KERMT2		;Abort on error
	IFZ	SETKEY_5	;Abort if no number
	LD	A,D		;Get the MSB must be zero
	IFNZ	SETKEY_4
	LD	A,E		;Get the LSB
	LD	(KEYNUM),A	;This is the key number
	LD	A,CMTXT		;Get the text definition
	LD	DE,RMTDATA	;Where to put it
	LD	(SOUPTR),DE	;Set the starting address
	CALL	COMND		;Call the parser
	JP	KERMT3		;Say not confirmed
	LD	HL,DATA
	LD	(KEYPTR),HL
	PUSH	AF
	XOR	A
	LD	(KEYLEN),A
	POP	AF
	IFZ	SETKEY_3
SETKEY_1	CALL	GETFCH	;GET A CHARACTER
	JR	NZ,SETKEY_3
	CALL	GTREAL		;GET THE ACTUAL IF IT IS SPECIAL
	JP	NZ,KERMIT	;Abort on bad string
	LD	E,A		;PUT IT IN E FOR OUTCHR
	LD	A,(DLYFLG)	;WAS IT A DELAY
	IFZ	SETKEY_2
	XOR	A
	LD	(DLYFLG),A	;RESET THE FLAG
	JR	SETKEY_1	;GET A NEW CHARACTER
SETKEY_2	LD	A,E	;Get the character
	CALL	PUTDKEY		;Put it into the buffer
	JR	SETKEY_1
SETKEY_3	LD	HL,DATA
	LD	A,(KEYLEN)
	LD	B,A
	LD	A,(KEYNUM)
	CALL	DEFKEY
	JP	KERMIT
SETKEY_4	LD	DE,OUTRNG
	CALL	PRTSTR
	JP	KERMIT
SETKEY_5	LD	DE,KEYHELP
	CALL	PRTSTR
SETKEY_6	CALL	CONIN
	IFZ	SETKEY_6
	LD	(KEYNUM),A
	CALL	VERPRT
	LD	DE,STRHELP
	CALL	PRTSTR
	LD	HL,DATA
	LD	B,0
SETKEY_7	CALL	CONIN
	IFZ	SETKEY_7
	IFA	128,SETKEY_8
	LD	(HL),A
	CALL	VERPRT
	INC	B
	INC	HL
	JR	SETKEY_7
SETKEY_8	LD	A,B
	LD	(KEYLEN),A
	JR	SETKEY_3
;
;	Put the decoded value into the buffer pointer to by KEYPTR
;
PUTDKEY	PUSH	HL
	LD	HL,(KEYPTR)
	LD	(HL),A
	INC	HL
	LD	(KEYPTR),HL
	LD	HL,KEYLEN
	INC	(HL)
	POP	HL
	RET
;end of file
