.po 13
.na
.nh
.LP
.ND
.NP
.tl ''\fITRS-80 Model 4(p) KERMIT version 5.2\fR''
.sp
.tl ''\fIFor use under TRSDOS 6.1 or later\fR''
.sp 2
.IP \fIProgram\ by:\fR 19
Gregg Wonderly Oklahoma State University, (gregg@okstate) 
rewritten from the original Model-4 KERMIT which was derived
from the TRS-80 KERMIT done by Stan Barber, Rice University who
modified the CP/M-80 version by Bill Catchings and others.
.IP \fILanguage:\fR 19
Z80 Assembler, compatible with M80 and EDAS from Misosys
.IP \fIVersion:\fR 19
5.2
.IP \fIDate:\fR 19
June 13, 1985
.IP \fIDocumentation\ by:\fR 19
Gregg Wonderly
.sp 2
.NH
Summary of TRSDOS 6.1
.sp
.PP
\fITRSDOS\fR (The Radio Shack Disk Operating System)
has a large library of built
in commands dealing with files, directory maintenance, device I/O, etc.
Programs are also used for some functions on some \fITRSDOS\fR-based DOS's.
Model 4(p) KERMIT gives you access to all of the library
commands of \fITRSDOS\fR versions 6.1 or later via the LOCAL command.
Issue the LIBRARY command at \fITRSDOS Ready\fR to obtain a list.
.PP
\fITRSDOS\fR file specifications can be represented as a sequence of
characters of the form
.RS
.sp
FILESPEC/EXT.PASSWORD:D
.sp
.RE
.IP \fIFILESPEC\fR 11
is the filename up to eight characters.
.IP \fIEXT\fR
is the file type, up to three characters.
.IP \fIPASSWORD\fR
is the password for that file, 8 characters or less.
.IP \fID\fR
is a numerical drive specification (0-7).
.PP
File names, file types and passwords may contain letters and numbers, but the 
first character in each must be a letter.  No special characters or spaces are 
allowed.  All fields are optional except the filespec.  Any field added must be 
preceded by its special delimiter '/' for file type, '.' for passwords
and ':' for drive specifications.  Upper and lower case characters are
equivalent.
.PP
\fITRSDOS\fR 6.1 and 6.2 do \fInot\fR recognize wild card
characters like *, ? etc.  When
specifying files, you must use the entire filespec.  NOTE:  This applies
to KERMIT commands in particular.  \fITRSDOS\fR library commands such as PURGE
do allow a partspec such as "PROG1:0" to specify all files with the string
PROG1 in them.  Model (4)p KERMIT only allows wild cards in the GET, and SEND
commands.
.NH
TRSDOS Commands of Interest
.sp
.NH 2
CAT PARTSPEC:D (OTHER OPTIONS)
.sp
.RS
This command is specific to \fITRSDOS\fR version
6.2 and later.  It displays only
the names of visible files on the drive specified, or all drives if
no \fIpartspec\fR is given.  \fI(other options)\fR allows different formats
and invisible as well as system files to be selected.  See the \fITRSDOS\fR
manual for specifics
.RE
.NH 2
DIR PARTSPEC:D (OTHER OPTIONS)
.sp
.RS
DIR is common to all version of TRSDOS.  Versions after 6.1 replaced the
DIR command with CAT, and changed the DIR command so that always
produces a long listing.
.RE
.NH 2
FREE :D
.sp
.RS
Gives statistics on disk usage.  If D is present, than only the
statistics for the specified disk will be shown.
.RE
.NH 2
REMOVE/PURGE FILESPEC (PARAMETERS)
.sp
.RS
Remove the file(s) from the directory and frees the space 
allocated to the file for reassignment.  Purge allows PARTSPECs that
specify groups of files.  With no PARAMETERS, PURGE prompts before
deleting any file.  Remove requires a full filespec as the name of the
file to remove.  More than one may be given on the command line.
.RE
.NH 2
LIST FILESPEC (PARAMETERS)
.sp
.RS
Lists the file on the display.  Parameters are described in the \fITRSDOS\fR
manual in detail.  \fI(HEX)\fR is sometimes useful to display the Hexidecimal
values of the characters in a file.
.RE
.NH 2
RENAME oldfile newfile
.sp
.RS
Changes the name of oldfile to newfile if newfile is a 
unique file name on that disk.
.RE
.NH
Copying Disks and Files:
.RS
.NH 2
COPY file1 file2
.sp
.RS
Copies file1 and name the copy file2. If file2 exists, it 
will be replaced.
.RE
.NH 2
BACKUP :D :E
.sp
.RS
Makes a copy of the disk in drive D on the the disk in drive E.
.RE
.NH 2
FORMAT :D
.sp
.RS
Formats the disk in drive D.  The disk will be ready for any normal 
read or write operation following successful completion of this 
operation. This operation must be performed before use of a blank disk. 
Reformatting a previously formatted disk will cause all previously 
stored information to be lost.
.RE
.RE
.NH
Transfers without the KERMIT Protocol
.PP
Model 4(p) KERMIT adds
2 logical devices to the already resident devices.  These devices are
use to access the communications port.  These devices,
*FI (File input) and *FO (File output), can be used as the source, and
destination of a copy command, respectively.  They make use of the status of
the SET FLOW-CONTROL parameter, to send and receive data using the 
communications port.  For instance, say you are communicating with a computer
that does not have KERMIT.  Say you also wish to transfer a file to
this computer to do some further processing.  The normal method involves
starting a program on the remote computer to collect the data into a file
on that system.  On a VMS system, you might use the CREATE command to
capture the file.  The following \fIKERMIT\fR commands will accomplish
the transmition of a file in this case.
.sp
.RS
OUTPUT CREATE MYPROG.DAT<CR>
.br
LOCAL COPY PROG/DAT *FO
.RE
.sp
The KERMIT command, OUTPUT,
will send the string "CREATE MYPROG.DAT<CR>" to the host.
Let's say for now that this is sufficient to cause all future characters sent
to the host to be placed into the file MYPROG.DAT on that system.
The KERMIT command LOCAL is then used to invoke the \fITRSDOS\fR library
command COPY.  COPY will copy the contents of the file "PROG/DAT" to the
*FO device.  The driver for this device is part of the KERMIT program,
and will take care of transmitting the data out of the communications
port to the HOST.  If the HOST sends XOFF because DATA is arriving TOO
fast, then the XON/XOFF option to the \fIKERMIT\fR command SET FLOW-CONTROL
will allow the transfer to pause while the HOST catches up.
If you wish to collect the contents of a file on the remote host,
that does not have \fIKERMIT\fR, you can use a series of commands similar to:
.sp
.RS
OUTPUT TYPE MYPROG.DAT<CR>	
.br
INPUT TYPE MYPROG.DAT<CR><LF>
.br
LOCAL COPY *FI MYPROG/DAT:1
.RE
.PP
I should clarify the use of the \fIOUTPUT\fR command, and the corresponding
\fIINPUT\fR command.  If you use the \fIKERMIT\fR command \fICONNECT\fR to
enter the terminal mode, and then proceed to tell the host
to send a file, it may start sending data
before you can escape back, and type the \fICOPY\fR command.
This means that some
of the data would be lost.  With \fIFLOW-CONTROL\fR set to \fIXON/XOFF,\fR
and the remote
host recognizing this fact, the previous commands would not allow any data
to be lost.  The use of \fIINPUT\fR is only to remove the characters
ECHOed by the
host from the input buffer (The TEXT of the command
"TYPE MYPROG.DAT").  If you are communicating with a half-duplex system
in which \fIModel (4)p KERMIT\fR is echoing the
characters typed on the keyboard, then the \fIINPUT\fR command
need not be used.  
.sp 3
.NH
Control of File Transfers
.sp
.PP
During the transfer of a file using either \fISEND\fR, or \fIGET\fR and possibly
during the use of the \fIREMOTE\fR command, protocol operations may need to be
aborted, or altered.  Several key strokes have been given to allow
the user to control the protocol operations.  These are listed below,
and are listed on the screen after issuing either the \fISEND\fR or \fIGET\fR
commands.  The operation of the \fIREMOTE\fR command is purposefully silent.
The key strokes are available to the user during \fIREMOTE\fR commands,
for added flexibility.  This allows
the user to cancel commands like \fIREMOTE TYPE\fR that may otherwise cause
large amounts of data to be displayed for an extended amount of time.
The valid key strokes are:
.sp
.IP \fIControl-F\fR 15
During data transfers using the \fIKERMIT\fR protocol,
\fIControl-F\fR will terminate the current transaction.
If there are more files to transfer, the next transaction will be started.
\fIModel 4(p) KERMIT\fR will send a signal to the remote \fIKERMIT\fR
telling it to stop sending packets for the current transaction.
If the remote \fIKERMIT\fR understands this signal
(not all implementations of \fIKERMIT\fR
do), it will comply, otherwise the transaction will continue.
.IP \fIControl-B\fR
Like  \fIControl-F\fR, except that if a group of files is being processed
this will stop the entire group.  If only a
single file is being \fISENT\fR or \fIRECEIVED\fR, \fIControl-B\fR
behaves exactly like \fIControl-F\fR.
.IP \fIControl-C\fR
Aborts the protocol immediately.  This should be a last resort to
stopping a transmission as it will leave the remote \fIKERMIT\fR in an
unknown state.
.IP \fIControl-E\fR
Aborts the protocol after sending an ERROR packet to the remote \fIKERMIT\fR.
.IP \fIControl-D\fR
Toggles \fIDEBUG\fR mode \fION\fR and \fIOFF.\fR  This is helpful when
trying to figure out why a particular host is unable to talk to
\fIModel 4(p) KERMIT\fR.
.IP \fI<ENTER>\fR
If you type \fI<ENTER>\fR, \fIModel 4(p) KERMIT\fR will resend
the current packet.
.IP \fIControl-H\fR
Displays the list of \fIKEYS\fR that you may press during a transfer.  I.E.
the keys described above.
.sp 3
.NH
Model 4(p) KERMIT Commands
.sp 2
.PP
\fIModel 4(p) KERMIT\fR uses a subset of the
the \fIDECSYSTEM-20\fR keyword style command language.  Each
keyword may be abbreviated to its minimum unique length.  "?" may be typed to
request a list of the available options for the current field at any point in a
command.  If insufficient characters have been typed to identify the 
current field uniquely, \fIModel 4(p) KERMIT\fR will display all
available choices,
and then reprompt to allow you to continue from that point.  If there are
sufficient characters, then only a single choice will be displayed.  The
following list of commands are available when using \fIModel 4(p) KERMIT\fR.
.NH 2
BYE
.sp
.RS
When talking to a remote \fIKERMIT\fR Server, this command should shut down a
remote server and terminate the login that you had there.  Due to some
deviations from the specification, some systems do not perform exactly
in this manner.  You should check the documentation of the \fIKERMIT\fR on the
remote system in order to obtain the operation performed by this command.
\fIModel 4(p) KERMIT\fR will then exit to \fITRSDOS Ready\fR.
.RE
.NH 2
CLEAR
.sp
.RS
.NH 3
INPUT-PORT
.sp
.RS
\fIModel 4(p) KERMIT\fR uses the "Interrupt on received character available"
feature of the COM/DVR communications line driver.  This driver is part of the
standard software on your system diskette.
All characters received via the interrupt vector, are placed in a 256 byte
circular buffer.  This command clears all characters currently buffered.
This is used most commonly with the INPUT, OUTPUT, PULSE, and PAUSE
commands, none of which explicitly clear the input buffer.  YOU MUST DO
THIS YOURSELF.  The execution of this command will \fInot\fR send
an \fIXON\fR character to the communications port.  This is also left
up to you to do.
.RE
.NH 3
SCREEN
.sp
.RS
As you would expect, this command clears the screen.
.RE
.RE
.NH 2
CLOSE
.sp
.RS
.NH 3
SESSION-LOG
.sp
.RS
Closes the file previously opened with the LOG command.  If no file is open,
you will be advised so.
.RE
.RE
.NH 2
CONNECT 
.sp
.RS
Establish a "virtual terminal" connection to any host that may be
connected to the serial port, i.e. pass all typed characters
to the serial port and display all input from the serial port on the screen.
A two character sequence of characters is required to return the user to the
\fIKERMIT\fR program.  An escape character must be typed followed by a 'c'
(Case is \fInot\fR significant).
The default escape character is entered by pressing the
<SHIFT> and <CLEAR> keys simultaneously on the keyboard.  Pressing '?'
after the <ESCAPE> character will display a list of valid keystrokes
that do helpful things during connect mode.
When you issue the \fICONNECT\fR command, the micro will print a
message telling you how to get back.   The escape sequence is
generally an uncommonly-used control character.
The following keystrokes are valid following the \fI<ESCAPE>\fR character,
and generate specific actions.  The actions are described beside the key.
.RS
.IP \fIC\fR
Return to \fIModel 4(p) KERMIT\fR command level.  The contents of the
screen and
the cursor location will be saved prior to displaying the \fIKERMIT\fR screen.
When you reconnect to the \fIHOST\fR using the \fIKERMIT\fR command,
\fICONNECT,\fR the old screen will be restored.
.IP \fIS\fR
Display Status of connection, but maintain remote connection.
.IP _?
List available single-character commands, I.E. These commands.
.IP \fIB\fR
Send a TRUE modem break.
.IP \fIR\fR
Resume logging if file open, and <ESCAPE>Q was used
previously to turn logging off.  See the \fILOG\fR command for more
information.
.IP \fIQ\fR
Quit logging to file but leave it open.
.IP \fI0\ (zero)\fR
Send a null (0) character out the communications port.
.IP \fI<ESCAPE>\fR
Send the \fI<ESCAPE>\fR character itself to the remote host.
.RE
.RE
.NH 2
DIR partspec
.sp
.RS
Produces a listing of the directory for "partspec".  If partspec is
not given, than the directory will be displayed for the \fIDEFAULT-DISK\fR
drive as established by \fISET DEFAULT-DISK\fR.
.RE
.NH 2
EXIT
.sp
.RS
Exit \fIModel 4(p) KERMIT\fR, and return to \fITRSDOS\fR.
.RE
.NH 2
FINISH  
.sp
.RS
Shuts down the remote server without logging it out.
Leaves you at \fIModel 4(p) KERMIT\fR command level.
A subsequent \fICONNECT\fR command will reconnect you to the
remote host.  The \fIremote KERMIT\fR should return to the
mode it was in prior to entering \fISERVER\fR mode.
.RE
.NH 2
GET filespec
.sp
.RS
Get allows you to retrieve files from a remote host.  Get works
with either a \fISERVER\fR or a \fIKERMIT\fR that has initiated
a \fISEND\fR command.  Filespec is a filename compatible with
\fIthat\fR system.  When \fIModel 4(p) KERMIT\fR is talking to
a \fIKERMIT\fR Server, you may include
a file wild card \fIif and only if\fR the host supports wild cards. The
filespec must be in a legal form for the \fIHOST KERMIT\fR to understand.
.RE
.NH 2
INPUT control string
.sp
.RS
Input provides one of 4 commands new to \fIKERMIT\fR in general.  It allows
you to watch for the occurrence of certain text strings that are made up
characters arriving in the communications port.
This is useful in \fITAKE\fR files that can automatically log you
onto a certain system.
.PP
When \fIINPUT\fR in initiated, it begins matching
characters in the input to those given in the control string.  When
an exact match is found as established by the \fISET INPUT\fR options then
\fIINPUT\fR will return to the \fIKERMIT\fR command level.
If \fITAKE\fR is active
than the next line of the \fITAKE\fR file will be read.  The Control string
may be comprised of any printable \fIASCII\fR characters.  \fISPACE\fR
must not occur as either the beginning or end of the string.
.PP
\fIASCII\fR character codes
0-32 are denoted as \fI<NUL>\fR - \fI<SPA>,\fR and \fI<DEL>\fR represents
character 127.
The string \fI<DLY*>\fR signifies an immediate delay.  The * should be replaced
by a character.  The significance of the character is this.  Decimal 48
is subtracted from the \fIASCII\fR value of the character to obtain the
number of seconds to delay.  Thus, you can obtain delays
1-9 seconds, with no trickery.  Delays longer than that will have
to be calculated since the formula (ASCII code - 48 decimal) is used
to calculate the binary value to use as a counter.  The "*" should
be replaced with the single proper ASCII character.
.PP
If you use \fI<DLY*>\fR in
a \fIPULSE\fR command, it should be noted that it will only be done once.
An alternative format for control characters is to explicitly type
a carat ("^") preceding a character.  The result of subtracting
64 from the \fIASCII\fR code for the character following will then be
used.  Since <, >, and ^ now have special meanings, you will need
some way to specify them explicitly.  To do this you should precede
them with a backslash, "\\", character.  In this case, backslash itself
now must be represented as "\\\\".  Finally, any and all characters
can be represented using a string of the form \\nnn where nnn is 1 or
more octal digits.  nnn is evaluated, and the resulting value will
be the ASCII value of the character.  Some examples might be:
.sp
.RS
INPUT login:<SPA>
.sp
.RS
Find the string "login:" followed by a space.
.RE
.sp
INPUT <SPA>^M^Jenter \\\\userid\\\\:<CR><LF>
.sp
.RS
Find the string with a space followed by a carriage
return followed by a line feed followed by the text
"enter \\userid\\:" followed by carriage return and another
linefeed.
.RE
.sp
INPUT USERNAME\\77\\40
.sp
.RS
Find the string "USERNAME? ".  Note that \\77 is the \fIONLY\fR
way that a question mark can be specified since a question mark is
recognized by the command stream as a request for help.
.RE
.RE
.sp
While input is waiting for a match, you may type characters on the
keyboard to be transmitted.  \fIBREAK\fR will abort the \fIINPUT\fR
command and if \fITAKE\fR is active, close the take file.  \fIESCAPE\fR
will abort the INPUT command, but will just skip to the next line in
a \fITAKE\fR file, if \fITAKE\fR is active.  These same 2 actions apply
to the \fIPULSE\fR command while no input has been received.
.RE
.NH 2
KILL filespec
.sp
.RS
This command removes the file given from the filesystem.  The
value of \fIDEFAULT-DISK\fR is \fINOT\fR used here.  You \fImust\fR
therefore completely qualify which file you wish to delete.
.RE
.NH 2
LOCAL TRSDOS library command
.sp
.RS
This command allows you to issue commands from within
\fIModel 4(p) KERMIT\fR.  You must remember where Model 4(p) KERMIT
resides in memory, to assure that you do not overwrite it.  KERMIT
loads at 6000H, and continues up through LOW$.  From within KERMIT,
you can issue the command:
.RS
.sp
LOCAL MEMORY
.RE
.sp
to see where KERMIT ends.  The value of LOW$ tells you this information.
KERMIT was placed at 6000H to allow all of the TRSDOS library
programs and commands to work in conjunction with KERMIT.  Some commands
extend above 3000H, and must have memory available up to approximately
5300H.
.RE
.NH 2
LOG filespec
.sp
.RS
When CONNECTed to a foreign host as a terminal, this command establishes
a logfile of the terminal  session in the file specified.
This function depends, to
some extent, on the remote host's ability to do \fIXON/XOFF\fR flow control.
Without \fIFLOW-CONTROL,\fR data may be lost when \fIKERMIT\fR writes to
the file.  The log file is closed by explicitly 
typing the \fIKERMIT\fR command \fICLOSE SESSION-LOG\fR or when
\fIKERMIT\fR is exited via the \fIEXIT\fR command.
It will also be closed if an I/O error occurs in file processing for
the file involved.  \fILOGGING\fR may be toggled on and off
during \fICONNECT\fR using the sequence of keys described in
the \fICONNECT\fR description.
.RE
.NH 2
LOGOUT  
.sp
.RS
Logout tells a \fIremote kermit server\fR to terminate itself, as
well as your login session.  When this is completed, you are left
at \fIModel 4(p) KERMIT\fR command level.
.RE
.NH 2
OUTPUT control string
.sp
.RS
This is the other side of the \fIINPUT\fR command.  Control string follows
the same conventions as in \fIINPUT,\fR and the resulting character(s) will
be output to the communications port immediately.  It should be noted
that \fINO\fR characters other than what you specify are transmitted.  In
other words if you want to simulate typing some string, followed by
pressing \fI<ENTER>,\fR then you will have to use a command similar to:
.sp
.RS
OUTPUT mypassword<CR>
.sp
.RE
.sp
The \fI<CR>\fR will explicitly send the \fIASCII\fR
character 13 to the communications port.
.RE
.NH 2
PAUSE number of seconds
.sp
.RS
This command is usually used in conjunction with \fIINPUT,\fR
\fIOUTPUT,\fR and \fIPULSE\fR as a means of syncronizing
\fIModel 4(p) KERMIT\fR to a remote host.
A delay of the specified number of seconds will be generated based on
the accuracy of the 60HZ interrupt.  No means has been made for 
aborting the delay.  The maximum delay is 65536 seconds by specifying
0 as the number.
.RE
.NH 2
PULSE control string
.sp
.RS
This command is an extension/combination of \fIINPUT\fR and \fIOUTPUT.\fR
It allows you to transmit one or more characters repeatedly until a character
appears in the input port.  The use of this command is valuable when
logging onto systems that don't always respond immediately after
the reception of some control character(s).  For instance, you might
(Now that all of the functions of this nature have been described)
use the following commands as part of a logon sequence to log onto a
computer system.
.sp
.RS
SET INPUT CASE-IGNORE ON
.br
SET INPUT DISPLAY ON
.br
SET OUTPUT HOST-ECHO ON
.br
SET OUTPUT DISPLAY ON
.br
CLEAR INPUT-PORT
.br
PULSE ^T<CR>
.br
INPUT <CR><LF>XYZ:
.br
PAUSE 2
.br
CLEAR INPUT-PORT
.br
PULSE <CR>
.br
INPUT Username:<SPA>
.br
OUTPUT joeblow<CR>
.br
INPUT <CR><LF>Terminal type:
.br
OUTPUT vt52<CR>
.br
SET KEY 8 <DEL>
.br
SET KEY 128 <ETX>
.RE
.sp
After you study this awhile, it should make since.  If these commands
are placed into a \fITAKE\fR file, then
you could use a \fICONNECT\fR command after the last command, to
connect immediately to the host.  If this is done, then \fIonly\fR
after you escape back to \fIModel 4(p) KERMIT\fR, will the \fITAKE\fR file
finally be closed.
.RE
.NH 2
REMOTE command
.sp
.RS
\fIRemote\fR commands are not supported in totality by all \fIservers\fR.
If a \fIserver\fR supports remote commands, then \fIremote help\fR should
display all of the commands available to the \fIremote\fR user of the
server.  Below are descriptions of the \fIremote\fR commands that
\fIModel 4(p) KERMIT\fR knows how to send to a \fIremote server\fR.
The arguments to most commands are dependent on the \fIremote\fR
system.  You should be familiar with any system before using the
\fIremote server\fR commands available from that server.  Usually only
a small number of these commands are supported since some require
abilities that some operating systems just don't have.
.sp
.NH 3
CLOSE-LOG
.sp
.RS
Close a remote \fILOG\fR previously opened via the command
\fIREMOTE START-LOG\fR.
.RE
.NH 3
COPY
.sp
.RS
Copy one file to another.
.RE
.NH 3
CWD directory path
.sp
.RS
If a particular server's operating system supports the concept of
separate directories, then this command will allow you to change to
a different directory.
.RE
.NH 3
DELETE 
.sp
.RS
Deletes file(s) from the \fIremote\fR system.  Any arguments will probably
be file names in the format of the \fIremote\fR system.
.RE
.NH 3
DIR
.sp
.RS
Display a list of files on the \fIremote\fR system.
.RE
.NH 3
DISK
.sp
.RS
Display information about disk utilization on the \fIremote\fR system.
.RE
.NH 3
HELP
.sp
.RS
Get information about \fIremote\fR capabilities on the \fIremote\fR system.
.RE
.NH 3
HOST
.sp
.RS
Execute a command on the \fIremote\fR system.
.RE
.NH 3
KERMIT
.sp
.RS
Execute a \fIKERMIT\fR command on the \fIremote\fR system.  This command should
accept a normal \fIKERMIT\fR command as an argument.  The command,
if valid, will then be executed by the remote \fIKERMIT\fR server.
.RE
.NH 3
LOGIN
.sp
.RS
Create a login entity on the \fIremote\fR system.  This may be incorporated
into a dedicated server.
.RE
.NH 3
MESSAGE
.sp
.RS
Send a message to a user on the \fIremote\fR system.
.RE
.NH 3
PROGRAM
.sp
.RS
Feed command input to a command executing on the remote system, or
control the execution of a program.
.RE
.NH 3
QUERY-VARIABLE
.sp
.RS
Get the value of a variable maintained on the \fIremote\fR system.
.RE
.NH 3
RENAME
.sp
.RS
Change the name of a file on the \fIremote\fR system.
.RE
.NH 3
SEND-LOG
.sp
.RS
Tells the server to close any open log, and then transfer it to the
user.
.RE
.NH 3
SERVER-STATUS
.sp
.RS
Retrieve certain information about the status of a REMOTE server.  The
information returned is dependent on the REMOTE system.
.RE
.NH 3
SET-VARIABLE
.sp
.RS
Set the value of a variable on the \fIremote\fR system.
.RE
.NH 3
START-LOG
.sp
.RS
Start a transaction log on the \fIremote\fR system.
.RE
.NH 3
STOP-LOG
.sp
.RS
Stops logging to the log file started by the \fIREMOTE START-LOG\fR
command.  The file is not closed.  Logging may be started again by
using the the command, \fIREMOTE START-LOG\fR.
.RE
.NH 3
TYPE
.sp
.RS
Display the contents of the file/files given as arguments.  The \fIremote\fR
server should use the \fIKERMIT\fR protocol to send the contents of the
specified file/files to \fIModel 4(p) KERMIT\fR.  The file contents will be
displayed on the screen using the *SO device.
.RE
.NH 3
WHO
.sp
.RS
Display a list of users on the \fIremote\fR system.
.RE
.RE
.NH 2
SEND [(INVIS,SYSTEM)] file specification(s) ...
.sp
.RS
File specifications may contain wild card characters.  The recognized
wild card characters are '*' and '$'.  '*' means zero or more of
any character.  '$' means exactly one of any character.  There are a lot
of specifics associated with wild carding, and search order through the
drives.  The INVIS, and SYSTEM options allow you to select invisible
and/or system files, which are not normally included.  The options
\fImust\fR appear before each specification that requires either, as
these options are nullified before each specification is processed.
.PP
When files by the same name exist on different drives, a wild card match
of one will also match all other occurances.  e.g. if drive 0 contains the
file report/dat, and report.dat also exist on drive 1, then the command
'SEND */dat' will collect both names for sending.  On the other hand,
other variations can be used to send only one of the 2 files.  'SEND
*/dat:1' will only match files on drive 1.  Another alternative would be
'SEND report/dat:1' which would send only report/dat on drive 1.
.PP
Case is NOT significant, so both REPORT/DAT and report/dat are identical.
'/' is not significantly different from other characters in a file name,
so "*/*" is the same as "*" for all file names with an extension.  "*/*",
however, does not match names of the form "data", "fred", "file", "temp",
or others without extensions.
.RE
.NH 2
SET parameter [value(s)...]
.sp
.RS
Set the specified parameter to the specified value.  Possible settings:
.sp
.NH 3
BELL ON (or OFF)
.sp
.RS
When \fIDUMB\fR terminal emulation is in effect, a simple noise generator
is used to produce a tone like a bell each time the \fIBELL\fR character is
received.  If you don't like it, than use \fISET BELL OFF\fR to disable it.
.RE
.NH 3
BLOCK-CHECK-TYPE
.sp
.RS
The options are:
.NH 4
1 (character checksum)
.sp
.RS
Normal, default, standard 6-bit checksum.
.RE
.NH 4
2 (character checksum)
.sp
.RS
A 12-bit checksum encoded as two characters.
.RE
.NH 4
3 (character crc-ccitt)
.sp
.RS
A 16-bit CCITT-format Cyclic Redundancy Check,  encoded
as 3 characters.
.RE
.sp
The 2 and 3 character options should only be used under
conditions of extreme line noise.  Many implementations of \fIKERMIT\fR
only support the single character checksum.
.RE
.NH 3
DEBUGGING OFF (or ON)
.sp
.RS
When transmitting or receiving packets, controls whether the
packets are displayed on the local screen.
.RE
.NH 3
DEFAULT-DISK (drive number)
.sp
.RS
The default-drive value is used for received files.  The file names created
by \fIModel 4(p) KERMIT\fR will have a ':' and the default drive number
affixed to the end so that they will be forced to be saved on the selected
drive.
.RE
.NH 3
EIGHT-BIT-QUOTING ON (or OFF)
.sp
.RS
This command enables or disables 8th bit quoting.  This is useful when
a full 8 bit path is available for binary file transfers.
.RE
.NH 3
EMULATION NONE (or DUMB)
.sp
.RS
When connected as a terminal to a foreign host, \fISET EMULATION\fR controls
whether the Model 4 emulates no terminal, allowing the use
of a terminal filter, or whether a \fIDUMB\fR terminal emulation is used.
No emulation is the default.
.RE
.NH 3
ESCAPE  
.sp
.RS
Change the escape character for virtual terminal connections.
\fIModel 4(p) KERMIT\fR will prompt you for the new escape 
character, which you type in locally.
.RE
.NH 3
FILE
.RS
.NH 4
DISPOSITION KEEP (or DISCARD)
.sp
.RS
When the transfer of a file is interrupted, this tells Model 4(p) KERMIT
what to do if it receives only a partial file.  If FILE-DISPOSITION is
DISCARD, then any partial file is removed.  Otherwise, the file is left as
it is when a transfer is interrupted.
.RE
.NH 4
TYPE (ASCII or BINARY)
.sp
.RS
Tells \fIModel 4(p) KERMIT\fR how to deal with the file being
sent/received. It is \fIIMPORTANT\fR to tell KERMIT if the file
is in \fIASCII\fR when sending to a \fINON Model 4(p) KERMIT\fR.
The action taken with this value is as follows.  If \fIASCII\fR mode
is set, then CR-LF pairs of characters are translated to CR on
input, and CR is translated to CR-LF on output.  When binary mode
is in effect, this translation does not occur.
.RE
.RE
.NH 3
FLOW-CONTROL XON/XOFF (or NONE)
.sp
.RS
When this feature is set to \fIXON/XOFF\fR (the default),
\fIModel 4(p) KERMIT\fR
will try its best to obey and use \fIXON\fR characters and \fIXOFF\fR
characters for all transmitions through the communications
port.  \fINONE\fR will disable all attempts at this sort of flow-
control.
.RE
.NH 3
INPUT
.RS
.NH 4
CASE-IGNORE OFF (or ON)
.sp
.RS
Controls whether of not case matching is done on
characters during the input command. In most
instances, you will want this \fION\fR.
.RE
.NH 4
DISPLAY OFF (or ON)
.sp
.RS
Controls the display of characters that are input
during the execution of the \fIINPUT\fR command.
.RE
.RE
.NH 3
KEY <key value> string
.sp
.RS
This command allows you to send an arbitrary (the length of the
\fIKERMIT\fR command line is the limit)
string with a single key stroke.  The definition of string is identical
for that of the \fIINPUT\fR, \fIOUTPUT\fR, and \fIPAUSE\fR commands. 
KEY VALUE is the ASCII value of the key stroke as given in the TRSDOS
manual.  If KEY VALUE is not given, then you will be asked to press
the key corresponding to the key that you wish to define.  All keys are valid
in \fIstring\fR except BREAK.  Pressing BREAK signals the end of the definition
string.
.RE
.NH 3
LOCAL-ECHO OFF (or ON)
.sp
.RS
When you \fICONNECT\fR to a remote host, you must set \fILOCAL-ECHO ON\fR
if the host is half duplex, \fIOFF\fR if full duplex.
.RE
.NH 3
OUTPUT
.RS
.NH 4
HOST-ECHO ON (or OFF)
.sp
.RS
When using \fIOUTPUT\fR, and communicating with a remote host,
the host commonly echoes the characters as you type.
Since \fIOUTPUT\fR effectively types characters for you, 
these characters may be echoed back.  If \fIHOST-ECHO\fR is 
\fION\fR, \fIOUTPUT\fR will wait for the echoed character to 
reappear in the input buffer before it sends the next.  
In the example for sending and receiving raw data, 
that is above, setting \fIHOST-ECHO ON\fR, will enable us 
to remove the \fIINPUT TYPE MYPROG.DAT<CR><LF>\fR command.  
Control characters are \fINOT\fR normally echoed, so this 
feature when set \fION\fR, will not wait for them.  If you
must catch the echo of a control character, then
follow the \fIOUTPUT\fR command with the appropriate \fIINPUT\fR
command.
.RE
.NH 4
DISPLAY OFF (or ON)
.sp
.RS
This parameter when on controls the display of characters
that are received when \fIHOST-ECHO\fR is \fION\fR.  Otherwise,
They are displayed based on the status of the \fILOCAL-ECHO\fR
setting.
.RE
.RE
.NH 3
PRINTER OFF (or ON)
.sp
.RS
Turns copying of \fICONNECT\fR session to printer on  and
off.  With \fIFLOW-CONTROL\fR turned on, and a sending host that will
acknowledge the \fIXOFF\fR, you should have no problems using the
printer continuously.
.RE
.NH 3
RECEIVE
.RS
.NH 4
END-OF-LINE <ascii code>
.sp
.RS
Set the end of line character in packets to some other
character than \fI<CR>\fR which is the default.
.RE
.NH 4
PAD-CHAR <ascii code>
.sp
.RS
If the host you are communicating with needs one or
more padding characters before it receives actual data
during packet transfers, this character will be sent
\fIPADDING\fR times.
.RE
.NH 4
PADDING <decimal number>
.sp
.RS
The repeat count for the number of times the padding
character is transmitted.
.RE
.NH 4
QUOTE-CHARACTER <ascii code>
.sp
.RS
The character used to quote control characters.  The default is pound "#"
.RE
.NH 4
START-OF-PACKET <ascii code>
.sp
.RS
The character used to syncronize the packets that
\fIKERMIT\fR transmits.  By default \fI<SOH>\fR.
.RE
.NH 4
TIME-OUT <decimal number>
.sp
.RS
\fIModel 4(p) KERMIT\fR uses this value as the number of seconds to wait for
a response to a packet.  If no response is received within the number of
seconds given, then the packet for which the response has not been received
is retransmitted.
.RE
.NH 4
TURN-CHAR
.sp
.RS
The character used to syncronize KERMIT when used over a half duplex
line.  \fIModel 4(p) KERMIT\fR will wait for this character at the
end of a packet, and will send the SEND TURN-CHAR at the end of a packet.
.RE
.RE
.NH 3
SEND
.RS
.NH 4
END-OF-LINE <ascii code>
.sp
.RS
Set the end of line character in packets to some other
character than \fI<CR>\fR which is the default.
.RE
.NH 4
PAD-CHAR <ascii code>
.sp
.RS
If the host you are communicating with needs one or
more padding characters before it receives actual data
during packet transfers, this character will be sent
\fIPADDING\fR times.
.RE
.NH 4
PADDING <decimal number>
.sp
.RS
The repeat count for the number of times the padding
character is transmitted.
.RE
.NH 4
QUOTE-CHARACTER <ascii code>
.sp
.RS
The character used to quote control characters.  The default is pound "#"
.RE
.NH 4
START-OF-PACKET <ascii code>
.sp
.RS
The character used to syncronize the packets that
\fIKERMIT\fR transmits.  By default \fI<SOH>\fR.
.RE
.NH 4
TIME-OUT <decimal number>
.sp
.RS
This value is given to the \fIother\fR host as its' timeout value.  You
should assure that this is different from the RECEIVE TIME-OUT value so
that both timeouts do not occur simultaneously.
.RE
.NH 4
TURN-CHAR
.sp
.RS
The character used to syncronize KERMIT when used over a half duplex
line.  \fIModel 4(p) KERMIT\fR will send this character at the end of a
packet.  The RECEIVE TURN-CHAR will be waited for before data is transmitted.
.RE
.RE
.NH 3
TAKE-DISPLAY OFF (or ON)
.sp
.RS
Controls the display of \fITAKE\fR files as they are executed.
By default this feature is off.
.RE
.NH 3
WARNING ON (or OFF)
.sp
.RS
Warns user if filename conflicts when receiving files from
remote host, and attempt to generate a unique name by modifying
the given one.  \fION\fR by default.
.RE
.RE
.NH 2
SETCOM
.sp
.RS
Sets/shows the status of the communications driver, \fICOM/DVR\fR.  If no
arguments are given, than the current status will be shown.  Any
arguments must be enclosed in parenthesis as the result of this
command, is a generated \fITRSDOS\fR command as in:
.RS
.sp
SETCOM (B=9600,P=N)
.RE
.sp
The default values are established according to you.  If you set up
the driver for a certain configuration, and then use \fISYSGEN\fR to save
it, then that will be the default.  \fINO\fR sysgen should give you:
.RS
.sp
300 BAUD
.br
EVEN PARITY
.br
DTR=YES
.br
7 DATA BITS
.br
1 STOP BIT
.RE
.RE
.sp
.NH 2
SHOW
.sp
.RS
Allows one or ALL of the options of the \fISET\fR command to be displayed.
Using the "?" feature will aid you if you can't figure out where to
find something.  All of the things that can be SET can be displayed.
The items not listed below can be displayed by using a command like:
.RS
.sp
SHOW BLOCK
.RE
.sp
or
.sp
.RS
SHOW DEFAULT
.RE
.sp
SHOW ALL will display all of the items that are not listed below.
.RE
.NH 3
SEND
.sp
.RS
Displays all options described under the \fISET SEND\fR command.
.RE
.NH 3
RECEIVE
.sp
.RS
Displays all options described under the \fISET RECEIVE\fR command.
.RE
.NH 3
KEY <ASCII key value>
.sp
.RS
If <ASCII key value> is specified, then the definition for the specified
key number is display.  Otherwise, a prompt is issued for the user to
type the keystroke that should be taken as the key to display.  \\nnn
is used to display all values greater than 127.  ^x where x is a
character 64 greater than 0 through 31, and 127 is used to display
control characters.  Any other printable ASCII character is displayed
normally.
.RE
.RE
.NH 2
STATUS
.sp
.RS
Shows certain information about the status of \fIModel 4(p) KERMIT\fR.  Items
currently displayed include the amount of space left in the \fIKEY\fR definition
table, the number of bytes written to files during transfers, the number
of bytes read from files during transfers, as well as statistics on the
latest transfer.
.RE
.NH 2
TAKE filespec
.sp
.RS
TAKE allows commands to be stored in a file, and then executed by
the \fIKERMIT\fR command interpreter.  Only \fIone\fR level of \fITAKE\fR
files is
supported.  This means that a \fITAKE\fR command can not appear inside of
a \fITAKE\fR file.  No checking is done to enforce this, so good luck if you
want to try it.  When \fIKERMIT\fR is first entered, a check is made for
a file called \fIKERMIT/INI\fR on all of the active disk drives as per
normal \fITRSDOS\fR searching order.  If it is found, than it is used as
a \fITAKE\fR file where you can store initialization commands.  Pressing the
\fIBREAK\fR key, or the \fIENTER\fR key during the startup of KERMIT (before the
TAKE file is opened) will cause \fIKERMIT\fR to skip
processing of the \fITAKE\fR file.
.RE
.sp 3
.NH
Installation
.PP
To install \fIModel 4(p) KERMIT\fR, you must obtain the two
files \fIM4BOO.BAS\fR and \fIM4MIT.HEX\fR.  Because of the size of the
executable, the hex file could not be placed into a basic program as data
statements.  Instead, the basic program
opens and reads the file \fIM4MIT.HEX\fR.  This file is an \fIASCII\fR image of
the executable.  All that needs to be done, is to run the \fIBASIC\fR program
which will convert the file back to its original binary format.
The resulting executable should be called \fIKERMIT/CMD\fR.
Follow the prompts of the BASIC program and there should not be any problems.
.NH
Building \fIModel 4(p) KERMIT\fR from the Source.
.PP
The Source for \fIModel 4(p) KERMIT\fR is in approx 15 modules.  The
names of the modules are:
.RS
.IP M4ADD/ASM 15
Additional code for miscellaneous routines.
.IP M4CMD/ASM
Command parser.
.IP M4GET/ASM
Receive file routines + other miscellany.
.IP M4LOG/ASM
INPUT, OUTPUT, PAUSE, PULSE commands.
.IP M4MIT/ASM
Main entry and some command routines.
.IP M4PKT/ASM
New packet routines for encoding and decoding packets.
.IP M4RMT/ASM
The base of what will be the remote command.
.IP M4SEND/ASM
Send file routines.
.IP M4SET/ASM
Set options routines.
.IP M4SHOW/ASM
Show settings routines
.IP M4STR/ASM
The majority of storage, prompts, and messages.
.IP M4XFER/ASM
File processing, and some packet stuff.
.IP M4WILD/ASM
Wild card file name processing
.IP M4MAC/ASM
Macros used in the program
.RE
.PP
\fIModel 4(p) KERMIT\fR was developed using the \fIEDAS\fR assembler from
Misosys.  Other macro assemblers should be able to assemble the program
with minor conversions.
\fIM4MIT/ASM\fR is the main source module. It will call the other
source files into 
the assembly (Using the *GET directive) as needed.
If any system calls need to be changed, they are 
all defined in \fIM4ADD/ASM\fR
for the most part.  All of the SVC's are coded in
\fIM4ADD/ASM\fR as subroutines that are accessed by CALL Xaaaaa, where aaaaa is
the name of the \fITRSDOS\fR supervisor call (SVC) without the "@" sign.
.PP
If this version is moved to another OS, there are several things that you
should consider.  The things that come to mind are:
.sp
.RS
.IP 1. 5
Consider the format of the TRSDOS directory structure.  The wild card routines
depend on this structure for validating directory entries, and for retrieving
the file name.
.IP 2.
There are 2 places where real time counting is required.  The delay specified
in a PAUSE statement can be handled with a counter, as all other processing
is halted (except the interrupt tasks) during the pause.  Currently, the
Real Time Clock task is used to measure the appropriate delay.  The other
use of a Real Time counter occurs in the Receive packet timeout.  This must
be handled using asyncronous processes in order to be accurate.
.IP 3.
The screen swapping is done using OUT instructions to the hardware to make
the screen visible in the top of memory.  This should be OS independent.
There exist code at the beginnning and end of the segment that accesses the
screen which outputs the bytes 14, and 15 to the *DO device.  These are used
to force the cursor to be invisible before the screen is accessed, and to then
make it reappear after the screen access is completed.
.IP 4.
The interrupt driven receiver must also be delt with.  The code in the
routine SETINT, establishes the interrupt vector that the *CL driver will
call when a character received interrupt is generated.
.IP 5.
In many instances, the characters having values 16, and 17 are used to
enable, and disable reverse video respectively.  If the driver for *DO
does not recognize this convention, as the current one does, then these
characters must be handled in some manner.  I.E. either removed from the
source, or filtered from the terminal output stream.  The PRTSTR() routine
is a good place to mask these characters at, as it is the sole source of
output for strings containing these type of characters.
.RE
.sp
.PP
It should be noted that \fIKERMIT/CMD\fR loads into RAM at 6000H.  This avoids
high memory filters and drivers, and also allows use of \fITRSDOS\fR library
commands that use low memory beyond 3000H, as FORMAT, and BACKUP do.
Exclusive use is made of the *DO device for screen output from the KERMIT
program, for informational messages and the like.  During
connect mode, *SI and *SO are used as the input and output
devices to allow filters to be attached that will not effect the operation
of \fIModel 4(p) KERMIT\fR during command operations.
If you install a different driver or filter it must be compatible in
these areas.  The last memory address used by \fIModel 4(p) KERMIT\fR can
be obtained by using the command
.RS
.sp
LOCAL MEMORY
.RE
.sp
from the \fIKERMIT\fR prompt.
.NH
Performance Specifics of Model 4(p) KERMIT
.PP
The \fIModel 4(p) KERMIT\fR has been tested and proven to work properly at
19,200 BAUD with flow control on, transferring files between 2 Model 4's.
What makes the \fIModel 4(p) KERMIT\fR perform so well is
the idea of flow control, and the interrupt driven receiver.  With out these
features, I expect that 2400 baud would be the reliable limit.  Flow control
can be disabled at speeds less than or equal to ~2400 baud, but greater speeds
require that flow control be functional in order to protect the integrity of
data in the input buffer.  
.sp 3
.NH
Heath 19 Filter
.PP
The files \fIM4H191.ASM, M4H192.ASM, M4H19.MAC\fR, and \fIM4H19.EQU\fR
make up the sources for the Heath 19 terminal emulation filter for the
TRS-80 Models 4 and 4p.  The assembler used was EDAS by Misosys.
To build the filter from sources, you need the above 4 files on a
disk.  \fIM4H191.ASM\fR is the main source module, and it *GETs all the other
necessary files.
.PP
The structure of the program is pretty simple.  For single character
(non escape or multi-character) sequences, most are passed to the
filtered device via the \fI@CHNIO\fR svc.  This filter depends on the
\fITRSDOS *DO\fR driver being at the end of the chain.  Several control
characters are merely translated, and then the new values are passed
to *DO.
.PP
A multi-character escape sequence is handled by remembering the previous
characters that the filter was passed.  The previous characters are
remembered by the presence of a non-zero value in the contents
of \fISTATE\fR.  The value in \fISTATE\fR represents the address of
the code to
handle the next character, given the previous string of characters.
.PP
The filter is relocatable, but \fIMUST\fR reside below screen memory because
it accesses it directly when performing several of the advanced terminal
functions.  For this reason, it will never load \fIabove F400H\fR.
.PP
The \fISETH19\fR program is created from the sources
\fIM4H19S.ASM, M4H19.EQU,\fR and \fIM4H19.MAC\fR.  \fIM4H19S.ASM\fR
is the main source module, and will *GET the other 2 files.  
.NH
How to use the SETH19 program
.PP
The \fISETH19\fR program allows you to configure a few options
that are available to you when using the \fIH19 filter\fR.
The following options are available:
.RS
.sp
.IP REMOVE 15
Remove and reclaim if possible.
.IP DURATION
Length of BELL tone
.IP FREQUENCY
Frequency value (bigger value is lower tone) for BELL
.IP BELL
Turn audible BELL ON or OFF
.IP BLOCK
Block cursor character
.IP CURSOR
Normal cursor character
.LP
.RE
These options are specified when you invoke \fISETH19\fR, as per the usual
TRSDOS 6.x parameter list.  An example might be:
.RS
.sp
SETH19 (BLOCK=191,CURSOR=23,BEEP=ON)
.RE
.PP
The REMOVE option takes several things for granted, as it tries to
thoroughly remove the device.  It assumes that the H19 filter is
attached to the *HP device, and that this device is a filter hooked
to *SO.  Further more, it assumes that *SO is routed to *DO.
.PP
This particular set up can be used easily if the following commands
are used to set up the filter:
.RS
.sp
SET *HP H19/FLT
FILTER *SO *HP
.RE
.sp
This is assuming that you have *SO routed to *DO.  The SETH19 command
will perform these very operations if you invoke it, and the memory
module, \fI$HEATH\fR, is not in place.
.PP
The other parameters to the SETH19 command can be used to control
certain preferable options to the filter.  Setting \fIBELL\fR off causes
the filter to flash the screen when it receives an ASCII(7) character.
If BELL is set \fION\fR, then an audible bell is issued when an ASCII(7) is
received.
.PP
When BELL is ON, then the \fIDURATION,\fR and \fIFREQUENCY\fR parameters take
effect.  These 2 parameters select the length and pitch, respectively,
of the BELL tone.  The FREQUENCY value is used as a delay between
oscillations of the sound port, so the bigger the number, the lower the
tone will be.
.PP
The \fIdefault DURATION\fR is set to 20, and the FREQUENCY
is set to 125.  You can adjust them as you please.  The DURATION
is inversely proportional to the FREQUENCY, since the delay caused
by the FREQUENCY value is part of the overall DURATION of the sound.
This means that as you increase FREQUENCY, you must \fIdecrease\fR
DURATION to maintain the same length of BELL, and vice-versa.
.PP
The \fIBLOCK\fR and \fICURSOR\fR parameters are used to control
the characters that are used as the cursor by the H19 filter.
The H19 terminal has the
ability to use a visual mode cursor, or a line mode cursor.  Since
the normal visual mode cursor is usually a block cursor, the parameter
BLOCK is used to set the ASCII value of the visual mode cursor.  The
CURSOR parameter sets the normal line mode cursor.
.PP
The switch between cursors must be done by the HOST computer that is
attached to the Model 4's communications port.  There is no magic
to when the BLOCK cursor is selected, see the description of the
recognized control sequences below.
.PP
.NH
Future modifications
.PP
It should be fairly straight forward to build extra states into the
filter so that it will recognize the ANSI 3.64 sequences for the
operations the filter knows how to perform.  Full support of all
the 3.64 sequences would be a non-trivial investment in time.  The
best bet here would, be a completely new device driver, since the
overhead of going to *DO is already costly, and trying to implement
scroll regions with *DO would be a HACK at best.
If somebody wants to do the conversion, I would like to have a
copy of the result.
.NH
HEATH-19 filter capabilities
.PP
The HEATH-19 terminal supports several advanced video capabilities
that make it an ideal source for a terminal emulation package.  Below
is a list of the functions supported by the Model 4(p) H-19 emulator,
and the escape sequences that perform the operations.
.NH
Heath/Zenith-19 Control Codes
.PP
The  Heath/Zenith-19 terminal is equivalent to the DEC VT52 with extensions for
line and character insertion and deletion.  Items marked with an  asterisk  are
not currently supported by Model 4(p) H19 emulation.
.sp 2
.na
.nf
Cursor Functions
.sp
  Sequence    Mnemonic    Definition
.br
   ESC H      HCUH        Cursor Home
.br
   ESC C      HCUF        Cursor Forward
.br
   ESC D      HCUB        Cursor Backward
.br
   ESC B      HCUD        Cursor Down
.br
   ESC A      HCUU        Cursor Up
.br
   ESC I      HRI         Reverse Index
.br
  *ESC n      HCPR        Cursor Position Report
.br
   ESC j      HSCP        Save Cursor Position
.br
   ESC k      HRCP        Set Cursor to Previously Saved Position
.br
   ESC Y      HDCA        Direct Cursor Addressing, 1-based:
.br
                          31+line# 31+col# (same as VT52)
.sp 3
Erasing and Editing
.sp
  Sequence    Mnemonic    Definition
.br
   ESC E      HCD         Clear Display (Shift Erase)
.br
   ESC b      HBD         Erase Beginning of Display
.br
   ESC J      HEOP        Erase to End of Page (Erase Key)
.br
   ESC l      HEL         Erase Entire Line
.br
   ESC o      HEBL        Erase Beginning of Line
.br
   ESC K      HEOL        Erase to End of Line
.br
   ESC L      HIL         Insert Line
.br
   ESC M      HDL         Delete Line
.br
   ESC N      HDCH        Delete Character
.br
   ESC @      HEIM        Enter Insert Character Mode
.br
   ESC O      HERM        Exit Insert Character Mode
.sp 3
Configuration
.sp
  Sequence    Mnemonic    Definition
.br
  *ESC z      HRAM        Reset to Power-Up Configuration
.br
  *ESC r Bn   HMBR        Modify Baud Rate: Bn=
.br
                            A=110, B=150, C=300, D=600, E=1200,
.br
                            F=1800, G=2000, H=2400, I=3600, J=4800,
.br
                            K=7200, L=9600, M=19200
.sp 2
   ESC x Ps   HSM         Set Mode(s): Ps=
.br
  *                         1 = Enable 25th line
.br
  *                         2 = No key click
.br
  *                         3 = Hold screen mode
.br
                            4 = Block cursor
.br
                            5 = Cursor off
.br
  *                         6 = Keypad shifted
.br
  *                         7 = Alternate keypad mode
.br
                            8 = Auto line feed on CR
.br
                            9 = Auto CR on line feed
.sp 2
   ESC y Ps   HRM         Reset mode(s): Ps=
.br
  *                         1 = Disable 25th line
.br
  *                         2 = Enable key click
.br
  *                         3 = Exit hold screen mode
.br
                            4 = Underscore cursor
.br
                            5 = Cursor on
.br
  *                         6 = Keypad unshifted
.br
  *                         7 = Exit alternate keypad mode
.br
                            8 = No auto line feed
.br
                            9 = No auto CR
.sp 2
  *ESC <      HEAM        Enter ANSI Mode
.sp
Modes of Operation
.sp
  Sequence    Mnemonic    Definition
.br
  *ESC [      HEHS        Enter Hold Screen Mode
.br
  *ESC \\      HXHS        Exit Hold Screen Mode
.br
   ESC p      HERV        Enter Reverse Video Mode
.br
   ESC q      HXRV        Exit Reverse Video Mode
.br
  *ESC F      HEGM        Enter Graphics Mode
.br
  *ESC G      HXGM        Exit Graphics Mode
.br
  *ESC t      HEKS        Enter Keypad Shifted Mode
.br
  *ESC u      HXKS        Exit Keypad Shifted Mode
.br
  *ESC =      HAKM        Enter Alternate Keypad Mode
.br
  *ESC >      HXAM        Exit Alternate Keypad Mode
.sp 3
  Additional Operations
.sp
  Sequence    Mnemonic    Definition
.br
  *ESC }      HDK         Keyboard Disable
.br
  *ESC {      HEK         Keyboard Enable
.br
  *ESC v      HEWA        Wrap Around at End of Line
.br
  *ESC w      HXWA        Discard at End of Line
.br
  *ESC Z      HID         Identify as VT52 (ESC / K)
.br
  *ESC ]      HX25        Transmit 25th Line
.br
  *ESC #      HXMP        Transmit Page
.sp 3
  Enhanced Character Support
.sp
   ESC [ p1 ; ... pn m    Set Graphics Rendition
.br
   where p1, ..., pn are chosen from the following:
.br
   *0            Reset to normal character display.
.br
   *1            Display characters in high intensity.
.br
   *4            Display characters underlined.
.br
   *5            Display characters blinking.
.br
   *7            Display characters in reverse video.
.br
.fo
.ad
.sp 2
.PP
The  Heath-19  transmits  the following sequences, but
it will not respond to
them if they are received.  Model 4(p) Kermit will transmit them
only if they are programmed with SET KEY.
.sp
.nf
.na
   ESC S      HF1         Function Key #1
.br
   ESC T      HF2         Function Key #2
.br
   ESC U      HF3         Function Key #3
.br
   ESC V      HF4         Function Key #4
.br
   ESC W      HF5         Function Key #5
.br
   ESC P      HF7         Function Key #7
.br
   ESC Q      HF8         Function Key #8
.br
   ESC R      HF9         Function Key #9
.fo
.PP
My thanks to Michael Carter and Roland Stolfa for their help in testing and
debugging this implementation. 
.sp 2
.nf
Gregg Wonderly
.br
Department of Computing and Information Sciences
.br
Oklahoma State University
.sp 2
UUCP: {cbosgd, ea, ihnp4, isucs1, mcvax, uokvax}!okstate!gregg
.br
ARPA:  gregg@A.CS.OKSTATE.EDU
