;	m4term/asm
;
;	This is the connect command
;
TELNET	EQU	$
	LD	A,CMCFM		;Get a confirmation
	CALL	COMND
	JP	KERMT3		;Abort if no <ENTER> pressed
	CALL	SCRCON		;Swap in the proper screen
	LD	A,(MAXCNT)	;Select the proper buffer size
	LD	(SVMAX),A
	LD	A,80		;80 characters max are buffered
	LD	(MAXCNT),A
	LD	A,(FTIME)	;Is this the VERY FIRST connect?
	OR	A
	JR	NZ,TELE2
	LD	DE,CLRTOP	;Clear the garbage off the screen
	CALL	PRTSTR
TELE1	LD	DE,INFMS7	;Display the message
	CALL	PRTSTR
	CALL	ESCPR
	LD	DE,INFMS8
	CALL	PRTSTR
	LD	A,1		;Set the first time done flag
	LD	(FTIME),A
TELE2	LD	A,14
	CALL	CONOUT
;
;While in connect mode, at most, 256 characters may be processed
;from the input port, before the keyboard is scaned. We try not
;to scan the keyboard too much, as that will kill screen I/O.
;
CHRLUP	XOR	A		;Set the processed character count to 0
	LD	(CHCNT),A
	CALL	PRTCHR		;Do input characters
	CALL	CONCHR		;Get a keyboard character
	JP	KERMIT		;IF we return here, then abort
	JR	CHRLUP		;Loop on
;
;Look at the input buffer for a character, and return it, or
;return no input.
;
INPORT	PUSH	HL		;SAVE HL
	LD	HL,(NXTCHR)	;Get address of next input char
	LD	A,(CURCHR)	;Get the LSB of the queue start
	CP	L		;If A=L, then there is no input.
	JR	Z,INOUT		;No input, so skip out.
	LD	A,(FLOFLG)	;ARE WE DOING FLOW-CONTROL?
	OR	A
	LD	A,(HL)		;Get the character back
	JR	Z,INP11		;GO IF WE AREN'T
	DI			;Interrupts off, CRITICAL section
	LD	(SVCHAR),A	;Save the input character
	INC	L		;Delete the character
	LD	(NXTCHR),HL	;Set the new pointer
	LD	HL,INCNT	;Decrement the count
	DEC	(HL)
	EI			;INTERRUPTS BACK ON
	PUSH	BC		;SAVE C
	LD	C,(HL)		;GET A COPY OF THE COUNT
	LD	A,(XFFLG)	;CHECK IF XOFF SENT
	OR	A		;IS THE FLAG ON
	JR	Z,INP10		;GO IF NOT
	LD	A,(MAXCNT)	;CHECK IF TIME FOR XON
	SRL	A		;Divide by 2
	CP	C		;Is A >= count
	JP	M,INP10		;GO IF STILL TOO MANY LEFT
	PUSH	DE		;SAVE E FOR XON
	LD	E,XON		;GET IT
	CALL	OUTCHR		;SEND AN XON
	XOR	A		;RESET THE FLAG
	LD	(XFFLG),A	;ZERO
	POP	DE		;RESTORE DE
INP10	POP	BC		;RESTORE OLD BC
	LD	A,(SVCHAR)	;GET THE NEXT CHARACTER
INP11	CP	A		;SET Z STATUS
INOUT1	POP	HL		;RESTORE HL
	RET
INOUT	EQU	$
	XOR	A		;SAY NO CHARACTERS AVAILABLE
	LD	(INCNT),A
	INC	A		;Set NZ
	POP	HL		;RESTORE STACK
	RET
SVCHAR	DB	0		;Temp storage
;
;Input a character, and display it based on the current value
;of EMULATION.
;
PRTCHR	CALL	INPORT		;Try to get an input character.
	RET	NZ		;Return if none there
	LD	E,A		;Get the input character
	LD	A,(EMULFLAG)	;Get the emulation flag
	OR	A		;Is this no emulation?
	JP	Z,PRTCHR4	;Jump if no emulation is active
;
;Certain control characters are translated on input. In
;particular, the following mappings are in effect.
;
;8 -> 24
;10 -> 26
;13 -> 29
;
	LD	A,E		;Is this a control character?
	CP	32
	JR	NC,PRTCHR2	;Jump if not a control character
	LD	HL,TRTAB	;Get the translation table
	LD	B,0		;Make BC an offset into TRTAB
;
;If the character in the translation table is 0, then it is
;ignored. This is handy for blocking out things line cursor
;on/off, and inverse video on/off
;
	CALL	GETTRN		;Get the character into A
	OR	A		;IGNORE NULLS
	RET	Z
	CP	12		;IS IT A FORMFEED
	JP	Z,CMBLNK	;GO BLANK THE SCREEN
PRTCHR2	EQU	$
	CP	7		;Is this BELL?
	JR	NZ,PRTCHR4	;Jump if not.
	CALL	CONOUT		;VT52 and DUMB use BUILTIN Bell
	JP	PRTCHR		;Get a new character
PRTCHR4	LD	A,E		;Get the character
	CALL	LOGONE		;Maybe do logging
	LD	A,(PRTFLG)	;CHECK FOR PRINTER OUTPUT
	OR	A		;SET THE FLAGS
	CALL	NZ,PRTIT	;GO PRINT IT
	LD	A,E		;GET THE CHARACTER AND DISPLAY
	CALL	TRMOUT		;Send it to the *SO device
	LD	A,(CHCNT)	;Check max character count
	LD	B,A		;GET IT IN B
	DJNZ	PRTCHR5		;SKIP RETURN IF NOT LIMIT
	RET			;RETURN AFTER LIMIT IS UP
PRTCHR5	LD	A,B		;GET THE NEW COUNT
	LD	(CHCNT),A	;SAVE IT
	JP	PRTCHR		;LOOP ON
;
;Input a character from the keyboard.
;
CONCHR	CALL	GETKEY		;Get a keyboard character without
	JP	NZ,RSKP		;Return if not one
	LD	E,A		;Is it CONNECT escape character?
	LD	A,(ESCCHR)
	CP	E
	JP	Z,INTCHR	;Go process the next key pressed
CONCHR2	CP	128		;BREAK?
	JR	NZ,CONCHR3
	CALL	DOBRK		;Generate real BREAK
	JP	RSKP
CONCHR3	LD	A,E
CONCHR4	PUSH	DE		;SAVE DE
	CALL	PRTOUT		;SEND IT TO THE PORT
	POP	DE
	LD	A,(ECOFLG)	;CHECK FOR LOCAL ECHO
	OR	A
	LD	A,E
	CALL	NZ,TRMOUT	;Echo out terminal device
	JP	RSKP		;RETURN TO THE CALLER SAY OK
;
;	This is the code to process the escape sequences during the
;	CONNECT command that do things like return to the KERMIT
;	prompt, send a break, turn logging on and off, etc...
;
INTCHR	CALL	GETKEY		;Get a character from translator
	JR	NZ,INTCHR	;Loop until we get one
	LD	B,A		;Put the real character into B
	AND	137O		;Convert A to upper case
	CP	'C'		;Is it close?
	JR	NZ,INTCHR0	;No, try other
	CALL	SCRCMD		;Swap KERMIT screen in
	LD	A,(SVMAX)	;Restore the old max
	LD	(MAXCNT),A
	RET			;Return to KERMIT
INTCHR0	CP	'S'		;Is it status?
	JR	NZ,INCH01	;No, try next
	CALL	STAT01		;Print out status
	JP	RSKP		;Return no error
INCH01	LD	A,B		;Get the real value
	CP	'?'		;Is it HELP
	JR	NZ,INTCH1	;No, try next
	LD	DE,INTHLP	;Get Help message
	CALL	PRTSTR		;Print message
	JR	INTCHR		;Get another key
INTCH1	AND	137O		;Convert back to uppercase
	CP	'B'		;Is it send BREAK?
	JR	NZ,INTCH2	;No, try the next
	CALL	DOBRK		;Send BREAK out port
	JP	RSKP		;Return NO error
INTCH2	LD	A,B		;Get the real character
	CP	'0'		;Is it send NULL?
	JR	NZ,INTCH3	;No, try next
	LD	E,0		;Get a NULL
	CALL	OUTCHR		;Out the port with it
	JP	RSKP		;Return no error
INTCH3	LD	E,B		;Get the real character
	LD	A,(ESCCHR)	;Get the escape character
	CP	E		;Is this the escape character
	JR	Z,INTCHZ	;Yep, go send character and bell
	LD	A,B		;Get the real character
	AND	137O		;Upper case again
	CP	'Q'		;QUIT LOGGING?
	JR	NZ,INTCH4	;No, try the next
	LD	A,(LOGFLG)	;Get the logging flag
	CP	2		;See if we can turn logging off
	JR	NZ,INTC3A	;Nope can't turn it off
	DEC	A		;Turn logging off
	LD	(LOGFLG),A	;Set the value
	JP	RSKP		;Return no error
INTC3A	LD	A,BELL		;Get An error sound
	CALL	CONOUT		;BEEP AT THEM
	JP	RSKP		;Return no error
INTCH4	CP	'R'		;Resume logging?
	JR	NZ,INTCH5	;Nope, try next
	LD	A,(LOGFLG)	;Check logging status
	CP	1		;Must be 1 to turn logging on
	JR	NZ,INTC3A	;Not 1, so can't turn it on
	INC	A		;Turn logging on
	LD	(LOGFLG),A	;Set the value
	JP	RSKP		;Return no error
INTCH5	LD	A,E		;Get the character typed
	CALL	PRTOUT		;Send it out the port
	JP	RSKP		;Return no error
INTCHZ	CALL	OUTCHR		;Send it out the port
	LD	A,BELL		;Get a bell
	CALL	CONOUT		;Send bell to terminal
	JP	RSKP		;Return no error
;
;	Send character to printer
;
PRTIT	EQU	$
	LD	A,E		;Get the character
	PUSH	DE		;Save E for return
	CALL	XPRT		;Dos printer routine
	POP	DE		;Restore E
	RET			;Return
;
DOBRK	LD	C,1		;OPTION 1 OF @CTL
	LD	DE,(CLDCB)	;Get the *CL DCB
	CALL	XCTL		;Do @CTL to start Modem break
	DI
	LD	BC,38070	;Pause for 200ms
BRKLOOP	DEC	BC		;Decrement the count
	LD	A,B
	OR	C
	JR	NZ,BRKLOOP	;Loop until done
	EI
	LD	E,0		;Stop break with any character
	JP	OUTCHR		;Null is good
;
PRTOUT	OR	A		;Don't send NULLS
	RET	Z
	LD	E,A		;Get the character
	JP	OUTCHR		;Output it
;
LOGONE	PUSH	AF
	PUSH	DE
	LD	E,A
	LD	A,(LOGFLG)
	OR	A
	LD	A,E
	CALL	NZ,LOGIT
	POP	DE
	POP	AF
	RET
;end of file
 
