;	M4MIT/ASM
;
	ORG	6000H
;
;	Model 4(p) KERMIT by Gregg Wonderly
;	This version is a radically modified and rewritten version
;	of the original TRS-80 KERMIT done by Stan Barber.  It has
;	numerous features and capabilities beyond that version due
;	to differences in hardware between the Model 3 and 4.
;
;SYMBOLIC DEFINITIONS FOR SOME ASCII CHARACTERS
;
EOS	EQU	0	;Printed string terminator
BELL	EQU	07O	;ASCII BEL (CONTROL-G)
CTRLC	EQU	03O	;ASCII ETX (CONTROL-C)
TAB	EQU	11O	;ASCII TAB (CONTROL-I)
LF	EQU	12O	;ASCII LINE FEED (CTRL-J)
FF	EQU	14O	;ASCII FORM FEED (CTRL-L)
CR	EQU	15O	;ASCII CARRIAGE RETURN (CTRL-M)
XON	EQU	21O	;THE THE ASCII CHARACTER USED FOR XON
XOFF	EQU	23O	;THE THE ASCII CHARACTER USED FOR XOFF
ESC	EQU	33O	;ASCII ESCAPE
SUBT	EQU	32O	;ASCII SUB (CTRL-Z)
DEL	EQU	177O	;ASCII DELETE (RUBOUT)
DEFESC	EQU	31	;<CLEAR> KEY ON KEY BOARD
MAXPKT	EQU	'~'-' '+2O	;MAXIMUM SIZE OF A PACKET.
DRPSIZ	EQU	5EH	;DEFAULT RECEIVE PACKET SIZE.
DSPSIZ	EQU	20H	;DEFAULT SEND PACKET SIZE.
DSTIME	EQU	15	;DEFAULT SEND TIME OUT INTERVAL.
DRTIME	EQU	10	;DEFAULT RECEIVE TIME OUT INTERVAL.
DSPAD	EQU	00H	;DEFAULT SEND PADDING.
DRPAD	EQU	00H	;DEFAULT RECEIVE PADDING.
DSPADC	EQU	00H	;DEFAULT SEND PADDING CHAR.
DRPADC	EQU	00H	;DEFAULT RECEIVE PADDING CHAR.
DSEOL	EQU	CR	;DEFAULT SEND EOL CHAR.
DREOL	EQU	CR	;DEFAULT RECEIVE EOL CHAR.
DSQUOT	EQU	'#'	;DEFAULT SEND QUOTE CHAR.
DRQUOT	EQU	'#'	;DEFAULT RECEIVE QUOTE CHAR.
DSCHKT	EQU	'1'	;DEFAULT CHECKSUM TYPE
SOH	EQU	01H	;START OF HEADER CHAR.
CMKEY	EQU	01H	;PARSE A KEYWORD.
CMIFI	EQU	02H	;PARSE AN INPUT FILE SPEC.
CMOFI	EQU	03H	;PARSE AN OUTPUT FILE SPEC.
CMCFM	EQU	04H	;PARSE A CONFIRM.
CMTXT	EQU	05H	;PARSE TEXT.
CMNUM	EQU	06H	;PARSE ASCII DECIMAL STRING
CMIFIN	EQU	10H	;PARSE AN INPUT FILE SPEC
*GET	M4MAC
;	ENTRY POINT FOR EXECUTION
START	LD	(OLDSP),SP
	LD	SP,STACK
	CALL	XFLAGS
	LD	(FLAGS),IY	;SAVE FLAGS FOR LATER
	LD	B,1		;WE WANT LOW$
	LD	HL,0		;SELECT GET
	CALL	XHIGH		;Get the current LOW$
	JP	NZ,XEXIT	;Quit on an error
	LD	(OLDLOW),HL	;SAVE FOR EXIT LATER
	LD	HL,TOPMEM	;GET THE LOWEST ADDRESS USED
	CALL	XHIGH		;GET LOW$ IN HL
	JP	NZ,XEXIT	;QUIT IF MEMORY ERROR
	LD	E,'C'		;GET THE *CL DEVICE
	LD	D,'L'
	CALL	XGTDCB
	LD	(CLDCB),HL	;SAVE WHAT EVER WE GOT
	JR	NZ,NOCL		;JUMP ON AN ERROR FROM @GTDCB
	LD	E,'S'		;Get *SI name
	LD	D,'I'
	CALL	XGTDCB		;Try to get the DCB
	LD	(TMIDCB),HL	;Store the result
	JR	NZ,NOSI		;Skip if not found
	LD	E,'S'		;Get the *SO name
	LD	D,'O'
	CALL	XGTDCB		;Try to get the DCB
	LD	(TMODCB),HL	;Store the result
	JR	NZ,NOSO		;Jump if NOT found
	CALL	SETINT		;Set up receiver
	XOR	A		;ZERO A
	LD	(FCB),A		;SET FILE CLOSED FLAG
	CALL	CMBLNK		;CLEAR THE SCREEN
	LD	DE,INTRO	;PRINT INTRO MESSAGE
	CALL	PRTSTR
	CALL	CHKTAK		;CHECK AUTO TAKE FILE
	CALL	KERMIT		;GOTO KERMIT
	JP	EXIT1		;EXIT PROGRAM ON RETURN
NOCL	LD	DE,CFCL		;ERROR MESSAGE
PRTOOP	CALL	PRTSTR
	JP	EXIT2		;RETURN TO DOS
NOSI	LD	HL,CFSI
	JR	PRTOOP
NOSO	LD	HL,CFSO
	JR	PRTOOP
;CLEAR THE SCREEN, SAVING DE
CMBLNK	PUSH	DE
	LD	DE,CLRTOP
	CALL	PRTSTR
	POP	DE
QUIT	RET
;
;	Output a character to *DO
;
CONOUT	PUSH	DE		;SAVE THE REGS
	PUSH	BC
	PUSH	AF
	CP	BELL		;IS IT A BELL
	JR	Z,BEEPON	;GO SET UP THE COUNTER IF SO
	CALL	XDSP
CON010	POP	BC		;Use BC to get A, and not destroy flags
	LD	A,B		;Get the old A
	POP	BC
	POP	DE
	RET			;RETURN TO THE CALLER
;
;	Output a character to *SO
;
TRMOUT	PUSH	DE		;Save the regs
	PUSH	BC
	PUSH	AF
	LD	C,A		;Get the character
	LD	DE,(TMODCB)	;Get the Device DCB
	CALL	XPUT		;@PUT it to the device
	POP	BC		;Use BC to get A, and leave Flags alone
	LD	A,B		;Get A
	POP	BC
	POP	DE
	RET
;
;	Input a character from *SI
;
TRMIN	PUSH	DE
	PUSH	BC
	LD	DE,(TMIDCB)
	CALL	XGET
	POP	BC
	POP	DE
	RET
;
;	Sound a bell
;
BEEPON	LD	A,(BELFLG)	;IS THAT OPTION ON?
	OR	A
	JR	Z,CON010	;NO BELL IF IT ISN'T
	PUSH	BC		;Save counter
	LD	C,50		;Get the duration
BEEP1	LD	A,1		;Get the value to send out port
	OUT	(90H),A		;Toggle port high
	LD	B,130		;Delay
	DJNZ	$
	DEC	A		;Set A to zero
	OUT	(90H),A		;Toggle port low
	LD	B,130		;Delay
	DJNZ	$
	DEC	C		;Decrement duration
	JR	NZ,BEEP1	;Loop if not done
	POP	BC		;Restore counter
	JR	CON010		;Join return code
;
;	Print string pointed to by DE to *DO, '$' is end of string
;
PRTSTR	LD	A,(DE)		;GET A CHARACTER
	CP	EOS		;IS IT THE END?
	RET	Z		;RETURN TO CALLER IF SO
	OR	A		;THROW AWAY THE NULL CHARACTER
	CALL	NZ,CONOUT	;DISPLAY ANYTHING NON-NULL
	INC	DE		;POINT TO THE NEXT ONE
	JR	PRTSTR		;LOOP ON
;
;	Get a character from *KI
;
CONIN	PUSH	DE		;SAVE DE
	CALL	XKBD		;LOOK AT THE KEYBOARD WITHOUT WAITING
	POP	DE		;RESTORE DE
	RET			;RETURN TO THE CALLER
;
;	KERMIT COMMAND PARSER!
;	THIS IS WHERE EACH COMMAND ORIGINATES.
;
KERMIT	LD	SP,STACK	;Set the stack back
	LD	DE,FCB		;WE ALWAYS CLOSE THE OPEN FILE
	LD	A,(DE)		;GET THE FLAGS BYTE FROM THE FCB
	BIT	7,A		;WAS FILE OPEN?
	CALL	NZ,XCLOSE	;CLOSE IT IF IT WAS
	LD	DE,KERM		;WHAT PROMPT TO PRINT
	CALL	PROMPT		;DISPLAY IT, AND DO SOME INITIALIZATION
	LD	DE,COMTAB	;GET THE COMMAND TABLE
	LD	A,CMKEY		;PARSE A KEYWORD FROM COMTAB
	CALL	COMND		;GET THE USERS COMMAND
	JP	KERMT2		;ABORT ON AN ERROR
	LD	HL,KERMTB	;GET THE JUMP TABLE
	LD	C,A
	LD	B,0		;MAKE IT A 16 BIT VALUE
	ADD	HL,BC		;CALCULATE THE ADDRESS
	JP	(HL)		;GO TO THE JUMP
;
;	Jump table for primary commands
;
KERMTB	JP	REMOTE		;REMOTE
	JP	EXIT		;EXIT
	JP	TELNET		;CONNECT
	JP	LOG		;LOG
	JP	READ		;RECEIVE
	JP	SEND		;SEND
	JP	SETCOM		;SET
	JP	SHOW		;SHOW
	JP	STATUS		;STATUS
	JP	FINISH		;FINISH
	JP	LOGOUT		;LOGOUT
	JP	BYE		;BYE
	JP	DIR		;DIRECTORY
	JP	ERA		;KILL
	JP	LOCCOM		;LOCAL
	JP	SETCL		;SETCOM
	JP	TAKE		;TAKE
	JP	INPUT		;INPUT
	JP	OUTPUT		;OUTPUT
	JP	PAUSE		;PAUSE
	JP	PULSE		;PULSE
	JP	CLEARC		;CLEAR
	JP	CLSFLS		;CLOSE
;
;	The close command.  At present, only SESSION is valid
;
CLSFLS	LD	A,CMKEY		;PARSE A KEYWORD
	LD	DE,CLSTAB	;GET THE PARSE TABLE
	CALL	COMND		;GET A KEYWORD
	JP	KERMT2		;ABORT ON AN ERROR
	LD	(TEMP1),A	;SAVE THE VALUE
	LD	A,CMCFM		;GET A CONFIRM
	CALL	COMND
	JP	KERMT3		;SAY NO CONFIRMED
	LD	A,(TEMP1)	;RESTORE WHAT WE GOT
	LD	C,A
	IFNZ	CLSF10		;SKIP IF NOT
	LD	A,(LOGFLG)	;CLOSE THE SESSION LOG IF IT IS OPEN
	IFZ	CLSF07
	XOR	A		;RESET THE LOG FLAG
	LD	(LOGFLG),A	;DO IT
	LD	DE,LFCB		;GET THE FCB ADDRESS
	CALL	XCLOSE		;CLOSE THE FILE IF POSSIBLE
	CALL	NZ,XERROR	;GET AN ERROR MESSAGE IF NEEDED
	JP	KERMIT		;GO GET A NEW COMMAND
CLSF07	LD	DE,NOLOGF	;SAY LOG FILE NOT OPEN
	CALL	PRTSTR
	JP	KERMIT		;GET A NEW COMMAND
CLSF10	JP	KERMT2		;SAY UNRECOGNIZED COMMAND (NEVER HAPPENS)
;
;	CLEAR command.  Services CLEAR INPUT-PORT, and CLEAR SCREEN
;
CLEARC	LD	A,CMKEY		;GET A KEYWORD
	LD	DE,CLRTAB	;FROM THIS TABLE
	CALL	COMND
	JP	KERMT2		;SAY UNRECOGNIZED COMMAND ON AN ERROR
	LD	(TEMP1),A	;SAVE THE RETURNED VALUE
	LD	A,CMCFM
	CALL	COMND
	JP	KERMT3
	LD	A,(TEMP1)
	LD	C,A
	IFNZ	CLR010
	CALL	CLRPRT		;DO "CLEAR INPUT-PORT"
	JP	KERMIT		;GET A NEW COMMAND
CLR010	CP	3		;IS IT CLEAR SCREEN?
	JP	NZ,KERMT2	;SAY UNRECOGNIZED COMMAND IT NOT
	CALL	CMBLNK		;CLEAR THE SCREEN
	JP	KERMIT		;GET A NEW COMMAND
;
;	TAKE commands from a file.  This is basically a HACK that
;	initializes some values so the GETSTR reads from the file,
;	instead of the keyboard.
;
TAKE	LD	DE,TFCB		;WHERE TO PUT THE FILENAME
	LD	A,CMIFI		;GET A FILE NAME
	CALL	COMND		;GET USER INPUT
	JP	KERMT3		;ABORT ON AN ERROR
	LD	IY,(FLAGS)	;GET THE SYSTEM FLAGS
	SET	0,(IY+18)	;SET UP FOR NO FILE OPEN BIT
	LD	HL,TBUF		;THIS IS THE DATA BUFFER
	LD	DE,TFCB		;GET THE FILE FCB
	LD	B,0		;256 BYTE LRL
	CALL	XOPEN		;TRY TO OPEN THE FILE
	JR	NZ,TERROR	;GO REPORT AN ERROR
	LD	A,1
	LD	(TAKFLG),A	;SET THE FLAG
	JP	KERMIT
TERROR	CALL	XERROR		;PRINT THE MESSAGE
	XOR	A		;RESET THE TAKE FLAG
	LD	(TAKFLG),A
	JP	KERMIT		;GET A NEW COMMAND
;
;	SETCOM command.  We use the TRSDOS SETCOM command here, as it
;	saves lots of time and trouble.
;
SETCL	LD	A,CMTXT		;GET ARBITRARY TEXT
	LD	DE,CLBUF	;BUFFER TO PUT DATA INTO
	CALL	COMND		;GET THE INPUT
	JP	KERMT3		;ABORT ON ERROR
	CALL	NEWLIN		;NEED A NEW LINE TO PRINT ON
	LD	A,CR		;GET A TERMINATOR
	LD	(DE),A		;TERMINATE THE STRING
	LD	HL,CLBUF-7	;GET THE "SETCOM " PREFIX
	CALL	XCMNDR
	JP	KERMIT		;GET A NEW COMMAND, IGNORE ANY ERROR CODE
;
;	LOCAL command.  Use @CMNDR to execute a TRSDOS command
;
LOCCOM	LD	HL,(CMDPTR)	;GET THE ADDRESS OF THE START
SYST1	LD	A,(HL)		;GET A CHARACTER
	INC	HL		;POINT TO THE NEXT
	IFA	' ',SYST1	;Loop if just a blank
	IFA	CR,SYST2	;Do a LIB command if no text given
	IFANOT	'?',SYST4	;Go if user not asking for HELP
SYST2	PUSH	HL		;SAVE THE ADDRESS TO PASS
	POP	IY		;GET A THE ADDRESS IN AN INDEX
	LD	(IY-1),'L'	;HL GO INCREMENTED UP THERE
	LD	(IY),'I'	;SPELLING OUT LIB
	LD	(IY+1),'B'
	LD	(IY+2),CR	;ADD THE TERMINATOR
SYST4	DEC	HL		;POINT TO THE ACTUAL ADDRESS
	CALL	NEWLIN		;NEED A NEW LINE
;	LD	IY,(FLAGS)	;Get the Flags pointer
;	SET	4,(IY+2)	;Only library commands are allowed
	CALL	XCMNDR		;Do a system command
SYST5	JP	KERMIT		;IGNORE ANY ERRORS
;
;	Print AMBIGUOUS message
;
KERMT2	LD	DE,ERMES1	;ISSUE AMBIGUOUS COMMAND MESSAGE
	CALL	PRTSTR
	JP	KERMIT
;
;	Print NOT CONFIRMED message
;
KERMT3	LD	DE,ERMES3	;ISSUE NOT CONFIRMED MESSAGE
	CALL	PRTSTR
	JP	KERMIT
;
;	Output a character to *CL.  The character is in E.
;
OUTCHR	PUSH	DE		;SAVE CURRENT DE AND BC
	PUSH	BC
	LD	C,E
OUTCH0	LD	A,(XOFREC)	;CHECK TO SEE IF WE CAN TRANSMIT YET!
	IFZ	OUTCH2
OUTCH1	CALL	CONIN		;Check the break key
	IFANOT	128,OUTCH0
	XOR	A
	LD	(XOFREC),A
OUTCH2	LD	A,C
OUTCH3	LD	DE,(CLDCB)	;GET THE DCB OF THE DEVICE TO PUT TO
	CALL	XPUT		;SEND THE CHARACTER
	JR	NZ,OUTCH3	;LOOP UNTIL IT GETS SENT
OUTCH4	POP	BC		;Restore the regs
	POP	DE
	RET
;
;	Character input routine for INPKT.  We can timeout on the
;	receive by allowing the timer to place a return in the code
;	below, at the address RECALRM.  Since TRSDOS doesn't allow
;	us (neatly, without a hack) to transfer control in a task,
;	to some other code, we use the self modifying code.  This
;	may be considered dirty, but it does work.  The RET causes
;	the code to behave as though the user had pressed <ENTER> to
;	resend the latest packet.
;
INCHR	XOR	A		;Zero the accumulator
	LD	(RECALRM),A	;Clear out a previous timeout
INCHR1	CALL	CONIN		;Check keyboard first to make sure
	IFNZ	INCHR3
	CALL	INPORT		;Get a character from the buffer
	JP	Z,RSKP		;Return if we got one
RECALRM	NOP			;Modified by timeout code to be a RET
	JR	INCHR
INCHR3	CP	CR		;Check which key was pressed
	RET	Z		;RETURN IF IT WAS
INCHR4	CHKWKEY	'B'-64		;Control-B for batch
	CHKWKEY	'F'-64		;Control-F for file
	CHKWKEY	'A'-64		;Control-A for status
	CHKWKEY	'E'-64		;Control-E for send error
	CHKWKEY	'D'-64		;Debug?
	CHKWKEY	'H'-64		;Help?
	IFANOT	'C'-64,INCHR1	;Control-C for abort completely
INCHR5	ADD	A,40H		;MAKE IT PRINTABLE
	LD	(CZSEEN),A
	RET
;
;	Timer task for receiving a packet.  Called every 33.333333333
;	milliseconds.  We decrement the TIMER counter, and when it
;	goes to zero, we write a RET into the above code, and kill
;	the task so that is does not return.
;
RECTIMOUT	PUSH	HL	;Save the register used
	PUSH	AF
	LD	HL,(TIMER)	;Get the counter
	DEC	HL		;Decrement it
	LD	(TIMER),HL	;Store the new value
	LD	A,H		;Check it for zero
	OR	L
	JR	NZ,RECT1
	LD	A,0C9H		;Get a RET instruction opcode
	LD	(RECALRM),A	;Write it in
	POP	AF		;Restore the register
	POP	HL
	CALL	XKLTSK		;Remove this task, no return.
	RET
RECT1	POP	AF		;Restore the registers
	POP	HL
	RET			;Return
;
;	Exit to TRSDOS
;
EXIT	LD	A,CMCFM		;MAKE SURE THEY ARE READY TO QUIT
	CALL	COMND
	JP	KERMT3
EXIT1	LD	DE,FCB		;GET THE FILE FCB AND CLOSE IF NEEDED
	LD	A,(DE)
	BIT	7,A
	CALL	NZ,XCLOSE	;JUST IN CASE
	LD	A,(LOGFLG)	;CHECK THE LOGFLAG
	OR	A
	LD	DE,LFCB		;GET THE FILE FCB
	CALL	NZ,XCLOSE	;CLOSE IT IF NECESSARY
	LD	C,4		;INTERRUPTS OPTION OF @CTL SVC
	LD	IY,0		;RESET OUR RECEIVER
	LD	DE,(CLDCB)	;GET THE RIGHT DEVICE
	CALL	XCTL		;Use @CTL to do it
	CALL	CMBLNK		;CLEAR THE SCREEN
EXIT2	LD	HL,(OLDLOW)	;GET THE OLD HIGH MEMORY
	LD	B,1		;SET TO DEAL WITH LOW$
	CALL	XHIGH
	LD	HL,(FINDCB)	;REMOVE THE *FI, AND *FO DEVICES
	CALL	ZERO8		;SET ALL 8 BYTES TO ZERO
	LD	HL,(FOTDCB)	;DO THE SAME FOR *FO
	CALL	ZERO8
	CALL	STOPTIMER	;Stop the timer
	LD	SP,(OLDSP)	;RESTORE THE OLD STACK POINTER
	LD	HL,0		;Set OK exit
	JP	XEXIT		;TAKE SYSTEM EXIT
;
;	Zero 8 bytes pointed to by HL
;
ZERO8	LD	D,H		;PUT A COPY OF HL INTO DE
	LD	E,L
	LD	BC,7		;8 BYTES TO MOVE
	LD	(HL),0		;SET THE FIRST TO ZERO
	INC	DE		;POINT ONE AHEAD FOR THE COPY
	LDIR			;DO IT TO ALL OF THEM
	RET			;RETURN TO THE CALLER
;
;Call error prints the error packet on a new line, and sets
;	the state to ABORT.
;Call error1 prints the packet on a new line.
;Call error2 prints the error packet on the same line
;Call error3 prints the string in DE on a new line
ERROR	EQU	$
	NSTATE	'A'		;Set the state to abort
ERROR1	LD	DE,CRLF		;PRINT A CRLF.
	CALL	PRTSTR
ERROR2	LD	A,(ARGBLK+1)	;GET THE LENGTH OF THE DATA.
	LD	C,A
	LD	B,0		;PUT IT INTO BC
	LD	HL,DATA		;GET THE ADDRESS OF THE DATA.
	PUSH	HL
	LD	A,EOS		;PUT A DOLLAR SIGN AT THE END.
	CALL	PUTTRN
	POP	DE
	JP	PRTSTR
ERROR3	EQU	$
	PUSH	DE
	CALL	NEWLIN
	POP	DE
	JP	PRTSTR		;Print error message
ERRORD	OR	A		;Display system error message
	RET	Z		;IFF an error has occured
	JP	XERROR		;Do system error
FINMES	EQU	$
	CALL	PRTSTR
	JP	NEWLIN		;Get a newline and return
;
; This is the Finish Command.
;
FINISH	EQU	$
	LD	A,CMCFM
	CALL	COMND		;GET A CONFIRM.
	JP	KERMT3
	CALL	NEWLIN
	CALL	CLRPRT		;CLEAR ANY STACKED NAKS
	XOR	A		;DIDN'T GET A CONFIRM.
	LD	(NUMTRY),A	;INITITIALIZE COUNT.
	LD	A,'1'		;Set block check to single char
	LD	(CURCHK),A	;. . .
FINSH1	CALL	CHKTRYS		;Check the retry threshold
	XOR	A
	LD	(ARGBLK),A	;MAKE IT PACKET NUMBER ZERO.
	LD	A,1
	LD	(ARGBLK+1),A	;ONE PIECE OF DATA.
	LD	HL,DATA
	LD	(HL),'F'	;FINISH RUNNING KERMIT.
	LD	A,'G'		;GENERIC COMMAND PACKET.
	CALL	SPACK
	JP	FINSH1		;On fail, try again
	CALL	RPACK	 	;GET AN ACKNOWLEDGEMENT.
	JP	FINSH1		;On fail, try again
	CP	'Y'		;ACK?
	JP	Z,KERMIT	;YES, WE ARE DONE.
	CP	'E'		;IS IT AN ERROR PACKET?
	JR	NZ,FINSH2	;Check for a NAK
	CALL	ERROR1		;PRINT THE ERROR MESSAGE.
	JP	KERMIT
FINSH2	EQU	$
	CP	'N'		;Is this a NAK?
	CALL	NZ,CONOUT	;Output the packet type to term
	JR	FINSH1		;Resend the packet
;
;THIS IS THE LOGOUT COMMAND.
;
LOGOUT	EQU	$
	LD	A,CMCFM
	CALL	COMND		;GET A CONFIRM.
	JP	KERMT3
	CALL	NEWLIN
	CALL	LOGO		;SEND THE LOGOUT PACKET.
	JP	LOG111		;GO GET ANOTHER COMMAND
	JP	KERMIT		;WHETHER WE SUCCEED OR NOT.
LOGO	XOR	A
	LD	(NUMTRY),A	;INITITIALIZE COUNT.
	CALL	CLRPRT		;CLEAR ANY STACKED NAKS
	LD	A,'1'		;Block check type to single
	LD	(CURCHK),A	;. . .
LOGO1	CALL	CHKTRYS		;Check retry threshold
	XOR	A
	LD	(ARGBLK),A	;MAKE IT PACKET NUMBER ZERO.
	LD	A,1
	LD	(ARGBLK+1),A	;ONE PIECE OF DATA.
	LD	HL,DATA
	LD	(HL),'L'	;LOGOUT THE REMOTE HOST.
	LD	A,'G'		;GENERIC COMMAND PACKET.
	CALL	SPACK
	JP	LOGO3
	CALL	RPACK		;GET AN ACKNOWLEDGEMENT
	JP	LOGO1
	CP	'Y'		;ACK?
	JP	Z,RSKP		;YES, WE ARE DONE.
	CP	'E'		;IS IT AN ERROR PACKET?
	JP	Z,ERROR1	;Print the error message
LOGO2	CP	'N'
	CALL	NZ,CONOUT
	JR	LOGO1
;
LOGO3	LD	DE,ERMS19
	JP	PRTSTR		;Print it
;
;This is the BYE command
;
BYE	EQU	$
	LD	A,CMCFM
	CALL	COMND		;GET A CONFIRM.
	JP	KERMT3
	CALL	NEWLIN
	CALL	LOGO		;TELL THE MAIN FRAME TO LOGOUT.
	JP	LOG111		;IF IT FAILS, DON'T EXIT.
	JP	EXIT1		;EXIT KERMIT.
LOG111	CALL	NEWLIN		;GET A NEW LINE
	JP	KERMIT
;
;THIS IS THE LOG COMMAND.
;
LOG	EQU	$
	LD	A,(LOGFLG)	;CHECK IF WE ARE ALREADY LOGGING
	IFZ	LOGOK
	LD	DE,LOGOPN	;PRINT MESSAGE THAT LOG FILE IS OPEN
	CALL	PRTSTR
	JP	KERMIT		;RETURN TO COMMAND PARSER
LOGOK	LD	A,CMIFI		;PARSE AN INPUT FILE SPEC.
	LD	DE,LFCB
	CALL	COMND
	JP	KERMT3
	LD	A,2		;Set the logging flag
	LD	(LOGFLG),A	;WITH WRITE ENABLED
	LD	HL,LBUFF	;Get the logging buffer
	LD	DE,LFCB		;Get the log-file fcb
	LD	B,0		;Select 256 byte records
LOG1A	CALL	XINIT		;Create a new file
	JP	Z,KERMIT	;QUIT IF IT DID WORK
	CALL	XERROR		;PRINT AN ERROR
	XOR	A		;Reset the logging flag
	LD	(LOGFLG),A
	JP	KERMIT		;GET A NEW COMMAND
;
;	Get the rest of the modules
;
*GET 	M4CMD/ASM	;Command parser
*GET	M4SET/ASM	;Set command processing
*GET	M4TERM/ASM	;Terminal emulation
*GET	M4SHOW/ASM	;Show command processing
*GET	M4PKT/ASM	;Additional packet stuff
*GET	M4GET/ASM	;Receive protocol
*GET	M4SEND/ASM	;Send protocol
*GET	M4XFER/ASM	;Protocol common code
*GET	M4ADD/ASM	;TRSDOS dependent stuff
*GET	M4RMT/ASM	;Remote commands
*GET	M4KEY/ASM	;Set key code
*GET	M4LOG/ASM	;Input, Output, Pause, Pulse commands
*GET 	M4STR/ASM	;Strings and storage
TOPMEM	EQU	$+10	;A little padding
	END	START
;end of file

