;		SETH19/ASM
*GET	M4H19/EQU
*GET	M4H19/MAC
VS	EQU	15		;Offset in header for visual cursor
VE	EQU	16		;Offset in header for line mode cursor
DEF_LEN	EQU	17		;Default length of audible bell
BELLFLAG	EQU	18	;Audible or visual bell flag
DEF_FREQ	EQU	19	;Frequency value for bell tone
OLDLOW	EQU	21		;Set up address used for removing *HP
OLDHIGH	EQU	23		;Ditto
WHERE_AT	EQU	25	;High or low memory load flag (obsolete)
MEM_LINK_LSB	EQU	3	;Link to next block in high memory
MEM_LINK_MSB	EQU	2
;
;	Load in low memory to avoid user programs, and KERMIT in particular.
;
	ORG	2600H
START	EQU	$
	LD	DE,ARGBUFF+1	;Copy the arguments
	LD	BC,255		;Pick a number suffiently large
	LD	(PARMS),DE	;Save the dest for later reference
	LDIR			;Move the command line
GETH19	EQU	$
	LD	DE,H19_NAME	;Check to see if $HEATH is resident
	LD	A,@GTMOD	;Call @GTMOD
	RST	28H
	JP	NZ,NOH19	;Not there, so go put it in
	PUSH	HL		;Put the address of the header into IX
	POP	IX
	LD	DE,PARAM_TABLE	;Get the parameter table
	LD	HL,(PARMS)	;Get the command line
;
;	We look for a '(' to know whether or not to display the usage
;	message.  If we do not find one, then we give the user help.
;
LOOP1	EQU	$
	LD	A,(HL)		;See if there is anything there
	CP	13		;End of command line
	JP	Z,SHOW_USAGE	;If so, then give help
	CP	'('		;Start of argument list?
	JR	Z,LOOP2		;Jump if it is
	INC	HL		;Point to next
	JR	LOOP1		;Loop on
LOOP2	EQU	$
	DEC	HL		;Back up before the '('
	LD	A,@PARAM	;Parse the parameter list
	RST	28H
	JP	NZ,SHOW_USAGE	;On failure, give help
	LD	A,(RESP_VS)	;Was a BLOCK cursor value given?
	OR	A
	JR	Z,CHK_VE	;Jump if not
	AND	60H		;Verify only numeric.
	JP	NZ,BAD_PARAM	;Jump if not
	LD	HL,(VS_VAL)	;Get the value given
	LD	A,H		;Make sure it is only a byte
	OR	A
	JP	NZ,TOO_BIG	;Print a message if too big
	LD	A,L		;Get the byte value from L
	LD	(IX+VS),A	;Save it into the $HEATH header
CHK_VE	EQU	$
	LD	A,(RESP_VE)	;Was there a line mode cursor value?
	OR	A		;Jump if not
	JR	Z,CHK_REM
	AND	60H		;Verify it is only numeric
	JP	NZ,BAD_PARAM	;Jump if bad
	LD	HL,(VE_VAL)	;Get the value
	LD	A,H		;Make sure it is a byte value
	OR	A
	JP	NZ,TOO_BIG	;Jump if too big.
	LD	A,L		;Get the byte value from L
	LD	(IX+VE),A	;Store it
CHK_REM	EQU	$
	LD	A,(RESP_REMOVE)	;Is this a remove request?
	OR	A
	JR	Z,CHK_FREQ	;If not go check bell frequency
	AND	0A0H		;Must be boolean
	JP	NZ,BAD_PARAM
	LD	B,0		;Get the current HIGH$ value
	LD	HL,0
	LD	A,@HIGH$
	RST	28H
	LD	A,(IX+OLDHIGH)	;Get the OLD HIGH$ from the header
	LD	C,A
	LD	A,(IX+OLDHIGH+1)
	LD	B,A		;See if they are still the same
	OR	A		;Reset the carry
	SBC	HL,BC		;Compute the difference
	JP	NZ,CANT_REMOVE	;If not equal, then can't remove it
	LD	A,(IX+OLDLOW)	;Get the previous HIGH$ that was
	LD	L,A		;in effect before $HEATH was installed
	LD	A,(IX+OLDLOW+1)
	LD	H,A
	LD	A,@HIGH$	;Set HIGH$ to that, and we are done
	LD	B,0		;removing the module
	RST	28H
;
;	The code here make several RASH assumptions about what devices
;	$HEATH is mated to.  It assumes that the following commands were
;	used to install the $HEATH module:
;
;	set *hp h19
;	filter *so *hp
;
;	With these in mind, it does the following commands
;
;	reset *so
;	reset *hp
;	remove *hp
;	route *so *do
;
;	This should restore the system to a reasonable state, given the fact
;	that the filter should be in by itself anyway.
;
REMOVE_FILTER	EQU	$
	LD	HL,CMD1		;Do "reset *so" command
	LD	A,@CMNDR
	RST	28H
	LD	HL,CMD2		;Do "reset *hp" command
	LD	A,@CMNDR
	RST	28H
	LD	HL,CMD3		;Do "remove *hp" command
	LD	A,@CMNDR
	RST	28H
	LD	HL,CMD4		;Do "route *so *do" command
	LD	A,@CMNDR
	RST	28H
	JR	SET_EXIT	;Nothing else is reasonable so quit
CHK_FREQ	EQU	$
	LD	A,(RESP_FREQ)	;Check for a frequency given
	OR	A
	JR	Z,CHK_DUR	;Jump if none there
	AND	60H		;Verify that it is numeric
	JP	NZ,BAD_PARAM	;Jump if not just numeric
	LD	HL,(FREQ_VAL)	;Get the value
	LD	(IX+DEF_FREQ),L	;Use all 16 bits worth
	LD	(IX+DEF_FREQ+1),H
CHK_DUR	EQU	$
	LD	A,(RESP_DURA)	;Is there a duration given?
	OR	A
	JR	Z,CHK_BELL	;Jump if there is isn't
	AND	60H		;Verify that it is numeric
	JP	NZ,BAD_PARAM	;Jump if it is not
	LD	HL,(DUR_VAL+1)	;Get the value
	LD	A,H		;Make sure there is only a byte value
	OR	A
	JP	NZ,TOO_BIG	;Jump if MSB not zero
	LD	A,L		;Get the byte value from L
	LD	(IX+DEF_LEN),A	;Save the tone length
CHK_BELL	EQU	$
	LD	A,(RESP_BELL)	;Are they setting visual/audible flag
	OR	A
	JP	Z,SET_EXIT	;Exit if not
	AND	0A0H		;Is it boolean?
	JP	NZ,BAD_PARAM	;Jump if not
	LD	A,(BELL_VAL)	;Get the value
	LD	(IX+BELLFLAG),A	;Save it
SET_EXIT	EQU	$
	LD	HL,0		;Set normal exit code
	RET			;Return, DON'T @EXIT HERE
;
SHOW_USAGE	EQU	$
	LD	HL,USAGE_STR	;Get the USAGE message
	JP	PRINT_EXIT	;Print and return error
;
CANT_REMOVE	EQU	$
	LD	HL,NO_REMOVE	;Print the Can't remove message
	LD	A,@DSPLY
	RST	28H
	JP	REMOVE_FILTER	;Finish unlinking the devices
;
TOO_BIG	EQU	$
	LD	HL,TOO_BIG_STR	;Get the TOO BIG message
PRINT_EXIT	EQU	$
	SVC	@DSPLY		;Print it
	LD	HL,-1		;Get error exit code
	RET			;Return from caller
;
NOH19	EQU	$
	LD	A,(ONCE)	;Check if we have been here once before
	OR	A
	JR	NZ,NOH19MESS	;If so, then issue an error message
	INC	A		;Set the flag
	LD	(ONCE),A
	LD	HL,SETH19	;Do the "set *hp h19" command
	LD	A,@CMNDR
	RST	28H
	LD	HL,FILTER	;Do the "filter *so *hp" command
	LD	A,@CMNDR
	RST	28H
	JP	GETH19		;Try to load it again
NOH19MESS	EQU	$
	LD	HL,NOFLT_STR	;Print error message, No H19/FLT
	JR	PRINT_EXIT
;
BAD_PARAM	LD	HL,BAD_PARAM_STR;Print Bad paramter message
	JR	PRINT_EXIT
;
H19_NAME	DB	'$HEATH',0
;
NO_REMOVE	DB	'Can not reclaim used memory!',10,13
;
NOFLT_STR	DB	'Can not find H19 filter',13
;
BAD_PARAM_STR	DB	'Bad parameter value',13
;
TOO_BIG_STR	DB	'Value too large',13
;
USAGE_STR	DB	'Arguments are:',29,10
	DB	'   REMOVE     -- Remove and reclaim if possible'
	DB	29,10
	DB	'   DURATION   -- Length of BELL tone',29,10
	DB	'   FREQUENCY  -- Frequency value (bigger value'
	DB	' is lower tone) for BELL',29,10
	DB	'   BELL       -- Turn audible BELL ON or OFF'
	DB	29,10
	DB	'   BLOCK      -- Block cursor character',29,10
	DB	'   CURSOR     -- Normal cursor character',29,10,13
VE_VAL	DW	0
;
VS_VAL	DW	0
;
RM_FLAG	DW	0
;
DUR_VAL	DW	0
;
FREQ_VAL	DW	0
;
BELL_VAL	DW	0
;
CMD1	DB	'reset *so',13
CMD2	DB	'reset *hp',13
CMD3	DB	'remove *hp',13
CMD4	DB	'route *so *do',13
SETH19	DB	'set *hp h19',13
FILTER	DB	'filter *so *hp'
PARMS	DW	0
ONCE	DB	0
ARGBUFF	DB	'    '
	DS	255
;
PARAM_TABLE	EQU	$
	DB	80H
	DB	80H+5
	DB	'BLOCK'
RESP_VS	DB	0
	DW	VS_VAL
	DB	80H+6
	DB	'CURSOR'
RESP_VE	DB	0
	DW	VE_VAL
	DB	40H+6
	DB	'REMOVE'
RESP_REMOVE	DB	0
	DW	RM_FLAG
	DB	90H+9
	DB	'FREQUENCY'
RESP_FREQ	DB	0
	DW	FREQ_VAL
	DB	90H+8
	DB	'DURATION'
RESP_DURA	DB	0
	DW	DUR_VAL
	DB	40H+4
	DB	'BELL'
RESP_BELL	DB	0
	DW	BELL_VAL
TABLE_END	DB	0
	END	START
 
