;	M4GET/ASM
;	RECEIVE	COMMAND
READ	EQU	$
	CALL	NEWLIN
	LD	DE,DATA		;WHERE TO PUT THE TEXT (IF ANY.)
	LD	A,CMTXT
	CALL	COMND		;GET EITHER SOME TEXT OR A CONFIRM.
	JP	KERMT3		;DIDN'T GET ANYTHING.
	OR	A		;GET ANY CHARS?
	JR	Z,READ1		;NOPE, JUST A REGULAR SEND.
	LD	(ARGBLK+1),A	;STORE THE NUMBER OF CHARS.
	EX	DE,HL   	;GET POINTER INTO HL.
	LD	(HL),EOS	;Put in the print terminator
	CALL	INIT		;CLEAR THE LINE AND INITIALIZE BUFFERS
	LD	A,'1'		;START WITH SINGLE CHARACTER CHECKSUM
	LD	(CURCHK),A	;SAVE THE TYPE
	XOR	A		;START A PACKET ZERO.
	LD	(ARGBLK),A
	LD	A,'R'		;RECEIVE INIT PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	KERMT3		;DIE!
	JP	READ12
READ1	CALL	INIT		;Clear input line and init buffers
READ12	EQU	$
	LD	HL,0		;Reset all the flags
	LD	(NUMPKT),HL	;SET THE NUMBER OF PACKETS TO ZERO.
	LD	(NUMRTR),HL	;SET THE NUMBER OF RETRIES TO ZERO.
	LD	(KTRANS),HL
	XOR	A
	LD	(PKTNUM),A	;SET THE PACKET NUMBER TO ZERO.
	LD	(NUMTRY),A	;SET THE NUMBER OF TRIES TO ZERO.
	LD	(CZSEEN),A	;Reset the control-Z seen flag
	NSTATE	'R'
	LD	(DISFLG),A	;Set the display flag
	CALL	CONDCHR
	CALL	CLRPRT		;CLEAR OUT THE COMMUNICATIONS PORT
	STROUT	HELPMSG
	CALL	PROTO
	JP	KERMIT
;
;	This is the complete state
;
COMP	EQU	$
	LD	DE,INFMS3	;PUT IN "COMPLETE" MESSAGE.
	LD	A,(CZSEEN)
	OR	A		;...
	JR	Z,COMP1
	XOR	A		;YES, CLEAR FLAG.
	LD	(CZSEEN),A
	LD	DE,INMS13	;ISSUE "INTERRUPTED" MESSAGE.
COMP1	LD	A,(DISFLG)	;But only if we are supposed to
	OR	A
	CALL	NZ,FINMES	;PRINT COMPLETION MESSAGE
	JP	KERMIT
;
;	This is the abort state
;
SABORT	EQU	$
	LD	DE,INFMS4	;Message to print
	JR	COMP1		;Go print it conditionally
;
;	Initialize the buffers, and clear the line
;
INIT	XOR	A		;BUFFER SIZE.
	LD	(CHRCNT),A	;NUMBER OF CHARS LEFT.
	LD	HL,BUFF		;ADDR FOR BEGINNING.
	LD	(BUFPNT),HL	;STORE ADDR FOR BEGINNING.
	CALL	CLRPRT
	RET	
;	RECEIVE	ROUTINES
;	RECEIVE	INIT
RINIT	CALL	CHKTRYS		;Check retry threshold
	LD	A,'1'		;RESET BLOCK CHECK TYPE TO SINGLE CHAR
	LD	(CURCHK),A	;STORE AS CURRENT TYPE FOR INITIALIZATION
	CALL	RPACK		;GET A PACKET.
	JP	NAK		;TRASHED PACKET NAK, RETRY.
	IFANOT	'S',RINIT3	;Send initiate packet?
	LD	A,(NUMTRY)	;GET THE NUMBER OF TRIES.
	LD	(OLDTRY),A	;SAVE IT.
	XOR	A
	LD	(NUMTRY),A	;RESET THE NUMBER OF TRIES.
	LD	A,(ARGBLK)	;RETURNED PACKET NUMBER.  (SYNC THEM.)
	CALL	INCPKT		;Increment the packet number
	CALL	INCDISPKT
	LD	A,(ARGBLK+1)	;GET THE NUMBER OF ARGUMENTS RECEIVED.
	LD	HL,DATA		;GET A POINTER TO THE DATA.
	CALL	SPAR		;GET THE DATA INTO THE PROPER VARIABLES.
	LD	HL,DATA		;GET A POINTER TO OUR DATA BLOCK.
	CALL	RPAR		;SET UP THE RECEIVE PARAMETERS.
	LD	(ARGBLK+1),A	;STORE THE RETURNED NUMBER OF ARGUMENTS.
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	RECABORT		;FAILED, ABORT.
	LD	A,(INICHK)
	LD	(CURCHK),A	;FOR ALL FUTURE PACKETS
	NSTATE	'f'
	LD	A,'F'
	CALL	CONDCHR		;Display which packet
	RET	
RINIT3	IFANOT	'E',NAK_0	;Is it a NAK ?
	CALL	ERROR
	JR	RECABORT
;	THESE ARE SOME UTILITY ROUTINES.
;	RECABORT
RECABORT	LD	IX,RTRANS
	CALL	UPDTRANS
ABORT	NSTATE	'A'
	RET	
;	SNDABORT
SNDABORT	NSTATE	'A'
	LD	IX,STRANS
	CALL	UPDTRANS
	RET	
;
;	Nack a packet.
;
NAK_0	XOR	A		;Reset to first packet
	LD	(PKTNUM),A	;Set the packet number
	JR	NAK		;Join NAK code
;
NAK_RTR	CALL	UPDRTR		;Update retries
;
NAK	LD	A,(PKTNUM)	;GET THE PACKET NUMBER WE'RE WAITING FOR.
	LD	(ARGBLK),A
	XOR	A		;NO DATA.
	LD	(ARGBLK+1),A
	LD	A,'N'		;NAK THAT PACKET.
	CALL	SPACK
	JP	RECABORT		;GIVE UP.
	LD	A,'N'		;Display NAKed character
	CALL	CONDCHR
	RET			;GO AROUND AGAIN.
;
;	Update the retry count
;
UPDRTR	EQU	$
	LD	HL,(NUMRTR)
	INC	HL		;INCREMENT THE NUMBER OF RETRIES
	LD	(NUMRTR),HL
	RET	
;
;	THIS ROUTINE SETS UP THE DATA FOR INIT PACKET (EITHER THE
;	SEND_INIT OR ACK PACKET).
;
RPAR	ADDPUT	RPSIZ		;GET THE RECEIVE PACKET SIZE.
	ADDPUT	STIME		;Add send timeout
	ADDPUT	RPAD		;Add padding amount
	LD	A,(RPADCH)	;Get the pad character
	ADD	A,100O		;UNCONTROL IT.
	PUTHL	A		;Put the pad character in
	ADDPUT	REOL		;Put the end of line character
	LD	A,(RQUOTE)	;GET THE QUOTE CHAR.
	PUTHL	A
	LD	A,(EBQFLG)	;Is eighth bit quoting on?
	IFZ	RPAR1		;If not, then say no
	PUTHL	'Y'		;Say yes
	JR	RPAR2
RPAR1	PUTHL	'N'		;Say no eighth bit quoting
RPAR2	LD	A,(INICHK)	;Check type
	PUTHL	A
	LD	A,(RPTQ)	;Get the repeat quote
	PUTHL	A
	LD	A,9		;Nine pieces of data
	RET	
;
;	Tochar() A, and store indirect HL, then increment HL
;
TCHPUT	ADD	A,' '
	PUTHL	A
	RET
;
;	THIS ROUTINE READS IN ALL THE SEND_INIT PACKET INFORMATION.
;
SPAR	LD	(TEMP4),A	;Save the number of arguments
	PUSH	BC
	XOR	A
	LD	B,A
	LD	(RPTFLG),A	;Set everything to default
	CALL	CHKSPAR		;Check number of characters in packet
	LD	A,(HL)		;Get THEIR Max packet size
	SUB	20H		;Make it real
	LD	(SPSIZ),A	;Save the value
	CALL	CHKSPAR		;Check the count
	GETHL	A
	SUB	20H		;Make it real
	LD	(RTIME),A	;Send packet timeout value
	CALL	CHKSPAR		;Check the count
	GETHL	A
	SUB	20H		;Make it real
	LD	(SPAD),A	;Save the padding character
	CALL	CHKSPAR		;Check the count of characters
	GETHL	A
	ADD	A,100O		;RE-CONTROLIFY IT.
	AND	7FH		;Keep us honest
	LD	(SPADCH),A	;Save the padding character
	CALL	CHKSPAR		;Check the count
	GETHL	A
	SUB	20H		;Make it the real value
	LD	(SEOL),A	;Save the value
	CALL	CHKSPAR		;Check the count
	GETHL	A
	LD	(SQUOTE),A	;Save it
	CALL	CHKSPAR		;Check the count
	INC	HL
	LD	A,(EBQFLG)
	IFZ	SPAR7
	LD	A,(HL)
	IFA	'Y',SPAR4
	IFANOT	'N',SPAR5
	XOR	A
	JR	SPAR6
SPAR4	LD	A,'&'
SPAR5	LD	(EBQ),A
SPAR6	LD	(EBQFLG),A
SPAR7	CALL	CHKSPAR		;Check the count
	GETHL	A
	LD	C,A		;COPY VALUE
	LD	A,(CHKTYP)	;GET OUR TYPE
	IFA	C,SPAR8
	LD	A,'1'		;NO, USE SINGLE CHARACTER
SPAR8	LD	(INICHK),A
	CALL	CHKSPAR		;Check the count
	GETHL	A
	IFA	' ',SPAR10
	LD	C,A
	LD	(RPTQ),A	;Save it
	LD	(RPTFLG),A
SPAR10	EQU	$
	POP	BC
	RET			;AND RETURN
;
;	Check the count of characters left in the packet.
;
CHKSPAR	EQU	$
	LD	A,(TEMP4)
	INC	B
	CP	B
	RET	P
	POP	HL		;Remove return address
	POP	BC		;Restore original BC
	RET			;Return to caller
;
;	RECEIVE	FILE
;
RFILE	CALL	CHKTRYS		;Check retry threshold
	CALL	RPACK		;GET A PACKET.
	JP	NAK		;TRASHED PACKET NAK, RETRY.
	IFANOT	'S',RFILE2
	CALL	CHKOLD
	CALL	CHKBLKDEC
	JP	NZ,NAK_RTR	;NO, NAK AND TRY AGAIN.
	CALL	UPDRTR		;UPDATE THE RETRY COUNT.
	LD	HL,DATA		;GET A POINTER TO OUR DATA BLOCK.
	CALL	RPAR		;SET UP THE PARAMETER INFORMATION.
	LD	(ARGBLK+1),A	;SAVE THE NUMBER OF ARGUMENTS.
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	RECABORT		;FAILED, ABORT.
	LD	A,'S'
	CALL	CONDCHR
	RET	
RFILE2	IFANOT	'Z',RFILE3
	CALL	CHKOLD
	CALL	CHKBLKDEC	;Check packet number
	JP	NZ,NAK_RTR	;NO, NAK IT AND TRY AGAIN.
	CALL	UPDRTR		;UPDATE THE NUMBER OF RETRIES.
	XOR	A
	LD	(ARGBLK+1),A	;NO DATA. (THE PACKET NUM IS IN ARGBLK.)
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	RECABORT		;FAILED, ABORT.
	LD	A,'Z'
	CALL	CONDCHR
	RET	
RFILE3	IFANOT	'F',RFILE4
	CALL	CHKBLK		;Check packet count
	JP	NZ,NAK_RTR	;NO, NAK IT AND TRY AGAIN.
	CALL	INCPKT		;Increment the packet number
	CALL	INCDISPKT
	LD	A,'F'
	LD	(DISFLG),A	;Turn on non-screen mode
	CALL	CONDCHR
	STROUT	KERREC
	CALL	GOFIL		;GET A FILE TO WRITE TO.
	JP	RECABORT
	CALL	INIT		;INITIALIZE ALL THE BUFFERS.
	CALL	NUM2OLD		;Reset the retry number
	LD	(ARGBLK+1),A	;NO DATA. (THE PACKET NUM IS IN ARGBLK.)
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	RECABORT
	LD	DE,FCB
	LD	(RFIDCB),DE
	CALL	RSETPKT		;Reset the packet coding routines
	NSTATE	'd'
	LD	A,(CZSEEN)	;Check if user requested EOF or EOT
	CP	'Z'		;Was it EOF?
	RET	Z		;IF THAT WAS THE REQUEST,
;				  KEEP TELLING OTHER END
	XOR	A		;OTHERWISE, CLEAR FLAG 
;				  (CONTROL-F IS ONLY FOR ONE FILE)
	LD	(CZSEEN),A	;Reset the flag
	RET	
RFILE4	IFANOT	'B',RFILE5	;End of Transmission
	CALL	CONDCHR
	CALL	CHKBLK		;Check packet count
	JP	NZ,NAK_RTR	;NO, NAK IT AND TRY AGAIN.
	XOR	A		;NO DATA. (PACKET NUM ALREADY IN ARGBLK).
	LD	(ARGBLK+1),A
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	RECABORT
	NSTATE	'C'
	LD	IX,RTRANS	;Get the start if data area
	CALL	UPDTRANS	;Update tranmission amounts
	RET	
RFILE5	CP	'X'		;Type on tty packet?
	JP	NZ,BADERROR	;Bad packet if not
	CALL	CHKBLK		;Make sure the packet number is right
	RET	NZ		;Return if not
	CALL	SETUPDIS	;Set up to type on terminal
	CALL	PRTPKTOUT	;Print the packet contents
	CALL	NEWLIN
	CALL	NUM2OLD		;Get new retry count
	LD	(ARGBLK+1),A	;Zero length
	LD	A,'Y'		;Send an ACK
	CALL	SPACK
	JP	RECABORT		;Quit if send fails
	LD	A,(PKTNUM)	;Get the packet number
	CALL	INCPKT		;Add one
	CALL	INCDISPKT	;Increment count for display
	NSTATE	'd'
	RET			;Return to protocol
;
;	RECEIVE	DATA
;
RDATA	CALL	CHKTRYS		;Check the retry threshold
	CALL	RPACK		;GET A PACKET.
	JP	NAK		;TRASHED PACKET NAK, RETRY.
	IFANOT	'D',RDATA2	;If not data check others
RDAT11	CALL	CHKBLK		;Check packet count
	JR	Z,RDAT14	;Jump if current packet
	CALL	CHKOLD		;Check tries
	CALL	CHKBLKDEC	;Check packet count for previous again
	JP	NZ,NAK_RTR	;Was not previous, so NAK it and retry
	CALL	UPDRTR		;UPDATE THE NUMBER OF RETRIES.
	XOR	A
	LD	(NUMTRY),A	;RESET NUMBER OF TRIES.
	LD	(ARGBLK+1),A	;NO DATA. (THE PACKET NUM IS IN ARGBLK.)
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	RECABORT	;FAILED, ABORT.
	LD	A,'%'		;Say we already saw this packet
	CALL	CONDCHR
	RET			;Next packet
RDAT14	CALL	INCPKT		;Increment the packet number
	CALL	INCDISPKT
	LD	A,(NUMTRY)	;GET THE NUMBER OF TRIES.
	LD	(OLDTRY),A	;SAVE IT.
	LD	A,(ARGBLK+1)	;GET THE LENGTH OF THE DATA.
	CALL	PTCHR		;Decode the data packet
	JP	RECABORT	;Can't write to output, abort
	XOR	A
	LD	(NUMTRY),A	;RESET THE NUMBER OF TRIES.
	LD	(ARGBLK+1),A	;NO DATA (PACKET NUMBER STILL IN ARGBLK).
	LD	C,A		;ASSUME NO DATA
	LD	A,(CZSEEN)
	OR	A		;.  .  .
	JR	Z,RDAT15	;ZERO IF NOT TYPED
	LD	C,A		;GET THE TYPE OF CHARACTER TYPED
	LD	A,1		;ONE DATA CHARACTER
	LD	(ARGBLK+1),A	;SAVE THE COUNT
	LD	A,C		;GET THE POSSIBLE DATA CHARACTER
	LD	(DATA),A	;STORE IN DATA AREA
RDAT15	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	RECABORT
	LD	A,(NUMPKT)	;Time to log the progress?
	AND	3		;Only every 4 packets
	RET	NZ		;Return if not time
	LD	A,'.'		;Get the character
	CALL	CONDCHR		;Log it if not doing 'X' packet
	RET	
RDATA2	IFANOT	'F',RDATA3
	CALL	CHKOLD
	CALL	CHKBLKDEC	;Check packet count
	JP	NZ,NAK_RTR	;NO, NAK IT AND TRY AGAIN.
	CALL	UPDRTR		;UPDATE THE NUMBER OF RETRIES.
	XOR	A
	LD	(NUMTRY),A	;RESET NUMBER OF TRIES.
	LD	(ARGBLK+1),A	;NO DATA.  (THE PACKET NUM IS IN ARGBLK.)
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	RECABORT	;FAILED, ABORT.
	LD	A,'%'		;Already saw this one.
	CALL	CONDCHR
	RET	
RDATA3	IFANOT	'Z',RDATA4
	CALL	CONDCHR
	CALL	CHKBLK		;Check packet count
	JP	NZ,NAK_RTR	;NO, NAK IT AND TRY AGAIN.
	CALL	INCPKT		;Increment the packet number
	CALL	INCDISPKT
	LD	A,(ARGBLK+1)	;GET THE DATA LENGTH	
	CP	1		;HAVE ONE ITEM?
	JR	NZ,RDAT35	;IF NOT, IGNORE DATA
	LD	A,(DATA)	;YES, GET THE CHARACTER
	IFANOT	'D',RDAT36
	LD	A,(DISCARD)	;Check users preference for incompletes
	OR	A		;Is the flag set?
	JR	Z,RDAT36	;Jump if not
	CALL	CHKFCB		;Is this FCB or *SO?
	CALL	Z,XREMOVE	;Remove the file if NOT *SO
	LD	DE,RMMES	;Get the 'Discarded' message
	CALL	CONDIS		;Print it conditionally
	JR	RDAT36
RDAT35	CALL	CHKFCB		;Check for file FCB, don't close *SO
	CALL	Z,XCLOSE	;CLOSE	THE FILE
RDAT36	XOR	A
	LD	(CZSEEN),A
	CALL	NUM2OLD		;Reset the number of retries
	LD	(ARGBLK+1),A	;NO DATA. (THE PACKET NUM IS IN ARGBLK.)
	LD	A,'Y'		;ACKNOWLEDGE PACKET.
	CALL	SPACK		;SEND THE PACKET.
	JP	RECABORT
	NSTATE	'f'
	LD	IX,RTRANS	;Update transfer statistics
	CALL	UPDTRANS
	RET	
RDATA4	CP	'X'
	JP	NZ,BADERROR
	CALL	CHKBLKDEC
	RET	NZ
	XOR	A
	LD	(ARGBLK+1),A
	LD	A,'Y'
	CALL	SPACK
	JP	RECABORT
	RET
CHKBLKDEC	EQU	$
	LD	A,(PKTNUM)	;GET THE PRESENT PACKET NUMBER.
	DEC	A		;DECREMENT.
	LD	B,A
	LD	A,(ARGBLK)	;GET THE PACKET'S NUMBER
	CP	B		;IS THE PACKET'S NUMBER ONE LESS THAN NOW?
	RET
CHKBLK	EQU	$
	LD	A,(PKTNUM)	;GET THE PACKET NUMBER.
	LD	B,A
	LD	A,(ARGBLK)
	CP	B		;IS IT THE RIGHT PACKET NUMBER?
	RET
CHKOLD	EQU	$
	LD	A,(MAXTRY)	;GET THE NUMBER OF TRIES.
	LD	B,A
	LD	A,(OLDTRY)
	CP	B
	JP	M,CHKOLD1
	POP	DE
	LD	DE,ERMS10
	CALL	ERROR3		;DISPLAY ERR MSG.
	JP	RECABORT		;CHANGE THE STATE TO ABORT.
CHKOLD1	INC	A		;INCREMENT IT.
	LD	(OLDTRY),A	;SAVE THE UPDATED NUMBER OF TRIES.
	RET
SETUPDIS	EQU	$
	LD	DE,(TMODCB)
	LD	(RFIDCB),DE
	XOR	A
	LD	(DISFLG),A
	CALL	NEWLIN
	RET
CONDIS	EQU	$
	PUSH	AF
	LD	A,(DISFLG)
	OR	A
	CALL	NZ,PRTSTR
	POP	AF
	RET
PRTPKTOUT	EQU	$
	LD	HL,DATA		;Get the start of the string
	LD	A,(ARGBLK+1)	;Get the length
	OR	A
	RET	Z		;Return if no data
	LD	C,A		;Get the LSB into C
	LD	B,0		;Make BC a 16 bit offset
	ADD	HL,BC		;HL is now the address past the end
	LD	(HL),EOS	;Terminator for printing
	STROUT	DATA
	JP	NEWLIN		;Print a new line and return
;
;	update byte counters, IX MUST point to send or receive
;	counter
;
UPDTRANS	EQU	$
	LD	HL,(KTRANS)	;Calculate new total transfered
	LD	C,(IX+2)	;Get the overflow counter
	LD	B,(IX+3)
	ADD	HL,BC
	CALL	C,ADD64K	;Add 64k for overflow
	LD	A,H
	AND	3
	LD	B,A
	LD	C,L
	LD	(IX+2),C	;Store the new overflow
	LD	(IX+3),B
	LD	A,H
	AND	0FCH
	LD	L,A
	LD	H,0
	SRL	L		;Divide by 4 to align
	SRL	L
	LD	C,(IX)		;Get the total so far
	LD	B,(IX+1)
	ADD	HL,BC
	LD	(IX),L
	LD	(IX+1),H
	LD	HL,0
	LD	(KTRANS),HL
	RET
;end of file

