;	m4add/asm
;
;	Input a line from a take file
;
DOTAKE	EQU	$
	LD	HL,CMDBUF	;WHERE TO PUT THE TEXT
	LD	B,0		;CHARACTER COUNTER
	CALL	CONIN
	CP	128
	JR	Z,TAKERR
TAKLOP	LD	DE,TFCB		;FCB FOR TAKE FILE
	CALL	XGET		;Call @GET svc
	JR	NZ,TAKERR	;QUIT ON AN ERROR
	LD	(HL),A		;SAVE THE CHARACTER
	INC	HL		;POINT TO THE NEXT
	INC	B		;ADD TO CHARACTER COUNT
	CP	CR		;IS IT THE END OF A COMMAND?
	JR	Z,TAK020	;GO IF IT IS THE END
	LD	C,A
	LD	A,(TAKLOG)	;IS DISPLAY OF TAKE FILES ON?
	OR	A
	LD	A,C
	CALL	NZ,CONOUT
	JR	TAKLOP
TAK020	RET			;RETURN WITH THE STRING
TAKERR	LD	DE,TFCB		;GET READY TO CLOSE THE FILE
	CALL	XCLOSE		;Close the file
	XOR	A		;TURN THE TAKE FLAG OFF
	LD	(TAKFLG),A	;RESET IT
	LD	A,29
	CALL	CONOUT
	SCF			;SET CARRY FOR A PARSE ERROR
	RET
GETSTR	LD	A,(TAKFLG)	;ARE WE DOING A TAKE COMMAND?
	OR	A
	JP	NZ,DOTAKE	;IF SO THAN GO FILL BUFFER FROM FILE
	PUSH	HL		;SAVE HL AND DE	
	PUSH	DE		
	LD	A,B		;NUMBER OF CHARS IN BUFFER
	LD	(TEMP4),A	;SAVE THAT NUMBER FOR LATER
GET010	CALL	XKEY		;GET A CHARACTER FROM THE KEYBOARD
	JP	NZ,GETEXT	;ABORT ON A *KI ERROR
	CP	8		;IS IT A BACKSPACE?
	JR	NZ,GET030	;GO IF IT ISN'T
	LD	E,A		;SAVE THE KEY
	LD	A,B		;NUMBER OF CHARS LEFT
	OR	A
	JR	Z,GET010	;IF ZERO AT THE START SO NO BACKSPACE
	DEC	B		;ONE MORE POSSIBLE
	DEC	HL		;NEW END OF BUFFER
	LD	A,E		;CHARACTER TO PRINT
	CALL	CONOUT		;DISPLAY A BACKSPACE
	JR	GET010		;GET A NEW KEY
GET030	CP	CR		;<ENTER> PRESSED?
	JR	Z,GET040	;GO IF SO
	CP	24		;ERASE LINE (<SHIFT> BACKARROW) PRESSED
	JR	NZ,GET036	;JUMP GO IF IT ISN'T
GET035	LD	A,B		;NUMBER LEFT
	OR	A
	JR	Z,GET010	;GO GET A NEW KEY IF ALL ERASED
	LD	A,8		;BACKSPACE
	CALL	CONOUT		;PRINT IT
	DEC	B		;ONE MORE LEFT
	DEC	HL		;BACKUP IN THE BUFFER
	JR	GET035		;KEEP LOOPING
GET036	CP	ESC		;WAS THE KEY ESCAPE?
	JR	Z,GET040	;GO OF IT WAS
	CP	129		;WAS IT F1 (ALSO ESCAPE HERE)
	JR	NZ,GET038	;GO IF IT WASN'T
	LD	A,ESC		;GET AN ESCAPE
	JR	GET040		;JOIN THE CODE FOR EXIT
GET038	CP	128		;WAS IT A BREAK
	JR	Z,GET040	;GO IF IT WAS
	CP	20H		;IGNORE ALL OTHER CONTROLS
	JR	C,GET010	;GET A NEW KEY
GET040	INC	B		;ONE LESS CHARACTER LEFT
	LD	(HL),A		;PUT THE CHARACTER IN THE BUFFER
	JR	NZ,GET050	;WHEN Z IS SET, NO MORE CHARS LEFT
	DEC	B		;SAY WE STILL HAVE ONE
	JR	GET060		;MIGHT BE '?' WHICH IS IGNORED AS LAST
GET050	CP	CR		;IS THE CURRENT KEY <ENTER>?
	JR	Z,GETEXT	;FINISH UP AND EXIT
	CP	ESC		;IS IT ESCAPE?
	JR	Z,GETEXT	;FINISH UP AND EXIT
	CP	128		;IS IT BREAK
	JR	Z,GETEXT	;FINISH UP AND EXIT
	INC	HL		;ONE MORE IN THE BUFFER
	CALL	CONOUT		;PRINT WHAT WAS TYPED
GET060	CP	'?'		;WAS IT A '?' ?
	JP	NZ,GET010	;GET A NEW KEY IF NOT
	LD	A,8		;GET A BACKSPACE
	CALL	CONOUT		;PRINT IT TO REMOVE THE '?'
	DEC	HL		;POINT AT THE '?'
	PUSH	HL		;HL -> IY
	POP	IY
	LD	A,' '		;LOOK FOR A PREVIOUS SPACE
	CP	(IY-1)		;IS THERE ONE BACK THERE
	JR	Z,GETEXT	;THERE IS SO EXIT
	LD	A,B		;ARE WE AT THE START OF THE LINE
	DEC	A
;IF Z IS SET THAN THE CURSOR IS AT HOME ON THE LINE.  NO SPACE WILL
;BE ADDED IN THIS CASE.
	LD	A,' '		;PUT A SPACE ON THE DISPLAY
	CALL	NZ,CONOUT	;PRINT IT
GETEXT	LD	A,B		;GET NUMBER ON THE LINE
	DEC	A
	JR	NZ,GET110	;AT LEAST ONE CHAR ON THE LINE
	PUSH	AF		;PUT AF INTO BC
	POP	BC
	LD	A,(HL)		;WAS '?' THE TERMINATOR?
	CP	'?'
	LD	A,B		;GET THE LENGTH IN A
	JR	NZ,GET120
GET110	INC	A		;COUNT THE TERMINATOR IF IT IS '?'
GET120	LD	B,A		;SAVE THE LENGTH
	LD	A,(HL)		;GET THE TERMINATOR
	CP	ESC		;WAS IT ESC
	JR	Z,GET130	;SKIP SPECIAL CASE HERE
	SLA	A		;CHECK FOR BREAK (128 IS NEGATIVE)
	JR	C,GET130	;ALSO GIVES C STATUS LIKE @KEYIN
	SRL	A		;FIX IT BACK
	OR	10H		;MAKE CR, CHR$(29), '?' IS UNDISTURBED
	CALL	CONOUT		;PRINT THE CHARACTER
GET130	POP	DE		;RESTORE THE REGS
	POP	HL
	RET			;RETURN TO THE CALLER
	;
STDOUT	LD	A,16		;REVERSE VIDEO ON
	JP	CONOUT		;USE THE RETURN ON THE STACK
STDEND	LD	A,17		;REVERSE VIDEO OFF
	JP	CONOUT		;USE THE RETURN ON THE STACK
;ENTRY POINT FOR INTERUPT DRIVEN RECEIVE CHARACTER ROUTINE.
GETINT	JR	NZ,GTIN10	;NO CHARACTER AVAILABLE
	LD	HL,(CURCHR)	;CURRENT POS IN BUFFER
	LD	(HL),C		;CHARACTER IS IN C, STORE IT
	INC	L		;POINT TO NEXT WRITE POSITION
	LD	A,(NXTCHR)	;CHECK FOR OVERFLOW
	CP	L		;IS NEXT CHARACTER THE START OF READ
	JR	Z,GTIN10	;FORGET IT AND JUST GO IF SO
	LD	(CURCHR),HL	;SAVE ADDRESS OF NEXT STORE
	LD	A,(MAXCNT)
	LD	E,A
	LD	HL,INCNT	;Get the address of the count
	INC	(HL)		;Add one to the count
	LD	A,(HL)		;Get the count
	CP	E
	JP	C,GTIN10	;JUMP IF NOT YET
	LD	A,(FLOFLG)	;ARE WE DOING FLOW CONTROL?
	OR	A
	JR	Z,GTIN10	;GO IF NOT
	LD	A,C		;GET THE CHARACTER JUST RECEIVED
	CP	XOFF		;TIME TO STOP TRANSMITTION?
	JR	NZ,GTIN05	;GO IF NOT
	LD	(XOFREC),A	;SET THE FLAG
	JR	GTIN07		;SAVE A FEW INSTRUCTIONS IF POSSIBLE
GTIN05	CP	XON		;TIME TO START BACK UP?
	JR	NZ,GTIN07
	XOR	A
	LD	(XOFREC),A
GTIN07	LD	A,(XFFLG)	;SEE IF WE ALREADY SENT IT
	OR	A
	JR	NZ,GTIN10	;GO IF WE DID ALREADY SEND XOFF
	INC	A		;MAKE IT NON-ZERO
	LD	(XFFLG),A	;SET IT
	LD	E,XOFF		;Get an XOFF character
	CALL	OUTCHR		;SENT IT OUT
GTIN10	RET
;LOG THE CHARACTER IN THE LOG FILE
LOGIT	PUSH	AF
	LD	A,(LOGFLG)
	CP	2
	JR	NZ,LOGITO
	POP	AF		;get the character back
	PUSH	AF
	PUSH	DE		;SAVE THE REGS
	LD	DE,LFCB		;GET THE FILE FCB
LOGT1	CALL	XPUT		;@PUT SVC
	JR	Z,LOGEXT	;EXIT IF NO ERRORS
LOGT2	CALL	XERROR		;PRINT THE MESSAGE IN A
	LD	DE,LFCB		;GET THE FCB
	CALL	XCLOSE		;CLOSE THE FILE
	LD	DE,ERMS20	;PRINT A MESSAGE SAYING WE CLOSED IT
	CALL	PRTSTR
	XOR	A		;RESET THE LOG TO FILE FLAG
	LD	(LOGFLG),A	;RESET
LOGEXT	POP	DE
LOGITO	POP	AF
	RET
;SVC DEFINITIONS
XFSPEC	DOSVC	78		;@FSPEC SVC (Convert filename to TRSDOS)
XINIT	DOSVC	58		;@INIT SVC (Create a file on disk device)
XOPEN	DOSVC	59		;@OPEN SVC (Open a file)
XCLOSE	DOSVC	60		;@CLOSE SVC (Close a file)
XVER	DOSVC	73		;@VER SVC (Write with verification)
XCTL	DOSVC	5		;@CTL SVC, perform control operation
XPRT	PUSH	BC		;Send character to printer
	PUSH	AF
	LD	C,A
	LD	A,6
	JR	SVCSAV
XVDCTL	DOSVC	15		;@VDCTL SVC (Perform video operations)
XGET	DOSVC	3		;@GET SVC (Get a character from a file)
;SVC'S THAT REQUIRE THE CHARACTER PASSED IN A TO BE IN C SHOULD 
;LOOK LIKE THIS.
XPUT	PUSH	BC		;SAVE BC
	PUSH	AF		;SAVE AF
	LD	C,A
	LD	A,4		;@PUT SVC
SVCSAV	RST	28H		;CALL AN SVC
	POP	BC		;POPPING BC DOES NOT AFFECT THE FLAGS
	LD	A,B		;B HAS OLD A SO RESTORE
	POP	BC		;GET OLD BC
	RET			;RETURN TO THE CALLER
XHIGH	DOSVC	100		;@HIGH$ SVC
XLOAD	DOSVC	76		;@LOAD SVC (Load an executable)
XCHKDRV	DOSVC	33		;@CHKDRV SVC (Check if drive is ready)
XADTSK	DOSVC	29		;@ADTSK SVC (Add a task to the table)
XCKTSK	DOSVC	28		;@CKTSK SVC (Check if task slot available)
XRMTSK	DOSVC	30		;@RMTSK SVC (Remove task from table)
XKLTSK	DOSVC	32		;@KLTSK SVC (Kill current exec task)
XPAUSE	DOSVC	16		;@PAUSE SVC (Delay for count in BC)
XFLAGS	DOSVC	101		;@FLAGS SVC (Get system flags address)
XREMOVE	DOSVC	57		;@REMOV SVC (Remove opened file)
XKILL	EQU	XREMOVE
XDECHEX	DOSVC	96		;@DECHEX SVC (Convert ASCII to binary)
XHEXDEC	DOSVC	97		;@HEXDEC SVC (Convert binary to ASCII)
XKBD	DOSVC	8		;@KBD SVC (Get a keyboard char, no wait)
XKEY	DOSVC	1		;@KEY SVC (Get a keyboard char, wait)
XCMNDR	DOSVC	25		;@CMNDR SVC (Execute system command)
XMUL16	DOSVC	91		;@MUL16 SVC (Multiply 8 bit by 16 bit)
XDSP	PUSH	BC		;SAVE BC
	PUSH	AF		;SAVE AF
	LD	C,A
	LD	A,2		;@DSP SVC
	JR	SVCSAV
XGTDCB	DOSVC	82		;@GTDCB SVC (Get the DCB for given device)
XEXIT	LD	L,A		;A HAS OUR RETURN CODE
	LD	H,0		;MAKE HL THE RETURN CODE
	DOSVC	22		;Do @EXIT SVC
XERROR	PUSH	BC		;SAVE BC AND AF
	PUSH	AF
	LD	IY,(FLAGS)	;GET @FLAGS ADDRESS
	RES	6,(IY+2)		;RESET ALL SPECIAL BITS
	RES	7,(IY+2)
	RES	6,(IY+18)
	OR	0C0H		;MAKE SIMPLE MESSAGES
	LD	C,A		;C NEEDS THE ERROR NUMBER
	LD	A,CR		;NEED A NEW LINE TO PRINT MESSAGES ON
	CALL	CONOUT
	LD	A,26		;@ERROR SVC   (ISSUE A SYSTEM MESSAGE)
	JR	SVCSAV		;GO CALL IT
;
;	Set up interrupt and device information
;
SETINT  EQU	$
;
;THIS CODE SETS UP THE INTERRUPT DRIVEN RECEIVER.  IT CALLS @CTL TO
;PASS THE ADDRESS OF THE "GETINT" ROUTINE WHICH DOES THE PROCESSING.
;
	LD      IY,GETINT		;WHERE TO TRANSFER CONTROL TO
	LD      DE,(CLDCB)		;WHICH DEVICE TO GET
	LD      C,4			;CTL FUNCTION 4
	CALL	XCTL		;DO @CTL
;
;	Install *FO and *FI devices
;
	LD	DE,0		;FIND A NEW DCB
	CALL	XGTDCB
	JR	NZ,NODCB	;ABORT ON AN ERROR
	LD	(FOTDCB),HL	;POINT AT THE DCB
	PUSH	HL
	POP	IX
	LD	(IX+6),'F'	;SET UP THE FILE OUTPUT DCB
	LD	(IX+7),'O'
	LD	A,2		;SELECT @PUT CAPABILITIES ONLY
	LD	(IX),A
	LD	HL,FILOUT	;GET THE ADDRESS OF THE DRIVER
	LD	(IX+1),L	;STORE THE ADDRESS AWAY
	LD	(IX+2),H
	LD	DE,0		;FIND A NEW DCB FOR INPUT
	CALL	XGTDCB
	JR	NZ,NODCB	;ABORT ON AN ERROR
	LD	(FINDCB),HL	;POINT AT THE DCB
	PUSH	HL
	POP	IX
	LD	(IX+6),'F'	;SET UP THE FILE INPUT DCB
	LD	(IX+7),'I'
	LD	A,1		;SELECT @GET CAPABILITIES ONLY
	LD	(IX),A
	LD	HL,FILIN	;GET THE ADDRESS OF THE DRIVER
	LD	(IX+1),L	;STORE THE ADDRESS AWAY
	LD	(IX+2),H
	RET			;RETURN
NODCB	LD	DE,NONDCB
	CALL	PRTSTR
	JP	EXIT1
NEWLIN	PUSH	AF
	LD	A,CR
	CALL	CONOUT
	POP	AF
	RET
;
;	Set the default disk drive command
;
SETDSK	EQU	$
	LD	A,CMNUM		;PARSE A NUMBER
	CALL	COMND
	JP	KERMT3
	OR	A		;CHECK FOR NO NUMBER
	JP	Z,KERMT2
	LD	A,D		;CHECK FOR OVERFLOW
	OR	A
	JR	NZ,NODRV	;SAY BAD NUMBER
	LD	C,E		;GET THE ACTUAL NUMBER
	CALL	XCHKDRV		;Check the disk drive
	JR	NZ,NODRV	;GO ON AN ERROR
	LD	A,C		;GET THE BINARY BACK
	ADD	A,48		;MAKE IT AN ASCII DIGIT
	LD	(DEFDSK),A	;SAVE IT AWAY
	JP	KERMIT		;GET A NEW COMMAND
NODRV	LD	A,32		;ALWAYS SAY ILLEAGAL DRIV NUMBER
	CALL	XERROR		;PRINT THE MESSAGE
	JP	KERMIT		;GET A NEW COMMAND
;
;	Clear the buffered character from the input
;
CLRPRT	PUSH	AF
	LD	A,(NXTCHR)	;SET NEXT AND CURRENT TO SAME ADDRESS
	LD	(CURCHR),A
	XOR	A		;SET COUNT TO NONE
	LD	(INCNT),A
	LD	(XOFREC),A	;SAY NO XOFF SEEN YET.
	LD	(XFFLG),A	;HAVEN'T SENT XOFF YET EITHER.
	POP	AF
	RET
;
;	Display the directory
;
DIR	EQU	$
	LD	A,CMTXT		;GET A DRIVE NUMBER
	LD	DE,DIRBUF	;GET SOME TEXT
	CALL	COMND		;GET THE USERS INPUT
	JP	KERMT3		;DO DIR (DEFDSK) ON ERROR
	OR	A
	JR	NZ,DIR1C
DIR1B	LD	A,(DEFDSK)	;GET THE USERS DEFAULT DRIVE
	LD	(DIRBUF),A
	LD	A,CR
	LD	(DIRBUF+1),A
DIR1C	CALL	NEWLIN
	CALL	NEWLIN
	LD	IY,(FLAGS)	;CHECK FOR 6.1 OR 6.2
	LD	A,(IY+27)	;GET THE VERSION
	AND	0FH		;KEEP JUST THE X OF 6.X
	LD	HL,DO62DR
	CP	2
	JR	Z,DIR1E
	LD	HL,DO61DR
DIR1E	LD	DE,DIRCMD
	LD	BC,4
	PUSH	DE
	LDIR
	POP	HL
	CALL	XCMNDR
DIR1D	JP	ERA3		;EXIT
;
;This code makes an educated guess as to whether it is running on a
;6.1 or a 6.2 TRSDOS machine.  This is to determine if we should
;issue the DIR command for 6.1 or the CAT command for 6.2
;
DO62DR	DB	'CAT '
DO61DR	DB	'DIR '
DIRCMD	DS	4
DIRBUF	DS	256
DIRERR	CALL	XERROR		;Report an error
	JP	KERMIT		;Return to command mode
;
;	Erase a file from the system
;
ERA	EQU	$
	LD     A,CMTXT		;PARSE A FILE-SPEC
	LD     DE,MFNBUF	;INTO FCB
	CALL   COMND
	JP	KERMT3
	OR	A
	JR	Z,ERA3
	LD	HL,MFNBUF
	LD	(MFNPTR),HL
ERA2	CALL	MFNAME		;GET A NEW FILE NAME IN THE BUFFER
	JR	C,ERA3A
	LD	DE,MFREQ
	LD	B,0
	CALL	XOPEN
	JR     Z,ERA1		;FOUND IT
ERA0	CALL	XERROR		;ISSUE THE MESSAGE IN A
	JP	KERMIT		;NEW COMMAND	
ERA1	LD	DE,MFREQ
	CALL	XKILL
	JR	NZ,ERA0
	LD     DE,INMS18	;" FILE KILLED"
	CALL   PRTSTR
	JR	ERA2
ERA3A	CALL	C,NEWLIN	;ONLY IF KILLED AT LEAST ONE FILE
ERA3	JP     KERMIT
;PRINT ESCAPE CHARACTER SEQUENCE CONTROL - ?
ESCPR	LD     A,(ESCCHR)	;GET THE ESCAPE CHAR.
ESCPR1	CP     ' '		;IS IT A CONTROL CHAR?
	JP     P,ESCPR2
	PUSH	AF
	LD     DE,INMS10	;OUTPUT "CONTROL-"
	CALL   PRTSTR
	POP	AF		;GET THE CHAR BACK
	OR     100O		;DE-CONTROLIFY.
ESCPR2	CALL	CONOUT
	LD	A,20H
	CALL	CONOUT
	RET    
;
;	Swap screens between connect mode, and KERMIT command modes
;
SWAPIN	LD	A,15		;cursor off
	CALL	CONOUT		;Tell *DO to turn it off
	DI			;INTERUPTS OFF WHILE SCREEN IS SWAPPED IN
	PUSH	HL		;Save the registers
	PUSH	DE
	PUSH	BC
	LD	A,134		;Select proper port mask
	OUT	(84H),A		;SWAP THE SCREEN IN
	LD	HL,0F800H	;GET THE SCREEN AREA
	LD	DE,SWTBUF	;GET THE SWAP BUFFER
	LD	BC,1920		;GET THE BYTE COUNT
SWPIN1	PUSH	BC		;SAVE THE COUNT
	LD	C,(HL)		;GET THE SCREEN BYTE
	LD	A,(DE)		;GET THE BUFFER BYTE
	LD	(HL),A		;SWAP THE BUFFER ONTO THE SCREEN
	LD	A,C		;GET C INTO A TO ADDRESS (DE)
	LD	(DE),A		;SWAP THE SCREEN INTO THE BUFFER
	INC	HL		;POINT TO NEXT
	INC	DE		;DITTO
	POP	BC		;GET THE COUNT OF CHARACTERS LEFT
	DEC	BC
	LD	A,B		;CHECK IF ANY LEFT
	OR	C
	JR	NZ,SWPIN1
	LD	A,135		;Get the right port mask
	OUT	(84H),A		;Swap the Screen out of view
	POP	BC		;Restore the registers
	POP	DE
	POP	HL
	EI			;INTERUPTS BACK ON
	LD	A,14		;cursor back on
	CALL	CONOUT
	RET			;Return to the caller
;
;	Put connect command screen in view
;
SCRCON	EQU	$
	CALL	SWAPIN		;Swap screens
	LD	B,4		;Select get cursor position option
	CALL	XVDCTL		;SVC @VDCTL to get position
	LD	(CMDCRS),HL	;Save the cursor
	LD	HL,(CONCRS)	;Get the connect cursor postion
	LD	B,3		;Select SET cursor position
	CALL	XVDCTL		;SVC @VDCTL to set it
	LD	A,14		;Make sure that the cursor is ON
	CALL	CONOUT
	RET			;Return to caller
;
;	Swap in Kermit command screen
;
SCRCMD	EQU	$
	CALL	SWAPIN		;Swap screens
	LD	B,4		;Get the current cursor position
	CALL	XVDCTL		;SVC @VDCTL to get it
	LD	(CONCRS),HL	;Save it
	LD	HL,(CMDCRS)	;Get the Kermit command cursor position
	LD	B,3		;Set the current cursor position
	CALL	XVDCTL		;SVC @VDCTL to set it
	LD	A,14		;Make sure the cursor is on
	CALL	CONOUT
	RET			;Return
;
;*FI DEVICE DRIVER IS HERE.
;
;	Valid memory module headers are used here, but are not necessary
;	since the drivers are not in the High or Low memory chain of
;	modules.
;
FILIN	JR	INPFIL		;Jump to code
	DW	ENDIN		;End of module
	DB	4		;Module name length
	DB	'INP$'
FINDCB	DW	0		;Pointer to our DCB
	DW	0
PRECHR	DB	0		;Previous character received
INPFIL	CALL	INPORT		;Get an input character
	JR	Z,INP04		;Jump if successful
	CALL	CONIN		;Failed, read the keyboard
	OR	A		;Did we get a key?
	JR	Z,INPFIL	;Nope, check port again
	CP	128		;Was the key break?
	JR	NZ,INP03	;Nope, send it to port
	LD	A,28		;RETURN WE ARE AT END OF FILE
	OR	A		;Set NZ status
	RET			;return to caller
INP03	LD	E,A		;Get the keyboard character
	CALL	OUTCHR		;Output it to the port
	JR	INPFIL		;Read the port again
INP04	LD	C,A		;Get the input character
	LD	A,(FLOFLG)	;Are we doing flow control?
	OR	A		;Set the flags
	JR	NZ,INP05	;Jump if we are not doing XON/XOFF
	LD	A,C		;Get the character back
	CP	XON		;Check for XON
	JR	Z,INPFIL	;Ignore it if it is
	CP	XOFF		;Is it XOFF?
	JR	Z,INPFIL	;Ignore it if so
INP05	LD	A,(PRECHR)	;Get the previous character
	CP	CR		;Was it CR?
	LD	A,C		;Get the current character
	JR	NZ,INP09	;Jump if not CR
	LD	A,(FILTYPE)	;Check if should convert
	OR	A		;Is it binary mode?
	LD	A,C
	JR	NZ,INP09	;It is, so do not translate
	CP	LF		;Is the current character LF?
	LD	(PRECHR),A	;Store new previous
	JR	Z,INPFIL	;Ignore LF after CR
INP09	CP	A		;Set Z status
	RET			;Return byte to caller in A
ENDIN	EQU	$
;
;*FO DEVICE DRIVER IS HERE.
;
FILOUT	JR	FIOUT		;Jump to code
	DW	OUTEND-1	;Normal header
	DB	4
	DB	'OUT$'
FOTDCB	DW	0
	DW	0
FIOUT	LD	E,C		;Get the character to send
FIOUT1	CALL	OUTCHR		;Output it.  We will hang till output
	LD	A,C		;Get the character sent
	CP	A		;Set the Z flag
	RET			;Return the byte sent out, and Z status
OUTEND	EQU	$
;end of file
  
