;       m4show/asm
;
;THIS IS THE SHOW COMMAND.
;
SHOW    LD      A,SHLEN         ;GET THE OFFSET TO OVERWRITE WITH
        LD      (SETTAB),A      ;FIX SET TABLE FOR SHOW
        LD      (SETTAB+1),A
        LD      A,CMKEY         ;Parse a keyword
        LD      DE,SHOTAB       ;From this table
        CALL    COMND           ;Go do it
        JP      KERMT2          ;Say ambiguous if nothing matches
        IFA     KYLEN,NOCFM     ;If keyword is KEY, then special case
        IFA     FILLEN,NOCFM    ;If keyword is FILE, then special case
        LD      (TEMP1),A       ;SAVE THE JUMP OFFSET
        LD      A,CMCFM         ;Get a confirm
        CALL    COMND
        JP      KERMT3          ;SAY NOT CONFIRMED ON AN ERROR
        CALL    NEWLIN          ;Get a new line to print on
        LD      A,(TEMP1)       ;Get the keyword value
NOCFM   LD      HL,SHOJTB       ;Get the start of the jump table
        LD      C,A             ;Make BC a 16-bit copy of A
        LD      B,0
        ADD     HL,BC           ;HL IS WHERE WE GO
        LD      BC,KERMIT       ;Put a return address on the
        PUSH    BC              ;stack to simulate a call
        JP      (HL)            ;GO DO THE ROUTINE
;
;       Show command jump table.  The 2 equates embedded in this table
;       indicate functions which need furthur parsing.  These are checked
;       above, and then handled special.
;
SHOJTB  JP      ESCSTAT         ;SHOW ESCAPE
        JP      ECHSTAT         ;SHOW LOCAL ECHO
        JP      EIGSTAT         ;Eight bit quoting status
FILLEN  EQU     $-SHOJTB
        JP      FILESTAT        ;Show the file parameters
        JP      CHKSTAT         ;SHOW BLOCK-CHECK-TYPE
        JP      EMULSTAT        ;SHOW emulation status
        JP      PRTSTAT         ;SHOW PRINTER
        JP      DEBSTAT         ;SHOW DEBUGGING
        JP      DSKSTAT         ;SHOW DEFAULT DISK
        JP      BELLSTAT        ;BELL STATUS
        JP      RCVSTAT         ;SHOW RECEIVE
        JP      SENDSTAT        ;SHOW SEND
KYLEN   EQU     $-SHOJTB        ;THESE 2 LINES MUST BE TOGETHER
        JP      KYSTAT          ;SHOW A KEY TRANSLATION
        JP      FLOWSTAT        ;SHOW FLOW CONTROL
        JP      SHOINP          ;SHOW INPUT PARAMETERS
        JP      SHOOUT          ;SHOW OUTPUT PARAMETERS
        JP      TAKESTAT        ;SHOW STATUS OF TAKE DISPLAY
        JP      SHOALL          ;SHOW ALL
;
;       Show the status of several values.  This is the STATUS command
;
STATUS  LD      A,CMCFM         ;GET A CONFIRM
        CALL    COMND
        JP      KERMT3          ;QUIT ON AN ERROR
        STROUT  SPACSTR
        LD      HL,DEFTABLE+DEFTLEN-1   ;Get the end of table
        LD      BC,(TOPADDR)            ;Get the current top
        OR      A                       ;Reset carry
        SBC     HL,BC                   ;Compute difference
        CALL    NOUT                    ;Print the number
        CALL    NEWLIN
        CALL    SHOTRANS
        JP      KERMIT
;
;       Show the values of all setable values other than keystrokes.
;       There is a lot of code here to perform the 2 column output.
;
SHOALL  EQU     $
        STROUT  SENDRECV        ;Send  Receive   header
        FORMAT  BELSTR,SHSTRLEN ;Print setting of BELL
        FOFFON  BELFLG
        FORMAT  EOLST,SRSTRLEN  ;Print send/recv EOL values
        LD      HL,SEOL
        CALL    SRSTATS
        FORMAT  PNTSTR,SHSTRLEN ;Print status of printer
        FOFFON  PRTFLG
        FORMAT  RETST,SRSTRLEN  ;Print send/recv turn around values
        LD      HL,STURN
        CALL    SRSTATS
        FORMAT  BUGST,SHSTRLEN  ;Print setting of debug flag
        FOFFON  DBFLG
        FORMAT  PCHST,SRSTRLEN  ;Print send/recv padding characters
        LD      HL,SPADCH
        CALL    SRSTATS
        FORMAT  TYPEST,SHSTRLEN ;Print file-type (ASCII or BINARY)
        LD      A,(FILTYPE)
        LD      DE,ASCIIST
        IFZ     SHOA_1
        LD      DE,BINST
SHOA_1  CALL    PRTSTR
        CALL    NEWLIN
        FORMAT  QTEST,SRSTRLEN  ;Print send/recv eighth bit quotes
        LD      HL,SQUOTE
        CALL    SRSTATS
        FORMAT  LOCST,SHSTRLEN  ;Print local echo setting
        FOFFON  ECOFLG
        FORMAT  TOST,SRSTRLEN   ;Print send/recv time out values
        LD      HL,STIME
        CALL    SRSTATS
        FORMAT  ESCST,SHSTRLEN  ;Print escape character
        CALL    STDOUT
        CALL    ESCPR
        CALL    STDEND
        CALL    NEWLIN
        FORMAT  PADST,SRSTRLEN  ;Print send/recv padding amounts
        LD      HL,SPAD
        CALL    SRSTATS
        FORMAT  FILST,SHSTRLEN  ;Print file warning setting
        FOFFON  FLWFLG
        FORMAT  SOPST,SRSTRLEN  ;Print send/recv SOP characters
        LD      HL,SSOHCH
        CALL    SRSTATS
        FORMAT  FLOWST,SHSTRLEN ;Print flow control setting
        LD      A,(FLOFLG)
        LD      DE,XONSTR
        IFNZ    SHOA_2
        LD      DE,NONSTR
SHOA_2  CALL    PRTSTR
        CALL    NEWLIN
        STROUT  INPUTSTR        ;Print Input settings message
        FORMAT  DSKDEF,SHSTRLEN ;Print the default disk drive
        CALL    STDOUT
        LD      A,(DEFDSK)
        CALL    CONOUT
        CALL    STDEND
        CALL    NEWLIN
        FORMAT  IDSPST,SRSTRLEN ;Print INPUT DISPLAY setting
        LD      A,(INDSP)
        CALL    JUSONOFF
        LD      BC,0620H        ;Display 6 spaces (B is count, C is char)
        CALL    MULDIS
        CALL    DISSEP
        FORMAT  EMSTR,SHSTRLEN  ;Print setting for emulation
        LD      A,(EMULFLAG)
        LD      DE,NOESTR
        IFZ     SHOA_3
        LD      DE,DMESTR
SHOA_3  CALL    PRTSTR
        CALL    NEWLIN
        FORMAT  CSEST,SRSTRLEN  ;Print INPUT CASE-IGNORE setting
        LD      A,(CSEFLG)
        CALL    JUSONOFF
        LD      BC,0620H
        CALL    MULDIS
        CALL    DISSEP
        FORMAT  DISPST,SHSTRLEN ;Print file dispostion
        CALL    STDOUT
        LD      A,(DISCARD)
        LD      DE,DSCRDST
        IFNZ    SHOA_4
        LD      DE,KEEPST
SHOA_4  CALL    PRTSTR
        CALL    STDEND
        CALL    NEWLIN
        STROUT  OUTPUTSTR       ;Print Output settings message
        FORMAT  BCKST,SHSTRLEN  ;Print block check type
        CALL    STDOUT
        LD      A,(CHKTYP)
        CALL    CONOUT
        STROUT  BCKST1
        CALL    STDEND
        CALL    NEWLIN
        FORMAT  ODSPST,SRSTRLEN ;Print OUTPUT DISPLAY setting
        LD      A,(OTDSP)
        CALL    JUSONOFF
        LD      BC,0620H
        CALL    MULDIS
        CALL    DISSEP
        FORMAT  TAKST,SHSTRLEN  ;Print take file display setting
        FOFFON  TAKLOG
        FORMAT  HSTEST,SRSTRLEN ;Print OUTPUT HOST-ECHO setting
        LD      A,(ECHFLG)
        CALL    JUSONOFF
        LD      BC,0620H
        CALL    MULDIS
        CALL    DISSEP
        FORMAT  EIGHTSTR,SHSTRLEN ;Print eight bit quoting status
        FOFFON  EBQFLG
        CALL    NEWLIN
        JP      KERMIT          ;Get a new command
;
;       Print status of take file display
;
TAKESTAT        STROUT  TAKST
        SHOFFON TAKLOG
;
;       Print status of eighth bit quoting
;
EIGSTAT STROUT  EIGHTSTR
        SHOFFON EBQFLG
;
;       Print file disposition
;
DISPSTAT        STROUT  DISPST
        CALL    STDOUT
        LD      A,(DISCARD)
        LD      DE,DSCRDST
        IFNZ    DISP_4
        LD      DE,KEEPST
DISP_4  CALL    PRTSTR
        CALL    STDEND
        JP      NEWLIN
;
;       Show the SET INPUT parameters
;
SHOINP  CALL    NEWLIN          ;GET A NEW LINE
        STROUT  CSEST
        LD      A,(CSEFLG)
        CALL    COFFON
        CALL    NEWLIN
        STROUT  IDSPST
        SHOFFON INDSP
;
;       Print the SET OUTPUT parameters
;
SHOOUT  CALL    NEWLIN
        STROUT  HSTEST
        LD      A,(ECHFLG)
        CALL    COFFON
        CALL    NEWLIN
        STROUT  ODSPST
        LD      A,(OTDSP)
        CALL    COFFON
        JP      NEWLIN
;
;       Flow control setting
;
FLOWSTAT        STROUT  FLOWST
        LD      DE,XONSTR
        LD      A,(FLOFLG)
        OR      A
        JP      NZ,PRTSTR
        LD      DE,NONSTR
        JP      PRTSTR
;
;       Show status of all send parameters
;
SENDSTAT        LD      A,CMCFM
        CALL    COMND
        JP      KERMT3
        CALL    NEWLIN
        SHSSTAT EOLST,SEOL
        SHSSTAT RETST,STURN
        SHSSTAT PCHST,SPADCH
        SHSSTAT QTEST,SQUOTE
        SHSSTAT TOST,STIME
        SHSSTAT PADST,SPAD
        SHSSTAT SOPST,SSOHCH
        RET
;
;       Show status of all receive parameters
;
RCVSTAT LD      A,CMCFM
        CALL    COMND
        JP      KERMT3
        CALL    NEWLIN
        SHRSTAT EOLST,REOL
        SHRSTAT RETST,RTURN
        SHRSTAT PCHST,RPADCH
        SHRSTAT QTEST,RQUOTE
        SHRSTAT TOST,RTIME
        SHRSTAT PADST,RPAD
        SHRSTAT SOPST,RSOHCH
        RET
;
;       Show status of bell for KERMIT messages
;
BELLSTAT        STROUT  BELSTR
        SHOFFON BELFLG          ;Print the bell status
;
;       Show status of local echo
;
ECHSTAT STROUT  LOCST           ;Local echo is ...
        SHOFFON ECOFLG          ;Print local echo status
;
;       Show the type of emulation
;
EMULSTAT        STROUT  EMSTR   ;Emulation is ...
        LD      A,(EMULFLAG)
        OR      A
        LD      DE,NOESTR
        JP      Z,PRTSTR
        LD      DE,DMESTR
        JP      PRTSTR
;
;       Show file parameters
;
FILESTAT        LD      DE,FILETAB      ;Get the options
        LD      A,CMKEY         ;Get a keyword
        CALL    COMND           ;Parse it
        JP      KERMT2          ;Say ambiguous if error
        CALL    NEWLIN
        LD      (TEMP1),A       ;Save the value
        LD      A,CMCFM         ;Get a confirm
        CALL    COMND
        JP      KERMT3          ;Say not confirmed if it is not
        LD      A,(TEMP1)       ;Get the value back
        LD      C,A             ;Put it into BC as 16 bits
        LD      B,0
        LD      HL,SHFLJTAB     ;Get the jump table
        ADD     HL,BC           ;Get the destination
        JP      (HL)            ;Jump into the table
;
SHFLJTAB        EQU     $
        JP      DISPSTAT        ;SHOW FILE DISPOSITION
        JP      TYPESTAT        ;SHOW FILE TYPE
        JP      WARNSTAT        ;SHOW FILE WARNING
;
;       Show file-type, ASCII or BINARY
;
TYPESTAT        STROUT  TYPEST  ;File type is ...
        LD      DE,ASCIIST      ;Get ASCII type
        LD      A,(FILTYPE)     ;Check the type
        OR      A               ;Set the flags
        JP      Z,PRTSTR        ;Jump if ASCII
        LD      DE,BINST        ;Get binary type
        JP      PRTSTR          ;Print the string in rev video
;
;       Show the default disk-drive
;
DSKSTAT STROUT  DSKDEF          ;Default disk is ...
        CALL    STDOUT          ;REVERSE VIDEO ON
        LD      A,(DEFDSK)      ;GET THE CHARACTER 0-9
        CALL    CONOUT
        JP      STDEND          ;REVERSE VIDEO OFF
;
;       Show status of file warning
;
WARNSTAT        STROUT  FILST   ;File warning is ...
        SHOFFON FLWFLG          ;Show the file warning status
;
;       Show status of debug setting
;
DEBSTAT STROUT BUGST            ;Debugging is ...
        SHOFFON DBFLG           ;Show the debugging
;
;       Show status of logging to the printer.
;
PRTSTAT STROUT  PNTSTR          ;Printer is ...
        SHOFFON PRTFLG          ;Show printer status
;
;       Show block check type
;
CHKSTAT STROUT  BCKST           ;Block check type is ...
        CALL    STDOUT          ;REVERSE VIDEO ON
        LD      A,(CHKTYP)      ;GET THE TYPE (CHARACTER 1, 2, OR 3)
        CALL    CONOUT
        CALL    STDEND          ;REVERSE VIDEO OFF
        LD      DE,BCKST1       ;GET REST OF TEXT ("-CHARACTER")
        JP      PRTSTR          ;. . .
;
;       Show the escape character
;
ESCSTAT STROUT  ESCST           ;Escape character is ...
        CALL    STDOUT          ;REVERSE VIDEO ON
        CALL    ESCPR           ;PRINT THE ESCAPE CHAR.
        JP      STDEND          ;REVERSE VIDEO OFF
;
;       Pick a character up from (HL+BC)
;
GETTRN  EQU     $
        LD      C,A
        ADD     HL,BC
        LD      A,(HL)
        RET
;
;       Put a characcter at (HL+BC)
;
PUTTRN  EQU     $
        ADD     HL,BC
        LD      (HL),A
        RET
;
;       Show the mapping of a keystroke
;
KYSTAT  LD      A,CMNUM         ;GET WHICH KEY
        CALL    COMND           ;GET IT
        JP      KERMT3          ;SAY NOT CONFIRMED
        IFZ     KYST_4          ;Say ambiguous if no number given
        LD      A,D             ;CHECK FOR OVERFLOW
        IFNZ    KYST_3          ;Jump if > 255
        CALL    NEWLIN
        LD      A,E             ;Get the key number
KYST_0  EQU     $
        CALL    KEYTRANS        ;Do the translation
        OR      H               ;Check if there is one
        JR      Z,KYST_2        ;Jump if not
        CALL    NEWLIN          ;Print a new line
KYST_1  EQU     $
        LD      A,(HL)          ;Get a character
        OR      A               ;Is it a null
        RET     Z               ;Return if end of string
        CALL    VERPRT          ;Print verbose description
        INC     HL              ;Point to next
        JR      KYST_1          ;Loop until done
KYST_2  EQU     $
        LD      DE,NODEF        ;Print undefined message
        JP      PRTSTR
KYST_3  STROUT  OUTRNG          ;Print bad value message
        JP      KERMIT
KYST_4  STROUT  KEYHELP         ;Ask them to press a key
KYST_5  CALL    CONIN           ;Get the keystroke
        IFZ     KYST_5          ;If none pressed, then loop
        PUSH    AF              ;Save the key
        CALL    VERPRT          ;Print it out
        POP     AF              ;Restore key
        JR      KYST_0          ;Go process the key
;
;       Print verbose string of A.  Control characters appear as
;       ^M for <CR>, etc...
;
VERPRT  IFAGE   ' ',VER_2       ;Jump if character not a control char
VER_1   PUSH    AF              ;Save the character
        LD      A,'^'           ;Print a carrat first
        CALL    CONOUT          ;Output it
        POP     AF              ;Get the character back
        ADD     A,64            ;Uncontrolify it
        AND     127             ;Remove eighth bit for <DEL>
        JP      CONOUT          ;Output and return
VER_2   IFA     127,VER_1       ;If <DEL> then process as control char
        JP      C,CONOUT        ;If less that 127 then print it
;
;       Characters greater than 127 are printed as \nnn, where
;       nnn is the 3 digit octal number representing the value
;       of the character
;
        LD      C,A             ;Save the character
        LD      A,'\'           ;Get a leading \
        CALL    CONOUT          ;Output it
        LD      A,C             ;Get a copy of the character
        AND     0C0H            ;Save only 2 higher order bits
        RLC     A               ;Move the 2 bits into the lower
        RLC     A               ;order bits of A
        AND     3               ;Make sure nothing else is there
        ADD     A,'0'           ;Make it a printable value
        CALL    CONOUT          ;Output it
        LD      A,C             ;Get another copy
        AND     38H             ;Save bits 5-3
        SRL     A               ;Align in lower order bits of
        SRL     A               ;the accumulator
        SRL     A
        AND     07H             ;Truncate to 3 bits only
        ADD     A,'0'           ;Make it printable
        CALL    CONOUT          ;Output it
        LD      A,C             ;Get the character again
        AND     07H             ;Save lower 3 bits, 2-0
        ADD     A,'0'           ;Make it printable
        JP      CONOUT          ;Output it, and return
;
;       Right justify the string in DE, within a field as wide as
;       HL specifies.
;
LEFTPAD PUSH    DE              ;Save the strings address for printing
        CALL    STRLEN          ;Get the length in BC
        OR      A               ;Reset the carry
        SBC     HL,BC           ;Compute the difference to pad
        LD      B,L             ;Make B the count
        LD      A,L             ;Check for no padding
        IFZ     LEFTP_2         ;Jump if none needed
LEFTP_1 LD      A,' '           ;Get the pad character
        CALL    CONOUT          ;output one
        DJNZ    LEFTP_1         ;Loop until done
LEFTP_2 POP     DE              ;Restore the strings address
        JP      PRTSTR          ;Print it, and return
;
;
DISSEP  LD      DE,SEPAR
        JP      PRTSTR
;
;       Display SEND and RECEIVE status as indicated by values at
;       the address pointed to be HL, and HL+1.
;
SRSTATS EQU     $
        LD      A,(HL)          ;Get the value
        PUSH    HL              ;Save the address
        CALL    DISNUM          ;Display the value
        LD      A,' '           ;Put in an extra blank
        CALL    CONOUT
        POP     HL              ;Get the address back
        INC     HL              ;Point to receive value
        LD      A,(HL)          ;Get the value
        CALL    DISNUM          ;Display the value
        CALL    DISSEP          ;Put in the separator
        RET
;
;       Display value in A, in a 5 character field
;
DISNUM  EQU     $
        LD      DE,DECBUF       ;Get the buffer
        LD      L,A             ;Put the value into HL
        LD      H,0
        CALL    XHEXDEC         ;Convert to printable
        EX      DE,HL           ;Put ending address into HL
        LD      (HL),EOS        ;Put in a terminator
        STROUT  DECBUF          ;Output the string
        RET
;
;       Display the character in C, B times on the screen
;
MULDIS  PUSH    AF              ;Save AF, don't destroy it
MULDIS1 LD      A,C             ;Get the character to print
        CALL    CONOUT          ;Output one
        DJNZ    MULDIS1         ;Loop until all done
        POP     AF              ;Restore AF
        RET                     ;Return
;
;       Print the ON string, or the OFF string, based on the value in
;       A.
;
JUSONOFF        EQU     $
        LD      DE,OFFSTR       ;Get the default before test
        IFZ     JUSON_1         ;Jump if OFF is right
        LD      DE,ONSTR        ;Get ON, since A is non-zero
JUSON_1 LD      HL,7            ;Make the field 7 characters wide
        JP      LEFTPAD         ;Go pad it, and return from there
;
;       Print ON or OFF based on the status of A.  This is different
;       from JUSONOFF because here, we do not right justify in a
;       fixed length field.
;
COFFON  LD      DE,OFFSTR       ;START WITH OFF AS DEFAULT
        OR      A               ;SET THE FLAGS
        JP      Z,PRTSTR        ;GO PRINT OFF IF A ZERO
        LD      DE,ONSTR
        JP      PRTSTR
; end of file
